/*
 * Portions of this file Copyright 1999-2005 University of Chicago
 * Portions of this file Copyright 1999-2005 The University of Southern California.
 *
 * This file or a portion of this file is licensed under the
 * terms of the Globus Toolkit Public License, found at
 * http://www.globus.org/toolkit/download/license.html.
 * If you redistribute this file, with or without
 * modifications, you must include this notice in the file.
 */

#ifndef GLOBUS_INCLUDE_GLOBUS_OPENSSL_H
#define GLOBUS_INCLUDE_GLOBUS_OPENSSL_H

#include "globus_common.h"

/**
 * @anchor globus_openssl
 * @mainpage Globus OpenSSL activation/deactivation
 *
 * The globus_openssl library is motivated by the desire to
 * make OpenSSL thread safe. This is done by allocating a mutex pool
 * and setting relevant callback functions in the module activation
 * functions. 
 *
 * Any program that uses OpenSSL functions must include
 * "globus_openssl.h". 
 *
 * @htmlonly
 * <a href="main.html" target="_top">View documentation without frames</a><br>
 * <a href="index.html" target="_top">View documentation with frames</a><br>
 * @endhtmlonly
 */


#ifndef EXTERN_C_BEGIN
#    ifdef __cplusplus
#        define EXTERN_C_BEGIN extern "C" {
#        define EXTERN_C_END }
#    else
#        define EXTERN_C_BEGIN
#        define EXTERN_C_END
#    endif
#endif

EXTERN_C_BEGIN


/**
 * @defgroup globus_openssl_activation Activation
 *
 * Globus OpenSSL uses standard Globus module activation and
 * deactivation. Before any OpenSSL functions are called, the
 * following function must be called:
 *
 * @code
 *      globus_module_activate(GLOBUS_OPENSSL_MODULE)
 * @endcode
 *
 *
 * This function returns GLOBUS_SUCCESS if OpenSSL was
 * successfully initialized, and you are therefore allowed to
 * subsequently call OpenSSL functions.  Otherwise, an error
 * code is returned, and OpenSSL functions should not
 * subsequently be called. This function may be called multiple times.
 *
 * To deactivate the OpenSSL module , the following function must be
 * called: 
 *
 * @code
 *    globus_module_deactivate(GLOBUS_OPENSSL_MODULE)
 * @endcode
 *
 * This function should be called once for each time OpenSSL
 * was activated. 
 *
 */

/** Module descriptor
 * @ingroup globus_openssl_activation
 * @hideinitializer
 */
#define GLOBUS_OPENSSL_MODULE (&globus_i_openssl_module)

extern
globus_module_descriptor_t		globus_i_openssl_module;

EXTERN_C_END

#endif /* GLOBUS_INCLUDE_GLOBUS_OPENSSL_H */












