
#
# Portions of this file Copyright 1999-2005 University of Chicago
# Portions of this file Copyright 1999-2005 The University of Southern California
#
# This file or a portion of this file is licensed under the
# terms of the Globus Toolkit Public License, found at
# http://www.globus.org/toolkit/download/license.html.
# If you redistribute this file, with or without
# modifications, you must include this notice in the file.
#

my $gpath = $ENV{GPT_LOCATION};

if (!defined($gpath))
{
  $gpath = $ENV{GLOBUS_LOCATION};
}

if (!defined($gpath))
{
   die "GPT_LOCATION or GLOBUS_LOCATION needs to be set before running this script"
}

@INC = (@INC, "$gpath/lib/perl");

require Grid::GPT::Setup;

my $metadata = new Grid::GPT::Setup(package_name => "globus_rls_server_setup");

my $globusdir = $ENV{GLOBUS_LOCATION};

if((!defined($globusdir)))
{
    die "GLOBUS_LOCATION needs to be set before running this script"
}

my $shell = $ENV{GLOBUS_SH};
if (!defined($shell)) {
  $shell = "/bin/sh";
}

my $odbclib = "$globusdir/lib";

my $iodbc = $ENV{GLOBUS_IODBC_PATH};
if (defined($iodbc)) {
    $odbclib = "$iodbc/lib";
}
else {
    $iodbc = $ENV{GLOBUS_IODBC_LIBS};
    if (defined($iodbc)) {
        $odbclib = "$iodbc";
    }
    else {
        my $unixodbc = $ENV{GLOBUS_UNIXODBC_LIBS};
        if (defined($unixodbc)) {
            $odbclib = "$unixodbc";
        }
    }
}

my $odbcini = $ENV{ODBCINI};
if (!defined($odbcini)) {
  $odbcini = "$globusdir/var/odbc.ini";
}

# Determine sysname
my $os = lc $^O;    # Convert sysname to lower case
$os =~ tr/a-z//cd;  # Remove digits, underscore, etc. from exotic sysnames

# Determine libsuffix
my $libsuffix = "so";  # Default to Linux/SunOS suffix
if ($os eq "darwin")
{
    $libsuffix = "dylib";
}   # Handle other os cases here, as needed

# Query GPT metadata for sqliteodbc flavor
my $sqliteodbcflavor = "";
my $sqliteodbc_pkgname = "globus_database_sqliteodbc";
my $installation = new Grid::GPT::Installation(globusdir => $gpath);
my $pkgs = $installation->query(
    pkgname => $sqliteodbc_pkgname,
    pkgtype => "dev");

if (@$pkgs < 1) {
    print "WARNING: $sqliteodbc_pkgname package not found. You may need to adjust the driver settings in $gpath/var/odbc.ini\n.";
}
if (@$pkgs > 1) {
    print "WARNING: More than one $sqliteodbc_pkgname package found. You may need to adjust the driver settings in $gpath/var/odbc.ini\n.";
}
if (@$pkgs >= 1) {
    $sqliteodbcflavor = "_" . @$pkgs[0]->flavor();
}

my $setupdir = "$globusdir/setup/globus";

for my $f ("SXXrls", "globus-rls-server.conf", "rls-ldif.conf", "odbc.ini") {
  print "creating $f\n";
  open(FIN, "<$setupdir/${f}.in") || die "Can't find $setupdir/${f}.in";
  open(FOUT, ">$setupdir/${f}") || die "Can't open $setupdir/${f}.in";
  while (<FIN>) {
    s/\@GLOBUS_LOCATION\@/$globusdir/g;
    s/\@ODBCLIB\@/$odbclib/g;
    s/\@ODBCINI\@/$odbcini/g;
    s/\@SHELL\@/$shell/g;
    s/\@LIBSUFFIX\@/$libsuffix/g;
    s/\@SQLITEODBCFLAVOR\@/$sqliteodbcflavor/g;
    print FOUT;
  }
  close FIN;
  close FOUT;
}

system("cp $setupdir/SXXrls $globusdir/sbin/.");
system("chmod 0755 $globusdir/sbin/SXXrls");

if (-e "$globusdir/etc/globus-rls-server.conf") {
  print "$globusdir/etc/globus-rls-server.conf already exists, not replacing with $setupdir/globus-rls-server.conf\n";
} else {
  system("cp $setupdir/globus-rls-server.conf $globusdir/etc/.");
  system("chmod 0600 $globusdir/etc/globus-rls-server.conf");
}

system("cp $setupdir/rls-ldif.conf $globusdir/etc/.");
system("chmod 0644 $globusdir/etc/rls-ldif.conf");

if (-e "$globusdir/var/odbc.ini") {
  print "$globusdir/var/odbc.ini already exists, not replacing with $setupdir/odbc.ini\n";
} else {
  system("cp $setupdir/odbc.ini $globusdir/var/.");
  system("chmod 0644 $globusdir/var/odbc.ini");
}

if (-e "$globusdir/var/lrc1000.db") {
  print "$globusdir/var/lrc1000.db already exists, not recreating lrc1000 database.\n";
} else {
  system("$globusdir/bin/sqlite3 $globusdir/var/lrc1000.db < $globusdir/setup/globus/globus-rls-lrc-sqlite.sql");
}

if (-e "$globusdir/var/rli1000.db") {
  print "$globusdir/var/rli1000.db already exists, not recreating rli1000 database.\n";
} else {
  system("$globusdir/bin/sqlite3 $globusdir/var/rli1000.db < $globusdir/setup/globus/globus-rls-rli-sqlite.sql");
}

print "Done\n";

$metadata->finish();
