<?php

/**
 * @return int
 * @param attributes array
 * @param signs array
 * @param filters array
 * @desc Retrieves the list of objects satisfying attribute/filter selection criteria
 */
function do_attlist ($thething,$attributes,$signs,$filters)
{
  require_once('lmtable.inc');
  require_once('cnvtime.inc');
  require_once('comfun.inc');
  require_once('toreload.inc');
  require_once('recursive_giis_info.inc');
  require('ldap_purge.inc');
  include('settings.inc');
  include('isattr.inc');

  $tlim = 20;
  $tout = 20;

  if ( !$thething ) $thething = "cluster";

  $engatts = array ();
  $lim     = array ( "dn" );

  // deduce the top object name assuming all requests are for the same object
  $components = explode("-",$attributes[0]);
  $object     = $components[0]."-".$components[1];

  // start building the filter
  $filter     = "(&(objectclass=$object)";
  
  $n       = count($attributes);
  $natt    = 0;
  $attrtag = array ();

  for ( $i=0; $i<$n; $i++ ){
    $attribute = $attributes[$i];
    if ( !$attribute ) continue;
    $selection = ( $filters[$i] ) ? $filters[$i] : "*";
    $is        = ( $signs[$i] ) ? $signs[$i] : "=";
    $lim[]     = $attribute;
    if ( !in_array($attribute,$attrtag)) $engatts[] = ( $isattr[$attribute] ) ? $isattr[$attribute] : $attribute;
    $attrtag[] = $attribute;

    // create the filter
    switch ( $is ) {
    case "!=":
      $filter .= "(!($attribute=$selection))";
      break;
    case "~":
      $selection = "*".$selection."*";
      $filter .= "($attribute=$selection)";
      break;
    case "!~":
      $selection = "*".$selection."*";
      $filter .= "(!($attribute=$selection))";
      break;
    default:
      $filter .= "($attribute$is$selection)";
    }
    $natt++;
  }
  $filter .= ")";

  // Header table
  
  define(HELPTEXT,"<div align=left><dl><dt><b>Name</b></dt><dd>CLICKABLE. Name of a resource which attributes are displayed. It can be a cluster name, a clusters queue name, a job name, a user name etc. Click on the string to get a detailde decscription of the resource.</dd><dt><b>Attribute name(s)</b></dt><dd>For each resource, one or more attribute values can be listed. Column title is the human-readable attribute name (except of some MDS-specific attributes), and the column contents are attribute values per resource as entered in the Information System.</dd></dl></div>");


  $toptable = new LmTableTop("","Attribute List");

  $gentries = recursive_giis_info($giislist,$thething,0);
  $nc       = count($gentries);
  if ( !$nc ) {
    // NO SITES FOUND!
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the top level GIIS returned information)</font>\n";
    return 1;
  }

  $dsarray = array ();
  $hnarray = array ();
  $sitetag = array (); /* a tag to skip duplicated entries */

  for ( $k = 0; $k < $nc; $k++ ) {
    $clhost = $gentries[$k]["host"];
    $clport = $gentries[$k]["port"];

    $clconn = ldap_connect($clhost,$clport);
    if ( $clconn && !$sitetag[$clhost] ) {
      array_push($dsarray,$clconn);
      $sitetag[$clhost] = 1; /* filtering tag */
    }
  }

  $nhosts = count($dsarray);
  if ( !$nhosts ) {
    // NO SITES REPLY...
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the GRIS returned connection)</font>\n";
    return 1;
  }

  // Search all clusters

  $srarray = @ldap_search($dsarray,DN_LOCAL,$filter,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
  
  // HTML table initialisation
  array_unshift($engatts,"Name");
  $jtable  = new LmTableFree($engatts);
  $rowcont = array();
  $tabcont = array();
  $rc = 0;
         
  for ( $ids = 0; $ids < $nhosts; $ids++ ) {

    $sr    = $srarray[$ids];
    $dst   = $dsarray[$ids];
    if ($dst && $sr) {
       
      // If search returned, check that there are valid entries
       
      $nmatch = @ldap_count_entries($dst,$sr);
      if ($nmatch > 0) {
        // If there are valid entries, tabulate results
         
        $allentries = ldap_get_entries($dst,$sr);
	$entries    = ldap_purge($allentries);
        $nclus      = $entries["count"];
        
        for ($i=0; $i<$nclus; $i++) {

	  $cluster  = "N/A";
	  $queue    = "N/A";
	  $job      = "N/A";

	  $currdn  = $entries[$i]["dn"];
	  $currdn  = preg_replace("/\"/","",$currdn);
	  $dnparts = ldap_explode_dn($currdn,0);
	  foreach ($dnparts as $part) {
	    $pair = explode("=",$part);
	    switch ( $pair[0] ) {
	    case CLU_NAME:
	      $cluster = $pair[1];
	      break;
	    case SEL_NAME:
	      $se      = $pair[1];
	      break;
	    case QUE_NAME:
	      $queue   = $pair[1];
	      break;
	    case JOB_GLID:
	      $job     = $pair[1];
              $encjob  = rawurlencode($currdn);
	      break;
	    }
	  }

	  switch ( $object ) {
	  case OBJ_CLUS:
	    $resource  = "Cluster <i>$cluster</i>";
            $winstring = popup("clusdes.php?host=$cluster&port=2135",700,620,1);
	    break;
	  case OBJ_QUEU:
	    $resource  = "Cluster <i>$cluster</i>, queue <i>$queue</i>";
	    $winstring = popup("quelist.php?host=$cluster&port=2135&qname=$queue",750,430,6);
	    break;
	  case OBJ_USER:
	    $resource  = "Cluster <i>$cluster</i>, queue <i>$queue</i>";
	    $winstring = popup("quelist.php?host=$cluster&port=2135&qname=$queue",750,430,6);
	    break;
	  case OBJ_AJOB:
	    $resource  = "Job <i>$job</i>";
	    $winstring = popup("jobstat.php?host=$cluster&port=2135&status=&jobdn=$encjob",750,430,4);
	    break;
	  case OBJ_STEL:
	    $resource  = "SE <i>$se</i>";
	    $winstring = "";
	    break;
	  }
	  
	  $rc++;
          $rowcont[0] = ( $winstring ) ? "$rc&nbsp;<a href=\"$winstring\">$resource</a>" : "$rc&nbsp;$resource";
	  
	  // determine maximum row count per object
	  $vcount = 0;
	  foreach ( $attributes as $attribute ) {
	    if ( !$attribute ) continue;
	    $ccount = $entries[$i][$attribute]["count"];
	    $vcount = ( $ccount > $vcount ) ? $ccount : $vcount;
	  }
	  if ($vcount == 0) $jtable->adderror($resource);
        
	  $attrtag = array();
	  for ( $j = 0; $j < $vcount; $j++ ) {
	    $attval   = "";
	    $attcheck = FALSE;
	    for ( $k = 0; $k < $n ; $k++ ) {
	      $attribute = $attributes[$k];
	      if ( !$attribute || @in_array($attribute,$attrtag[$j]) ) continue;
	      if ( $entries[$i][$attribute][$j] ) {
		$attval   = $entries[$i][$attribute][$j];
		$attcheck = TRUE;
	      } else {
		$attval   = " ";
	      }
	      
	      // Some time-stamp readability adjustment
	      if (substr(strrchr($attribute, "-"), 1) == "sessiondirerasetime" ||
		  substr(strrchr($attribute, "-"), 1) == "submissiontime"      ||
		  substr($attribute,0,9)              == "Mds-valid"
		  ) $attval=cnvtime($attval);
	      $rowcont[]     = htmlentities($attval);
	      $attrtag[$j][] = $attribute;
	    }
	    
	    if ( $attcheck ) {
	      $tabcont[] = $rowcont;
	    } else {
	      $rc--;
	    }
	    //	    if ( $attcheck ) $jtable->addrow($rowcont);
	    $rowcont = array();	    
	    $rowcont[0] = "&nbsp;";
	  }
        }
      }
    }
    @ldap_free_result($sr);
  }
  foreach ( $tabcont as $row ) $jtable->addrow($row,"");
  $jtable->close();
  return 0;
}

?>