<?php

// Author: oxana.smirnova@quark.lu.se

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('cnvtime.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_nice_dump.inc');

// Setting up the page itself

  define(HELPTEXT,"<div align=left><dl><dt><b>Attribute</b></dt><dd>CLICKABLE. Cluster attribute name, human-readable except of some MDS-specific attributes. Click on the attribute name to get the list of the attribute values across the NorduGrid universe.</dd><dt><b>Value</b></dt><dd>Attribute value as entered in the Information System.</dd><dt><b>Queue</b></dt><dd>CLICKABLE. Names of batch queues available for the NorduGrid users, as set by cluster owners. Typically, different queues correspond to different allowed task duration, or to different groups of users. Click on a queue name to get detailed information about the queue, including running, queued, and finished tasks.</dd><dt><b>Status</b></dt><dd>Queue status. Operating queue typically reports <i>active</i> status.</dd><dt><b>CPU (min)</b></dt><dd>Time limit for job duration per queue, if set, in CPU-minutes. First displayed value is the lower limit, second - the upper one. If limits are not set (jobs of any duration are accepted), <b>N/A</b> tag is shown.</dd><dt><b>Running</b></dt><dd>Number of jobs running in the queue. Total number of jobs is shown, with Grid-submitted jobs displayed in parentheses, e.g. (Grid: 12)</dd><dt><b>Queing</b></dt><dd>Number of jobs awaiting execution in the queue. Total number of jobs is shown, with Grid-submitted jobs displayed in parentheses, e.g. (Grid: 235)</dd></dl></div>");


$toppage = new LmDoc("clusdes");
define("TOPTIT",$toppage->title);

/**
 * @return int
 * @param host string
 * @param port int
 * @desc Retrieves the cluster information
 */
function do_clusdes ($host="grid.quark.lu.se",$port=2135)
{
  /**
   * FUNCTION DO_CLUSDES (string host, integer port)
   * Retrieves the cluster information from a given domain
   * Uses LDAP functions of PHP
   * 
   * Author: O.Smirnova (May 2002)
   * inspired by the LDAPExplorer by T.Miao
   * 
   * input:
   * host (default: grid.quark.lu.se)
   * port (default: 2135)
   * 
   * output:
   * an HTML table, containing the full cluster info
   */

  // Array defining the attributes to be returned
  
  $qlim = array( QUE_NAME, QUE_QUED, QUE_GQUE, QUE_RUNG, QUE_GRUN, 
                 QUE_ASCP, QUE_MAXT, QUE_MINT, QUE_STAT );
   
  // ldapsearch filter strings for cluster and queues
   
  $qfilter = "(objectclass=".OBJ_QUEU.")";
  $dn      = DN_LOCAL;
   
  $tlim = 10;
  $tout = 10;

  // Header table
  
  $toptable = new LmTableTop("","<b><i>".TOPTIT." for $host</i></b>");
  
  // Establish connection to the requested LDAP server
   
  $ds = ldap_connect($host,$port);
  if ($ds) {
     
    // If contact OK, search for clusters
     
    $thisdn = ldap_nice_dump($ds,CLU_NAME."=".$host.",".$dn);
    echo "<BR>";
    
    // Loop on queues (if everything works)
    
    if ($thisdn != 1) {
      $qsr = @ldap_search($ds,$dn,$qfilter,$qlim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
      // Fall back to conventional LDAP
      if (!$qsr) $qsr = @ldap_search($ds,$dn,$qfilter,$qlim,0,0,$tlim,LDAP_DEREF_NEVER);
    }
    if ($qsr) {
       
      // If search returned, check that there are valid entries
       
      $nqmatch = @ldap_count_entries($ds,$qsr);
      if ($nqmatch > 0) {
         
        // If there are valid entries, tabulate results
         
        $qentries = @ldap_get_entries($ds,$qsr);
        $nqueues  = $qentries["count"];
        
        // HTML table initialisation
         
        $qtable = new LmTableSp("clusdes");
        
        // loop on the rest of attributes

        define("CMPKEY",QUE_MAXT);
        usort($qentries,"quetcmp");
        for ($k=1; $k<$nqueues+1; $k++) {
          $qname   =  $qentries[$k][QUE_NAME][0];
          $qstatus =  $qentries[$k][QUE_STAT][0];
          $queued  =  $qentries[$k][QUE_QUED][0];
          $run     =  $qentries[$k][QUE_RUNG][0];
          $cpumin  = ($qentries[$k][QUE_MINT][0]) ? $qentries[$k][QUE_MINT][0] : "0";
          $cpumax  = ($qentries[$k][QUE_MAXT][0]) ? $qentries[$k][QUE_MAXT][0] : "inf";
          $cpu     = ($qentries[$k][QUE_ASCP][0]) ? $qentries[$k][QUE_ASCP][0] : "N/A";
	  $gridque = ($qentries[$k][QUE_GQUE][0]) ? $qentries[$k][QUE_GQUE][0] : "0";
	  $gridrun = ($qentries[$k][QUE_GRUN][0]) ? $qentries[$k][QUE_GRUN][0] : "0";
          $quewin  = popup("quelist.php?host=$host&port=$port&qname=$qname",750,430,6);

          // filling the table

          $qrowcont[] = "<a href=\"$quewin\">$qname</a>";
          $qrowcont[] = "$qstatus";
          $qrowcont[] = "$cpumin to $cpumax";
          $qrowcont[] = "$cpu";
          $qrowcont[] = "$run (Grid: $gridrun)";
          $qrowcont[] = "$queued (Grid: $gridque)";
          $qtable->addrow($qrowcont);
          $qrowcont = array ();
        }
        $qtable->close();
      }
      else {
        echo "<BR><font color=red><B>No queue information found</B></font>\n";
      }
    }
    else {
      echo "<BR><font color=red><B>No information available</B></font>\n";
    }
    @ldap_free_result($qsr);
    @ldap_close($ds);
    return 0;
  }
  else {
    echo "<BR><font color=red><b>Server unavailable</b></font>\n";
    return 1;
  }
}

$host   = $_GET["host"];
$port   = $_GET["port"];
do_clusdes($host,$port);

// Done

$toppage->close();

?>
