<?php

// Author: oxana.smirnova@quark.lu.se

// Collection of user comparison functions

/**
 * @return int
 * @param a array
 * @param b array
 * @desc Compares LDAP entries
 */
function ldap_entry_comp($a, $b)
{
  return strcasecmp ($a[CMPKEY][0],$b[CMPKEY][0]);
}

/**
 * @return int
 * @param a array
 * @param b array
 * @desc Compares DN strings
 */
function dncmp($a, $b)
{
  return strcasecmp ($a["dn"],$b["dn"]);
}

/**
 * @return int
 * @param a array
 * @param b array
 * @desc Compares queues by maxcputime
 */
function quetcmp ($a, $b) 
{
  $tm1 = ($a[CMPKEY][0])?$a[CMPKEY][0]:999999;
  $tm2 = ($b[CMPKEY][0])?$b[CMPKEY][0]:999999;
  if (gettype($a) != "array") return -1;
  if (gettype($b) != "array") return 1;
  return $tm1-$tm2;
}

/**
 * @return int
 * @param a array
 * @param b array
 * @desc Compares VO strings, or else host names
 */
function vocmp ($a, $b) 
{
  $cmpvo   = strcasecmp ($a["zvoname"],$b["zvoname"]);
  $cmpname = strcasecmp ($a["host"],$b["host"]);
  if ( !$cmpvo ) return $cmpname;
  return $cmpvo;
}

?>