<?php

// Author: oxana.smirnova@quark.lu.se

/**
 * A  function purging any LDAP
 * search result with identical DNs
 */

/**
* @return array
* @param allentries array
* @desc Purges identical DNs from LDAP search result
*/
function ldap_purge($allentries)
{
  
  $dnstore = array(); /* array to store unique DNs */
  $entries = array(); /* purged array to be returned */

  $ninp = $allentries["count"];
  
  $storesize = 0;

  for ($i = 0; $i < $ninp; $i++) {
    $curdn = $allentries[$i]["dn"];
    $curdn = str_replace(" ","",$curdn); // get rid of blanks in DN
    if ( !in_array($curdn,$dnstore) ) {
      array_push($dnstore,$curdn);
      $storesize++;
      array_push($entries,$allentries[$i]);
    }
  }

  $entries["count"] = $storesize;

  return $entries;

}

?>
