<?php
 
// Author: oxana.smirnova@quark.lu.se

/* THIS IS THE TOP MONITOR WINDOW */

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_purge.inc');
require_once('recursive_giis_info.inc');
require_once('postcode.inc');

// Setting up the page itself

  define(HELPTEXT,"<div align=left><dl><dt style={text-align:justify;}}>This screen displays all the sites registering to the top NorduGrid indexing service, sorted by country then by host name. Selected site parameters are monitored: cluster alias, total CPU capacity and number of running and queued jobs, both Grid and local ones. Use &quot;Match-it-yourself&quot; utility if you want to compare other cluster, queue, job etc. characteristics</dt><dt><b>Flag</b></dt><dd>CLICKABLE. Country flag and name as deduced from available resource descriptions. Click to show only this country info. </dd><dt><b>Cluster</b></dt><dd>CLICKABLE. Cluster alias as assigned by the owner. Maximal displayed length is 22 characters. Click on the alias to get a detailed cluster description.</dd><dt><b>CPUs</b></dt><dd>Total number of CPUs in a cluster. <b>NB!</b> Only a fraction of those can be actualy available for the Grid users.</dd><dt><b>Load (processes:Grid&#43local)</b></dt><dd>CLICKABLE. Relative cluster load, corresponding to the occupied CPUs count. Grey bars indicate processors occupied by the localy submitted jobs, while red bars show CPUs occupied by jobs submitted via Grid. Click on the bar to get the detailed list of all the running Grid jobs on the cluster, including amount of processors per job.</dd><dt><b>Queueing</b></dt><dd>CLICKABLE. Number of all queued jobs on the cluster, both Grid and local ones. Click the number to get the list of queued Grid jobs on the cluster.</dd></dl></div>");

$toppage = new LmDoc("loadmon");

// Header table

//$toptit   = date("D M j G:i:s T Y");
$toptit = date("Y-m-d T H:i:s");
$toptable = new LmTableTop("<font face=\"Verdana,Geneva,Arial,Helvetica,sans-serif\">$toppage->title<br><br></font>","<i>$toptit</i>");

// Legend

echo "<P ALIGN=left>Processes:\n";
echo "<img src=\"icon_led.php?c1=204&c2=0&c3=0\" vspace=1 hspace=3 border=0 alt=\"Red\" width=14 height=6>Grid&nbsp;<img src=\"icon_led.php?c1=128&c2=128&c3=128\" vspace=1 hspace=3 border=0 alt=\"Grey\">Local\n";
echo "</P>\n";

// The main function

/**
* @return int
* @param debug int
* @param display string
* @desc Retrieves the cluster load information
*/
function do_loadmon ($debug=0,$display="all")
{
  /*
   * FUNCTION DO_LOADMON (string host, integer port, string dn)
   * Retrieves the cluster load information from a given NorduGrid domain
   * Uses LDAP functions of PHP
   *
   * Author: O.Smirnova (May 2002)
   *         inspired by the LDAPExplorer by T.Miao
   *         and curses-based monitor by A.Waananen
   *
   * input:
   * GIIS host (default: grid.quark.lu.se)
   * port (default: 2135)
   * DN (default: mds-vo-name=sweden,o=grid)
   *
   * output:
   * an HTML table, containing:
   * - list of available clusters
   *   per each cluster:
   *   - total running jobs
   *   - relative load of the cluster (ratio "running jobs"/"CPUs")
   *   - queued jobs
   */

  if ( $debug ) {
    ob_end_flush();
    ob_implicit_flush();
  }

  // Setting time limits for ldapsearch

  $tlim = 10;
  $tout = 10;
  if($debug) dbgmsg("<div align=left><i>:::> Monitor timeouts for GRIS: $tlim sec on connection and $tout sec on search <:::</i></div>");

  // Arrays defining the attributes to be returned
  
  $lim  = array( "dn", CLU_ANAM, CLU_TCPU, CLU_UCPU, CLU_TJOB, CLU_QJOB );
  $qlim = array( QUE_GQUE, QUE_RUNG, QUE_GRUN );
  $jlim = array( JOB_STAT );
   
  // ldapsearch filter strings for clusters and queues
   
  $filstr  = "(objectclass=".OBJ_CLUS.")";
  $qfilstr = "(objectclass=".OBJ_QUEU.")";
  $jfilstr = "(objectclass=".OBJ_AJOB.")";

  // Adjusting cluster display filter

  $showvo = "";
  if ( substr($display,0,2) == "vo" ) {
    $showvo = substr(strrchr($display,"="),1);
    if ($debug) dbgmsg("<b> ::: Showing resources only in $showvo</b>");
  }
  if ( $display != "all" && !$showvo ) $filter  = "(&".$filstr."(".$display."))";

  // Top GIIS server: get all from the pre-defined list

  include('settings.inc');

  $ngiis = count($giislist);
  $ts1 = time(); $gentries = recursive_giis_info($giislist,"cluster",$debug);
  $ts2 = time(); if($debug) dbgmsg("<BR><b>Got GRIS list from $ngiis top servers in ".($ts2-$ts1)." sec</b><br>");

  $nc = count($gentries);

  if ( !$nc ) {
    // NO SITES FOUND!
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the top level GIIS returned information)</font>\n";
    return 1;
  }

  $ts1 = time(); $gentries = add_country($gentries);
  $ts2 = time(); if($debug) dbgmsg("<BR><b>Got geographical locations from $nc servers in ".($ts2-$ts1)." sec</b><br>");

  // Sort cluster list by country and host name

  usort($gentries,"vocmp");

  $affiliation = array ();
  $votolink    = array ();
  $dsarray     = array ();
  $hnarray     = array ();
  $sitetag     = array (); /* a tag to skip duplicated entries */

  // Filling the list of countries and purging cluster entries, ev. skipping countries

  for ( $k = 0; $k < $nc; $k++ ) {
    $clhost = $gentries[$k]["host"];
    $clport = $gentries[$k]["port"];
    $voname = $gentries[$k]["zvoname"];
    if ( strlen($voname) < 2 ) $voname = "World";
    if ( $showvo && $showvo != $voname ) {
      if ( !in_array($voname,$votolink) ) $votolink[]=$voname;
      continue;
    }

    $clconn = ldap_connect($clhost,$clport);
    if ( $clconn && !$sitetag[$clhost] ) {
      array_push($dsarray,$clconn);
      array_push($hnarray,$clhost);
      array_push($affiliation,$voname);
      $sitetag[$clhost] = 1; /* filtering tag */
      if ($debug==2) dbgmsg("$k - <i>$clhost:$clport </i>");
    }
  }

  $affcnt = array_count_values($affiliation);

  $nhosts = count($dsarray);
  if( $debug == 2 ) dbgmsg("<BR>$nhosts sites arranged by geographical location<br>");
  if ( !$nhosts ) {
    // NO SITES REPLY...
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the GRIS returned connection)</font>\n";
    return 1;
  }

  // Search all clusters for names and CPUs

  $ts1 = time();
  $srarray = @ldap_search($dsarray,DN_LOCAL,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
  // Fall back to a conventional LDAP
  //  if (!count($srarray)) $srarray = @ldap_search($dsarray,DN_LOCAL,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER);
  $ts2 = time(); if($debug) dbgmsg("<br><b>Search for cluster attributes: ".($ts2-$ts1)." sec</b><br>");

  // Search all clusters for queues

  $ts1 = time(); 
  $qsarray = @ldap_search($dsarray,DN_LOCAL,$qfilstr,$qlim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);  
  // Fall back to a conventional LDAP
  //  if ( !count($qsrarray)) $qsarray = @ldap_search($dsarray,DN_LOCAL,$qfilstr,$qlim,0,0,$tlim,LDAP_DEREF_NEVER);  
  $ts2 = time(); if($debug) dbgmsg("<br><b>Search for queue attributes: ".($ts2-$ts1)." sec</b><br>");

  // HTML table initialization

  $ctable = new LmTableSp("loadmon");
           
  // Loop on clusters

  $prevvo      = "boo";
  $sumcpu      = 0;
  $sumgridjobs = 0;
  $sumlocljobs = 0;
  $sumclusters = 0;

  // purge fake sites
  for ( $ip = 0; $ip < $nhosts; $ip++ ) {
    $vo = $affiliation[$ip];
    $sr = $srarray[$ip];
    $ds = $dsarray[$ip];
    $nr = @ldap_count_entries($ds,$sr);
    if ( !$sr || !$ds || !$nr ) {
      $affcnt[$vo]--;
      $alien = $hnarray[$ip];
      if ($debug) dbgmsg("<b><font color=red>Misconfigured cluster $alien in $vo</font></b><br>");
      $srarray[$ip] = FALSE;
    }    
  }

  for ( $ids = 0; $ids < $nhosts; $ids++ ) {

    $vo = $affiliation[$ids];
    $sr = $srarray[$ids];
    $qs = $qsarray[$ids];
    $hn = $hnarray[$ids];
    $ds = $dsarray[$ids];
    if ($ds && $sr) {

      $entries   = ldap_get_entries($ds,$sr);
      $nclusters = $entries["count"];      /* Must be one cluster */
      if ( !$nclusters ) {
	$ctable->adderror("<b>$hn</b>: bad configuration or $tout sec timeout");
	continue;
      }

      $i = 0;
      $curdn      = $entries[$i]["dn"];
      //      $curname    = $entries[$i][CLU_NAME][0];
      $dnparts    = ldap_explode_dn($curdn,0);
      $curname    = substr(strstr($dnparts[0],"="),1);

      $curalias   = $entries[$i][CLU_ANAM][0];

      if ($debug==2) dbgmsg("<i>$ids: <b>$curname</b> is up in $vo</i><br>");
      if (file_exists("cnvalias.inc")) include('cnvalias.inc');
      if ( strlen($curalias) > 22 ) $curalias = substr($curalias,0,21) . ">";

      $curtotjobs = ($entries[$i][CLU_TJOB][0]) ? $entries[$i][CLU_TJOB][0] : 0;
      $curusedcpu = ($entries[$i][CLU_UCPU][0]) ? $entries[$i][CLU_UCPU][0] : -1;
      $curquejobs = ($entries[$i][CLU_QJOB][0]) ? $entries[$i][CLU_QJOB][0] : 0;
      $curtotcpu  = ($entries[$i][CLU_TCPU][0]) ? $entries[$i][CLU_TCPU][0] : 0;
      $clstring  = popup("clusdes.php?host=$curname&port=2135",700,620,1);
	
      // queue lookup
      
      $allqrun  = 0;
      $gridjobs = 0;
      $allqued  = 0;
      $gridqued = 0;
      
      $toflag2 = FALSE;
      $qnmatch = @ldap_count_entries($ds,$qs);
      if ($qnmatch > 0) {
	
	// if there are valid queues, get the results
	
	$qentries = ldap_get_entries($ds,$qs);
	$nqueues  = $qentries["count"];
	
	// loop on queues
	
	$flag = 1;
	for ($j=0; $j<$nqueues; $j++) {
	  $allqrun  += ($qentries[$j][QUE_RUNG][0]) ? ($qentries[$j][QUE_RUNG][0]) : 0;
	  $gridjobs += ($qentries[$j][QUE_GRUN][0]) ? ($qentries[$j][QUE_GRUN][0]) : 0;
	  $gridqued += ($qentries[$j][QUE_GQUE][0]) ? ($qentries[$j][QUE_GQUE][0]) : 0;
	}
	
	if ($flag < 1) {
	  
	  // all NorduGrid jobs : manual sum up - not used here
	  
	  $jsr = ldap_search($ds,DN_LOCAL,$jfilstr,$jlim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
	  // Fall back to a conventional LDAP
	  if (!$jsr) $jsr = ldap_search($ds,DN_LOCAL,$jfilstr,$jlim,0,0,$tlim,LDAP_DEREF_NEVER);
	  $njmatch  = ldap_count_entries($ds,$jsr);
	  if ($njmatch > 0) {
	    $jentries = ldap_get_entries($ds,$jsr);
	    for ($ij=0; $ij<$jentries["count"];$ij++){
	      if ($jentries[$ij][JOB_STAT][0] == "INLRMS: R") $gridjobs++;
	    }
	  }
	}
      } else { 
	$toflag2 = TRUE;
      }
      
      $allrun    = ($curusedcpu < 0) ? $allqrun             : $curusedcpu; 
      if ($gridjobs > $allrun) $gridjobs = $allrun;
      $totqueued = ($flag < 1)       ? $curtotjobs-$allqrun : $curquejobs;
      $nongridq  = $totqueued - $gridqued;
      $localrun  = $allrun - $gridjobs;
      $gridload  = ($curtotcpu > 0)  ? $gridjobs/$curtotcpu : 0;
      $clusload  = ($curtotcpu > 0)  ? $allrun/$curtotcpu   : 0;
      $tstring   = urlencode("$gridjobs+$localrun");
      $jrstring  = popup("jobstat.php?host=$curname&port=2135&status=Running&jobdn=all",600,500,2);
      $jqstring  = popup("jobstat.php?host=$curname&port=2135&status=Queueing&jobdn=all",600,500,2);
      $vostring  = "http://www.nordugrid.org/monitor/loadmon.php?debug=$debug&display=vo=$vo";

      if ( $vo != $prevvo ) {
	
	$prevvo = $vo;
	$ctable->addspacer("#000099");
	$ctable->rowspan( $affcnt[$vo], "<a href=\"$vostring\"><img src=\"icons/$vo.png\" alt=\"\" height=\"10\" width=\"16\" border=\"0\">&nbsp;<i><b>$vo</b></i></a>&nbsp;", "#FFF2DF" );
      }
      
      //      $rowcont[] = "<img src=\"$vo.jpg\">";
      $rowcont[] = "<a href=\"$clstring\"><b>&nbsp;$curalias</b></a>";
      $rowcont[] = "$curtotcpu";
      if ( $toflag2 ) {
	$tstring .= "(no queue info)";
      }
      $rowcont[] = "<a href=\"$jrstring\"><img src=\"icon_bar.php?x=".$clusload."&xg=".$gridload."&y=13&text=".$tstring."\" vspace=2 hspace=3 border=0 alt=\"$gridjobs+$localrun\" width=200 height=13></a>";
      $rowcont[] = "<a href=\"$jqstring\">$totqueued</a>";

      //      $rowcont[] = "<a href=\"$jqstring\">$gridqued+$nongridq</a>";
      $ctable->addrow($rowcont);
      $rowcont = array ();
      
      $sumcpu      += $curtotcpu;
      $sumgridjobs += $gridjobs;
      $sumlocljobs += $localrun;
      $sumclusters ++;
    }
    $entries  = array();
    $jentries = array();
    $qentries = array();
    $gentries = array();
  }
  $ctable->addspacer("#990000");
  $rowcont[] = "<b><i>TOTAL</i></b>";
  $rowcont[] = "<b><i>$sumclusters sites</i></b>";
  $rowcont[] = "<b><i>$sumcpu</i></b>";
  $rowcont[] = "<b><i>$sumgridjobs + $sumlocljobs</i></b>";
  $rowcont[] = "&nbsp;";
  $ctable->addrow($rowcont, "#ffffff");
  $ctable->close();
  
  if ( $showvo ) {
    echo "<br><nobr>\n";
    foreach ( $votolink as $volink ) {
      $vostring  = "http://www.nordugrid.org/monitor/loadmon.php?debug=$debug&display=vo=$volink";
      $voimage   = "<img src=\"icons/$volink.png\" alt=\"\" height=\"10\" width=\"16\" border=\"0\">";
      echo "<a href=\"$vostring\">$voimage</a>&nbsp;&nbsp;";
    }
    echo "<a href=\"http://www.nordugrid.org/monitor\"><b>ALL</b></a><BR>\n";
    echo "</nobr>\n";
  }

  return 0;

}

$debug = $_GET["debug"];
do_loadmon($debug,$display);

$usstring = popup("volist.php",440,330,11);

$sewin   = popup("sestat.php",650,200,8);
$discwin = popup("discover.php",700,400,9);

echo "<div align=right><font size=-1 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif,lucida\"><i>";
echo "<a href=\"$discwin\">Match-it-yourself</a><BR>\n";
echo "<a href=\"$sewin\">Storage resources</a><BR>\n";
echo "<a href=\"$usstring\">User base</a></i></font></div>\n";

// Done

$toppage->close();


?>
