#!/usr/bin/perl
use Getopt::Long;
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
use infosys_shared;

#
# populates the nordugrid-rc MDS entry
#

GetOptions("dn:s" => \$dn,	     	  
	   "valid-to:i" => \$ttl,     
	   "config:s" => \$conf_file,
	   "loglevel:i" => \$loglevel,
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --config
				     
		optional arguments:  --valid-to 
		
		this help:	     --help				  		
		\n";
		exit;
}

if (($dn and $conf_file) eq "") {
    $loglevel and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
}; 

#
# initialization from the info.conf 
#

unless (open (configfile, "<$conf_file")) {
   $loglevel and  &infosys_shared::write_log("can't open $conf_file configuration file");
   die "Can't open $conf_file configuration file\n";
}

while ($line =<configfile>) {
	next if $line =~/^#/;
	next if $line =~/^$/;
	$line=~m/^(\w+)\s*=\s*"(.+)"\s*$/;
	($conf_var,$conf_value) = ($1,$2);

	($1 eq "hostname")             and  	$rc_hostname=$2;	
	($1 eq "rc_alias")             and  	$rc_alias=$2;
	($1 eq "rc_port")              and  	$rc_port=$2;	
	($1 eq "rc_basedn")            and  	$rc_basedn=$2;
	($1 eq "gridmap")              and  	$gridmapfile=$2;
	($1 eq "rc_gridmap")           and  	$rc_gridmapfile=$2;
}	


#
#  default values
#
$ttl ||= 600;
$rc_port ||= 389;
$gridmapfile ||= "/etc/grid-security/grid-mapfile";
$rc_gridmapfile ||= $gridmapfile;
$rc_hostname || chomp ($rc_hostname = `/bin/hostname -f`);

#
# read the mappings from the grid-mapfile to a %users hash
#

unless (open mapfile, "<$rc_gridmapfile") {
   $loglevel and  &infosys_shared::write_log("can't open gridmapfile");
   die "can't open gridmapfile";
}

while($line = <mapfile>) {
    chomp($line);  
    if ( ($sn,$unix_user)= $line =~ m/\"([^"]+)\"\s+(\S+)/) {
        $users{$1}=$unix_user; 	
    }  	
}				    
close mapfile;	

# The DN of the entry
print "dn: $dn\n";

# The objectclasses
print "objectclass: Mds\n";
print "objectclass: nordugrid-rc\n";

# The attributes
print "nordugrid-rc-name: $rc_hostname\n";
print "nordugrid-rc-aliasname: $rc_alias\n";
print "nordugrid-rc-baseurl: ldap://$rc_hostname:$rc_port/$rc_basedn\n";

#nordugrid-rc-authuser
foreach $listentry (keys %users) {
    print "nordugrid-rc-authuser: $listentry\n";
}

#Mds-validfrom/to
&infosys_shared::mds_valid($ttl);

my $runtime =  time - $^T;
if ($loglevel == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($loglevel = 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}

exit;
