#!/usr/bin/perl
use Getopt::Long;
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
use infosys_shared;

#
# populates the nordugrid-se MDS entry
#


GetOptions("dn:s" => \$dn,	     	  
	   "valid-to:i" => \$ttl,     
	   "config:s" => \$conf_file,
	   "loglevel:i" => \$loglevel,
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --config
				     
		optional arguments:  --valid-to 
		
		this help:	     --help				  		
		\n";
		exit;
}

if (($dn and $conf_file) eq "") {
    $loglevel and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
};


#
# initialization
#
unless (open (configfile, "<$conf_file")) {
   $loglevel and  &infosys_shared::write_log("can't open $conf_file configuration file");
   die "Can't open $conf_file configuration file\n";
}

while ($line =<configfile>) {
	next if $line =~/^#/;
	next if $line =~/^$/;
	$line=~m/^(\w+)\s*=\s*"(.+)"\s*$/;
	($conf_var,$conf_value) = ($1,$2);
	
	($1 eq "se_name")     	       and  	$se_name=$2;
	($1 eq "se_hostname")          and  	$se_hostname=$2;
	($1 eq "se_alias")             and  	$se_alias=$2;
	($1 eq "se_type")	       and	$se_type=$2;
	($1 eq "se_dir")	       and	$se_dir=$2;
	($1 eq "se_mount")	       and	$se_mount=$2;
	($1 eq "se_port")	       and	$se_port=$2;
	($1 eq "gridmap")              and  	$gridmapfile=$2;
	($1 eq "se_gridmap")           and	$se_gridmapfile=$2;
	($1 eq "se_comment")           and	$se_comment=$2;
}	


#
#  default values
#
$ttl ||= 600;
$se_port ||= "2811";
$gridmapfile ||= "/etc/grid-security/grid-mapfile";
$se_gridmapfile ||= $gridmapfile;
$se_hostname || chomp ($se_hostname = `/bin/hostname -f`);
$config{ng_location} ||= $ENV{NORDUGRID_LOCATION} ||= "/opt/nordugrid";
my $globus_location ||= $ENV{GLOBUS_LOCATION} ||= "/opt/globus/";

#
# read the mappings from the grid-mapfile to a %users hash
#

unless (open mapfile, "<$se_gridmapfile") {
 $loglevel and  &infosys_shared::write_log("can't open gridmapfile");
 die "can't open gridmapfile";
}

while($line = <mapfile>) {
    chomp($line);  
    if ( ($sn,$unix_user)= $line =~ m/\"([^"]+)\"\s+(\S+)/) {
        $users{$1}=$unix_user; 	
    }  	
}				    
close mapfile;	


# The DN of the entry
print "dn: $dn\n";

# The objectclasses
print "objectclass: Mds\n";
print "objectclass: nordugrid-se\n";

# The attributes
print "nordugrid-se-name: $se_name:$se_hostname\n";
print "nordugrid-se-baseurl: gsiftp://$se_hostname:$se_port","$se_dir\n";
$se_alias and print "nordugrid-se-aliasname: $se_alias\n";
$se_type and print "nordugrid-se-type: $se_type\n";
$se_comment and print "nordugrid-se-comment: $se_comment\n";

#nordugrid-se-totalspace/freespace
my $diskfree;
my $disktotal;
if ( -d "$se_mount") {
  # check if on afs  
  if ($se_mount =~ /\/afs\//) {
	$diskfree =`fs listquota $se_mount 2>/dev/null`;   
	if ($diskfree) {
	  $diskfree =~ /\n\S+\s+(\d+)\s+(\d+)\s+\d+%\s+\d+%/;
	  $diskfree = int (($1 - $2)/1024);
	  $disktotal= int $1/1024;
	} 
	else {
	  $diskfree = 0;
	  $disktotal = 0;
	}  
  } 
  # "ordinary" disk 
  else {
	$dfstring =`df -k $se_mount 2>/dev/null`;   
	if ($dfstring) {
	  $dfstring =~ /\n\S+\s+(\d+)\s+\d+\s+(\d+)\s+\d+/;
	  $diskfree = int $2/1024;
	  $disktotal = int $1/1024;
	}
	else {
	  $diskfree = 0;
	  $disktotal = 0;
	}
  }
}
else {
  $diskfree = 0;
  $disktotal = 0;
  $loglevel and &infosys_shared::write_log("SE mount directory is not found");
}
print "nordugrid-se-totalspace: $disktotal\n";
print "nordugrid-se-freespace: $diskfree\n";

#nordugrid-se-middleware

#NorduGrid toolkit
#nordugridlocation/sbin/grid-manager -v
my $ngversionstring = `$config{ng_location}/sbin/grid-manager -v`;
$ngversionstring =~ /grid-manager: version\s*(.+)$/ and $ngversion="-".$1;
if ($ngversionstring) {
    print "nordugrid-se-middleware: nordugrid$ngversion\n";
}

#Globus Toolkit
#globuslocation/share/doc/VERSION
chomp (my  $globusversion =  `cat $globus_location/share/doc/VERSION 2>/dev/null`);
if ($? and $loglevel) { 					         
    &infosys_shared::write_log("error in reading the globus version file")   
}								         
if ($globusversion) {
    print "nordugrid-se-middleware: globus-$globusversion\n";
}


#nordugrid-se-authuser
foreach $listentry (keys %users) {
   print "nordugrid-se-authuser: $listentry\n";
}

#Mds-validfrom/to
&infosys_shared::mds_valid($ttl);

my $runtime =  time - $^T;
if ($loglevel == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($loglevel = 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}

exit;
