<?php

// Author: oxana.smirnova@quark.lu.se

 /**
 * A class to set up HTML pages
 */

class LmDoc {

  /**
   * @return LmDoc
   * @param wintyp string
   * @desc Creates a new HTML document
   */
  function LmDoc ( $wintyp="" )
    {
      header("Content-type: text/html; charset=utf-8");
      ob_implicit_flush(0);
      ob_start();

      set_time_limit(5);

      //echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n";
      //echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\n";
      echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD W3 HTML//EN\">\n";
      echo "<HTML><HEAD>\n";
      //      echo "<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=iso-8859-1\">\n";
      echo "<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"text/html; charset=utf-8\">\n";
      echo "<SCRIPT SRC=\"monitor.js\"></SCRIPT>\n";

      if ( $wintyp ) {

	require ('settings.inc');
	
	$inpnam = implode("_",array("def",$wintyp));
	
	// Page style definitions (see settings.inc)
	
	$this->title   = (${$inpnam}["title"])   ? ${$inpnam}["title"]   : "No Title";
	$this->refresh = (${$inpnam}["refresh"]) ? ${$inpnam}["refresh"] : 30;
	$this->bg      = (${$inpnam}["bgcolor"]) ? ${$inpnam}["bgcolor"] : "#ffffff";
	$this->lc      = (${$inpnam}["lcolor"])  ? ${$inpnam}["lcolor"]  : "#cc0000";

	echo "<TITLE>$this->title</TITLE>\n";
	echo "<META HTTP-EQUIV=\"REFRESH\" CONTENT=$this->refresh>\n";
	echo "<STYLE>\n";
	echo "<!--\n";
	echo "A {text-decoration:none; }\n";
	echo "A:link {color: $this->lc; }\n";
	echo "A:visited {color: $this->lc; }\n";
	echo "A:first-child {color: $this->lc; }\n";
	echo "BODY {background-color: $this->bg; font-size:small; height:auto;}\n";
	echo "P {padding: 0em; margin: 10px 0px 6px 0px; font-size:small; }\n";
	echo "TD {font-size:small;}\n";
	echo ".right {text-align: right; padding: 0em; margin: 0em;}\n";
	echo ".fix {font-family: monospace;}\n";
	echo "//-->\n";
	echo "</STYLE>\n";
      }
      
      echo "</HEAD>\n";
      echo "<BODY>\n";
      echo "<CENTER>\n";
    }

  /**
   * @return void
   * @desc Closes an HTML document
   */
  function close ()
    {
      echo "\n</CENTER>\n";
      echo "</BODY></HTML>\n";
      ob_end_flush();
      ob_implicit_flush();
    }
	
}

/**
* @return void
* @param dbgtxt string
* @desc Outputs a debug message outside the table
*/
function dbgmsg( $dbgtxt="Debug" )
{
  echo "$dbgtxt\n";
  flush();
}

/**
* @return void
* @param contact string
* @param x int
* @param y int
* @param n int
* @desc Returns a new monitor window URL
*/
$agent = $_SERVER["HTTP_USER_AGENT"] ;
if ( !defined("USERAGENT") ) define("USERAGENT",$agent);

function popup( $contact, $x=400, $y=300, $n=1 )
{
  ( USERAGENT ) ? $agent = USERAGENT : $agent = "lynx";
  if ( preg_match("/opera/i",$agent) 
       || preg_match("/lynx/i",$agent) 
       || preg_match("/konqueror/i",$agent) 
       ) return $contact;
  //  $link  = "javascript:monitor('".$contact."',$x,$y,$n)";
  $link = $contact."\" target=\"win".$n."\" onClick=\"monitor('".$contact."',$x,$y,$n); return false";
  return $link;
}

?>
