<?php
 
// Author: oxana.smirnova@quark.lu.se

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('cnvtime.inc');
require_once('cnvname.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_nice_dump.inc');

// Setting up the page itself

$toppage = new LmDoc("jobstat");

/**
 * @return int
 * @param host string
 * @param port int
 * @param status string
 * @param jobdn string
 * @desc Retrieves job-specific information
 */
//function do_jobstat ($host="grid.quark.lu.se",$port=2135,$status="Running",$jobdn="all")
function do_jobstat ($host,$port,$status,$jobdn)
{   
  /*
   * FUNCTION DO_JOBSTAT (string host, int port, string dn, string status)
   * Retrieves job-specific information from a given NorduGrid queue
   * Uses LDAP functions of PHP
   * 
   * Author: O.Smirnova (May 2002)
   * inspired by the LDAPExplorer by T.Miao
   * 
   * input:
   * host (default: grid.quark.lu.se)
   * port (default: 2135)
   * status (Running|Preparing|whatever)
   * jobdn (all|DN of a single job)
   * 
   * output:
   * an HTML table, containing:
   * per each cluster:
   * - list of running or queued jobs
   */
  
  $tlim = 10;
  $tout = 15;

  // Header table
  
  if ($jobdn=="all") {
    define(HELPTEXT,"<div align=left><dl><dt><b>Job name</b></dt><dd>CLICKABLE. Name of a job as assigned by the owner. If no name has been assigned, &quot;<span style={color:red};}>N/A</span>&quot; is displayed. Click on a name to get a detailed description of the job.</dd><dt><b>Owner</b></dt><dd>CLICKABLE. Name of the job owner, as specified in the user certificate. Click on a name to get the list of all the resources available for this user and all the jobs by this user which are currently in the system.</dd><dt><b>Status</b></dt><dd>Job status as returned by the Grid Manager (GM) and LRMS. In sequential order, the states are:<dl><dt>ACCEPTED &ndash; job submitted but not yet processed</dt><dt>PREPARING &ndash; input files are being retreived</dt><dt>SUBMITTING &ndash; interaction with LRMS ongoing</dt><dt>INLRMS &ndash; the job is transferred to the LRMS; internal staus is added by the infosystem. For PBS, possible states are:</dt> <dd>: Q &ndash; job is queued by PBS <br>: U &ndash; job is in a suspended state on a busy node (PBSPro) <br>: R &ndash; job is running <br>: E &ndash; job is finishing in PBS</dd><dt>FINISHING &ndash; output files are being transferred by the GM</dt><dt>FINISHED &ndash; job is finished; time stamp is added by the infosystem</dt><dt>CANCELING &ndash; job is being cancelled</dt><dt>DELETED &ndash; job not cleaned upon user request but removed by the GM due to expiration time</dt></dl>Each of the states can be reported with the PENDING: prefix, meaning the GM is attempting to move the job to the next state</dd><dt><b>CPU (min)</b></dt><dd>CPU time used by the job, minutes.</dd><dt><b>Queue</b></dt><dd>CLICKABLE. Name of the batch queue in which the job is being executed. Click on a queue name to get detailed information about the queue, including running, queued, and finished tasks.</dd><dt><b>CPUs</b></dt><dd>Number of processors used by the job.</dd></dl></div>");
    $clstring=popup("clusdes.php?host=$host&port=$port",700,620,1);
    $toptit = "<b><i>$status jobs at <a href=\"$clstring\">$host</a></i></b>";
  } else {
  define(HELPTEXT,"<div align=left><dl><dt><b>Attribute</b></dt><dd>CLICKABLE. Job attribute name, human-readable except of some MDS-specific attributes. Click on the attribute name to get the list of the attribute values across the NorduGrid universe.</dd><dt><b>Value</b></dt><dd>Attribute value as entered in the Information System.</dd></dl></div>");
    $jobdn     = rawurldecode($jobdn);
    $jobdn     = preg_replace("/\"/","",$jobdn);
    $dn_pieces = ldap_explode_dn($jobdn,1);
    $jobgid    = $dn_pieces[0];
    $toptit    = "<b>Job ID: <i>$jobgid</i></b>";
  }
  
  $toptable = new LmTableTop("","$toptit");
  
  // Arrays defining the attributes to be returned
  
  $lim = array( "dn", JOB_NAME, JOB_EQUE, JOB_GOWN, JOB_STAT, JOB_USET, JOB_SUBM, JOB_CPUS );
  
  // ldapsearch filter string for jobs
  
  $filstr="(objectclass=".OBJ_AJOB.")";
  
  // Establish connection to the requested LDAP server
  
  $ds    = ldap_connect($host,$port);
  $bdn   = DN_LOCAL;
  $topdn = DN_GLOBL;
  if ($ds) {
    
    // Single job info dump and quit
    
    if ($jobdn != "all") {
      $basedn = explode("Mds",$jobdn);
      $locdn  = $basedn[0].$bdn;
      $thisdn = ldap_nice_dump($ds,$locdn);
      ldap_close($ds);
      return 0;
    }
    
    // Loop over all the jobs
    
    $sr = @ldap_search($ds,$bdn,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
    // Fall back to conventional LDAP
    if (!$sr) $sr = @ldap_search($ds,$bdn,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER);

    if ($sr) {
      
      // If search returned, check that there are valid entries
      
      $nmatch = ldap_count_entries($ds,$sr);
      if ($nmatch > 0) {
        
        // HTML table initialisation
        
        $jtable = new LmTable("jobstat");
        
        // If there are valid entries, tabulate results
        
        $entries = ldap_get_entries($ds,$sr);
        $njobs   = $entries["count"];

        define("CMPKEY",JOB_SUBM);
        usort($entries,"ldap_entry_comp");
        
        // loop on jobs
        
	$jcount = 0;
        for ($i=1; $i<$njobs+1; $i++) {
          $jdn     = rawurlencode($entries[$i]["dn"]);
          $curstat = $entries[$i][JOB_STAT][0];
          
          /*
           * The following flags may need an adjustment, 
           * depending on the Job Status provider
           */

          // Running job: statail == ": R"
          $statail = substr($curstat,-3);
          
          // Queued job: stahead != "FIN" && statail != ": R"
          $stahead = substr($curstat,0,3);
          
          $flagrun = ( $status  == "Running" && 
                       $statail == ": R");
          $flagque = ( $status  != "Running" &&
                       $statail != ": R"     &&
                       $stahead != "FIN"     &&
                       $stahead != "DEL" );
          
          /* No changes necessary below */
          
          $flagact = ($flagrun || $flagque)?1:0;
          if ($flagact == 1 || $status == "All" ) {
            $uname    = $entries[$i][JOB_GOWN][0];
            $encuname = rawurlencode($uname);
	    $family   = cnvname($uname);

	    $jname   = htmlentities($entries[$i][JOB_NAME][0]);
	    $jobname = ($entries[$i][JOB_NAME][0]) ? $jname : "<font color=red>N/A</font>";
            $queue   = ($entries[$i][JOB_EQUE][0]) ? $entries[$i][JOB_EQUE][0] : "";
            $time    = ($entries[$i][JOB_USET][0]) ? $entries[$i][JOB_USET][0] : "";
	    $ncpus   = ($entries[$i][JOB_CPUS][0]) ? $entries[$i][JOB_CPUS][0] : "";
            $newwin  = popup("jobstat.php?host=$host&port=$port&status=$status&jobdn=$jdn",750,430,4);
            $quewin  = popup("quelist.php?host=$host&port=$port&qname=$queue",750,430,6);
            $usrwin  = popup("userlist.php?bdn=$topdn&owner=$encuname",700,500,5);

            $jcount++;

            // filling the table
            
            $jrowcont[] = "$jcount&nbsp;<a href=\"$newwin\">$jobname</a>";
            $jrowcont[] = "<a href=\"$usrwin\">$family</a>";
            $jrowcont[] = "$curstat";
            $jrowcont[] = "$time";
            $jrowcont[] = "<a href=\"$quewin\">$queue</a>";
            $jrowcont[] = "$ncpus";
            $jtable->addrow($jrowcont);
            $jrowcont = array ();
          }
        }
        if ($jcount == 0) $jtable->adderror("<B>$status Grid jobs not found</B>");
        $jtable->close();
      }
      else {
        echo "<BR><font color=red><B>No Grid jobs found</B> - refresh later</font>\n";
      }
    }
    else {
      echo "<BR><font color=red><B>No Grid jobs found</B> - refresh later</font>\n";
    }
    $entries = array();
    @ldap_free_result($sr);
    ldap_close($ds);
    return 0;
  }
  else {
    echo "<BR><font color=red><b>Server unavailable</b></font>\n";
    return 1;
  }
}

$host   = $_GET["host"];
$port   = $_GET["port"];
$status = ( $_GET["status"] ) ? $_GET["status"] : "Running";
$jobdn  = ( $_GET["jobdn"] )  ? $_GET["jobdn"]  : "all";
do_jobstat($host,$port,$status,$jobdn);

// Done

$toppage->close();

?>
