<?php
 
// Author: oxana.smirnova@quark.lu.se

/*
 * Describes two classes for the NorduGrid Load Monitor tables:
 *  LmTableTop - constructs the header table with a given title
 *  LmTable    - constructs all other tables characterized by:
 *               header row color
 *               body color
 *               title font
 *               main text font
 *               array of column headers
 *               array of column sizes
 * Author: O.Smirnova (July 2002)
 */ 

/*
 * CLASS LmTableTop
 */
 
class LmTableTop  {
	
  var $title;
  
  /**
   * @return LmTableTop
   * @param title string
   * @desc Initialisation of the header table
   */
  function LmTableTop( $title, $subtitle="" ) {

    if ( !defined("HELPTEXT") ) define("HELPTEXT","Help");    

    $this->title = $title;
    $this->subtitle = $subtitle;
    
    require('toreload.inc');
    
    echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n";
    echo "<tr><td nowrap align=\"center\" colspan=\"2\"><b>$this->title</b></td>\n";
    echo "<tr><td nowrap align=\"left\"><b><i>$this->subtitle</i></b></td>\n";
    //    echo "<td nowrap align=\"right\"><a href=\"".TORELOAD."\">\n";
    echo "<td nowrap align=\"right\"><a href=\"javascript: window.location.reload()\">\n";
    echo "     <img src=\"icon_refresh.php\" vspace=\"1\" hspace=\"3\" border=\"0\" align=\"absmiddle\"></a>\n";
    echo "     <a href=\"javascript:(self.print();)\" onClick=\"self.print();\">\n";
    echo "     <img src=\"icon_print.php\" vspace=\"1\" hspace=\"3\" border=\"0\" align=\"absmiddle\"></a>\n";
    echo "     <a href=\"javascript:monitor('help.php?text=".HELPTEXT."',400,300,10);\" onClick=\"javascript:monitor('help.php?text=".HELPTEXT."',400,300,10);\">\n";
    echo "     <img src=\"icon_help.php\" vspace=\"1\" hspace=\"3\" border=\"0\" align=\"absmiddle\"></a>\n";
    echo "     <a href=\"javascript:(self.close();)\" onClick=\"self.close();\">\n";
    echo "     <img src=\"icon_close.php\" vspace=\"1\" hspace=\"3\" border=\"0\" align=\"absmiddle\"></a>\n";
    echo "</td></tr></table>\n";
    
  }
}

/*
 * CLASS LmTable
 */

class LmTable {
  
  var $color_header;
  var $color_bg;
  
  var $font_title;
  var $font_main;
  
  var $columns;
  var $contents;
  var $ncols;
  
  var $errtxt;
  var $nrows;
  
  /**
   * @return LmTable
   * @param wintyp string
   * @desc Starts an HTML table
   */
  function LmTable( $wintyp ) {
    /*
     * Initialisation of a table: 
     * definition of colors
     * 
     * Input: 
     *   string $wintyp - table style
     */
    
    ob_implicit_flush(0);
    ob_start();

    require ('settings.inc');

    $inpnam = implode("_",array("def",$wintyp));
    $xeader = implode("_",array("header",$wintyp));
    
    $this->color_header = (${$inpnam}["thcolor"]) ? ${$inpnam}["thcolor"] : "#999999";
    $this->color_bg     = (${$inpnam}["tbcolor"]) ? ${$inpnam}["tbcolor"] : "#f0f0f0";
    $this->font_title   = (${$inpnam}["thfont"])  ? ${$inpnam}["thfont"]  : "color=\"#ffffff\"";
    $this->font_main    = (${$inpnam}["tbfont"])  ? ${$inpnam}["tbfont"]  : "color=\"#000000\"";
    $this->columns      = ${$xeader};
    $this->ncols        = 0;
    
    echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"$this->color_bg\">\n";
    echo "<tr bgcolor=\"$this->color_header\">\n";
    foreach ( ${$xeader} as $colnam => $colwid) {
      $this->ncols ++;
      $value = $colnam;
      $width = ($colwid)?$colwid:"1%";
      echo "<td align=\"left\" width=\"$width\"><nobr><font $this->font_title>&nbsp;$value&nbsp;</font></nobr></td>\n";
    }
    echo "</tr>\n";
  }
  
  /**
   * @return void
   * @param contents array 
   * @desc Draws a table row
   */
  function addrow( $contents, $bgcol="" ) {
    
    if ( count($contents) != $this->ncols ) {
      $this->adderror("Incompatible data");
      return 1;
    }
    
    $this->contents = $contents;

    if ($bgcol) {
      echo "<tr bgcolor=\"$bgcol\">\n";
    } else {
      echo "<tr>\n";
    }
    foreach ($contents as $colent) {
      $value = $colent;
      echo "<td align=\"left\" valign=\"middle\"><nobr><font $this->font_main>&nbsp;$value&nbsp;</font></nobr></td>\n";
    }
    echo "</tr>\n";
    
  }
  
  /**
   * @return void
   * @param color string
   * @desc Draws a spanning row containing a spacer
   */
  function addspacer( $color="#000000" ) {
    
    echo "<tr>\n";
    echo "<td colspan=\"$this->ncols\" bgcolor=\"$color\" height=\"0\"><img src=\"icon_spacer.php\" width=\"1\" height=\"1\" border=\"0\" alt=\"\"></td>";
    echo "</tr>\n";
    
  }
   
  /**
   * @return void
   * @param errtxt string 
   * @desc Draws a spanning row containing error message
   */
  function adderror( $errtxt="Error" ) {
    
    $this->errtxt  = $errtxt;
    echo "<tr>\n";
    echo "<td nowrap align=\"left\" colspan=\"$this->ncols\">&nbsp;<font color=\"red\">$errtxt</font></td>";
    echo "</tr>\n";
    
  }
   
  /**
   * @return void
   * @param errtxt string 
   * @param nrows integer
   * @param color string
   * @desc Adds a cell spanning $nrows rows
   */
  function rowspan( $nrows, $errtxt="&nbsp;", $color="#ffffcc" ) {
    
    $this->errtxt = $errtxt;

    $ncols  = $this->ncols - 1;
    $nrows  = $nrows + 1;

    echo "<tr>\n";
    echo "<td nowrap align=\"left\" valign=\"middle\" rowspan=\"$nrows\" bgcolor=\"$color\">&nbsp;$errtxt</td>";
    echo "<td nowrap colspan=\"$ncols\" bgcolor=\"$color\" height=\"0\"><img src=\"icon_spacer.php\" width=\"1\" height=\"1\" border=\"0\" alt=\"\"></td>";
    echo "</tr>\n";
    
  }
   
  /**
   * @return void
   * @desc Closes a table
   */
  function close() {
    echo "</table>\n";
    
    ob_end_flush();
    ob_implicit_flush();
  }
  
}

class LmTableSp extends LmTable {

  var $spcolor;
  
  /**
   * @return void
   * @param contents array 
   * @param color string 
   * @desc Draws a table row with a spacer above
   */
  function addrow( $contents, $bgcol="", $color="#ffffff" ) {
    
    $ncols = count($contents);
    
    $this->contents = $contents;

    if ($bgcol) {
      echo "<tr nowrap bgcolor=\"$bgcol\">\n";
    } else {
      echo "<tr nowrap>\n";
    }
    foreach ($contents as $colent) {
       $value = $colent;
      echo "<td align=\"left\" valign=\"middle\"><nobr><font $this->font_main>&nbsp;$value&nbsp;</font></nobr></td>\n";
    }
    echo "</tr>\n";

    echo "<tr>\n";

    echo "<td colspan=\"$ncols\" bgcolor=\"$color\" height=\"1\"><img src=\"icon_spacer.php\" width=\"1\" height=\"1\" alt=\"\"></td>";
    echo "</tr>\n";
    
  }
  
    /**
     * @return void
     * @param errtxt string
 	   * @param color string 
     * @desc Draws a spanning row containing error message
     */
    function adderror( $errtxt="Error", $color="#ffffff" ) {
    
    $this->errtxt  = $errtxt;
    
    $ncols  = $this->ncols;
    $tospan = $this->rowspan;
    if ( $tospan ) $ncols = $ncols - 1;

    echo "<tr>\n";
    echo "<td nowrap colspan=\"$ncols\" bgcolor=\"$color\" height=\"0\"><img src=\"icon_spacer.php\" width=\"1\" height=\"1\" border=\"0\" alt=\"\"></td>";
    echo "</tr>\n";
  
    echo "<tr>\n";
    echo "<td nowrap align=\"left\" colspan=\"$this->ncols\">&nbsp;<font color=\"red\">$errtxt</font></td>";
    echo "</tr>\n";
    
  }

  /**
   * @return void
   * @param errtxt string 
   * @param nrows integer
   * @param color string 
   * @desc Adds a cell spanning $nrows rows
   */
  function rowspan( $nrows, $errtxt="&nbsp;", $color="#ffffcc" ) {
    
    $this->errtxt = $errtxt;

    $ncols  = $this->ncols - 1;
    $nrows  = (2 * $nrows) + 1;

    echo "<tr>\n";
    echo "<td nowrap align=\"left\" valign=\"middle\" rowspan=\"$nrows\" bgcolor=\"$color\">&nbsp;$errtxt</td>";
    echo "<td nowrap colspan=\"$ncols\" bgcolor=\"$color\" height=\"0\"><img src=\"icon_spacer.php\" width=\"1\" height=\"1\" border=\"0\" alt=\"\"></td>";
    echo "</tr>\n";
    
  }
   


}

class LmTableFree extends LmTableSp {

  /**
   * @return LmTableFree
   * @param headers array
   * @desc Starts an HTML table
   */
  function LmTableFree( $headers ) {
    
    ob_implicit_flush(0);
    ob_start();

    $this->color_header = "#666666";
    $this->color_bg     = "#f0f0f0";
    $this->font_title   = "color=\"#ffffff\"";
    $this->font_main    = "color=\"#000000\"";
    $this->columns      = count($headers);
    $this->ncols        = 0;
    
    echo "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"$this->color_bg\">\n";
    echo "<tr bgcolor=\"$this->color_header\">\n";
    foreach ( $headers as $colnam ) {
      $this->ncols ++;
      $value = $colnam;
      $width = "1%";
      echo "<td align=\"left\" width=\"$width\"><nobr><font $this->font_title>&nbsp;$value&nbsp;</font></nobr></td>\n";
    }
    echo "</tr>\n";
  }
  
}

?>