<?php

// Author: oxana.smirnova@quark.lu.se

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('comfun.inc');
require_once('cnvtime.inc');
require_once('cnvname.inc');
require_once('toreload.inc');
require_once('ldap_nice_dump.inc');

// Setting up the page itself

$toppage = new LmDoc("quelist");

/**
 * @return int
 * @param host string
 * @param port int
 * @param qname string
 * @desc Retrieves the queue information (job list)
 */
function do_quelist ($host="grid.quark.lu.se",$port=2135,$qname="default")
{
  /**
   * FUNCTION DO_QUELIST (string host, int port, string qname)
   * Retrieves the queue job list information from a given NorduGrid domain
   * Uses LDAP functions of PHP
   * 
   * Author: O.Smirnova (June 2002)
   * inspired by the LDAPExplorer by T.Miao
   * 
   * input:
   * host (default: grid.quark.lu.se)
   * port (default: 2135)
   * qname (default: "default")
   * 
   * output:
   * an HTML table, containing the list of the jobs in the queue
   */
   
  define(HELPTEXT,"<div align=left><dl><dt><b>Attribute</b></dt><dd>CLICKABLE. Descriptive name of a queue attribute. Click on a name to get the list of this attribute values over the entire Grid</dd><dt><b>Value</b></dt><dd>Value of attributes, as assigned during the system configuration</dd><dt><b>Job name</b></dt><dd>CLICKABLE. Name of a job in the queue, as assigned by the job owner.<br>  <font color=red>N/A</font> indicates that user did not assign any name. <br> <font color=red><b>X</b></font> indicates that the job has been killed by the owner<br> <font color=red><b>!</b></font> indicates that the job failed in the system<br> Click on a name to get a detailed description of the job.</dd><dt><b>Owner</b></dt><dd>CLICKABLE. Name of the job owner, as specified in the user certificate. Click on a name to get the list of all the resources available for this user and all the jobs by this user which are currently in the system.</dd><dt><b>Status</b></dt><dd>Job status as returned by the Grid Manager (GM) and LRMS. In sequential order, the states are:<dl><dt>ACCEPTED &ndash; job submitted but not yet processed</dt><dt>PREPARING &ndash; input files are being retreived</dt><dt>SUBMITTING &ndash; interaction with LRMS ongoing</dt><dt>INLRMS &ndash; the job is transferred to the LRMS; internal staus is added by the infosystem. For PBS, possible states are:</dt> <dd>: Q &ndash; job is queued by PBS <br>: U &ndash; job is in a suspended state on a busy node (PBSPro) <br>: R &ndash; job is running <br>: E &ndash; job is finishing in PBS</dd><dt>FINISHING &ndash; output files are being transferred by the GM</dt><dt>FINISHED &ndash; job is finished; time stamp is added by the infosystem</dt><dt>CANCELING &ndash; job is being cancelled</dt><dt>DELETED &ndash; job not cleaned upon user request but removed by the GM due to expiration time</dt></dl>Each of the states can be reported with the PENDING: prefix, meaning the GM is attempting to move the job to the next state</dd><dt><b>CPU (min)</b></dt><dd>CPU time used by the job, minutes.</dd><dt><b>Memory (KB)</b></dt><dd>Memory consumed by the job, KB</dd><dt><b>CPUs</b></dt><dd>Number of processors used by the job.</dd></dl></div>");

  $lim = array( "dn", JOB_NAME, JOB_GOWN, JOB_SUBM, JOB_STAT, JOB_USET, JOB_USEM, JOB_ERRS, JOB_CPUS );
  
  $tlim = 10;
  $tout = 10;

  // Header table

  $clstring=popup("clusdes.php?host=$host&port=$port",700,620,1);

  $toptit   = "<b><i>Queue $qname at <a href=\"$clstring\">$host</a></i></b>";
  $toptable = new LmTableTop("","$toptit");

  // ldapsearch filter strings for cluster and queues
  
  $filstr = "(&(objectclass=".OBJ_AJOB.")(".JOB_EQUE."=$qname))";
  $dn     = DN_LOCAL;
  $topdn  = DN_GLOBL;
  
  // Establish connection to the requested LDAP server
  
  $ds = ldap_connect($host,$port);
  if ($ds) {
    
    // If contact OK, search for NorduGrid clusters
    
    $basedn = QUE_NAME."=".$qname.",".CLU_NAME."=".$host.",";
    $locdn  = $basedn.$dn;
    $aaa = ldap_nice_dump($ds,$locdn);
    echo "<BR>";    
    
    $sr = ldap_search($ds,$dn,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
    // Fall back to conventional LDAP
    if (!$sr) $sr = ldap_search($ds,$dn,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER);

    if ($sr) {
      $nmatch = ldap_count_entries($ds,$sr);
      if ($nmatch > 0) {
        $entries = ldap_get_entries($ds,$sr);
        $njobs   = $entries["count"];
        
        define("CMPKEY",JOB_SUBM);
        usort($entries,"ldap_entry_comp");
        
        // HTML table initialisation
        
        $ltable = new LmTable("quelist");
        
        // loop on jobs
        
        for ($i=1; $i<$njobs+1; $i++) {
          $jobdn   = rawurlencode($entries[$i]["dn"]);
          $curstat = $entries[$i][JOB_STAT][0];
          $stahead = substr($curstat,0,12);
          if ($stahead=="FINISHED at:") {
            $ftime   = substr(strrchr($curstat, " "), 1);
            $ftime   = cnvtime($ftime);
            $curstat = "FINISHED at: ".$ftime;
          }
          $uname    = $entries[$i][JOB_GOWN][0];
          $encuname = rawurlencode($uname);
	  $family   = cnvname($uname);
          
	  $jname   = htmlentities($entries[$i][JOB_NAME][0]);
	  $jobname = ($entries[$i][JOB_NAME][0]) ? $jname : "<font color=red>N/A</font>";
          $time    = ($entries[$i][JOB_USET][0]) ? $entries[$i][JOB_USET][0] : "";
          $memory  = ($entries[$i][JOB_USEM][0]) ? $entries[$i][JOB_USEM][0] : "";
          $ncpus   = ($entries[$i][JOB_CPUS][0]) ? $entries[$i][JOB_CPUS][0] : "";
	  $error   = ($entries[$i][JOB_ERRS][0]);
	  if ( $error ) $error = ( preg_match("/user/i",$error) ) ? "X" : "!";
	  $status  = "All";
          $newwin  = popup("jobstat.php?host=$host&port=$port&status=$status&jobdn=$jobdn",750,430,4);
          $usrwin  = popup("userlist.php?bdn=$topdn&owner=$encuname",700,500,5);
          
          // filling the table
          
          $lrowcont[] = "$i&nbsp;<b><font color=red>$error</font></b>";
          $lrowcont[] = "<a href=\"$newwin\">$jobname</a>";
          $lrowcont[] = "<a href=\"$usrwin\">$family</a>";
          $lrowcont[] = "$curstat";
          $lrowcont[] = "$time";
          $lrowcont[] = "$memory";
          $lrowcont[] = "$ncpus";
          $ltable->addrow($lrowcont);
          $lrowcont = array ();
        }
        $ltable->close();
      } else {
        echo "<BR><font color=red><B>No Grid jobs found</B></font>\n";
        return 1;
      }
    } else {
      echo "<BR><font color=red><B>No information found</B></font>\n";
      return 1;
    }
    ldap_free_result($sr);
    ldap_close($ds);
    return 0;
  }
  else {
    echo "<BR><font color=red><b>Server unavailable</b></font>\n";
    return 1;
  }
}

$host   = $_GET["host"];
$port   = $_GET["port"];
$qname  = $_GET["qname"];
do_quelist($host,$port,$qname);

// Done

$toppage->close();

?>
