<?php
 
// Author: oxana.smirnova@quark.lu.se

/* THIS IS NOT THE TOP MONITOR WINDOW */

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_purge.inc');
require_once('recursive_giis_info.inc');

// Setting up the page itself

$toppage = new LmDoc("sestat");

// Header table

	define(HELPTEXT,"<div align=left><dl><dt><b>Alias</b></dt><dd>Storage element alias as specified in the Information System. Maximal displayed length is 15 characters.</dd><dt><b>Space (MB)</b></dt><dd>Disk space available at the moment.</dd><dt><b>Name</b></dt><dd>Storage element name, consisting of a logical name and host name (separated by a column, &quot;:&quot;). Logical name is used only for information system purposes, to distinguish between different storage elements hosted by the same machine.</dd><dt><b>Base URL</b></dt><dd>URL for the storage element, typically a gsiftp:// protocol. Use this URL as the base to access files.</dd><dt><b>Type</b></dt><dd>Storage element type. &quot;gridftp-based&quot; indicates a disk storage with GridFTP interface.</dd></dl></div>");

//$toptit   = date("D M j G:i:s T Y");
$toptit = date("Y-m-d T H:i:s");
$toptable = new LmTableTop("<font face=\"Verdana,Geneva,Arial,Helvetica,sans-serif\">$toppage->title<br><br></font>","<i>$toptit</i>");

// The main function

/**
* @return int
* @param debug int
* @desc Retrieves the cluster load information
*/
function do_sestat ($debug=0)
{
  if ( $debug ) {
    ob_end_flush();
    ob_implicit_flush();
  }

  $tlim = 10;
  $tout = 15;
  if($debug) dbgmsg("<div align=left><i>:::> Monitor timeouts for GRIS: $tlim sec on connection and $tout sec on search <:::</i></div>");

  // Arrays defining the attributes to be returned
  
  $lim  = array( "dn", SEL_NAME, SEL_ANAM, SEL_BURL, SEL_TYPE, SEL_FREE );
   
  // ldapsearch filter strings for clusters and queues
   
  $filstr  = "(objectclass=".OBJ_STEL.")";

  // Top GIIS server: get all from the pre-defined list

  include('settings.inc');

  $ngiis = count($giislist);
  $ts1 = time(); $gentries = recursive_giis_info($giislist,"nordugrid-SE",$debug);
  $ts2 = time(); if($debug) dbgmsg("<BR><b>Got GRIS list from $ngiis top servers in ".($ts2-$ts1)." sec</b><br>");

  $nc = count($gentries);

  if ( !$nc ) {
    // NO SITES FOUND!
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the top level GIIS returned information)</font>\n";
    return 1;
  }

  $dsarray     = array ();
  $sitetag     = array (); /* a tag to skip duplicated entries */

  for ( $k = 0; $k < $nc; $k++ ) {
    $clhost = $gentries[$k]["host"];
    $clport = $gentries[$k]["port"];

    $clconn = ldap_connect($clhost,$clport);
    if ( $clconn && !$sitetag[$clhost] ) {
      array_push($dsarray,$clconn);
      $sitetag[$clhost] = 1; /* filtering tag */
      if ($debug==2) dbgmsg("$k - <i>$clhost:$clport </i>");
    }
  }

  $nhosts = count($dsarray);
  if ( !$nhosts ) {
    // NO SITES REPLY...
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the GRIS returned connection)</font>\n";
    return 1;
  }

  // Search all SEs

  $ts1 = time();
  $srarray = @ldap_search($dsarray,DN_LOCAL,$filstr,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
  $ts2 = time(); if($debug) dbgmsg("<br><b>Search for SE attributes: ".($ts2-$ts1)." sec</b><br>");

  $ctable = new LmTableSp("sestat");
           
  // Loop on SEs

  $senum = 0;
  for ( $ids = 0; $ids < $nhosts; $ids++ ) {

    $sr = $srarray[$ids];
    $ds = $dsarray[$ids];
    if ($ds && $sr) {

      $entries   = ldap_get_entries($ds,$sr);
      $nclusters = $entries["count"];      /* May be several SEs! */
      if ( !$nclusters ) continue;

      for ( $i = 0; $i < $nclusters; $i++) {
	$senum++;
	$curdn      = $entries[$i]["dn"];
	$curname    = $entries[$i][SEL_NAME][0];
	$curalias   = $entries[$i][SEL_ANAM][0];
	$curspace   = $entries[$i][SEL_FREE][0];
	$cururl     = $entries[$i][SEL_BURL][0];
	$curtype    = $entries[$i][SEL_TYPE][0];
	if ($debug==2) dbgmsg("<i>$senum: <b>$curname</b> is found</i><br>");
	if ( strlen($curalias) > 15 ) $curalias = substr($curalias,0,15) . ">";
	//      $clstring  = popup("clusdes.php?host=$curname&port=2135",700,620,1);
	
	$rowcont[] = "$senum";
	$rowcont[] = "<b>$curalias</b>";
	$rowcont[] = "$curspace";
	$rowcont[] = "$curname";
	$rowcont[] = "$cururl";
	$rowcont[] = "$curtype";
	//      $rowcont[] = "<a href=\"$jrstring\"><img src=\"icon_bar.php?x=".$clusload."&xg=".$gridload."&y=13&text=".$tstring."\" vspace=2 hspace=3 border=0 alt=\"$gridjobs+$localrun\" width=200 height=13></a>";
	$ctable->addrow($rowcont);
	$rowcont = array ();
      }
    }
    $entries  = array();
    $jentries = array();
    $gentries = array();
  }
  $ctable->close();

  return 0;

}

$debug = $_GET["debug"];
do_sestat($debug);


// Done

$toppage->close();


?>
