<?php

// Author: oxana.smirnova@quark.lu.se

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('cnvtime.inc');
require_once('cnvname.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_nice_dump.inc');
require_once('recursive_giis_info.inc');
require('ldap_purge.inc');

// Setting up the page itself

$toppage = new LmDoc("userlist");

/**
 * @return int
 * @param bdn string
 * @param owner string
 * @desc Retrieves the list of user's jobs
 */
function do_userlist ($bdn="mds-vo-name=NorduGrid,o=Grid",$owner)
{
  /**
   * FUNCTION DO_USERLIST (string bdn, string owner)
   * Retrieves the user jobs information from the NorduGrid
   * Uses LDAP functions of PHP
   *
   * Author: O.Smirnova (June 2002)
   * inspired by the LDAPExplorer by T.Miao
   *
   * input:
   * bdn (base DN, def. mds-vo-name=NordiGrid,o=Grid)
   * owner (DN of a user)
   *
   * output:
   * an HTML table, containing:
   * per each cluster:
   * - list of jobs
   */
	
  include('settings.inc');
	
  // Array defining the attributes to be returned
	
  $lim  = array( "dn", USR_USSN, USR_CPUS, USR_QUEU, USR_DISK );
  $ulim = array( "dn", JOB_NAME, JOB_EQUE, JOB_ECLU, JOB_GOWN, JOB_SUBM, JOB_STAT, JOB_USET, JOB_ERRS, JOB_CPUS );
	
  $tlim = 20;
  $tout = 20;

  $uname  = rawurldecode($owner);
  $family = cnvname($uname);
  $uname  = addslashes($uname); // In case $uname contains escape characters
  
  // ldapsearch filter string for jobs
	
  $filter  = "(&(objectclass=".OBJ_USER.")(".USR_USSN."=$uname))";
  $ufilter = "(&(objectclass=".OBJ_AJOB.")(".JOB_GOWN."=$uname))";
	
  // Header table
	
  define(HELPTEXT,"<div align=left><dl><dl><dt><b>Cluster:queue</b></dt><dd>CLICKABLE. Names of clusters and respective queues (separated by a column, &quot;:&quot;) where a user is authorized to submit jobs. If a user is not authorized, message &quot;<b><font color=red>Not authorised at host ...</font></b>&quot; is displayed. Click a cluster name to get a detailed cluster description. Click on a queue name to get a detailed queue description. </dd><dt><b>Free CPUs</b></dt><dd>Number of free CPUs available in a given queue for the user at this moment of time, optionally appended with the upper time limit value (in minutes). For example, &quot;3&quot; means 3 CPUs available for a job of unlimited running time; &quot;4:360&quot; indicates there are 4 CPUs available for jobs not longer than 6 hours; &quot;10:180 30&quot; means there are 10 CPUs available for jobs not exceeding 3 hours, plus 30 CPUs available for jobs of any length; &quot;0&quot; means there are no CPUs available at the moment, and the jobs will be placed in a waiting queue.</dd><dt><b>Exp. queue length</b></dt><dd>Number of jobs expected to sit ahead of a new submitted job (for this user) in a waiting queue. Number of &quot;0&quot; means the job is expected to be executed immediately. <b>NB!</b> This is only an estimation, which can be overwritten by local policies.</dd><dt><b>Free disk (MB)</b></dt><dd>Disk space available for the user in a given queue (in Megabytes). <b>NB!</b> This is only an estimation, as most clusters do not provide fixed disk quotas.</dd><dt><b>Job name</b></dt><dd>CLICKABLE. Name of a job as assigned by the job owner.<br>  <font color=red>N/A</font> indicates that user did not assign any name. <br> <font color=red><b>X</b></font> indicates that the job has been killed by the owner<br> <font color=red><b>!</b></font> indicates that the job failed in the system<br> Click on a name to get a detailed description of the job.</dd><dt><b>Status</b></dt><dd>Job status as returned by the Grid Manager (GM) and LRMS. In sequential order, the states are:<dl><dt>ACCEPTED &ndash; job submitted but not yet processed</dt><dt>PREPARING &ndash; input files are being retreived</dt><dt>SUBMITTING &ndash; interaction with LRMS ongoing</dt><dt>INLRMS &ndash; the job is transferred to the LRMS; internal staus is added by the infosystem. For PBS, possible states are:</dt> <dd>: Q &ndash; job is queued by PBS <br>: U &ndash; job is in a suspended state on a busy node (PBSPro) <br>: R &ndash; job is running <br>: E &ndash; job is finishing in PBS</dd><dt>FINISHING &ndash; output files are being transferred by the GM</dt><dt>FINISHED &ndash; job is finished; time stamp is added by the infosystem</dt><dt>CANCELING &ndash; job is being cancelled</dt><dt>DELETED &ndash; job not cleaned upon user request but removed by the GM due to expiration time</dt></dl>Each of the states can be reported with the PENDING: prefix, meaning the GM is attempting to move the job to the next state</dd><dt><b>CPU (min)</b></dt><dd>CPU time used by the job, minutes.</dd><dt><b>Cluster</b></dt><dd>CLICKABLE. Name of the cluster at which the job is being executed. Click on a cluster name to get detailed information about the cluster.</dd><dt><b>Queue</b></dt><dd>CLICKABLE. Name of the batch queue in which the job is/was executed. Click on a queue name to get detailed information about the queue, including running, queued, and finished tasks.</dd><dt><b>CPUs</b></dt><dd>Number of processors used by the job.</dd></dl></div>");

  $toptable = new LmTableTop("","Information for $family");

  $gentries = recursive_giis_info($giislist,"cluster",0);
  $nc       = count($gentries);
  if ( !$nc ) {
    // NO SITES FOUND!
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the top level GIIS returned information)</font>\n";
    return 1;
  }

  $dsarray = array ();
  $hnarray = array ();
  $sitetag = array (); /* a tag to skip duplicated entries */

  for ( $k = 0; $k < $nc; $k++ ) {
    $clhost = $gentries[$k]["host"];
    $clport = $gentries[$k]["port"];

    $clconn = ldap_connect($clhost,$clport);
    if ( $clconn && !$sitetag[$clhost] ) {
      array_push($dsarray,$clconn);
      array_push($hnarray,$clhost);
      $sitetag[$clhost] = 1; /* filtering tag */
    }
  }

  $nhosts = count($dsarray);
  if ( !$nhosts ) {
    // NO SITES REPLY...
    echo "<BR><font color=red><B>Information System is empty</B><br>(None of the GRIS returned connection)</font>\n";
    return 1;
  }

  // Search all clusters for (a) allowed queues and (b) for user jobs

  $uiarray = @ldap_search($dsarray,DN_LOCAL,$filter,$lim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
  $srarray = @ldap_search($dsarray,DN_LOCAL,$ufilter,$ulim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
           
  // Loop on results: first go queues

  // HTML table initialisation
  $utable   = new LmTable("userres");
  $urowcont = array();
  
  for ( $ids = 0; $ids < $nhosts; $ids++ ) {

    $ui    = $uiarray[$ids];
    $hn    = $hnarray[$ids];
    $dst   = $dsarray[$ids];
    $curl  = popup("clusdes.php?host=$hn&port=2135",700,620,1);

    if ($dst && $ui) {

      $nqueues = @ldap_count_entries($dst,$ui);
      if ($nqueues > 0) {
				
	// If there are valid entries, tabulate results
				
	$allres  = ldap_get_entries($dst,$ui);
	$results = ldap_purge($allres);
	$nqueues = $allres["count"];
				
	//   define("CMPKEY",USR_CPUS);
	//   usort($allres,"ldap_entry_comp");
				
	// loop on queues
				
	for ($j=0; $j<$nqueues; $j++) {
	  $parts = ldap_explode_dn($allres[$j]["dn"],0);
	  foreach ($parts as $part) {
	    $pair = explode("=",$part);
	    switch ( $pair[0] ) {
	    case CLU_NAME:
	      $ucluster = $pair[1];
	      break;
	    case QUE_NAME:
	      $uqueue   = $pair[1];
	      break;
	    }
	  }
	  $qurl  = popup("quelist.php?host=$ucluster&port=2135&qname=$uqueue",750,430,6);
	  $curl  = popup("clusdes.php?host=$ucluster&port=2135",700,620,1);
	  $fcpu  = $allres[$j][USR_CPUS][0];
	  $fdisk = $allres[$j][USR_DISK][0];
	  $exque = $allres[$j][USR_QUEU][0];
	  $urowcont[] = "<a href=\"$curl\">$ucluster</a>:<a href=\"$qurl\">$uqueue</a>";
	  $urowcont[] = $fcpu;
	  $urowcont[] = $exque;
	  $urowcont[] = $fdisk;
	  $utable->addrow($urowcont);
	  $urowcont = array();
	}
      } else {
	$utable->adderror("<B>Not authorised at host <a href=\"$curl\">$hn</a></B>");
      }
    } else {
      $utable->adderror("<B>Host <a href=\"$curl\">$hn</a> does not answer</B>");
    }
    @ldap_free_result($ui);
  }
  $utable->close();
  echo "<BR>\n";

  // HTML table initialisation
  $jtable  = new LmTable("userlist");
  $rowcont = array();
  $jcount  = 0;
				
  for ( $ids = 0; $ids < $nhosts; $ids++ ) {

    $sr  = $srarray[$ids];
    $dst = $dsarray[$ids];
    if ($dst && $sr) {
			
      // If search returned, check that there are valid entries
			
      $nmatch = @ldap_count_entries($dst,$sr);
      if ($nmatch > 0) {
	// If there are valid entries, tabulate results
				
	$allentries = ldap_get_entries($dst,$sr);
	$entries    = ldap_purge($allentries);
	$njobs      = $entries["count"];
				
	define("CMPKEY",JOB_SUBM);
	usort($entries,"ldap_entry_comp");
				
	// loop on jobs
				
	for ($i=1; $i<$njobs+1; $i++) {
	  $jobdn   = rawurlencode($entries[$i]["dn"]);
	  $curstat = $entries[$i][JOB_STAT][0];
	  $stahead = substr($curstat,0,12);
	  if ($stahead=="FINISHED at:") {
	    $ftime   = substr(strrchr($curstat, " "), 1);
	    $ftime   = cnvtime($ftime);
	    $curstat = "FINISHED at: ".$ftime;
	  }
	  $jname    = htmlentities($entries[$i][JOB_NAME][0]);
	  $jobname  = ($entries[$i][JOB_NAME][0]) ? $jname : "<font color=red>N/A</font>";
	  $queue    = ($entries[$i][JOB_EQUE][0]) ? $entries[$i][JOB_EQUE][0] : "N/A";
	  $cluster  = ($entries[$i][JOB_ECLU][0]) ? $entries[$i][JOB_ECLU][0] : "N/A";
	  $time     = ($entries[$i][JOB_USET][0]) ? $entries[$i][JOB_USET][0] : "N/A";
	  $ncpus    = ($entries[$i][JOB_CPUS][0]) ? $entries[$i][JOB_CPUS][0] : "";
	  $error    = ($entries[$i][JOB_ERRS][0]);
	  if ( $error ) $error = ( preg_match("/user/i",$error) ) ? "X" : "!";
	  $newwin   = popup("jobstat.php?host=$cluster&port=2135&status=$status&jobdn=$jobdn",750,430,4);
	  $quewin   = popup("quelist.php?host=$cluster&port=2135&qname=$queue",750,430,6);
	  $clstring = popup("clusdes.php?host=$cluster&port=2135",700,620,1);
	  $jcount++;
					
	  // filling the table
					
	  $rowcont[] = "$jcount&nbsp;<b><font color=red>$error</font></b>";
	  $rowcont[] = "<a href=\"$newwin\">$jobname</a>";
	  $rowcont[] = "$curstat";
	  $rowcont[] = "$time";
	  $rowcont[] = "<a href=\"$clstring\">$cluster</a>";
	  $rowcont[] = "<a href=\"$quewin\">$queue</a>";
	  $rowcont[] = "$ncpus";
	  $jtable->addrow($rowcont);
	  $rowcont = array();
	}
      }
      //      else {
      //	$jtable->adderror("<B>No recent jobs by $family found</B>");
      //      }
    }
    //    else {
    //      $jtable->adderror("<B>No information about $family found</B>");
    //    }
    @ldap_free_result($sr);
  }
  if ( !$jcount ) $jtable->adderror("<B>No recent jobs by $family found</B>");
  $jtable->close();

  return 0;
}

$owner = $_GET["owner"];
do_userlist(DN_GLOBL,$owner);

// Done

$toppage->close();

?>
