<?php
 
// Author: oxana.smirnova@quark.lu.se

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('settings.inc');
//require_once('utf2cyr.inc');

// Setting up the page itself

$toppage = new LmDoc("vousers");
define("TOPTIT",$toppage->title);

$host  = $_GET["host"];
$port  = $_GET["port"];
$vo    = $_GET["vo"];
$group = $_GET["group"];
/**
 * @return unknown
 * @param host string
 * @param port int
 * @desc List all the users of a VO
 */
function do_vousers ($host="grid-vo.nordugrid.org",$port=389,$vo,$group)
{
  /**
   * FUNCTION DO_VOUSERS ()
   * List all the users of the NorduGrid VO
   * Uses LDAP functions of PHP
   * 
   * Author: O.Smirnova (June 2002)
   * inspired by the LDAPExplorer by T.Miao
   * 
   * input:
   * host (grid-vo.nordugrid.org)
   * port (389)
   * 
   * output:
   * an HTML table, containing list of users
   */

  // ldap search filter string for jobs

  $ufilter = "(objectclass=".OBJ_PERS.")";
  $ulim    = array ( "dn", VO_USSN, VO_USCN, VO_DESC, VO_INST, VO_MAIL );
  
  $tlim = 10;
  $tout = 15;

  // Establish connection to the requested VO server

  $ds = ldap_connect($host,$port);

  if ($ds) {
    
    // If contact OK, search for people

    $sr = @ldap_search($ds,$vo,$ufilter,$ulim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
    if ($sr) {
      
      // If search returned, check that there are valid entries
      
      $nmatch = @ldap_count_entries($ds,$sr);
      if ($nmatch > 0) {
        
        // Header table
        
	define(HELPTEXT,"<div align=left><dl><dt><b>Name</b></dt><dd>CLICKABLE. User name as specified in Grid certificate.  Click on a name to get the list of all the resources available for this user and all the jobs by this user which are currently in the system.</dd><dt><b>Affiliation</b></dt><dd>Users home institute as entered by a VO manager. Can be empty.</dd><dt><b>E-mail</b></dt><dd>CLICKABLE. Users e-mail as entered by a VO manager. Can be empty. Click the address to send an e-mail to the user.</dd></dl></div>");

        $toptable = new LmTableTop("","<b><i>".TOPTIT."</i></b>");
        
        // If there are valid entries, tabulate results
        
        $entries = @ldap_get_entries($ds,$sr);
        $nusers  = $entries["count"];
        
        define("CMPKEY",VO_USSN);
        usort($entries,"ldap_entry_comp");
        
        // HTML table initialization
        
        $utable = new LmTable("vousers");
        
        // loop on users
        
	$uscnt = 0;
        for ($i=1; $i<$nusers+1; $i++) {
	  $dn = $entries[$i]["dn"];
	  if ( $group ) {
	    $newfilter = "(member=$dn)";
	    $newdn     = $group.",".$vo;
	    $newlim    = array("dn");
	    $gcheck    = @ldap_search($ds,$newdn,$newfilter,$newlim,0,0,$tlim,LDAP_DEREF_NEVER,$tout);
	    if ( !ldap_count_entries($ds,$gcheck) ) continue;
	  }
          $usname   = $entries[$i][VO_USCN][0];
	  //          $usname   = utf2cyr($usname,"n");
	  //	  $ussn     = strstr($entries[$i][VO_DESC][0],"/");
	  $ussn     = substr(strstr($entries[$i][VO_DESC][0],"subject="),8);
	  $ussn     = trim($ussn);
          $encuname = rawurlencode($ussn);
          $org      = $entries[$i][VO_INST][0];
	  //	  $org      = utf8_decode($org);
          $mail     = $entries[$i][VO_MAIL][0];
          $mailstr  = "mailto:".$mail;
          $usrwin   = popup("userlist.php?owner=$encuname",700,500,5);
          
          // filling the table
          
	  $uscnt++;
	  $urowcont[] = $uscnt;
          $urowcont[] = "<a href=\"$usrwin\">$usname</a>";
          $urowcont[] = "$org";
          $urowcont[] = "<a href=\"$mailstr\">$mail</a>";
          $utable->addrow($urowcont);
          $urowcont = array ();
        }
        $utable->close();
      }
      else {
        echo "<BR><font color=red><B>No users found</B></font>\n";
        return 1;
      }
    } else {
      echo "<BR><font color=red><B>No information available</B></font>\n";
      return 1;
    }
    ldap_free_result($sr);
    ldap_close($ds);
    return 0;
  } else {
    echo "<BR><font color=red><b>Server unavailable</b></font>\n";
    return 1;
  }
}

do_vousers($host,$port,$vo,$group);

// Done

$toppage->close();

?>
