<?php
 
// Author: oxana.smirnova@quark.lu.se

/* THIS IS NOT THE TOP MONITOR WINDOW */

require_once('headfoot.inc');
require_once('lmtable.inc');
require_once('comfun.inc');
require_once('toreload.inc');
require_once('ldap_purge.inc');

// Setting up the page itself

  define(HELPTEXT,"<div align=left><dl><dt><b>Virtual Organisation</b></dt><dd>CLICKABLE. Group of users, typically sharing common activities and resources, authorised at at least one NorduGrid-enabled site. Click on the name to get the list of group members.</dd><dt><b>Members</b></dt><dd>Number of group members.</dd><dt><b>Served by</b></dt><dd>LDAP server that supports the group membership database.</dd></dl></div>");

$toppage = new LmDoc("volist");

// Header table

$toptit = date("Y-m-d T H:i:s");
$toptable = new LmTableTop("<font face=\"Verdana,Geneva,Arial,Helvetica,sans-serif\">$toppage->title<br><br></font>","<i>$toptit</i>");

// The main function

$vos = array (
	      array (
		     "name"   => "NorduGrid members",
		     "server" => "grid-vo.nordugrid.org",
		     "port"   => "389",
		     "dn"     => "ou=people,dc=nordugrid,dc=org"
		     ),
	      array (
		     "name"   => "NorduGrid guests",
		     "server" => "grid-vo.nordugrid.org",
		     "port"   => "389",
		     "dn"     => "ou=guests,dc=nordugrid,dc=org"
		     ),
	      array (
		     "name"   => "NorduGrid tutorials",
		     "server" => "grid-vo.nordugrid.org",
		     "port"   => "389",
		     "dn"     => "ou=tutorial,dc=nordugrid,dc=org"
		     ),
	      /*
	      array (
		     "name"   => "NorduGrid services",
		     "server" => "grid-vo.nordugrid.org",
		     "port"   => "389",
		     "dn"     => "ou=services,dc=nordugrid,dc=org"
		     ),
	      */
	      array (
		     "name"   => "BaBar",
		     "server" => "babar-vo.gridpp.ac.uk",
		     "port"   => "389",
		     "dn"     => "ou=babar,dc=gridpp,dc=ac,dc=uk"
		     ),
	      array (
		     "name"   => "EDG ALICE",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=alice,dc=eu-datagrid,dc=org"
		     ),
	      array (
		     "name"   => "EDG ATLAS",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=atlas,dc=eu-datagrid,dc=org"
		     ),
	      array (
		     "name"   => "EDG CMS",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=cms,dc=eu-datagrid,dc=org"
		     ),
	      array (
		     "name"   => "EDG LHC-B",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=lhcb,dc=eu-datagrid,dc=org"
		     ),
	      array (
		     "name"   => "EDG D0",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=dzero,dc=eu-datagrid,dc=org",
		     "group"  => "ou=testbed1"
		     ),
	      array (
		     "name"   => "EDG Earth Observation",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=earthob,dc=eu-datagrid,dc=org"
		     ),
	      array (
		     "name"   => "EDG Genomics",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=biomedical,dc=eu-datagrid,dc=org",
		     "group"  => "ou=genomics"
		     ),
	      array (
		     "name"   => "EDG Medical Imaging",
		     "server" => "grid-vo.nikhef.nl",
		     "port"   => "389",
		     "dn"     => "o=biomedical,dc=eu-datagrid,dc=org",
		     "group"  => "ou=medical imaging"
		     ),
	      array (
		     "name"   => "EDG ITeam",
		     "server" => "marianne.in2p3.fr",
		     "port"   => "389",
		     "dn"     => "o=testbed,dc=eu-datagrid,dc=org",
		     "group"  => "ou=ITeam"
		     ),
	      array (
		     "name"   => "EDG TSTG",
		     "server" => "marianne.in2p3.fr",
		     "port"   => "389",
		     "dn"     => "o=testbed,dc=eu-datagrid,dc=org",
		     "group"  => "ou=TSTG"
		     ),
	      array (
		     "name"   => "EDG Tutorials",
		     "server" => "marianne.in2p3.fr",
		     "port"   => "389",
		     "dn"     => "o=testbed,dc=eu-datagrid,dc=org",
		     "group"  => "ou=EDGtutorial"
		     ),
	      array (
		     "name"   => "EDG WP6",
		     "server" => "marianne.in2p3.fr",
		     "port"   => "389",
		     "dn"     => "o=testbed,dc=eu-datagrid,dc=org",
		     "group"  => "ou=wp6"
		     )
	      );
	      
$votable = new LmTableSp("volist");
$rowcont = array ();
foreach ( $vos as $contact ) {
  $server    = $contact["server"];
  $port      = $contact["port"];
  $dn        = $contact["dn"];
  $group     = $contact["group"];

  $nusers    = "";
  $ds = ldap_connect($server,$port);
  if ($ds) {
    if ( $group ) {
      $newfilter = "(objectclass=*)";
      $newdn     = $group.",".$dn;
      $newlim    = array("dn","member");
      $sr        = @ldap_search($ds,$newdn,$newfilter,$newlim,0,0,10,LDAP_DEREF_NEVER,10);
      $groupdesc = @ldap_get_entries($ds,$sr);
      $nusers    = $groupdesc[0]["member"]["count"];
    } else {
      $sr = @ldap_search($ds,$dn,"(objectclass=organizationalPerson)",array("dn"),0,0,10,LDAP_DEREF_NEVER,10);
      if ($sr) $nusers = @ldap_count_entries($ds,$sr);
    }
  }

  $vostring  = popup("vo-users.php?host=$server&port=$port&vo=$dn&group=$group",750,300,6);
  $rowcont[] = "<a href=\"$vostring\">".$contact["name"]."</a>";
  $rowcont[] = $nusers;
  $rowcont[] = $server;

  $votable->addrow($rowcont);
  $rowcont = array ();
}

$votable->close;

$toppage->close;

     /*

group http://www.nbi.dk/~waananen/ngssc2003.txt

### Datagrid VO Groups and their user mappings
     */
?>