<?php

// Author: oxana.smirnova@quark.lu.se

/**
 * A  function purging any LDAP
 * search result with identical DNs
 */

/**
* @return array
* @param allentries array
* @param attr string
* @desc Purges identical $attr entries from LDAP search result
*/
function ldap_purge($allentries,$attr="dn")
{
  
  $dnstore = array(); /* array to store unique attributes */
  $entries = array(); /* purged array to be returned */

  $ninp = $allentries["count"];
  
  $storesize = 0;

  for ($i = 0; $i < $ninp; $i++) {
    $curdn = $allentries[$i][$attr];
    $curdn = str_replace(" ","",$curdn); // get rid of blanks in DN
    if ( !in_array($curdn,$dnstore) ) {
      array_push($dnstore,$curdn);
      $storesize++;
      array_push($entries,$allentries[$i]);
    }
  }

  $entries["count"] = $storesize;

  return $entries;

}

?>
