<?php 

/*

Author: O.Smirnova, oxana.smirnova@cern.ch (C) 2003

*/

/**
 * @return void
 * @param lcdump array
 * @param loclist array
 * @param search string
 * @param lpath string
 * @desc Loops over the list of LFNs, splitting them logically into levels
 */
function dumplevel($lcdump,$search,$lpath) 
{
  /**
   * - This function is called per collection and dumps
   *   one pseudo-level at a time.
   * - Pseudo-level corresponds to a physical directory 
   *   on a storage
   */

  global $rcserver;
  global $rcport;
  global $rcdn;
  global $rcc;

  $sefilstr = "(&(objectclass=GlobusReplicaLocation)(filename=*$search*))";
  $selim    = array(
		    "filename",
		    "dn",
		    "uc",
		    "path"
		    );
  
  //  $semask = "(objectclass=GlobusReplicaLocation)";
  //  $seatts = array(
  //		    "dn",
  //		    "uc"
  //		    );
  
  $self  = $_SERVER['PHP_SELF'];

  //       
  $topdn   = strstr($rcdn,"rc");
  $tdnpart = ldap_explode_dn($topdn,1);
  $rcname  = $tdnpart[0];
  $contact = "?rcserver=$rcserver&rcport=$rcport&rcdn=".rawurlencode($topdn)."&search=$search&lpath=";
  $toplink = $self.$contact;

  //     
  $collname = $lcdump["lc"][0];
  $colldn   = $lcdump["dn"];
  if ( !$collname ) {
    $dnparts  = ldap_explode_dn($colldn,1);
    $collname = $dnparts[0];
  }
  $colllink = "rcserver=$rcserver&rcport=$rcport&rcdn=".rawurlencode($colldn)."&search=$search&lpath=";
  $back     = $self."?".rawurlencode($colllink.$lpath);

  $filcount = $lcdump["filename"]["count"];
  if ( !$filcount ) $filcount = "No";
  
  // :      
  echo "<BR><div align=center><table width=80% cellspacing=0>\n";
  echo "<tr bgcolor=#ffcc66 valign=middle><td colspan=2 align=left>\n";
  echo "Logical Collection <b>$collname</b> at <a href=\"$toplink\">$rcname RC</a>&nbsp;($filcount&nbsp;entries)</i><BR>\n";

  if ( $filcount != "No" ) {

    //   ( ),     ( )
    $loclist = array ();
    $loc     = ldap_search($rcc,$rcdn,$sefilstr,$selim);
    if ( $loc ) $loclist = ldap_get_entries($rcc,$loc);
    ldap_free_result($loc);

    //  ,     ()
    //    $selist = array ();
    //    $sename = "";
    //    $seres  = ldap_list($rcc,$rcdn,$semask,$seatts);
    //    if ( $seres ) $selist = ldap_get_entries($rcc,$seres);
    //    ldap_free_result($seres);
    //    $nses = $selist["count"];
    //    for ( $k = 0; $k < $nses; $k++ ) $sename .= $selist[$k]["uc"][0].",";
    //    if ( strlen($sename) ) $sename = substr($sename,0,-1);
    
    //   :     
    $locfiles = array ();
    $locdirs  = array ();
    for ( $j = 0; $j < $filcount; $j++ ) {
      $entry = $lcdump["filename"][$j];

      //    
      $match = 1;
      if ( $search != "*") $match = preg_match("/$search/i",$entry);
      if ( !$match ) continue;

      // ""     
      $entry = trim($entry);
      if ( substr($entry,0,1) == "/" ) $entry = substr($entry,1);

      $lfn   = $entry;

      //  ,    ;     
      if ( $lpath != "" ) {
	$split = explode($lpath,$entry);
	if ( $split[0] == $entry ) continue;
	$entry = $split[1];
      }
      
      // :     
      $path   = explode("/",$entry);
      $depth  = count($path);
      $topdir = $path[0];

      //   :     
      if ( $depth == 1 ) {
	$pfn = "<font color=red><i>Consult <a href=\"fileinfo.php?lfn=$logname&back=$back\">file info</a></i></font>";
	if ( $filcount < 10000 || $lpath != "" ) $pfn = getpfn($lfn,$loclist);
	//	$pfn = getpfn($lfn,$loclist);
	$locfiles[$entry]["lfn"] = $lfn;
	$locfiles[$entry]["pfn"] = $pfn;
      } else {
	$locdirs[$topdir] += 1;
      }
    }

    ksort($locfiles);
    ksort($locdirs);

    /**
     *  ; 
     */
    
    //    
    if ( $lpath == "" ) {
      echo "TOP\n";
    } else {
      $godown = "";
      $chain  = explode("/",$lpath);
      echo "<p><a href=\"$self?$colllink\">TOP</a>";
      foreach ( $chain as $clink ) {
	$godown .= "$clink/";
	echo "/<a href=\"$self?$colllink$godown\">$clink</a>";
      } 
    }
    
    //   
    echo "</td></tr>\n";
    echo "<tr><td bgcolor=#ffffcc><b>Logical Dataset</b></td>
             <td CLASS=PFN bgcolor=#ffffcc><b>Physical instances</b></td></td>\n";
    
    //   - -
    foreach ( $locdirs as $direntry => $dirsize ) {
      //    
      $dirurl = $self."?".$colllink.$lpath.$direntry."/";
      echo "<tr><td><a href=\"$dirurl\"><img src=folder.gif width=20 height=22 border=0 align=top alt=\" \">&nbsp;$direntry</a></td>
                <td CLASS=PFN><i>Dataset of $dirsize members</i></td></tr>\n";
      ob_flush();
    }
    
    //   :     
    foreach ( $locfiles as $filentry => $names ) {
      $location = $names["pfn"];
      $logname  = $names["lfn"];
      echo "<tr><td nowrap valign=top><a href=\"fileinfo.php?lfn=$logname&back=$back\">
          <img src=binary.gif width=20 height=22 border=0 align=top alt=\" \">&nbsp;$filentry</a></td>
          <td CLASS=PFN valign=top>$location</td></tr>\n";
      ob_flush();
      //           href=\"javascript:fileinfo('$logname','$location');\">$filentry</a></td>
    }
  }
  echo "</table></div>\n";
  
  return 0;
}

/**
 * @return pfnlist
 * @param lfn string
 * @param loclist array
 * @desc Finds physical locations for an LFN
 */
function getpfn($lfn,$loclist)
{

  $pfnlist = "";

  $nloc = $loclist["count"];
  
  // Loop on locations
  for ( $i = 0; $i < $nloc; $i++ ) {
    $sedn   = $loclist[$i]["dn"];
    $sename = $loclist[$i]["uc"][0];    
    $sepath = $loclist[$i]["path"][0];
    //    $check  = ldap_compare($rcc, $sedn, "filename", $lfn);
    $check  = in_array($lfn,$loclist[$i]["filename"]);
    if ( $check ) $pfnlist .= $sename.$sepath."<BR>";
  } /* loop on locations */
  
  if ( strlen($pfnlist) == 0 ) {
    $pfnlist = "<i><font color=red>No physical instance</font></i>";
  } else {
    $pfnlist = substr($pfnlist,0,-4);
  }
  return $pfnlist;
}

/**
 * @return void
 * @param rcserver string
 * @param rcport integer
 * @param rcdn string
 * @param search string
 * @param lpath string
 * @desc Main Globus RC browsing function
 */
function listrc($rcserver,$rcport,$rcdn,$search,$lpath)
{

  $rcdn = rawurldecode($rcdn);

  global $rcserver;
  global $rcport;
  global $rcdn;
  global $rcc;

  /*
  $psearch = ( $_POST["mask"] ) ? $_POST["mask"] : "*";
  $fromform = $_POST["submit"];
  if ( $fromform == "Submit" ) $search = $psearch;
  */

  $filstr = "(&(objectclass=GlobusReplicaLogicalCollection)(filename=*$search*))";
  $lim    = array(
		  "filename",
		  "dn",
		  "lc"
		  );
  
  $self    = $_SERVER['PHP_SELF'];
  $contact = $self."?rcserver=$rcserver&rcport=$rcport&rcdn=$rcdn&search=$search&lpath=";
  
  echo "<HTML>\n<HEAD><TITLE>Replica Catalog Browser</TITLE>\n";
  echo "<META HTTP-EQUIV=\"EXPIRE\" CONTENT=\"Mon, 01 Jan 1970 00:00:00 GMT\">\n";
  include ( 'style.inc' );
  echo "<SCRIPT SRC=\"fileinfo.js\"></SCRIPT>\n";
  echo "</HEAD><BODY>\n";

  if ( !$rcserver ||
       !$rcport   ||
       !$rcdn ) {
    
    include("collections.inc");
    
    echo "<BR><div CLASS=TITLE><B>REPLICA CATALOGUES BROWSER</B></DIV>\n";
    echo "<BR><div align=center><table width=80% cellspacing=0>\n";
    echo "<tr bgcolor=#ffcc66 valign=middle><td align=middle>Virtual Organisations</td></tr>\n";

    ksort($rcs);
    foreach ( $rcs as $vo => $params ) {
      $rcserver = $params["rcserver"];
      $rcport   = $params["rcport"];
      $rcdn     = $params["rcdn"];
      $contact  = $self."?rcserver=$rcserver&rcport=$rcport&rcdn=$rcdn&search=&lpath=";
      
      echo "<tr><td valign=middle align=center><a href=\"".$contact."\">$vo</a></td></tr>\n";
    }
    echo "</table>\n";
    echo "<BR><p align=right><font size=1>Contact: <a href=\"mailto:oxana.smirnova@cern.ch\">Oxana Smirnova</a></FONT></p></BODY></HTML>\n";
    return 0;
  }

  $rcatts = ldap_explode_dn($rcdn,1);
  $rcname = $rcatts[0];
  // Contact the RC server
  $rcc = ldap_connect($rcserver,$rcport);
  if ( !$rcc ) {
    echo "<b><i>Server ".$rcserver." can not be reached at port ".$rcport."</i></b><BR>\n";
  } else {
    
    // Find logical collections: names and files
    $lc = ldap_search($rcc,$rcdn,$filstr,$lim);
  
    if ( !$lc ) {
      echo "<b><i>Replica Catalog ".$rcname." has no logical collections</i></b><BR>\n";
    } else {
      $lclist = ldap_get_entries($rcc,$lc);
      $ncoll  = $lclist["count"];

      /*      
      echo "<div CLASS=HEADER>\n";
      echo "<FORM action=\"$contact\" enctype=\"application/x-www-form-urlencoded\" method=\"POST\">\n";
      echo "Search mask:&nbsp;<input type=text name=\"mask\" size=10 value=$search>\n";
      echo "&nbsp;<input type=\"submit\" name=\"submit\" value=\"Submit\">\n";
      echo "</form></DIV>\n";
      */
  
      // Loops on logical collections

      if ( substr($rcdn,0,2) == "rc" ) { /* TOP level; list only LCs */
	echo "<div CLASS=TITLE><b>Replica Catalog <i>$rcname</i></b><BR><BR>\n";
	echo "<BR><U>Logical&nbsp;collections:</U><BR><BR>\n";
	echo "<table CLASS=SIMPLE align=center>\n";
	for ( $ip = 0; $ip < $ncoll; $ip++ ) {
	  $collname = $lclist[$ip]["lc"][0];
	  $colldn   = $lclist[$ip]["dn"];
	  if ( !$collname ) {
	    $dnparts  = ldap_explode_dn($colldn,1);
	    $collname = $dnparts[0];
	  }
	  $aastring = "rcserver=".$rcserver."&rcport=".$rcport."&rcdn=".rawurlencode($colldn)."&search=".$search."&lpath=";
	  $lcstring = $self."?".$aastring;
	  echo "<tr><td CLASS=SIMPLE><a href=\"$lcstring\">$collname</a></td></tr>";
	} /* loop on collections */
	echo "</table></DIV>\n";
      } else {
	for ( $i = 0; $i < $ncoll; $i++ ) dumplevel($lclist[$i],$search,$lpath);
      } /* check which level it is */
    } /* check if there are collections */
    ldap_free_result($lc);
  } /* connect to server */

  echo "<DIV CLASS=FOOTER><a href=\"$self\">List of Virtual Organisations worldwide</a></DIV>\n";
  echo "</BODY></HTML>\n";

  return 0;
}

listrc($rcserver,$rcport,$rcdn,$search,$lpath);

?>
