<?php
 
// Author: oxana.smirnova@quark.lu.se

/**
 * Quite a universal function, dumping any LDAP
 * search result in a nice fashion
 */

/**
 * @return string
 * @param ds string
 * @param dn string
 * @param exclude array
 * @desc Dumps all the LDAP attributes (except those in exclude) returned by a search in an HTML table
 */
function ldap_nice_dump() {

  $tlim = 30;
  $tout = 30;

  $strings = func_get_arg(0);
  $ds      = func_get_arg(1);
  $dn      = func_get_arg(2);
  if ( func_num_args() == 4 ) $exclude = func_get_arg(3);
  
  // Descriptive array of known MDS attributes (optional)
  $mdsattr = &$strings["mdsattr"];
  $isattr  = &$strings["isattr"];
  $errors  = &$strings["errors"];
  
  // Plain LDAP dump for the DN
  $filstr = "(objectclass=*)";
  $sr     = @ldap_search($ds,$dn,$filstr,array("*"),0,0,$tlim,LDAP_DEREF_NEVER,$tout);

  if ($sr) {
    
    // If search returned, check that there are valid entries
    
    $nmatch = ldap_count_entries($ds,$sr);
    if ($nmatch > 0) {
      
      // If there are valid entries, tabulate results
      
      $first   = ldap_first_entry($ds,$sr);
      $entries = ldap_get_attributes($ds,$first);
      $nfields = $entries["count"];
      
      // get the Distinguished Name
      
      $thisdn = ldap_get_dn($ds,$first);
      
      // HTML table initialisation
      
      $dtable = new LmTableSp("ldapdump",$strings["ldapdump"]);
      
      // add the DN entry
      
      $drowcont = array("<b>".$errors["420"]."</b>",$thisdn);
      $dtable->addrow($drowcont, "#cccccc");
      $drowcont = array();
      
      // loop on the rest of attributes
      
      for ($i=0; $i<$nfields; $i++) {
        $curatt = $entries[$i];
	if ( $exclude[$curatt] ) continue;
        $engatt = ($isattr[$curatt]) ? $isattr[$curatt] : $curatt;
        $nval   = $entries[$curatt]["count"];
        
	$encatt = rawurlencode($curatt);
	$attwin = popup("attlist.php?attribute=$encatt",650,300,7);

	$attstring   = ( $mdsattr[$curatt] ) ? "<b>$engatt</b>" : "<a href=\"$attwin\"><b>$engatt</b></a>";
        $drowcont[0] = $attstring;
        $drowcont[1] = "&nbsp;";
        
        if ($nval==0) $dtable->addrow($drowcont);
        
        for ($j=0; $j<$nval; $j++) {
          $curval = $entries[$curatt][$j];
          
          // Some time-stamp readability adjustment
	  if ( strlen($curval) == 15 && $curval{14} == "Z" ) $curval=cnvtime($curval);

          $drowcont[1] = htmlspecialchars($curval,ENT_QUOTES,"UTF8");
          $dtable->addrow($drowcont);
          $drowcont[0] = "&nbsp;";
          
        }
      }
      $dtable->close();
      ldap_free_result($sr);
      return $thisdn;
    } else {
      $errno = 9;
      echo "<br><font color=\"red\"><b>".$errors[$errno]."</b></font>\n";
      return $errno;
    }
  } else {
    $errno = 5;
    echo "<br><font color=\"red\"><b>".$errors[$errno]."</b></font>\n";
    return $errno;
  }
}
?>