package Fork;

use File::Basename;
use lib dirname($0);
@ISA = ('Exporter');
@EXPORT_OK = ('cluster_info',
	      'queue_info',
	      'jobs_info',
	      'users_info');
use LogUtils ( 'start_logging', 'error', 'warning', 'debug' ); 
use strict;

# Changelog:
#   
#    2005-11 Juha
#        Adapted from cluster-fork.pl and queues+jobs+users-fork.pl
#

##########################################
# Saved private variables
##########################################

our (%lrms_queue);

##########################################
# Private subs
##########################################

sub totalcpus {
    # number of cpus is calculated from the /proc/cpuinfo,
    # by default it is set to 1
    
    my ($cpus) = 0;
    unless (open CPUINFOFILE, "</proc/cpuinfo") {
	error("can't read the /proc/cpuinfo");
    }   
    while(my $line = <CPUINFOFILE>) {
	chomp($line);
	if ($line =~ m/^processor/) {
	    $cpus++;	
	}
    }
    close CPUINFOFILE;
    $cpus ||= 1;
    return $cpus;
}

############################################
# Public subs
#############################################

sub cluster_info ($) {
    my ($path) = shift;

    my (%lrms_cluster);

    $lrms_cluster{lrms_type} = "fork";
    $lrms_cluster{queue} = "";
    $lrms_cluster{lrms_version} = "";
    $lrms_cluster{totalcpus} = totalcpus();

    # it is assumed that all the cpus are sitting in the same machine

    $lrms_cluster{cpudistribution} = $lrms_cluster{totalcpus}."cpu:1";

    # usedcpus on a fork machine is determined from the 1min cpu
    # loadaverage and can not be larger than the totalcpus

    my ($oneminavg, $fiveminavg, $fifteenminavg, $processnumber,
	$lastprocessid );
    unless (open LOADAVGFILE, "</proc/loadavg") {
	error("can't read the /proc/loadavg");
    }
    while(my $line = <LOADAVGFILE>) {
	chomp($line);
	($oneminavg, $fiveminavg, $fifteenminavg, $processnumber, $lastprocessid ) =  split(/\s+/, $line);
    }
    close LOADAVGFILE;

    if (defined $oneminavg) {
	$lrms_cluster{usedcpus} = int $oneminavg;
	if ($lrms_cluster{usedcpus} >= $lrms_cluster{totalcpus}) {
	    $lrms_cluster{usedcpus} = $lrms_cluster{totalcpus};
	}    
    }
    else {
	$lrms_cluster{usedcpus}  = 0;
    }    

    # no LRMS queuing jobs on a fork machine, fork has no queueing ability

    $lrms_cluster{queuedcpus} = 0;

    return %lrms_cluster;
}

sub queue_info ($$) {
    my ($path) = shift;
    my ($qname) = shift;

    # status
    # running
    # totalcpus

    # $lrms_queue{running} (number of active jobs in a fork system)
    # is calculated by making use of the 'ps axr'

    $lrms_queue{running}= 0;
    unless (open PSCOMMAND,  "ps axr |") {
	error("error in executing ps axr");
    }
    while(my $line = <PSCOMMAND>) {
	chomp($line);
	next if ($line =~ m/PID TTY/);
	next if ($line =~ m/ps axr/);
	next if ($line =~ m/cluster-fork/);     
	$lrms_queue{running}++;
    }
    close PSCOMMAND;

    $lrms_queue{totalcpus} = totalcpus();

    $lrms_queue{status} = $lrms_queue{totalcpus}-$lrms_queue{running};

    # reserve negative numbers for error states
    # Fork is not real LRMS, and cannot be in ewrror state ;-)
    if ($lrms_queue{status}<0) {
	debug("lrms_queue{status} = $lrms_queue{status}");
	$lrms_queue{status} = 0;
    }

    # maxcputime

    unless ( $lrms_queue{maxcputime} = `/bin/sh -c "ulimit -t"` ) {
	debug("Could not determine max cputime with ulimit -t");
	$lrms_queue{maxcputime} = "";
    };
    chomp $lrms_queue{maxcputime};

    # queued
    # In fork? ;-)

    $lrms_queue{queued} = 0;
      
    # Is there a sensible limit for these in fork?
    # nordugrid-queue-maxrunning
    # nordugrid-queue-maxqueuable
    # nordugrid-queue-maxuserrun
    # nordugrid-queue-mincputime
    # nordugrid-queue-defaultcputime
    $lrms_queue{maxrunning} = "";
    $lrms_queue{maxqueuable} = "";
    $lrms_queue{maxuserrun} = "";
    $lrms_queue{mincputime} = "";
    $lrms_queue{defaultcput} = "";

    return %lrms_queue;
}


sub jobs_info ($$@) {
    my ($path) = shift;
    my ($qname) = shift;
    my ($jids) = shift;

    my (%lrms_jobs);

    # lrms_jobs{$id}{status}
    # lrms_jobs{$id}{node}
    # lrms_jobs{$id}{mem}
    # lrms_jobs{$id}{walltime}
    # lrms_jobs{$id}{cputime}
    # lrms_jobs{$id}{reqwalltime}
    # lrms_jobs{$id}{reqcputime}
    # lrms_jobs{$id}{comment}
    # lrms_jobs{$id}{rank}

    my (@s);
    foreach my $id (@$jids){

	$lrms_jobs{$id}{status} = 'R';

	unless ( $lrms_jobs{$id}{node} = `hostname` ) {
	    debug("hostname did not work?");
	    $lrms_jobs{$id}{node} = "";
	}

	unless ( $lrms_jobs{$id}{mem} = `ps -h -o vsize -p $id` ) {
	    debug("ps -h -o vsize -p \$ID did not work?");
	    $lrms_jobs{$id}{mem} = "";
	}

	unless ( $lrms_jobs{$id}{walltime} = `ps -h -o etime -p $id` ) {
	    debug("ps  -o etime -p \$ID did not work?");
	    $lrms_jobs{$id}{walltime} = "";
	}
	@s = split ":", $lrms_jobs{$id}{walltime};
	$lrms_jobs{$id}{walltime} = 60*$s[0]+$s[1]+int($s[2]/60);

	unless ( $lrms_jobs{$id}{cputime} = `ps -h -o cputime -p $id` ) {
	    debug("ps  -o etime -p \$ID did not work?");
	    $lrms_jobs{$id}{walltime} = "";
	}
	@s = split ":", $lrms_jobs{$id}{cputime};
	$lrms_jobs{$id}{cputime} = 60*$s[0]+$s[1]+int($s[2]/60);

	$lrms_jobs{$id}{comment} = "Running under fork";
       
	# Not appropriate for Fork
	$lrms_jobs{$id}{rank} = "";
	$lrms_jobs{$id}{reqwalltime} = "";
	$lrms_jobs{$id}{reqcputime} = "";
    }

    return %lrms_jobs;

}


sub users_info($$@) {
    my ($path) = shift;
    my ($qname) = shift;
    my ($accts) = shift;

    my (%lrms_users);

    # freecpus
    # queue length

    if ( ! exists $lrms_queue{status} ) {
	%lrms_queue = ( $path, $qname );
    }

    foreach my $u ( @{$accts} ) {
	$lrms_users{$u}{freecpus} = $lrms_queue{status};
	$lrms_users{$u}{queuelength} = "$lrms_queue{queued}";
    }
    return %lrms_users;
}
	      


1;
