#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysCluster qw(%config &clusterldif);

#<LRMSPORT

# LSF environment set
$lsf_profile_path="$config{lsf_profile_path}/profile.lsf";
$lsf_profile=`source $lsf_profile_path`;
$lshosts_command="$config{lsf_bin_path}/lshosts -w";
$bhosts_command = "$config{lsf_bin_path}/bhosts -w";
$bqueues_command = "$config{lsf_bin_path}/bqueues";

#LRMSPORT>


#<LRMSPORT
# automatically determine the LRMS name(flavour) and version
#dummy values for testing

$lsf_lsid="$config{lsf_bin_path}/lsid";
@lsf_version=`$lsf_lsid -V 2>&1`;

#$lrms_version = "6.1"; $lrms_type = "LSF";

if($lsf_version[0] =~ /^Platform/) {
  @lsf_version_values = split(/ +/,$lsf_version[0]);

  $index=0;
  while( $lsf_version_values[$index] =~ /^[^0-9]/ )
  {
    $lrms_type = $lrms_type . " $lsf_version_values[$index]";
    $index++;
  }

#  chop($lsf_version_values[$index]);
  $lsf_version_values[$index] =~ s/,//;
  $lrms_version = $lsf_version_values[$index];
}

#LRMSPORT>


#<LRMSPORT
# Calculate the totalcpus & cpudistribution & number of used cpus
# by collecting information from the LRMS
# Consult the schema for the syntax of the $cpudistribution
# If $dedicated_node_string is set, nondedicated nodes, which are not marked with 
# $dedicated_node_string should be skipped

#processing the bhosts output by using a hash of hashes %hoh_lsfnodes

my %hoh_lsfnodes;
&infosys_shared::read_lsfnodes($lshosts_command,$bhosts_command, \%hoh_lsfnodes);

$totalcpus=0;
@cpudist=0;
$usedcpus=0;
$cpudistribution="";

foreach my $node (keys %hoh_lsfnodes){

  if( ($hoh_lsfnodes{$node}{"node_status"} eq "ok") || ($hoh_lsfnodes{$node}{"node_status"} eq "closed_Full") || ($hoh_lsfnodes{$node}{"node_status"} eq "closed_Excl") || ($hoh_lsfnodes{$node}{"node_status"} eq "closed_Busy") || ($hoh_lsfnodes{$node}{"node_status"} eq "closed_Adm") )
  {
    $nodeid = $hoh_lsfnodes{$node}{"node_hostname"};
    $OStype = $hoh_lsfnodes{$node}{"node_os_type"};
    $model = $hoh_lsfnodes{$node}{"node_model"};
    $cpuf = $hoh_lsfnodes{$node}{"node_cpuf"};
    $maxmem = $hoh_lsfnodes{$node}{"node_maxmem"};
    $maxswp = $hoh_lsfnodes{$node}{"node_max_swap"};
    $ncpus = $hoh_lsfnodes{$node}{"node_ncpus"};

    $usedcpus += $hoh_lsfnodes{$node}{"node_used_slots"};
    $totalcpus += $ncpus;
    $cpudist[$ncpus] += 1;
  }
}

for (my $i=0; $i<=$#cpudist; $i++) {
   next unless ($cpudist[$i]);
   $cpudistribution .= " " . $i . "cpu:" . $cpudist[$i];
}


#LRMSPORT>



#<LRMSPORT
# Calculate $lrms_queued, the number of jobs (both grid and nongrid) 
# being queued in the LRMS 


unless (open QSTATOUTPUT,   "$bqueues_command $config{queue} |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing bqueues command: $bqueues_command $config{queue}");
    die "Error in executing bqueues: $bqueues_command $config{queue}\n";
}

while (my $line= <QSTATOUTPUT>) {
  if (! ($line =~ '^QUEUE')) {
    chomp($line);
    ($q_name,$q_priority,$q_status,$q_mjobs,$q_mslots,$q_mslots_proc,$q_mjob_slots_host,$q_num_jobs,$q_job_pending,$q_job_running,$q_job_suspended) = split(" ", $line);
  }
}

close QSTATOUTPUT;

$lrms_total = $q_num_jobs;
$lrms_queued += $q_job_pending + $q_job_suspended;

#LRMSPORT>


# generating the cluster ldif
&clusterldif;


# some performance test
my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} == 1 and $runtime >= 4 ) {
   &infosys_shared::write_log("SLOW script: $runtime");
}

exit;
