#!/bin/sh -f
#
# set environment variables:
#   SGE_BIN_PATH
#
# Juha.Lento@csc.fi
# 2004-11-05
#

##############################################################
# Reading configuration from $ARC_CONFIG
##############################################################


ARC_CONFIG=${ARC_CONFIG:-/etc/arc.conf}

if [ ! -r "$ARC_CONFIG" ]; then
  echo "ARC configuration file arc.conf was not found (usually /etc/arc.conf)"
  if [ -r "/etc/nordugrid.conf" ]; then
    echo "Fallback /etc/nordugrid.conf was found, trying to use that one"
    ARC_CONFIG="/etc/nordugrid.conf"
  else
    echo "Failed to find the fallback /etc/nordugrid.conf"
    exit 1
  fi  
fi


# Path to sge commands
SGE_BIN_PATH=${SGE_BIN_PATH:-`grep sge_bin_path $ARC_CONFIG |
sed 's/^sge_bin_path\s*=*\s*\(\"*\)\(.*\)\1/\2/'`}
if [ "$SGE_ROOT" ] && [ "$SGE_ARCH" ] ; then
    SGE_BIN_PATH=${SGE_BIN_PATH:-${SGE_ROOT}/bin/${SGE_ARCH}}
fi
if [ ! -d ${SGE_BIN_PATH} ] ; then
    echo "Could not set SGE_BIN_PATH." 1>&2
    exit 1
fi
