#!/usr/bin/perl 

package infosys_shared;

sub mds_valid ($){
   # Mds-validfrom/to
   my ($ttl) = (@_);  
   my $seconds=time;
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($seconds);
   print "Mds-validfrom: ";
   printf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z\n";
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($seconds+$ttl);
   print "Mds-validto: ";
   printf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z\n";
   print "\n";
}


sub read_pbsnodes ($$){ 
   #processing the pbsnodes output by using a hash of hashes %hoh_pbsnodes (referrenced by $hashref)
   my ($pbsnodes_command,$hashref) =@_;
   unless (open PBSNODESOUT,  "$pbsnodes_command -a |") {
      write_log("error in executing pbsnodes");
      die "Error in executing pbsnodes";
   }
   while (my $line= <PBSNODESOUT>) {	    
   	 if ($line =~ /^$/) {next}; 
   	 if ($line =~ /^([\w\-]+)/) {		 
   	    $nodeid=$1;
   	    next;	    
   	 }
   	 if ($line =~ / = /)  {
   	     ($node_var,$node_value) = split (/ = /, $line);
   	     $node_var =~ s/\s+//g;
   	     chop $node_value;  	     
   	 }	     
   	 ${$hashref}{$nodeid}{$node_var}=$node_value;     
   } 
   close PBSNODESOUT;
}


sub read_lsfnodes ($$){

   #processing the bhosts output by using a hash of hashes %hoh_lsfnodes (referrenced by $hashref)
    my ($lshosts_command, $bhosts_command, $hashref) =@_;

    $node_count = 0;
    $cpu_count = 0;

    unless (open LSFHOSTSOUTPUT,   "$lshosts_command |") {
	$config{loglevel} and  &infosys_shared::write_log("Error in executing lshosts command: $lshosts_command");
	die "Error in executing lshosts: $lshosts_command\n";
    }

    while (my $line= <LSFHOSTSOUTPUT>) {
	if (! ($line =~ '^HOST_NAME')) {
	    chomp($line);
	    ($nodeid,$OStype,$model,$cpuf,$ncpus,$maxmem,$maxswp)= split(" ", $line);
	    ${$hashref}{$nodeid}{"node_hostname"} = $nodeid; 
	    ${$hashref}{$nodeid}{"node_os_type"} = $OStype;  
            ${$hashref}{$nodeid}{"node_model"} = $model;     
            ${$hashref}{$nodeid}{"node_cpuf"} = $cpuf;
            ${$hashref}{$nodeid}{"node_maxmem"} = $maxmem;
            ${$hashref}{$nodeid}{"node_max_swap"} = $maxswp;

            if($ncpus  != "-") {
                ${$hashref}{$nodeid}{"node_ncpus"} = $ncpus;
            } 
	    else { 
                ${$hashref}{$nodeid}{"node_ncpus"} = 1;
            }
       }
    }
    close LSFHOSTSOUTPUT;

    unless (open LSFBHOSTSOUTPUT, "$bhosts_command |") {
    	$config{loglevel} and  &infosys_shared::write_log("Error in executing bhosts command: $bhosts_command");
    	die "Error in executing bhosts: $bhosts_command\n";
    }

    while (my $line= <LSFBHOSTSOUTPUT>) {
    	if (! ( ($line =~ '^HOST_NAME') || ($line =~ '^My cluster') || ($line =~ '^My master') ) ) {
    	    chomp($line);
    	    # HOST_NAME  	STATUS       JL/U    MAX  NJOBS    RUN  SSUSP  USUSP	RSV
            ($nodeid,$status,$lju,$max,$njobs,$run,$ssusp,$ususp,$rsv) = split(" ", $line);
            ${$hashref}{$nodeid}{"node_used_slots"} = $njobs;
            ${$hashref}{$nodeid}{"node_running"} = $run;
            ${$hashref}{$nodeid}{"node_suspended"} = $ssusp + $ususp;
            ${$hashref}{$nodeid}{"node_reserved"} = $rsv;
            ${$hashref}{$nodeid}{"node_status"} = $status;
        }
    }
    close LSFBHOSTSOUTPUT;
}



sub read_sgenodes ($$){ 
#processing the SGE qstat -f output by using a hash %h_sgenodes (referrenced by $hashref)
## SGE output
## queuename            qtype used/tot. load_avg arch      states
##----------------------------------------------------------------------------
##lxsrv009             B     2/2       2.40     glinux    d

   my ($sgenodes_command,$hashref) =@_; 			      
   unless (open SGENODESOUT,  "$sgenodes_command |") {		      
       write_log("error in executing $sgenodes_command");
       die "Error in executing $sgenodes_command";
   }								      
   while (my $line= <SGENODESOUT>) {	   			      
       
       if ($line =~ /^$/) {next}; 
       if ($line =~ /^-+/) {next}; 
       if ($line =~ /^queuename/) {next}; 
       if ($line =~ /^\#+/) {last}; 
  	   
       ($nodeid, $nodetype, $rest ) = split(/\s+/, $line);
       if ( ! ($nodetype =~ /B/ )) {next}; # only nodes for batch  	   
       ${$hashref}{$nodeid} = $rest;
   }
   close SGENODESOUT;
}


sub read_jobinf ($$){ 
# read detailed SGE jobinfo to obtain resource usage
#
# a call as: qstat -F -j 154138
# gives : usage    1:                  cpu=06:01:07, mem=202.10015 GBs, io=0.00000, vmem=12.94M, maxvmem=12.94M

   my ($sgejobinf_command, $usgref) = @_;

   unless (open SGEJOBINFOUT,  "$sgejobinf_command |") {
      write_log("error in executing $sgejobinf_command");
      die "Error in executing $sgejobinf_command";
   }
   while (my $linein= <SGEJOBINFOUT>) {	    
   	 if ($linein =~ /^$/) {next}; 
	 
   	 if ($linein =~ /usage/) {
	     chomp($linein);
	     ($dum, $usg ) = split(":", $linein,2);
	     $usg =~ s/^\s*//;
	     
	     last;
#	     print "$ usg \n";
	 } 
     }
   ${$usgref} = $usg;
   close SGEJOBINFOUT;
}

sub write_log ($){
  use POSIX;
  #records logging info into the $logfile read from configuration
  my ($message) = @_;  
  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime (time);
  my $timestamp=POSIX::strftime("%b %d %T", $sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst); 
  my $scriptname= $0; 
  
  $main::config{providerlog} and $logfile = $main::config{providerlog};
  $InfosysQJU::config{providerlog} and $logfile = $InfosysQJU::config{providerlog};
  $InfosysCluster::config{providerlog} and $logfile = $InfosysCluster::config{providerlog};
 
  open PROVIDERLOG, ">>$logfile";
  print PROVIDERLOG  "$timestamp [$$] $scriptname: $message\n";
  close PROVIDERLOG; 
}  
   
1;
