#!/usr/bin/perl
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
use infosys_shared;
use InfosysCluster qw(%config %gmjobs &clusterldif);
#use warnings;

# populates the nordugrid-cluster LDAP entry with real GM, config 
# and fork LRMS info
# The GM interface is factored into the InfosysCluster module.
# Don't use 'my xyz' for the interfacing GLOBAL variables!


$lrms_type = "fork";

# lrms_version has no meaning for fork therefore it is not set
#$lrms_version ="1.0";


# number of cpus is calculated from the /proc/cpuinfo, by default it is set to 1
$totalcpus = 0;
unless (open CPUINFOFILE, "</proc/cpuinfo") {
   $config{loglevel} and  &infosys_shared::write_log("can't read the /proc/cpuinfo");
   die "can't read the /proc/cpuinfo";
}   
while(my $line = <CPUINFOFILE>) {
    chomp($line);
    if ($line =~ m/^processor/) {
        $totalcpus++;	
    }
}
close CPUINFOFILE;
$totalcpus ||= 1;

# it is assumed that all the cpus are sitting in the same machine
$cpudistribution = $totalcpus."cpu:1";

# usedcpus on a fork machine is determined from the 1min cpu loadaverage and can not be
# larger than the totalcpus
unless (open LOADAVGFILE, "</proc/loadavg") {
   $config{loglevel} and  &infosys_shared::write_log("can't read the /proc/loadavg");
   die "can't read the /proc/loadavg";
}
while(my $line = <LOADAVGFILE>) {
    chomp($line);
    ($oneminavg, $fiveminavg, $fifteenminavg, $processnumber, $lastprocessid ) =  split(/\s+/, $line);
}
close LOADAVGFILE;

if (defined $oneminavg) {
   $usedcpus = int $oneminavg;
   if ($usedcpus >= $totalcpus) {
      $usedcpus = $totalcpus;
   }    
}
else {
   $usedcpus  = 0;
}    

# no LRMS queuing jobs on a fork machine, fork has no queueing ability
$lrms_queued = 0;


# $lrms_total (total number of active jobs in a fork system) is calculated by 
# making use of the 'ps axr'
$lrms_total = 0;
unless (open PSCOMMAND,  "ps axr |") {
   $config{loglevel} and  &infosys_shared::write_log("error in executing ps axr");
   die "error in executing ps axr";
}
while(my $line = <PSCOMMAND>) {
    chomp($line);
    next if ($line =~ m/PID TTY/);
    next if ($line =~ m/ps axr/);
    next if ($line =~ m/cluster-fork/);     
    $lrms_total++;
}
close PSCOMMAND;


# for consistency and to overcome the gm latency the $usedcpus
# and the $lrms_total can not be less than the $gmjobs{inlrms}
($usedcpus <= $gmjobs{inlrms}) and $usedcpus = $gmjobs{inlrms};
($lrms_total <= $gmjobs{inlrms}) and $lrms_total = $gmjobs{inlrms};


# generating the cluster ldif  
&clusterldif;


# some performance test
my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} == 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
   

exit;
