package 	InfosysCluster;
require		Exporter;
@ISA		=qw(Exporter);
@EXPORT		=qw(%config &clusterldif %gmjobs);
@EXPORT_OK	=qw(%config &clusterldif %gmjobs);

use Getopt::Long;
use infosys_shared;
use lib "$ENV{PWD}/";
use File::Basename;
use lib dirname($0);
#use warnings;

# Module to initialize Grid Manager dependent variables, to process the configuration file
# and to generate the cluster ldif for the cluster-lrms providers


GetOptions("dn:s" => \$config{dn},
	   "valid-to:i" => \$config{ttl}, 
	   "config:s" => \$config{conf_file},
	   "loglevel:i" => \$config{loglevel},
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --config
				     
		optional arguments:  --valid-to 
		
		this help:	     --help				  		
		\n";
		exit;
}

if (! ($config{dn} and $config{conf_file})) {
    $config{loglevel} and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
};

#
#  default values
#
$config{ttl} ||=  600;
$config{gm_mount_point} ="/jobs";
$config{gm_port} = 2811;
$config{homogeneity} = "True";
$config{providerlog}="/var/log/infoprovider.log";
$config{defaultttl}="604800";
$config{"x509_user_cert"} = "/etc/grid-security/hostcert.pem";
$config{"x509_cert_dir"} = "/etc/grid-security/certificates/";
chomp ($config{hostname} = `/bin/hostname -f`);
$config{ng_location} ||= $ENV{NORDUGRID_LOCATION} ||= "/opt/nordugrid";
my $globus_location ||= $ENV{GLOBUS_LOCATION} ||= "/opt/globus/";
my $cache_statfile="statistics";


#parse the arc.conf directly into a hash $parsedconfig{blockname}{variable_name}
unless (open (CONFIGFILE, "<$config{conf_file}")) {
    $config{loglevel} and  &infosys_shared::write_log("can't open $config{conf_file} configuration file");
    die "Can't open $config{conf_file} configuration file\n";
}
my $blockname;
while (my $line =<CONFIGFILE>) {
   next if $line =~/^#/;
   next if $line =~/^$/;
   next if $line =~/^\s+$/;
   
   if ($line =~/\[(.+)\]/ ) {
      $blockname = $1;
      next;
   }
   
   unless ($line =~ /=\s*".*"\s*$/) {
      $config{loglevel} and &infosys_shared::write_log("skipping incorrect arc.conf line: $line");
      next;
   }
    
   $line =~m/^(\w+)\s*=\s*"(.*)"\s*$/;
   $variable_name=$1;
   $variable_value=$2;
   unless ($parsedconfig{$blockname}{$variable_name}) {
      $parsedconfig{$blockname}{$variable_name} = $variable_value;
   }
   else {
      $parsedconfig{$blockname}{$variable_name} .= "[separator]".$variable_value;
   }   
}
close CONFIGFILE;

##debug printout
#foreach $block (keys %parsedconfig) {
#   print "\nHHHH[$block]:\n";
#   foreach $variable (keys %{ $parsedconfig{$block} }) {
#      print "$variable: $parsedconfig{$block}{$variable}\n";
#   }   
#}


#fill the %config hash from the %parsedconfig taking into account the block hierarchy
foreach $variable (keys %{ $parsedconfig{"common"} } ) {
   $config{$variable} = $parsedconfig{"common"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"grid-manager"} } ) {
   $config{$variable} = $parsedconfig{"grid-manager"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"infosys"} } ) {
   $config{$variable} = $parsedconfig{"infosys"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"gridftpd"} } ) {
   $config{$variable} = $parsedconfig{"gridftpd"}{$variable};
}
foreach $variable (keys %{ $parsedconfig{"cluster"} } ) {
   $config{$variable} = $parsedconfig{"cluster"}{$variable};
}


#read the gm-jobs information about the number of jobs in different gm states
%gmjobs;
$gm_jobs_command = "$config{ng_location}/bin/gm-jobs -Z -c $config{conf_file} -u 0";

unless (open GMJOBSOUTPUT, "$gm_jobs_command 2>/dev/null |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing $gm_jobs_command");  
    die "Error in executing $gm_jobs_command\n"; 					      
}

while (my $line= <GMJOBSOUTPUT>) {
    if ($line =~ /^Job:/) {next};					  
    ($line =~ /Jobs total: (\d+)/)    and $gmjobs{"totaljobs"}=$1; 	  
    ($line =~ /ACCEPTED: (\d+)/)      and $gmjobs{"accepted"}=$1; 	  
    ($line =~ /PREPARING: (\d+)/)     and $gmjobs{"preparing"}=$1;	  
    ($line =~ /SUBMIT: (\d+)/)        and $gmjobs{"submit"}=$1; 	  
    ($line =~ /INLRMS: (\d+)/)        and $gmjobs{"inlrms"}=$1; 	  
    ($line =~ /FINISHING: (\d+)/)     and $gmjobs{"finishing"}=$1;	  
    ($line =~ /FINISHED: (\d+)/)      and $gmjobs{"finished"}=$1;	  
    ($line =~ /DELETED: (\d+)/)       and $gmjobs{"deleted"}=$1;	  
    ($line =~ /CANCELING: (\d+)/)     and $gmjobs{"canceling"}=$1;	  
}

close GMJOBSOUTPUT;

sub clusterldif {
    # The DN of the entry
    print "dn: $config{dn}\n";

    # The objectclasses
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-cluster\n";

    # The attributes
    print "nordugrid-cluster-name: $config{hostname}\n";
    
    $config{cluster_alias} and print "nordugrid-cluster-aliasname: $config{cluster_alias}\n";
    
    $config{comment} and print "nordugrid-cluster-comment: $config{comment}\n";

    #nordugrid-cluster-owner
    my @cluster_owner = split /\[separator\]/, $config{cluster_owner};
    foreach my $listentry (@cluster_owner) {
        print "nordugrid-cluster-owner: $listentry\n";
    }
    
    #nordugrid-cluster-acl
    my @cluster_acl = split /\[separator\]/, $config{authorizedvo};
    foreach my $listentry (@cluster_acl) {
        print "nordugrid-cluster-acl: VO:$listentry\n";
    }
    
    $config{cluster_location} and print "nordugrid-cluster-location: $config{cluster_location}\n";

    #nordugrid-cluster-issuerca
    $ENV{"LD_LIBRARY_PATH"}="$globus_location/lib:$config{ng_location}/lib";
    my $hostcert = $config{"x509_user_cert"};    
    # find an openssl
    my $openssl_command = `which openssl 2>/dev/null`;
    chomp $openssl_command;
    if ( $? != 0 ) {
       $openssl_command = "$globus_location/bin/openssl";
    }                 
    my $issuerca=`$openssl_command x509 -noout -issuer -in $hostcert 2>/dev/null`;
    if ( $? and $config{loglevel} ) {
       &infosys_shared::write_log("error in executing $openssl_command x509 -noout -issuer -in $hostcert")
    }
    if ( $issuerca =~ s/issuer= // ) {
       chomp($issuerca);
       print "nordugrid-cluster-issuerca: $issuerca\n";
    } 
       
    #nordugrid-cluster-issuerca-hash
    @certfiles = `ls $config{"x509_cert_dir"}/*.0 2>/dev/null`;
    foreach $cert ( @certfiles ) {
       my $ca_sn = `$openssl_command x509 -checkend 60 -noout -subject -in $cert`;
       $ca_sn =~ s/subject= //;
       chomp($ca_sn);
       if ( $ca_sn eq $issuerca) {
          $issuerca_hash = `$openssl_command x509 -checkend 60 -noout -hash -in $cert`;
       }
       if ($?) {
         $config{loglevel} and &infosys_shared::write_log("CA $ca_sn is expired");
	 next;
       }
       push @trustedca, $ca_sn;
    }
    if ( $issuerca_hash ) {
       chomp ($issuerca_hash);
       print "nordugrid-cluster-issuerca-hash: $issuerca_hash\n";
    }
    
    #nordugrid-cluster-trustedca
    foreach my $listentry (@trustedca) {
       print "nordugrid-cluster-trustedca: $listentry\n";
    }
    
    #contact string, from now we only support the gridftp submission
    my $cstring = "gsiftp://$config{hostname}:$config{gm_port}$config{gm_mount_point}";
    print "nordugrid-cluster-contactstring: $cstring\n";

    #interactive-contactstring
    my @interactive_contactstring = split /\[separator\]/, $config{interactive_contactstring};
    foreach my $listentry (@interactive_contactstring) {
       print "nordugrid-cluster-interactive-contactstring: $listentry\n";
    }
     
    #nordugrid-cluster-support
    my @clustersupport = split /\[separator\]/, $config{clustersupport};
    foreach my $listentry (@clustersupport) {
        print "nordugrid-cluster-support: $listentry\n";
    }

    # nordugrid-cluster-lrms-type
    print "nordugrid-cluster-lrms-type: $main::lrms_type\n";
    $main::lrms_version and print "nordugrid-cluster-lrms-version: $main::lrms_version\n";
    $config{lrmsconfig}  and print "nordugrid-cluster-lrms-config: $config{lrmsconfig}\n";

    #nordugrid-cluster-architecture
    if ($config{architecture}=~/adotf/i) {
        my $tmparch = `uname -m`;
        chomp $tmparch;
        print "nordugrid-cluster-architecture: $tmparch\n";  
    }
    elsif ($config{architecture}){  
        print "nordugrid-cluster-architecture: $config{architecture}\n";
    }

    #nordugrid-cluster-opsys
    my @opsys =  split /\[separator\]/, $config{opsys};
    foreach my $listentry (@opsys) {
        print "nordugrid-cluster-opsys: $listentry\n";
    }

    #nordugrid-cluster-benchmark
    my @benchmark = split /\[separator\]/, $config{benchmark};
    foreach my $listentry (@benchmark) {
        my ($bench_name,$bench_value) = split(/\s+/, $listentry);
        print "nordugrid-cluster-benchmark: $bench_name \@ $bench_value\n";
    }
          
    print "nordugrid-cluster-homogeneity: $config{homogeneity}\n";

    #nordugrid-cluster-nodecpu
    my ($modelname,$mhz);
    if ($config{nodecpu}=~/adotf/i) { 
       unless (open  CPUINFO, "</proc/cpuinfo") {
    	  $config{loglevel} and  &infosys_shared::write_log("error in opening /proc/cpuinfo");
    	  die "Error in opening /proc/cpuinfo";
       }   
       while (my $line= <CPUINFO>) {
    	     if ($line=~/^model name\s+:\s+(.*)$/) {		
    		$modelname=$1;         
    	     }
    	     if ($line=~/^cpu MHz\s+:\s+(.*)$/) {
    		$mhz=$1;
    	     }
       }
       close CPUINFO;
       $nodecpu = "$modelname @ $mhz MHz";
       print "nordugrid-cluster-nodecpu: $nodecpu\n";	      
    }
    elsif ($config{nodecpu}) {
       print "nordugrid-cluster-nodecpu:", $config{nodecpu}, "\n";
    }

    #nordugrid-cluster-nodememory
    $config{nodememory} and print "nordugrid-cluster-nodememory: $config{nodememory}\n";

    #nordugrid-cluster-nodeaccess
    my @nodeaccess = split /\[separator\]/, $config{nodeaccess};
    foreach my $listentry (@nodeaccess) {
       print "nordugrid-cluster-nodeaccess: $listentry\n";
    }

    #nordugrid-cluster-totalcpus, usedcpus, cpudistribution 
    if ( $main::totalcpus ) {
       print "nordugrid-cluster-totalcpus: $main::totalcpus\n";
    }
    else {
       print "nordugrid-cluster-totalcpus: 0\n";
    } 
    if ( $main::usedcpus ) {
       print "nordugrid-cluster-usedcpus: $main::usedcpus\n";
    }
    else {
       print "nordugrid-cluster-usedcpus: 0\n";
    }
    if ( $main::cpudistribution ) {
       print "nordugrid-cluster-cpudistribution: $main::cpudistribution\n";
    }    

    # nordugrid-cluster-queuedjobs (DEPRECATED)
    # The total number of jobs (grid + nongrid) being queued on the cluster 
    # either in LRMS or in the GM
    #$gmqueued = $gmjobs{"totaljobs"} - $gmjobs{"deleted"} - $gmjobs{"finished"} - $gmjobs{"finishing"} 
    #		- $gmjobs{"inlrms"} - $gmjobs{"canceling"}; 
    #print "nordugrid-cluster-queuedjobs: ", $main::lrms_queued + $gmqueued, "\n"; 

    # nordugrid-cluster-prelrmsqueued
    # The total number of grid jobs not yet reached the LRMS, being queued on the cluster in one of the
    # GM's internal queues
    $gmqueued = $gmjobs{"accepted"} + $gmjobs{"preparing"} + $gmjobs{"submit"};
    print "nordugrid-cluster-prelrmsqueued: $gmqueued\n";

    # nordugrid-cluster-totaljobs
    # The total number of 'active' jobs (Grid + non-Grid) in the cluster
    # $main::lrms_total is the total number of jobs in the LRMS (both grid and nongrid)
    # In order to avoid double counting, the number of grid jobs in LRMS state, $gmjobs{"inlrms"}
    # has to be substracted (they counted in $lrms_total too)
    $nonfinish = $gmjobs{"totaljobs"}-$gmjobs{"finishing"}-$gmjobs{"finished"}-$gmjobs{"deleted"};
    $totaljobs = $nonfinish + $main::lrms_total - $gmjobs{"inlrms"};
    print "nordugrid-cluster-totaljobs: $totaljobs\n";  


    #nordugrid-cluster-localse
    my @localse =  split /\[separator\]/, $config{localse};
    foreach my $listentry (@localse) {
        print "nordugrid-cluster-localse: $listentry\n";
    }

    #nordugrid-cluster-sessiondirusage
    my $diskfree;
    my $disktotal;
    if ( -d "$config{sessiondir}") {
      # check if on afs  
      if ($config{sessiondir} =~ /\/afs\//) {
    	    $diskfree =`fs listquota $config{sessiondir} 2>/dev/null`;   
    	    if ($diskfree) {
    	      $diskfree =~ /\n\S+\s+(\d+)\s+(\d+)\s+\d+%\s+\d+%/;
    	      $diskfree = int (($1 - $2)/1024);
    	      $disktotal= int $1/1024;
    	    } 
    	    else {
    	      $diskfree = 0;
    	      $disktotal = 0;
    	    }  
      } 
      # "ordinary" disk 
      else {
    	    $dfstring =`df -k -P $config{sessiondir} 2>/dev/null`;   
    	    if ($dfstring) {
    	      $dfstring =~ /\n\S+\s+(\d+)\s+\d+\s+(\d+)\s+\d+/;
    	      $diskfree = int $2/1024;
    	      $disktotal = int $1/1024;
    	    }
    	    else {
    	      $diskfree = 0;
    	      $disktotal = 0;
    	    }
      }
    }
    else {
      	$diskfree = 0;
      	$disktotal = 0;
        $config{loglevel} and &infosys_shared::write_log("no sessiondir found");
    }
    print "nordugrid-cluster-sessiondir-free: $diskfree\n";
    print "nordugrid-cluster-sessiondir-total: $disktotal\n";

    #nordugrid-cluster-sessiondir-lifetime
    #use only the first number from the defaultttl  
    $config{defaultttl} =~ /(\d+)/;
    my $lifetime_min = int $1/60; 
    print "nordugrid-cluster-sessiondir-lifetime: $lifetime_min\n"; 
    
    #nordugrid-cluster-cacheusage
    if ( $config{cachedir} ){
       (my $path1, my $path2) = split /\s+/, $config{cachedir};      
       $dfstring =`cat $path1/$cache_statfile 2>/dev/null`;
       if ($? and $config{loglevel}) {
    	 &infosys_shared::write_log("error in reading the cache status file $path1/$cache_statfile")
       } 
       $dfstring =~ /softfree=(\d+)/;
       $diskfree = int $1/1024/1024;
       $dfstring =~ /unclaimed=(\d+)/;
       $diskfree += int $1/1024/1024;
       $dfstring =~ /softsize=(\d+)/;
       $disktotal = int $1/1024/1024;
       print "nordugrid-cluster-cache-free: $diskfree\n";
       print "nordugrid-cluster-cache-total: $disktotal\n";
    }

    #nordugrid-cluster-middleware

    #NorduGrid middleware
    #nordugridlocation/bin/grid-manager -v
    $ENV{"LD_LIBRARY_PATH"}="$globus_location/lib:$config{ng_location}/lib";
    my $ngversionstring = `$config{ng_location}/sbin/grid-manager -v 2>/dev/null`;
    if ($? and $config{loglevel}) {						     
       &infosys_shared::write_log("Can't execute the $config{ng_location}/sbin/grid-manager")   
    }
    $ngversionstring =~ /grid-manager: version\s*(.+)$/ and $ngversion="-".$1;
    if ($ngversionstring) {
       print "nordugrid-cluster-middleware: nordugrid-arc$ngversion\n";
    }

    #Globus Toolkit version
    #globuslocation/share/doc/VERSION
    if (-r "$globus_location/share/doc/VERSION" ) {
       chomp ( $globusversion =  `cat $globus_location/share/doc/VERSION 2>/dev/null`);      
       if ($? and $config{loglevel}) {
          &infosys_shared::write_log("error in reading the globus version file")	 
       }
    }
    #globuslocation/bin/globus-version 
    elsif (-x "$globus_location/bin/globus-version" ) {
       chomp ( $globusversion =  `$globus_location/bin/globus-version 2>/dev/null`);       
       if ($? and $config{loglevel}) {
          &infosys_shared::write_log("error in executing the $globus_location/bin/globus-version command")
       }
    }
    if ($globusversion) {
       print "nordugrid-cluster-middleware: globus-$globusversion\n";
    }
    
    my @middleware = split /\[separator\]/, $config{middleware};
    foreach my $listentry (@middleware) {
      	next if ($ngversionstring and ($listentry =~ /nordugrid/i)); 
      	next if ($globusversion and ($listentry =~ /globus/i));
      	print "nordugrid-cluster-middleware: $listentry\n";      
    }

    #nordugrid-cluster-runtimeenvironment
     if ($config{runtimedir}){
        unless (opendir DIR, $config{runtimedir}) {
	    $loglevel and  &infosys_shared::write_log("Can't acess $config{runtimedir}");
	    die "Can't acess $config{runtimedir}\n";
	}
        @runtimeenvironment= `find $config{runtimedir} -type f ! -name ".*" ! -name "*~"` ;
        closedir DIR;

        foreach my $listentry (@runtimeenvironment) {
    	  chomp($listentry);	
    	  $listentry=~s/$config{runtimedir}\/*//;
    	  print "nordugrid-cluster-runtimeenvironment: $listentry\n";
        }
    }

    #Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});
}


1;
