CREATE DATABASE IF NOT EXISTS nglogger;
USE nglogger;

CREATE TABLE IF NOT EXISTS jobs (
	id INT AUTO_INCREMENT PRIMARY KEY,
	globaljobid VARCHAR(255) NOT NULL,
	user_id INT UNSIGNED NOT NULL,
	cluster_id INT UNSIGNED NOT NULL,
	jobdescription BLOB NULL DEFAULT NULL,
	projectname VARCHAR(255) NULL DEFAULT NULL,
	jobname VARCHAR(255) NULL DEFAULT NULL,
	submithost VARCHAR(255) NULL DEFAULT NULL,
	requestedcputime INT NULL DEFAULT NULL,
	requestedwalltime INT NULL DEFAULT NULL,
	requestedmemory INT NULL DEFAULT NULL,
	requesteddisk INT NULL DEFAULT NULL,
	submissiontime DATETIME NULL DEFAULT NULL,
	localuserid VARCHAR(255) NULL DEFAULT NULL,
	queue VARCHAR(32) NULL DEFAULT NULL,
	lrms VARCHAR(32) NULL DEFAULT NULL,
	localjobid VARCHAR(255) NULL DEFAULT NULL,
	lrmssubmissiontime DATETIME NULL DEFAULT NULL,
	lrmsendtime DATETIME NULL DEFAULT NULL,
	nodename BLOB NULL DEFAULT NULL,
	nodecount INT DEFAULT 1,
	processors INT DEFAULT 1,
	exitcode INT NULL DEFAULT NULL,
	failurestring BLOB NULL DEFAULT NULL,
	usedcputime INT NULL DEFAULT NULL,
	usedwalltime INT NULL DEFAULT NULL,
	usedmemory INT NULL DEFAULT NULL,
	useddisk INT NULL DEFAULT NULL,
	status VARCHAR(255) NULL DEFAULT NULL,
	endtime DATETIME NULL DEFAULT NULL,
	downloadtime INT NULL DEFAULT NULL,
	uploadtime INT NULL DEFAULT NULL,
	processid INT NULL DEFAULT NULL,
	charge INT NULL DEFAULT NULL,
	network VARCHAR(255) NULL DEFAULT NULL,
	stageindata INT NULL DEFAULT NULL,
	stageoutdata INT NULL DEFAULT NULL,
	usedswap INT NULL DEFAULT NULL,
	servicelevel VARCHAR(255) NULL DEFAULT NULL,
	runtimeenvironment BLOB NULL DEFAULT NULL,
	INDEX start_failure(globaljobid,submissiontime,endtime,status),
	INDEX cluster(cluster_id),
	INDEX user(user_id)
) ENGINE = MyISAM;

CREATE TABLE IF NOT EXISTS user (
	id INT UNSIGNED AUTO_INCREMENT,
	dn VARCHAR(255) CHARACTER SET utf8 NOT NULL,
	KEY id(id)
) ENGINE = InnoDB;

CREATE TABLE IF NOT EXISTS cluster (
	id INT UNSIGNED AUTO_INCREMENT,
	dn VARCHAR(255) CHARACTER SET utf8 NOT NULL,
	KEY id(id)
) ENGINE = InnoDB;

CREATE VIEW v_jobs AS
SELECT 
	jobs.id,
	jobs.globaljobid,
	user.dn as globaluserid,
	cluster.dn as cluster,
	jobs.jobdescription,
	jobs.projectname,
	jobs.jobname,
	jobs.submithost,
	jobs.requestedcputime,
	jobs.requestedwalltime,
	jobs.requestedmemory,
	jobs.requesteddisk,
	jobs.submissiontime,
	jobs.localuserid,
	jobs.queue,
	jobs.lrms,
	jobs.localjobid,
	jobs.lrmssubmissiontime,
	jobs.lrmsendtime,
	jobs.nodename,
	jobs.nodecount,
	jobs.processors,
	jobs.exitcode,
	jobs.failurestring,
	jobs.usedcputime,
	jobs.usedwalltime,
	jobs.usedmemory,
	jobs.useddisk,
	jobs.status,
	jobs.endtime,
	jobs.downloadtime,
	jobs.uploadtime,
	jobs.processid,
	jobs.charge,
	jobs.network,
	jobs.stageindata,
	jobs.stageoutdata,
	jobs.usedswap,
	jobs.servicelevel,
	jobs.runtimeenvironment
FROM jobs, user, cluster
WHERE jobs.user_id = user.id AND jobs.cluster_id = cluster.id;

delimiter //
CREATE PROCEDURE add_job(
	p_globaljobid VARCHAR(255),
	p_globaluserid VARCHAR(255) CHARACTER SET utf8,
	p_cluster VARCHAR(255) CHARACTER SET utf8,
	p_jobdescription BLOB,
	p_projectname VARCHAR(255),
	p_jobname VARCHAR(255),
	p_submithost VARCHAR(255),
	p_requestedcputime INT,
	p_requestedwalltime INT,
	p_requestedmemory INT,
	p_requesteddisk INT,
	p_submissiontime DATETIME,
	p_localuserid VARCHAR(255),
	p_queue VARCHAR(32),
	p_lrms VARCHAR(32),
	p_localjobid VARCHAR(255),
	p_lrmssubmissiontime DATETIME,
	p_lrmsendtime DATETIME,
	p_nodename BLOB,
	p_nodecount INT,
	p_processors INT,
	p_exitcode INT,
	p_failurestring BLOB,
	p_usedcputime INT,
	p_usedwalltime INT,
	p_usedmemory INT,
	p_useddisk INT,
	p_status VARCHAR(255),
	p_endtime DATETIME,
	p_downloadtime INT,
	p_uploadtime INT,
	p_processid INT,
	p_charge INT,
	p_network VARCHAR(255),
	p_stageindata INT,
	p_stageoutdata INT,
	p_usedswap INT,
	p_servicelevel VARCHAR(255),
	p_runtimeenvironment BLOB
	)
BEGIN
	DECLARE v_cluster_id INT DEFAULT NULL;
	DECLARE v_user_id INT DEFAULT NULL;
	DECLARE v_entry_count INT DEFAULT 0;
	DECLARE s BLOB DEFAULT '';
	DECLARE s_length INT;

	-- 1. try to get cluster
	SELECT id INTO v_cluster_id FROM cluster WHERE dn = p_cluster;
	IF( v_cluster_id IS NULL) THEN
		INSERT INTO cluster(dn) values (p_cluster);
		SELECT LAST_INSERT_ID() INTO v_cluster_id;
	END IF;
	
	-- 2. try to get user
	SELECT id INTO v_user_id FROM user WHERE dn = p_globaluserid;
	IF( v_user_id IS NULL) THEN
		INSERT INTO user(dn) values (p_globaluserid);
		SELECT LAST_INSERT_ID() INTO v_user_id;
	END IF;

	-- 3. create set statement
	IF(p_jobdescription IS NOT NULL) THEN
		SET s = CONCAT(s, ' jobdescription = \'', p_jobdescription, '\',');
	END IF;
	IF(p_projectname IS NOT NULL) THEN
		SET s = CONCAT(s, ' projectname = \'', p_projectname, '\',');
	END IF;
	IF(p_jobname IS NOT NULL) THEN
		SET s = CONCAT(s, ' jobname = \'', p_jobname, '\',');
	END IF;
	IF(p_submithost IS NOT NULL) THEN
		SET s = CONCAT(s, ' submithost = \'', p_submithost, '\',');
	END IF;
	IF(p_requestedcputime IS NOT NULL) THEN
		SET s = CONCAT(s, ' requestedcputime = ', p_requestedcputime, ',');
	END IF;
	IF(p_requestedwalltime IS NOT NULL) THEN
		SET s = CONCAT(s, ' requestedwalltime = ', p_requestedwalltime, ',');
	END IF;
	IF(p_requestedmemory IS NOT NULL) THEN
		SET s = CONCAT(s, ' requestedmemory = ', p_requestedmemory, ',');
	END IF;
	IF(p_requesteddisk IS NOT NULL) THEN
		SET s = CONCAT(s, ' requesteddisk = ', p_requesteddisk, ',');
	END IF;
	IF(p_submissiontime IS NOT NULL) THEN
		SET s = CONCAT(s, ' submissiontime = \'', p_submissiontime, '\',');
	END IF;
	IF(p_localuserid IS NOT NULL) THEN
		SET s = CONCAT(s, ' localuserid = \'', p_localuserid, '\',');
	END IF;
	IF(p_queue IS NOT NULL) THEN
		SET s = CONCAT(s, ' queue = \'', p_queue, '\',');
	END IF;
	IF(p_lrms IS NOT NULL) THEN
		SET s = CONCAT(s, ' lrms = \'', p_lrms, '\',');
	END IF;
	IF(p_localjobid IS NOT NULL) THEN
		SET s = CONCAT(s, ' localjobid = \'', p_localjobid, '\',');
	END IF;
	IF(p_lrmssubmissiontime IS NOT NULL) THEN
		SET s = CONCAT(s, ' lrmssubmissiontime = \'', p_lrmssubmissiontime, '\',');
	END IF;
	IF(p_lrmsendtime IS NOT NULL) THEN
		SET s = CONCAT(s, ' lrmsendtime = \'', p_lrmsendtime, '\',');
	END IF;
	IF(p_nodename IS NOT NULL) THEN
		SET s = CONCAT(s, ' nodename = \'', p_nodename, '\',');
	END IF;
	IF(p_nodecount IS NOT NULL) THEN
		SET s = CONCAT(s, ' nodecount = ', p_nodecount, ',');
	END IF;
	IF(p_processors IS NOT NULL) THEN
		SET s = CONCAT(s, ' processors = ', p_processors, ',');
	END IF;
	IF(p_exitcode IS NOT NULL) THEN
		SET s = CONCAT(s, ' exitcode = ', p_exitcode, ',');
	END IF;
	IF(p_failurestring IS NOT NULL) THEN
		SET s = CONCAT(s, ' failurestring = \'', p_failurestring, '\',');
	END IF;
	IF(p_usedcputime IS NOT NULL) THEN
		SET s = CONCAT(s, ' usedcputime = ', p_usedcputime, ',');
	END IF;
	IF(p_usedwalltime IS NOT NULL) THEN
		SET s = CONCAT(s, ' usedwalltime = ', p_usedwalltime, ',');
	END IF;
	IF(p_usedmemory IS NOT NULL) THEN
		SET s = CONCAT(s, ' usedmemory = ', p_usedmemory, ',');
	END IF;
	IF(p_useddisk IS NOT NULL) THEN
		SET s = CONCAT(s, ' useddisk = ', p_useddisk, ',');
	END IF;
	IF(p_status IS NOT NULL) THEN
		SET s = CONCAT(s, ' status = \'', p_status, '\',');
	END IF;
	IF(p_endtime IS NOT NULL) THEN
		SET s = CONCAT(s, ' endtime = \'', p_endtime, '\',');
	END IF;
	IF(p_downloadtime IS NOT NULL) THEN
		SET s = CONCAT(s, ' downloadtime = \'', p_downloadtime, '\',');
	END IF;
	IF(p_uploadtime IS NOT NULL) THEN
		SET s = CONCAT(s, ' endtime = \'', p_uploadtime, '\',');
	END IF;
	IF(p_processid IS NOT NULL) THEN
		SET s = CONCAT(s, ' processid = \'', p_processid, '\',');
	END IF;
	IF(p_charge IS NOT NULL) THEN
		SET s = CONCAT(s, ' charge = \'', p_charge, '\',');
	END IF;
	IF(p_network IS NOT NULL) THEN
		SET s = CONCAT(s, ' network = \'', p_network, '\',');
	END IF;
	IF(p_stageindata IS NOT NULL) THEN
		SET s = CONCAT(s, ' stageindata = \'', p_stageindata, '\',');
	END IF;
	IF(p_stageoutdata IS NOT NULL) THEN
		SET s = CONCAT(s, ' stageoutdata = \'', p_stageoutdata, '\',');
	END IF;
	IF(p_usedswap IS NOT NULL) THEN
		SET s = CONCAT(s, ' usedswap = \'', p_usedswap, '\',');
	END IF;
	IF(p_servicelevel IS NOT NULL) THEN
		SET s = CONCAT(s, ' servicelevel = \'', p_servicelevel, '\',');
	END IF;
	IF(p_runtimeenvironment IS NOT NULL) THEN
		SET s = CONCAT(s, ' runtimeenvironment = \'', p_runtimeenvironment, '\',');
	END IF;
	
	SET s_length = CHAR_LENGTH(s);
	
	-- 4. check if exist jobs with the same attributes
	SELECT count(*) INTO v_entry_count FROM jobs WHERE cluster_id = v_cluster_id AND user_id = v_user_id AND globaljobid = p_globaljobid;

	-- 5. update/insert data
	IF(v_entry_count > 0 AND s_length > 0) THEN
	 	SET @q = CONCAT('UPDATE jobs SET', SUBSTRING(s, 1, s_length-1), ' WHERE cluster_id = ', v_cluster_id, ' AND user_id = ', v_user_id, ' AND globaljobid = \'', p_globaljobid, '\'');
		PREPARE stmt FROM @q;
		EXECUTE stmt;
		DEALLOCATE PREPARE stmt;
	ELSEIF(v_entry_count = 0) THEN
		SET s = CONCAT(s, ' cluster_id = ', v_cluster_id, ',');
		SET s = CONCAT(s, ' user_id = ', v_user_id, ',');
		SET s = CONCAT(s, ' globaljobid = \'', p_globaljobid, '\'');

		SET @q = CONCAT('INSERT INTO jobs SET', s);
		PREPARE stmt FROM @q;
		EXECUTE stmt;
		DEALLOCATE PREPARE stmt;
	END IF;
END
//
delimiter ;

GRANT ALL ON nglogger.* TO 'nglogger'@'localhost' IDENTIFIED BY 'pass';

-- call to test:
-- call add_job('id','user','cluster',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
--CALL add_job('83471154531898470222942','/DC=org/DC=balticgrid/OU=ut.ee/CN=Aleksei Nazarov','/DC=org/DC=balticgrid/OU=ut.ee/CN=Aleksei Nazarov',NULL,NULL,'logger test','130.235.91.118:2450;guest4.hep.lu.se',NULL,NULL,NULL,NULL,'2006-8-2 15:18:18','aleksei','gridshort','fork',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)
-- copy query
--insert into nglogger.user (dn) select distinct user from ngloggerold.jobs;
--insert into nglogger.cluster (dn) select distinct cluster from ngloggerold.jobs;
--insert into nglogger.jobs (submissiontime, endtime, user_id, cluster_id, globaljobid, jobname, failurestring, lrms, queue, jobdescription, submithost, usedcputime, usedmemory) 
--select j.start, j.end, u.id, c.id, j.id, j.name, j.failure, j.lrms, j.queue, j.rsl, j.ui, j.usedcpu, j.usedmem from ngloggerold.jobs j, nglogger.user u, nglogger.cluster c where j.user = u.dn and j.cluster = c.dn;
