#!/bin/bash

##############################################################
# Reading configuration from $ARC_CONFIG
##############################################################


ARC_CONFIG=${ARC_CONFIG:-/etc/arc.conf}

if [ ! -r "$ARC_CONFIG" ]; then
  echo "ARC configuration file arc.conf was not found (usually /etc/arc.conf)"
  if [ -r "/etc/nordugrid.conf" ]; then
    echo "Fallback /etc/nordugrid.conf was found, trying to use that one"
    ARC_CONFIG="/etc/nordugrid.conf"
  else
    echo "Failed to find the fallback /etc/nordugrid.conf"
    exit 1
  fi
fi

config_parse() {
    script='my ($nb,$no)=(0,0); while(<>) { if (/^\s*\[([^\]]+)\]/) {
                print "_CONFIG_BLOCK${nb}_NUM='\''$no'\'';\n" if $nb;
                $nb++; $no=0;
                print "_CONFIG_BLOCK${nb}_NAME='\''$1'\'';\n"; next;
              } elsif (/^(\w+)\s*=\s*([\"'\''])(.*)(\2)\s*$/) { $no++;
                print "_CONFIG_BLOCK${nb}_OPT${no}_NAME='\''$1'\'';\n";
                print "_CONFIG_BLOCK${nb}_OPT${no}_VALUE='\''$3'\'';\n";
            } }
            print "_CONFIG_BLOCK${nb}_NUM='\''$no'\'';\n";
            print "_CONFIG_NUM_BLOCKS='\''$nb'\'';\n";
           '
    config=`cat $ARC_CONFIG | perl -w -e "$script"`
    eval "$config"
}

# Option names from config file will be prefixed with CONFIG_

config_reveal_block() {
  block=$1
  i=0
  if [ -z "$_CONFIG_NUM_BLOCKS" ]; then return 1; fi
  while [ $i -lt $_CONFIG_NUM_BLOCKS ]; do
    i=$((i+1))
    eval name="\$_CONFIG_BLOCK${i}_NAME"
    if [ "x$block" != "x$name" ]; then continue; fi
    eval num="\$_CONFIG_BLOCK${i}_NUM"
    if [ -z "$num" ]; then return 1; fi
    j=0
    while [ $j -lt $num ]; do
      j=$((j+1))
      eval name="\$_CONFIG_BLOCK${i}_OPT${j}_NAME"
      eval value="\$_CONFIG_BLOCK${i}_OPT${j}_VALUE"
      if [ -z "$name" ]; then return 1; fi
      eval export "CONFIG_$name='$value'"
    done
    return 0
  done
  return 1
}

config_hide_all() {
    unset `set|grep ^CONFIG_|cut -f1 -d=`
}

# test
#config_parse /etc/arc.conf
#config_reveal_block common
#config_reveal_block grid-manager
#config_reveal_block infosys
#env | grep CONFIG_

