#!/bin/sh -f
#
# set environment variables:
#   LSF_BIN_PATH
# and 
#   LSF_QUEUE_NAME
#
# Sergio Maffioletti <sergio.maffioletti@cscs.ch>
# 12-07-2005
#

##############################################################
# Reading configuration from $ARC_CONFIG
##############################################################


ARC_CONFIG=${ARC_CONFIG:-/etc/arc.conf}

if [ ! -r "$ARC_CONFIG" ]; then
  echo "ARC configuration file arc.conf was not found (usually /etc/arc.conf)"
  if [ -r "/etc/nordugrid.conf" ]; then
    echo "Fallback /etc/nordugrid.conf was found, trying to use that one"
    ARC_CONFIG="/etc/nordugrid.conf"
  else
    echo "Failed to find the fallback /etc/nordugrid.conf"
    exit 1
  fi  
fi

# Path to LSF commands
LSF_BIN_PATH=${LSF_BIN_PATH:-`grep lsf_bin_path $ARC_CONFIG | sed 's/^lsf_bin_path\s*=*\s*\(\"*\)\(.*\)\1/\2/'`}
if [ ! -d ${LSF_BIN_PATH} ] ; then
    echo "Could not set LSF_BIN_PATH." 1>&2
    exit 1
fi

LSF_QUEUE_NAME=`grep queue_name= $ARC_CONFIG | sed 's/^queue_name\s*=*\s*\(\"*\)\(.*\)\1/\2/'`
