#ifndef UI_NGUI
#define UI_NGUI

/* constants for the whichfile argument to ngcat */
#define STDOUT 0
#define STDERR 1
#define GMLOG 2

/* constant used to get the default values for timeout and debug */
#define UNDEFINED -1

#ifdef __cplusplus
#include <string>
#include <vector>
#endif

typedef const char * (* ngversiontype) ();

typedef int (* ngcattype) (const char *const *const jobs,
			   const char *const *const joblists,
			   const char *const *const clusterselect,
			   const char *const *const clusterreject,
			   const char *const *const status,
			   const int all,
			   const int whichfile,
			   const int timeout,
			   const int debug,
			   const int anonymous);

typedef int (* ngcleantype) (const char *const *const jobs,
			     const char *const *const joblists,
			     const char *const *const clusterselect,
			     const char *const *const clusterreject,
			     const char *const *const status,
			     const int all,
			     const int force,
			     const int timeout,
			     const int debug,
			     const int anonymous);

typedef int (* nggettype) (const char *const *const jobs,
			   const char *const *const joblists,
			   const char *const *const clusterselect,
			   const char *const *const clusterreject,
			   const char *const *const status,
			   const int all,
			   const char * directory,
			   const int usejobname,
			   const int keep,
			   const int timeout,
			   const int debug,
			   const int anonymous);

typedef int (* ngkilltype) (const char *const *const jobs,
			    const char *const *const joblists,
			    const char *const *const clusterselect,
			    const char *const *const clusterreject,
			    const char *const *const status,
			    const int all,
			    const int keep,
			    const int timeout,
			    const int debug,
			    const int anonymous);

typedef int (* ngrenewtype) (const char *const *const jobs,
			     const char *const *const joblists,
			     const char *const *const clusterselect,
			     const char *const *const clusterreject,
			     const char *const *const status,
			     const int all,
			     const int timeout,
			     const int debug,
			     const int anonymous);

typedef int (* ngresubtype) (const char *const *const jobs,
			     const char *const *const joblists,
			     const char *const *const clusterselect,
			     const char *const *const clusterreject,
			     const char *const *const status,
			     const int all,
			     const char *const *const klusterselect,
			     const char *const *const klusterreject,
			     const char *const *const giisurls,
			     const char *const joblist,
			     const int dryrun,
			     const int dumpxrsl,
			     const int keep,
			     const int timeout,
			     const int debug,
			     const int anonymous);

typedef int (* ngstattype) (const char *const *const jobs,
			    const char *const *const joblists,
			    const char *const *const clusterselect,
			    const char *const *const clusterreject,
			    const char *const *const status,
			    const int all,
			    const char *const *const giisurls,
			    const int clusters,
			    const int longlist,
			    const int timeout,
			    const int debug,
			    const int anonymous);

typedef int (* ngsubtype) (const char *const *const xrslfiles,
			   const char *const *const xrslstrings,
			   const char *const *const clusterselect,
			   const char *const *const clusterreject,
			   const char *const *const giisurls,
			   const char *const joblist,
			   const int dryrun,
			   const int dumpxrsl,
			   const int timeout,
			   const int debug,
			   const int anonymous);

typedef int (* ngsynctype) (const char *const *const clusterselect,
			    const char *const *const clusterreject,
			    const char *const *const giisurls,
			    const int force,
			    const int timeout,
			    const int debug,
			    const int anonymous);


#ifdef __cplusplus

typedef int (* ngcatxxtype) (const std::vector <std::string> & jobs,
			     const std::vector <std::string> & joblists,
			     const std::vector <std::string> & clusterselect,
			     const std::vector <std::string> & clusterreject,
			     const std::vector <std::string> & status,
			     const bool all,
			     const int whichfile = STDOUT,
			     int timeout = UNDEFINED,
			     int debug = UNDEFINED,
			     const bool anonymous = false);

typedef int (* ngcleanxxtype) (const std::vector <std::string> & jobs,
			       const std::vector <std::string> & joblists,
			       const std::vector <std::string> & clusterselect,
			       const std::vector <std::string> & clusterreject,
			       const std::vector <std::string> & status,
			       const bool all,
			       const bool force = false,
			       int timeout = UNDEFINED,
			       int debug = UNDEFINED,
			       const bool anonymous = false);

typedef int (* nggetxxtype) (const std::vector <std::string> & jobs,
			     const std::vector <std::string> & joblists,
			     const std::vector <std::string> & clusterselect,
			     const std::vector <std::string> & clusterreject,
			     const std::vector <std::string> & status,
			     const bool all,
			     std::string & directory,
			     const bool usejobname = false,
			     const bool keep = false,
			     int timeout = UNDEFINED,
			     int debug = UNDEFINED,
			     const bool anonymous = false);

typedef int (* ngkillxxtype) (const std::vector <std::string> & jobs,
			      const std::vector <std::string> & joblists,
			      const std::vector <std::string> & clusterselect,
			      const std::vector <std::string> & clusterreject,
			      const std::vector <std::string> & status,
			      const bool all,
			      const bool keep = false,
			      int timeout = UNDEFINED,
			      int debug = UNDEFINED,
			      const bool anonymous = false);

typedef int (* ngrenewxxtype) (const std::vector <std::string> & jobs,
			       const std::vector <std::string> & joblists,
			       const std::vector <std::string> & clusterselect,
			       const std::vector <std::string> & clusterreject,
			       const std::vector <std::string> & status,
			       const bool all,
			       int timeout = UNDEFINED,
			       int debug = UNDEFINED,
			       const bool anonymous = false);

typedef int (* ngresubxxtype) (const std::vector <std::string> & jobs,
			       const std::vector <std::string> & joblists,
			       const std::vector <std::string> & clusterselect,
			       const std::vector <std::string> & clusterreject,
			       const std::vector <std::string> & status,
			       const bool all,
			       const std::vector <std::string> & klusterselect,
			       const std::vector <std::string> & klusterreject,
			       const std::vector <std::string> & giisurls,
			       const std::string & joblist,
			       const bool dryrun = false,
			       const bool dumpxrsl = false,
			       const bool keep = false,
			       int timeout = UNDEFINED,
			       int debug = UNDEFINED,
			       const bool anonymous = false);

typedef int (* ngstatxxtype) (const std::vector <std::string> & jobs,
			      const std::vector <std::string> & joblists,
			      const std::vector <std::string> & clusterselect,
			      const std::vector <std::string> & clusterreject,
			      const std::vector <std::string> & status,
			      const bool all,
			      const std::vector <std::string> & giisurls,
			      const bool clusters = false,
			      const bool longlist = false,
			      int timeout = UNDEFINED,
			      int debug = UNDEFINED,
			      const bool anonymous = false);

typedef int (* ngsubxxtype) (const std::vector <std::string> & xrslfiles,
			     const std::vector <std::string> & xrslstrings,
			     const std::vector <std::string> & clusterselect,
			     const std::vector <std::string> & clusterreject,
			     const std::vector <std::string> & giisurls,
			     const std::string & joblist,
			     const bool dryrun = false,
			     const bool dumpxrsl = false,
			     int timeout = UNDEFINED,
			     int debug = UNDEFINED,
			     const bool anonymous = false);

typedef int (* ngsyncxxtype) (const std::vector <std::string> & clusterselect,
			      const std::vector <std::string> & clusterreject,
			      const std::vector <std::string> & giisurls,
			      const bool force = false,
			      int timeout = UNDEFINED,
			      int debug = UNDEFINED,
			      const bool anonymous = false);

#endif


#ifdef __cplusplus
extern "C" {
#endif

const char * ngversion ();

int ngcat (const char *const *const jobs,
	   const char *const *const joblists,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const status,
	   const int all,
	   const int whichfile,
	   const int timeout,
	   const int debug,
	   const int anonymous);

int ngclean (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const int force,
	     const int timeout,
	     const int debug,
	     const int anonymous);

int ngget (const char *const *const jobs,
	   const char *const *const joblists,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const status,
	   const int all,
	   const char * directory,
	   const int usejobname,
	   const int keep,
	   const int timeout,
	   const int debug,
	   const int anonymous);

int ngkill (const char *const *const jobs,
	    const char *const *const joblists,
	    const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const status,
	    const int all,
	    const int keep,
	    const int timeout,
	    const int debug,
	    const int anonymous);

int ngrenew (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const int timeout,
	     const int debug,
	     const int anonymous);

int ngresub (const char *const *const jobs,
	     const char *const *const joblists,
	     const char *const *const clusterselect,
	     const char *const *const clusterreject,
	     const char *const *const status,
	     const int all,
	     const char *const *const klusterselect,
	     const char *const *const klusterreject,
	     const char *const *const giisurls,
	     const char *const joblist,
	     const int dryrun,
	     const int dumpxrsl,
	     const int keep,
	     const int timeout,
	     const int debug,
	     const int anonymous);

int ngstat (const char *const *const jobs,
	    const char *const *const joblists,
	    const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const status,
	    const int all,
	    const char *const *const giisurls,
	    const int clusters,
	    const int longlist,
	    const int timeout,
	    const int debug,
	    const int anonymous);

int ngsub (const char *const *const xrslfiles,
	   const char *const *const xrslstrings,
	   const char *const *const clusterselect,
	   const char *const *const clusterreject,
	   const char *const *const giisurls,
	   const char *const joblist,
	   const int dryrun,
	   const int dumpxrsl,
	   const int timeout,
	   const int debug,
	   const int anonymous);

int ngsync (const char *const *const clusterselect,
	    const char *const *const clusterreject,
	    const char *const *const giisurls,
	    const int force,
	    const int timeout,
	    const int debug,
	    const int anonymous);


#ifdef __cplusplus

int ngcatxx (const std::vector <std::string> & jobs,
	     const std::vector <std::string> & joblists,
	     const std::vector <std::string> & clusterselect,
	     const std::vector <std::string> & clusterreject,
	     const std::vector <std::string> & status,
	     const bool all,
	     const int whichfile = STDOUT,
	     int timeout = UNDEFINED,
	     int debug = UNDEFINED,
	     const bool anonymous = false);

int ngcleanxx (const std::vector <std::string> & jobs,
	       const std::vector <std::string> & joblists,
	       const std::vector <std::string> & clusterselect,
	       const std::vector <std::string> & clusterreject,
	       const std::vector <std::string> & status,
	       const bool all,
	       const bool force = false,
	       int timeout = UNDEFINED,
	       int debug = UNDEFINED,
	       const bool anonymous = false);

int nggetxx (const std::vector <std::string> & jobs,
	     const std::vector <std::string> & joblists,
	     const std::vector <std::string> & clusterselect,
	     const std::vector <std::string> & clusterreject,
	     const std::vector <std::string> & status,
	     const bool all,
	     std::string & directory,
	     const bool usejobname = false,
	     const bool keep = false,
	     int timeout = UNDEFINED,
	     int debug = UNDEFINED,
	     const bool anonymous = false);

int ngkillxx (const std::vector <std::string> & jobs,
	      const std::vector <std::string> & joblists,
	      const std::vector <std::string> & clusterselect,
	      const std::vector <std::string> & clusterreject,
	      const std::vector <std::string> & status,
	      const bool all,
	      const bool keep = false,
	      int timeout = UNDEFINED,
	      int debug = UNDEFINED,
	      const bool anonymous = false);

int ngrenewxx (const std::vector <std::string> & jobs,
	       const std::vector <std::string> & joblists,
	       const std::vector <std::string> & clusterselect,
	       const std::vector <std::string> & clusterreject,
	       const std::vector <std::string> & status,
	       const bool all,
	       int timeout = UNDEFINED,
	       int debug = UNDEFINED,
	       const bool anonymous = false);

int ngresubxx (const std::vector <std::string> & jobs,
	       const std::vector <std::string> & joblists,
	       const std::vector <std::string> & clusterselect,
	       const std::vector <std::string> & clusterreject,
	       const std::vector <std::string> & status,
	       const bool all,
	       const std::vector <std::string> & klusterselect,
	       const std::vector <std::string> & klusterreject,
	       const std::vector <std::string> & giisurls,
	       const std::string & joblist,
	       const bool dryrun = false,
	       const bool dumpxrsl = false,
	       const bool keep = false,
	       int timeout = UNDEFINED,
	       int debug = UNDEFINED,
	       const bool anonymous = false);

int ngstatxx (const std::vector <std::string> & jobs,
	      const std::vector <std::string> & joblists,
	      const std::vector <std::string> & clusterselect,
	      const std::vector <std::string> & clusterreject,
	      const std::vector <std::string> & status,
	      const bool all,
	      const std::vector <std::string> & giisurls,
	      const bool clusters = false,
	      const bool longlist = false,
	      int timeout = UNDEFINED,
	      int debug = UNDEFINED,
	      const bool anonymous = false);

int ngsubxx (const std::vector <std::string> & xrslfiles,
	     const std::vector <std::string> & xrslstrings,
	     const std::vector <std::string> & clusterselect,
	     const std::vector <std::string> & clusterreject,
	     const std::vector <std::string> & giisurls,
	     const std::string & joblist,
	     const bool dryrun = false,
	     const bool dumpxrsl = false,
	     int timeout = UNDEFINED,
	     int debug = UNDEFINED,
	     const bool anonymous = false);

int ngsyncxx (const std::vector <std::string> & clusterselect,
	      const std::vector <std::string> & clusterreject,
	      const std::vector <std::string> & giisurls,
	      const bool force = false,
	      int timeout = UNDEFINED,
	      int debug = UNDEFINED,
	      const bool anonymous = false);

#endif


#ifdef __cplusplus
}
#endif

#endif
