package 	InfosysCluster;
require		Exporter;
@ISA		=qw(Exporter);
@EXPORT		=qw(%config &clusterldif);
@EXPORT_OK	=qw(%config &clusterldif);

use Getopt::Long;
use infosys_shared;
use lib "$ENV{PWD}/";
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
#use warnings;

# Module to initialize Grid Manager dependent variables, to process the configuration file
# and to generate the cluster ldif for the cluster-lrms providers


GetOptions("dn:s" => \$config{dn},
	   "valid-to:i" => \$config{ttl}, 
	   "config:s" => \$config{conf_file},
	   "loglevel:i" => \$config{loglevel},
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --config
				     
		optional arguments:  --valid-to 
		
		this help:	     --help				  		
		\n";
		exit;
}

if (! ($config{dn} and $config{conf_file})) {
    $config{loglevel} and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
};

#
#  default values
#
$config{ttl} ||=  600;
$config{gm_mount_point} ="/jobs";
$config{gm_port} = 2811;
$config{homogeneity} = "True";
chomp ($config{hostname} = `/bin/hostname -f`);
$config{ng_location} ||= $ENV{NORDUGRID_LOCATION} ||= "/opt/nordugrid";
my $hostcert ||= $ENV{X509_USER_CERT} ||= "/etc/grid-security/hostcert.pem";
my $globus_location ||= $ENV{GLOBUS_LOCATION} ||= "/opt/globus/";
my $cache_statfile="statistics";



#
# initialization from the info.conf 
#

unless (open (CONFIGFILE, "<$config{conf_file}")) {
    $config{loglevel} and  &infosys_shared::write_log("can't open $config{conf_file} configuration file");
    die "Can't open $config{conf_file} configuration file\n";
}


my $queue_block;
while (my $line =<CONFIGFILE>) {
   next if $line =~/^#/;
   next if $line =~/^\[/;
   $line=~m/^(\w+)\s*=\s*"(.+)"\s*$/;  
    
#DIRTY parsing solution for skipping queue blocks, will be removed with the new config parser
   (defined $1) and ($1 eq "queue_name") and  $queue_block = "true";       
   if ($queue_block) {  
      ($line =~ /^$/) and $queue_block = "";
       next;
   }    
#end of dirty parsing

   next if $line =~ /^$/;

   ($1 eq "hostname")	   	    and $config{$1} = $2;
   ($1 eq "cluster_alias")	    and $config{$1} = $2;
   ($1 eq "cluster_location")	    and $config{$1} = $2;
   ($1 eq "lrmsconfig") 	    and $config{$1} = $2;
   ($1 eq "homogeneity")	    and $config{$1} = $2;
   ($1 eq "architecture")	    and $config{$1} = $2;
   ($1 eq "nodecpu")		    and $config{$1} = $2;
   ($1 eq "nodememory") 	    and $config{$1} = $2;	      
   ($1 eq "gm_mount_point")	    and $config{$1} = $2;
   ($1 eq "gm_port")		    and $config{$1} = $2;
   ($1 eq "controldir") 	    and $config{$1} = $2; 
   ($1 eq "dedicated_node_string")  and $config{$1} = $2;
   ($1 eq "sessiondir") 	    and $config{$1} = $2;
   ($1 eq "cachedir")	 	    and $config{$1} = $2;
   ($1 eq "comment")	 	    and $config{$1} = $2;
   ($1 eq "runtimedir") 	    and $config{$1} = $2;
   ($1 eq "condor_config")          and $config{$1} = $2;
   ($1 eq "condor_location")        and $config{$1} = $2;  
   ($1 eq "cluster_owner")	    and push @cluster_owner, $2;	   
   ($1 eq "clustersupport") 	    and push @clustersupport, $2;
   ($1 eq "localse")        	    and push @localse, $2;	   
   ($1 eq "middleware")             and push @middleware, $2;  
   ($1 eq "opsys") 		    and push @opsys, $2;
   ($1 eq "nodeaccess") 	    and push @nodeaccess, lc($2);
   ($1 eq "interactive_contactstring") 	    and push @interactive_contactstring, $2;					   
}	
close CONFIGFILE;



#read the gm-jobs information about the number of jobs in different gm states
my %gmjobs;
unless (open GMJOBSOUTPUT,  "$config{ng_location}/bin/gm-jobs -U root 2>/dev/null |") {
    $config{loglevel} and  &infosys_shared::write_log("Error in executing gm-jobs");  
    die "Error in executing gm-jobs\n"; 					      
}

while (my $line= <GMJOBSOUTPUT>) {
    if ($line =~ /^Job:/) {next};					  
    ($line =~ /Jobs total: (\d+)/)    and $gmjobs{"totaljobs"}=$1; 	  
    ($line =~ /ACCEPTED: (\d+)/)      and $gmjobs{"accepted"}=$1; 	  
    ($line =~ /PREPARING: (\d+)/)     and $gmjobs{"preparing"}=$1;	  
    ($line =~ /SUBMIT: (\d+)/)        and $gmjobs{"submit"}=$1; 	  
    ($line =~ /INLRMS: (\d+)/)        and $gmjobs{"inlrms"}=$1; 	  
    ($line =~ /FINISHING: (\d+)/)     and $gmjobs{"finishing"}=$1;	  
    ($line =~ /FINISHED: (\d+)/)      and $gmjobs{"finished"}=$1;	  
    ($line =~ /DELETED: (\d+)/)       and $gmjobs{"deleted"}=$1;	  
    ($line =~ /CANCELING: (\d+)/)     and $gmjobs{"canceling"}=$1;	  
}

close GMJOBSOUTPUT;

sub clusterldif {
    # The DN of the entry
    print "dn: $config{dn}\n";

    # The objectclasses
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-cluster\n";

    # The attributes
    print "nordugrid-cluster-name: $config{hostname}\n";
    $config{cluster_alias} and print "nordugrid-cluster-aliasname: $config{cluster_alias}\n";
    $config{comment} and print "nordugrid-cluster-comment: $config{comment}\n";

    foreach my $listentry (@cluster_owner) {
        print "nordugrid-cluster-owner: $listentry\n";
    }
    $config{cluster_location} and print "nordugrid-cluster-location: $config{cluster_location}\n";

    #nordugrid-cluster-issuerca
    my $hostcert ||= $ENV{X509_USER_CERT} ||= "/etc/grid-security/hostcert.pem";
    my $GLOBUS_LOCATION ||= $ENV{GLOBUS_LOCATION} ||= "/opt/globus/";
    $ENV{"LD_LIBRARY_PATH"}="$GLOBUS_LOCATION/lib";
    my $issuerca=`$globus_location/bin/openssl x509 -noout -issuer -in $hostcert`;
    $issuerca=~s/issuer= //;
    chomp($issuerca);
    print "nordugrid-cluster-issuerca: $issuerca\n";

    #contact string, from now we only support the gridftp submission
    my $cstring = "gsiftp://$config{hostname}:$config{gm_port}$config{gm_mount_point}";
    print "nordugrid-cluster-contactstring: $cstring\n";

    #interactive-contactstring
    foreach my $listentry (@interactive_contactstring) {
       print "nordugrid-cluster-interactive-contactstring: $listentry\n";
    }
     
    #nordugrid-cluster-support
    foreach my $listentry (@clustersupport) {
        print "nordugrid-cluster-support: $listentry\n";
    }

    # nordugrid-cluster-lrms-type
    print "nordugrid-cluster-lrms-type: $main::lrms_type\n";
    print "nordugrid-cluster-lrms-version: $main::lrms_version\n";
    $config{lrmsconfig}  and print "nordugrid-cluster-lrms-config: $config{lrmsconfig}\n";

    #nordugrid-cluster-architecture
    if ($config{architecture}=~/adotf/i) {
        my $tmparch = `uname -m`;
        chomp $tmparch;
        print "nordugrid-cluster-architecture: $tmparch\n";  
    }
    elsif ($config{architecture}){  
        print "nordugrid-cluster-architecture: $config{architecture}\n";
    }

    #nordugrid-cluster-opsys
    foreach my $listentry (@opsys) {
        print "nordugrid-cluster-opsys: $listentry\n";
    }
      
    print "nordugrid-cluster-homogeneity: $config{homogeneity}\n";

    #nordugrid-cluster-nodecpu
    my ($modelname,$mhz);
    if ($config{nodecpu}=~/adotf/i) { 
       unless (open  CPUINFO, "</proc/cpuinfo") {
    	  $config{loglevel} and  &infosys_shared::write_log("error in opening /proc/cpuinfo");
    	  die "Error in opening /proc/cpuinfo";
       }   
       while (my $line= <CPUINFO>) {
    	     if ($line=~/^model name\s+:\s+(.*)$/) {		
    		$modelname=$1;         
    	     }
    	     if ($line=~/^cpu MHz\s+:\s+(.*)$/) {
    		$mhz=$1;
    	     }
       }
       close CPUINFO;
       $nodecpu = "$modelname @ $mhz MHz";
       print "nordugrid-cluster-nodecpu: $nodecpu\n";	      
    }
    elsif ($config{nodecpu}) {
       print "nordugrid-cluster-nodecpu:", $config{nodecpu}, "\n";
    }

    #nordugrid-cluster-nodememory
    $config{nodememory} and print "nordugrid-cluster-nodememory: $config{nodememory}\n";

    #nordugrid-cluster-nodeaccess
    foreach my $listentry (@nodeaccess) {
       print "nordugrid-cluster-nodeaccess: $listentry\n";
    }

    #nordugrid-cluster-totalcpus, usedcpus, cpudistribution 
    print "nordugrid-cluster-totalcpus: $main::totalcpus\n";
    print "nordugrid-cluster-usedcpus: $main::usedcpus\n";
    print "nordugrid-cluster-cpudistribution: $main::cpudistribution\n";


    # nordugrid-cluster-queuedjobs
    # The total number of jobs (grid + nongrid) being queued on the cluster 
    # either in LRMS or in the GM
    unless (-r $config{controldir}) {
      $config{loglevel} and &infosys_shared::write_log("can't access the controldir");
    }
    $gmqueued = $gmjobs{"totaljobs"} - $gmjobs{"deleted"} - $gmjobs{"finished"} - $gmjobs{"finishing"} 
    		- $gmjobs{"inlrms"} - $gmjobs{"canceling"}; 
    print "nordugrid-cluster-queuedjobs: ", $main::lrms_queued + $gmqueued, "\n"; 


    # nordugrid-cluster-totaljobs
    # The total number of 'active' jobs (Grid + non-Grid) in the cluster
    # $main::lrms_total is the total number of jobs in the LRMS (both grid and nongrid)
    # In order to avoid double counting, the number of grid jobs in LRMS state, $gmjobs{"inlrms"}
    # has to be substracted (they counted in $lrms_total too)
    $nonfinish = $gmjobs{"totaljobs"}-$gmjobs{"finishing"}-$gmjobs{"finished"}-$gmjobs{"deleted"};
    $totaljobs = $nonfinish + $main::lrms_total - $gmjobs{"inlrms"};
    print "nordugrid-cluster-totaljobs: $totaljobs\n";  


    #nordugrid-cluster-localse
    foreach my $listentry (@localse) {
        print "nordugrid-cluster-localse: $listentry\n";
    }

    #nordugrid-cluster-sessiondirusage
    my $diskfree;
    my $disktotal;
    if ( -d "$config{sessiondir}") {
      # check if on afs  
      if ($config{sessiondir} =~ /\/afs\//) {
    	    $diskfree =`fs listquota $config{sessiondir} 2>/dev/null`;   
    	    if ($diskfree) {
    	      $diskfree =~ /\n\S+\s+(\d+)\s+(\d+)\s+\d+%\s+\d+%/;
    	      $diskfree = int (($1 - $2)/1024);
    	      $disktotal= int $1/1024;
    	    } 
    	    else {
    	      $diskfree = 0;
    	      $disktotal = 0;
    	    }  
      } 
      # "ordinary" disk 
      else {
    	    $dfstring =`df -k $config{sessiondir} 2>/dev/null`;   
    	    if ($dfstring) {
    	      $dfstring =~ /\n\S+\s+(\d+)\s+\d+\s+(\d+)\s+\d+/;
    	      $diskfree = int $2/1024;
    	      $disktotal = int $1/1024;
    	    }
    	    else {
    	      $diskfree = 0;
    	      $disktotal = 0;
    	    }
      }
    }
    else {
      	$diskfree = 0;
      	$disktotal = 0;
        $config{loglevel} and &infosys_shared::write_log("no sessiondir found");
    }
    print "nordugrid-cluster-sessiondir-free: $diskfree\n";
    print "nordugrid-cluster-sessiondir-total: $disktotal\n";

    #nordugrid-cluster-cacheusage
    if (-e $config{cachedir}){
       $dfstring =`cat $config{cachedir}/$cache_statfile 2>/dev/null`;
       if ($? and $config{loglevel}) {
    	 &infosys_shared::write_log("error in reading the cache status file")
       } 
       $dfstring =~ /softfree=(\d+)/;
       $diskfree = int $1/1024/1024;
       $dfstring =~ /unclaimed=(\d+)/;
       $diskfree += int $1/1024/1024;
       $dfstring =~ /softsize=(\d+)/;
       $disktotal = int $1/1024/1024;
       print "nordugrid-cluster-cache-free: $diskfree\n";
       print "nordugrid-cluster-cache-total: $disktotal\n";
    }

    #nordugrid-cluster-middleware

    #NorduGrid middleware
    #nordugridlocation/bin/grid-manager -v
    my $ngversionstring = `$config{ng_location}/sbin/grid-manager -v`;
    if ($? and $config{loglevel}) {						     
        &infosys_shared::write_log("Can't execute the $config{ng_location}/sbin/grid-manager")   
    }
    $ngversionstring =~ /grid-manager: version\s*(.+)$/ and $ngversion="-".$1;
    if ($ngversionstring) {
    	print "nordugrid-cluster-middleware: nordugrid$ngversion\n";
    }

    #Globus Toolkit
    #globuslocation/share/doc/VERSION
    chomp (my  $globusversion =  `cat $globus_location/share/doc/VERSION 2>/dev/null`);
    if ($? and $config{loglevel}) {						     
        &infosys_shared::write_log("error in reading the globus version file")   
    }									     
    if ($globusversion) {
        print "nordugrid-cluster-middleware: globus-$globusversion\n";
    }

    foreach my $listentry (@middleware) {
      	next if ($ngversionstring and ($listentry =~ /nordugrid/i)); 
      	next if ($globusversion and ($listentry =~ /globus/i));
      	print "nordugrid-cluster-middleware: $listentry\n";      
    }

    #nordugrid-cluster-runtimeenvironment
    if ($config{runtimedir}){
        opendir DIR, $config{runtimedir};
        @runtimeenvironment= `find $config{runtimedir} -type f` ;
        closedir DIR;

        foreach my $listentry (@runtimeenvironment) {
    	  chomp($listentry);	
    	  $listentry=~s/$config{runtimedir}\/*//;
    	  print "nordugrid-cluster-runtimeenvironment: $listentry\n";
        }
    }

    #Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});
}


1;
