package         InfosysQJU;
require         Exporter;
@ISA            =qw(Exporter);
@EXPORT         =qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
@EXPORT_OK      =qw(%config);

use Getopt::Long;
use infosys_shared;
use lib "$ENV{PWD}/";
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
#use warnings;


# Module to initialize Grid Manager dependent variables, to process the configuration file
# and to generate the queue,job,user ldifs for the queue+jobs+users-lrms providers


GetOptions("dn:s" => \$config{dn},	     	  
	   "queue:s" => \$config{queue}, 
	   "config:s" => \$config{conf_file}, 
	   "valid-to:i" => \$config{ttl},   
	   "loglevel:i" => \$config{loglevel},
	   "help|h" => \$print_help   
	  ); 
 
if ($print_help) { 
    print "\n  
     		script usage: 
		mandatory arguments: --dn
				     --queue
				     --config
				      
		optional arguments:  --valid-to 
				     --loglevel
		this help:	     --help			  		
		\n";
		exit;
}

if (! ($config{dn} and $config{queue} and $config{conf_file})) {
    $config{loglevel} and  &infosys_shared::write_log("a command line argument is missing, see --help ");
    die "a command line argument is missing, see --help "
};

#
#  default values
#
$config{ttl}           ||= 600;
$config{gm_mount_point}  = "/jobs";
$config{gm_port}         = 2811;
$config{gridmap} 	 = "/etc/grid-security/grid-mapfile";
chomp ($config{hostname} = `/bin/hostname -f`);


#
# initialization from the info.conf 
#

my $queue_block;
unless (open (CONFIGFILE, "<$config{conf_file}")) {
   $config{loglevel} and  &infosys_shared::write_log("can't open $config{conf_file} configuration file");
   die "Can't open $config{conf_file} configuration file\n";
}

while (my $line =<CONFIGFILE>) {
   next if $line =~/^#/; 
   next if $line =~/^$/; 
   $line=~m/^(\w+)\s*=\s*"(.+)"\s*$/;
   
   ($1 eq "hostname")	  	    and   $config{$1} = $2;
   ($1 eq "controldir") 	    and   $config{$1} = $2;
   ($1 eq "gm_mount_point")	    and   $config{$1} = $2;
   ($1 eq "gm_port")		    and   $config{$1} = $2;
   ($1 eq "gridmap")		    and   $config{$1} = $2;	  	          
   ($1 eq "sessiondir") 	    and   $config{$1} = $2; 
   ($1 eq "dedicated_node_string")  and   $config{$1} = $2;
   ($1 eq "condor_config") 	    and   $config{$1} = $2;
   ($1 eq "condor_location") 	    and   $config{$1} = $2;  

   if ($1 eq "queue_name" and $2 eq $config{queue}) {	       
       $queue_block = "true";
   }

   if ($queue_block) {
       ($1 eq "totalcpus")          and    $config{$1}=$2;
       ($1 eq "nodecpu")  	    and    $config{$1}=$2;
       ($1 eq "nodememory")  	    and    $config{$1}=$2;
       ($1 eq "architecture")  	    and    $config{$1}=$2;
       ($1 eq "opsys") 		    and    push @opsys, $2;	       
       ($1 eq "queue_node_string")  and    $config{$1} = $2; 
       ($1 eq "scheduling_policy")  and    $config{$1} = $2;
       ($1 eq "comment") 	    and    $config{$1} = $2;  
       ($line =~ /^$/) and $queue_block = "";
   }	

}
close CONFIGFILE;

#
# read the mappings from the grid-mapfile to a %users hash, the SN is the key
#

unless (open MAPFILE, "<$config{gridmap}") {
   $config{loglevel} and  &infosys_shared::write_log("can't open gridmapfile");
   die "can't open gridmapfile";
}   
while(my $line = <MAPFILE>) {
    chomp($line);
    if ($line =~ m/\"([^"]+)\"\s+(\S+)/) {
        $users{$1}=$2; 	
    }
}
close MAPFILE;

#
# if sessiondir ="*" read $HOME of the local unix users from "passwd" into the %homedirs{$uid} 
#
my %homedirs;
if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {   
   unless (open PASSWD, "</etc/passwd") {
      $config{loglevel} and  &infosys_shared::write_log("can't open passwd file");
      die "can't open passwd file";
   }	     
   while  (my $line= <PASSWD>) {
       my @passwd_fields = split (":", $line);  
       $homedirs{$passwd_fields[0]}=$passwd_fields[5];
   }
   close PASSWD;
}

if ($config{loglevel} == 2) {  
   my $runtime = time - $^T; 
   &infosys_shared::write_log("CONFIG+GRIDMAP I/O time: $runtime");  
}


#
# read the list of jobs from the jobdir and create the @gridmanager_jobs 
# the @gridmanager_jobs contains the IDs from the job.ID.status
#

$timestamp = time;
unless (opendir JOBDIR,  $config{controldir}) {
   $config{loglevel} and  &infosys_shared::write_log("can't access the directory of the jobstatus files");
   die "Can't access the directory of the jobstatus files\n";
}  

my @allfiles= readdir JOBDIR;
@allfiles= grep /\.status/, @allfiles;
closedir JOBDIR;
@gridmanager_jobs = map {$_=~m/job\.(.+)\.status/; $_=$1;} @allfiles;


#
# read the gridmanager jobinfo into a hash of hashes %hoh_gmjobs 
# filter out jobs not belonging to this $queue
#

my $controldir = $config{controldir};
foreach $ID (@gridmanager_jobs) { 
    my $gmjob_local=$controldir."/job.".$ID.".local";
    my $gmjob_status=$controldir."/job.".$ID.".status";
    my $gmjob_failed=$controldir."/job.".$ID.".failed";  
    my $gmjob_description=$controldir."/job.".$ID.".description"; 
    my $gmjob_diag=$controldir."/job.".$ID.".diag"; 
    
    open (GMJOB_LOCAL, "<$gmjob_local");
    my @local_allines=<GMJOB_LOCAL>;
    
    # check that this job belongs to this queue  
    my $the_right_queue= grep /^queue=$config{queue}$/, @local_allines;
    if (!$the_right_queue) {
       close GMJOB_LOCAL;
       next;
    }
    
    # parse the content of the job.ID.local into the %hoh_gmjobs hash 
    foreach my $line (@local_allines) {		  
  	$line=~m/^(\w+)=(.+)$/; 		   	
  	$hoh_gmjobs{$ID}{$1}=$2;    
    }	 
    close GMJOB_LOCAL;

    # read the job.ID.status into "status"
    open (GMJOB_STATUS, "<$gmjob_status");
    my @status_allines=<GMJOB_STATUS>;    
    chomp (my $job_status_firstline=$status_allines[0]);    
    $hoh_gmjobs{$ID}{"status"}= $job_status_firstline;
    close GMJOB_STATUS;    
    
    if ($hoh_gmjobs{$ID}{"status"} eq "FINISHED") {
      	my @file_stat = stat $gmjob_status;       	  
      	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($file_stat[9]);
        my $file_time = sprintf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z";    
      	$hoh_gmjobs{$ID}{"status"} .= " at: $file_time";	
    }  

    # check for job failure, (job.ID.failed )   "errors"
    if (-e $gmjob_failed) {
       open (GMJOB_FAILED, "<$gmjob_failed");
       my @failed_allines=<GMJOB_FAILED>;    
       chomp (my $job_failed_firstline=$failed_allines[0]);    
       $hoh_gmjobs{$ID}{"errors"}="JOB FAILURE: $job_failed_firstline";
       close GMJOB_FAILED;	        
    } 
    
    # do something with the job.ID.description file
    # read the stdin,stdout,stderr 
    open (GMJOB_DESC, "<$gmjob_description");
    my @desc_allines=<GMJOB_DESC>;    
    chomp (my $rsl_string=$desc_allines[0]);      
    if ($rsl_string=~m/"stdin"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stdin"}=$1;
    }
    if ($rsl_string=~m/"stdout"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stdout"}=$1;	
    }
    if ($rsl_string=~m/"stderr"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"stderr"}=$1;		
    }
    if ($rsl_string=~m/"count"\s+=\s+"(\S+)"/) {
    	$hoh_gmjobs{$ID}{"count"}=$1;	
    }
    else {
        $hoh_gmjobs{$ID}{"count"}="1";
    }
    if ($rsl_string=~m/"cputime"\s+=\s+"(\S+)"/i) {
    	$hoh_gmjobs{$ID}{"reqcputime"}=$1;	
    }      
    # the runtimeenvironment is multivalued, needs further processing at printout
    if ($rsl_string=~m/\("runtimeenvironment"\s+=\s+([^\)]+)/i) {
    	$hoh_gmjobs{$ID}{"runtimeenvironment"}=$1;	
    }
    close GMJOB_DESC;
     
    #read the job.ID.diag file        
    if (-s $gmjob_diag) {
       open (GMJOB_DIAG, "<$gmjob_diag");
          while ($line = <GMJOB_DIAG>) {
	    $line=~m/nodename=(\S+)/     and   $hoh_gmjobs{$ID}{"exec_host"}.=$1."+";
	    $line=~m/WallTime=(\S+)\./   and   $hoh_gmjobs{$ID}{"WallTime"}=int($1/60);
	    $line=~m/KernelTime=(\S+)\./ and   $kerneltime=$1;
	    $line=~m/UserTime=(\S+)\./	 and   $usertime=$1;  
	  }	
 	$hoh_gmjobs{$ID}{"CpuTime"}= int(($kerneltime+$usertime)/60); 
	close GMJOB_DIAG;	  		
   } 	 
}


# calculate the diskspace on the sessiondir, %gridareas{$user} is filled if "sessiondir=*",
# otherwise %gridareas{"common"} set to sessiondir

my %gridareas;
my %diskspaces;
if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {
     while ( ($key,$user) = each %users ) { 	 
         next unless ($gridareas{$user} eq "");
	 if ($homedirs{$user} eq "") {
	    &infosys_shared::write_log("$user is not listed in the passwd file");
	    $gridareas{$user} = "";
	    next;
	 }
         $gridareas{$user} = $homedirs{$user}."/.jobs";	 
     }
}
else {
    $gridareas{"common"} = $config{sessiondir};
}  


foreach $user (keys %gridareas) {
    my $gridarea = $gridareas{$user};
    if ( -d "$gridarea") {						 
      # check if on afs 						 
      if ($gridarea =~ /\/afs\//) {					 
    	    $diskspace =`fs listquota $gridarea 2>/dev/null`;	
	    if ($? != 0) {
                &infosys_shared::write_log("Failed checking diskspace for user=$user, gridarea=$gridarea");
		$diskspace = 0;
	    }	
    	    if ($diskspace) {						
    	      $diskspace =~ /\n\S+\s+(\d+)\s+(\d+)\s+\d+%\s+\d+%/;	
    	      $diskspace = int (($1 - $2)/1024);			
    	    } else {							
    	      $diskspace = 0;						
    	    }								
      # "ordinary" disk 						 
      } else {  							 
    	    $diskspace =`df -k $gridarea 2>/dev/null`;    	    	
	    if ($? != 0) {                
		&infosys_shared::write_log("Failed checking diskspace for user=$user, gridarea=$gridarea");
		$diskspace = 0;
	    }
    	    if ($diskspace) {						
    	      $diskspace =~ /\n\S+\s+\d+\s+\d+\s+(\d+)\s+\d+/;  	
    	      $diskspace=int $1/1024;					
    	    } else {
    	      $diskspace = 0;						
    	    }
      } 								 
    } else {								 
      $diskspace = 0;							 
      $config{loglevel} and &infosys_shared::write_log("sessiondir $gridarea was not found");   
    }
    $diskspaces{$user} = $diskspace;
}


if ($config{loglevel} == 2) {   
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("GM+diskspace I/O time: $runtime");
}


sub queueldif {
    # The dn of the queue entry 
    print "dn: $config{dn}\n";

    # The objectclasses
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-queue\n";

    # The attributes
    print "nordugrid-queue-name: $config{queue}\n";

    my $gm_running = `pgrep grid-manager`;
    if ($? != 0) {
    	$gm_running = `ps -C grid-manager  --no-heading`;     
    	if ($? != 0) {
    	    $config{loglevel} and   &infosys_shared::write_log("Failed checking the grid-manager process");	    
    	}  
    }
    my $gridftp_running = `pgrep gridftpd`;
    if ($? != 0) {
    	$gridftp_running = `ps -C gridftpd --no-heading`;     
    	if ($? != 0) {
    	    $config{loglevel} and   &infosys_shared::write_log("Failed checking the gridftpd process"); 	    
    	}   
    }
    if (not $gm_running) {
    	print "nordugrid-queue-status: inactive, grid-manager is down\n";   
    }
    elsif  (  !($gridftp_running) )  {
       print "nordugrid-queue-status: inactive, gridftp is down\n";  
    }	
    elsif ( ! ($main::lrms_queue_status eq "active")) {
    	    print "nordugrid-queue-status: inactive\n";
    }
    else {
    	    print "nordugrid-queue-status: active\n";
    }

    # nordugrid-queue-running
    print "nordugrid-queue-running: $main::totalrunning_in_the_queue\n";

    #nordugrid-queue-gridrunning
    print "nordugrid-queue-gridrunning: $main::gridrunning\n";

    # nordugrid-queue-queued
    print "nordugrid-queue-queued: $main::totalqueued\n";

    #nordugrid-queue-gridqueued
    print "nordugrid-queue-gridqueued: $main::gridqueued\n";

    # nordugrid-queue-maxrunning
    $main::queue_info{"max_running"} and print "nordugrid-queue-maxrunning: ", $main::queue_info{"max_running"}, "\n";

    # nordugrid-queue-maxinqueue
    $main::queue_info{"max_queuable"} and print "nordugrid-queue-maxqueuable: ", $main::queue_info{"max_queuable"}, "\n";

    # nordugrid-queue-maxuserrun
    $main::queue_info{"max_user_run"} and print "nordugrid-queue-maxuserrun: ", $main::queue_info{"max_user_run"}, "\n";

    # nordugrid-queue-maxcputime (in minutes)
    if ($main::queue_info{"max.cput"}) {
    	print "nordugrid-queue-maxcputime: ", $main::queue_info{"max.cput"}, "\n";
    }

    # nordugrid-queue-mincput (in minutes)
    if ($main::queue_info{"min.cput"}) {
       print "nordugrid-queue-mincputime: ", $main::queue_info{"min.cput"}, "\n";
    }

    # nordugrid-queue-defaultcputime (in minutes)
    if ($main::queue_info{"default.cput"}) {
    	print "nordugrid-queue-defaultcputime: ", $main::queue_info{"default.cput"}, "\n";
    }

    # nordugrid-queue-schedulingpolicy
    $config{scheduling_policy} and print "nordugrid-queue-schedulingpolicy: $config{scheduling_policy}\n";

    # nordugrid-queue-comment
    $config{comment} and print "nordugrid-queue-comment: $config{comment}\n";

    # nordugrid-queue-totalcpus
    if ($config{queue_node_string}) {
       print "nordugrid-queue-totalcpus: $main::totalcpus\n";
    }
    elsif ( $config{totalcpus}) {
       print "nordugrid-queue-totalcpus: $config{totalcpus}\n";
    }	

    # nordugrid-queue-nodecpu
    $config{nodecpu} and print "nordugrid-queue-nodecpu: $config{nodecpu}\n";

    # nordugrid-queue-nodememory
    $config{nodememory} and print "nordugrid-queue-nodememory: $config{nodememory}\n";

    # nordugrid-queue-architecture
    $config{architecture} and print "nordugrid-queue-architecture: $config{architecture}\n";

    #nordugrid-queue-opsys
    foreach my $listentry (@opsys) {
       print "nordugrid-queue-opsys: $listentry\n";
    }

    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});
}


sub  jobsldif {
    # The nordugrid-info-group=jobs entry
    print "dn: nordugrid-info-group-name=jobs, $config{dn}\n"; 
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-info-group\n";
    print "nordugrid-info-group-name: jobs\n";
    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});


    # The loop goes through the %hoh_gmjobs{$ID} where $ID is the unique number from the GM jobID
    # The LRMS jobID is read from the job.xx.local file and stored as
    # $lrmsjobid=$hoh_gmjobs{$ID}{"localid"}
    # Jobs are sorted in a descending order with respect to their jobsubmission time
    foreach my $ID (sort { $hoh_gmjobs{$b}{"starttime"} <=> $hoh_gmjobs{$a}{"starttime"}}
    	    keys %hoh_gmjobs){
    	 
    	 my $lrmsjobid;
    	 if (defined $main::DUMMY_LRMS_VALUES) {
    	    $lrmsjobid = "dummy13"; 
    	 }
	 else {
	    $lrmsjobid=$hoh_gmjobs{$ID}{"localid"}
	 }   
    	 my $nordugrid_globalid="gsiftp://".$config{hostname}.":".$config{gm_port}.$config{gm_mount_point}."/".$ID; 
    	 print "dn: nordugrid-job-globalid=$nordugrid_globalid, nordugrid-info-group-name=jobs, $config{dn}\n";
    	 print "objectclass: Mds\n";
    	 print "objectclass: nordugrid-job\n";   
    	 print "nordugrid-job-globalid: $nordugrid_globalid\n";
    	 print "nordugrid-job-globalowner: ", $hoh_gmjobs{$ID}{"subject"}, "\n";
    	 if ( $hoh_gmjobs{$ID}{"jobname"}) {
    	     print "nordugrid-job-jobname: ", $hoh_gmjobs{$ID}{"jobname"}, "\n";
    	 }
    	 print "nordugrid-job-submissiontime: ",$hoh_gmjobs{$ID}{"starttime"}, "\n";		  
    	 print "nordugrid-job-execcluster: ", $config{hostname}, "\n";
    	 print "nordugrid-job-execqueue: ",$config{queue}, "\n";
    	 if ($hoh_gmjobs{$ID}{"count"}) {
    	     print "nordugrid-job-cpucount: ", $hoh_gmjobs{$ID}{"count"}, "\n";
    	 }
    	 else {
    	     print "nordugrid-job-cpucount: 1\n";
    	 }  
    	 if ($hoh_gmjobs{$ID}{"errors"}) {
    	     print "nordugrid-job-errors: ", $hoh_gmjobs{$ID}{"errors"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"cleanuptime"}) {
    	     print "nordugrid-job-sessiondirerasetime: ",$hoh_gmjobs{$ID}{"cleanuptime"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"stdin"}) {
    	     print "nordugrid-job-stdin: ",$hoh_gmjobs{$ID}{"stdin"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"stdout"}) {
    	     print "nordugrid-job-stdout: ",$hoh_gmjobs{$ID}{"stdout"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"stderr"}) {
    	     print "nordugrid-job-stderr: ",$hoh_gmjobs{$ID}{"stderr"}, "\n";
    	 }
    	 if ($hoh_gmjobs{$ID}{"gmlog"}) {
    	     print "nordugrid-job-gmlog: ",$hoh_gmjobs{$ID}{"gmlog"}, "\n";
    	 }     
    	 if (my $tmpruntimestring = $hoh_gmjobs{$ID}{"runtimeenvironment"}) {	       
    	     while( $tmpruntimestring =~ m/"(\S+)"/g ) {
    		print "nordugrid-job-runtimeenvironment: ",$1, "\n";	
    	     }  		    
    	 }
    	 if ($hoh_gmjobs{$ID}{"clientname"}) {
    	     print "nordugrid-job-submissionui: ",$hoh_gmjobs{$ID}{"clientname"}, "\n";
    	 }		     
    	 if ($hoh_gmjobs{$ID}{"clientsoftware"}) {
    	     print "nordugrid-job-clientsoftware: ",$hoh_gmjobs{$ID}{"clientsoftware"}, "\n";
    	 } 
    	 if ($hoh_gmjobs{$ID}{"delegexpiretime"}) {
    	     print "nordugrid-job-proxyexpirationtime: ",$hoh_gmjobs{$ID}{"delegexpiretime"}, "\n";
    	 }  

    	 #LRMS-dependent attributes taken from LRMS when the job is in state 'INLRMS'
    	 if ($hoh_gmjobs{$ID}{"status"} eq "INLRMS") {
    	     #nordugrid-job-status
    	     # take care of the GM latency, check if the job is in LRMS
    	     # according to both GM and LRMS, GM might think the job 
    	     # is still in LRMS while the job have already left LRMS		     
    	     if ($main::hoh_lrmsjobs{"$lrmsjobid"}{"job_state"}) {   
    		  print "nordugrid-job-status: INLRMS: ",     
    		  $main::hoh_lrmsjobs{"$lrmsjobid"}{"job_state"}, "\n";
    	     }
    	     else {	
    		  print "nordugrid-job-status: FINISHING\n";
    	     }      
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"rank"}) {  
    		  print "nordugrid-job-queuerank: ", $main::hoh_lrmsjobs{$lrmsjobid}{"rank"}, "\n"; 
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.mem"}) {
    		 print "nordugrid-job-usedmem: ", $main::hoh_lrmsjobs{$lrmsjobid}{"used.mem"}, "\n";
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.walltime"}) {  
    		print "nordugrid-job-usedwalltime: ", $main::hoh_lrmsjobs{$lrmsjobid}{"used.walltime"}, "\n" ;
    	     }  	    
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"used.cput"}) {
    		 print "nordugrid-job-usedcputime: ",$main::hoh_lrmsjobs{$lrmsjobid}{"used.cput"}, "\n"; 
    	     }       
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"req.cput"}) {       
    		 print "nordugrid-job-reqcput: ", $main::hoh_lrmsjobs{$lrmsjobid}{"req.cput"},"\n"; 
    	     }
    	     #nordugrid-job-executionnodes
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"exec_host"}) {
    		 my @exec_hosts = split('\+',$main::hoh_lrmsjobs{$lrmsjobid}{"exec_host"});
    		 foreach my $listentry (@exec_hosts) {
    		     print "nordugrid-job-executionnodes: $listentry\n";
    		 }
    	     }
    	     if ($main::hoh_lrmsjobs{$lrmsjobid}{"comment"}) {       
    		 print "nordugrid-job-lrmscomment: ", $main::hoh_lrmsjobs{$lrmsjobid}{"comment"}, "\n";
    	     }    
    	 }     
    	 #LRMS-dependent attributes taken from GM when the job has passed the 'INLRMS' state
    	 else {  
    	     print "nordugrid-job-status: ", $hoh_gmjobs{$ID}{"status"}, "\n";
    	     if ($hoh_gmjobs{$ID}{"WallTime"}) {
    		 print "nordugrid-job-usedwalltime: ", $hoh_gmjobs{$ID}{"WallTime"}, "\n";
    	     }
    	     if ($hoh_gmjobs{$ID}{"CpuTime"})  {   
    		 print "nordugrid-job-usedcputime: ", $hoh_gmjobs{$ID}{"CpuTime"}, "\n";
    	     }
    	     if ($hoh_gmjobs{$ID}{"reqcputime"})  {   
    		 print "nordugrid-job-reqcput: ", $hoh_gmjobs{$ID}{"reqcputime"}, "\n";
    	     }
    	     #nordugrid-job-executionnodes
    	     if ( $hoh_gmjobs{$ID}{"exec_host"}) { 
    		 my @exec_hosts = split('\+',$hoh_gmjobs{$ID}{"exec_host"});
    		 foreach my $listentry (@exec_hosts) {
    		    print "nordugrid-job-executionnodes: $listentry\n";
    		 }
    	     }  	 
    	 }	 
    	 # Mds-validfrom/to
    	 &infosys_shared::mds_valid($config{ttl});
    }
}


sub usersldif {
    # The nordugrid-info-group=users entry 
    print "dn: nordugrid-info-group-name=users, $config{dn}\n";
    print "objectclass: Mds\n";
    print "objectclass: nordugrid-info-group\n";
    print "nordugrid-info-group-name: users\n";
    # Mds-validfrom/to
    &infosys_shared::mds_valid($config{ttl});


    # create the user entries from the LRMS-authorized members of the %users hash
    my $usernumber = 0;
    foreach my $key (sort sort_by_cn keys %users) {

       # check if there is an "acl list" of authorized LRMS users and if the mapping of the 
       # grid user is on this list
       if ( @main::acl_users and !(grep /$users{$key}/, @main::acl_users)) {
       #   print "we skip $users{$key} \n";
    	  next
       }
       

       #nordugrid-authuser-name= CN from the SN  + unique number 
       $key =~ m/\/CN=([^\/]+)(\/Email)?/;
       my $cn = $1;
       $usernumber++;
       print "dn: nordugrid-authuser-name=", $cn, "_", $usernumber, ", nordugrid-info-group-name=users, ", $config{dn}, "\n";
       print "objectclass: Mds\n";
       print "objectclass: nordugrid-authuser\n";
       print "nordugrid-authuser-name: ", $cn, "_", $usernumber, "\n";
       print "nordugrid-authuser-sn: $key\n";
       
       #nordugrid-authuser-diskspace
       if ($config{"sessiondir"} =~ /^\s*\*\s*$/) {
    	  print "nordugrid-authuser-diskspace: $diskspaces{$users{$key}}\n";
       }
       else {	   
    	  print "nordugrid-authuser-diskspace: ", $diskspaces{"common"},"\n";
       }   
       
       $username = $users{$key};       
       #nordugrid-authuser-freecpus
       if ($main::users_freecpus{$username}) {
    	   print "nordugrid-authuser-freecpus: ", $main::users_freecpus{$username}, "\n";
       } 
    	    
       #nordugrid-authuser-queuelength  
       if ($main::users_jobs_queued{$username}) {
    	   print "nordugrid-authuser-queuelength: ", $main::users_jobs_queued{$username}, "\n";   
       }
    	  
       #Mds-validfrom/to
       &infosys_shared::mds_valid($config{ttl});
    }
}


sub sort_by_cn{
    $a =~ m/\/CN=([^\/]+)(\/Email)?/;
    $cn_a=$1;
    $b =~ m/\/CN=([^\/]+)(\/Email)?/;
    $cn_b=$1;	
    $cn_a cmp $cn_b;
}

1;
