#!/usr/bin/perl
use lib "$ENV{PWD}/";
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
use infosys_shared;
use InfosysCluster qw(%config &clusterldif);
use LRMS_Condor;
#use warnings;

# populates the nordugrid-cluster LDAP entry with real GM and config
# The GM interface is factored into the InfosysCluster module.


#<LRMSPORT
# automatically determine the LRMS name(flavour) and version
$lrms_type = nordugrid_cluster_lrms_type();
$lrms_version = nordugrid_cluster_lrms_version();
#LRMSPORT>


#<LRMSPORT
# Calculate the totalcpus & cpudistribution & number of used cpus
# by collecting information from the LRMS
# Consult the schema for the syntax of the $cpudistribution
# If $dedicated_node_string is set, nondedicated nodes, which are not marked with 
# $dedicated_node_string should be skipped
$totalcpus = nordugrid_cluster_totalcpus();
$usedcpus = nordugrid_cluster_usedcpus();
$cpudistribution = nordugrid_cluster_cpudistribution();
#LRMSPORT>


#<LRMSPORT
# Calculate $lrms_queued, the number of jobs (both grid and nongrid) 
# being queued in the LRMS 
$lrms_queued = lrms_get_queued();
#LRMSPORT>


#<LRMSPORT
# Calculate the total number of jobs in the LRMS (running, queued, hold, being in any LRMS state;
# submitted by both grid and nongrid users): $lrms_total
$lrms_total = lrms_get_total();
#LRMSPORT>


# generating the cluster ldif  
&clusterldif;


# some performance test
my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} == 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
   

exit;
