#!/usr/bin/perl 

package infosys_shared;

sub mds_valid ($){
   # Mds-validfrom/to
   my ($ttl) = (@_);  
   my $seconds=time;
   my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($seconds);
   print "Mds-validfrom: ";
   printf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z\n";
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime ($seconds+$ttl);
   print "Mds-validto: ";
   printf "%4d%02d%02d%02d%02d%02d%1s", $year+1900,$mon+1,$mday,$hour,$min,$sec,"Z\n";
   print "\n";
}


sub read_pbsnodes ($$){ 
   #processing the pbsnodes output by using a hash of hashes %hoh_pbsnodes (referrenced by $hashref)
   my ($pbsnodes_command,$hashref) =@_;
   unless (open PBSNODESOUT,  "$pbsnodes_command -a |") {
      write_log("error in executing pbsnodes");
      die "Error in executing pbsnodes";
   }
   while (my $line= <PBSNODESOUT>) {	    
   	 if ($line =~ /^$/) {next}; 
   	 if ($line =~ /^([\w\-]+)/) {		 
   	    $nodeid=$1;
   	    next;	    
   	 }
   	 if ($line =~ / = /)  {
   	     ($node_var,$node_value) = split (/ = /, $line);
   	     $node_var =~ s/\s+//g;
   	     chop $node_value;  	     
   	 }	     
   	 ${$hashref}{$nodeid}{$node_var}=$node_value;     
   } 
   close PBSNODESOUT;
}

sub write_log ($){
  use POSIX;
  #records logging info into the /var/log/infoprovider.log
  my ($message) = @_; 
  my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime (time);
  my $timestamp=POSIX::strftime("%b %d %T", $sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst); 
  my $scriptname= $0; 
  open PROVIDERLOG, '>>/var/log/infoprovider.log';
  print PROVIDERLOG  "$timestamp [$$] $scriptname: $message\n";
  close PROVIDERLOG; 
}  
   
1;
