#!/usr/bin/perl
use lib "$ENV{PWD}/";
use lib "$ENV{NORDUGRID_LOCATION}/libexec";
use lib "/opt/nordugrid/libexec";
use infosys_shared;
use InfosysQJU qw(%config %hoh_gmjobs %users &queueldif &jobsldif &usersldif);
use LRMS_Condor;
#use warnings;


# generates everything under the nordugrid-queue-name=xz,
# creates the queue, job & user entries.
# Real GM and config values are used, but dummy values
# are set for LRMS-dependent  attributes (13, 66 or "dummy").
# The GM interface is factored into the InfosysQJU module.
# Use this template to port the infosys.
# Don't use 'my xyz' for the interfacing GLOBAL variables!


$timestamp = time;


#<LRMSPORT   
# read the queue info such as limits, authorized users' list, etc from the LRMS "queue" command
# into %queue_info and  @acl_users (list of LRMS-authorized unix users, undefined list means
# every unix user is LRMS authorized)

# queue limits, setting dummy values
# don't set the values if they are not relevant to the LRMS
# nordugrid-queue-maxrunning
$queue_info{"max_running"} = nordugrid_queue_maxrunning();
# nordugrid-queue-maxinqueue
$queue_info{"max_queuable"} = nordugrid_queue_maxqueuable();
# nordugrid-queue-maxuserrun
$queue_info{"max_user_run"} = nordugrid_queue_maxuserrun();
# nordugrid-queue-maxcputime (in minutes)
$queue_info{"max.cput"} = nordugrid_queue_maxcputime();
# nordugrid-queue-mincput (in minutes)
$queue_info{"min.cput"} = nordugrid_queue_mincputime();
# nordugrid-queue-defaultcputime (in minutes)
$queue_info{"default.cput"} = nordugrid_queue_defaultcputime();

#LRMSPORT>



#<LRMSPORT
# read the job info from LRMS to a hash of hashes %hoh_lrmsjobs
# The LRMS jobid is the key of the hash, it MUST match the one stored
# in the GM's job.xx.local file as 'localid'
# determine the queue rank of a LRMS queuing job
# $hoh_lrmsjobs{$jobid}{"rank"} = 1 

for (lrms_get_localids()) {
    $hoh_lrmsjobs{$_}{'job_state'} = lrms_get_job_status($_, $config{controldir});
    $hoh_lrmsjobs{$_}{'rank'} = nordugrid_job_queuerank($_);
    $hoh_lrmsjobs{$_}{'used.mem'} = nordugrid_job_usedmem($_);
    $hoh_lrmsjobs{$_}{'used.walltime'} = nordugrid_job_usedwalltime($_);
    $hoh_lrmsjobs{$_}{'used.cput'} = nordugrid_job_usedcputime($_);
    $hoh_lrmsjobs{$_}{'req.cput'} = nordugrid_job_reqcput($_);
    $hoh_lrmsjobs{$_}{'exec_host'} = lrms_get_job_executionnodes($_);
    $hoh_lrmsjobs{$_}{'comment'} = nordugrid_job_lrmscomment($_);
}

#LRMSPORT>


#<LRMSPORT
# scan the LRMS and count the number of running jobs with their multiciplity
# and the number or queued jobs 
# count the jobs per unix users and the number of queueing jobs per users
# These values may be needed for the calculation of the per user freecpus
# useful variables: $user_jobs_queued{$username}, $user_jobs_running{$username}
# required values for the queue entry: $totalrunning_in_the_queue, $totalqueued
# nordugrid-queue-running
$totalrunning_in_the_queue = nordugrid_queue_running();
# nordugrid-queue-queued
$totalqueued = nordugrid_queue_queued();
#LRMSPORT>



#<LRMSPORT
# scan the LRMS in order to find out the $totalcpus and the $usedcpus
# Take into account the $dedicated_node_string or the $queue_node_string
# for distinguishing grid and non-grid enabled nodes (skip nonededicated nodes).
# The $totalcpus and the $usedcpus may be needed for the calculation of the per user freecpus.
# TODO ???
#LRMSPORT>



if ($config{loglevel} == 2) {  
   my $runtime = time - $timestamp; 
   &infosys_shared::write_log("LRMS I/O time: $runtime");  
}


#<LRMSPORT
# Count the running and queued GRID jobs in the LRMS (a subset of all LRMS jobs)
# running jobs are counted with their multiciplity
# you can loop through the hoh_gmjobs and use the "dummy13"=$hoh_gmjobs{$ID}{"localid"}
# and the $hoh_lrmsjobs{"dummy13"}{"job_state"} to find queuing and running grid jobs
# in the LRMS
# Provide the $gridrunning, $gridqueued numbers
#nordugrid-queue-gridrunning
$gridrunning = nordugrid_queue_gridrunning();
#nordugrid-queue-gridqueued
$gridqueued = nordugrid_queue_gridqueued();
#LRMSPORT>



#<LRMSPORT
# nordugrid-queue-status
# determine the $lrms_queue_status from the LRMS
# set it to 'active' if the queue can accept jobs
$lrms_queue_status = lrms_get_queue_status();
#LRMSPORT>


# loop over the mapped local unix users and determine the LRMS-dependent
# freecpus and queuelength for each of them. 
# Use the %users hash which contains the grid user -> local unix user
# mapping info:  $users{Grid_User_SN}=mapped_unix_id
# Take into account queue limits (cpu & time),
# physically available cpus (values determined above) or use LRMS specific method
# Store the result in two hashes, take care of the syntax of the freecpus: cpus[:minutes] 
# here the :minutes part is optional and used for specifying time limit on CPUs.
# $freecpus_for_mapped_users{unix_username}="13:33"
# $user_jobs_queued{$unix_username}=13

for (values %users) {
    #nordugrid-authuser-freecpus
    $users_freecpus{$_} = nordugrid_authuser_freecpus();
    #nordugrid-authuser-queuelength	
    $users_jobs_queued{$_} = nordugrid_authuser_queuelength();
}

#LRMSPORT>

&queueldif;


&jobsldif;


&usersldif;



my $runtime =  time - $^T;
if ($config{loglevel} == 2) {
   &infosys_shared::write_log("execution time: $runtime");
}
elsif ($config{loglevel} = 1 and $runtime >= 4 ) {  
   &infosys_shared::write_log("SLOW script: $runtime");  
}
