/* jsdl_soapC.cpp
   Generated by gSOAP 2.7.8a from jsdl_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "jsdl_soapH.h"

SOAP_SOURCE_STAMP("@(#) jsdl_soapC.cpp ver 2.7.8a 2009-04-06 10:35:38 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_jsdlARC__Reruns_USCOREType:
		return soap_in_jsdlARC__Reruns_USCOREType(soap, NULL, NULL, "jsdlARC:Reruns_Type");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType:
		return soap_in_jsdlARC__SessionLifeTime_USCOREType(soap, NULL, NULL, "jsdlARC:SessionLifeTime_Type");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType:
		return soap_in_jsdlARC__GridTimeLimit_USCOREType(soap, NULL, NULL, "jsdlARC:GridTimeLimit_Type");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_jsdl__CreationFlagEnumeration:
		return soap_in_jsdl__CreationFlagEnumeration(soap, NULL, NULL, "jsdl:CreationFlagEnumeration");
	case SOAP_TYPE_jsdl__FileSystemTypeEnumeration:
		return soap_in_jsdl__FileSystemTypeEnumeration(soap, NULL, NULL, "jsdl:FileSystemTypeEnumeration");
	case SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration:
		return soap_in_jsdl__OperatingSystemTypeEnumeration(soap, NULL, NULL, "jsdl:OperatingSystemTypeEnumeration");
	case SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration:
		return soap_in_jsdl__ProcessorArchitectureEnumeration(soap, NULL, NULL, "jsdl:ProcessorArchitectureEnumeration");
	case SOAP_TYPE_jsdlARC__NotificationType_USCOREType:
		return soap_in_jsdlARC__NotificationType_USCOREType(soap, NULL, NULL, "jsdlARC:NotificationType_Type");
	case SOAP_TYPE_jsdlARC__AccessControlType_USCOREType:
		return soap_in_jsdlARC__AccessControlType_USCOREType(soap, NULL, NULL, "jsdlARC:AccessControlType_Type");
	case SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType:
		return soap_in_jsdlARC__JoinOutputs_USCOREType(soap, NULL, NULL, "jsdlARC:JoinOutputs_Type");
	case SOAP_TYPE_jsdlARC__IsExecutable_USCOREType:
		return soap_in_jsdlARC__IsExecutable_USCOREType(soap, NULL, NULL, "jsdlARC:IsExecutable_Type");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_jsdlARC__SessionType_USCOREType:
		return soap_in_jsdlARC__SessionType_USCOREType(soap, NULL, NULL, "jsdlARC:SessionType_Type");
	case SOAP_TYPE_jsdlARC__GMState_USCOREType:
		return soap_in_jsdlARC__GMState_USCOREType(soap, NULL, NULL, "jsdlARC:GMState_Type");
	case SOAP_TYPE_jsdlARC__Time_USCOREType:
		return soap_in_jsdlARC__Time_USCOREType(soap, NULL, NULL, "jsdlARC:Time_Type");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_jsdl__Description_USCOREType:
		return soap_in_jsdl__Description_USCOREType(soap, NULL, NULL, "jsdl:Description_Type");
	case SOAP_TYPE_jsdlARC__FileParameters_USCOREType:
		return soap_in_jsdlARC__FileParameters_USCOREType(soap, NULL, NULL, "jsdlARC:FileParameters_Type");
	case SOAP_TYPE_jsdl__SourceTarget_USCOREType:
		return soap_in_jsdl__SourceTarget_USCOREType(soap, NULL, NULL, "jsdl:SourceTarget_Type");
	case SOAP_TYPE_jsdl__DataStaging_USCOREType:
		return soap_in_jsdl__DataStaging_USCOREType(soap, NULL, NULL, "jsdl:DataStaging_Type");
	case SOAP_TYPE_jsdl__OperatingSystemType_USCOREType:
		return soap_in_jsdl__OperatingSystemType_USCOREType(soap, NULL, NULL, "jsdl:OperatingSystemType_Type");
	case SOAP_TYPE_jsdl__OperatingSystem_USCOREType:
		return soap_in_jsdl__OperatingSystem_USCOREType(soap, NULL, NULL, "jsdl:OperatingSystem_Type");
	case SOAP_TYPE_jsdl__FileSystem_USCOREType:
		return soap_in_jsdl__FileSystem_USCOREType(soap, NULL, NULL, "jsdl:FileSystem_Type");
	case SOAP_TYPE_jsdl__CPUArchitecture_USCOREType:
		return soap_in_jsdl__CPUArchitecture_USCOREType(soap, NULL, NULL, "jsdl:CPUArchitecture_Type");
	case SOAP_TYPE_jsdl__CandidateHosts_USCOREType:
		return soap_in_jsdl__CandidateHosts_USCOREType(soap, NULL, NULL, "jsdl:CandidateHosts_Type");
	case SOAP_TYPE_jsdl__Resources_USCOREType:
		return soap_in_jsdl__Resources_USCOREType(soap, NULL, NULL, "jsdl:Resources_Type");
	case SOAP_TYPE_jsdl__Application_USCOREType:
		return soap_in_jsdl__Application_USCOREType(soap, NULL, NULL, "jsdl:Application_Type");
	case SOAP_TYPE_jsdl__JobIdentification_USCOREType:
		return soap_in_jsdl__JobIdentification_USCOREType(soap, NULL, NULL, "jsdl:JobIdentification_Type");
	case SOAP_TYPE_jsdl__JobDescription_USCOREType:
		return soap_in_jsdl__JobDescription_USCOREType(soap, NULL, NULL, "jsdl:JobDescription_Type");
	case SOAP_TYPE_jsdl__JobDefinition_USCOREType:
		return soap_in_jsdl__JobDefinition_USCOREType(soap, NULL, NULL, "jsdl:JobDefinition_Type");
	case SOAP_TYPE_jsdl__RangeValue_USCOREType:
		return soap_in_jsdl__RangeValue_USCOREType(soap, NULL, NULL, "jsdl:RangeValue_Type");
	case SOAP_TYPE_jsdl__Range_USCOREType:
		return soap_in_jsdl__Range_USCOREType(soap, NULL, NULL, "jsdl:Range_Type");
	case SOAP_TYPE_jsdl__Exact_USCOREType:
		return soap_in_jsdl__Exact_USCOREType(soap, NULL, NULL, "jsdl:Exact_Type");
	case SOAP_TYPE_jsdl__Boundary_USCOREType:
		return soap_in_jsdl__Boundary_USCOREType(soap, NULL, NULL, "jsdl:Boundary_Type");
	case SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType:
		return soap_in_jsdlARC__CandidateTarget_USCOREType(soap, NULL, NULL, "jsdlARC:CandidateTarget_Type");
	case SOAP_TYPE_jsdlARC__Notify_USCOREType:
		return soap_in_jsdlARC__Notify_USCOREType(soap, NULL, NULL, "jsdlARC:Notify_Type");
	case SOAP_TYPE_jsdlARC__AccessControl_USCOREType:
		return soap_in_jsdlARC__AccessControl_USCOREType(soap, NULL, NULL, "jsdlARC:AccessControl_Type");
	case SOAP_TYPE_jsdlARC__LocalLogging_USCOREType:
		return soap_in_jsdlARC__LocalLogging_USCOREType(soap, NULL, NULL, "jsdlARC:LocalLogging_Type");
	case SOAP_TYPE_jsdlARC__CredentialServer_USCOREType:
		return soap_in_jsdlARC__CredentialServer_USCOREType(soap, NULL, NULL, "jsdlARC:CredentialServer_Type");
	case SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType:
		return soap_in_jsdlARC__RemoteLogging_USCOREType(soap, NULL, NULL, "jsdlARC:RemoteLogging_Type");
	case SOAP_TYPE_jsdlARC__Middleware_USCOREType:
		return soap_in_jsdlARC__Middleware_USCOREType(soap, NULL, NULL, "jsdlARC:Middleware_Type");
	case SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType:
		return soap_in_jsdlARC__RunTimeEnvironment_USCOREType(soap, NULL, NULL, "jsdlARC:RunTimeEnvironment_Type");
	case SOAP_TYPE_jsdlARC__Version_USCOREType:
		return soap_in_jsdlARC__Version_USCOREType(soap, NULL, NULL, "jsdlARC:Version_Type");
	case SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType:
		return soap_in_jsdlPOSIX__POSIXApplication_USCOREType(soap, NULL, NULL, "jsdlPOSIX:POSIXApplication_Type");
	case SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType:
		return soap_in_jsdlPOSIX__GroupName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:GroupName_Type");
	case SOAP_TYPE_jsdlPOSIX__UserName_USCOREType:
		return soap_in_jsdlPOSIX__UserName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:UserName_Type");
	case SOAP_TYPE_jsdlPOSIX__Limits_USCOREType:
		return soap_in_jsdlPOSIX__Limits_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Limits_Type");
	case SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType:
		return soap_in_jsdlPOSIX__DirectoryName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:DirectoryName_Type");
	case SOAP_TYPE_jsdlPOSIX__FileName_USCOREType:
		return soap_in_jsdlPOSIX__FileName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:FileName_Type");
	case SOAP_TYPE_jsdlPOSIX__Argument_USCOREType:
		return soap_in_jsdlPOSIX__Argument_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Argument_Type");
	case SOAP_TYPE_jsdlPOSIX__Environment_USCOREType:
		return soap_in_jsdlPOSIX__Environment_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Environment_Type");
	case SOAP_TYPE_xsd__normalizedString:
		return soap_in_xsd__normalizedString(soap, NULL, NULL, "xsd:normalizedString");
	case SOAP_TYPE_xsd__anyURI:
		return soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_xsd__NCName:
		return soap_in_xsd__NCName(soap, NULL, NULL, "xsd:NCName");
	case SOAP_TYPE_xsd__ID:
		return soap_in_xsd__ID(soap, NULL, NULL, "xsd:ID");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_in_PointerToxsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_PointerTojsdlARC__FileParameters_USCOREType:
		return soap_in_PointerTojsdlARC__FileParameters_USCOREType(soap, NULL, NULL, "jsdlARC:FileParameters_Type");
	case SOAP_TYPE_PointerTojsdlARC__IsExecutable_USCOREType:
		return soap_in_PointerTojsdlARC__IsExecutable_USCOREType(soap, NULL, NULL, "jsdlARC:IsExecutable_Type");
	case SOAP_TYPE_PointerTojsdl__SourceTarget_USCOREType:
		return soap_in_PointerTojsdl__SourceTarget_USCOREType(soap, NULL, NULL, "jsdl:SourceTarget_Type");
	case SOAP_TYPE_PointerTojsdl__OperatingSystemType_USCOREType:
		return soap_in_PointerTojsdl__OperatingSystemType_USCOREType(soap, NULL, NULL, "jsdl:OperatingSystemType_Type");
	case SOAP_TYPE_PointerTojsdl__FileSystemTypeEnumeration:
		return soap_in_PointerTojsdl__FileSystemTypeEnumeration(soap, NULL, NULL, "jsdl:FileSystemTypeEnumeration");
	case SOAP_TYPE_PointerTojsdlARC__RunTimeEnvironment_USCOREType:
		return soap_in_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, NULL, NULL, "jsdlARC:RunTimeEnvironment_Type");
	case SOAP_TYPE_PointerTojsdlARC__Middleware_USCOREType:
		return soap_in_PointerTojsdlARC__Middleware_USCOREType(soap, NULL, NULL, "jsdlARC:Middleware_Type");
	case SOAP_TYPE_PointerTojsdlARC__CandidateTarget_USCOREType:
		return soap_in_PointerTojsdlARC__CandidateTarget_USCOREType(soap, NULL, NULL, "jsdlARC:CandidateTarget_Type");
	case SOAP_TYPE_PointerTojsdlARC__GridTimeLimit_USCOREType:
		return soap_in_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, NULL, NULL, "jsdlARC:GridTimeLimit_Type");
	case SOAP_TYPE_PointerTojsdlARC__SessionType_USCOREType:
		return soap_in_PointerTojsdlARC__SessionType_USCOREType(soap, NULL, NULL, "jsdlARC:SessionType_Type");
	case SOAP_TYPE_PointerTojsdlARC__SessionLifeTime_USCOREType:
		return soap_in_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, NULL, NULL, "jsdlARC:SessionLifeTime_Type");
	case SOAP_TYPE_PointerTojsdl__RangeValue_USCOREType:
		return soap_in_PointerTojsdl__RangeValue_USCOREType(soap, NULL, NULL, "jsdl:RangeValue_Type");
	case SOAP_TYPE_PointerTojsdl__CPUArchitecture_USCOREType:
		return soap_in_PointerTojsdl__CPUArchitecture_USCOREType(soap, NULL, NULL, "jsdl:CPUArchitecture_Type");
	case SOAP_TYPE_PointerTojsdl__OperatingSystem_USCOREType:
		return soap_in_PointerTojsdl__OperatingSystem_USCOREType(soap, NULL, NULL, "jsdl:OperatingSystem_Type");
	case SOAP_TYPE_PointerTojsdl__FileSystem_USCOREType:
		return soap_in_PointerTojsdl__FileSystem_USCOREType(soap, NULL, NULL, "jsdl:FileSystem_Type");
	case SOAP_TYPE_PointerTojsdl__CandidateHosts_USCOREType:
		return soap_in_PointerTojsdl__CandidateHosts_USCOREType(soap, NULL, NULL, "jsdl:CandidateHosts_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__POSIXApplication_USCOREType:
		return soap_in_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, NULL, NULL, "jsdlPOSIX:POSIXApplication_Type");
	case SOAP_TYPE_PointerTojsdl__Description_USCOREType:
		return soap_in_PointerTojsdl__Description_USCOREType(soap, NULL, NULL, "jsdl:Description_Type");
	case SOAP_TYPE_PointerTojsdlARC__Time_USCOREType:
		return soap_in_PointerTojsdlARC__Time_USCOREType(soap, NULL, NULL, "jsdlARC:Time_Type");
	case SOAP_TYPE_PointerTojsdlARC__Reruns_USCOREType:
		return soap_in_PointerTojsdlARC__Reruns_USCOREType(soap, NULL, NULL, "jsdlARC:Reruns_Type");
	case SOAP_TYPE_PointerTojsdlARC__CredentialServer_USCOREType:
		return soap_in_PointerTojsdlARC__CredentialServer_USCOREType(soap, NULL, NULL, "jsdlARC:CredentialServer_Type");
	case SOAP_TYPE_PointerTojsdlARC__RemoteLogging_USCOREType:
		return soap_in_PointerTojsdlARC__RemoteLogging_USCOREType(soap, NULL, NULL, "jsdlARC:RemoteLogging_Type");
	case SOAP_TYPE_PointerTojsdlARC__LocalLogging_USCOREType:
		return soap_in_PointerTojsdlARC__LocalLogging_USCOREType(soap, NULL, NULL, "jsdlARC:LocalLogging_Type");
	case SOAP_TYPE_PointerTojsdlARC__AccessControl_USCOREType:
		return soap_in_PointerTojsdlARC__AccessControl_USCOREType(soap, NULL, NULL, "jsdlARC:AccessControl_Type");
	case SOAP_TYPE_PointerTojsdlARC__Notify_USCOREType:
		return soap_in_PointerTojsdlARC__Notify_USCOREType(soap, NULL, NULL, "jsdlARC:Notify_Type");
	case SOAP_TYPE_PointerTojsdl__DataStaging_USCOREType:
		return soap_in_PointerTojsdl__DataStaging_USCOREType(soap, NULL, NULL, "jsdl:DataStaging_Type");
	case SOAP_TYPE_PointerTojsdl__Resources_USCOREType:
		return soap_in_PointerTojsdl__Resources_USCOREType(soap, NULL, NULL, "jsdl:Resources_Type");
	case SOAP_TYPE_PointerTojsdl__Application_USCOREType:
		return soap_in_PointerTojsdl__Application_USCOREType(soap, NULL, NULL, "jsdl:Application_Type");
	case SOAP_TYPE_PointerTojsdl__JobIdentification_USCOREType:
		return soap_in_PointerTojsdl__JobIdentification_USCOREType(soap, NULL, NULL, "jsdl:JobIdentification_Type");
	case SOAP_TYPE_PointerToxsd__ID:
		return soap_in_PointerToxsd__ID(soap, NULL, NULL, "xsd:ID");
	case SOAP_TYPE_PointerTojsdl__JobDescription_USCOREType:
		return soap_in_PointerTojsdl__JobDescription_USCOREType(soap, NULL, NULL, "jsdl:JobDescription_Type");
	case SOAP_TYPE_PointerTojsdl__Range_USCOREType:
		return soap_in_PointerTojsdl__Range_USCOREType(soap, NULL, NULL, "jsdl:Range_Type");
	case SOAP_TYPE_PointerTojsdl__Exact_USCOREType:
		return soap_in_PointerTojsdl__Exact_USCOREType(soap, NULL, NULL, "jsdl:Exact_Type");
	case SOAP_TYPE_PointerTojsdl__Boundary_USCOREType:
		return soap_in_PointerTojsdl__Boundary_USCOREType(soap, NULL, NULL, "jsdl:Boundary_Type");
	case SOAP_TYPE_PointerTojsdlARC__NotificationType_USCOREType:
		return soap_in_PointerTojsdlARC__NotificationType_USCOREType(soap, NULL, NULL, "jsdlARC:NotificationType_Type");
	case SOAP_TYPE_PointerTojsdlARC__AccessControlType_USCOREType:
		return soap_in_PointerTojsdlARC__AccessControlType_USCOREType(soap, NULL, NULL, "jsdlARC:AccessControlType_Type");
	case SOAP_TYPE_PointerTojsdlARC__Version_USCOREType:
		return soap_in_PointerTojsdlARC__Version_USCOREType(soap, NULL, NULL, "jsdlARC:Version_Type");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToxsd__NCName:
		return soap_in_PointerToxsd__NCName(soap, NULL, NULL, "xsd:NCName");
	case SOAP_TYPE_PointerTojsdlPOSIX__GroupName_USCOREType:
		return soap_in_PointerTojsdlPOSIX__GroupName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:GroupName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__UserName_USCOREType:
		return soap_in_PointerTojsdlPOSIX__UserName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:UserName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Limits_USCOREType:
		return soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Limits_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Environment_USCOREType:
		return soap_in_PointerTojsdlPOSIX__Environment_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Environment_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__DirectoryName_USCOREType:
		return soap_in_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:DirectoryName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Argument_USCOREType:
		return soap_in_PointerTojsdlPOSIX__Argument_USCOREType(soap, NULL, NULL, "jsdlPOSIX:Argument_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__FileName_USCOREType:
		return soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, NULL, NULL, "jsdlPOSIX:FileName_Type");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:Reruns_Type"))
		{	*type = SOAP_TYPE_jsdlARC__Reruns_USCOREType;
			return soap_in_jsdlARC__Reruns_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:SessionLifeTime_Type"))
		{	*type = SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType;
			return soap_in_jsdlARC__SessionLifeTime_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:GridTimeLimit_Type"))
		{	*type = SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType;
			return soap_in_jsdlARC__GridTimeLimit_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:CreationFlagEnumeration"))
		{	*type = SOAP_TYPE_jsdl__CreationFlagEnumeration;
			return soap_in_jsdl__CreationFlagEnumeration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:FileSystemTypeEnumeration"))
		{	*type = SOAP_TYPE_jsdl__FileSystemTypeEnumeration;
			return soap_in_jsdl__FileSystemTypeEnumeration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:OperatingSystemTypeEnumeration"))
		{	*type = SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration;
			return soap_in_jsdl__OperatingSystemTypeEnumeration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:ProcessorArchitectureEnumeration"))
		{	*type = SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration;
			return soap_in_jsdl__ProcessorArchitectureEnumeration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:NotificationType_Type"))
		{	*type = SOAP_TYPE_jsdlARC__NotificationType_USCOREType;
			return soap_in_jsdlARC__NotificationType_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:AccessControlType_Type"))
		{	*type = SOAP_TYPE_jsdlARC__AccessControlType_USCOREType;
			return soap_in_jsdlARC__AccessControlType_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:JoinOutputs_Type"))
		{	*type = SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType;
			return soap_in_jsdlARC__JoinOutputs_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:IsExecutable_Type"))
		{	*type = SOAP_TYPE_jsdlARC__IsExecutable_USCOREType;
			return soap_in_jsdlARC__IsExecutable_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:SessionType_Type"))
		{	*type = SOAP_TYPE_jsdlARC__SessionType_USCOREType;
			return soap_in_jsdlARC__SessionType_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:GMState_Type"))
		{	*type = SOAP_TYPE_jsdlARC__GMState_USCOREType;
			return soap_in_jsdlARC__GMState_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:Time_Type"))
		{	*type = SOAP_TYPE_jsdlARC__Time_USCOREType;
			return soap_in_jsdlARC__Time_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Description_Type"))
		{	*type = SOAP_TYPE_jsdl__Description_USCOREType;
			return soap_in_jsdl__Description_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:FileParameters_Type"))
		{	*type = SOAP_TYPE_jsdlARC__FileParameters_USCOREType;
			return soap_in_jsdlARC__FileParameters_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:SourceTarget_Type"))
		{	*type = SOAP_TYPE_jsdl__SourceTarget_USCOREType;
			return soap_in_jsdl__SourceTarget_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:DataStaging_Type"))
		{	*type = SOAP_TYPE_jsdl__DataStaging_USCOREType;
			return soap_in_jsdl__DataStaging_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:OperatingSystemType_Type"))
		{	*type = SOAP_TYPE_jsdl__OperatingSystemType_USCOREType;
			return soap_in_jsdl__OperatingSystemType_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:OperatingSystem_Type"))
		{	*type = SOAP_TYPE_jsdl__OperatingSystem_USCOREType;
			return soap_in_jsdl__OperatingSystem_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:FileSystem_Type"))
		{	*type = SOAP_TYPE_jsdl__FileSystem_USCOREType;
			return soap_in_jsdl__FileSystem_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:CPUArchitecture_Type"))
		{	*type = SOAP_TYPE_jsdl__CPUArchitecture_USCOREType;
			return soap_in_jsdl__CPUArchitecture_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:CandidateHosts_Type"))
		{	*type = SOAP_TYPE_jsdl__CandidateHosts_USCOREType;
			return soap_in_jsdl__CandidateHosts_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Resources_Type"))
		{	*type = SOAP_TYPE_jsdl__Resources_USCOREType;
			return soap_in_jsdl__Resources_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Application_Type"))
		{	*type = SOAP_TYPE_jsdl__Application_USCOREType;
			return soap_in_jsdl__Application_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:JobIdentification_Type"))
		{	*type = SOAP_TYPE_jsdl__JobIdentification_USCOREType;
			return soap_in_jsdl__JobIdentification_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:JobDescription_Type"))
		{	*type = SOAP_TYPE_jsdl__JobDescription_USCOREType;
			return soap_in_jsdl__JobDescription_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:JobDefinition_Type"))
		{	*type = SOAP_TYPE_jsdl__JobDefinition_USCOREType;
			return soap_in_jsdl__JobDefinition_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:RangeValue_Type"))
		{	*type = SOAP_TYPE_jsdl__RangeValue_USCOREType;
			return soap_in_jsdl__RangeValue_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Range_Type"))
		{	*type = SOAP_TYPE_jsdl__Range_USCOREType;
			return soap_in_jsdl__Range_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Exact_Type"))
		{	*type = SOAP_TYPE_jsdl__Exact_USCOREType;
			return soap_in_jsdl__Exact_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdl:Boundary_Type"))
		{	*type = SOAP_TYPE_jsdl__Boundary_USCOREType;
			return soap_in_jsdl__Boundary_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:CandidateTarget_Type"))
		{	*type = SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType;
			return soap_in_jsdlARC__CandidateTarget_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:Notify_Type"))
		{	*type = SOAP_TYPE_jsdlARC__Notify_USCOREType;
			return soap_in_jsdlARC__Notify_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:AccessControl_Type"))
		{	*type = SOAP_TYPE_jsdlARC__AccessControl_USCOREType;
			return soap_in_jsdlARC__AccessControl_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:LocalLogging_Type"))
		{	*type = SOAP_TYPE_jsdlARC__LocalLogging_USCOREType;
			return soap_in_jsdlARC__LocalLogging_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:CredentialServer_Type"))
		{	*type = SOAP_TYPE_jsdlARC__CredentialServer_USCOREType;
			return soap_in_jsdlARC__CredentialServer_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:RemoteLogging_Type"))
		{	*type = SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType;
			return soap_in_jsdlARC__RemoteLogging_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:Middleware_Type"))
		{	*type = SOAP_TYPE_jsdlARC__Middleware_USCOREType;
			return soap_in_jsdlARC__Middleware_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:RunTimeEnvironment_Type"))
		{	*type = SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType;
			return soap_in_jsdlARC__RunTimeEnvironment_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlARC:Version_Type"))
		{	*type = SOAP_TYPE_jsdlARC__Version_USCOREType;
			return soap_in_jsdlARC__Version_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:POSIXApplication_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType;
			return soap_in_jsdlPOSIX__POSIXApplication_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:GroupName_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType;
			return soap_in_jsdlPOSIX__GroupName_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:UserName_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__UserName_USCOREType;
			return soap_in_jsdlPOSIX__UserName_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:Limits_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__Limits_USCOREType;
			return soap_in_jsdlPOSIX__Limits_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:DirectoryName_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType;
			return soap_in_jsdlPOSIX__DirectoryName_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:FileName_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__FileName_USCOREType;
			return soap_in_jsdlPOSIX__FileName_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:Argument_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__Argument_USCOREType;
			return soap_in_jsdlPOSIX__Argument_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "jsdlPOSIX:Environment_Type"))
		{	*type = SOAP_TYPE_jsdlPOSIX__Environment_USCOREType;
			return soap_in_jsdlPOSIX__Environment_USCOREType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:normalizedString"))
		{	*type = SOAP_TYPE_xsd__normalizedString;
			return soap_in_xsd__normalizedString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	*type = SOAP_TYPE_xsd__anyURI;
			return soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:NCName"))
		{	*type = SOAP_TYPE_xsd__NCName;
			return soap_in_xsd__NCName(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:ID"))
		{	*type = SOAP_TYPE_xsd__ID;
			return soap_in_xsd__ID(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_jsdlARC__Reruns_USCOREType:
		return soap_out_jsdlARC__Reruns_USCOREType(soap, tag, id, (const int *)ptr, "jsdlARC:Reruns_Type");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType:
		return soap_out_jsdlARC__SessionLifeTime_USCOREType(soap, tag, id, (const LONG64 *)ptr, "jsdlARC:SessionLifeTime_Type");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType:
		return soap_out_jsdlARC__GridTimeLimit_USCOREType(soap, tag, id, (const unsigned int *)ptr, "jsdlARC:GridTimeLimit_Type");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_jsdl__CreationFlagEnumeration:
		return soap_out_jsdl__CreationFlagEnumeration(soap, tag, id, (const enum jsdl__CreationFlagEnumeration *)ptr, "jsdl:CreationFlagEnumeration");
	case SOAP_TYPE_jsdl__FileSystemTypeEnumeration:
		return soap_out_jsdl__FileSystemTypeEnumeration(soap, tag, id, (const enum jsdl__FileSystemTypeEnumeration *)ptr, "jsdl:FileSystemTypeEnumeration");
	case SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration:
		return soap_out_jsdl__OperatingSystemTypeEnumeration(soap, tag, id, (const enum jsdl__OperatingSystemTypeEnumeration *)ptr, "jsdl:OperatingSystemTypeEnumeration");
	case SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration:
		return soap_out_jsdl__ProcessorArchitectureEnumeration(soap, tag, id, (const enum jsdl__ProcessorArchitectureEnumeration *)ptr, "jsdl:ProcessorArchitectureEnumeration");
	case SOAP_TYPE_jsdlARC__NotificationType_USCOREType:
		return soap_out_jsdlARC__NotificationType_USCOREType(soap, tag, id, (const enum jsdlARC__NotificationType_USCOREType *)ptr, "jsdlARC:NotificationType_Type");
	case SOAP_TYPE_jsdlARC__AccessControlType_USCOREType:
		return soap_out_jsdlARC__AccessControlType_USCOREType(soap, tag, id, (const enum jsdlARC__AccessControlType_USCOREType *)ptr, "jsdlARC:AccessControlType_Type");
	case SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType:
		return soap_out_jsdlARC__JoinOutputs_USCOREType(soap, tag, id, (const bool *)ptr, "jsdlARC:JoinOutputs_Type");
	case SOAP_TYPE_jsdlARC__IsExecutable_USCOREType:
		return soap_out_jsdlARC__IsExecutable_USCOREType(soap, tag, id, (const bool *)ptr, "jsdlARC:IsExecutable_Type");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_jsdlARC__SessionType_USCOREType:
		return soap_out_jsdlARC__SessionType_USCOREType(soap, tag, id, (const enum jsdlARC__SessionType_USCOREType *)ptr, "jsdlARC:SessionType_Type");
	case SOAP_TYPE_jsdlARC__GMState_USCOREType:
		return soap_out_jsdlARC__GMState_USCOREType(soap, tag, id, (const enum jsdlARC__GMState_USCOREType *)ptr, "jsdlARC:GMState_Type");
	case SOAP_TYPE_jsdlARC__Time_USCOREType:
		return soap_out_jsdlARC__Time_USCOREType(soap, tag, id, (const time_t *)ptr, "jsdlARC:Time_Type");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_jsdl__Description_USCOREType:
		return soap_out_jsdl__Description_USCOREType(soap, tag, id, (const std::string *)ptr, "jsdl:Description_Type");
	case SOAP_TYPE_jsdlARC__FileParameters_USCOREType:
		return soap_out_jsdlARC__FileParameters_USCOREType(soap, tag, id, (const std::string *)ptr, "jsdlARC:FileParameters_Type");
	case SOAP_TYPE_jsdl__SourceTarget_USCOREType:
		return ((jsdl__SourceTarget_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:SourceTarget_Type");
	case SOAP_TYPE_jsdl__DataStaging_USCOREType:
		return ((jsdl__DataStaging_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:DataStaging_Type");
	case SOAP_TYPE_jsdl__OperatingSystemType_USCOREType:
		return ((jsdl__OperatingSystemType_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:OperatingSystemType_Type");
	case SOAP_TYPE_jsdl__OperatingSystem_USCOREType:
		return ((jsdl__OperatingSystem_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:OperatingSystem_Type");
	case SOAP_TYPE_jsdl__FileSystem_USCOREType:
		return ((jsdl__FileSystem_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:FileSystem_Type");
	case SOAP_TYPE_jsdl__CPUArchitecture_USCOREType:
		return ((jsdl__CPUArchitecture_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:CPUArchitecture_Type");
	case SOAP_TYPE_jsdl__CandidateHosts_USCOREType:
		return ((jsdl__CandidateHosts_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:CandidateHosts_Type");
	case SOAP_TYPE_jsdl__Resources_USCOREType:
		return ((jsdl__Resources_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:Resources_Type");
	case SOAP_TYPE_jsdl__Application_USCOREType:
		return ((jsdl__Application_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:Application_Type");
	case SOAP_TYPE_jsdl__JobIdentification_USCOREType:
		return ((jsdl__JobIdentification_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:JobIdentification_Type");
	case SOAP_TYPE_jsdl__JobDescription_USCOREType:
		return ((jsdl__JobDescription_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:JobDescription_Type");
	case SOAP_TYPE_jsdl__JobDefinition_USCOREType:
		return ((jsdl__JobDefinition_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:JobDefinition_Type");
	case SOAP_TYPE_jsdl__RangeValue_USCOREType:
		return ((jsdl__RangeValue_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:RangeValue_Type");
	case SOAP_TYPE_jsdl__Range_USCOREType:
		return ((jsdl__Range_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:Range_Type");
	case SOAP_TYPE_jsdl__Exact_USCOREType:
		return ((jsdl__Exact_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:Exact_Type");
	case SOAP_TYPE_jsdl__Boundary_USCOREType:
		return ((jsdl__Boundary_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdl:Boundary_Type");
	case SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType:
		return ((jsdlARC__CandidateTarget_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:CandidateTarget_Type");
	case SOAP_TYPE_jsdlARC__Notify_USCOREType:
		return ((jsdlARC__Notify_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:Notify_Type");
	case SOAP_TYPE_jsdlARC__AccessControl_USCOREType:
		return ((jsdlARC__AccessControl_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:AccessControl_Type");
	case SOAP_TYPE_jsdlARC__LocalLogging_USCOREType:
		return ((jsdlARC__LocalLogging_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:LocalLogging_Type");
	case SOAP_TYPE_jsdlARC__CredentialServer_USCOREType:
		return ((jsdlARC__CredentialServer_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:CredentialServer_Type");
	case SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType:
		return ((jsdlARC__RemoteLogging_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:RemoteLogging_Type");
	case SOAP_TYPE_jsdlARC__Middleware_USCOREType:
		return ((jsdlARC__Middleware_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:Middleware_Type");
	case SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType:
		return ((jsdlARC__RunTimeEnvironment_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:RunTimeEnvironment_Type");
	case SOAP_TYPE_jsdlARC__Version_USCOREType:
		return ((jsdlARC__Version_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlARC:Version_Type");
	case SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType:
		return ((jsdlPOSIX__POSIXApplication_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:POSIXApplication_Type");
	case SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType:
		return ((jsdlPOSIX__GroupName_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:GroupName_Type");
	case SOAP_TYPE_jsdlPOSIX__UserName_USCOREType:
		return ((jsdlPOSIX__UserName_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:UserName_Type");
	case SOAP_TYPE_jsdlPOSIX__Limits_USCOREType:
		return ((jsdlPOSIX__Limits_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:Limits_Type");
	case SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType:
		return ((jsdlPOSIX__DirectoryName_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:DirectoryName_Type");
	case SOAP_TYPE_jsdlPOSIX__FileName_USCOREType:
		return ((jsdlPOSIX__FileName_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:FileName_Type");
	case SOAP_TYPE_jsdlPOSIX__Argument_USCOREType:
		return ((jsdlPOSIX__Argument_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:Argument_Type");
	case SOAP_TYPE_jsdlPOSIX__Environment_USCOREType:
		return ((jsdlPOSIX__Environment_USCOREType *)ptr)->soap_out(soap, tag, id, "jsdlPOSIX:Environment_Type");
	case SOAP_TYPE_xsd__normalizedString:
		return soap_out_xsd__normalizedString(soap, tag, id, (const std::string *)ptr, "xsd:normalizedString");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_xsd__anyURI(soap, tag, id, (const std::string *)ptr, "xsd:anyURI");
	case SOAP_TYPE_xsd__NCName:
		return soap_out_xsd__NCName(soap, tag, id, (const std::string *)ptr, "xsd:NCName");
	case SOAP_TYPE_xsd__ID:
		return soap_out_xsd__ID(soap, tag, id, (const std::string *)ptr, "xsd:ID");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_out_PointerToxsd__anyURI(soap, tag, id, (std::string *const*)ptr, "xsd:anyURI");
	case SOAP_TYPE_PointerTojsdlARC__FileParameters_USCOREType:
		return soap_out_PointerTojsdlARC__FileParameters_USCOREType(soap, tag, id, (std::string *const*)ptr, "jsdlARC:FileParameters_Type");
	case SOAP_TYPE_PointerTojsdlARC__IsExecutable_USCOREType:
		return soap_out_PointerTojsdlARC__IsExecutable_USCOREType(soap, tag, id, (bool *const*)ptr, "jsdlARC:IsExecutable_Type");
	case SOAP_TYPE_PointerTojsdl__SourceTarget_USCOREType:
		return soap_out_PointerTojsdl__SourceTarget_USCOREType(soap, tag, id, (jsdl__SourceTarget_USCOREType *const*)ptr, "jsdl:SourceTarget_Type");
	case SOAP_TYPE_PointerTojsdl__OperatingSystemType_USCOREType:
		return soap_out_PointerTojsdl__OperatingSystemType_USCOREType(soap, tag, id, (jsdl__OperatingSystemType_USCOREType *const*)ptr, "jsdl:OperatingSystemType_Type");
	case SOAP_TYPE_PointerTojsdl__FileSystemTypeEnumeration:
		return soap_out_PointerTojsdl__FileSystemTypeEnumeration(soap, tag, id, (enum jsdl__FileSystemTypeEnumeration *const*)ptr, "jsdl:FileSystemTypeEnumeration");
	case SOAP_TYPE_PointerTojsdlARC__RunTimeEnvironment_USCOREType:
		return soap_out_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, id, (jsdlARC__RunTimeEnvironment_USCOREType *const*)ptr, "jsdlARC:RunTimeEnvironment_Type");
	case SOAP_TYPE_PointerTojsdlARC__Middleware_USCOREType:
		return soap_out_PointerTojsdlARC__Middleware_USCOREType(soap, tag, id, (jsdlARC__Middleware_USCOREType *const*)ptr, "jsdlARC:Middleware_Type");
	case SOAP_TYPE_PointerTojsdlARC__CandidateTarget_USCOREType:
		return soap_out_PointerTojsdlARC__CandidateTarget_USCOREType(soap, tag, id, (jsdlARC__CandidateTarget_USCOREType *const*)ptr, "jsdlARC:CandidateTarget_Type");
	case SOAP_TYPE_PointerTojsdlARC__GridTimeLimit_USCOREType:
		return soap_out_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, tag, id, (unsigned int *const*)ptr, "jsdlARC:GridTimeLimit_Type");
	case SOAP_TYPE_PointerTojsdlARC__SessionType_USCOREType:
		return soap_out_PointerTojsdlARC__SessionType_USCOREType(soap, tag, id, (enum jsdlARC__SessionType_USCOREType *const*)ptr, "jsdlARC:SessionType_Type");
	case SOAP_TYPE_PointerTojsdlARC__SessionLifeTime_USCOREType:
		return soap_out_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, tag, id, (LONG64 *const*)ptr, "jsdlARC:SessionLifeTime_Type");
	case SOAP_TYPE_PointerTojsdl__RangeValue_USCOREType:
		return soap_out_PointerTojsdl__RangeValue_USCOREType(soap, tag, id, (jsdl__RangeValue_USCOREType *const*)ptr, "jsdl:RangeValue_Type");
	case SOAP_TYPE_PointerTojsdl__CPUArchitecture_USCOREType:
		return soap_out_PointerTojsdl__CPUArchitecture_USCOREType(soap, tag, id, (jsdl__CPUArchitecture_USCOREType *const*)ptr, "jsdl:CPUArchitecture_Type");
	case SOAP_TYPE_PointerTojsdl__OperatingSystem_USCOREType:
		return soap_out_PointerTojsdl__OperatingSystem_USCOREType(soap, tag, id, (jsdl__OperatingSystem_USCOREType *const*)ptr, "jsdl:OperatingSystem_Type");
	case SOAP_TYPE_PointerTojsdl__FileSystem_USCOREType:
		return soap_out_PointerTojsdl__FileSystem_USCOREType(soap, tag, id, (jsdl__FileSystem_USCOREType *const*)ptr, "jsdl:FileSystem_Type");
	case SOAP_TYPE_PointerTojsdl__CandidateHosts_USCOREType:
		return soap_out_PointerTojsdl__CandidateHosts_USCOREType(soap, tag, id, (jsdl__CandidateHosts_USCOREType *const*)ptr, "jsdl:CandidateHosts_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__POSIXApplication_USCOREType:
		return soap_out_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, tag, id, (jsdlPOSIX__POSIXApplication_USCOREType *const*)ptr, "jsdlPOSIX:POSIXApplication_Type");
	case SOAP_TYPE_PointerTojsdl__Description_USCOREType:
		return soap_out_PointerTojsdl__Description_USCOREType(soap, tag, id, (std::string *const*)ptr, "jsdl:Description_Type");
	case SOAP_TYPE_PointerTojsdlARC__Time_USCOREType:
		return soap_out_PointerTojsdlARC__Time_USCOREType(soap, tag, id, (time_t *const*)ptr, "jsdlARC:Time_Type");
	case SOAP_TYPE_PointerTojsdlARC__Reruns_USCOREType:
		return soap_out_PointerTojsdlARC__Reruns_USCOREType(soap, tag, id, (int *const*)ptr, "jsdlARC:Reruns_Type");
	case SOAP_TYPE_PointerTojsdlARC__CredentialServer_USCOREType:
		return soap_out_PointerTojsdlARC__CredentialServer_USCOREType(soap, tag, id, (jsdlARC__CredentialServer_USCOREType *const*)ptr, "jsdlARC:CredentialServer_Type");
	case SOAP_TYPE_PointerTojsdlARC__RemoteLogging_USCOREType:
		return soap_out_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, id, (jsdlARC__RemoteLogging_USCOREType *const*)ptr, "jsdlARC:RemoteLogging_Type");
	case SOAP_TYPE_PointerTojsdlARC__LocalLogging_USCOREType:
		return soap_out_PointerTojsdlARC__LocalLogging_USCOREType(soap, tag, id, (jsdlARC__LocalLogging_USCOREType *const*)ptr, "jsdlARC:LocalLogging_Type");
	case SOAP_TYPE_PointerTojsdlARC__AccessControl_USCOREType:
		return soap_out_PointerTojsdlARC__AccessControl_USCOREType(soap, tag, id, (jsdlARC__AccessControl_USCOREType *const*)ptr, "jsdlARC:AccessControl_Type");
	case SOAP_TYPE_PointerTojsdlARC__Notify_USCOREType:
		return soap_out_PointerTojsdlARC__Notify_USCOREType(soap, tag, id, (jsdlARC__Notify_USCOREType *const*)ptr, "jsdlARC:Notify_Type");
	case SOAP_TYPE_PointerTojsdl__DataStaging_USCOREType:
		return soap_out_PointerTojsdl__DataStaging_USCOREType(soap, tag, id, (jsdl__DataStaging_USCOREType *const*)ptr, "jsdl:DataStaging_Type");
	case SOAP_TYPE_PointerTojsdl__Resources_USCOREType:
		return soap_out_PointerTojsdl__Resources_USCOREType(soap, tag, id, (jsdl__Resources_USCOREType *const*)ptr, "jsdl:Resources_Type");
	case SOAP_TYPE_PointerTojsdl__Application_USCOREType:
		return soap_out_PointerTojsdl__Application_USCOREType(soap, tag, id, (jsdl__Application_USCOREType *const*)ptr, "jsdl:Application_Type");
	case SOAP_TYPE_PointerTojsdl__JobIdentification_USCOREType:
		return soap_out_PointerTojsdl__JobIdentification_USCOREType(soap, tag, id, (jsdl__JobIdentification_USCOREType *const*)ptr, "jsdl:JobIdentification_Type");
	case SOAP_TYPE_PointerToxsd__ID:
		return soap_out_PointerToxsd__ID(soap, tag, id, (std::string *const*)ptr, "xsd:ID");
	case SOAP_TYPE_PointerTojsdl__JobDescription_USCOREType:
		return soap_out_PointerTojsdl__JobDescription_USCOREType(soap, tag, id, (jsdl__JobDescription_USCOREType *const*)ptr, "jsdl:JobDescription_Type");
	case SOAP_TYPE_PointerTojsdl__Range_USCOREType:
		return soap_out_PointerTojsdl__Range_USCOREType(soap, tag, id, (jsdl__Range_USCOREType *const*)ptr, "jsdl:Range_Type");
	case SOAP_TYPE_PointerTojsdl__Exact_USCOREType:
		return soap_out_PointerTojsdl__Exact_USCOREType(soap, tag, id, (jsdl__Exact_USCOREType *const*)ptr, "jsdl:Exact_Type");
	case SOAP_TYPE_PointerTojsdl__Boundary_USCOREType:
		return soap_out_PointerTojsdl__Boundary_USCOREType(soap, tag, id, (jsdl__Boundary_USCOREType *const*)ptr, "jsdl:Boundary_Type");
	case SOAP_TYPE_PointerTojsdlARC__NotificationType_USCOREType:
		return soap_out_PointerTojsdlARC__NotificationType_USCOREType(soap, tag, id, (enum jsdlARC__NotificationType_USCOREType *const*)ptr, "jsdlARC:NotificationType_Type");
	case SOAP_TYPE_PointerTojsdlARC__AccessControlType_USCOREType:
		return soap_out_PointerTojsdlARC__AccessControlType_USCOREType(soap, tag, id, (enum jsdlARC__AccessControlType_USCOREType *const*)ptr, "jsdlARC:AccessControlType_Type");
	case SOAP_TYPE_PointerTojsdlARC__Version_USCOREType:
		return soap_out_PointerTojsdlARC__Version_USCOREType(soap, tag, id, (jsdlARC__Version_USCOREType *const*)ptr, "jsdlARC:Version_Type");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToxsd__NCName:
		return soap_out_PointerToxsd__NCName(soap, tag, id, (std::string *const*)ptr, "xsd:NCName");
	case SOAP_TYPE_PointerTojsdlPOSIX__GroupName_USCOREType:
		return soap_out_PointerTojsdlPOSIX__GroupName_USCOREType(soap, tag, id, (jsdlPOSIX__GroupName_USCOREType *const*)ptr, "jsdlPOSIX:GroupName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__UserName_USCOREType:
		return soap_out_PointerTojsdlPOSIX__UserName_USCOREType(soap, tag, id, (jsdlPOSIX__UserName_USCOREType *const*)ptr, "jsdlPOSIX:UserName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Limits_USCOREType:
		return soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, tag, id, (jsdlPOSIX__Limits_USCOREType *const*)ptr, "jsdlPOSIX:Limits_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Environment_USCOREType:
		return soap_out_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, id, (jsdlPOSIX__Environment_USCOREType *const*)ptr, "jsdlPOSIX:Environment_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__DirectoryName_USCOREType:
		return soap_out_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, tag, id, (jsdlPOSIX__DirectoryName_USCOREType *const*)ptr, "jsdlPOSIX:DirectoryName_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__Argument_USCOREType:
		return soap_out_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, id, (jsdlPOSIX__Argument_USCOREType *const*)ptr, "jsdlPOSIX:Argument_Type");
	case SOAP_TYPE_PointerTojsdlPOSIX__FileName_USCOREType:
		return soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, tag, id, (jsdlPOSIX__FileName_USCOREType *const*)ptr, "jsdlPOSIX:FileName_Type");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_jsdl__Description_USCOREType:
		soap_serialize_jsdl__Description_USCOREType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_jsdlARC__FileParameters_USCOREType:
		soap_serialize_jsdlARC__FileParameters_USCOREType(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_jsdl__SourceTarget_USCOREType:
		((jsdl__SourceTarget_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__DataStaging_USCOREType:
		((jsdl__DataStaging_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__OperatingSystemType_USCOREType:
		((jsdl__OperatingSystemType_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__OperatingSystem_USCOREType:
		((jsdl__OperatingSystem_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__FileSystem_USCOREType:
		((jsdl__FileSystem_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__CPUArchitecture_USCOREType:
		((jsdl__CPUArchitecture_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__CandidateHosts_USCOREType:
		((jsdl__CandidateHosts_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__Resources_USCOREType:
		((jsdl__Resources_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__Application_USCOREType:
		((jsdl__Application_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__JobIdentification_USCOREType:
		((jsdl__JobIdentification_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__JobDescription_USCOREType:
		((jsdl__JobDescription_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__JobDefinition_USCOREType:
		((jsdl__JobDefinition_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__RangeValue_USCOREType:
		((jsdl__RangeValue_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__Range_USCOREType:
		((jsdl__Range_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__Exact_USCOREType:
		((jsdl__Exact_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdl__Boundary_USCOREType:
		((jsdl__Boundary_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType:
		((jsdlARC__CandidateTarget_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__Notify_USCOREType:
		((jsdlARC__Notify_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__AccessControl_USCOREType:
		((jsdlARC__AccessControl_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__LocalLogging_USCOREType:
		((jsdlARC__LocalLogging_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__CredentialServer_USCOREType:
		((jsdlARC__CredentialServer_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType:
		((jsdlARC__RemoteLogging_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__Middleware_USCOREType:
		((jsdlARC__Middleware_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType:
		((jsdlARC__RunTimeEnvironment_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlARC__Version_USCOREType:
		((jsdlARC__Version_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType:
		((jsdlPOSIX__POSIXApplication_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType:
		((jsdlPOSIX__GroupName_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__UserName_USCOREType:
		((jsdlPOSIX__UserName_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__Limits_USCOREType:
		((jsdlPOSIX__Limits_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType:
		((jsdlPOSIX__DirectoryName_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__FileName_USCOREType:
		((jsdlPOSIX__FileName_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__Argument_USCOREType:
		((jsdlPOSIX__Argument_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_jsdlPOSIX__Environment_USCOREType:
		((jsdlPOSIX__Environment_USCOREType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_xsd__normalizedString:
		soap_serialize_xsd__normalizedString(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_xsd__anyURI(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__NCName:
		soap_serialize_xsd__NCName(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_xsd__ID:
		soap_serialize_xsd__ID(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__anyURI:
		soap_serialize_PointerToxsd__anyURI(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__FileParameters_USCOREType:
		soap_serialize_PointerTojsdlARC__FileParameters_USCOREType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__IsExecutable_USCOREType:
		soap_serialize_PointerTojsdlARC__IsExecutable_USCOREType(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__SourceTarget_USCOREType:
		soap_serialize_PointerTojsdl__SourceTarget_USCOREType(soap, (jsdl__SourceTarget_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__OperatingSystemType_USCOREType:
		soap_serialize_PointerTojsdl__OperatingSystemType_USCOREType(soap, (jsdl__OperatingSystemType_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__FileSystemTypeEnumeration:
		soap_serialize_PointerTojsdl__FileSystemTypeEnumeration(soap, (enum jsdl__FileSystemTypeEnumeration *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__RunTimeEnvironment_USCOREType:
		soap_serialize_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, (jsdlARC__RunTimeEnvironment_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__Middleware_USCOREType:
		soap_serialize_PointerTojsdlARC__Middleware_USCOREType(soap, (jsdlARC__Middleware_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__CandidateTarget_USCOREType:
		soap_serialize_PointerTojsdlARC__CandidateTarget_USCOREType(soap, (jsdlARC__CandidateTarget_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__GridTimeLimit_USCOREType:
		soap_serialize_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, (unsigned int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__SessionType_USCOREType:
		soap_serialize_PointerTojsdlARC__SessionType_USCOREType(soap, (enum jsdlARC__SessionType_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__SessionLifeTime_USCOREType:
		soap_serialize_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__RangeValue_USCOREType:
		soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, (jsdl__RangeValue_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__CPUArchitecture_USCOREType:
		soap_serialize_PointerTojsdl__CPUArchitecture_USCOREType(soap, (jsdl__CPUArchitecture_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__OperatingSystem_USCOREType:
		soap_serialize_PointerTojsdl__OperatingSystem_USCOREType(soap, (jsdl__OperatingSystem_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__FileSystem_USCOREType:
		soap_serialize_PointerTojsdl__FileSystem_USCOREType(soap, (jsdl__FileSystem_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__CandidateHosts_USCOREType:
		soap_serialize_PointerTojsdl__CandidateHosts_USCOREType(soap, (jsdl__CandidateHosts_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__POSIXApplication_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, (jsdlPOSIX__POSIXApplication_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Description_USCOREType:
		soap_serialize_PointerTojsdl__Description_USCOREType(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__Time_USCOREType:
		soap_serialize_PointerTojsdlARC__Time_USCOREType(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__Reruns_USCOREType:
		soap_serialize_PointerTojsdlARC__Reruns_USCOREType(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__CredentialServer_USCOREType:
		soap_serialize_PointerTojsdlARC__CredentialServer_USCOREType(soap, (jsdlARC__CredentialServer_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__RemoteLogging_USCOREType:
		soap_serialize_PointerTojsdlARC__RemoteLogging_USCOREType(soap, (jsdlARC__RemoteLogging_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__LocalLogging_USCOREType:
		soap_serialize_PointerTojsdlARC__LocalLogging_USCOREType(soap, (jsdlARC__LocalLogging_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__AccessControl_USCOREType:
		soap_serialize_PointerTojsdlARC__AccessControl_USCOREType(soap, (jsdlARC__AccessControl_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__Notify_USCOREType:
		soap_serialize_PointerTojsdlARC__Notify_USCOREType(soap, (jsdlARC__Notify_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__DataStaging_USCOREType:
		soap_serialize_PointerTojsdl__DataStaging_USCOREType(soap, (jsdl__DataStaging_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Resources_USCOREType:
		soap_serialize_PointerTojsdl__Resources_USCOREType(soap, (jsdl__Resources_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Application_USCOREType:
		soap_serialize_PointerTojsdl__Application_USCOREType(soap, (jsdl__Application_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__JobIdentification_USCOREType:
		soap_serialize_PointerTojsdl__JobIdentification_USCOREType(soap, (jsdl__JobIdentification_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__ID:
		soap_serialize_PointerToxsd__ID(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__JobDescription_USCOREType:
		soap_serialize_PointerTojsdl__JobDescription_USCOREType(soap, (jsdl__JobDescription_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Range_USCOREType:
		soap_serialize_PointerTojsdl__Range_USCOREType(soap, (jsdl__Range_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Exact_USCOREType:
		soap_serialize_PointerTojsdl__Exact_USCOREType(soap, (jsdl__Exact_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdl__Boundary_USCOREType:
		soap_serialize_PointerTojsdl__Boundary_USCOREType(soap, (jsdl__Boundary_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__NotificationType_USCOREType:
		soap_serialize_PointerTojsdlARC__NotificationType_USCOREType(soap, (enum jsdlARC__NotificationType_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__AccessControlType_USCOREType:
		soap_serialize_PointerTojsdlARC__AccessControlType_USCOREType(soap, (enum jsdlARC__AccessControlType_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlARC__Version_USCOREType:
		soap_serialize_PointerTojsdlARC__Version_USCOREType(soap, (jsdlARC__Version_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__NCName:
		soap_serialize_PointerToxsd__NCName(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__GroupName_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__GroupName_USCOREType(soap, (jsdlPOSIX__GroupName_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__UserName_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__UserName_USCOREType(soap, (jsdlPOSIX__UserName_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__Limits_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, (jsdlPOSIX__Limits_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__Environment_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__Environment_USCOREType(soap, (jsdlPOSIX__Environment_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__DirectoryName_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, (jsdlPOSIX__DirectoryName_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__Argument_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__Argument_USCOREType(soap, (jsdlPOSIX__Argument_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTojsdlPOSIX__FileName_USCOREType:
		soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(soap, (jsdlPOSIX__FileName_USCOREType *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__POSIXApplication_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__Version_USCOREType:
		return (void*)soap_instantiate_jsdlARC__Version_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType:
		return (void*)soap_instantiate_jsdlARC__RunTimeEnvironment_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__Middleware_USCOREType:
		return (void*)soap_instantiate_jsdlARC__Middleware_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType:
		return (void*)soap_instantiate_jsdlARC__RemoteLogging_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__CredentialServer_USCOREType:
		return (void*)soap_instantiate_jsdlARC__CredentialServer_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__LocalLogging_USCOREType:
		return (void*)soap_instantiate_jsdlARC__LocalLogging_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__AccessControl_USCOREType:
		return (void*)soap_instantiate_jsdlARC__AccessControl_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__Notify_USCOREType:
		return (void*)soap_instantiate_jsdlARC__Notify_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType:
		return (void*)soap_instantiate_jsdlARC__CandidateTarget_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Range_USCOREType:
		return (void*)soap_instantiate_jsdl__Range_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__RangeValue_USCOREType:
		return (void*)soap_instantiate_jsdl__RangeValue_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__JobDefinition_USCOREType:
		return (void*)soap_instantiate_jsdl__JobDefinition_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__JobDescription_USCOREType:
		return (void*)soap_instantiate_jsdl__JobDescription_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__JobIdentification_USCOREType:
		return (void*)soap_instantiate_jsdl__JobIdentification_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Application_USCOREType:
		return (void*)soap_instantiate_jsdl__Application_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Resources_USCOREType:
		return (void*)soap_instantiate_jsdl__Resources_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__CandidateHosts_USCOREType:
		return (void*)soap_instantiate_jsdl__CandidateHosts_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__CPUArchitecture_USCOREType:
		return (void*)soap_instantiate_jsdl__CPUArchitecture_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__FileSystem_USCOREType:
		return (void*)soap_instantiate_jsdl__FileSystem_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__OperatingSystem_USCOREType:
		return (void*)soap_instantiate_jsdl__OperatingSystem_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__OperatingSystemType_USCOREType:
		return (void*)soap_instantiate_jsdl__OperatingSystemType_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__DataStaging_USCOREType:
		return (void*)soap_instantiate_jsdl__DataStaging_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__SourceTarget_USCOREType:
		return (void*)soap_instantiate_jsdl__SourceTarget_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__Environment_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__Environment_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__Argument_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__Argument_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__FileName_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__FileName_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__DirectoryName_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__Limits_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__Limits_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__UserName_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__UserName_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType:
		return (void*)soap_instantiate_jsdlPOSIX__GroupName_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Boundary_USCOREType:
		return (void*)soap_instantiate_jsdl__Boundary_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Exact_USCOREType:
		return (void*)soap_instantiate_jsdl__Exact_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__ID:
		return (void*)soap_instantiate_xsd__ID(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__NCName:
		return (void*)soap_instantiate_xsd__NCName(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__anyURI:
		return (void*)soap_instantiate_xsd__anyURI(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__normalizedString:
		return (void*)soap_instantiate_xsd__normalizedString(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdlARC__FileParameters_USCOREType:
		return (void*)soap_instantiate_jsdlARC__FileParameters_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_jsdl__Description_USCOREType:
		return (void*)soap_instantiate_jsdl__Description_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Range_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfjsdlARC__GMState_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		return (void*)soap_instantiate_std__vectorTemplateOfstd__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType:
		return (void*)soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__POSIXApplication_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__POSIXApplication_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__Version_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__Version_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__Version_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__RunTimeEnvironment_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__RunTimeEnvironment_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__Middleware_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__Middleware_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__Middleware_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__RemoteLogging_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__RemoteLogging_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__CredentialServer_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__CredentialServer_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__CredentialServer_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__LocalLogging_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__LocalLogging_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__LocalLogging_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__AccessControl_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__AccessControl_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__AccessControl_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__Notify_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__Notify_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__Notify_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType:
		if (p->size < 0)
			delete (jsdlARC__CandidateTarget_USCOREType*)p->ptr;
		else
			delete[] (jsdlARC__CandidateTarget_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Range_USCOREType:
		if (p->size < 0)
			delete (jsdl__Range_USCOREType*)p->ptr;
		else
			delete[] (jsdl__Range_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__RangeValue_USCOREType:
		if (p->size < 0)
			delete (jsdl__RangeValue_USCOREType*)p->ptr;
		else
			delete[] (jsdl__RangeValue_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__JobDefinition_USCOREType:
		if (p->size < 0)
			delete (jsdl__JobDefinition_USCOREType*)p->ptr;
		else
			delete[] (jsdl__JobDefinition_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__JobDescription_USCOREType:
		if (p->size < 0)
			delete (jsdl__JobDescription_USCOREType*)p->ptr;
		else
			delete[] (jsdl__JobDescription_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__JobIdentification_USCOREType:
		if (p->size < 0)
			delete (jsdl__JobIdentification_USCOREType*)p->ptr;
		else
			delete[] (jsdl__JobIdentification_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Application_USCOREType:
		if (p->size < 0)
			delete (jsdl__Application_USCOREType*)p->ptr;
		else
			delete[] (jsdl__Application_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Resources_USCOREType:
		if (p->size < 0)
			delete (jsdl__Resources_USCOREType*)p->ptr;
		else
			delete[] (jsdl__Resources_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__CandidateHosts_USCOREType:
		if (p->size < 0)
			delete (jsdl__CandidateHosts_USCOREType*)p->ptr;
		else
			delete[] (jsdl__CandidateHosts_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__CPUArchitecture_USCOREType:
		if (p->size < 0)
			delete (jsdl__CPUArchitecture_USCOREType*)p->ptr;
		else
			delete[] (jsdl__CPUArchitecture_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__FileSystem_USCOREType:
		if (p->size < 0)
			delete (jsdl__FileSystem_USCOREType*)p->ptr;
		else
			delete[] (jsdl__FileSystem_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__OperatingSystem_USCOREType:
		if (p->size < 0)
			delete (jsdl__OperatingSystem_USCOREType*)p->ptr;
		else
			delete[] (jsdl__OperatingSystem_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__OperatingSystemType_USCOREType:
		if (p->size < 0)
			delete (jsdl__OperatingSystemType_USCOREType*)p->ptr;
		else
			delete[] (jsdl__OperatingSystemType_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__DataStaging_USCOREType:
		if (p->size < 0)
			delete (jsdl__DataStaging_USCOREType*)p->ptr;
		else
			delete[] (jsdl__DataStaging_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__SourceTarget_USCOREType:
		if (p->size < 0)
			delete (jsdl__SourceTarget_USCOREType*)p->ptr;
		else
			delete[] (jsdl__SourceTarget_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__Environment_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__Environment_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__Environment_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__Argument_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__Argument_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__Argument_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__FileName_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__FileName_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__FileName_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__DirectoryName_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__DirectoryName_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__Limits_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__Limits_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__Limits_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__UserName_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__UserName_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__UserName_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType:
		if (p->size < 0)
			delete (jsdlPOSIX__GroupName_USCOREType*)p->ptr;
		else
			delete[] (jsdlPOSIX__GroupName_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Boundary_USCOREType:
		if (p->size < 0)
			delete (jsdl__Boundary_USCOREType*)p->ptr;
		else
			delete[] (jsdl__Boundary_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Exact_USCOREType:
		if (p->size < 0)
			delete (jsdl__Exact_USCOREType*)p->ptr;
		else
			delete[] (jsdl__Exact_USCOREType*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	case SOAP_TYPE_xsd__ID:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__NCName:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__anyURI:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_xsd__normalizedString:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_jsdlARC__FileParameters_USCOREType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_jsdl__Description_USCOREType:
		if (p->size < 0)
			delete (std::string*)p->ptr;
		else
			delete[] (std::string*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlARC__Middleware_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlARC__Middleware_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdl__FileSystem_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdl__FileSystem_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdl__JobDescription_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdl__JobDescription_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlARC__RemoteLogging_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlARC__RemoteLogging_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlARC__Notify_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlARC__Notify_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdl__DataStaging_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdl__DataStaging_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Range_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdl__Range_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdl__Range_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdl__Exact_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdl__Exact_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfjsdlARC__GMState_USCOREType:
		if (p->size < 0)
			delete (std::vector<enum jsdlARC__GMState_USCOREType >*)p->ptr;
		else
			delete[] (std::vector<enum jsdlARC__GMState_USCOREType >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		if (p->size < 0)
			delete (std::vector<std::string >*)p->ptr;
		else
			delete[] (std::vector<std::string >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlPOSIX__Environment_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlPOSIX__Environment_USCOREType * >*)p->ptr;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType:
		if (p->size < 0)
			delete (std::vector<jsdlPOSIX__Argument_USCOREType * >*)p->ptr;
		else
			delete[] (std::vector<jsdlPOSIX__Argument_USCOREType * >*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{	switch (tt)
	{
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)p)[len] = *(jsdlARC__RunTimeEnvironment_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlARC__Middleware_USCOREType * >*)p)[len] = *(jsdlARC__Middleware_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdl__FileSystem_USCOREType * >*)p)[len] = *(jsdl__FileSystem_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdl__JobDescription_USCOREType * >*)p)[len] = *(jsdl__JobDescription_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlARC__RemoteLogging_USCOREType * >*)p)[len] = *(jsdlARC__RemoteLogging_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlARC__Notify_USCOREType * >*)p)[len] = *(jsdlARC__Notify_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdl__DataStaging_USCOREType * >*)p)[len] = *(jsdl__DataStaging_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Range_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdl__Range_USCOREType * >*)p)[len] = *(jsdl__Range_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdl__Exact_USCOREType * >*)p)[len] = *(jsdl__Exact_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfjsdlARC__GMState_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<enum jsdlARC__GMState_USCOREType >*)p)[len] = *(enum jsdlARC__GMState_USCOREType *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfstd__string:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<std::string >*)p)[len] = *(std::string *)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlPOSIX__Environment_USCOREType * >*)p)[len] = *(jsdlPOSIX__Environment_USCOREType **)q;
		break;
	case SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Container insert type=%d in %d location=%p object=%p len=%lu\n", st, tt, p, q, (unsigned long)len));
		(*(std::vector<jsdlPOSIX__Argument_USCOREType * >*)p)[len] = *(jsdlPOSIX__Argument_USCOREType **)q;
		break;
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__Reruns_USCOREType(struct soap *soap, int *a)
{	soap_default_int(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__Reruns_USCOREType(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__Reruns_USCOREType);
	if (soap_out_jsdlARC__Reruns_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__Reruns_USCOREType(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_jsdlARC__Reruns_USCOREType);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_jsdlARC__Reruns_USCOREType(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__Reruns_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_jsdlARC__Reruns_USCOREType(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_jsdlARC__Reruns_USCOREType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__SessionLifeTime_USCOREType(struct soap *soap, LONG64 *a)
{	soap_default_LONG64(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__SessionLifeTime_USCOREType(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType);
	if (soap_out_jsdlARC__SessionLifeTime_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__SessionLifeTime_USCOREType(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_jsdlARC__SessionLifeTime_USCOREType(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__SessionLifeTime_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_jsdlARC__SessionLifeTime_USCOREType(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{
	return soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__GridTimeLimit_USCOREType(struct soap *soap, unsigned int *a)
{	soap_default_unsignedInt(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__GridTimeLimit_USCOREType(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType);
	if (soap_out_jsdlARC__GridTimeLimit_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__GridTimeLimit_USCOREType(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_jsdlARC__GridTimeLimit_USCOREType(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__GridTimeLimit_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_jsdlARC__GridTimeLimit_USCOREType(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdl__CreationFlagEnumeration(struct soap *soap, enum jsdl__CreationFlagEnumeration *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdl__CreationFlagEnumeration
	*a = SOAP_DEFAULT_jsdl__CreationFlagEnumeration;
#else
	*a = (enum jsdl__CreationFlagEnumeration)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdl__CreationFlagEnumeration(struct soap *soap, const enum jsdl__CreationFlagEnumeration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdl__CreationFlagEnumeration);
	if (soap_out_jsdl__CreationFlagEnumeration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdl__CreationFlagEnumeration[] =
{	{ (long)jsdl__CreationFlagEnumeration__overwrite, "overwrite" },
	{ (long)jsdl__CreationFlagEnumeration__append, "append" },
	{ (long)jsdl__CreationFlagEnumeration__dontOverwrite, "dontOverwrite" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdl__CreationFlagEnumeration2s(struct soap *soap, enum jsdl__CreationFlagEnumeration n)
{	const char *s = soap_code_str(soap_codes_jsdl__CreationFlagEnumeration, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__CreationFlagEnumeration(struct soap *soap, const char *tag, int id, const enum jsdl__CreationFlagEnumeration *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__CreationFlagEnumeration), type);
	soap_send(soap, soap_jsdl__CreationFlagEnumeration2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdl__CreationFlagEnumeration * SOAP_FMAC4 soap_get_jsdl__CreationFlagEnumeration(struct soap *soap, enum jsdl__CreationFlagEnumeration *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__CreationFlagEnumeration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdl__CreationFlagEnumeration(struct soap *soap, const char *s, enum jsdl__CreationFlagEnumeration *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdl__CreationFlagEnumeration, s);
	if (map)
		*a = (enum jsdl__CreationFlagEnumeration)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdl__CreationFlagEnumeration)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdl__CreationFlagEnumeration * SOAP_FMAC4 soap_in_jsdl__CreationFlagEnumeration(struct soap *soap, const char *tag, enum jsdl__CreationFlagEnumeration *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdl__CreationFlagEnumeration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__CreationFlagEnumeration, sizeof(enum jsdl__CreationFlagEnumeration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdl__CreationFlagEnumeration(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdl__CreationFlagEnumeration *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__CreationFlagEnumeration, 0, sizeof(enum jsdl__CreationFlagEnumeration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdl__FileSystemTypeEnumeration(struct soap *soap, enum jsdl__FileSystemTypeEnumeration *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdl__FileSystemTypeEnumeration
	*a = SOAP_DEFAULT_jsdl__FileSystemTypeEnumeration;
#else
	*a = (enum jsdl__FileSystemTypeEnumeration)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdl__FileSystemTypeEnumeration(struct soap *soap, const enum jsdl__FileSystemTypeEnumeration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdl__FileSystemTypeEnumeration);
	if (soap_out_jsdl__FileSystemTypeEnumeration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdl__FileSystemTypeEnumeration[] =
{	{ (long)jsdl__FileSystemTypeEnumeration__swap, "swap" },
	{ (long)jsdl__FileSystemTypeEnumeration__temporary, "temporary" },
	{ (long)jsdl__FileSystemTypeEnumeration__spool, "spool" },
	{ (long)jsdl__FileSystemTypeEnumeration__normal, "normal" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdl__FileSystemTypeEnumeration2s(struct soap *soap, enum jsdl__FileSystemTypeEnumeration n)
{	const char *s = soap_code_str(soap_codes_jsdl__FileSystemTypeEnumeration, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__FileSystemTypeEnumeration(struct soap *soap, const char *tag, int id, const enum jsdl__FileSystemTypeEnumeration *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__FileSystemTypeEnumeration), type);
	soap_send(soap, soap_jsdl__FileSystemTypeEnumeration2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdl__FileSystemTypeEnumeration * SOAP_FMAC4 soap_get_jsdl__FileSystemTypeEnumeration(struct soap *soap, enum jsdl__FileSystemTypeEnumeration *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__FileSystemTypeEnumeration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdl__FileSystemTypeEnumeration(struct soap *soap, const char *s, enum jsdl__FileSystemTypeEnumeration *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdl__FileSystemTypeEnumeration, s);
	if (map)
		*a = (enum jsdl__FileSystemTypeEnumeration)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdl__FileSystemTypeEnumeration)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdl__FileSystemTypeEnumeration * SOAP_FMAC4 soap_in_jsdl__FileSystemTypeEnumeration(struct soap *soap, const char *tag, enum jsdl__FileSystemTypeEnumeration *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdl__FileSystemTypeEnumeration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__FileSystemTypeEnumeration, sizeof(enum jsdl__FileSystemTypeEnumeration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdl__FileSystemTypeEnumeration(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdl__FileSystemTypeEnumeration *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__FileSystemTypeEnumeration, 0, sizeof(enum jsdl__FileSystemTypeEnumeration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdl__OperatingSystemTypeEnumeration(struct soap *soap, enum jsdl__OperatingSystemTypeEnumeration *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdl__OperatingSystemTypeEnumeration
	*a = SOAP_DEFAULT_jsdl__OperatingSystemTypeEnumeration;
#else
	*a = (enum jsdl__OperatingSystemTypeEnumeration)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdl__OperatingSystemTypeEnumeration(struct soap *soap, const enum jsdl__OperatingSystemTypeEnumeration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration);
	if (soap_out_jsdl__OperatingSystemTypeEnumeration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdl__OperatingSystemTypeEnumeration[] =
{	{ (long)jsdl__OperatingSystemTypeEnumeration__Unknown, "Unknown" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__MACOS, "MACOS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__ATTUNIX, "ATTUNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__DGUX, "DGUX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__DECNT, "DECNT" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Tru64_USCOREUNIX, "Tru64_UNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OpenVMS, "OpenVMS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__HPUX, "HPUX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__AIX, "AIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__MVS, "MVS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OS400, "OS400" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OS_USCORE2, "OS_2" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__JavaVM, "JavaVM" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__MSDOS, "MSDOS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__WIN3x, "WIN3x" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__WIN95, "WIN95" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__WIN98, "WIN98" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__WINNT, "WINNT" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__WINCE, "WINCE" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__NCR3000, "NCR3000" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__NetWare, "NetWare" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OSF, "OSF" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__DC_USCOREOS, "DC_OS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Reliant_USCOREUNIX, "Reliant_UNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__SCO_USCOREUnixWare, "SCO_UnixWare" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__SCO_USCOREOpenServer, "SCO_OpenServer" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Sequent, "Sequent" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__IRIX, "IRIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Solaris, "Solaris" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__SunOS, "SunOS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__U6000, "U6000" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__ASERIES, "ASERIES" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__TandemNSK, "TandemNSK" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__TandemNT, "TandemNT" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__BS2000, "BS2000" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__LINUX, "LINUX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Lynx, "Lynx" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__XENIX, "XENIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__VM, "VM" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Interactive_USCOREUNIX, "Interactive_UNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__BSDUNIX, "BSDUNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__FreeBSD, "FreeBSD" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__NetBSD, "NetBSD" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__GNU_USCOREHurd, "GNU_Hurd" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OS9, "OS9" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__MACH_USCOREKernel, "MACH_Kernel" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Inferno, "Inferno" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__QNX, "QNX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__EPOC, "EPOC" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__IxWorks, "IxWorks" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__VxWorks, "VxWorks" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__MiNT, "MiNT" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__BeOS, "BeOS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__HP_USCOREMPE, "HP_MPE" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__NextStep, "NextStep" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__PalmPilot, "PalmPilot" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Rhapsody, "Rhapsody" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Windows_USCORE2000, "Windows_2000" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Dedicated, "Dedicated" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OS_USCORE390, "OS_390" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__VSE, "VSE" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__TPF, "TPF" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Windows_USCORER_USCOREMe, "Windows_R_Me" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Caldera_USCOREOpen_USCOREUNIX, "Caldera_Open_UNIX" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__OpenBSD, "OpenBSD" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Not_USCOREApplicable, "Not_Applicable" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__Windows_USCOREXP, "Windows_XP" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__z_USCOREOS, "z_OS" },
	{ (long)jsdl__OperatingSystemTypeEnumeration__other, "other" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdl__OperatingSystemTypeEnumeration2s(struct soap *soap, enum jsdl__OperatingSystemTypeEnumeration n)
{	const char *s = soap_code_str(soap_codes_jsdl__OperatingSystemTypeEnumeration, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__OperatingSystemTypeEnumeration(struct soap *soap, const char *tag, int id, const enum jsdl__OperatingSystemTypeEnumeration *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration), type);
	soap_send(soap, soap_jsdl__OperatingSystemTypeEnumeration2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdl__OperatingSystemTypeEnumeration * SOAP_FMAC4 soap_get_jsdl__OperatingSystemTypeEnumeration(struct soap *soap, enum jsdl__OperatingSystemTypeEnumeration *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__OperatingSystemTypeEnumeration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdl__OperatingSystemTypeEnumeration(struct soap *soap, const char *s, enum jsdl__OperatingSystemTypeEnumeration *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdl__OperatingSystemTypeEnumeration, s);
	if (map)
		*a = (enum jsdl__OperatingSystemTypeEnumeration)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 68)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdl__OperatingSystemTypeEnumeration)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdl__OperatingSystemTypeEnumeration * SOAP_FMAC4 soap_in_jsdl__OperatingSystemTypeEnumeration(struct soap *soap, const char *tag, enum jsdl__OperatingSystemTypeEnumeration *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdl__OperatingSystemTypeEnumeration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration, sizeof(enum jsdl__OperatingSystemTypeEnumeration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdl__OperatingSystemTypeEnumeration(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdl__OperatingSystemTypeEnumeration *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__OperatingSystemTypeEnumeration, 0, sizeof(enum jsdl__OperatingSystemTypeEnumeration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdl__ProcessorArchitectureEnumeration(struct soap *soap, enum jsdl__ProcessorArchitectureEnumeration *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdl__ProcessorArchitectureEnumeration
	*a = SOAP_DEFAULT_jsdl__ProcessorArchitectureEnumeration;
#else
	*a = (enum jsdl__ProcessorArchitectureEnumeration)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdl__ProcessorArchitectureEnumeration(struct soap *soap, const enum jsdl__ProcessorArchitectureEnumeration *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration);
	if (soap_out_jsdl__ProcessorArchitectureEnumeration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdl__ProcessorArchitectureEnumeration[] =
{	{ (long)jsdl__ProcessorArchitectureEnumeration__sparc, "sparc" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__powerpc, "powerpc" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__x86, "x86" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__x86_USCORE32, "x86_32" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__x86_USCORE64, "x86_64" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__parisc, "parisc" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__mips, "mips" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__ia64, "ia64" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__arm, "arm" },
	{ (long)jsdl__ProcessorArchitectureEnumeration__other, "other" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdl__ProcessorArchitectureEnumeration2s(struct soap *soap, enum jsdl__ProcessorArchitectureEnumeration n)
{	const char *s = soap_code_str(soap_codes_jsdl__ProcessorArchitectureEnumeration, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__ProcessorArchitectureEnumeration(struct soap *soap, const char *tag, int id, const enum jsdl__ProcessorArchitectureEnumeration *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration), type);
	soap_send(soap, soap_jsdl__ProcessorArchitectureEnumeration2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdl__ProcessorArchitectureEnumeration * SOAP_FMAC4 soap_get_jsdl__ProcessorArchitectureEnumeration(struct soap *soap, enum jsdl__ProcessorArchitectureEnumeration *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__ProcessorArchitectureEnumeration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdl__ProcessorArchitectureEnumeration(struct soap *soap, const char *s, enum jsdl__ProcessorArchitectureEnumeration *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdl__ProcessorArchitectureEnumeration, s);
	if (map)
		*a = (enum jsdl__ProcessorArchitectureEnumeration)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 9)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdl__ProcessorArchitectureEnumeration)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdl__ProcessorArchitectureEnumeration * SOAP_FMAC4 soap_in_jsdl__ProcessorArchitectureEnumeration(struct soap *soap, const char *tag, enum jsdl__ProcessorArchitectureEnumeration *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdl__ProcessorArchitectureEnumeration *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration, sizeof(enum jsdl__ProcessorArchitectureEnumeration), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdl__ProcessorArchitectureEnumeration(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdl__ProcessorArchitectureEnumeration *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__ProcessorArchitectureEnumeration, 0, sizeof(enum jsdl__ProcessorArchitectureEnumeration), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__NotificationType_USCOREType(struct soap *soap, enum jsdlARC__NotificationType_USCOREType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdlARC__NotificationType_USCOREType
	*a = SOAP_DEFAULT_jsdlARC__NotificationType_USCOREType;
#else
	*a = (enum jsdlARC__NotificationType_USCOREType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__NotificationType_USCOREType(struct soap *soap, const enum jsdlARC__NotificationType_USCOREType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__NotificationType_USCOREType);
	if (soap_out_jsdlARC__NotificationType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdlARC__NotificationType_USCOREType[] =
{	{ (long)jsdlARC__NotificationType_USCOREType__Email, "Email" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__NotificationType_USCOREType2s(struct soap *soap, enum jsdlARC__NotificationType_USCOREType n)
{	const char *s = soap_code_str(soap_codes_jsdlARC__NotificationType_USCOREType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__NotificationType_USCOREType(struct soap *soap, const char *tag, int id, const enum jsdlARC__NotificationType_USCOREType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__NotificationType_USCOREType), type);
	soap_send(soap, soap_jsdlARC__NotificationType_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdlARC__NotificationType_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__NotificationType_USCOREType(struct soap *soap, enum jsdlARC__NotificationType_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__NotificationType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__NotificationType_USCOREType(struct soap *soap, const char *s, enum jsdlARC__NotificationType_USCOREType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdlARC__NotificationType_USCOREType, s);
	if (map)
		*a = (enum jsdlARC__NotificationType_USCOREType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdlARC__NotificationType_USCOREType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdlARC__NotificationType_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__NotificationType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__NotificationType_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdlARC__NotificationType_USCOREType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__NotificationType_USCOREType, sizeof(enum jsdlARC__NotificationType_USCOREType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__NotificationType_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__NotificationType_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__NotificationType_USCOREType, 0, sizeof(enum jsdlARC__NotificationType_USCOREType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__AccessControlType_USCOREType(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdlARC__AccessControlType_USCOREType
	*a = SOAP_DEFAULT_jsdlARC__AccessControlType_USCOREType;
#else
	*a = (enum jsdlARC__AccessControlType_USCOREType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__AccessControlType_USCOREType(struct soap *soap, const enum jsdlARC__AccessControlType_USCOREType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType);
	if (soap_out_jsdlARC__AccessControlType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdlARC__AccessControlType_USCOREType[] =
{	{ (long)jsdlARC__AccessControlType_USCOREType__GACL, "GACL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__AccessControlType_USCOREType2s(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType n)
{	const char *s = soap_code_str(soap_codes_jsdlARC__AccessControlType_USCOREType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__AccessControlType_USCOREType(struct soap *soap, const char *tag, int id, const enum jsdlARC__AccessControlType_USCOREType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType), type);
	soap_send(soap, soap_jsdlARC__AccessControlType_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdlARC__AccessControlType_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__AccessControlType_USCOREType(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__AccessControlType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__AccessControlType_USCOREType(struct soap *soap, const char *s, enum jsdlARC__AccessControlType_USCOREType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdlARC__AccessControlType_USCOREType, s);
	if (map)
		*a = (enum jsdlARC__AccessControlType_USCOREType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 0)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdlARC__AccessControlType_USCOREType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdlARC__AccessControlType_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__AccessControlType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__AccessControlType_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdlARC__AccessControlType_USCOREType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType, sizeof(enum jsdlARC__AccessControlType_USCOREType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__AccessControlType_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__AccessControlType_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType, 0, sizeof(enum jsdlARC__AccessControlType_USCOREType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__JoinOutputs_USCOREType(struct soap *soap, bool *a)
{	soap_default_bool(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__JoinOutputs_USCOREType(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType);
	if (soap_out_jsdlARC__JoinOutputs_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__JoinOutputs_USCOREType2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__JoinOutputs_USCOREType(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType), type);
	soap_send(soap, soap_jsdlARC__JoinOutputs_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_jsdlARC__JoinOutputs_USCOREType(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__JoinOutputs_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__JoinOutputs_USCOREType(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_jsdlARC__JoinOutputs_USCOREType(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, "xsd:boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__JoinOutputs_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__JoinOutputs_USCOREType, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__IsExecutable_USCOREType(struct soap *soap, bool *a)
{	soap_default_bool(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__IsExecutable_USCOREType(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType);
	if (soap_out_jsdlARC__IsExecutable_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__IsExecutable_USCOREType2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__IsExecutable_USCOREType(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType), type);
	soap_send(soap, soap_jsdlARC__IsExecutable_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_jsdlARC__IsExecutable_USCOREType(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__IsExecutable_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__IsExecutable_USCOREType(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_jsdlARC__IsExecutable_USCOREType(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, "xsd:boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__IsExecutable_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_code_str(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__SessionType_USCOREType(struct soap *soap, enum jsdlARC__SessionType_USCOREType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdlARC__SessionType_USCOREType
	*a = SOAP_DEFAULT_jsdlARC__SessionType_USCOREType;
#else
	*a = (enum jsdlARC__SessionType_USCOREType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__SessionType_USCOREType(struct soap *soap, const enum jsdlARC__SessionType_USCOREType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__SessionType_USCOREType);
	if (soap_out_jsdlARC__SessionType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdlARC__SessionType_USCOREType[] =
{	{ (long)jsdlARC__SessionType_USCOREType__INTERNAL, "INTERNAL" },
	{ (long)jsdlARC__SessionType_USCOREType__LIMITED, "LIMITED" },
	{ (long)jsdlARC__SessionType_USCOREType__READONLY, "READONLY" },
	{ (long)jsdlARC__SessionType_USCOREType__FULL, "FULL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__SessionType_USCOREType2s(struct soap *soap, enum jsdlARC__SessionType_USCOREType n)
{	const char *s = soap_code_str(soap_codes_jsdlARC__SessionType_USCOREType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__SessionType_USCOREType(struct soap *soap, const char *tag, int id, const enum jsdlARC__SessionType_USCOREType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__SessionType_USCOREType), type);
	soap_send(soap, soap_jsdlARC__SessionType_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdlARC__SessionType_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__SessionType_USCOREType(struct soap *soap, enum jsdlARC__SessionType_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__SessionType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__SessionType_USCOREType(struct soap *soap, const char *s, enum jsdlARC__SessionType_USCOREType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdlARC__SessionType_USCOREType, s);
	if (map)
		*a = (enum jsdlARC__SessionType_USCOREType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 3)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdlARC__SessionType_USCOREType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdlARC__SessionType_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__SessionType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__SessionType_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdlARC__SessionType_USCOREType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__SessionType_USCOREType, sizeof(enum jsdlARC__SessionType_USCOREType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__SessionType_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__SessionType_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__SessionType_USCOREType, 0, sizeof(enum jsdlARC__SessionType_USCOREType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__GMState_USCOREType(struct soap *soap, enum jsdlARC__GMState_USCOREType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_jsdlARC__GMState_USCOREType
	*a = SOAP_DEFAULT_jsdlARC__GMState_USCOREType;
#else
	*a = (enum jsdlARC__GMState_USCOREType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__GMState_USCOREType(struct soap *soap, const enum jsdlARC__GMState_USCOREType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__GMState_USCOREType);
	if (soap_out_jsdlARC__GMState_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_jsdlARC__GMState_USCOREType[] =
{	{ (long)jsdlARC__GMState_USCOREType__ACCEPTED, "ACCEPTED" },
	{ (long)jsdlARC__GMState_USCOREType__PREPARING, "PREPARING" },
	{ (long)jsdlARC__GMState_USCOREType__SUBMIT, "SUBMIT" },
	{ (long)jsdlARC__GMState_USCOREType__INLRMS, "INLRMS" },
	{ (long)jsdlARC__GMState_USCOREType__FINISHING, "FINISHING" },
	{ (long)jsdlARC__GMState_USCOREType__FINISHED, "FINISHED" },
	{ (long)jsdlARC__GMState_USCOREType__DELETED, "DELETED" },
	{ (long)jsdlARC__GMState_USCOREType__CANCELING, "CANCELING" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_jsdlARC__GMState_USCOREType2s(struct soap *soap, enum jsdlARC__GMState_USCOREType n)
{	const char *s = soap_code_str(soap_codes_jsdlARC__GMState_USCOREType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__GMState_USCOREType(struct soap *soap, const char *tag, int id, const enum jsdlARC__GMState_USCOREType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__GMState_USCOREType), type);
	soap_send(soap, soap_jsdlARC__GMState_USCOREType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum jsdlARC__GMState_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__GMState_USCOREType(struct soap *soap, enum jsdlARC__GMState_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__GMState_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2jsdlARC__GMState_USCOREType(struct soap *soap, const char *s, enum jsdlARC__GMState_USCOREType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_jsdlARC__GMState_USCOREType, s);
	if (map)
		*a = (enum jsdlARC__GMState_USCOREType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 7)))
			return soap->error = SOAP_TYPE;
		*a = (enum jsdlARC__GMState_USCOREType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum jsdlARC__GMState_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__GMState_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__GMState_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum jsdlARC__GMState_USCOREType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__GMState_USCOREType, sizeof(enum jsdlARC__GMState_USCOREType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2jsdlARC__GMState_USCOREType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__GMState_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__GMState_USCOREType, 0, sizeof(enum jsdlARC__GMState_USCOREType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__Time_USCOREType(struct soap *soap, time_t *a)
{	soap_default_time(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__Time_USCOREType(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__Time_USCOREType);
	if (soap_out_jsdlARC__Time_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__Time_USCOREType(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_jsdlARC__Time_USCOREType);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_jsdlARC__Time_USCOREType(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__Time_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_jsdlARC__Time_USCOREType(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_jsdlARC__Time_USCOREType);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_jsdl__Description_USCOREType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdl__Description_USCOREType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdl__Description_USCOREType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdl__Description_USCOREType);
	if (soap_out_jsdl__Description_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Description_USCOREType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_jsdl__Description_USCOREType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_jsdl__Description_USCOREType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Description_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_jsdl__Description_USCOREType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_jsdl__Description_USCOREType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_jsdl__Description_USCOREType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_jsdl__Description_USCOREType, 0, sizeof(std::string), 0, soap_copy_jsdl__Description_USCOREType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_jsdl__Description_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Description_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Description_USCOREType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_jsdl__Description_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Description_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Description_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Description_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_jsdlARC__FileParameters_USCOREType(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_jsdlARC__FileParameters_USCOREType(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_jsdlARC__FileParameters_USCOREType(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_jsdlARC__FileParameters_USCOREType);
	if (soap_out_jsdlARC__FileParameters_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__FileParameters_USCOREType(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_jsdlARC__FileParameters_USCOREType), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_jsdlARC__FileParameters_USCOREType(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__FileParameters_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_jsdlARC__FileParameters_USCOREType(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_jsdlARC__FileParameters_USCOREType, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_jsdlARC__FileParameters_USCOREType, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_jsdlARC__FileParameters_USCOREType, 0, sizeof(std::string), 0, soap_copy_jsdlARC__FileParameters_USCOREType);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_jsdlARC__FileParameters_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__FileParameters_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__FileParameters_USCOREType(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_jsdlARC__FileParameters_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__FileParameters_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__FileParameters_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__FileParameters_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void jsdl__SourceTarget_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__anyURI(soap, &((jsdl__SourceTarget_USCOREType*)this)->URI);
	/* transient soap skipped */
}

void jsdl__SourceTarget_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__SourceTarget_USCOREType*)this)->URI = NULL;
	((jsdl__SourceTarget_USCOREType*)this)->__any = NULL;
	((jsdl__SourceTarget_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__SourceTarget_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__SourceTarget_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__SourceTarget_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__SourceTarget_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__SourceTarget_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__SourceTarget_USCOREType *a, const char *type)
{
	if (((jsdl__SourceTarget_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__SourceTarget_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__SourceTarget_USCOREType), type);
	soap_out_PointerToxsd__anyURI(soap, "jsdl:URI", -1, &(((jsdl__SourceTarget_USCOREType*)a)->URI), "");
	soap_outliteral(soap, "-any", &(((jsdl__SourceTarget_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__SourceTarget_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__SourceTarget_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__SourceTarget_USCOREType * SOAP_FMAC4 soap_get_jsdl__SourceTarget_USCOREType(struct soap *soap, jsdl__SourceTarget_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__SourceTarget_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__SourceTarget_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__SourceTarget_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__SourceTarget_USCOREType * SOAP_FMAC4 soap_in_jsdl__SourceTarget_USCOREType(struct soap *soap, const char *tag, jsdl__SourceTarget_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__SourceTarget_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__SourceTarget_USCOREType, sizeof(jsdl__SourceTarget_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__SourceTarget_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__SourceTarget_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__SourceTarget_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_URI1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_URI1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerToxsd__anyURI(soap, "jsdl:URI", &(((jsdl__SourceTarget_USCOREType*)a)->URI), "xsd:anyURI"))
				{	soap_flag_URI1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__SourceTarget_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__SourceTarget_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__SourceTarget_USCOREType, 0, sizeof(jsdl__SourceTarget_USCOREType), 0, soap_copy_jsdl__SourceTarget_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__SourceTarget_USCOREType * SOAP_FMAC6 soap_new_jsdl__SourceTarget_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__SourceTarget_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__SourceTarget_USCOREType(struct soap *soap, jsdl__SourceTarget_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__SourceTarget_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__SourceTarget_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__SourceTarget_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__SourceTarget_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__SourceTarget_USCOREType;
		if (size)
			*size = sizeof(jsdl__SourceTarget_USCOREType);
		((jsdl__SourceTarget_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__SourceTarget_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__SourceTarget_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__SourceTarget_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__SourceTarget_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__SourceTarget_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__SourceTarget_USCOREType %p -> %p\n", q, p));
	*(jsdl__SourceTarget_USCOREType*)p = *(jsdl__SourceTarget_USCOREType*)q;
}

void jsdl__DataStaging_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdl__DataStaging_USCOREType*)this)->FileName, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdl__DataStaging_USCOREType*)this)->FileName);
	soap_serialize_PointerToxsd__NCName(soap, &((jsdl__DataStaging_USCOREType*)this)->FilesystemName);
	soap_serialize_PointerTobool(soap, &((jsdl__DataStaging_USCOREType*)this)->DeleteOnTermination);
	soap_serialize_PointerTojsdl__SourceTarget_USCOREType(soap, &((jsdl__DataStaging_USCOREType*)this)->Source);
	soap_serialize_PointerTojsdl__SourceTarget_USCOREType(soap, &((jsdl__DataStaging_USCOREType*)this)->Target);
	soap_serialize_PointerTojsdlARC__IsExecutable_USCOREType(soap, &((jsdl__DataStaging_USCOREType*)this)->jsdlARC__IsExecutable);
	soap_serialize_PointerTojsdlARC__FileParameters_USCOREType(soap, &((jsdl__DataStaging_USCOREType*)this)->jsdlARC__FileParameters);
	/* transient soap skipped */
}

void jsdl__DataStaging_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdl__DataStaging_USCOREType*)this)->FileName);
	((jsdl__DataStaging_USCOREType*)this)->FilesystemName = NULL;
	soap_default_jsdl__CreationFlagEnumeration(soap, &((jsdl__DataStaging_USCOREType*)this)->CreationFlag);
	((jsdl__DataStaging_USCOREType*)this)->DeleteOnTermination = NULL;
	((jsdl__DataStaging_USCOREType*)this)->Source = NULL;
	((jsdl__DataStaging_USCOREType*)this)->Target = NULL;
	((jsdl__DataStaging_USCOREType*)this)->jsdlARC__IsExecutable = NULL;
	((jsdl__DataStaging_USCOREType*)this)->jsdlARC__FileParameters = NULL;
	((jsdl__DataStaging_USCOREType*)this)->__any = NULL;
	((jsdl__DataStaging_USCOREType*)this)->name = NULL;
	((jsdl__DataStaging_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__DataStaging_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__DataStaging_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__DataStaging_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__DataStaging_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__DataStaging_USCOREType *a, const char *type)
{
	if (((jsdl__DataStaging_USCOREType *)a)->name)
		soap_set_attr(soap, "name", ((jsdl__DataStaging_USCOREType *)a)->name->c_str());
	if (((jsdl__DataStaging_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__DataStaging_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__DataStaging_USCOREType), type);
	soap_out_std__string(soap, "jsdl:FileName", -1, &(((jsdl__DataStaging_USCOREType*)a)->FileName), "");
	soap_out_PointerToxsd__NCName(soap, "jsdl:FilesystemName", -1, &(((jsdl__DataStaging_USCOREType*)a)->FilesystemName), "");
	soap_out_jsdl__CreationFlagEnumeration(soap, "jsdl:CreationFlag", -1, &(((jsdl__DataStaging_USCOREType*)a)->CreationFlag), "");
	soap_out_PointerTobool(soap, "jsdl:DeleteOnTermination", -1, &(((jsdl__DataStaging_USCOREType*)a)->DeleteOnTermination), "");
	soap_out_PointerTojsdl__SourceTarget_USCOREType(soap, "jsdl:Source", -1, &(((jsdl__DataStaging_USCOREType*)a)->Source), "");
	soap_out_PointerTojsdl__SourceTarget_USCOREType(soap, "jsdl:Target", -1, &(((jsdl__DataStaging_USCOREType*)a)->Target), "");
	soap_out_PointerTojsdlARC__IsExecutable_USCOREType(soap, "jsdlARC:IsExecutable", -1, &(((jsdl__DataStaging_USCOREType*)a)->jsdlARC__IsExecutable), "");
	soap_out_PointerTojsdlARC__FileParameters_USCOREType(soap, "jsdlARC:FileParameters", -1, &(((jsdl__DataStaging_USCOREType*)a)->jsdlARC__FileParameters), "");
	soap_outliteral(soap, "-any", &(((jsdl__DataStaging_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__DataStaging_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__DataStaging_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__DataStaging_USCOREType * SOAP_FMAC4 soap_get_jsdl__DataStaging_USCOREType(struct soap *soap, jsdl__DataStaging_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__DataStaging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__DataStaging_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__DataStaging_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__DataStaging_USCOREType * SOAP_FMAC4 soap_in_jsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, jsdl__DataStaging_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__DataStaging_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__DataStaging_USCOREType, sizeof(jsdl__DataStaging_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__DataStaging_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__DataStaging_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "name", 0);
		if (t)
		{	if (!(((jsdl__DataStaging_USCOREType *)a)->name = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdl__DataStaging_USCOREType *)a)->name = soap_new_std__string(soap, -1);
			((jsdl__DataStaging_USCOREType *)a)->name->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__DataStaging_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_FileName1 = 1, soap_flag_FilesystemName1 = 1, soap_flag_CreationFlag1 = 1, soap_flag_DeleteOnTermination1 = 1, soap_flag_Source1 = 1, soap_flag_Target1 = 1, soap_flag_jsdlARC__IsExecutable1 = 1, soap_flag_jsdlARC__FileParameters1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FileName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "jsdl:FileName", &(((jsdl__DataStaging_USCOREType*)a)->FileName), "xsd:string"))
				{	soap_flag_FileName1--;
					continue;
				}
			if (soap_flag_FilesystemName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerToxsd__NCName(soap, "jsdl:FilesystemName", &(((jsdl__DataStaging_USCOREType*)a)->FilesystemName), "xsd:NCName"))
				{	soap_flag_FilesystemName1--;
					continue;
				}
			if (soap_flag_CreationFlag1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_jsdl__CreationFlagEnumeration(soap, "jsdl:CreationFlag", &(((jsdl__DataStaging_USCOREType*)a)->CreationFlag), "jsdl:CreationFlagEnumeration"))
				{	soap_flag_CreationFlag1--;
					continue;
				}
			if (soap_flag_DeleteOnTermination1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "jsdl:DeleteOnTermination", &(((jsdl__DataStaging_USCOREType*)a)->DeleteOnTermination), "xsd:boolean"))
				{	soap_flag_DeleteOnTermination1--;
					continue;
				}
			if (soap_flag_Source1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__SourceTarget_USCOREType(soap, "jsdl:Source", &(((jsdl__DataStaging_USCOREType*)a)->Source), "jsdl:SourceTarget_Type"))
				{	soap_flag_Source1--;
					continue;
				}
			if (soap_flag_Target1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__SourceTarget_USCOREType(soap, "jsdl:Target", &(((jsdl__DataStaging_USCOREType*)a)->Target), "jsdl:SourceTarget_Type"))
				{	soap_flag_Target1--;
					continue;
				}
			if (soap_flag_jsdlARC__IsExecutable1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__IsExecutable_USCOREType(soap, "jsdlARC:IsExecutable", &(((jsdl__DataStaging_USCOREType*)a)->jsdlARC__IsExecutable), "jsdlARC:IsExecutable_Type"))
				{	soap_flag_jsdlARC__IsExecutable1--;
					continue;
				}
			if (soap_flag_jsdlARC__FileParameters1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTojsdlARC__FileParameters_USCOREType(soap, "jsdlARC:FileParameters", &(((jsdl__DataStaging_USCOREType*)a)->jsdlARC__FileParameters), "jsdlARC:FileParameters_Type"))
				{	soap_flag_jsdlARC__FileParameters1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__DataStaging_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_FileName1 > 0 || soap_flag_CreationFlag1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__DataStaging_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__DataStaging_USCOREType, 0, sizeof(jsdl__DataStaging_USCOREType), 0, soap_copy_jsdl__DataStaging_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__DataStaging_USCOREType * SOAP_FMAC6 soap_new_jsdl__DataStaging_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__DataStaging_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__DataStaging_USCOREType(struct soap *soap, jsdl__DataStaging_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__DataStaging_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__DataStaging_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__DataStaging_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__DataStaging_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__DataStaging_USCOREType;
		if (size)
			*size = sizeof(jsdl__DataStaging_USCOREType);
		((jsdl__DataStaging_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__DataStaging_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__DataStaging_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__DataStaging_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__DataStaging_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__DataStaging_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__DataStaging_USCOREType %p -> %p\n", q, p));
	*(jsdl__DataStaging_USCOREType*)p = *(jsdl__DataStaging_USCOREType*)q;
}

void jsdl__OperatingSystemType_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void jsdl__OperatingSystemType_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_jsdl__OperatingSystemTypeEnumeration(soap, &((jsdl__OperatingSystemType_USCOREType*)this)->OperatingSystemName);
	((jsdl__OperatingSystemType_USCOREType*)this)->__any = NULL;
	((jsdl__OperatingSystemType_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__OperatingSystemType_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__OperatingSystemType_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__OperatingSystemType_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__OperatingSystemType_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__OperatingSystemType_USCOREType *a, const char *type)
{
	if (((jsdl__OperatingSystemType_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__OperatingSystemType_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType), type);
	soap_out_jsdl__OperatingSystemTypeEnumeration(soap, "jsdl:OperatingSystemName", -1, &(((jsdl__OperatingSystemType_USCOREType*)a)->OperatingSystemName), "");
	soap_outliteral(soap, "-any", &(((jsdl__OperatingSystemType_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__OperatingSystemType_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__OperatingSystemType_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__OperatingSystemType_USCOREType * SOAP_FMAC4 soap_get_jsdl__OperatingSystemType_USCOREType(struct soap *soap, jsdl__OperatingSystemType_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__OperatingSystemType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__OperatingSystemType_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__OperatingSystemType_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__OperatingSystemType_USCOREType * SOAP_FMAC4 soap_in_jsdl__OperatingSystemType_USCOREType(struct soap *soap, const char *tag, jsdl__OperatingSystemType_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__OperatingSystemType_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType, sizeof(jsdl__OperatingSystemType_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__OperatingSystemType_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__OperatingSystemType_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__OperatingSystemType_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_OperatingSystemName1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_OperatingSystemName1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_jsdl__OperatingSystemTypeEnumeration(soap, "jsdl:OperatingSystemName", &(((jsdl__OperatingSystemType_USCOREType*)a)->OperatingSystemName), "jsdl:OperatingSystemTypeEnumeration"))
				{	soap_flag_OperatingSystemName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__OperatingSystemType_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_OperatingSystemName1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__OperatingSystemType_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType, 0, sizeof(jsdl__OperatingSystemType_USCOREType), 0, soap_copy_jsdl__OperatingSystemType_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__OperatingSystemType_USCOREType * SOAP_FMAC6 soap_new_jsdl__OperatingSystemType_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__OperatingSystemType_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__OperatingSystemType_USCOREType(struct soap *soap, jsdl__OperatingSystemType_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__OperatingSystemType_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__OperatingSystemType_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__OperatingSystemType_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__OperatingSystemType_USCOREType;
		if (size)
			*size = sizeof(jsdl__OperatingSystemType_USCOREType);
		((jsdl__OperatingSystemType_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__OperatingSystemType_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__OperatingSystemType_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__OperatingSystemType_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__OperatingSystemType_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__OperatingSystemType_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__OperatingSystemType_USCOREType %p -> %p\n", q, p));
	*(jsdl__OperatingSystemType_USCOREType*)p = *(jsdl__OperatingSystemType_USCOREType*)q;
}

void jsdl__OperatingSystem_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__OperatingSystemType_USCOREType(soap, &((jsdl__OperatingSystem_USCOREType*)this)->OperatingSystemType);
	soap_serialize_PointerTostd__string(soap, &((jsdl__OperatingSystem_USCOREType*)this)->OperatingSystemVersion);
	soap_serialize_PointerTojsdl__Description_USCOREType(soap, &((jsdl__OperatingSystem_USCOREType*)this)->Description);
	/* transient soap skipped */
}

void jsdl__OperatingSystem_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__OperatingSystem_USCOREType*)this)->OperatingSystemType = NULL;
	((jsdl__OperatingSystem_USCOREType*)this)->OperatingSystemVersion = NULL;
	((jsdl__OperatingSystem_USCOREType*)this)->Description = NULL;
	((jsdl__OperatingSystem_USCOREType*)this)->__any = NULL;
	((jsdl__OperatingSystem_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__OperatingSystem_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__OperatingSystem_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__OperatingSystem_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__OperatingSystem_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__OperatingSystem_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__OperatingSystem_USCOREType *a, const char *type)
{
	if (((jsdl__OperatingSystem_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__OperatingSystem_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__OperatingSystem_USCOREType), type);
	soap_out_PointerTojsdl__OperatingSystemType_USCOREType(soap, "jsdl:OperatingSystemType", -1, &(((jsdl__OperatingSystem_USCOREType*)a)->OperatingSystemType), "");
	soap_out_PointerTostd__string(soap, "jsdl:OperatingSystemVersion", -1, &(((jsdl__OperatingSystem_USCOREType*)a)->OperatingSystemVersion), "");
	soap_out_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", -1, &(((jsdl__OperatingSystem_USCOREType*)a)->Description), "");
	soap_outliteral(soap, "-any", &(((jsdl__OperatingSystem_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__OperatingSystem_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__OperatingSystem_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__OperatingSystem_USCOREType * SOAP_FMAC4 soap_get_jsdl__OperatingSystem_USCOREType(struct soap *soap, jsdl__OperatingSystem_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__OperatingSystem_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__OperatingSystem_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__OperatingSystem_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__OperatingSystem_USCOREType * SOAP_FMAC4 soap_in_jsdl__OperatingSystem_USCOREType(struct soap *soap, const char *tag, jsdl__OperatingSystem_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__OperatingSystem_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__OperatingSystem_USCOREType, sizeof(jsdl__OperatingSystem_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__OperatingSystem_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__OperatingSystem_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__OperatingSystem_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_OperatingSystemType1 = 1, soap_flag_OperatingSystemVersion1 = 1, soap_flag_Description1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_OperatingSystemType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__OperatingSystemType_USCOREType(soap, "jsdl:OperatingSystemType", &(((jsdl__OperatingSystem_USCOREType*)a)->OperatingSystemType), "jsdl:OperatingSystemType_Type"))
				{	soap_flag_OperatingSystemType1--;
					continue;
				}
			if (soap_flag_OperatingSystemVersion1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jsdl:OperatingSystemVersion", &(((jsdl__OperatingSystem_USCOREType*)a)->OperatingSystemVersion), "xsd:string"))
				{	soap_flag_OperatingSystemVersion1--;
					continue;
				}
			if (soap_flag_Description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", &(((jsdl__OperatingSystem_USCOREType*)a)->Description), "jsdl:Description_Type"))
				{	soap_flag_Description1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__OperatingSystem_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__OperatingSystem_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__OperatingSystem_USCOREType, 0, sizeof(jsdl__OperatingSystem_USCOREType), 0, soap_copy_jsdl__OperatingSystem_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__OperatingSystem_USCOREType * SOAP_FMAC6 soap_new_jsdl__OperatingSystem_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__OperatingSystem_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__OperatingSystem_USCOREType(struct soap *soap, jsdl__OperatingSystem_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__OperatingSystem_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__OperatingSystem_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__OperatingSystem_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__OperatingSystem_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__OperatingSystem_USCOREType;
		if (size)
			*size = sizeof(jsdl__OperatingSystem_USCOREType);
		((jsdl__OperatingSystem_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__OperatingSystem_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__OperatingSystem_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__OperatingSystem_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__OperatingSystem_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__OperatingSystem_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__OperatingSystem_USCOREType %p -> %p\n", q, p));
	*(jsdl__OperatingSystem_USCOREType*)p = *(jsdl__OperatingSystem_USCOREType*)q;
}

void jsdl__FileSystem_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__FileSystemTypeEnumeration(soap, &((jsdl__FileSystem_USCOREType*)this)->FileSystemType);
	soap_serialize_PointerTojsdl__Description_USCOREType(soap, &((jsdl__FileSystem_USCOREType*)this)->Description);
	soap_serialize_PointerTostd__string(soap, &((jsdl__FileSystem_USCOREType*)this)->MountPoint);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__FileSystem_USCOREType*)this)->DiskSpace);
	/* transient soap skipped */
}

void jsdl__FileSystem_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__FileSystem_USCOREType*)this)->FileSystemType = NULL;
	((jsdl__FileSystem_USCOREType*)this)->Description = NULL;
	((jsdl__FileSystem_USCOREType*)this)->MountPoint = NULL;
	((jsdl__FileSystem_USCOREType*)this)->DiskSpace = NULL;
	((jsdl__FileSystem_USCOREType*)this)->__any = NULL;
	soap_default_xsd__NCName(soap, &((jsdl__FileSystem_USCOREType*)this)->name);
	((jsdl__FileSystem_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__FileSystem_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__FileSystem_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__FileSystem_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__FileSystem_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__FileSystem_USCOREType *a, const char *type)
{
	if (!((jsdl__FileSystem_USCOREType *)a)->name.empty())
		soap_set_attr(soap, "name", ((jsdl__FileSystem_USCOREType *)a)->name.c_str());
	if (((jsdl__FileSystem_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__FileSystem_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__FileSystem_USCOREType), type);
	soap_out_PointerTojsdl__FileSystemTypeEnumeration(soap, "jsdl:FileSystemType", -1, &(((jsdl__FileSystem_USCOREType*)a)->FileSystemType), "");
	soap_out_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", -1, &(((jsdl__FileSystem_USCOREType*)a)->Description), "");
	soap_out_PointerTostd__string(soap, "jsdl:MountPoint", -1, &(((jsdl__FileSystem_USCOREType*)a)->MountPoint), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:DiskSpace", -1, &(((jsdl__FileSystem_USCOREType*)a)->DiskSpace), "");
	soap_outliteral(soap, "-any", &(((jsdl__FileSystem_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__FileSystem_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__FileSystem_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__FileSystem_USCOREType * SOAP_FMAC4 soap_get_jsdl__FileSystem_USCOREType(struct soap *soap, jsdl__FileSystem_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__FileSystem_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__FileSystem_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__FileSystem_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__FileSystem_USCOREType * SOAP_FMAC4 soap_in_jsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, jsdl__FileSystem_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__FileSystem_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__FileSystem_USCOREType, sizeof(jsdl__FileSystem_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__FileSystem_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__FileSystem_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "name", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s))
				return NULL;
			((jsdl__FileSystem_USCOREType *)a)->name.assign(s);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__FileSystem_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_FileSystemType1 = 1, soap_flag_Description1 = 1, soap_flag_MountPoint1 = 1, soap_flag_DiskSpace1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_FileSystemType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__FileSystemTypeEnumeration(soap, "jsdl:FileSystemType", &(((jsdl__FileSystem_USCOREType*)a)->FileSystemType), "jsdl:FileSystemTypeEnumeration"))
				{	soap_flag_FileSystemType1--;
					continue;
				}
			if (soap_flag_Description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", &(((jsdl__FileSystem_USCOREType*)a)->Description), "jsdl:Description_Type"))
				{	soap_flag_Description1--;
					continue;
				}
			if (soap_flag_MountPoint1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jsdl:MountPoint", &(((jsdl__FileSystem_USCOREType*)a)->MountPoint), "xsd:string"))
				{	soap_flag_MountPoint1--;
					continue;
				}
			if (soap_flag_DiskSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:DiskSpace", &(((jsdl__FileSystem_USCOREType*)a)->DiskSpace), "jsdl:RangeValue_Type"))
				{	soap_flag_DiskSpace1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__FileSystem_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__FileSystem_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__FileSystem_USCOREType, 0, sizeof(jsdl__FileSystem_USCOREType), 0, soap_copy_jsdl__FileSystem_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__FileSystem_USCOREType * SOAP_FMAC6 soap_new_jsdl__FileSystem_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__FileSystem_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__FileSystem_USCOREType(struct soap *soap, jsdl__FileSystem_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__FileSystem_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__FileSystem_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__FileSystem_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__FileSystem_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__FileSystem_USCOREType;
		if (size)
			*size = sizeof(jsdl__FileSystem_USCOREType);
		((jsdl__FileSystem_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__FileSystem_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__FileSystem_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__FileSystem_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__FileSystem_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__FileSystem_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__FileSystem_USCOREType %p -> %p\n", q, p));
	*(jsdl__FileSystem_USCOREType*)p = *(jsdl__FileSystem_USCOREType*)q;
}

void jsdl__CPUArchitecture_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void jsdl__CPUArchitecture_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_jsdl__ProcessorArchitectureEnumeration(soap, &((jsdl__CPUArchitecture_USCOREType*)this)->CPUArchitectureName);
	((jsdl__CPUArchitecture_USCOREType*)this)->__any = NULL;
	((jsdl__CPUArchitecture_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__CPUArchitecture_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__CPUArchitecture_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__CPUArchitecture_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__CPUArchitecture_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__CPUArchitecture_USCOREType *a, const char *type)
{
	if (((jsdl__CPUArchitecture_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__CPUArchitecture_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType), type);
	soap_out_jsdl__ProcessorArchitectureEnumeration(soap, "jsdl:CPUArchitectureName", -1, &(((jsdl__CPUArchitecture_USCOREType*)a)->CPUArchitectureName), "");
	soap_outliteral(soap, "-any", &(((jsdl__CPUArchitecture_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__CPUArchitecture_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__CPUArchitecture_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__CPUArchitecture_USCOREType * SOAP_FMAC4 soap_get_jsdl__CPUArchitecture_USCOREType(struct soap *soap, jsdl__CPUArchitecture_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__CPUArchitecture_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__CPUArchitecture_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__CPUArchitecture_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__CPUArchitecture_USCOREType * SOAP_FMAC4 soap_in_jsdl__CPUArchitecture_USCOREType(struct soap *soap, const char *tag, jsdl__CPUArchitecture_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__CPUArchitecture_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType, sizeof(jsdl__CPUArchitecture_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__CPUArchitecture_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__CPUArchitecture_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__CPUArchitecture_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_CPUArchitectureName1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CPUArchitectureName1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_jsdl__ProcessorArchitectureEnumeration(soap, "jsdl:CPUArchitectureName", &(((jsdl__CPUArchitecture_USCOREType*)a)->CPUArchitectureName), "jsdl:ProcessorArchitectureEnumeration"))
				{	soap_flag_CPUArchitectureName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__CPUArchitecture_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_CPUArchitectureName1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__CPUArchitecture_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType, 0, sizeof(jsdl__CPUArchitecture_USCOREType), 0, soap_copy_jsdl__CPUArchitecture_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__CPUArchitecture_USCOREType * SOAP_FMAC6 soap_new_jsdl__CPUArchitecture_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__CPUArchitecture_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__CPUArchitecture_USCOREType(struct soap *soap, jsdl__CPUArchitecture_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__CPUArchitecture_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__CPUArchitecture_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__CPUArchitecture_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__CPUArchitecture_USCOREType;
		if (size)
			*size = sizeof(jsdl__CPUArchitecture_USCOREType);
		((jsdl__CPUArchitecture_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__CPUArchitecture_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__CPUArchitecture_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__CPUArchitecture_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__CPUArchitecture_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__CPUArchitecture_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__CPUArchitecture_USCOREType %p -> %p\n", q, p));
	*(jsdl__CPUArchitecture_USCOREType*)p = *(jsdl__CPUArchitecture_USCOREType*)q;
}

void jsdl__CandidateHosts_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((jsdl__CandidateHosts_USCOREType*)this)->HostName);
	/* transient soap skipped */
}

void jsdl__CandidateHosts_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__vectorTemplateOfstd__string(soap, &((jsdl__CandidateHosts_USCOREType*)this)->HostName);
	/* transient soap skipped */
}

int jsdl__CandidateHosts_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__CandidateHosts_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__CandidateHosts_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__CandidateHosts_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__CandidateHosts_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__CandidateHosts_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__CandidateHosts_USCOREType), type);
	soap_out_std__vectorTemplateOfstd__string(soap, "jsdl:HostName", -1, &(((jsdl__CandidateHosts_USCOREType*)a)->HostName), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__CandidateHosts_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__CandidateHosts_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__CandidateHosts_USCOREType * SOAP_FMAC4 soap_get_jsdl__CandidateHosts_USCOREType(struct soap *soap, jsdl__CandidateHosts_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__CandidateHosts_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__CandidateHosts_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__CandidateHosts_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__CandidateHosts_USCOREType * SOAP_FMAC4 soap_in_jsdl__CandidateHosts_USCOREType(struct soap *soap, const char *tag, jsdl__CandidateHosts_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__CandidateHosts_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__CandidateHosts_USCOREType, sizeof(jsdl__CandidateHosts_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__CandidateHosts_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__CandidateHosts_USCOREType *)a->soap_in(soap, tag, type);
		}
	};
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "jsdl:HostName", &(((jsdl__CandidateHosts_USCOREType*)a)->HostName), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__CandidateHosts_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__CandidateHosts_USCOREType, 0, sizeof(jsdl__CandidateHosts_USCOREType), 0, soap_copy_jsdl__CandidateHosts_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__CandidateHosts_USCOREType * SOAP_FMAC6 soap_new_jsdl__CandidateHosts_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__CandidateHosts_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__CandidateHosts_USCOREType(struct soap *soap, jsdl__CandidateHosts_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__CandidateHosts_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__CandidateHosts_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__CandidateHosts_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__CandidateHosts_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__CandidateHosts_USCOREType;
		if (size)
			*size = sizeof(jsdl__CandidateHosts_USCOREType);
		((jsdl__CandidateHosts_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__CandidateHosts_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__CandidateHosts_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__CandidateHosts_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__CandidateHosts_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__CandidateHosts_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__CandidateHosts_USCOREType %p -> %p\n", q, p));
	*(jsdl__CandidateHosts_USCOREType*)p = *(jsdl__CandidateHosts_USCOREType*)q;
}

void jsdl__Resources_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__CandidateHosts_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->CandidateHosts);
	soap_serialize_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->FileSystem);
	soap_serialize_PointerTobool(soap, &((jsdl__Resources_USCOREType*)this)->ExclusiveExecution);
	soap_serialize_PointerTojsdl__OperatingSystem_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->OperatingSystem);
	soap_serialize_PointerTojsdl__CPUArchitecture_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->CPUArchitecture);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualCPUSpeed);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualCPUTime);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualCPUCount);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualNetworkBandwidth);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualPhysicalMemory);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualVirtualMemory);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->IndividualDiskSpace);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalCPUTime);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalCPUCount);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalPhysicalMemory);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalVirtualMemory);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalDiskSpace);
	soap_serialize_PointerTojsdl__RangeValue_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->TotalResourceCount);
	soap_serialize_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__SessionLifeTime);
	soap_serialize_PointerTojsdlARC__SessionType_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__SessionType);
	soap_serialize_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__GridTimeLimit);
	soap_serialize_PointerTojsdlARC__CandidateTarget_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__CandidateTarget);
	soap_serialize_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__Middleware);
	soap_serialize_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__RunTimeEnvironment);
	/* transient soap skipped */
}

void jsdl__Resources_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__Resources_USCOREType*)this)->CandidateHosts = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->FileSystem);
	((jsdl__Resources_USCOREType*)this)->ExclusiveExecution = NULL;
	((jsdl__Resources_USCOREType*)this)->OperatingSystem = NULL;
	((jsdl__Resources_USCOREType*)this)->CPUArchitecture = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualCPUSpeed = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualCPUTime = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualCPUCount = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualNetworkBandwidth = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualPhysicalMemory = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualVirtualMemory = NULL;
	((jsdl__Resources_USCOREType*)this)->IndividualDiskSpace = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalCPUTime = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalCPUCount = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalPhysicalMemory = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalVirtualMemory = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalDiskSpace = NULL;
	((jsdl__Resources_USCOREType*)this)->TotalResourceCount = NULL;
	((jsdl__Resources_USCOREType*)this)->jsdlARC__SessionLifeTime = NULL;
	((jsdl__Resources_USCOREType*)this)->jsdlARC__SessionType = NULL;
	((jsdl__Resources_USCOREType*)this)->jsdlARC__GridTimeLimit = NULL;
	((jsdl__Resources_USCOREType*)this)->jsdlARC__CandidateTarget = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__Middleware);
	soap_default_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, &((jsdl__Resources_USCOREType*)this)->jsdlARC__RunTimeEnvironment);
	((jsdl__Resources_USCOREType*)this)->__any = NULL;
	((jsdl__Resources_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__Resources_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__Resources_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__Resources_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__Resources_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Resources_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__Resources_USCOREType *a, const char *type)
{
	if (((jsdl__Resources_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__Resources_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__Resources_USCOREType), type);
	soap_out_PointerTojsdl__CandidateHosts_USCOREType(soap, "jsdl:CandidateHosts", -1, &(((jsdl__Resources_USCOREType*)a)->CandidateHosts), "");
	soap_out_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, "jsdl:FileSystem", -1, &(((jsdl__Resources_USCOREType*)a)->FileSystem), "");
	soap_out_PointerTobool(soap, "jsdl:ExclusiveExecution", -1, &(((jsdl__Resources_USCOREType*)a)->ExclusiveExecution), "");
	soap_out_PointerTojsdl__OperatingSystem_USCOREType(soap, "jsdl:OperatingSystem", -1, &(((jsdl__Resources_USCOREType*)a)->OperatingSystem), "");
	soap_out_PointerTojsdl__CPUArchitecture_USCOREType(soap, "jsdl:CPUArchitecture", -1, &(((jsdl__Resources_USCOREType*)a)->CPUArchitecture), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUSpeed", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualCPUSpeed), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUTime", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualCPUTime), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUCount", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualCPUCount), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualNetworkBandwidth", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualNetworkBandwidth), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualPhysicalMemory", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualPhysicalMemory), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualVirtualMemory", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualVirtualMemory), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualDiskSpace", -1, &(((jsdl__Resources_USCOREType*)a)->IndividualDiskSpace), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalCPUTime", -1, &(((jsdl__Resources_USCOREType*)a)->TotalCPUTime), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalCPUCount", -1, &(((jsdl__Resources_USCOREType*)a)->TotalCPUCount), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalPhysicalMemory", -1, &(((jsdl__Resources_USCOREType*)a)->TotalPhysicalMemory), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalVirtualMemory", -1, &(((jsdl__Resources_USCOREType*)a)->TotalVirtualMemory), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalDiskSpace", -1, &(((jsdl__Resources_USCOREType*)a)->TotalDiskSpace), "");
	soap_out_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalResourceCount", -1, &(((jsdl__Resources_USCOREType*)a)->TotalResourceCount), "");
	soap_out_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, "jsdlARC:SessionLifeTime", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__SessionLifeTime), "");
	soap_out_PointerTojsdlARC__SessionType_USCOREType(soap, "jsdlARC:SessionType", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__SessionType), "");
	soap_out_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, "jsdlARC:GridTimeLimit", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__GridTimeLimit), "");
	soap_out_PointerTojsdlARC__CandidateTarget_USCOREType(soap, "jsdlARC:CandidateTarget", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__CandidateTarget), "");
	soap_out_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, "jsdlARC:Middleware", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__Middleware), "");
	soap_out_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, "jsdlARC:RunTimeEnvironment", -1, &(((jsdl__Resources_USCOREType*)a)->jsdlARC__RunTimeEnvironment), "");
	soap_outliteral(soap, "-any", &(((jsdl__Resources_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__Resources_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__Resources_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__Resources_USCOREType * SOAP_FMAC4 soap_get_jsdl__Resources_USCOREType(struct soap *soap, jsdl__Resources_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Resources_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__Resources_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__Resources_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__Resources_USCOREType * SOAP_FMAC4 soap_in_jsdl__Resources_USCOREType(struct soap *soap, const char *tag, jsdl__Resources_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__Resources_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__Resources_USCOREType, sizeof(jsdl__Resources_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__Resources_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__Resources_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__Resources_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_CandidateHosts1 = 1, soap_flag_ExclusiveExecution1 = 1, soap_flag_OperatingSystem1 = 1, soap_flag_CPUArchitecture1 = 1, soap_flag_IndividualCPUSpeed1 = 1, soap_flag_IndividualCPUTime1 = 1, soap_flag_IndividualCPUCount1 = 1, soap_flag_IndividualNetworkBandwidth1 = 1, soap_flag_IndividualPhysicalMemory1 = 1, soap_flag_IndividualVirtualMemory1 = 1, soap_flag_IndividualDiskSpace1 = 1, soap_flag_TotalCPUTime1 = 1, soap_flag_TotalCPUCount1 = 1, soap_flag_TotalPhysicalMemory1 = 1, soap_flag_TotalVirtualMemory1 = 1, soap_flag_TotalDiskSpace1 = 1, soap_flag_TotalResourceCount1 = 1, soap_flag_jsdlARC__SessionLifeTime1 = 1, soap_flag_jsdlARC__SessionType1 = 1, soap_flag_jsdlARC__GridTimeLimit1 = 1, soap_flag_jsdlARC__CandidateTarget1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_CandidateHosts1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__CandidateHosts_USCOREType(soap, "jsdl:CandidateHosts", &(((jsdl__Resources_USCOREType*)a)->CandidateHosts), "jsdl:CandidateHosts_Type"))
				{	soap_flag_CandidateHosts1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, "jsdl:FileSystem", &(((jsdl__Resources_USCOREType*)a)->FileSystem), "jsdl:FileSystem_Type"))
					continue;
			if (soap_flag_ExclusiveExecution1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "jsdl:ExclusiveExecution", &(((jsdl__Resources_USCOREType*)a)->ExclusiveExecution), "xsd:boolean"))
				{	soap_flag_ExclusiveExecution1--;
					continue;
				}
			if (soap_flag_OperatingSystem1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__OperatingSystem_USCOREType(soap, "jsdl:OperatingSystem", &(((jsdl__Resources_USCOREType*)a)->OperatingSystem), "jsdl:OperatingSystem_Type"))
				{	soap_flag_OperatingSystem1--;
					continue;
				}
			if (soap_flag_CPUArchitecture1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__CPUArchitecture_USCOREType(soap, "jsdl:CPUArchitecture", &(((jsdl__Resources_USCOREType*)a)->CPUArchitecture), "jsdl:CPUArchitecture_Type"))
				{	soap_flag_CPUArchitecture1--;
					continue;
				}
			if (soap_flag_IndividualCPUSpeed1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUSpeed", &(((jsdl__Resources_USCOREType*)a)->IndividualCPUSpeed), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualCPUSpeed1--;
					continue;
				}
			if (soap_flag_IndividualCPUTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUTime", &(((jsdl__Resources_USCOREType*)a)->IndividualCPUTime), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualCPUTime1--;
					continue;
				}
			if (soap_flag_IndividualCPUCount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualCPUCount", &(((jsdl__Resources_USCOREType*)a)->IndividualCPUCount), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualCPUCount1--;
					continue;
				}
			if (soap_flag_IndividualNetworkBandwidth1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualNetworkBandwidth", &(((jsdl__Resources_USCOREType*)a)->IndividualNetworkBandwidth), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualNetworkBandwidth1--;
					continue;
				}
			if (soap_flag_IndividualPhysicalMemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualPhysicalMemory", &(((jsdl__Resources_USCOREType*)a)->IndividualPhysicalMemory), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualPhysicalMemory1--;
					continue;
				}
			if (soap_flag_IndividualVirtualMemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualVirtualMemory", &(((jsdl__Resources_USCOREType*)a)->IndividualVirtualMemory), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualVirtualMemory1--;
					continue;
				}
			if (soap_flag_IndividualDiskSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:IndividualDiskSpace", &(((jsdl__Resources_USCOREType*)a)->IndividualDiskSpace), "jsdl:RangeValue_Type"))
				{	soap_flag_IndividualDiskSpace1--;
					continue;
				}
			if (soap_flag_TotalCPUTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalCPUTime", &(((jsdl__Resources_USCOREType*)a)->TotalCPUTime), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalCPUTime1--;
					continue;
				}
			if (soap_flag_TotalCPUCount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalCPUCount", &(((jsdl__Resources_USCOREType*)a)->TotalCPUCount), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalCPUCount1--;
					continue;
				}
			if (soap_flag_TotalPhysicalMemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalPhysicalMemory", &(((jsdl__Resources_USCOREType*)a)->TotalPhysicalMemory), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalPhysicalMemory1--;
					continue;
				}
			if (soap_flag_TotalVirtualMemory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalVirtualMemory", &(((jsdl__Resources_USCOREType*)a)->TotalVirtualMemory), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalVirtualMemory1--;
					continue;
				}
			if (soap_flag_TotalDiskSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalDiskSpace", &(((jsdl__Resources_USCOREType*)a)->TotalDiskSpace), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalDiskSpace1--;
					continue;
				}
			if (soap_flag_TotalResourceCount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__RangeValue_USCOREType(soap, "jsdl:TotalResourceCount", &(((jsdl__Resources_USCOREType*)a)->TotalResourceCount), "jsdl:RangeValue_Type"))
				{	soap_flag_TotalResourceCount1--;
					continue;
				}
			if (soap_flag_jsdlARC__SessionLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, "jsdlARC:SessionLifeTime", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__SessionLifeTime), "jsdlARC:SessionLifeTime_Type"))
				{	soap_flag_jsdlARC__SessionLifeTime1--;
					continue;
				}
			if (soap_flag_jsdlARC__SessionType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__SessionType_USCOREType(soap, "jsdlARC:SessionType", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__SessionType), "jsdlARC:SessionType_Type"))
				{	soap_flag_jsdlARC__SessionType1--;
					continue;
				}
			if (soap_flag_jsdlARC__GridTimeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, "jsdlARC:GridTimeLimit", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__GridTimeLimit), "jsdlARC:GridTimeLimit_Type"))
				{	soap_flag_jsdlARC__GridTimeLimit1--;
					continue;
				}
			if (soap_flag_jsdlARC__CandidateTarget1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__CandidateTarget_USCOREType(soap, "jsdlARC:CandidateTarget", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__CandidateTarget), "jsdlARC:CandidateTarget_Type"))
				{	soap_flag_jsdlARC__CandidateTarget1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, "jsdlARC:Middleware", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__Middleware), "jsdlARC:Middleware_Type"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, "jsdlARC:RunTimeEnvironment", &(((jsdl__Resources_USCOREType*)a)->jsdlARC__RunTimeEnvironment), "jsdlARC:RunTimeEnvironment_Type"))
					continue;
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__Resources_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__Resources_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__Resources_USCOREType, 0, sizeof(jsdl__Resources_USCOREType), 0, soap_copy_jsdl__Resources_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__Resources_USCOREType * SOAP_FMAC6 soap_new_jsdl__Resources_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Resources_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Resources_USCOREType(struct soap *soap, jsdl__Resources_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__Resources_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__Resources_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Resources_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Resources_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__Resources_USCOREType;
		if (size)
			*size = sizeof(jsdl__Resources_USCOREType);
		((jsdl__Resources_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__Resources_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__Resources_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__Resources_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__Resources_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Resources_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__Resources_USCOREType %p -> %p\n", q, p));
	*(jsdl__Resources_USCOREType*)p = *(jsdl__Resources_USCOREType*)q;
}

void jsdl__Application_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((jsdl__Application_USCOREType*)this)->ApplicationName);
	soap_serialize_PointerTostd__string(soap, &((jsdl__Application_USCOREType*)this)->ApplicationVersion);
	soap_serialize_PointerTojsdl__Description_USCOREType(soap, &((jsdl__Application_USCOREType*)this)->Description);
	soap_serialize_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, &((jsdl__Application_USCOREType*)this)->jsdlPOSIX__POSIXApplication);
	/* transient soap skipped */
}

void jsdl__Application_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__Application_USCOREType*)this)->ApplicationName = NULL;
	((jsdl__Application_USCOREType*)this)->ApplicationVersion = NULL;
	((jsdl__Application_USCOREType*)this)->Description = NULL;
	((jsdl__Application_USCOREType*)this)->jsdlPOSIX__POSIXApplication = NULL;
	((jsdl__Application_USCOREType*)this)->__any = NULL;
	((jsdl__Application_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__Application_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__Application_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__Application_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__Application_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Application_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__Application_USCOREType *a, const char *type)
{
	if (((jsdl__Application_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__Application_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__Application_USCOREType), type);
	soap_out_PointerTostd__string(soap, "jsdl:ApplicationName", -1, &(((jsdl__Application_USCOREType*)a)->ApplicationName), "");
	soap_out_PointerTostd__string(soap, "jsdl:ApplicationVersion", -1, &(((jsdl__Application_USCOREType*)a)->ApplicationVersion), "");
	soap_out_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", -1, &(((jsdl__Application_USCOREType*)a)->Description), "");
	soap_out_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, "jsdlPOSIX:POSIXApplication", -1, &(((jsdl__Application_USCOREType*)a)->jsdlPOSIX__POSIXApplication), "");
	soap_outliteral(soap, "-any", &(((jsdl__Application_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__Application_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__Application_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__Application_USCOREType * SOAP_FMAC4 soap_get_jsdl__Application_USCOREType(struct soap *soap, jsdl__Application_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Application_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__Application_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__Application_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__Application_USCOREType * SOAP_FMAC4 soap_in_jsdl__Application_USCOREType(struct soap *soap, const char *tag, jsdl__Application_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__Application_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__Application_USCOREType, sizeof(jsdl__Application_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__Application_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__Application_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__Application_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_ApplicationName1 = 1, soap_flag_ApplicationVersion1 = 1, soap_flag_Description1 = 1, soap_flag_jsdlPOSIX__POSIXApplication1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ApplicationName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jsdl:ApplicationName", &(((jsdl__Application_USCOREType*)a)->ApplicationName), "xsd:string"))
				{	soap_flag_ApplicationName1--;
					continue;
				}
			if (soap_flag_ApplicationVersion1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jsdl:ApplicationVersion", &(((jsdl__Application_USCOREType*)a)->ApplicationVersion), "xsd:string"))
				{	soap_flag_ApplicationVersion1--;
					continue;
				}
			if (soap_flag_Description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", &(((jsdl__Application_USCOREType*)a)->Description), "jsdl:Description_Type"))
				{	soap_flag_Description1--;
					continue;
				}
			if (soap_flag_jsdlPOSIX__POSIXApplication1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, "jsdlPOSIX:POSIXApplication", &(((jsdl__Application_USCOREType*)a)->jsdlPOSIX__POSIXApplication), "jsdlPOSIX:POSIXApplication_Type"))
				{	soap_flag_jsdlPOSIX__POSIXApplication1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__Application_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__Application_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__Application_USCOREType, 0, sizeof(jsdl__Application_USCOREType), 0, soap_copy_jsdl__Application_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__Application_USCOREType * SOAP_FMAC6 soap_new_jsdl__Application_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Application_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Application_USCOREType(struct soap *soap, jsdl__Application_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__Application_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__Application_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Application_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Application_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__Application_USCOREType;
		if (size)
			*size = sizeof(jsdl__Application_USCOREType);
		((jsdl__Application_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__Application_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__Application_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__Application_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__Application_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Application_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__Application_USCOREType %p -> %p\n", q, p));
	*(jsdl__Application_USCOREType*)p = *(jsdl__Application_USCOREType*)q;
}

void jsdl__JobIdentification_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((jsdl__JobIdentification_USCOREType*)this)->JobName);
	soap_serialize_PointerTojsdl__Description_USCOREType(soap, &((jsdl__JobIdentification_USCOREType*)this)->Description);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((jsdl__JobIdentification_USCOREType*)this)->JobAnnotation);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((jsdl__JobIdentification_USCOREType*)this)->JobProject);
	/* transient soap skipped */
}

void jsdl__JobIdentification_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__JobIdentification_USCOREType*)this)->JobName = NULL;
	((jsdl__JobIdentification_USCOREType*)this)->Description = NULL;
	soap_default_std__vectorTemplateOfstd__string(soap, &((jsdl__JobIdentification_USCOREType*)this)->JobAnnotation);
	soap_default_std__vectorTemplateOfstd__string(soap, &((jsdl__JobIdentification_USCOREType*)this)->JobProject);
	((jsdl__JobIdentification_USCOREType*)this)->__any = NULL;
	((jsdl__JobIdentification_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__JobIdentification_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__JobIdentification_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__JobIdentification_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__JobIdentification_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__JobIdentification_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__JobIdentification_USCOREType *a, const char *type)
{
	if (((jsdl__JobIdentification_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__JobIdentification_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__JobIdentification_USCOREType), type);
	soap_out_PointerTostd__string(soap, "jsdl:JobName", -1, &(((jsdl__JobIdentification_USCOREType*)a)->JobName), "");
	soap_out_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", -1, &(((jsdl__JobIdentification_USCOREType*)a)->Description), "");
	soap_out_std__vectorTemplateOfstd__string(soap, "jsdl:JobAnnotation", -1, &(((jsdl__JobIdentification_USCOREType*)a)->JobAnnotation), "");
	soap_out_std__vectorTemplateOfstd__string(soap, "jsdl:JobProject", -1, &(((jsdl__JobIdentification_USCOREType*)a)->JobProject), "");
	soap_outliteral(soap, "-any", &(((jsdl__JobIdentification_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__JobIdentification_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__JobIdentification_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__JobIdentification_USCOREType * SOAP_FMAC4 soap_get_jsdl__JobIdentification_USCOREType(struct soap *soap, jsdl__JobIdentification_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__JobIdentification_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__JobIdentification_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__JobIdentification_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__JobIdentification_USCOREType * SOAP_FMAC4 soap_in_jsdl__JobIdentification_USCOREType(struct soap *soap, const char *tag, jsdl__JobIdentification_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__JobIdentification_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__JobIdentification_USCOREType, sizeof(jsdl__JobIdentification_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__JobIdentification_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__JobIdentification_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__JobIdentification_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_JobName1 = 1, soap_flag_Description1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_JobName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "jsdl:JobName", &(((jsdl__JobIdentification_USCOREType*)a)->JobName), "xsd:string"))
				{	soap_flag_JobName1--;
					continue;
				}
			if (soap_flag_Description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTojsdl__Description_USCOREType(soap, "jsdl:Description", &(((jsdl__JobIdentification_USCOREType*)a)->Description), "jsdl:Description_Type"))
				{	soap_flag_Description1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "jsdl:JobAnnotation", &(((jsdl__JobIdentification_USCOREType*)a)->JobAnnotation), "xsd:string"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "jsdl:JobProject", &(((jsdl__JobIdentification_USCOREType*)a)->JobProject), "xsd:string"))
					continue;
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__JobIdentification_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__JobIdentification_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__JobIdentification_USCOREType, 0, sizeof(jsdl__JobIdentification_USCOREType), 0, soap_copy_jsdl__JobIdentification_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__JobIdentification_USCOREType * SOAP_FMAC6 soap_new_jsdl__JobIdentification_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__JobIdentification_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__JobIdentification_USCOREType(struct soap *soap, jsdl__JobIdentification_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__JobIdentification_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__JobIdentification_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__JobIdentification_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__JobIdentification_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__JobIdentification_USCOREType;
		if (size)
			*size = sizeof(jsdl__JobIdentification_USCOREType);
		((jsdl__JobIdentification_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__JobIdentification_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__JobIdentification_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__JobIdentification_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__JobIdentification_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__JobIdentification_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__JobIdentification_USCOREType %p -> %p\n", q, p));
	*(jsdl__JobIdentification_USCOREType*)p = *(jsdl__JobIdentification_USCOREType*)q;
}

void jsdl__JobDescription_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__JobIdentification_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->JobIdentification);
	soap_serialize_PointerTojsdl__Application_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->Application);
	soap_serialize_PointerTojsdl__Resources_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->Resources);
	soap_serialize_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->DataStaging);
	soap_serialize_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__Notify);
	soap_serialize_PointerTojsdlARC__AccessControl_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__AccessControl);
	soap_serialize_PointerTojsdlARC__LocalLogging_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__LocalLogging);
	soap_serialize_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__RemoteLogging);
	soap_serialize_PointerTojsdlARC__CredentialServer_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__CredentialServer);
	soap_serialize_PointerTojsdlARC__Reruns_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__Reruns);
	soap_serialize_PointerTojsdlARC__Time_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__ProcessingStartTime);
	soap_serialize_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->JobDescription);
	/* transient soap skipped */
}

void jsdl__JobDescription_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__JobDescription_USCOREType*)this)->JobIdentification = NULL;
	((jsdl__JobDescription_USCOREType*)this)->Application = NULL;
	((jsdl__JobDescription_USCOREType*)this)->Resources = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->DataStaging);
	soap_default_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__Notify);
	((jsdl__JobDescription_USCOREType*)this)->jsdlARC__AccessControl = NULL;
	((jsdl__JobDescription_USCOREType*)this)->jsdlARC__LocalLogging = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->jsdlARC__RemoteLogging);
	((jsdl__JobDescription_USCOREType*)this)->jsdlARC__CredentialServer = NULL;
	((jsdl__JobDescription_USCOREType*)this)->jsdlARC__Reruns = NULL;
	((jsdl__JobDescription_USCOREType*)this)->jsdlARC__ProcessingStartTime = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, &((jsdl__JobDescription_USCOREType*)this)->JobDescription);
	((jsdl__JobDescription_USCOREType*)this)->__any = NULL;
	((jsdl__JobDescription_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__JobDescription_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__JobDescription_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__JobDescription_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__JobDescription_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__JobDescription_USCOREType *a, const char *type)
{
	if (((jsdl__JobDescription_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__JobDescription_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__JobDescription_USCOREType), type);
	soap_out_PointerTojsdl__JobIdentification_USCOREType(soap, "jsdl:JobIdentification", -1, &(((jsdl__JobDescription_USCOREType*)a)->JobIdentification), "");
	soap_out_PointerTojsdl__Application_USCOREType(soap, "jsdl:Application", -1, &(((jsdl__JobDescription_USCOREType*)a)->Application), "");
	soap_out_PointerTojsdl__Resources_USCOREType(soap, "jsdl:Resources", -1, &(((jsdl__JobDescription_USCOREType*)a)->Resources), "");
	soap_out_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, "jsdl:DataStaging", -1, &(((jsdl__JobDescription_USCOREType*)a)->DataStaging), "");
	soap_out_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, "jsdlARC:Notify", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__Notify), "");
	soap_out_PointerTojsdlARC__AccessControl_USCOREType(soap, "jsdlARC:AccessControl", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__AccessControl), "");
	soap_out_PointerTojsdlARC__LocalLogging_USCOREType(soap, "jsdlARC:LocalLogging", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__LocalLogging), "");
	soap_out_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, "jsdlARC:RemoteLogging", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__RemoteLogging), "");
	soap_out_PointerTojsdlARC__CredentialServer_USCOREType(soap, "jsdlARC:CredentialServer", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__CredentialServer), "");
	soap_out_PointerTojsdlARC__Reruns_USCOREType(soap, "jsdlARC:Reruns", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__Reruns), "");
	soap_out_PointerTojsdlARC__Time_USCOREType(soap, "jsdlARC:ProcessingStartTime", -1, &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__ProcessingStartTime), "");
	soap_out_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, "jsdl:JobDescription", -1, &(((jsdl__JobDescription_USCOREType*)a)->JobDescription), "");
	soap_outliteral(soap, "-any", &(((jsdl__JobDescription_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__JobDescription_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__JobDescription_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__JobDescription_USCOREType * SOAP_FMAC4 soap_get_jsdl__JobDescription_USCOREType(struct soap *soap, jsdl__JobDescription_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__JobDescription_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__JobDescription_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__JobDescription_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__JobDescription_USCOREType * SOAP_FMAC4 soap_in_jsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, jsdl__JobDescription_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__JobDescription_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__JobDescription_USCOREType, sizeof(jsdl__JobDescription_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__JobDescription_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__JobDescription_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__JobDescription_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_JobIdentification1 = 1, soap_flag_Application1 = 1, soap_flag_Resources1 = 1, soap_flag_jsdlARC__AccessControl1 = 1, soap_flag_jsdlARC__LocalLogging1 = 1, soap_flag_jsdlARC__CredentialServer1 = 1, soap_flag_jsdlARC__Reruns1 = 1, soap_flag_jsdlARC__ProcessingStartTime1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_JobIdentification1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__JobIdentification_USCOREType(soap, "jsdl:JobIdentification", &(((jsdl__JobDescription_USCOREType*)a)->JobIdentification), "jsdl:JobIdentification_Type"))
				{	soap_flag_JobIdentification1--;
					continue;
				}
			if (soap_flag_Application1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Application_USCOREType(soap, "jsdl:Application", &(((jsdl__JobDescription_USCOREType*)a)->Application), "jsdl:Application_Type"))
				{	soap_flag_Application1--;
					continue;
				}
			if (soap_flag_Resources1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Resources_USCOREType(soap, "jsdl:Resources", &(((jsdl__JobDescription_USCOREType*)a)->Resources), "jsdl:Resources_Type"))
				{	soap_flag_Resources1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, "jsdl:DataStaging", &(((jsdl__JobDescription_USCOREType*)a)->DataStaging), "jsdl:DataStaging_Type"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, "jsdlARC:Notify", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__Notify), "jsdlARC:Notify_Type"))
					continue;
			if (soap_flag_jsdlARC__AccessControl1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__AccessControl_USCOREType(soap, "jsdlARC:AccessControl", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__AccessControl), "jsdlARC:AccessControl_Type"))
				{	soap_flag_jsdlARC__AccessControl1--;
					continue;
				}
			if (soap_flag_jsdlARC__LocalLogging1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__LocalLogging_USCOREType(soap, "jsdlARC:LocalLogging", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__LocalLogging), "jsdlARC:LocalLogging_Type"))
				{	soap_flag_jsdlARC__LocalLogging1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, "jsdlARC:RemoteLogging", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__RemoteLogging), "jsdlARC:RemoteLogging_Type"))
					continue;
			if (soap_flag_jsdlARC__CredentialServer1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__CredentialServer_USCOREType(soap, "jsdlARC:CredentialServer", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__CredentialServer), "jsdlARC:CredentialServer_Type"))
				{	soap_flag_jsdlARC__CredentialServer1--;
					continue;
				}
			if (soap_flag_jsdlARC__Reruns1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__Reruns_USCOREType(soap, "jsdlARC:Reruns", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__Reruns), "jsdlARC:Reruns_Type"))
				{	soap_flag_jsdlARC__Reruns1--;
					continue;
				}
			if (soap_flag_jsdlARC__ProcessingStartTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__Time_USCOREType(soap, "jsdlARC:ProcessingStartTime", &(((jsdl__JobDescription_USCOREType*)a)->jsdlARC__ProcessingStartTime), "jsdlARC:Time_Type"))
				{	soap_flag_jsdlARC__ProcessingStartTime1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, "jsdl:JobDescription", &(((jsdl__JobDescription_USCOREType*)a)->JobDescription), "jsdl:JobDescription_Type"))
					continue;
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__JobDescription_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (((jsdl__JobDescription_USCOREType*)a)->jsdlARC__Notify.size() > 3 || ((jsdl__JobDescription_USCOREType*)a)->jsdlARC__RemoteLogging.size() > 3))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__JobDescription_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__JobDescription_USCOREType, 0, sizeof(jsdl__JobDescription_USCOREType), 0, soap_copy_jsdl__JobDescription_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__JobDescription_USCOREType * SOAP_FMAC6 soap_new_jsdl__JobDescription_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__JobDescription_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__JobDescription_USCOREType(struct soap *soap, jsdl__JobDescription_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__JobDescription_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__JobDescription_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__JobDescription_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__JobDescription_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__JobDescription_USCOREType;
		if (size)
			*size = sizeof(jsdl__JobDescription_USCOREType);
		((jsdl__JobDescription_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__JobDescription_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__JobDescription_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__JobDescription_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__JobDescription_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__JobDescription_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__JobDescription_USCOREType %p -> %p\n", q, p));
	*(jsdl__JobDescription_USCOREType*)p = *(jsdl__JobDescription_USCOREType*)q;
}

void jsdl__JobDefinition_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__JobDescription_USCOREType(soap, &((jsdl__JobDefinition_USCOREType*)this)->JobDescription);
	/* transient soap skipped */
}

void jsdl__JobDefinition_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__JobDefinition_USCOREType*)this)->JobDescription = NULL;
	((jsdl__JobDefinition_USCOREType*)this)->__any = NULL;
	((jsdl__JobDefinition_USCOREType*)this)->id = NULL;
	((jsdl__JobDefinition_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__JobDefinition_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__JobDefinition_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__JobDefinition_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__JobDefinition_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__JobDefinition_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__JobDefinition_USCOREType *a, const char *type)
{
	if (((jsdl__JobDefinition_USCOREType *)a)->id)
		soap_set_attr(soap, "id", ((jsdl__JobDefinition_USCOREType *)a)->id->c_str());
	if (((jsdl__JobDefinition_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__JobDefinition_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__JobDefinition_USCOREType), type);
	soap_out_PointerTojsdl__JobDescription_USCOREType(soap, "jsdl:JobDescription", -1, &(((jsdl__JobDefinition_USCOREType*)a)->JobDescription), "");
	soap_outliteral(soap, "-any", &(((jsdl__JobDefinition_USCOREType*)a)->__any), NULL);
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__JobDefinition_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__JobDefinition_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__JobDefinition_USCOREType * SOAP_FMAC4 soap_get_jsdl__JobDefinition_USCOREType(struct soap *soap, jsdl__JobDefinition_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__JobDefinition_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__JobDefinition_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__JobDefinition_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__JobDefinition_USCOREType * SOAP_FMAC4 soap_in_jsdl__JobDefinition_USCOREType(struct soap *soap, const char *tag, jsdl__JobDefinition_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__JobDefinition_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__JobDefinition_USCOREType, sizeof(jsdl__JobDefinition_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__JobDefinition_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__JobDefinition_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "id", 0);
		if (t)
		{	if (!(((jsdl__JobDefinition_USCOREType *)a)->id = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdl__JobDefinition_USCOREType *)a)->id = soap_new_std__string(soap, -1);
			((jsdl__JobDefinition_USCOREType *)a)->id->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__JobDefinition_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_JobDescription1 = 1, soap_flag___any1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_JobDescription1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__JobDescription_USCOREType(soap, "jsdl:JobDescription", &(((jsdl__JobDefinition_USCOREType*)a)->JobDescription), "jsdl:JobDescription_Type"))
				{	soap_flag_JobDescription1--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag___any1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &(((jsdl__JobDefinition_USCOREType*)a)->__any)))
				{	soap_flag___any1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_JobDescription1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__JobDefinition_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__JobDefinition_USCOREType, 0, sizeof(jsdl__JobDefinition_USCOREType), 0, soap_copy_jsdl__JobDefinition_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__JobDefinition_USCOREType * SOAP_FMAC6 soap_new_jsdl__JobDefinition_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__JobDefinition_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__JobDefinition_USCOREType(struct soap *soap, jsdl__JobDefinition_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__JobDefinition_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__JobDefinition_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__JobDefinition_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__JobDefinition_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__JobDefinition_USCOREType;
		if (size)
			*size = sizeof(jsdl__JobDefinition_USCOREType);
		((jsdl__JobDefinition_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__JobDefinition_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__JobDefinition_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__JobDefinition_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__JobDefinition_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__JobDefinition_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__JobDefinition_USCOREType %p -> %p\n", q, p));
	*(jsdl__JobDefinition_USCOREType*)p = *(jsdl__JobDefinition_USCOREType*)q;
}

void jsdl__RangeValue_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__Boundary_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->UpperBoundedRange);
	soap_serialize_PointerTojsdl__Boundary_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->LowerBoundedRange);
	soap_serialize_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->Exact);
	soap_serialize_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->Range);
	/* transient soap skipped */
}

void jsdl__RangeValue_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__RangeValue_USCOREType*)this)->UpperBoundedRange = NULL;
	((jsdl__RangeValue_USCOREType*)this)->LowerBoundedRange = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->Exact);
	soap_default_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, &((jsdl__RangeValue_USCOREType*)this)->Range);
	((jsdl__RangeValue_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__RangeValue_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__RangeValue_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__RangeValue_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__RangeValue_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__RangeValue_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__RangeValue_USCOREType *a, const char *type)
{
	if (((jsdl__RangeValue_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__RangeValue_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__RangeValue_USCOREType), type);
	soap_out_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:UpperBoundedRange", -1, &(((jsdl__RangeValue_USCOREType*)a)->UpperBoundedRange), "");
	soap_out_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:LowerBoundedRange", -1, &(((jsdl__RangeValue_USCOREType*)a)->LowerBoundedRange), "");
	soap_out_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, "jsdl:Exact", -1, &(((jsdl__RangeValue_USCOREType*)a)->Exact), "");
	soap_out_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, "jsdl:Range", -1, &(((jsdl__RangeValue_USCOREType*)a)->Range), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__RangeValue_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__RangeValue_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__RangeValue_USCOREType * SOAP_FMAC4 soap_get_jsdl__RangeValue_USCOREType(struct soap *soap, jsdl__RangeValue_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__RangeValue_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__RangeValue_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__RangeValue_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__RangeValue_USCOREType * SOAP_FMAC4 soap_in_jsdl__RangeValue_USCOREType(struct soap *soap, const char *tag, jsdl__RangeValue_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__RangeValue_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__RangeValue_USCOREType, sizeof(jsdl__RangeValue_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__RangeValue_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__RangeValue_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__RangeValue_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_UpperBoundedRange1 = 1, soap_flag_LowerBoundedRange1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_UpperBoundedRange1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:UpperBoundedRange", &(((jsdl__RangeValue_USCOREType*)a)->UpperBoundedRange), "jsdl:Boundary_Type"))
				{	soap_flag_UpperBoundedRange1--;
					continue;
				}
			if (soap_flag_LowerBoundedRange1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:LowerBoundedRange", &(((jsdl__RangeValue_USCOREType*)a)->LowerBoundedRange), "jsdl:Boundary_Type"))
				{	soap_flag_LowerBoundedRange1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, "jsdl:Exact", &(((jsdl__RangeValue_USCOREType*)a)->Exact), "jsdl:Exact_Type"))
					continue;
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, "jsdl:Range", &(((jsdl__RangeValue_USCOREType*)a)->Range), "jsdl:Range_Type"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__RangeValue_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__RangeValue_USCOREType, 0, sizeof(jsdl__RangeValue_USCOREType), 0, soap_copy_jsdl__RangeValue_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__RangeValue_USCOREType * SOAP_FMAC6 soap_new_jsdl__RangeValue_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__RangeValue_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__RangeValue_USCOREType(struct soap *soap, jsdl__RangeValue_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__RangeValue_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__RangeValue_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__RangeValue_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__RangeValue_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__RangeValue_USCOREType;
		if (size)
			*size = sizeof(jsdl__RangeValue_USCOREType);
		((jsdl__RangeValue_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__RangeValue_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__RangeValue_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__RangeValue_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__RangeValue_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__RangeValue_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__RangeValue_USCOREType %p -> %p\n", q, p));
	*(jsdl__RangeValue_USCOREType*)p = *(jsdl__RangeValue_USCOREType*)q;
}

void jsdl__Range_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdl__Boundary_USCOREType(soap, &((jsdl__Range_USCOREType*)this)->LowerBound);
	soap_serialize_PointerTojsdl__Boundary_USCOREType(soap, &((jsdl__Range_USCOREType*)this)->UpperBound);
	/* transient soap skipped */
}

void jsdl__Range_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdl__Range_USCOREType*)this)->LowerBound = NULL;
	((jsdl__Range_USCOREType*)this)->UpperBound = NULL;
	((jsdl__Range_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__Range_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__Range_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__Range_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__Range_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Range_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__Range_USCOREType *a, const char *type)
{
	if (((jsdl__Range_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__Range_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdl__Range_USCOREType), type);
	soap_out_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:LowerBound", -1, &(((jsdl__Range_USCOREType*)a)->LowerBound), "");
	soap_out_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:UpperBound", -1, &(((jsdl__Range_USCOREType*)a)->UpperBound), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdl__Range_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__Range_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__Range_USCOREType * SOAP_FMAC4 soap_get_jsdl__Range_USCOREType(struct soap *soap, jsdl__Range_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Range_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__Range_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__Range_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__Range_USCOREType * SOAP_FMAC4 soap_in_jsdl__Range_USCOREType(struct soap *soap, const char *tag, jsdl__Range_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdl__Range_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__Range_USCOREType, sizeof(jsdl__Range_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__Range_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdl__Range_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__Range_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_LowerBound1 = 1, soap_flag_UpperBound1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_LowerBound1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:LowerBound", &(((jsdl__Range_USCOREType*)a)->LowerBound), "jsdl:Boundary_Type"))
				{	soap_flag_LowerBound1--;
					continue;
				}
			if (soap_flag_UpperBound1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdl__Boundary_USCOREType(soap, "jsdl:UpperBound", &(((jsdl__Range_USCOREType*)a)->UpperBound), "jsdl:Boundary_Type"))
				{	soap_flag_UpperBound1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_LowerBound1 > 0 || soap_flag_UpperBound1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdl__Range_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdl__Range_USCOREType, 0, sizeof(jsdl__Range_USCOREType), 0, soap_copy_jsdl__Range_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdl__Range_USCOREType * SOAP_FMAC6 soap_new_jsdl__Range_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Range_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Range_USCOREType(struct soap *soap, jsdl__Range_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__Range_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__Range_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Range_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Range_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__Range_USCOREType;
		if (size)
			*size = sizeof(jsdl__Range_USCOREType);
		((jsdl__Range_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__Range_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__Range_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__Range_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__Range_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Range_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__Range_USCOREType %p -> %p\n", q, p));
	*(jsdl__Range_USCOREType*)p = *(jsdl__Range_USCOREType*)q;
}

void jsdl__Exact_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdl__Exact_USCOREType*)this)->__item, SOAP_TYPE_double);
	/* transient soap skipped */
}

void jsdl__Exact_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_double(soap, &((jsdl__Exact_USCOREType*)this)->__item);
	((jsdl__Exact_USCOREType*)this)->epsilon = NULL;
	((jsdl__Exact_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__Exact_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__Exact_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__Exact_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__Exact_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Exact_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__Exact_USCOREType *a, const char *type)
{
	if (((jsdl__Exact_USCOREType *)a)->epsilon)
		soap_set_attr(soap, "epsilon", soap_double2s(soap, *((jsdl__Exact_USCOREType *)a)->epsilon));
	if (((jsdl__Exact_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__Exact_USCOREType *)a)->__anyAttribute);
	return soap_out_double(soap, tag, id, &(((jsdl__Exact_USCOREType*)a)->__item), "");
}

void *jsdl__Exact_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__Exact_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__Exact_USCOREType * SOAP_FMAC4 soap_get_jsdl__Exact_USCOREType(struct soap *soap, jsdl__Exact_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Exact_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__Exact_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__Exact_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__Exact_USCOREType * SOAP_FMAC4 soap_in_jsdl__Exact_USCOREType(struct soap *soap, const char *tag, jsdl__Exact_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdl__Exact_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__Exact_USCOREType, sizeof(jsdl__Exact_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__Exact_USCOREType)
			return (jsdl__Exact_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "epsilon", 0);
		if (t)
		{	if (!(((jsdl__Exact_USCOREType *)a)->epsilon = (double *)soap_malloc(soap, sizeof(double))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2double(soap, t, ((jsdl__Exact_USCOREType *)a)->epsilon))
		return NULL;
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__Exact_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_double(soap, tag, &(((jsdl__Exact_USCOREType*)a)->__item), "jsdl:Exact_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdl__Exact_USCOREType * SOAP_FMAC6 soap_new_jsdl__Exact_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Exact_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Exact_USCOREType(struct soap *soap, jsdl__Exact_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__Exact_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__Exact_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Exact_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Exact_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__Exact_USCOREType;
		if (size)
			*size = sizeof(jsdl__Exact_USCOREType);
		((jsdl__Exact_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__Exact_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__Exact_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__Exact_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__Exact_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Exact_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__Exact_USCOREType %p -> %p\n", q, p));
	*(jsdl__Exact_USCOREType*)p = *(jsdl__Exact_USCOREType*)q;
}

void jsdl__Boundary_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdl__Boundary_USCOREType*)this)->__item, SOAP_TYPE_double);
	/* transient soap skipped */
}

void jsdl__Boundary_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_double(soap, &((jsdl__Boundary_USCOREType*)this)->__item);
	((jsdl__Boundary_USCOREType*)this)->exclusiveBound = NULL;
	((jsdl__Boundary_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdl__Boundary_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdl__Boundary_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdl__Boundary_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdl__Boundary_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdl__Boundary_USCOREType(struct soap *soap, const char *tag, int id, const jsdl__Boundary_USCOREType *a, const char *type)
{
	if (((jsdl__Boundary_USCOREType *)a)->exclusiveBound)
		soap_set_attr(soap, "exclusiveBound", soap_bool2s(soap, *((jsdl__Boundary_USCOREType *)a)->exclusiveBound));
	if (((jsdl__Boundary_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdl__Boundary_USCOREType *)a)->__anyAttribute);
	return soap_out_double(soap, tag, id, &(((jsdl__Boundary_USCOREType*)a)->__item), "");
}

void *jsdl__Boundary_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdl__Boundary_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdl__Boundary_USCOREType * SOAP_FMAC4 soap_get_jsdl__Boundary_USCOREType(struct soap *soap, jsdl__Boundary_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdl__Boundary_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdl__Boundary_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdl__Boundary_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdl__Boundary_USCOREType * SOAP_FMAC4 soap_in_jsdl__Boundary_USCOREType(struct soap *soap, const char *tag, jsdl__Boundary_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdl__Boundary_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdl__Boundary_USCOREType, sizeof(jsdl__Boundary_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdl__Boundary_USCOREType)
			return (jsdl__Boundary_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "exclusiveBound", 0);
		if (t)
		{	if (!(((jsdl__Boundary_USCOREType *)a)->exclusiveBound = (bool *)soap_malloc(soap, sizeof(bool))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	if (soap_s2bool(soap, t, ((jsdl__Boundary_USCOREType *)a)->exclusiveBound))
		return NULL;
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdl__Boundary_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_double(soap, tag, &(((jsdl__Boundary_USCOREType*)a)->__item), "jsdl:Boundary_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdl__Boundary_USCOREType * SOAP_FMAC6 soap_new_jsdl__Boundary_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdl__Boundary_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdl__Boundary_USCOREType(struct soap *soap, jsdl__Boundary_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdl__Boundary_USCOREType * SOAP_FMAC4 soap_instantiate_jsdl__Boundary_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdl__Boundary_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdl__Boundary_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdl__Boundary_USCOREType;
		if (size)
			*size = sizeof(jsdl__Boundary_USCOREType);
		((jsdl__Boundary_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdl__Boundary_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdl__Boundary_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdl__Boundary_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdl__Boundary_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdl__Boundary_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdl__Boundary_USCOREType %p -> %p\n", q, p));
	*(jsdl__Boundary_USCOREType*)p = *(jsdl__Boundary_USCOREType*)q;
}

void jsdlARC__CandidateTarget_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__CandidateTarget_USCOREType*)this)->HostName);
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__CandidateTarget_USCOREType*)this)->QueueName);
	/* transient soap skipped */
}

void jsdlARC__CandidateTarget_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdlARC__CandidateTarget_USCOREType*)this)->HostName = NULL;
	((jsdlARC__CandidateTarget_USCOREType*)this)->QueueName = NULL;
	/* transient soap skipped */
}

int jsdlARC__CandidateTarget_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__CandidateTarget_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__CandidateTarget_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__CandidateTarget_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType), type);
	soap_out_PointerTostd__string(soap, "HostName", -1, &(((jsdlARC__CandidateTarget_USCOREType*)a)->HostName), "");
	soap_out_PointerTostd__string(soap, "QueueName", -1, &(((jsdlARC__CandidateTarget_USCOREType*)a)->QueueName), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__CandidateTarget_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__CandidateTarget_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__CandidateTarget_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, jsdlARC__CandidateTarget_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__CandidateTarget_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__CandidateTarget_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__CandidateTarget_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__CandidateTarget_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, const char *tag, jsdlARC__CandidateTarget_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__CandidateTarget_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType, sizeof(jsdlARC__CandidateTarget_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__CandidateTarget_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_HostName1 = 1, soap_flag_QueueName1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_HostName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "HostName", &(((jsdlARC__CandidateTarget_USCOREType*)a)->HostName), "xsd:string"))
				{	soap_flag_HostName1--;
					continue;
				}
			if (soap_flag_QueueName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "QueueName", &(((jsdlARC__CandidateTarget_USCOREType*)a)->QueueName), "xsd:string"))
				{	soap_flag_QueueName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__CandidateTarget_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType, 0, sizeof(jsdlARC__CandidateTarget_USCOREType), 0, soap_copy_jsdlARC__CandidateTarget_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__CandidateTarget_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__CandidateTarget_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, jsdlARC__CandidateTarget_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__CandidateTarget_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__CandidateTarget_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__CandidateTarget_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__CandidateTarget_USCOREType);
		((jsdlARC__CandidateTarget_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__CandidateTarget_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__CandidateTarget_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__CandidateTarget_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__CandidateTarget_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__CandidateTarget_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__CandidateTarget_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__CandidateTarget_USCOREType*)p = *(jsdlARC__CandidateTarget_USCOREType*)q;
}

void jsdlARC__Notify_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdlARC__NotificationType_USCOREType(soap, &((jsdlARC__Notify_USCOREType*)this)->Type);
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__Notify_USCOREType*)this)->Endpoint);
	soap_serialize_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, &((jsdlARC__Notify_USCOREType*)this)->State);
	/* transient soap skipped */
}

void jsdlARC__Notify_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdlARC__Notify_USCOREType*)this)->Type = NULL;
	((jsdlARC__Notify_USCOREType*)this)->Endpoint = NULL;
	soap_default_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, &((jsdlARC__Notify_USCOREType*)this)->State);
	/* transient soap skipped */
}

int jsdlARC__Notify_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__Notify_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__Notify_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__Notify_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__Notify_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__Notify_USCOREType), type);
	soap_out_PointerTojsdlARC__NotificationType_USCOREType(soap, "Type", -1, &(((jsdlARC__Notify_USCOREType*)a)->Type), "");
	soap_out_PointerTostd__string(soap, "Endpoint", -1, &(((jsdlARC__Notify_USCOREType*)a)->Endpoint), "");
	soap_out_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, "State", -1, &(((jsdlARC__Notify_USCOREType*)a)->State), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__Notify_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__Notify_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__Notify_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__Notify_USCOREType(struct soap *soap, jsdlARC__Notify_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__Notify_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__Notify_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__Notify_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__Notify_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, jsdlARC__Notify_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__Notify_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__Notify_USCOREType, sizeof(jsdlARC__Notify_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__Notify_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__Notify_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Type1 = 1, soap_flag_Endpoint1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__NotificationType_USCOREType(soap, "Type", &(((jsdlARC__Notify_USCOREType*)a)->Type), "jsdlARC:NotificationType_Type"))
				{	soap_flag_Type1--;
					continue;
				}
			if (soap_flag_Endpoint1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "Endpoint", &(((jsdlARC__Notify_USCOREType*)a)->Endpoint), "xsd:string"))
				{	soap_flag_Endpoint1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, "State", &(((jsdlARC__Notify_USCOREType*)a)->State), "jsdlARC:GMState_Type"))
					continue;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__Notify_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__Notify_USCOREType, 0, sizeof(jsdlARC__Notify_USCOREType), 0, soap_copy_jsdlARC__Notify_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__Notify_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__Notify_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__Notify_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__Notify_USCOREType(struct soap *soap, jsdlARC__Notify_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__Notify_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__Notify_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__Notify_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__Notify_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__Notify_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__Notify_USCOREType);
		((jsdlARC__Notify_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__Notify_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__Notify_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__Notify_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__Notify_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__Notify_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__Notify_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__Notify_USCOREType*)p = *(jsdlARC__Notify_USCOREType*)q;
}

void jsdlARC__AccessControl_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTobool(soap, &((jsdlARC__AccessControl_USCOREType*)this)->OwnerAlwaysAllowed);
	soap_serialize_PointerTojsdlARC__AccessControlType_USCOREType(soap, &((jsdlARC__AccessControl_USCOREType*)this)->Type);
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__AccessControl_USCOREType*)this)->Content);
	/* transient soap skipped */
}

void jsdlARC__AccessControl_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdlARC__AccessControl_USCOREType*)this)->OwnerAlwaysAllowed = NULL;
	((jsdlARC__AccessControl_USCOREType*)this)->Type = NULL;
	((jsdlARC__AccessControl_USCOREType*)this)->Content = NULL;
	/* transient soap skipped */
}

int jsdlARC__AccessControl_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__AccessControl_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__AccessControl_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__AccessControl_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__AccessControl_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__AccessControl_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__AccessControl_USCOREType), type);
	soap_out_PointerTobool(soap, "OwnerAlwaysAllowed", -1, &(((jsdlARC__AccessControl_USCOREType*)a)->OwnerAlwaysAllowed), "");
	soap_out_PointerTojsdlARC__AccessControlType_USCOREType(soap, "Type", -1, &(((jsdlARC__AccessControl_USCOREType*)a)->Type), "");
	soap_out_PointerTostd__string(soap, "Content", -1, &(((jsdlARC__AccessControl_USCOREType*)a)->Content), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__AccessControl_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__AccessControl_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__AccessControl_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__AccessControl_USCOREType(struct soap *soap, jsdlARC__AccessControl_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__AccessControl_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__AccessControl_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__AccessControl_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__AccessControl_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__AccessControl_USCOREType(struct soap *soap, const char *tag, jsdlARC__AccessControl_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__AccessControl_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__AccessControl_USCOREType, sizeof(jsdlARC__AccessControl_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__AccessControl_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__AccessControl_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_OwnerAlwaysAllowed1 = 1, soap_flag_Type1 = 1, soap_flag_Content1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_OwnerAlwaysAllowed1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "OwnerAlwaysAllowed", &(((jsdlARC__AccessControl_USCOREType*)a)->OwnerAlwaysAllowed), "xsd:boolean"))
				{	soap_flag_OwnerAlwaysAllowed1--;
					continue;
				}
			if (soap_flag_Type1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__AccessControlType_USCOREType(soap, "Type", &(((jsdlARC__AccessControl_USCOREType*)a)->Type), "jsdlARC:AccessControlType_Type"))
				{	soap_flag_Type1--;
					continue;
				}
			if (soap_flag_Content1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "Content", &(((jsdlARC__AccessControl_USCOREType*)a)->Content), "xsd:string"))
				{	soap_flag_Content1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__AccessControl_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__AccessControl_USCOREType, 0, sizeof(jsdlARC__AccessControl_USCOREType), 0, soap_copy_jsdlARC__AccessControl_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__AccessControl_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__AccessControl_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__AccessControl_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__AccessControl_USCOREType(struct soap *soap, jsdlARC__AccessControl_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__AccessControl_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__AccessControl_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__AccessControl_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__AccessControl_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__AccessControl_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__AccessControl_USCOREType);
		((jsdlARC__AccessControl_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__AccessControl_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__AccessControl_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__AccessControl_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__AccessControl_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__AccessControl_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__AccessControl_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__AccessControl_USCOREType*)p = *(jsdlARC__AccessControl_USCOREType*)q;
}

void jsdlARC__LocalLogging_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlARC__LocalLogging_USCOREType*)this)->Directory, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlARC__LocalLogging_USCOREType*)this)->Directory);
	/* transient soap skipped */
}

void jsdlARC__LocalLogging_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlARC__LocalLogging_USCOREType*)this)->Directory);
	/* transient soap skipped */
}

int jsdlARC__LocalLogging_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__LocalLogging_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__LocalLogging_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__LocalLogging_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__LocalLogging_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType), type);
	soap_out_std__string(soap, "Directory", -1, &(((jsdlARC__LocalLogging_USCOREType*)a)->Directory), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__LocalLogging_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__LocalLogging_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__LocalLogging_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__LocalLogging_USCOREType(struct soap *soap, jsdlARC__LocalLogging_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__LocalLogging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__LocalLogging_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__LocalLogging_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__LocalLogging_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__LocalLogging_USCOREType(struct soap *soap, const char *tag, jsdlARC__LocalLogging_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__LocalLogging_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType, sizeof(jsdlARC__LocalLogging_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__LocalLogging_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__LocalLogging_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Directory1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Directory1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "Directory", &(((jsdlARC__LocalLogging_USCOREType*)a)->Directory), "xsd:string"))
				{	soap_flag_Directory1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Directory1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__LocalLogging_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType, 0, sizeof(jsdlARC__LocalLogging_USCOREType), 0, soap_copy_jsdlARC__LocalLogging_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__LocalLogging_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__LocalLogging_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__LocalLogging_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__LocalLogging_USCOREType(struct soap *soap, jsdlARC__LocalLogging_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__LocalLogging_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__LocalLogging_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__LocalLogging_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__LocalLogging_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__LocalLogging_USCOREType);
		((jsdlARC__LocalLogging_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__LocalLogging_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__LocalLogging_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__LocalLogging_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__LocalLogging_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__LocalLogging_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__LocalLogging_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__LocalLogging_USCOREType*)p = *(jsdlARC__LocalLogging_USCOREType*)q;
}

void jsdlARC__CredentialServer_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlARC__CredentialServer_USCOREType*)this)->URL, SOAP_TYPE_xsd__anyURI);
	soap_serialize_xsd__anyURI(soap, &((jsdlARC__CredentialServer_USCOREType*)this)->URL);
	/* transient soap skipped */
}

void jsdlARC__CredentialServer_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((jsdlARC__CredentialServer_USCOREType*)this)->URL);
	/* transient soap skipped */
}

int jsdlARC__CredentialServer_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__CredentialServer_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__CredentialServer_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__CredentialServer_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__CredentialServer_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType), type);
	soap_out_xsd__anyURI(soap, "URL", -1, &(((jsdlARC__CredentialServer_USCOREType*)a)->URL), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__CredentialServer_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__CredentialServer_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__CredentialServer_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__CredentialServer_USCOREType(struct soap *soap, jsdlARC__CredentialServer_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__CredentialServer_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__CredentialServer_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__CredentialServer_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__CredentialServer_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__CredentialServer_USCOREType(struct soap *soap, const char *tag, jsdlARC__CredentialServer_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__CredentialServer_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType, sizeof(jsdlARC__CredentialServer_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__CredentialServer_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__CredentialServer_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_URL1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_URL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "URL", &(((jsdlARC__CredentialServer_USCOREType*)a)->URL), "xsd:anyURI"))
				{	soap_flag_URL1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_URL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__CredentialServer_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType, 0, sizeof(jsdlARC__CredentialServer_USCOREType), 0, soap_copy_jsdlARC__CredentialServer_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__CredentialServer_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__CredentialServer_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__CredentialServer_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__CredentialServer_USCOREType(struct soap *soap, jsdlARC__CredentialServer_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__CredentialServer_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__CredentialServer_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__CredentialServer_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__CredentialServer_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__CredentialServer_USCOREType);
		((jsdlARC__CredentialServer_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__CredentialServer_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__CredentialServer_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__CredentialServer_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__CredentialServer_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__CredentialServer_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__CredentialServer_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__CredentialServer_USCOREType*)p = *(jsdlARC__CredentialServer_USCOREType*)q;
}

void jsdlARC__RemoteLogging_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlARC__RemoteLogging_USCOREType*)this)->URL, SOAP_TYPE_xsd__anyURI);
	soap_serialize_xsd__anyURI(soap, &((jsdlARC__RemoteLogging_USCOREType*)this)->URL);
	/* transient soap skipped */
}

void jsdlARC__RemoteLogging_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((jsdlARC__RemoteLogging_USCOREType*)this)->URL);
	/* transient soap skipped */
}

int jsdlARC__RemoteLogging_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__RemoteLogging_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__RemoteLogging_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__RemoteLogging_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType), type);
	soap_out_xsd__anyURI(soap, "URL", -1, &(((jsdlARC__RemoteLogging_USCOREType*)a)->URL), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__RemoteLogging_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__RemoteLogging_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__RemoteLogging_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, jsdlARC__RemoteLogging_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__RemoteLogging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__RemoteLogging_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__RemoteLogging_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__RemoteLogging_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, jsdlARC__RemoteLogging_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__RemoteLogging_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType, sizeof(jsdlARC__RemoteLogging_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__RemoteLogging_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_URL1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_URL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "URL", &(((jsdlARC__RemoteLogging_USCOREType*)a)->URL), "xsd:anyURI"))
				{	soap_flag_URL1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_URL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__RemoteLogging_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType, 0, sizeof(jsdlARC__RemoteLogging_USCOREType), 0, soap_copy_jsdlARC__RemoteLogging_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__RemoteLogging_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__RemoteLogging_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, jsdlARC__RemoteLogging_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__RemoteLogging_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__RemoteLogging_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__RemoteLogging_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__RemoteLogging_USCOREType);
		((jsdlARC__RemoteLogging_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__RemoteLogging_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__RemoteLogging_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__RemoteLogging_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__RemoteLogging_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__RemoteLogging_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__RemoteLogging_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__RemoteLogging_USCOREType*)p = *(jsdlARC__RemoteLogging_USCOREType*)q;
}

void jsdlARC__Middleware_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlARC__Middleware_USCOREType*)this)->Name, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlARC__Middleware_USCOREType*)this)->Name);
	soap_serialize_PointerTojsdlARC__Version_USCOREType(soap, &((jsdlARC__Middleware_USCOREType*)this)->Version);
	/* transient soap skipped */
}

void jsdlARC__Middleware_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlARC__Middleware_USCOREType*)this)->Name);
	((jsdlARC__Middleware_USCOREType*)this)->Version = NULL;
	/* transient soap skipped */
}

int jsdlARC__Middleware_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__Middleware_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__Middleware_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__Middleware_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__Middleware_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__Middleware_USCOREType), type);
	soap_out_std__string(soap, "Name", -1, &(((jsdlARC__Middleware_USCOREType*)a)->Name), "");
	soap_out_PointerTojsdlARC__Version_USCOREType(soap, "Version", -1, &(((jsdlARC__Middleware_USCOREType*)a)->Version), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__Middleware_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__Middleware_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__Middleware_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__Middleware_USCOREType(struct soap *soap, jsdlARC__Middleware_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__Middleware_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__Middleware_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__Middleware_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__Middleware_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, jsdlARC__Middleware_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__Middleware_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__Middleware_USCOREType, sizeof(jsdlARC__Middleware_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__Middleware_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__Middleware_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Name1 = 1, soap_flag_Version1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "Name", &(((jsdlARC__Middleware_USCOREType*)a)->Name), "xsd:string"))
				{	soap_flag_Name1--;
					continue;
				}
			if (soap_flag_Version1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__Version_USCOREType(soap, "Version", &(((jsdlARC__Middleware_USCOREType*)a)->Version), "jsdlARC:Version_Type"))
				{	soap_flag_Version1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Name1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__Middleware_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__Middleware_USCOREType, 0, sizeof(jsdlARC__Middleware_USCOREType), 0, soap_copy_jsdlARC__Middleware_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__Middleware_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__Middleware_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__Middleware_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__Middleware_USCOREType(struct soap *soap, jsdlARC__Middleware_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__Middleware_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__Middleware_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__Middleware_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__Middleware_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__Middleware_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__Middleware_USCOREType);
		((jsdlARC__Middleware_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__Middleware_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__Middleware_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__Middleware_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__Middleware_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__Middleware_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__Middleware_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__Middleware_USCOREType*)p = *(jsdlARC__Middleware_USCOREType*)q;
}

void jsdlARC__RunTimeEnvironment_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlARC__RunTimeEnvironment_USCOREType*)this)->Name, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlARC__RunTimeEnvironment_USCOREType*)this)->Name);
	soap_serialize_PointerTojsdlARC__Version_USCOREType(soap, &((jsdlARC__RunTimeEnvironment_USCOREType*)this)->Version);
	/* transient soap skipped */
}

void jsdlARC__RunTimeEnvironment_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlARC__RunTimeEnvironment_USCOREType*)this)->Name);
	((jsdlARC__RunTimeEnvironment_USCOREType*)this)->Version = NULL;
	/* transient soap skipped */
}

int jsdlARC__RunTimeEnvironment_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__RunTimeEnvironment_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__RunTimeEnvironment_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__RunTimeEnvironment_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType), type);
	soap_out_std__string(soap, "Name", -1, &(((jsdlARC__RunTimeEnvironment_USCOREType*)a)->Name), "");
	soap_out_PointerTojsdlARC__Version_USCOREType(soap, "Version", -1, &(((jsdlARC__RunTimeEnvironment_USCOREType*)a)->Version), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__RunTimeEnvironment_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__RunTimeEnvironment_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__RunTimeEnvironment_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, jsdlARC__RunTimeEnvironment_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__RunTimeEnvironment_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__RunTimeEnvironment_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__RunTimeEnvironment_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__RunTimeEnvironment_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, jsdlARC__RunTimeEnvironment_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__RunTimeEnvironment_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType, sizeof(jsdlARC__RunTimeEnvironment_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__RunTimeEnvironment_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_Name1 = 1, soap_flag_Version1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_std__string(soap, "Name", &(((jsdlARC__RunTimeEnvironment_USCOREType*)a)->Name), "xsd:string"))
				{	soap_flag_Name1--;
					continue;
				}
			if (soap_flag_Version1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlARC__Version_USCOREType(soap, "Version", &(((jsdlARC__RunTimeEnvironment_USCOREType*)a)->Version), "jsdlARC:Version_Type"))
				{	soap_flag_Version1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_Name1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__RunTimeEnvironment_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType, 0, sizeof(jsdlARC__RunTimeEnvironment_USCOREType), 0, soap_copy_jsdlARC__RunTimeEnvironment_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__RunTimeEnvironment_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__RunTimeEnvironment_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, jsdlARC__RunTimeEnvironment_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__RunTimeEnvironment_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__RunTimeEnvironment_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__RunTimeEnvironment_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__RunTimeEnvironment_USCOREType);
		((jsdlARC__RunTimeEnvironment_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__RunTimeEnvironment_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__RunTimeEnvironment_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__RunTimeEnvironment_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__RunTimeEnvironment_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__RunTimeEnvironment_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__RunTimeEnvironment_USCOREType*)p = *(jsdlARC__RunTimeEnvironment_USCOREType*)q;
}

void jsdlARC__Version_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__Version_USCOREType*)this)->UpperExclusive);
	soap_serialize_PointerTostd__string(soap, &((jsdlARC__Version_USCOREType*)this)->LowerExclusive);
	soap_serialize_std__vectorTemplateOfstd__string(soap, &((jsdlARC__Version_USCOREType*)this)->Exact);
	soap_serialize_PointerTobool(soap, &((jsdlARC__Version_USCOREType*)this)->Exclusive);
	/* transient soap skipped */
}

void jsdlARC__Version_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdlARC__Version_USCOREType*)this)->UpperExclusive = NULL;
	((jsdlARC__Version_USCOREType*)this)->LowerExclusive = NULL;
	soap_default_std__vectorTemplateOfstd__string(soap, &((jsdlARC__Version_USCOREType*)this)->Exact);
	((jsdlARC__Version_USCOREType*)this)->Exclusive = NULL;
	/* transient soap skipped */
}

int jsdlARC__Version_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlARC__Version_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlARC__Version_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlARC__Version_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlARC__Version_USCOREType(struct soap *soap, const char *tag, int id, const jsdlARC__Version_USCOREType *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlARC__Version_USCOREType), type);
	soap_out_PointerTostd__string(soap, "UpperExclusive", -1, &(((jsdlARC__Version_USCOREType*)a)->UpperExclusive), "");
	soap_out_PointerTostd__string(soap, "LowerExclusive", -1, &(((jsdlARC__Version_USCOREType*)a)->LowerExclusive), "");
	soap_out_std__vectorTemplateOfstd__string(soap, "Exact", -1, &(((jsdlARC__Version_USCOREType*)a)->Exact), "");
	soap_out_PointerTobool(soap, "Exclusive", -1, &(((jsdlARC__Version_USCOREType*)a)->Exclusive), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlARC__Version_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlARC__Version_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlARC__Version_USCOREType * SOAP_FMAC4 soap_get_jsdlARC__Version_USCOREType(struct soap *soap, jsdlARC__Version_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlARC__Version_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlARC__Version_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlARC__Version_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlARC__Version_USCOREType * SOAP_FMAC4 soap_in_jsdlARC__Version_USCOREType(struct soap *soap, const char *tag, jsdlARC__Version_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlARC__Version_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlARC__Version_USCOREType, sizeof(jsdlARC__Version_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlARC__Version_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlARC__Version_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_UpperExclusive1 = 1, soap_flag_LowerExclusive1 = 1, soap_flag_Exclusive1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_UpperExclusive1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "UpperExclusive", &(((jsdlARC__Version_USCOREType*)a)->UpperExclusive), "xsd:string"))
				{	soap_flag_UpperExclusive1--;
					continue;
				}
			if (soap_flag_LowerExclusive1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "LowerExclusive", &(((jsdlARC__Version_USCOREType*)a)->LowerExclusive), "xsd:string"))
				{	soap_flag_LowerExclusive1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfstd__string(soap, "Exact", &(((jsdlARC__Version_USCOREType*)a)->Exact), "xsd:string"))
					continue;
			if (soap_flag_Exclusive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "Exclusive", &(((jsdlARC__Version_USCOREType*)a)->Exclusive), "xsd:boolean"))
				{	soap_flag_Exclusive1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlARC__Version_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlARC__Version_USCOREType, 0, sizeof(jsdlARC__Version_USCOREType), 0, soap_copy_jsdlARC__Version_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlARC__Version_USCOREType * SOAP_FMAC6 soap_new_jsdlARC__Version_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlARC__Version_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlARC__Version_USCOREType(struct soap *soap, jsdlARC__Version_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlARC__Version_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlARC__Version_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlARC__Version_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlARC__Version_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlARC__Version_USCOREType;
		if (size)
			*size = sizeof(jsdlARC__Version_USCOREType);
		((jsdlARC__Version_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlARC__Version_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlARC__Version_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlARC__Version_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlARC__Version_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlARC__Version_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlARC__Version_USCOREType %p -> %p\n", q, p));
	*(jsdlARC__Version_USCOREType*)p = *(jsdlARC__Version_USCOREType*)q;
}

void jsdlPOSIX__POSIXApplication_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Executable);
	soap_serialize_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Argument);
	soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Input);
	soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Output);
	soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Error);
	soap_serialize_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->WorkingDirectory);
	soap_serialize_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Environment);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->WallTimeLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->FileSizeLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->CoreDumpLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->DataSegmentLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->LockedMemoryLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->MemoryLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->OpenDescriptorsLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->PipeSizeLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->StackSizeLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->CPUTimeLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->ProcessCountLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->VirtualMemoryLimit);
	soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->ThreadCountLimit);
	soap_serialize_PointerTojsdlPOSIX__UserName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->UserName);
	soap_serialize_PointerTojsdlPOSIX__GroupName_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->GroupName);
	/* transient soap skipped */
}

void jsdlPOSIX__POSIXApplication_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Executable = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Argument);
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Input = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Output = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Error = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->WorkingDirectory = NULL;
	soap_default_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, &((jsdlPOSIX__POSIXApplication_USCOREType*)this)->Environment);
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->WallTimeLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->FileSizeLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->CoreDumpLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->DataSegmentLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->LockedMemoryLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->MemoryLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->OpenDescriptorsLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->PipeSizeLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->StackSizeLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->CPUTimeLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->ProcessCountLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->VirtualMemoryLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->ThreadCountLimit = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->UserName = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->GroupName = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->name = NULL;
	((jsdlPOSIX__POSIXApplication_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__POSIXApplication_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__POSIXApplication_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__POSIXApplication_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__POSIXApplication_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__POSIXApplication_USCOREType *)a)->name)
		soap_set_attr(soap, "name", ((jsdlPOSIX__POSIXApplication_USCOREType *)a)->name->c_str());
	if (((jsdlPOSIX__POSIXApplication_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__POSIXApplication_USCOREType *)a)->__anyAttribute);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType), type);
	soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Executable", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Executable), "");
	soap_out_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, "jsdlPOSIX:Argument", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Argument), "");
	soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Input", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Input), "");
	soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Output", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Output), "");
	soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Error", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Error), "");
	soap_out_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, "jsdlPOSIX:WorkingDirectory", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->WorkingDirectory), "");
	soap_out_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, "jsdlPOSIX:Environment", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Environment), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:WallTimeLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->WallTimeLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:FileSizeLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->FileSizeLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:CoreDumpLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->CoreDumpLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:DataSegmentLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->DataSegmentLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:LockedMemoryLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->LockedMemoryLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:MemoryLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->MemoryLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:OpenDescriptorsLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->OpenDescriptorsLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:PipeSizeLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->PipeSizeLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:StackSizeLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->StackSizeLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:CPUTimeLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->CPUTimeLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:ProcessCountLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->ProcessCountLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:VirtualMemoryLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->VirtualMemoryLimit), "");
	soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:ThreadCountLimit", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->ThreadCountLimit), "");
	soap_out_PointerTojsdlPOSIX__UserName_USCOREType(soap, "jsdlPOSIX:UserName", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->UserName), "");
	soap_out_PointerTojsdlPOSIX__GroupName_USCOREType(soap, "jsdlPOSIX:GroupName", -1, &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->GroupName), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *jsdlPOSIX__POSIXApplication_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__POSIXApplication_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__POSIXApplication_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, jsdlPOSIX__POSIXApplication_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__POSIXApplication_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__POSIXApplication_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__POSIXApplication_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__POSIXApplication_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__POSIXApplication_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (jsdlPOSIX__POSIXApplication_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType, sizeof(jsdlPOSIX__POSIXApplication_USCOREType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (jsdlPOSIX__POSIXApplication_USCOREType *)a->soap_in(soap, tag, type);
		}
	}
	{	const char *t = soap_attr_value(soap, "name", 0);
		if (t)
		{	if (!(((jsdlPOSIX__POSIXApplication_USCOREType *)a)->name = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdlPOSIX__POSIXApplication_USCOREType *)a)->name = soap_new_std__string(soap, -1);
			((jsdlPOSIX__POSIXApplication_USCOREType *)a)->name->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__POSIXApplication_USCOREType *)a)->__anyAttribute))
		return NULL;
	short soap_flag_Executable1 = 1, soap_flag_Input1 = 1, soap_flag_Output1 = 1, soap_flag_Error1 = 1, soap_flag_WorkingDirectory1 = 1, soap_flag_WallTimeLimit1 = 1, soap_flag_FileSizeLimit1 = 1, soap_flag_CoreDumpLimit1 = 1, soap_flag_DataSegmentLimit1 = 1, soap_flag_LockedMemoryLimit1 = 1, soap_flag_MemoryLimit1 = 1, soap_flag_OpenDescriptorsLimit1 = 1, soap_flag_PipeSizeLimit1 = 1, soap_flag_StackSizeLimit1 = 1, soap_flag_CPUTimeLimit1 = 1, soap_flag_ProcessCountLimit1 = 1, soap_flag_VirtualMemoryLimit1 = 1, soap_flag_ThreadCountLimit1 = 1, soap_flag_UserName1 = 1, soap_flag_GroupName1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_Executable1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Executable", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Executable), "jsdlPOSIX:FileName_Type"))
				{	soap_flag_Executable1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, "jsdlPOSIX:Argument", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Argument), "jsdlPOSIX:Argument_Type"))
					continue;
			if (soap_flag_Input1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Input", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Input), "jsdlPOSIX:FileName_Type"))
				{	soap_flag_Input1--;
					continue;
				}
			if (soap_flag_Output1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Output", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Output), "jsdlPOSIX:FileName_Type"))
				{	soap_flag_Output1--;
					continue;
				}
			if (soap_flag_Error1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, "jsdlPOSIX:Error", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Error), "jsdlPOSIX:FileName_Type"))
				{	soap_flag_Error1--;
					continue;
				}
			if (soap_flag_WorkingDirectory1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, "jsdlPOSIX:WorkingDirectory", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->WorkingDirectory), "jsdlPOSIX:DirectoryName_Type"))
				{	soap_flag_WorkingDirectory1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, "jsdlPOSIX:Environment", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->Environment), "jsdlPOSIX:Environment_Type"))
					continue;
			if (soap_flag_WallTimeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:WallTimeLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->WallTimeLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_WallTimeLimit1--;
					continue;
				}
			if (soap_flag_FileSizeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:FileSizeLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->FileSizeLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_FileSizeLimit1--;
					continue;
				}
			if (soap_flag_CoreDumpLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:CoreDumpLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->CoreDumpLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_CoreDumpLimit1--;
					continue;
				}
			if (soap_flag_DataSegmentLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:DataSegmentLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->DataSegmentLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_DataSegmentLimit1--;
					continue;
				}
			if (soap_flag_LockedMemoryLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:LockedMemoryLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->LockedMemoryLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_LockedMemoryLimit1--;
					continue;
				}
			if (soap_flag_MemoryLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:MemoryLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->MemoryLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_MemoryLimit1--;
					continue;
				}
			if (soap_flag_OpenDescriptorsLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:OpenDescriptorsLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->OpenDescriptorsLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_OpenDescriptorsLimit1--;
					continue;
				}
			if (soap_flag_PipeSizeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:PipeSizeLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->PipeSizeLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_PipeSizeLimit1--;
					continue;
				}
			if (soap_flag_StackSizeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:StackSizeLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->StackSizeLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_StackSizeLimit1--;
					continue;
				}
			if (soap_flag_CPUTimeLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:CPUTimeLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->CPUTimeLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_CPUTimeLimit1--;
					continue;
				}
			if (soap_flag_ProcessCountLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:ProcessCountLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->ProcessCountLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_ProcessCountLimit1--;
					continue;
				}
			if (soap_flag_VirtualMemoryLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:VirtualMemoryLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->VirtualMemoryLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_VirtualMemoryLimit1--;
					continue;
				}
			if (soap_flag_ThreadCountLimit1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, "jsdlPOSIX:ThreadCountLimit", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->ThreadCountLimit), "jsdlPOSIX:Limits_Type"))
				{	soap_flag_ThreadCountLimit1--;
					continue;
				}
			if (soap_flag_UserName1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__UserName_USCOREType(soap, "jsdlPOSIX:UserName", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->UserName), "jsdlPOSIX:UserName_Type"))
				{	soap_flag_UserName1--;
					continue;
				}
			if (soap_flag_GroupName1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTojsdlPOSIX__GroupName_USCOREType(soap, "jsdlPOSIX:GroupName", &(((jsdlPOSIX__POSIXApplication_USCOREType*)a)->GroupName), "jsdlPOSIX:GroupName_Type"))
				{	soap_flag_GroupName1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__POSIXApplication_USCOREType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType, 0, sizeof(jsdlPOSIX__POSIXApplication_USCOREType), 0, soap_copy_jsdlPOSIX__POSIXApplication_USCOREType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 jsdlPOSIX__POSIXApplication_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__POSIXApplication_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, jsdlPOSIX__POSIXApplication_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__POSIXApplication_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__POSIXApplication_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__POSIXApplication_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__POSIXApplication_USCOREType);
		((jsdlPOSIX__POSIXApplication_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__POSIXApplication_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__POSIXApplication_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__POSIXApplication_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__POSIXApplication_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__POSIXApplication_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__POSIXApplication_USCOREType*)p = *(jsdlPOSIX__POSIXApplication_USCOREType*)q;
}

void jsdlPOSIX__GroupName_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlPOSIX__GroupName_USCOREType*)this)->__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlPOSIX__GroupName_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__GroupName_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlPOSIX__GroupName_USCOREType*)this)->__item);
	((jsdlPOSIX__GroupName_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__GroupName_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__GroupName_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__GroupName_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__GroupName_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__GroupName_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__GroupName_USCOREType *)a)->__anyAttribute);
	return soap_out_std__string(soap, tag, id, &(((jsdlPOSIX__GroupName_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__GroupName_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__GroupName_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__GroupName_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, jsdlPOSIX__GroupName_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__GroupName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__GroupName_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__GroupName_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__GroupName_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__GroupName_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__GroupName_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType, sizeof(jsdlPOSIX__GroupName_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType)
			return (jsdlPOSIX__GroupName_USCOREType *)a->soap_in(soap, tag, type);
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__GroupName_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_std__string(soap, tag, &(((jsdlPOSIX__GroupName_USCOREType*)a)->__item), "jsdlPOSIX:GroupName_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__GroupName_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__GroupName_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, jsdlPOSIX__GroupName_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__GroupName_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__GroupName_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__GroupName_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__GroupName_USCOREType);
		((jsdlPOSIX__GroupName_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__GroupName_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__GroupName_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__GroupName_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__GroupName_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__GroupName_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__GroupName_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__GroupName_USCOREType*)p = *(jsdlPOSIX__GroupName_USCOREType*)q;
}

void jsdlPOSIX__UserName_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlPOSIX__UserName_USCOREType*)this)->__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlPOSIX__UserName_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__UserName_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlPOSIX__UserName_USCOREType*)this)->__item);
	((jsdlPOSIX__UserName_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__UserName_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__UserName_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__UserName_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__UserName_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__UserName_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__UserName_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__UserName_USCOREType *)a)->__anyAttribute);
	return soap_out_std__string(soap, tag, id, &(((jsdlPOSIX__UserName_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__UserName_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__UserName_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__UserName_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__UserName_USCOREType(struct soap *soap, jsdlPOSIX__UserName_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__UserName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__UserName_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__UserName_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__UserName_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__UserName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__UserName_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__UserName_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType, sizeof(jsdlPOSIX__UserName_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__UserName_USCOREType)
			return (jsdlPOSIX__UserName_USCOREType *)a->soap_in(soap, tag, type);
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__UserName_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_std__string(soap, tag, &(((jsdlPOSIX__UserName_USCOREType*)a)->__item), "jsdlPOSIX:UserName_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__UserName_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__UserName_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__UserName_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__UserName_USCOREType(struct soap *soap, jsdlPOSIX__UserName_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__UserName_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__UserName_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__UserName_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__UserName_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__UserName_USCOREType);
		((jsdlPOSIX__UserName_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__UserName_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__UserName_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__UserName_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__UserName_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__UserName_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__UserName_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__UserName_USCOREType*)p = *(jsdlPOSIX__UserName_USCOREType*)q;
}

void jsdlPOSIX__Limits_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

void jsdlPOSIX__Limits_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_unsignedInt(soap, &((jsdlPOSIX__Limits_USCOREType*)this)->__item);
	((jsdlPOSIX__Limits_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__Limits_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__Limits_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__Limits_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__Limits_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__Limits_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__Limits_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__Limits_USCOREType *)a)->__anyAttribute);
	return soap_out_unsignedInt(soap, tag, id, &(((jsdlPOSIX__Limits_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__Limits_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__Limits_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__Limits_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__Limits_USCOREType(struct soap *soap, jsdlPOSIX__Limits_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__Limits_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__Limits_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__Limits_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__Limits_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__Limits_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Limits_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__Limits_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType, sizeof(jsdlPOSIX__Limits_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__Limits_USCOREType)
			return (jsdlPOSIX__Limits_USCOREType *)a->soap_in(soap, tag, type);
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__Limits_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_unsignedInt(soap, tag, &(((jsdlPOSIX__Limits_USCOREType*)a)->__item), "jsdlPOSIX:Limits_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__Limits_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__Limits_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__Limits_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__Limits_USCOREType(struct soap *soap, jsdlPOSIX__Limits_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__Limits_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__Limits_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__Limits_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__Limits_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__Limits_USCOREType);
		((jsdlPOSIX__Limits_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__Limits_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__Limits_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__Limits_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__Limits_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__Limits_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__Limits_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__Limits_USCOREType*)p = *(jsdlPOSIX__Limits_USCOREType*)q;
}

void jsdlPOSIX__DirectoryName_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlPOSIX__DirectoryName_USCOREType*)this)->__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlPOSIX__DirectoryName_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__DirectoryName_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlPOSIX__DirectoryName_USCOREType*)this)->__item);
	((jsdlPOSIX__DirectoryName_USCOREType*)this)->filesystemName = NULL;
	((jsdlPOSIX__DirectoryName_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__DirectoryName_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__DirectoryName_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__DirectoryName_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__DirectoryName_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__DirectoryName_USCOREType *)a)->filesystemName)
		soap_set_attr(soap, "filesystemName", ((jsdlPOSIX__DirectoryName_USCOREType *)a)->filesystemName->c_str());
	if (((jsdlPOSIX__DirectoryName_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__DirectoryName_USCOREType *)a)->__anyAttribute);
	return soap_out_std__string(soap, tag, id, &(((jsdlPOSIX__DirectoryName_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__DirectoryName_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__DirectoryName_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__DirectoryName_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, jsdlPOSIX__DirectoryName_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__DirectoryName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__DirectoryName_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__DirectoryName_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__DirectoryName_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__DirectoryName_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__DirectoryName_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType, sizeof(jsdlPOSIX__DirectoryName_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType)
			return (jsdlPOSIX__DirectoryName_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "filesystemName", 0);
		if (t)
		{	if (!(((jsdlPOSIX__DirectoryName_USCOREType *)a)->filesystemName = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdlPOSIX__DirectoryName_USCOREType *)a)->filesystemName = soap_new_std__string(soap, -1);
			((jsdlPOSIX__DirectoryName_USCOREType *)a)->filesystemName->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__DirectoryName_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_std__string(soap, tag, &(((jsdlPOSIX__DirectoryName_USCOREType*)a)->__item), "jsdlPOSIX:DirectoryName_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__DirectoryName_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__DirectoryName_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, jsdlPOSIX__DirectoryName_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__DirectoryName_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__DirectoryName_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__DirectoryName_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__DirectoryName_USCOREType);
		((jsdlPOSIX__DirectoryName_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__DirectoryName_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__DirectoryName_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__DirectoryName_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__DirectoryName_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__DirectoryName_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__DirectoryName_USCOREType*)p = *(jsdlPOSIX__DirectoryName_USCOREType*)q;
}

void jsdlPOSIX__FileName_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlPOSIX__FileName_USCOREType*)this)->__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlPOSIX__FileName_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__FileName_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlPOSIX__FileName_USCOREType*)this)->__item);
	((jsdlPOSIX__FileName_USCOREType*)this)->filesystemName = NULL;
	((jsdlPOSIX__FileName_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__FileName_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__FileName_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__FileName_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__FileName_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__FileName_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__FileName_USCOREType *)a)->filesystemName)
		soap_set_attr(soap, "filesystemName", ((jsdlPOSIX__FileName_USCOREType *)a)->filesystemName->c_str());
	if (((jsdlPOSIX__FileName_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__FileName_USCOREType *)a)->__anyAttribute);
	return soap_out_std__string(soap, tag, id, &(((jsdlPOSIX__FileName_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__FileName_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__FileName_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__FileName_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__FileName_USCOREType(struct soap *soap, jsdlPOSIX__FileName_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__FileName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__FileName_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__FileName_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__FileName_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__FileName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__FileName_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__FileName_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType, sizeof(jsdlPOSIX__FileName_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__FileName_USCOREType)
			return (jsdlPOSIX__FileName_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "filesystemName", 0);
		if (t)
		{	if (!(((jsdlPOSIX__FileName_USCOREType *)a)->filesystemName = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdlPOSIX__FileName_USCOREType *)a)->filesystemName = soap_new_std__string(soap, -1);
			((jsdlPOSIX__FileName_USCOREType *)a)->filesystemName->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__FileName_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_std__string(soap, tag, &(((jsdlPOSIX__FileName_USCOREType*)a)->__item), "jsdlPOSIX:FileName_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__FileName_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__FileName_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__FileName_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__FileName_USCOREType(struct soap *soap, jsdlPOSIX__FileName_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__FileName_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__FileName_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__FileName_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__FileName_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__FileName_USCOREType);
		((jsdlPOSIX__FileName_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__FileName_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__FileName_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__FileName_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__FileName_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__FileName_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__FileName_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__FileName_USCOREType*)p = *(jsdlPOSIX__FileName_USCOREType*)q;
}

void jsdlPOSIX__Argument_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__normalizedString(soap, &((jsdlPOSIX__Argument_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__Argument_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__normalizedString(soap, &((jsdlPOSIX__Argument_USCOREType*)this)->__item);
	((jsdlPOSIX__Argument_USCOREType*)this)->filesystemName = NULL;
	((jsdlPOSIX__Argument_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__Argument_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__Argument_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__Argument_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__Argument_USCOREType *a, const char *type)
{
	if (((jsdlPOSIX__Argument_USCOREType *)a)->filesystemName)
		soap_set_attr(soap, "filesystemName", ((jsdlPOSIX__Argument_USCOREType *)a)->filesystemName->c_str());
	if (((jsdlPOSIX__Argument_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__Argument_USCOREType *)a)->__anyAttribute);
	return soap_out_xsd__normalizedString(soap, tag, id, &(((jsdlPOSIX__Argument_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__Argument_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__Argument_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__Argument_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__Argument_USCOREType(struct soap *soap, jsdlPOSIX__Argument_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__Argument_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__Argument_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__Argument_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__Argument_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Argument_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__Argument_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType, sizeof(jsdlPOSIX__Argument_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__Argument_USCOREType)
			return (jsdlPOSIX__Argument_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "filesystemName", 0);
		if (t)
		{	if (!(((jsdlPOSIX__Argument_USCOREType *)a)->filesystemName = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdlPOSIX__Argument_USCOREType *)a)->filesystemName = soap_new_std__string(soap, -1);
			((jsdlPOSIX__Argument_USCOREType *)a)->filesystemName->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__Argument_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_xsd__normalizedString(soap, tag, &(((jsdlPOSIX__Argument_USCOREType*)a)->__item), "jsdlPOSIX:Argument_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__Argument_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__Argument_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__Argument_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__Argument_USCOREType(struct soap *soap, jsdlPOSIX__Argument_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__Argument_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__Argument_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__Argument_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__Argument_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__Argument_USCOREType);
		((jsdlPOSIX__Argument_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__Argument_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__Argument_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__Argument_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__Argument_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__Argument_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__Argument_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__Argument_USCOREType*)p = *(jsdlPOSIX__Argument_USCOREType*)q;
}

void jsdlPOSIX__Environment_USCOREType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_embedded(soap, &((jsdlPOSIX__Environment_USCOREType*)this)->__item, SOAP_TYPE_std__string);
	soap_serialize_std__string(soap, &((jsdlPOSIX__Environment_USCOREType*)this)->__item);
	/* transient soap skipped */
}

void jsdlPOSIX__Environment_USCOREType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_std__string(soap, &((jsdlPOSIX__Environment_USCOREType*)this)->__item);
	soap_default_xsd__NCName(soap, &((jsdlPOSIX__Environment_USCOREType*)this)->name);
	((jsdlPOSIX__Environment_USCOREType*)this)->filesystemName = NULL;
	((jsdlPOSIX__Environment_USCOREType*)this)->__anyAttribute = NULL;
	/* transient soap skipped */
}

int jsdlPOSIX__Environment_USCOREType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int jsdlPOSIX__Environment_USCOREType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_jsdlPOSIX__Environment_USCOREType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_jsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, int id, const jsdlPOSIX__Environment_USCOREType *a, const char *type)
{
	if (!((jsdlPOSIX__Environment_USCOREType *)a)->name.empty())
		soap_set_attr(soap, "name", ((jsdlPOSIX__Environment_USCOREType *)a)->name.c_str());
	if (((jsdlPOSIX__Environment_USCOREType *)a)->filesystemName)
		soap_set_attr(soap, "filesystemName", ((jsdlPOSIX__Environment_USCOREType *)a)->filesystemName->c_str());
	if (((jsdlPOSIX__Environment_USCOREType *)a)->__anyAttribute)
		soap_set_attr(soap, "-anyAttribute", ((jsdlPOSIX__Environment_USCOREType *)a)->__anyAttribute);
	return soap_out_std__string(soap, tag, id, &(((jsdlPOSIX__Environment_USCOREType*)a)->__item), "");
}

void *jsdlPOSIX__Environment_USCOREType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_jsdlPOSIX__Environment_USCOREType(soap, this, tag, type);
}

SOAP_FMAC3 jsdlPOSIX__Environment_USCOREType * SOAP_FMAC4 soap_get_jsdlPOSIX__Environment_USCOREType(struct soap *soap, jsdlPOSIX__Environment_USCOREType *p, const char *tag, const char *type)
{
	if ((p = soap_in_jsdlPOSIX__Environment_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *jsdlPOSIX__Environment_USCOREType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_jsdlPOSIX__Environment_USCOREType(soap, tag, this, type);
}

SOAP_FMAC3 jsdlPOSIX__Environment_USCOREType * SOAP_FMAC4 soap_in_jsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Environment_USCOREType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!(a = (jsdlPOSIX__Environment_USCOREType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType, sizeof(jsdlPOSIX__Environment_USCOREType), soap->type, soap->arrayType)))
	{	soap->error = SOAP_TAG_MISMATCH;
		return NULL;
	}
	soap_revert(soap);
	*soap->id = '\0';
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_jsdlPOSIX__Environment_USCOREType)
			return (jsdlPOSIX__Environment_USCOREType *)a->soap_in(soap, tag, type);
	}
	{	const char *t = soap_attr_value(soap, "name", 1);
		if (t)
		{	char *s;
			if (soap_s2string(soap, t, &s))
				return NULL;
			((jsdlPOSIX__Environment_USCOREType *)a)->name.assign(s);
		}
	}
	{	const char *t = soap_attr_value(soap, "filesystemName", 0);
		if (t)
		{	if (!(((jsdlPOSIX__Environment_USCOREType *)a)->filesystemName = (std::string *)soap_malloc(soap, sizeof(std::string))))
			{	soap->error = SOAP_EOM;
				return NULL;
			}
	char *s;
		if (soap_s2string(soap, t, &s))
			return NULL;
		if (s)
		{	((jsdlPOSIX__Environment_USCOREType *)a)->filesystemName = soap_new_std__string(soap, -1);
			((jsdlPOSIX__Environment_USCOREType *)a)->filesystemName->assign(s);
		}
		}
	}
	if (soap_s2string(soap, soap_attr_value(soap, "-anyAttribute", 0), &((jsdlPOSIX__Environment_USCOREType *)a)->__anyAttribute))
		return NULL;
	if (!soap_in_std__string(soap, tag, &(((jsdlPOSIX__Environment_USCOREType*)a)->__item), "jsdlPOSIX:Environment_Type"))
		return NULL;
	return a;
}

SOAP_FMAC5 jsdlPOSIX__Environment_USCOREType * SOAP_FMAC6 soap_new_jsdlPOSIX__Environment_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_jsdlPOSIX__Environment_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_jsdlPOSIX__Environment_USCOREType(struct soap *soap, jsdlPOSIX__Environment_USCOREType *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 jsdlPOSIX__Environment_USCOREType * SOAP_FMAC4 soap_instantiate_jsdlPOSIX__Environment_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_jsdlPOSIX__Environment_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new jsdlPOSIX__Environment_USCOREType;
		if (size)
			*size = sizeof(jsdlPOSIX__Environment_USCOREType);
		((jsdlPOSIX__Environment_USCOREType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new jsdlPOSIX__Environment_USCOREType[n];
		if (size)
			*size = n * sizeof(jsdlPOSIX__Environment_USCOREType);
		for (int i = 0; i < n; i++)
			((jsdlPOSIX__Environment_USCOREType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (jsdlPOSIX__Environment_USCOREType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_jsdlPOSIX__Environment_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying jsdlPOSIX__Environment_USCOREType %p -> %p\n", q, p));
	*(jsdlPOSIX__Environment_USCOREType*)p = *(jsdlPOSIX__Environment_USCOREType*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__normalizedString(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__normalizedString(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__normalizedString(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__normalizedString);
	if (soap_out_xsd__normalizedString(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__normalizedString(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__normalizedString), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__normalizedString(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__normalizedString(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__normalizedString(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__normalizedString, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__normalizedString, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__normalizedString, 0, sizeof(std::string), 0, soap_copy_xsd__normalizedString);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_xsd__normalizedString(struct soap *soap, int n)
{	return soap_instantiate_xsd__normalizedString(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__normalizedString(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_xsd__normalizedString(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__normalizedString(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__normalizedString, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__normalizedString(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__anyURI(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__anyURI(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__anyURI(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__anyURI);
	if (soap_out_xsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__anyURI(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__anyURI), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__anyURI(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__anyURI(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__anyURI, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__anyURI, 0, sizeof(std::string), 0, soap_copy_xsd__anyURI);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_xsd__anyURI(struct soap *soap, int n)
{	return soap_instantiate_xsd__anyURI(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__anyURI(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_xsd__anyURI(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__anyURI(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__anyURI, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__anyURI(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__NCName(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__NCName(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__NCName(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__NCName);
	if (soap_out_xsd__NCName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__NCName(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__NCName), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__NCName(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__NCName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__NCName(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__NCName, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__NCName, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__NCName, 0, sizeof(std::string), 0, soap_copy_xsd__NCName);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_xsd__NCName(struct soap *soap, int n)
{	return soap_instantiate_xsd__NCName(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__NCName(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_xsd__NCName(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__NCName(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__NCName, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__NCName(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__ID(struct soap *soap, std::string const*a)
{	soap_serialize_std__string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__ID(struct soap *soap, std::string *a)
{	soap_default_std__string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__ID(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__ID);
	if (soap_out_xsd__ID(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__ID(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_xsd__ID), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_xsd__ID(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__ID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_xsd__ID(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__ID, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_xsd__ID, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_xsd__ID, 0, sizeof(std::string), 0, soap_copy_xsd__ID);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_xsd__ID(struct soap *soap, int n)
{	return soap_instantiate_xsd__ID(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__ID(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_xsd__ID(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__ID(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__ID, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__ID(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *p)
{	(void)soap; (void)p; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
			if ((t = soap_string_in(soap, 1, -1, -1)))
				s->assign(t);
			else
				return NULL;
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC5 std::string * SOAP_FMAC6 soap_new_std__string(struct soap *soap, int n)
{	return soap_instantiate_std__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__string(struct soap *soap, std::string *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::string;
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)new std::string[n];
		if (size)
			*size = n * sizeof(std::string);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	/* transient dummy skipped */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_double);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTodouble);
	if (soap_out_PointerTodouble(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__anyURI(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xsd__anyURI))
		soap_serialize_xsd__anyURI(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__anyURI(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__anyURI);
	if (soap_out_PointerToxsd__anyURI(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__anyURI(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__anyURI);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__anyURI(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerToxsd__anyURI(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__anyURI(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerToxsd__anyURI(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__anyURI(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__anyURI, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__FileParameters_USCOREType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__FileParameters_USCOREType))
		soap_serialize_jsdlARC__FileParameters_USCOREType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__FileParameters_USCOREType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__FileParameters_USCOREType);
	if (soap_out_PointerTojsdlARC__FileParameters_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__FileParameters_USCOREType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__FileParameters_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__FileParameters_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTojsdlARC__FileParameters_USCOREType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__FileParameters_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTojsdlARC__FileParameters_USCOREType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__FileParameters_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__FileParameters_USCOREType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__IsExecutable_USCOREType(struct soap *soap, bool *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__IsExecutable_USCOREType(struct soap *soap, bool *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__IsExecutable_USCOREType);
	if (soap_out_PointerTojsdlARC__IsExecutable_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__IsExecutable_USCOREType(struct soap *soap, const char *tag, int id, bool *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__IsExecutable_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_get_PointerTojsdlARC__IsExecutable_USCOREType(struct soap *soap, bool **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__IsExecutable_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_in_PointerTojsdlARC__IsExecutable_USCOREType(struct soap *soap, const char *tag, bool **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (bool **)soap_malloc(soap, sizeof(bool *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__IsExecutable_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (bool **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__IsExecutable_USCOREType, sizeof(bool), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__SourceTarget_USCOREType(struct soap *soap, jsdl__SourceTarget_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__SourceTarget_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__SourceTarget_USCOREType(struct soap *soap, jsdl__SourceTarget_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__SourceTarget_USCOREType);
	if (soap_out_PointerTojsdl__SourceTarget_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__SourceTarget_USCOREType(struct soap *soap, const char *tag, int id, jsdl__SourceTarget_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__SourceTarget_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__SourceTarget_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__SourceTarget_USCOREType(struct soap *soap, jsdl__SourceTarget_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__SourceTarget_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__SourceTarget_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__SourceTarget_USCOREType(struct soap *soap, const char *tag, jsdl__SourceTarget_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__SourceTarget_USCOREType **)soap_malloc(soap, sizeof(jsdl__SourceTarget_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__SourceTarget_USCOREType *)soap_instantiate_jsdl__SourceTarget_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__SourceTarget_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__SourceTarget_USCOREType, sizeof(jsdl__SourceTarget_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__OperatingSystemType_USCOREType(struct soap *soap, jsdl__OperatingSystemType_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__OperatingSystemType_USCOREType(struct soap *soap, jsdl__OperatingSystemType_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__OperatingSystemType_USCOREType);
	if (soap_out_PointerTojsdl__OperatingSystemType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__OperatingSystemType_USCOREType(struct soap *soap, const char *tag, int id, jsdl__OperatingSystemType_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__OperatingSystemType_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__OperatingSystemType_USCOREType(struct soap *soap, jsdl__OperatingSystemType_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__OperatingSystemType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__OperatingSystemType_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__OperatingSystemType_USCOREType(struct soap *soap, const char *tag, jsdl__OperatingSystemType_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__OperatingSystemType_USCOREType **)soap_malloc(soap, sizeof(jsdl__OperatingSystemType_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__OperatingSystemType_USCOREType *)soap_instantiate_jsdl__OperatingSystemType_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__OperatingSystemType_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__OperatingSystemType_USCOREType, sizeof(jsdl__OperatingSystemType_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__FileSystemTypeEnumeration(struct soap *soap, enum jsdl__FileSystemTypeEnumeration *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdl__FileSystemTypeEnumeration);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__FileSystemTypeEnumeration(struct soap *soap, enum jsdl__FileSystemTypeEnumeration *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__FileSystemTypeEnumeration);
	if (soap_out_PointerTojsdl__FileSystemTypeEnumeration(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__FileSystemTypeEnumeration(struct soap *soap, const char *tag, int id, enum jsdl__FileSystemTypeEnumeration *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__FileSystemTypeEnumeration);
	if (id < 0)
		return soap->error;
	return soap_out_jsdl__FileSystemTypeEnumeration(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum jsdl__FileSystemTypeEnumeration ** SOAP_FMAC4 soap_get_PointerTojsdl__FileSystemTypeEnumeration(struct soap *soap, enum jsdl__FileSystemTypeEnumeration **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__FileSystemTypeEnumeration(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum jsdl__FileSystemTypeEnumeration ** SOAP_FMAC4 soap_in_PointerTojsdl__FileSystemTypeEnumeration(struct soap *soap, const char *tag, enum jsdl__FileSystemTypeEnumeration **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum jsdl__FileSystemTypeEnumeration **)soap_malloc(soap, sizeof(enum jsdl__FileSystemTypeEnumeration *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdl__FileSystemTypeEnumeration(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum jsdl__FileSystemTypeEnumeration **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__FileSystemTypeEnumeration, sizeof(enum jsdl__FileSystemTypeEnumeration), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, jsdlARC__RunTimeEnvironment_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, jsdlARC__RunTimeEnvironment_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__RunTimeEnvironment_USCOREType);
	if (soap_out_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__RunTimeEnvironment_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__RunTimeEnvironment_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, jsdlARC__RunTimeEnvironment_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__RunTimeEnvironment_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, jsdlARC__RunTimeEnvironment_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__RunTimeEnvironment_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__RunTimeEnvironment_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__RunTimeEnvironment_USCOREType *)soap_instantiate_jsdlARC__RunTimeEnvironment_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__RunTimeEnvironment_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType, sizeof(jsdlARC__RunTimeEnvironment_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__Middleware_USCOREType(struct soap *soap, jsdlARC__Middleware_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__Middleware_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__Middleware_USCOREType(struct soap *soap, jsdlARC__Middleware_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__Middleware_USCOREType);
	if (soap_out_PointerTojsdlARC__Middleware_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__Middleware_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__Middleware_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__Middleware_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__Middleware_USCOREType(struct soap *soap, jsdlARC__Middleware_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__Middleware_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__Middleware_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, jsdlARC__Middleware_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__Middleware_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__Middleware_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__Middleware_USCOREType *)soap_instantiate_jsdlARC__Middleware_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__Middleware_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__Middleware_USCOREType, sizeof(jsdlARC__Middleware_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__CandidateTarget_USCOREType(struct soap *soap, jsdlARC__CandidateTarget_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__CandidateTarget_USCOREType(struct soap *soap, jsdlARC__CandidateTarget_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__CandidateTarget_USCOREType);
	if (soap_out_PointerTojsdlARC__CandidateTarget_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__CandidateTarget_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__CandidateTarget_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__CandidateTarget_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__CandidateTarget_USCOREType(struct soap *soap, jsdlARC__CandidateTarget_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__CandidateTarget_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__CandidateTarget_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__CandidateTarget_USCOREType(struct soap *soap, const char *tag, jsdlARC__CandidateTarget_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__CandidateTarget_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__CandidateTarget_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__CandidateTarget_USCOREType *)soap_instantiate_jsdlARC__CandidateTarget_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__CandidateTarget_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__CandidateTarget_USCOREType, sizeof(jsdlARC__CandidateTarget_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__GridTimeLimit_USCOREType(struct soap *soap, unsigned int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__GridTimeLimit_USCOREType(struct soap *soap, unsigned int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__GridTimeLimit_USCOREType);
	if (soap_out_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__GridTimeLimit_USCOREType(struct soap *soap, const char *tag, int id, unsigned int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__GridTimeLimit_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_get_PointerTojsdlARC__GridTimeLimit_USCOREType(struct soap *soap, unsigned int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__GridTimeLimit_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 unsigned int ** SOAP_FMAC4 soap_in_PointerTojsdlARC__GridTimeLimit_USCOREType(struct soap *soap, const char *tag, unsigned int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (unsigned int **)soap_malloc(soap, sizeof(unsigned int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__GridTimeLimit_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__GridTimeLimit_USCOREType, sizeof(unsigned int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__SessionType_USCOREType(struct soap *soap, enum jsdlARC__SessionType_USCOREType *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__SessionType_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__SessionType_USCOREType(struct soap *soap, enum jsdlARC__SessionType_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__SessionType_USCOREType);
	if (soap_out_PointerTojsdlARC__SessionType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__SessionType_USCOREType(struct soap *soap, const char *tag, int id, enum jsdlARC__SessionType_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__SessionType_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__SessionType_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum jsdlARC__SessionType_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__SessionType_USCOREType(struct soap *soap, enum jsdlARC__SessionType_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__SessionType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum jsdlARC__SessionType_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__SessionType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__SessionType_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum jsdlARC__SessionType_USCOREType **)soap_malloc(soap, sizeof(enum jsdlARC__SessionType_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__SessionType_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__SessionType_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__SessionType_USCOREType, sizeof(enum jsdlARC__SessionType_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__SessionLifeTime_USCOREType(struct soap *soap, LONG64 *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__SessionLifeTime_USCOREType(struct soap *soap, LONG64 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__SessionLifeTime_USCOREType);
	if (soap_out_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__SessionLifeTime_USCOREType(struct soap *soap, const char *tag, int id, LONG64 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__SessionLifeTime_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_get_PointerTojsdlARC__SessionLifeTime_USCOREType(struct soap *soap, LONG64 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__SessionLifeTime_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 LONG64 ** SOAP_FMAC4 soap_in_PointerTojsdlARC__SessionLifeTime_USCOREType(struct soap *soap, const char *tag, LONG64 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (LONG64 **)soap_malloc(soap, sizeof(LONG64 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__SessionLifeTime_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (LONG64 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__SessionLifeTime_USCOREType, sizeof(LONG64), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__RangeValue_USCOREType(struct soap *soap, jsdl__RangeValue_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__RangeValue_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__RangeValue_USCOREType(struct soap *soap, jsdl__RangeValue_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__RangeValue_USCOREType);
	if (soap_out_PointerTojsdl__RangeValue_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__RangeValue_USCOREType(struct soap *soap, const char *tag, int id, jsdl__RangeValue_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__RangeValue_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__RangeValue_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__RangeValue_USCOREType(struct soap *soap, jsdl__RangeValue_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__RangeValue_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__RangeValue_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__RangeValue_USCOREType(struct soap *soap, const char *tag, jsdl__RangeValue_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__RangeValue_USCOREType **)soap_malloc(soap, sizeof(jsdl__RangeValue_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__RangeValue_USCOREType *)soap_instantiate_jsdl__RangeValue_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__RangeValue_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__RangeValue_USCOREType, sizeof(jsdl__RangeValue_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__CPUArchitecture_USCOREType(struct soap *soap, jsdl__CPUArchitecture_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__CPUArchitecture_USCOREType(struct soap *soap, jsdl__CPUArchitecture_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__CPUArchitecture_USCOREType);
	if (soap_out_PointerTojsdl__CPUArchitecture_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__CPUArchitecture_USCOREType(struct soap *soap, const char *tag, int id, jsdl__CPUArchitecture_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__CPUArchitecture_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__CPUArchitecture_USCOREType(struct soap *soap, jsdl__CPUArchitecture_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__CPUArchitecture_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__CPUArchitecture_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__CPUArchitecture_USCOREType(struct soap *soap, const char *tag, jsdl__CPUArchitecture_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__CPUArchitecture_USCOREType **)soap_malloc(soap, sizeof(jsdl__CPUArchitecture_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__CPUArchitecture_USCOREType *)soap_instantiate_jsdl__CPUArchitecture_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__CPUArchitecture_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__CPUArchitecture_USCOREType, sizeof(jsdl__CPUArchitecture_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__OperatingSystem_USCOREType(struct soap *soap, jsdl__OperatingSystem_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__OperatingSystem_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__OperatingSystem_USCOREType(struct soap *soap, jsdl__OperatingSystem_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__OperatingSystem_USCOREType);
	if (soap_out_PointerTojsdl__OperatingSystem_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__OperatingSystem_USCOREType(struct soap *soap, const char *tag, int id, jsdl__OperatingSystem_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__OperatingSystem_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__OperatingSystem_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__OperatingSystem_USCOREType(struct soap *soap, jsdl__OperatingSystem_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__OperatingSystem_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__OperatingSystem_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__OperatingSystem_USCOREType(struct soap *soap, const char *tag, jsdl__OperatingSystem_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__OperatingSystem_USCOREType **)soap_malloc(soap, sizeof(jsdl__OperatingSystem_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__OperatingSystem_USCOREType *)soap_instantiate_jsdl__OperatingSystem_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__OperatingSystem_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__OperatingSystem_USCOREType, sizeof(jsdl__OperatingSystem_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__FileSystem_USCOREType(struct soap *soap, jsdl__FileSystem_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__FileSystem_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__FileSystem_USCOREType(struct soap *soap, jsdl__FileSystem_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__FileSystem_USCOREType);
	if (soap_out_PointerTojsdl__FileSystem_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, int id, jsdl__FileSystem_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__FileSystem_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__FileSystem_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__FileSystem_USCOREType(struct soap *soap, jsdl__FileSystem_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__FileSystem_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__FileSystem_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, jsdl__FileSystem_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__FileSystem_USCOREType **)soap_malloc(soap, sizeof(jsdl__FileSystem_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__FileSystem_USCOREType *)soap_instantiate_jsdl__FileSystem_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__FileSystem_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__FileSystem_USCOREType, sizeof(jsdl__FileSystem_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__CandidateHosts_USCOREType(struct soap *soap, jsdl__CandidateHosts_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__CandidateHosts_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__CandidateHosts_USCOREType(struct soap *soap, jsdl__CandidateHosts_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__CandidateHosts_USCOREType);
	if (soap_out_PointerTojsdl__CandidateHosts_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__CandidateHosts_USCOREType(struct soap *soap, const char *tag, int id, jsdl__CandidateHosts_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__CandidateHosts_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__CandidateHosts_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__CandidateHosts_USCOREType(struct soap *soap, jsdl__CandidateHosts_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__CandidateHosts_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__CandidateHosts_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__CandidateHosts_USCOREType(struct soap *soap, const char *tag, jsdl__CandidateHosts_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__CandidateHosts_USCOREType **)soap_malloc(soap, sizeof(jsdl__CandidateHosts_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__CandidateHosts_USCOREType *)soap_instantiate_jsdl__CandidateHosts_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__CandidateHosts_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__CandidateHosts_USCOREType, sizeof(jsdl__CandidateHosts_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, jsdlPOSIX__POSIXApplication_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, jsdlPOSIX__POSIXApplication_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__POSIXApplication_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__POSIXApplication_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__POSIXApplication_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, jsdlPOSIX__POSIXApplication_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__POSIXApplication_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__POSIXApplication_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__POSIXApplication_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__POSIXApplication_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__POSIXApplication_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__POSIXApplication_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__POSIXApplication_USCOREType *)soap_instantiate_jsdlPOSIX__POSIXApplication_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__POSIXApplication_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__POSIXApplication_USCOREType, sizeof(jsdlPOSIX__POSIXApplication_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Description_USCOREType(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Description_USCOREType))
		soap_serialize_jsdl__Description_USCOREType(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Description_USCOREType(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Description_USCOREType);
	if (soap_out_PointerTojsdl__Description_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Description_USCOREType(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Description_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdl__Description_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTojsdl__Description_USCOREType(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Description_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTojsdl__Description_USCOREType(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdl__Description_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Description_USCOREType, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__Time_USCOREType(struct soap *soap, time_t *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__Time_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__Time_USCOREType(struct soap *soap, time_t *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__Time_USCOREType);
	if (soap_out_PointerTojsdlARC__Time_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__Time_USCOREType(struct soap *soap, const char *tag, int id, time_t *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__Time_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__Time_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_get_PointerTojsdlARC__Time_USCOREType(struct soap *soap, time_t **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__Time_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t ** SOAP_FMAC4 soap_in_PointerTojsdlARC__Time_USCOREType(struct soap *soap, const char *tag, time_t **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (time_t **)soap_malloc(soap, sizeof(time_t *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__Time_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (time_t **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__Time_USCOREType, sizeof(time_t), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__Reruns_USCOREType(struct soap *soap, int *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__Reruns_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__Reruns_USCOREType(struct soap *soap, int *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__Reruns_USCOREType);
	if (soap_out_PointerTojsdlARC__Reruns_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__Reruns_USCOREType(struct soap *soap, const char *tag, int id, int *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__Reruns_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__Reruns_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_get_PointerTojsdlARC__Reruns_USCOREType(struct soap *soap, int **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__Reruns_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int ** SOAP_FMAC4 soap_in_PointerTojsdlARC__Reruns_USCOREType(struct soap *soap, const char *tag, int **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (int **)soap_malloc(soap, sizeof(int *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__Reruns_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (int **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__Reruns_USCOREType, sizeof(int), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__CredentialServer_USCOREType(struct soap *soap, jsdlARC__CredentialServer_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__CredentialServer_USCOREType(struct soap *soap, jsdlARC__CredentialServer_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__CredentialServer_USCOREType);
	if (soap_out_PointerTojsdlARC__CredentialServer_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__CredentialServer_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__CredentialServer_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__CredentialServer_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__CredentialServer_USCOREType(struct soap *soap, jsdlARC__CredentialServer_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__CredentialServer_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__CredentialServer_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__CredentialServer_USCOREType(struct soap *soap, const char *tag, jsdlARC__CredentialServer_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__CredentialServer_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__CredentialServer_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__CredentialServer_USCOREType *)soap_instantiate_jsdlARC__CredentialServer_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__CredentialServer_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__CredentialServer_USCOREType, sizeof(jsdlARC__CredentialServer_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, jsdlARC__RemoteLogging_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, jsdlARC__RemoteLogging_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__RemoteLogging_USCOREType);
	if (soap_out_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__RemoteLogging_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__RemoteLogging_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, jsdlARC__RemoteLogging_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__RemoteLogging_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, jsdlARC__RemoteLogging_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__RemoteLogging_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__RemoteLogging_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__RemoteLogging_USCOREType *)soap_instantiate_jsdlARC__RemoteLogging_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__RemoteLogging_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType, sizeof(jsdlARC__RemoteLogging_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__LocalLogging_USCOREType(struct soap *soap, jsdlARC__LocalLogging_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__LocalLogging_USCOREType(struct soap *soap, jsdlARC__LocalLogging_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__LocalLogging_USCOREType);
	if (soap_out_PointerTojsdlARC__LocalLogging_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__LocalLogging_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__LocalLogging_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__LocalLogging_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__LocalLogging_USCOREType(struct soap *soap, jsdlARC__LocalLogging_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__LocalLogging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__LocalLogging_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__LocalLogging_USCOREType(struct soap *soap, const char *tag, jsdlARC__LocalLogging_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__LocalLogging_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__LocalLogging_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__LocalLogging_USCOREType *)soap_instantiate_jsdlARC__LocalLogging_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__LocalLogging_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__LocalLogging_USCOREType, sizeof(jsdlARC__LocalLogging_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__AccessControl_USCOREType(struct soap *soap, jsdlARC__AccessControl_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__AccessControl_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__AccessControl_USCOREType(struct soap *soap, jsdlARC__AccessControl_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__AccessControl_USCOREType);
	if (soap_out_PointerTojsdlARC__AccessControl_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__AccessControl_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__AccessControl_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__AccessControl_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__AccessControl_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__AccessControl_USCOREType(struct soap *soap, jsdlARC__AccessControl_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__AccessControl_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__AccessControl_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__AccessControl_USCOREType(struct soap *soap, const char *tag, jsdlARC__AccessControl_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__AccessControl_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__AccessControl_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__AccessControl_USCOREType *)soap_instantiate_jsdlARC__AccessControl_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__AccessControl_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__AccessControl_USCOREType, sizeof(jsdlARC__AccessControl_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__Notify_USCOREType(struct soap *soap, jsdlARC__Notify_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__Notify_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__Notify_USCOREType(struct soap *soap, jsdlARC__Notify_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__Notify_USCOREType);
	if (soap_out_PointerTojsdlARC__Notify_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__Notify_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__Notify_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__Notify_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__Notify_USCOREType(struct soap *soap, jsdlARC__Notify_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__Notify_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__Notify_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, jsdlARC__Notify_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__Notify_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__Notify_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__Notify_USCOREType *)soap_instantiate_jsdlARC__Notify_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__Notify_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__Notify_USCOREType, sizeof(jsdlARC__Notify_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__DataStaging_USCOREType(struct soap *soap, jsdl__DataStaging_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__DataStaging_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__DataStaging_USCOREType(struct soap *soap, jsdl__DataStaging_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__DataStaging_USCOREType);
	if (soap_out_PointerTojsdl__DataStaging_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, int id, jsdl__DataStaging_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__DataStaging_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__DataStaging_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__DataStaging_USCOREType(struct soap *soap, jsdl__DataStaging_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__DataStaging_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__DataStaging_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, jsdl__DataStaging_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__DataStaging_USCOREType **)soap_malloc(soap, sizeof(jsdl__DataStaging_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__DataStaging_USCOREType *)soap_instantiate_jsdl__DataStaging_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__DataStaging_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__DataStaging_USCOREType, sizeof(jsdl__DataStaging_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Resources_USCOREType(struct soap *soap, jsdl__Resources_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Resources_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Resources_USCOREType(struct soap *soap, jsdl__Resources_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Resources_USCOREType);
	if (soap_out_PointerTojsdl__Resources_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Resources_USCOREType(struct soap *soap, const char *tag, int id, jsdl__Resources_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Resources_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__Resources_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__Resources_USCOREType(struct soap *soap, jsdl__Resources_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Resources_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__Resources_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__Resources_USCOREType(struct soap *soap, const char *tag, jsdl__Resources_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__Resources_USCOREType **)soap_malloc(soap, sizeof(jsdl__Resources_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__Resources_USCOREType *)soap_instantiate_jsdl__Resources_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__Resources_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Resources_USCOREType, sizeof(jsdl__Resources_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Application_USCOREType(struct soap *soap, jsdl__Application_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Application_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Application_USCOREType(struct soap *soap, jsdl__Application_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Application_USCOREType);
	if (soap_out_PointerTojsdl__Application_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Application_USCOREType(struct soap *soap, const char *tag, int id, jsdl__Application_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Application_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__Application_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__Application_USCOREType(struct soap *soap, jsdl__Application_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Application_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__Application_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__Application_USCOREType(struct soap *soap, const char *tag, jsdl__Application_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__Application_USCOREType **)soap_malloc(soap, sizeof(jsdl__Application_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__Application_USCOREType *)soap_instantiate_jsdl__Application_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__Application_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Application_USCOREType, sizeof(jsdl__Application_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__JobIdentification_USCOREType(struct soap *soap, jsdl__JobIdentification_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__JobIdentification_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__JobIdentification_USCOREType(struct soap *soap, jsdl__JobIdentification_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__JobIdentification_USCOREType);
	if (soap_out_PointerTojsdl__JobIdentification_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__JobIdentification_USCOREType(struct soap *soap, const char *tag, int id, jsdl__JobIdentification_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__JobIdentification_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__JobIdentification_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__JobIdentification_USCOREType(struct soap *soap, jsdl__JobIdentification_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__JobIdentification_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__JobIdentification_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__JobIdentification_USCOREType(struct soap *soap, const char *tag, jsdl__JobIdentification_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__JobIdentification_USCOREType **)soap_malloc(soap, sizeof(jsdl__JobIdentification_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__JobIdentification_USCOREType *)soap_instantiate_jsdl__JobIdentification_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__JobIdentification_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__JobIdentification_USCOREType, sizeof(jsdl__JobIdentification_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__ID(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xsd__ID))
		soap_serialize_xsd__ID(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__ID(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__ID);
	if (soap_out_PointerToxsd__ID(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__ID(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__ID);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__ID(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerToxsd__ID(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__ID(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerToxsd__ID(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__ID(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__ID, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__JobDescription_USCOREType(struct soap *soap, jsdl__JobDescription_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__JobDescription_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__JobDescription_USCOREType(struct soap *soap, jsdl__JobDescription_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__JobDescription_USCOREType);
	if (soap_out_PointerTojsdl__JobDescription_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, int id, jsdl__JobDescription_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__JobDescription_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__JobDescription_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__JobDescription_USCOREType(struct soap *soap, jsdl__JobDescription_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__JobDescription_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__JobDescription_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, jsdl__JobDescription_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__JobDescription_USCOREType **)soap_malloc(soap, sizeof(jsdl__JobDescription_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__JobDescription_USCOREType *)soap_instantiate_jsdl__JobDescription_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__JobDescription_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__JobDescription_USCOREType, sizeof(jsdl__JobDescription_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Range_USCOREType(struct soap *soap, jsdl__Range_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Range_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Range_USCOREType(struct soap *soap, jsdl__Range_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Range_USCOREType);
	if (soap_out_PointerTojsdl__Range_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Range_USCOREType(struct soap *soap, const char *tag, int id, jsdl__Range_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Range_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__Range_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__Range_USCOREType(struct soap *soap, jsdl__Range_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Range_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__Range_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__Range_USCOREType(struct soap *soap, const char *tag, jsdl__Range_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__Range_USCOREType **)soap_malloc(soap, sizeof(jsdl__Range_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__Range_USCOREType *)soap_instantiate_jsdl__Range_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__Range_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Range_USCOREType, sizeof(jsdl__Range_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Exact_USCOREType(struct soap *soap, jsdl__Exact_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Exact_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Exact_USCOREType(struct soap *soap, jsdl__Exact_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Exact_USCOREType);
	if (soap_out_PointerTojsdl__Exact_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Exact_USCOREType(struct soap *soap, const char *tag, int id, jsdl__Exact_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Exact_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__Exact_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__Exact_USCOREType(struct soap *soap, jsdl__Exact_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Exact_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__Exact_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__Exact_USCOREType(struct soap *soap, const char *tag, jsdl__Exact_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__Exact_USCOREType **)soap_malloc(soap, sizeof(jsdl__Exact_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__Exact_USCOREType *)soap_instantiate_jsdl__Exact_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__Exact_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Exact_USCOREType, sizeof(jsdl__Exact_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdl__Boundary_USCOREType(struct soap *soap, jsdl__Boundary_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdl__Boundary_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdl__Boundary_USCOREType(struct soap *soap, jsdl__Boundary_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdl__Boundary_USCOREType);
	if (soap_out_PointerTojsdl__Boundary_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdl__Boundary_USCOREType(struct soap *soap, const char *tag, int id, jsdl__Boundary_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdl__Boundary_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdl__Boundary_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdl__Boundary_USCOREType(struct soap *soap, jsdl__Boundary_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdl__Boundary_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdl__Boundary_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdl__Boundary_USCOREType(struct soap *soap, const char *tag, jsdl__Boundary_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdl__Boundary_USCOREType **)soap_malloc(soap, sizeof(jsdl__Boundary_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdl__Boundary_USCOREType *)soap_instantiate_jsdl__Boundary_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdl__Boundary_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdl__Boundary_USCOREType, sizeof(jsdl__Boundary_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__NotificationType_USCOREType(struct soap *soap, enum jsdlARC__NotificationType_USCOREType *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__NotificationType_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__NotificationType_USCOREType(struct soap *soap, enum jsdlARC__NotificationType_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__NotificationType_USCOREType);
	if (soap_out_PointerTojsdlARC__NotificationType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__NotificationType_USCOREType(struct soap *soap, const char *tag, int id, enum jsdlARC__NotificationType_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__NotificationType_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__NotificationType_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum jsdlARC__NotificationType_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__NotificationType_USCOREType(struct soap *soap, enum jsdlARC__NotificationType_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__NotificationType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum jsdlARC__NotificationType_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__NotificationType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__NotificationType_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum jsdlARC__NotificationType_USCOREType **)soap_malloc(soap, sizeof(enum jsdlARC__NotificationType_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__NotificationType_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__NotificationType_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__NotificationType_USCOREType, sizeof(enum jsdlARC__NotificationType_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__AccessControlType_USCOREType(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__AccessControlType_USCOREType(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__AccessControlType_USCOREType);
	if (soap_out_PointerTojsdlARC__AccessControlType_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__AccessControlType_USCOREType(struct soap *soap, const char *tag, int id, enum jsdlARC__AccessControlType_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType);
	if (id < 0)
		return soap->error;
	return soap_out_jsdlARC__AccessControlType_USCOREType(soap, tag, id, *a, type);
}

SOAP_FMAC3 enum jsdlARC__AccessControlType_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__AccessControlType_USCOREType(struct soap *soap, enum jsdlARC__AccessControlType_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__AccessControlType_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 enum jsdlARC__AccessControlType_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__AccessControlType_USCOREType(struct soap *soap, const char *tag, enum jsdlARC__AccessControlType_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (enum jsdlARC__AccessControlType_USCOREType **)soap_malloc(soap, sizeof(enum jsdlARC__AccessControlType_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_jsdlARC__AccessControlType_USCOREType(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (enum jsdlARC__AccessControlType_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__AccessControlType_USCOREType, sizeof(enum jsdlARC__AccessControlType_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlARC__Version_USCOREType(struct soap *soap, jsdlARC__Version_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlARC__Version_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlARC__Version_USCOREType(struct soap *soap, jsdlARC__Version_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlARC__Version_USCOREType);
	if (soap_out_PointerTojsdlARC__Version_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlARC__Version_USCOREType(struct soap *soap, const char *tag, int id, jsdlARC__Version_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlARC__Version_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlARC__Version_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlARC__Version_USCOREType(struct soap *soap, jsdlARC__Version_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlARC__Version_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlARC__Version_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlARC__Version_USCOREType(struct soap *soap, const char *tag, jsdlARC__Version_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlARC__Version_USCOREType **)soap_malloc(soap, sizeof(jsdlARC__Version_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlARC__Version_USCOREType *)soap_instantiate_jsdlARC__Version_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlARC__Version_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlARC__Version_USCOREType, sizeof(jsdlARC__Version_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTobool(struct soap *soap, bool *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_bool);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTobool(struct soap *soap, bool *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTobool);
	if (soap_out_PointerTobool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTobool(struct soap *soap, const char *tag, int id, bool *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_bool);
	if (id < 0)
		return soap->error;
	return soap_out_bool(soap, tag, id, *a, type);
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_get_PointerTobool(struct soap *soap, bool **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTobool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 bool ** SOAP_FMAC4 soap_in_PointerTobool(struct soap *soap, const char *tag, bool **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (bool **)soap_malloc(soap, sizeof(bool *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_bool(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (bool **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_bool, sizeof(bool), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__NCName(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xsd__NCName))
		soap_serialize_xsd__NCName(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__NCName(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__NCName);
	if (soap_out_PointerToxsd__NCName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__NCName(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__NCName);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__NCName(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerToxsd__NCName(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__NCName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerToxsd__NCName(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__NCName(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__NCName, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__GroupName_USCOREType(struct soap *soap, jsdlPOSIX__GroupName_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__GroupName_USCOREType(struct soap *soap, jsdlPOSIX__GroupName_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__GroupName_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__GroupName_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__GroupName_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__GroupName_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__GroupName_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__GroupName_USCOREType(struct soap *soap, jsdlPOSIX__GroupName_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__GroupName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__GroupName_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__GroupName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__GroupName_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__GroupName_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__GroupName_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__GroupName_USCOREType *)soap_instantiate_jsdlPOSIX__GroupName_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__GroupName_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__GroupName_USCOREType, sizeof(jsdlPOSIX__GroupName_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__UserName_USCOREType(struct soap *soap, jsdlPOSIX__UserName_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__UserName_USCOREType(struct soap *soap, jsdlPOSIX__UserName_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__UserName_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__UserName_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__UserName_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__UserName_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__UserName_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__UserName_USCOREType(struct soap *soap, jsdlPOSIX__UserName_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__UserName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__UserName_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__UserName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__UserName_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__UserName_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__UserName_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__UserName_USCOREType *)soap_instantiate_jsdlPOSIX__UserName_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__UserName_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__UserName_USCOREType, sizeof(jsdlPOSIX__UserName_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__Limits_USCOREType(struct soap *soap, jsdlPOSIX__Limits_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__Limits_USCOREType(struct soap *soap, jsdlPOSIX__Limits_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__Limits_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__Limits_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__Limits_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__Limits_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__Limits_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__Limits_USCOREType(struct soap *soap, jsdlPOSIX__Limits_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__Limits_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__Limits_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__Limits_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Limits_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__Limits_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__Limits_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__Limits_USCOREType *)soap_instantiate_jsdlPOSIX__Limits_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__Limits_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__Limits_USCOREType, sizeof(jsdlPOSIX__Limits_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, jsdlPOSIX__Environment_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, jsdlPOSIX__Environment_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__Environment_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__Environment_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__Environment_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, jsdlPOSIX__Environment_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__Environment_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Environment_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__Environment_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__Environment_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__Environment_USCOREType *)soap_instantiate_jsdlPOSIX__Environment_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__Environment_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__Environment_USCOREType, sizeof(jsdlPOSIX__Environment_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, jsdlPOSIX__DirectoryName_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, jsdlPOSIX__DirectoryName_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__DirectoryName_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__DirectoryName_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__DirectoryName_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, jsdlPOSIX__DirectoryName_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__DirectoryName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__DirectoryName_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__DirectoryName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__DirectoryName_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__DirectoryName_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__DirectoryName_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__DirectoryName_USCOREType *)soap_instantiate_jsdlPOSIX__DirectoryName_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__DirectoryName_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__DirectoryName_USCOREType, sizeof(jsdlPOSIX__DirectoryName_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, jsdlPOSIX__Argument_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, jsdlPOSIX__Argument_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__Argument_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__Argument_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__Argument_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, jsdlPOSIX__Argument_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__Argument_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__Argument_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__Argument_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__Argument_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__Argument_USCOREType *)soap_instantiate_jsdlPOSIX__Argument_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__Argument_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__Argument_USCOREType, sizeof(jsdlPOSIX__Argument_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTojsdlPOSIX__FileName_USCOREType(struct soap *soap, jsdlPOSIX__FileName_USCOREType *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTojsdlPOSIX__FileName_USCOREType(struct soap *soap, jsdlPOSIX__FileName_USCOREType *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTojsdlPOSIX__FileName_USCOREType);
	if (soap_out_PointerTojsdlPOSIX__FileName_USCOREType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTojsdlPOSIX__FileName_USCOREType(struct soap *soap, const char *tag, int id, jsdlPOSIX__FileName_USCOREType *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 jsdlPOSIX__FileName_USCOREType ** SOAP_FMAC4 soap_get_PointerTojsdlPOSIX__FileName_USCOREType(struct soap *soap, jsdlPOSIX__FileName_USCOREType **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTojsdlPOSIX__FileName_USCOREType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 jsdlPOSIX__FileName_USCOREType ** SOAP_FMAC4 soap_in_PointerTojsdlPOSIX__FileName_USCOREType(struct soap *soap, const char *tag, jsdlPOSIX__FileName_USCOREType **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a)
		if (!(a = (jsdlPOSIX__FileName_USCOREType **)soap_malloc(soap, sizeof(jsdlPOSIX__FileName_USCOREType *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (jsdlPOSIX__FileName_USCOREType *)soap_instantiate_jsdlPOSIX__FileName_USCOREType(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	a = (jsdlPOSIX__FileName_USCOREType **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_jsdlPOSIX__FileName_USCOREType, sizeof(jsdlPOSIX__FileName_USCOREType), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*a)
{
	for (std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, -1)))
		return NULL;
	jsdlARC__RunTimeEnvironment_USCOREType *n;
	jsdlARC__RunTimeEnvironment_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlARC__RunTimeEnvironment_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType, sizeof(jsdlARC__RunTimeEnvironment_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, NULL, "jsdlARC:RunTimeEnvironment_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, tag, &n, "jsdlARC:RunTimeEnvironment_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlARC__RunTimeEnvironment_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlARC__RunTimeEnvironment_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlARC__RunTimeEnvironment_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlARC__RunTimeEnvironment_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)p = *(std::vector<jsdlARC__RunTimeEnvironment_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, const std::vector<jsdlARC__Middleware_USCOREType * >*a)
{
	for (std::vector<jsdlARC__Middleware_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlARC__Middleware_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, std::vector<jsdlARC__Middleware_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlARC__Middleware_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlARC__Middleware_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlARC__Middleware_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlARC__Middleware_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlARC__Middleware_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, -1)))
		return NULL;
	jsdlARC__Middleware_USCOREType *n;
	jsdlARC__Middleware_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlARC__Middleware_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType, sizeof(jsdlARC__Middleware_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlARC__Middleware_USCOREType(soap, tag, NULL, "jsdlARC:Middleware_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlARC__Middleware_USCOREType(soap, tag, &n, "jsdlARC:Middleware_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlARC__Middleware_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, std::vector<jsdlARC__Middleware_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlARC__Middleware_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlARC__Middleware_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlARC__Middleware_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlARC__Middleware_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlARC__Middleware_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlARC__Middleware_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlARC__Middleware_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlARC__Middleware_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlARC__Middleware_USCOREType * >*)p = *(std::vector<jsdlARC__Middleware_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, const std::vector<jsdl__FileSystem_USCOREType * >*a)
{
	for (std::vector<jsdl__FileSystem_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdl__FileSystem_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, std::vector<jsdl__FileSystem_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdl__FileSystem_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdl__FileSystem_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdl__FileSystem_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdl__FileSystem_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, const char *tag, std::vector<jsdl__FileSystem_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, -1)))
		return NULL;
	jsdl__FileSystem_USCOREType *n;
	jsdl__FileSystem_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdl__FileSystem_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType, sizeof(jsdl__FileSystem_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdl__FileSystem_USCOREType(soap, tag, NULL, "jsdl:FileSystem_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdl__FileSystem_USCOREType(soap, tag, &n, "jsdl:FileSystem_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdl__FileSystem_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, std::vector<jsdl__FileSystem_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdl__FileSystem_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdl__FileSystem_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdl__FileSystem_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdl__FileSystem_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdl__FileSystem_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdl__FileSystem_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdl__FileSystem_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdl__FileSystem_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdl__FileSystem_USCOREType * >*)p = *(std::vector<jsdl__FileSystem_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, const std::vector<jsdl__JobDescription_USCOREType * >*a)
{
	for (std::vector<jsdl__JobDescription_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdl__JobDescription_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, std::vector<jsdl__JobDescription_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdl__JobDescription_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdl__JobDescription_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdl__JobDescription_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdl__JobDescription_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, const char *tag, std::vector<jsdl__JobDescription_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, -1)))
		return NULL;
	jsdl__JobDescription_USCOREType *n;
	jsdl__JobDescription_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdl__JobDescription_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType, sizeof(jsdl__JobDescription_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdl__JobDescription_USCOREType(soap, tag, NULL, "jsdl:JobDescription_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdl__JobDescription_USCOREType(soap, tag, &n, "jsdl:JobDescription_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdl__JobDescription_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, std::vector<jsdl__JobDescription_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdl__JobDescription_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdl__JobDescription_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdl__JobDescription_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdl__JobDescription_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdl__JobDescription_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdl__JobDescription_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdl__JobDescription_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdl__JobDescription_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdl__JobDescription_USCOREType * >*)p = *(std::vector<jsdl__JobDescription_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, const std::vector<jsdlARC__RemoteLogging_USCOREType * >*a)
{
	for (std::vector<jsdlARC__RemoteLogging_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlARC__RemoteLogging_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, std::vector<jsdlARC__RemoteLogging_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlARC__RemoteLogging_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlARC__RemoteLogging_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlARC__RemoteLogging_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlARC__RemoteLogging_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, -1)))
		return NULL;
	jsdlARC__RemoteLogging_USCOREType *n;
	jsdlARC__RemoteLogging_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlARC__RemoteLogging_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType, sizeof(jsdlARC__RemoteLogging_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, NULL, "jsdlARC:RemoteLogging_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlARC__RemoteLogging_USCOREType(soap, tag, &n, "jsdlARC:RemoteLogging_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlARC__RemoteLogging_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, std::vector<jsdlARC__RemoteLogging_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlARC__RemoteLogging_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlARC__RemoteLogging_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlARC__RemoteLogging_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlARC__RemoteLogging_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlARC__RemoteLogging_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlARC__RemoteLogging_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlARC__RemoteLogging_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlARC__RemoteLogging_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlARC__RemoteLogging_USCOREType * >*)p = *(std::vector<jsdlARC__RemoteLogging_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, const std::vector<jsdlARC__Notify_USCOREType * >*a)
{
	for (std::vector<jsdlARC__Notify_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlARC__Notify_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, std::vector<jsdlARC__Notify_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlARC__Notify_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlARC__Notify_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlARC__Notify_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlARC__Notify_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlARC__Notify_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, -1)))
		return NULL;
	jsdlARC__Notify_USCOREType *n;
	jsdlARC__Notify_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlARC__Notify_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType, sizeof(jsdlARC__Notify_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlARC__Notify_USCOREType(soap, tag, NULL, "jsdlARC:Notify_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlARC__Notify_USCOREType(soap, tag, &n, "jsdlARC:Notify_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlARC__Notify_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, std::vector<jsdlARC__Notify_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlARC__Notify_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlARC__Notify_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlARC__Notify_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlARC__Notify_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlARC__Notify_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlARC__Notify_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlARC__Notify_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlARC__Notify_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlARC__Notify_USCOREType * >*)p = *(std::vector<jsdlARC__Notify_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, const std::vector<jsdl__DataStaging_USCOREType * >*a)
{
	for (std::vector<jsdl__DataStaging_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdl__DataStaging_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, std::vector<jsdl__DataStaging_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdl__DataStaging_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdl__DataStaging_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdl__DataStaging_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdl__DataStaging_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, const char *tag, std::vector<jsdl__DataStaging_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, -1)))
		return NULL;
	jsdl__DataStaging_USCOREType *n;
	jsdl__DataStaging_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdl__DataStaging_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType, sizeof(jsdl__DataStaging_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdl__DataStaging_USCOREType(soap, tag, NULL, "jsdl:DataStaging_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdl__DataStaging_USCOREType(soap, tag, &n, "jsdl:DataStaging_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdl__DataStaging_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, std::vector<jsdl__DataStaging_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdl__DataStaging_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdl__DataStaging_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdl__DataStaging_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdl__DataStaging_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdl__DataStaging_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdl__DataStaging_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdl__DataStaging_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdl__DataStaging_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdl__DataStaging_USCOREType * >*)p = *(std::vector<jsdl__DataStaging_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, const std::vector<jsdl__Range_USCOREType * >*a)
{
	for (std::vector<jsdl__Range_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdl__Range_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, std::vector<jsdl__Range_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdl__Range_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdl__Range_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdl__Range_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdl__Range_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, const char *tag, std::vector<jsdl__Range_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, -1)))
		return NULL;
	jsdl__Range_USCOREType *n;
	jsdl__Range_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdl__Range_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Range_USCOREType, sizeof(jsdl__Range_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdl__Range_USCOREType(soap, tag, NULL, "jsdl:Range_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdl__Range_USCOREType(soap, tag, &n, "jsdl:Range_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdl__Range_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, std::vector<jsdl__Range_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdl__Range_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Range_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdl__Range_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdl__Range_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdl__Range_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdl__Range_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdl__Range_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdl__Range_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdl__Range_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdl__Range_USCOREType * >*)p = *(std::vector<jsdl__Range_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, const std::vector<jsdl__Exact_USCOREType * >*a)
{
	for (std::vector<jsdl__Exact_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdl__Exact_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, std::vector<jsdl__Exact_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdl__Exact_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdl__Exact_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdl__Exact_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdl__Exact_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, const char *tag, std::vector<jsdl__Exact_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, -1)))
		return NULL;
	jsdl__Exact_USCOREType *n;
	jsdl__Exact_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdl__Exact_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType, sizeof(jsdl__Exact_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdl__Exact_USCOREType(soap, tag, NULL, "jsdl:Exact_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdl__Exact_USCOREType(soap, tag, &n, "jsdl:Exact_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdl__Exact_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, std::vector<jsdl__Exact_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdl__Exact_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdl__Exact_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdl__Exact_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdl__Exact_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdl__Exact_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdl__Exact_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdl__Exact_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdl__Exact_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdl__Exact_USCOREType * >*)p = *(std::vector<jsdl__Exact_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, const std::vector<enum jsdlARC__GMState_USCOREType >*a)
{
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, std::vector<enum jsdlARC__GMState_USCOREType >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<enum jsdlARC__GMState_USCOREType >*a, const char *type)
{
	for (std::vector<enum jsdlARC__GMState_USCOREType >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_jsdlARC__GMState_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<enum jsdlARC__GMState_USCOREType >* SOAP_FMAC4 soap_in_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, const char *tag, std::vector<enum jsdlARC__GMState_USCOREType >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, -1)))
		return NULL;
	enum jsdlARC__GMState_USCOREType n;
	enum jsdlARC__GMState_USCOREType *p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlARC__GMState_USCOREType, SOAP_TYPE_std__vectorTemplateOfjsdlARC__GMState_USCOREType, sizeof(enum jsdlARC__GMState_USCOREType), 0))
				break;
			if (!(p = soap_in_jsdlARC__GMState_USCOREType(soap, tag, NULL, "jsdlARC:GMState_Type")))
				break;
		}
		else
		{	soap_default_jsdlARC__GMState_USCOREType(soap, &n);
			if (!soap_in_jsdlARC__GMState_USCOREType(soap, tag, &n, "jsdlARC:GMState_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<enum jsdlARC__GMState_USCOREType > * SOAP_FMAC6 soap_new_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfjsdlARC__GMState_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, std::vector<enum jsdlARC__GMState_USCOREType >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<enum jsdlARC__GMState_USCOREType > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfjsdlARC__GMState_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfjsdlARC__GMState_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<enum jsdlARC__GMState_USCOREType >;
		if (size)
			*size = sizeof(std::vector<enum jsdlARC__GMState_USCOREType >);
	}
	else
	{	cp->ptr = (void*)new std::vector<enum jsdlARC__GMState_USCOREType >[n];
		if (size)
			*size = n * sizeof(std::vector<enum jsdlARC__GMState_USCOREType >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<enum jsdlARC__GMState_USCOREType >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfjsdlARC__GMState_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<enum jsdlARC__GMState_USCOREType > %p -> %p\n", q, p));
	*(std::vector<enum jsdlARC__GMState_USCOREType >*)p = *(std::vector<enum jsdlARC__GMState_USCOREType >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfstd__string(struct soap *soap, const std::vector<std::string >*a)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_std__string(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, int id, const std::vector<std::string >*a, const char *type)
{
	for (std::vector<std::string >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_std__string(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<std::string >* SOAP_FMAC4 soap_in_std__vectorTemplateOfstd__string(struct soap *soap, const char *tag, std::vector<std::string >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfstd__string(soap, -1)))
		return NULL;
	std::string n;
	std::string *p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_std__string, SOAP_TYPE_std__vectorTemplateOfstd__string, sizeof(std::string), 0))
				break;
			if (!(p = soap_in_std__string(soap, tag, NULL, "xsd:string")))
				break;
		}
		else
		{	soap_default_std__string(soap, &n);
			if (!soap_in_std__string(soap, tag, &n, "xsd:string"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<std::string > * SOAP_FMAC6 soap_new_std__vectorTemplateOfstd__string(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfstd__string(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfstd__string(struct soap *soap, std::vector<std::string >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<std::string > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfstd__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfstd__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfstd__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<std::string >;
		if (size)
			*size = sizeof(std::vector<std::string >);
	}
	else
	{	cp->ptr = (void*)new std::vector<std::string >[n];
		if (size)
			*size = n * sizeof(std::vector<std::string >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<std::string >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfstd__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<std::string > %p -> %p\n", q, p));
	*(std::vector<std::string >*)p = *(std::vector<std::string >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, const std::vector<jsdlPOSIX__Environment_USCOREType * >*a)
{
	for (std::vector<jsdlPOSIX__Environment_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlPOSIX__Environment_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, std::vector<jsdlPOSIX__Environment_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlPOSIX__Environment_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlPOSIX__Environment_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlPOSIX__Environment_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlPOSIX__Environment_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, -1)))
		return NULL;
	jsdlPOSIX__Environment_USCOREType *n;
	jsdlPOSIX__Environment_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlPOSIX__Environment_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType, sizeof(jsdlPOSIX__Environment_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, NULL, "jsdlPOSIX:Environment_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlPOSIX__Environment_USCOREType(soap, tag, &n, "jsdlPOSIX:Environment_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlPOSIX__Environment_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, std::vector<jsdlPOSIX__Environment_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlPOSIX__Environment_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlPOSIX__Environment_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlPOSIX__Environment_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlPOSIX__Environment_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlPOSIX__Environment_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlPOSIX__Environment_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlPOSIX__Environment_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlPOSIX__Environment_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlPOSIX__Environment_USCOREType * >*)p = *(std::vector<jsdlPOSIX__Environment_USCOREType * >*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, const std::vector<jsdlPOSIX__Argument_USCOREType * >*a)
{
	for (std::vector<jsdlPOSIX__Argument_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
		soap_serialize_PointerTojsdlPOSIX__Argument_USCOREType(soap, &(*i));
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, std::vector<jsdlPOSIX__Argument_USCOREType * >*p)
{
	p->clear();
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, int id, const std::vector<jsdlPOSIX__Argument_USCOREType * >*a, const char *type)
{
	for (std::vector<jsdlPOSIX__Argument_USCOREType * >::const_iterator i = a->begin(); i != a->end(); ++i)
	{
		if (soap_out_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, id, &(*i), ""))
			return soap->error;
	}
	return SOAP_OK;
}

SOAP_FMAC3 std::vector<jsdlPOSIX__Argument_USCOREType * >* SOAP_FMAC4 soap_in_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, const char *tag, std::vector<jsdlPOSIX__Argument_USCOREType * >*a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1))
		return NULL;
	if (!a && !(a = soap_new_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, -1)))
		return NULL;
	jsdlPOSIX__Argument_USCOREType *n;
	jsdlPOSIX__Argument_USCOREType **p;
	do
	{	soap_revert(soap);
		if (*soap->id || *soap->href)
		{	if (!soap_container_id_forward(soap, *soap->id?soap->id:soap->href, a, (size_t)a->size(), SOAP_TYPE_jsdlPOSIX__Argument_USCOREType, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType, sizeof(jsdlPOSIX__Argument_USCOREType), 1))
				break;
			if (!(p = soap_in_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, NULL, "jsdlPOSIX:Argument_Type")))
				break;
		}
		else
		{	n = NULL;
			if (!soap_in_PointerTojsdlPOSIX__Argument_USCOREType(soap, tag, &n, "jsdlPOSIX:Argument_Type"))
				break;
		}
		a->push_back(n);
	}
	while (!soap_element_begin_in(soap, tag, 1));
	if (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG)
	{	soap->error = SOAP_OK;
		return a;
	}
	return NULL;
}

SOAP_FMAC5 std::vector<jsdlPOSIX__Argument_USCOREType * > * SOAP_FMAC6 soap_new_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, int n)
{	return soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, std::vector<jsdlPOSIX__Argument_USCOREType * >*p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 std::vector<jsdlPOSIX__Argument_USCOREType * > * SOAP_FMAC4 soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new std::vector<jsdlPOSIX__Argument_USCOREType * >;
		if (size)
			*size = sizeof(std::vector<jsdlPOSIX__Argument_USCOREType * >);
	}
	else
	{	cp->ptr = (void*)new std::vector<jsdlPOSIX__Argument_USCOREType * >[n];
		if (size)
			*size = n * sizeof(std::vector<jsdlPOSIX__Argument_USCOREType * >);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::vector<jsdlPOSIX__Argument_USCOREType * >*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__vectorTemplateOfPointerTojsdlPOSIX__Argument_USCOREType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::vector<jsdlPOSIX__Argument_USCOREType * > %p -> %p\n", q, p));
	*(std::vector<jsdlPOSIX__Argument_USCOREType * >*)p = *(std::vector<jsdlPOSIX__Argument_USCOREType * >*)q;
}

/* End of jsdl_soapC.cpp */
