#include "../std.h"

#include <string>
#include <fstream>

#include "../misc/escaped.h"
#include "../misc/log_time.h"
#include "auth.h"

int AuthUser::match_file(const char* line) {
  for(;;) {
    std::string s("");
    int n = input_escaped_string(line,s,' ','"');
    if(n == 0) break;
    line+=n;
    std::ifstream f(s.c_str());
    if(!f.is_open()) {
      olog<<"Failed to read file "<<s<<std::endl;
      return AAA_FAILURE;
    };
    for(;!f.eof();) {
      char buf[1024];
      istream_readline(f,buf,sizeof(buf));
      int res = evaluate(buf);
      if(res != AAA_NO_MATCH) {
        f.close();
        return res;
      };
    };
    f.close();
  };
  return AAA_NO_MATCH;
}
