#ifndef __DATAHANDLE_FTP_H__
#define __DATAHANDLE_FTP_H__

#include "../std.h"

#include <string>
#include <list>

#include <globus_common.h>
#include <globus_ftp_client.h>

#include "../misc/condition.h"
#include "../misc/globus_modules.h"

#include "datahandle.h"

class DataHandleFTP: public DataHandleCommon {
 private:
  class FTPHolder {
   public:
    FTPHolder(DataHandleFTP*);
    ~FTPHolder(void);
    globus_ftp_client_handle_t handle;
    globus_ftp_client_operationattr_t opattr;
    DataHandleFTP* arg;
  };
  GlobusModuleFTPClient ftp_mod;
  bool ftp_active;
  FTPHolder* ftp_holder;
  globus_thread_t ftp_control_thread;
  int ftp_threads;
  Condition<int> ftp_completed;
  Condition<int> thread_completed;
  LockSimple ftp_order;
  bool ftp_eof_flag;
  CounterSimple ftp_counter;
  static void ftp_complete_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error);
  static void ftp_get_complete_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error);
  static void ftp_put_complete_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error);
  static void ftp_read_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error,globus_byte_t* buffer,globus_size_t length,globus_off_t offset,globus_bool_t eof);
  static void ftp_check_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error,globus_byte_t* buffer,globus_size_t length,globus_off_t offset,globus_bool_t eof);
  static void ftp_write_callback(void* arg,globus_ftp_client_handle_t* handle,globus_object_t* error,globus_byte_t* buffer,globus_size_t length,globus_off_t offset,globus_bool_t eof);
  static void* ftp_read_thread(void *arg);
  static void* ftp_write_thread(void *arg);
  std::string ftp_dir_path;
  bool mkdir_ftp();
  char ftp_buf[16];
  bool check_credentials(void);
  virtual bool drop_handle(void); 
 protected:
  virtual bool init_handle(void); 
  virtual bool deinit_handle(void); 
 public:
  static DataHandle* CreateInstance(DataPoint* url_);
  DataHandleFTP(DataPoint* url_);
  virtual ~DataHandleFTP(void);
  virtual bool analyze(analyze_t &arg);
  virtual bool start_reading(DataBufferPar &buf);
  virtual bool start_writing(DataBufferPar &buf,DataCallback *space_cb = NULL);
  virtual bool stop_reading(void);
  virtual bool stop_writing(void);
  virtual bool check(void);
  virtual bool remove(void);
  virtual bool list_files(std::list<DataPoint::FileInfo> &files,bool long_list=false,bool resolve = false,bool metadata = false);
  virtual bool out_of_order(void);
};

#endif
