#ifndef __DATAHANDLE_SRM_H__
#define __DATAHANDLE_SRM_H__

#include "../std.h"

#include <string>
#include <list>

#include "../misc/condition.h"
#include "../misc/globus_modules.h"

#include "datahandle.h"

class SRMClient;
class SRMClientRequest;

class DataHandleSRM: public DataHandleCommon {
 private:
  DataPoint* r_url; /* url used for redirected operations */
  DataHandle* r_handle; /* handle used for redirected operations */
  SRMClientRequest* srm_request;
 protected:
  virtual bool init_handle(void); 
  virtual bool deinit_handle(void); 
 public: 
  static DataHandle* CreateInstance(DataPoint* url_);
  DataHandleSRM(DataPoint* url_);
  virtual ~DataHandleSRM(void);
  virtual bool start_reading(DataBufferPar &buffer);
  virtual bool start_writing(DataBufferPar &buffer,DataCallback *space_cb = NULL);
  virtual bool stop_reading(void);
  virtual bool stop_writing(void);
  virtual bool analyze(analyze_t &arg);
  virtual bool check(void);
  virtual bool remove(void);
  virtual bool list_files(std::list<DataPoint::FileInfo> &files,bool long_list = false,bool resolve = false,bool metadata = false);
};

#endif
