#include "../../std.h"

#include "../../auth/identity_dn.h"
#include "../../auth/identity_voms.h"

#include "identity_srm.h"


Identity::Item* IdentitySRMv2::add(const Item* t) {
  if(items_.size() > 0) return NULL;
  return Identity::add(t);
}

Identity::Item* IdentitySRMv2::use(Item* t) {
  if(items_.size() > 0) return NULL;
  return Identity::use(t);
}


IdentitySRMv2::IdentitySRMv2(const Identity& t):Identity(t) { }

IdentitySRMv2::~IdentitySRMv2(void) { }

IdentitySRMv2::IdentitySRMv2(void) { }

IdentitySRMv2::IdentitySRMv2(const char* u) {
  IdentityItemDN* t = new IdentityItemDN(u);
  if(t) Identity::use(t);
}

Identity* IdentitySRMv2::duplicate(void) const {
  return new IdentitySRMv2(*this);
}

std::string IdentitySRMv2::get(void) {
  if(items_.size() <= 0) return std::string("");
  Identity::Item* i = *(items_.begin());
  if(!i) return std::string("");
  return i->str();
}

void IdentitySRMv2::set(const std::string& i) {
  items_.clear();
  IdentityItemDN dn(i.c_str());
  add(&dn);
}

