#include "../../std.h"

#include <string>

#include "../../misc/log_time.h"
#include "../../misc/escaped.h"
#include "../../misc/time_utils.h"
#include "../server/httpsd.h"

// HACK
static bool merge_urls(std::string &cfg_url,const char* contact_base);

#define __SRM_INTERNAL_INCLUDE__
#include "srm.h"

#include "srm1_soapH.h"
#include "srm2_soapH.h"

extern SOAP_NMAC struct Namespace srm1_soap_namespaces[];
extern SOAP_NMAC struct Namespace srm2_soap_namespaces[];
extern SOAP_NMAC struct Namespace file_soap_namespaces[];

#include "../se.h"

#define SOAP_ENV__Header SE_ENV__Header
#define SOAP_ENV__Code   SE_ENV__Code
#define SOAP_ENV__Detail SE_ENV__Detail
#define SOAP_ENV__Fault  SE_ENV__Fault
#include "../se/file_soapStub.h"
#undef SE_ENV__Header
#undef SE_ENV__Code
#undef SE_ENV__Detail
#undef SE_ENV__Fault

#ifdef OLD_GSOAP
#error gSOAP older than 2.5.2 is not supported.
#else
void HTTP_SRM::soap_methods(void) {
  odlog(VERBOSE)<<"soap_methods: tag: "<<sp.tag<<std::endl;
  if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:put")) soap_serve_SRMv1Meth__put(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:get")) soap_serve_SRMv1Meth__get(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:copy")) soap_serve_SRMv1Meth__copy(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:ping")) soap_serve_SRMv1Meth__ping(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:pin")) soap_serve_SRMv1Meth__pin(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:unPin")) soap_serve_SRMv1Meth__unPin(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:setFileStatus")) soap_serve_SRMv1Meth__setFileStatus(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:getRequestStatus")) soap_serve_SRMv1Meth__getRequestStatus(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:getFileMetaData")) soap_serve_SRMv1Meth__getFileMetaData(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:mkPermanent")) soap_serve_SRMv1Meth__mkPermanent(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:getEstGetTime")) soap_serve_SRMv1Meth__getEstGetTime(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:getEstPutTime")) soap_serve_SRMv1Meth__getEstPutTime(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:advisoryDelete")) soap_serve_SRMv1Meth__advisoryDelete(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv1Meth:getProtocols")) soap_serve_SRMv1Meth__getProtocols(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmReserveSpace")) soap_serve_SRMv2__srmReserveSpace(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmReleaseSpace")) soap_serve_SRMv2__srmReleaseSpace(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmUpdateSpace")) soap_serve_SRMv2__srmUpdateSpace(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmCompactSpace")) soap_serve_SRMv2__srmCompactSpace(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmGetSpaceMetaData")) soap_serve_SRMv2__srmGetSpaceMetaData(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmChangeFileStorageType")) soap_serve_SRMv2__srmChangeFileStorageType(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmGetSpaceToken")) soap_serve_SRMv2__srmGetSpaceToken(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmSetPermission")) soap_serve_SRMv2__srmSetPermission(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmReassignToUser")) soap_serve_SRMv2__srmReassignToUser(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmCheckPermission")) soap_serve_SRMv2__srmCheckPermission(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmMkdir")) soap_serve_SRMv2__srmMkdir(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmRmdir")) soap_serve_SRMv2__srmRmdir(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmRm")) soap_serve_SRMv2__srmRm(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmLs")) soap_serve_SRMv2__srmLs(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmMv")) soap_serve_SRMv2__srmMv(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmPrepareToGet")) soap_serve_SRMv2__srmPrepareToGet(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmPrepareToPut")) soap_serve_SRMv2__srmPrepareToPut(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmCopy")) soap_serve_SRMv2__srmCopy(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmRemoveFiles")) soap_serve_SRMv2__srmRemoveFiles(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmReleaseFiles")) soap_serve_SRMv2__srmReleaseFiles(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmPutDone")) soap_serve_SRMv2__srmPutDone(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmAbortRequest")) soap_serve_SRMv2__srmAbortRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmAbortFiles")) soap_serve_SRMv2__srmAbortFiles(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmSuspendRequest")) soap_serve_SRMv2__srmSuspendRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmResumeRequest")) soap_serve_SRMv2__srmResumeRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmStatusOfGetRequest")) soap_serve_SRMv2__srmStatusOfGetRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmStatusOfPutRequest")) soap_serve_SRMv2__srmStatusOfPutRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmStatusOfCopyRequest")) soap_serve_SRMv2__srmStatusOfCopyRequest(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmGetRequestSummary")) soap_serve_SRMv2__srmGetRequestSummary(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmExtendFileLifeTime")) soap_serve_SRMv2__srmExtendFileLifeTime(&sp);
  else if(!soap_match_tag(&sp,sp.tag,"SRMv2:srmGetRequestID")) soap_serve_SRMv2__srmGetRequestID(&sp);
  else {
    sp.user=this->se;
    if(!soap_match_tag(&sp,sp.tag,"ns:add")) soap_serve_ns__add(&sp);
    else if(!soap_match_tag(&sp,sp.tag,"ns:update")) soap_serve_ns__update(&sp);
    else if(!soap_match_tag(&sp,sp.tag,"ns:info")) soap_serve_ns__info(&sp);
    else if(!soap_match_tag(&sp,sp.tag,"ns:acl")) soap_serve_ns__acl(&sp);
    else if(!soap_match_tag(&sp,sp.tag,"ns:del")) soap_serve_ns__del(&sp);
    else sp.error=SOAP_NO_METHOD;
    soap_flush(&sp);
    sp.user=this;
    return;
  };
  soap_flush(&sp);
}
#endif


class HTTP_SRM_Handle {
 public:
  HTTP_Service_Properties se_prop;
  std::string service_url;
  SRMRequests requests;
  SRMRequests_Thread* req_thread;
  struct Namespace *srm_soap_namespaces;
  HTTP_SRM_Handle(const char* u):service_url(u),req_thread(NULL) { };
  ~HTTP_SRM_Handle(void) { };
};

bool srm_service_configurator(std::istream& f,const char* uri,HTTP_Service_Properties &prop) {
  std::string service_url(uri);
  {
    const char* u = base_url_by_type("gsi");
    if(!u) u=base_url_by_type("gssapi");
    if(!u) return false;
    merge_urls(service_url,u);
  };
  HTTP_SRM_Handle* handle = new HTTP_SRM_Handle(service_url.c_str());
  if(!handle) return false;
  if(!se_service_configurator(f,uri,handle->se_prop)) {
    delete handle;
    return false;
  };
  handle->req_thread = new SRMRequests_Thread(handle->requests);
  int n = 0;
  struct Namespace *ns;
  for(ns=srm1_soap_namespaces;ns->id;ns++) { n++; };
  for(ns=srm2_soap_namespaces;ns->id;ns++) { n++; };
  for(ns=file_soap_namespaces;ns->id;ns++) { n++; };
  handle->srm_soap_namespaces=
             (struct Namespace*)malloc(sizeof(struct Namespace)*(n+1));
  if(handle->srm_soap_namespaces) {
    memset(handle->srm_soap_namespaces,0,sizeof(struct Namespace)*(n+1));
    n=0;
    for(ns=srm1_soap_namespaces;ns->id;ns++) {
      int nn;
      for(nn=0;nn<n;nn++) {
        if(strcmp(ns->id,((handle->srm_soap_namespaces)+nn)->id) == 0) break;
      };
      if(nn == n) {
        memcpy((handle->srm_soap_namespaces)+n,ns,sizeof(struct Namespace));
        n++;
      };
    };
    for(ns=srm2_soap_namespaces;ns->id;ns++) {
      int nn;
      for(nn=0;nn<n;nn++) {
        if(strcmp(ns->id,((handle->srm_soap_namespaces)+nn)->id) == 0) break;
      };
      if(nn == n) {
        memcpy((handle->srm_soap_namespaces)+n,ns,sizeof(struct Namespace));
        n++;
      };
    };
    for(ns=file_soap_namespaces;ns->id;ns++) {
      int nn;
      for(nn=0;nn<n;nn++) {
        if(strcmp(ns->id,((handle->srm_soap_namespaces)+nn)->id) == 0) break;
      };
      if(nn == n) {
        memcpy((handle->srm_soap_namespaces)+n,ns,sizeof(struct Namespace));
        n++;
      };
    };
  };
  prop.arg=handle;
  prop.subtree=true;
  return true;
}

HTTP_Service* srm_service_creator(HTTP_Connector& c,const char* uri,void* arg) {
  HTTP_SRM_Handle* handle = (HTTP_SRM_Handle*)arg;
  if(!handle) return NULL;
  HTTP_SRM* h = new HTTP_SRM(&c,handle);
  return h;
}

HTTP_SRM::HTTP_SRM(HTTP_Connector *c_,HTTP_SRM_Handle* handle):HTTP_ServiceAdv(c_),se(NULL) {
  if(!handle) return;
  soap_init();
  //sp.namespaces=srm1_soap_namespaces;
  sp.namespaces=handle->srm_soap_namespaces;
  service_url=handle->service_url;
  sp.user=this;
  requests=&(handle->requests);
  se=(HTTP_SE*)se_service_creator(*c_,service_url.c_str(),handle->se_prop.arg);
}

HTTP_SRM::~HTTP_SRM(void) {
  soap_deinit();
  if(se) delete se;
}

HTTP_Error HTTP_SRM::get(const char* uri,int &keep_alive) {
  if(!se) return HTTP_NOT_IMPLEMENTED;
  odlog(VERBOSE)<<"SRM:get: uri: "<<uri<<std::endl;
  return se->get(uri,keep_alive);
}

HTTP_Error HTTP_SRM::put(const char* uri,int &keep_alive) {
  if(!se) return HTTP_NOT_IMPLEMENTED;
  odlog(VERBOSE)<<"SRM:put: uri: "<<uri<<std::endl;
  return se->put(uri,keep_alive);
}

HTTP_Error HTTP_SRM::post(const char* uri,int &keep_alive) {
  if(!se) return HTTP_NOT_IMPLEMENTED;
  odlog(VERBOSE)<<"SRM:post: uri: "<<uri<<std::endl;
  se->set_current_file(uri);
  return soap_post(uri,keep_alive);
}

static bool merge_urls(std::string &cfg_url,const char* contact_base) {
  if((cfg_url.length() == 0) || (cfg_url[0] == '/')) { // path
    const char* u_ = contact_base;
    u_=strchr(u_,':'); if(u_==NULL) return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; u_=strchr(u_,'/'); if(u_==NULL) u_=contact_base+strlen(contact_base);
    std::string url(contact_base,u_-contact_base);
    cfg_url=url+cfg_url;
  } else if(cfg_url[0] == ':') { // port+path
    const char* u_ = contact_base;
    u_=strchr(u_,':'); if(u_==NULL) return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; if((*u_) != '/') return false; // bad url
    u_++; u_=strchr(u_,'/'); if(u_==NULL) u_=contact_base+strlen(contact_base);
    std::string::size_type p = cfg_url.find('/'); if(p == std::string::npos) p=cfg_url.length();
    std::string url(contact_base,u_-contact_base);
    url+=cfg_url.c_str()+p;
    cfg_url=url;
  } else { // url

  };
  return true;
}

