/* srm1_soapServer.cpp
   Generated by gSOAP 2.7.8a from srm1_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
#include "srm1_soapH.h"

SOAP_SOURCE_STAMP("@(#) srm1_soapServer.cpp ver 2.7.8a 2009-04-06 10:45:38 GMT")


SOAP_FMAC5 int SOAP_FMAC6 srm1_soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || srm1_soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 srm1_soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:put"))
		return soap_serve_SRMv1Meth__put(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:get"))
		return soap_serve_SRMv1Meth__get(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:copy"))
		return soap_serve_SRMv1Meth__copy(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:ping"))
		return soap_serve_SRMv1Meth__ping(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:pin"))
		return soap_serve_SRMv1Meth__pin(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:unPin"))
		return soap_serve_SRMv1Meth__unPin(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:setFileStatus"))
		return soap_serve_SRMv1Meth__setFileStatus(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:getRequestStatus"))
		return soap_serve_SRMv1Meth__getRequestStatus(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:getFileMetaData"))
		return soap_serve_SRMv1Meth__getFileMetaData(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:mkPermanent"))
		return soap_serve_SRMv1Meth__mkPermanent(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:getEstGetTime"))
		return soap_serve_SRMv1Meth__getEstGetTime(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:getEstPutTime"))
		return soap_serve_SRMv1Meth__getEstPutTime(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:advisoryDelete"))
		return soap_serve_SRMv1Meth__advisoryDelete(soap);
	if (!soap_match_tag(soap, soap->tag, "SRMv1Meth:getProtocols"))
		return soap_serve_SRMv1Meth__getProtocols(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__put(struct soap *soap)
{	struct SRMv1Meth__put soap_tmp_SRMv1Meth__put;
	struct SRMv1Meth__putResponse _param_1;
	soap_default_SRMv1Meth__putResponse(soap, &_param_1);
	soap_default_SRMv1Meth__put(soap, &soap_tmp_SRMv1Meth__put);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__put(soap, &soap_tmp_SRMv1Meth__put, "SRMv1Meth:put", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__put(soap, soap_tmp_SRMv1Meth__put._arg0, soap_tmp_SRMv1Meth__put._arg1, soap_tmp_SRMv1Meth__put._arg2, soap_tmp_SRMv1Meth__put._arg3, soap_tmp_SRMv1Meth__put._arg4, _param_1);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__putResponse(soap, &_param_1);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__putResponse(soap, &_param_1, "SRMv1Meth:putResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__putResponse(soap, &_param_1, "SRMv1Meth:putResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__get(struct soap *soap)
{	struct SRMv1Meth__get soap_tmp_SRMv1Meth__get;
	struct SRMv1Meth__getResponse _param_2;
	soap_default_SRMv1Meth__getResponse(soap, &_param_2);
	soap_default_SRMv1Meth__get(soap, &soap_tmp_SRMv1Meth__get);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__get(soap, &soap_tmp_SRMv1Meth__get, "SRMv1Meth:get", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__get(soap, soap_tmp_SRMv1Meth__get._arg0, soap_tmp_SRMv1Meth__get._arg1, _param_2);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getResponse(soap, &_param_2);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getResponse(soap, &_param_2, "SRMv1Meth:getResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getResponse(soap, &_param_2, "SRMv1Meth:getResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__copy(struct soap *soap)
{	struct SRMv1Meth__copy soap_tmp_SRMv1Meth__copy;
	struct SRMv1Meth__copyResponse _param_3;
	soap_default_SRMv1Meth__copyResponse(soap, &_param_3);
	soap_default_SRMv1Meth__copy(soap, &soap_tmp_SRMv1Meth__copy);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__copy(soap, &soap_tmp_SRMv1Meth__copy, "SRMv1Meth:copy", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__copy(soap, soap_tmp_SRMv1Meth__copy._arg0, soap_tmp_SRMv1Meth__copy._arg1, soap_tmp_SRMv1Meth__copy._arg2, _param_3);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__copyResponse(soap, &_param_3);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__copyResponse(soap, &_param_3, "SRMv1Meth:copyResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__copyResponse(soap, &_param_3, "SRMv1Meth:copyResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__ping(struct soap *soap)
{	struct SRMv1Meth__ping soap_tmp_SRMv1Meth__ping;
	struct SRMv1Meth__pingResponse soap_tmp_SRMv1Meth__pingResponse;
	soap_default_SRMv1Meth__pingResponse(soap, &soap_tmp_SRMv1Meth__pingResponse);
	soap_default_SRMv1Meth__ping(soap, &soap_tmp_SRMv1Meth__ping);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__ping(soap, &soap_tmp_SRMv1Meth__ping, "SRMv1Meth:ping", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__ping(soap, soap_tmp_SRMv1Meth__pingResponse._Result);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__pingResponse(soap, &soap_tmp_SRMv1Meth__pingResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__pingResponse(soap, &soap_tmp_SRMv1Meth__pingResponse, "SRMv1Meth:pingResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__pingResponse(soap, &soap_tmp_SRMv1Meth__pingResponse, "SRMv1Meth:pingResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__pin(struct soap *soap)
{	struct SRMv1Meth__pin soap_tmp_SRMv1Meth__pin;
	struct SRMv1Meth__pinResponse _param_4;
	soap_default_SRMv1Meth__pinResponse(soap, &_param_4);
	soap_default_SRMv1Meth__pin(soap, &soap_tmp_SRMv1Meth__pin);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__pin(soap, &soap_tmp_SRMv1Meth__pin, "SRMv1Meth:pin", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__pin(soap, soap_tmp_SRMv1Meth__pin._arg0, _param_4);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__pinResponse(soap, &_param_4);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__pinResponse(soap, &_param_4, "SRMv1Meth:pinResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__pinResponse(soap, &_param_4, "SRMv1Meth:pinResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__unPin(struct soap *soap)
{	struct SRMv1Meth__unPin soap_tmp_SRMv1Meth__unPin;
	struct SRMv1Meth__unPinResponse _param_5;
	soap_default_SRMv1Meth__unPinResponse(soap, &_param_5);
	soap_default_SRMv1Meth__unPin(soap, &soap_tmp_SRMv1Meth__unPin);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__unPin(soap, &soap_tmp_SRMv1Meth__unPin, "SRMv1Meth:unPin", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__unPin(soap, soap_tmp_SRMv1Meth__unPin._arg0, soap_tmp_SRMv1Meth__unPin._arg1, _param_5);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__unPinResponse(soap, &_param_5);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__unPinResponse(soap, &_param_5, "SRMv1Meth:unPinResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__unPinResponse(soap, &_param_5, "SRMv1Meth:unPinResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__setFileStatus(struct soap *soap)
{	struct SRMv1Meth__setFileStatus soap_tmp_SRMv1Meth__setFileStatus;
	struct SRMv1Meth__setFileStatusResponse _param_6;
	soap_default_SRMv1Meth__setFileStatusResponse(soap, &_param_6);
	soap_default_SRMv1Meth__setFileStatus(soap, &soap_tmp_SRMv1Meth__setFileStatus);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__setFileStatus(soap, &soap_tmp_SRMv1Meth__setFileStatus, "SRMv1Meth:setFileStatus", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__setFileStatus(soap, soap_tmp_SRMv1Meth__setFileStatus._arg0, soap_tmp_SRMv1Meth__setFileStatus._arg1, soap_tmp_SRMv1Meth__setFileStatus._arg2, _param_6);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__setFileStatusResponse(soap, &_param_6);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__setFileStatusResponse(soap, &_param_6, "SRMv1Meth:setFileStatusResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__setFileStatusResponse(soap, &_param_6, "SRMv1Meth:setFileStatusResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__getRequestStatus(struct soap *soap)
{	struct SRMv1Meth__getRequestStatus soap_tmp_SRMv1Meth__getRequestStatus;
	struct SRMv1Meth__getRequestStatusResponse _param_7;
	soap_default_SRMv1Meth__getRequestStatusResponse(soap, &_param_7);
	soap_default_SRMv1Meth__getRequestStatus(soap, &soap_tmp_SRMv1Meth__getRequestStatus);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__getRequestStatus(soap, &soap_tmp_SRMv1Meth__getRequestStatus, "SRMv1Meth:getRequestStatus", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__getRequestStatus(soap, soap_tmp_SRMv1Meth__getRequestStatus._arg0, _param_7);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getRequestStatusResponse(soap, &_param_7);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getRequestStatusResponse(soap, &_param_7, "SRMv1Meth:getRequestStatusResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getRequestStatusResponse(soap, &_param_7, "SRMv1Meth:getRequestStatusResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__getFileMetaData(struct soap *soap)
{	struct SRMv1Meth__getFileMetaData soap_tmp_SRMv1Meth__getFileMetaData;
	struct SRMv1Meth__getFileMetaDataResponse _param_8;
	soap_default_SRMv1Meth__getFileMetaDataResponse(soap, &_param_8);
	soap_default_SRMv1Meth__getFileMetaData(soap, &soap_tmp_SRMv1Meth__getFileMetaData);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__getFileMetaData(soap, &soap_tmp_SRMv1Meth__getFileMetaData, "SRMv1Meth:getFileMetaData", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__getFileMetaData(soap, soap_tmp_SRMv1Meth__getFileMetaData._arg0, _param_8);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getFileMetaDataResponse(soap, &_param_8);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getFileMetaDataResponse(soap, &_param_8, "SRMv1Meth:getFileMetaDataResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getFileMetaDataResponse(soap, &_param_8, "SRMv1Meth:getFileMetaDataResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__mkPermanent(struct soap *soap)
{	struct SRMv1Meth__mkPermanent soap_tmp_SRMv1Meth__mkPermanent;
	struct SRMv1Meth__mkPermanentResponse _param_9;
	soap_default_SRMv1Meth__mkPermanentResponse(soap, &_param_9);
	soap_default_SRMv1Meth__mkPermanent(soap, &soap_tmp_SRMv1Meth__mkPermanent);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__mkPermanent(soap, &soap_tmp_SRMv1Meth__mkPermanent, "SRMv1Meth:mkPermanent", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__mkPermanent(soap, soap_tmp_SRMv1Meth__mkPermanent._arg0, _param_9);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__mkPermanentResponse(soap, &_param_9);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__mkPermanentResponse(soap, &_param_9, "SRMv1Meth:mkPermanentResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__mkPermanentResponse(soap, &_param_9, "SRMv1Meth:mkPermanentResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__getEstGetTime(struct soap *soap)
{	struct SRMv1Meth__getEstGetTime soap_tmp_SRMv1Meth__getEstGetTime;
	struct SRMv1Meth__getEstGetTimeResponse _param_10;
	soap_default_SRMv1Meth__getEstGetTimeResponse(soap, &_param_10);
	soap_default_SRMv1Meth__getEstGetTime(soap, &soap_tmp_SRMv1Meth__getEstGetTime);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__getEstGetTime(soap, &soap_tmp_SRMv1Meth__getEstGetTime, "SRMv1Meth:getEstGetTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__getEstGetTime(soap, soap_tmp_SRMv1Meth__getEstGetTime._arg0, soap_tmp_SRMv1Meth__getEstGetTime._arg1, _param_10);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getEstGetTimeResponse(soap, &_param_10);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getEstGetTimeResponse(soap, &_param_10, "SRMv1Meth:getEstGetTimeResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getEstGetTimeResponse(soap, &_param_10, "SRMv1Meth:getEstGetTimeResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__getEstPutTime(struct soap *soap)
{	struct SRMv1Meth__getEstPutTime soap_tmp_SRMv1Meth__getEstPutTime;
	struct SRMv1Meth__getEstPutTimeResponse _param_11;
	soap_default_SRMv1Meth__getEstPutTimeResponse(soap, &_param_11);
	soap_default_SRMv1Meth__getEstPutTime(soap, &soap_tmp_SRMv1Meth__getEstPutTime);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__getEstPutTime(soap, &soap_tmp_SRMv1Meth__getEstPutTime, "SRMv1Meth:getEstPutTime", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__getEstPutTime(soap, soap_tmp_SRMv1Meth__getEstPutTime._arg0, soap_tmp_SRMv1Meth__getEstPutTime._arg1, soap_tmp_SRMv1Meth__getEstPutTime._arg2, soap_tmp_SRMv1Meth__getEstPutTime._arg3, soap_tmp_SRMv1Meth__getEstPutTime._arg4, _param_11);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getEstPutTimeResponse(soap, &_param_11);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getEstPutTimeResponse(soap, &_param_11, "SRMv1Meth:getEstPutTimeResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getEstPutTimeResponse(soap, &_param_11, "SRMv1Meth:getEstPutTimeResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__advisoryDelete(struct soap *soap)
{	struct SRMv1Meth__advisoryDelete soap_tmp_SRMv1Meth__advisoryDelete;
	struct SRMv1Meth__advisoryDeleteResponse _param_12;
	soap_default_SRMv1Meth__advisoryDeleteResponse(soap, &_param_12);
	soap_default_SRMv1Meth__advisoryDelete(soap, &soap_tmp_SRMv1Meth__advisoryDelete);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__advisoryDelete(soap, &soap_tmp_SRMv1Meth__advisoryDelete, "SRMv1Meth:advisoryDelete", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__advisoryDelete(soap, soap_tmp_SRMv1Meth__advisoryDelete._arg0, _param_12);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__advisoryDeleteResponse(soap, &_param_12);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__advisoryDeleteResponse(soap, &_param_12, "SRMv1Meth:advisoryDeleteResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__advisoryDeleteResponse(soap, &_param_12, "SRMv1Meth:advisoryDeleteResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_SRMv1Meth__getProtocols(struct soap *soap)
{	struct SRMv1Meth__getProtocols soap_tmp_SRMv1Meth__getProtocols;
	struct SRMv1Meth__getProtocolsResponse _param_13;
	soap_default_SRMv1Meth__getProtocolsResponse(soap, &_param_13);
	soap_default_SRMv1Meth__getProtocols(soap, &soap_tmp_SRMv1Meth__getProtocols);
	soap->encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
	if (!soap_get_SRMv1Meth__getProtocols(soap, &soap_tmp_SRMv1Meth__getProtocols, "SRMv1Meth:getProtocols", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = SRMv1Meth__getProtocols(soap, _param_13);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_SRMv1Meth__getProtocolsResponse(soap, &_param_13);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_SRMv1Meth__getProtocolsResponse(soap, &_param_13, "SRMv1Meth:getProtocolsResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_SRMv1Meth__getProtocolsResponse(soap, &_param_13, "SRMv1Meth:getProtocolsResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

/* End of srm1_soapServer.cpp */
