/* srm2_2_soapC.cpp
   Generated by gSOAP 2.7.8a from srm2_2_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "srm2_2_soapH.h"

SOAP_SOURCE_STAMP("@(#) srm2_2_soapC.cpp ver 2.7.8a 2009-04-06 10:48:07 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_unsignedLONG64:
		return soap_in_unsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_SRMv2__TStatusCode:
		return soap_in_SRMv2__TStatusCode(soap, NULL, NULL, "SRMv2:TStatusCode");
	case SOAP_TYPE_SRMv2__TConnectionType:
		return soap_in_SRMv2__TConnectionType(soap, NULL, NULL, "SRMv2:TConnectionType");
	case SOAP_TYPE_SRMv2__TAccessPattern:
		return soap_in_SRMv2__TAccessPattern(soap, NULL, NULL, "SRMv2:TAccessPattern");
	case SOAP_TYPE_SRMv2__TFileLocality:
		return soap_in_SRMv2__TFileLocality(soap, NULL, NULL, "SRMv2:TFileLocality");
	case SOAP_TYPE_SRMv2__TOverwriteMode:
		return soap_in_SRMv2__TOverwriteMode(soap, NULL, NULL, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_SRMv2__TRequestType:
		return soap_in_SRMv2__TRequestType(soap, NULL, NULL, "SRMv2:TRequestType");
	case SOAP_TYPE_SRMv2__TPermissionType:
		return soap_in_SRMv2__TPermissionType(soap, NULL, NULL, "SRMv2:TPermissionType");
	case SOAP_TYPE_SRMv2__TPermissionMode:
		return soap_in_SRMv2__TPermissionMode(soap, NULL, NULL, "SRMv2:TPermissionMode");
	case SOAP_TYPE_SRMv2__TAccessLatency:
		return soap_in_SRMv2__TAccessLatency(soap, NULL, NULL, "SRMv2:TAccessLatency");
	case SOAP_TYPE_SRMv2__TRetentionPolicy:
		return soap_in_SRMv2__TRetentionPolicy(soap, NULL, NULL, "SRMv2:TRetentionPolicy");
	case SOAP_TYPE_SRMv2__TFileType:
		return soap_in_SRMv2__TFileType(soap, NULL, NULL, "SRMv2:TFileType");
	case SOAP_TYPE_SRMv2__TFileStorageType:
		return soap_in_SRMv2__TFileStorageType(soap, NULL, NULL, "SRMv2:TFileStorageType");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_SRMv2__srmPingResponse:
		return soap_in_SRMv2__srmPingResponse(soap, NULL, NULL, "SRMv2:srmPingResponse");
	case SOAP_TYPE_SRMv2__srmPingRequest:
		return soap_in_SRMv2__srmPingRequest(soap, NULL, NULL, "SRMv2:srmPingRequest");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse:
		return soap_in_SRMv2__srmGetTransferProtocolsResponse(soap, NULL, NULL, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest:
		return soap_in_SRMv2__srmGetTransferProtocolsRequest(soap, NULL, NULL, "SRMv2:srmGetTransferProtocolsRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse:
		return soap_in_SRMv2__srmGetRequestTokensResponse(soap, NULL, NULL, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensRequest:
		return soap_in_SRMv2__srmGetRequestTokensRequest(soap, NULL, NULL, "SRMv2:srmGetRequestTokensRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return soap_in_SRMv2__srmResumeRequestResponse(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return soap_in_SRMv2__srmResumeRequestRequest(soap, NULL, NULL, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return soap_in_SRMv2__srmSuspendRequestResponse(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return soap_in_SRMv2__srmSuspendRequestRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return soap_in_SRMv2__srmAbortFilesResponse(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return soap_in_SRMv2__srmAbortFilesRequest(soap, NULL, NULL, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return soap_in_SRMv2__srmAbortRequestResponse(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return soap_in_SRMv2__srmAbortRequestRequest(soap, NULL, NULL, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return soap_in_SRMv2__srmPutDoneResponse(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return soap_in_SRMv2__srmPutDoneRequest(soap, NULL, NULL, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return soap_in_SRMv2__srmReleaseFilesResponse(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return soap_in_SRMv2__srmReleaseFilesRequest(soap, NULL, NULL, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return soap_in_SRMv2__srmCopyResponse(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return soap_in_SRMv2__srmCopyRequest(soap, NULL, NULL, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return soap_in_SRMv2__srmPrepareToPutResponse(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return soap_in_SRMv2__srmPrepareToPutRequest(soap, NULL, NULL, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse:
		return soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest:
		return soap_in_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequestRequest");
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse:
		return soap_in_SRMv2__srmBringOnlineResponse(soap, NULL, NULL, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_SRMv2__srmBringOnlineRequest:
		return soap_in_SRMv2__srmBringOnlineRequest(soap, NULL, NULL, "SRMv2:srmBringOnlineRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return soap_in_SRMv2__srmPrepareToGetResponse(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return soap_in_SRMv2__srmPrepareToGetRequest(soap, NULL, NULL, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return soap_in_SRMv2__srmMvResponse(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return soap_in_SRMv2__srmMvRequest(soap, NULL, NULL, "SRMv2:srmMvRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse:
		return soap_in_SRMv2__srmStatusOfLsRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest:
		return soap_in_SRMv2__srmStatusOfLsRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequestRequest");
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return soap_in_SRMv2__srmLsResponse(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return soap_in_SRMv2__srmLsRequest(soap, NULL, NULL, "SRMv2:srmLsRequest");
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return soap_in_SRMv2__srmRmResponse(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return soap_in_SRMv2__srmRmRequest(soap, NULL, NULL, "SRMv2:srmRmRequest");
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return soap_in_SRMv2__srmRmdirResponse(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return soap_in_SRMv2__srmRmdirRequest(soap, NULL, NULL, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return soap_in_SRMv2__srmMkdirResponse(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return soap_in_SRMv2__srmMkdirRequest(soap, NULL, NULL, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse:
		return soap_in_SRMv2__srmGetPermissionResponse(soap, NULL, NULL, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetPermissionRequest:
		return soap_in_SRMv2__srmGetPermissionRequest(soap, NULL, NULL, "SRMv2:srmGetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return soap_in_SRMv2__srmCheckPermissionResponse(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return soap_in_SRMv2__srmCheckPermissionRequest(soap, NULL, NULL, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return soap_in_SRMv2__srmSetPermissionResponse(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return soap_in_SRMv2__srmSetPermissionRequest(soap, NULL, NULL, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse:
		return soap_in_SRMv2__srmGetSpaceTokensResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest:
		return soap_in_SRMv2__srmGetSpaceTokensRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceTokensRequest");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse:
		return soap_in_SRMv2__srmPurgeFromSpaceResponse(soap, NULL, NULL, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest:
		return soap_in_SRMv2__srmPurgeFromSpaceRequest(soap, NULL, NULL, "SRMv2:srmPurgeFromSpaceRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse:
		return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest:
		return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequestRequest");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse:
		return soap_in_SRMv2__srmChangeSpaceForFilesResponse(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest:
		return soap_in_SRMv2__srmChangeSpaceForFilesRequest(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFilesRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse:
		return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest:
		return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequestRequest");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return soap_in_SRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return soap_in_SRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return soap_in_SRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return soap_in_SRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse:
		return soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest:
		return soap_in_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequestRequest");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return soap_in_SRMv2__srmReserveSpaceResponse(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return soap_in_SRMv2__srmReserveSpaceRequest(soap, NULL, NULL, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol:
		return soap_in_SRMv2__ArrayOfTSupportedTransferProtocol(soap, NULL, NULL, "SRMv2:ArrayOfTSupportedTransferProtocol");
	case SOAP_TYPE_SRMv2__TSupportedTransferProtocol:
		return soap_in_SRMv2__TSupportedTransferProtocol(soap, NULL, NULL, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn:
		return soap_in_SRMv2__ArrayOfTRequestTokenReturn(soap, NULL, NULL, "SRMv2:ArrayOfTRequestTokenReturn");
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return soap_in_SRMv2__TRequestTokenReturn(soap, NULL, NULL, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn:
		return soap_in_SRMv2__ArrayOfTPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTPermissionReturn");
	case SOAP_TYPE_SRMv2__TPermissionReturn:
		return soap_in_SRMv2__TPermissionReturn(soap, NULL, NULL, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return soap_in_SRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return soap_in_SRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return soap_in_SRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return soap_in_SRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return soap_in_SRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTBringOnlineRequestFileStatus");
	case SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus:
		return soap_in_SRMv2__TBringOnlineRequestFileStatus(soap, NULL, NULL, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return soap_in_SRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return soap_in_SRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return soap_in_SRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return soap_in_SRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return soap_in_SRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return soap_in_SRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_SRMv2__TTransferParameters:
		return soap_in_SRMv2__TTransferParameters(soap, NULL, NULL, "SRMv2:TTransferParameters");
	case SOAP_TYPE_SRMv2__ArrayOfAnyURI:
		return soap_in_SRMv2__ArrayOfAnyURI(soap, NULL, NULL, "SRMv2:ArrayOfAnyURI");
	case SOAP_TYPE_SRMv2__ArrayOfTExtraInfo:
		return soap_in_SRMv2__ArrayOfTExtraInfo(soap, NULL, NULL, "SRMv2:ArrayOfTExtraInfo");
	case SOAP_TYPE_SRMv2__TExtraInfo:
		return soap_in_SRMv2__TExtraInfo(soap, NULL, NULL, "SRMv2:TExtraInfo");
	case SOAP_TYPE_SRMv2__TDirOption:
		return soap_in_SRMv2__TDirOption(soap, NULL, NULL, "SRMv2:TDirOption");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return soap_in_SRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return soap_in_SRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus:
		return soap_in_SRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLLifetimeReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus:
		return soap_in_SRMv2__TSURLLifetimeReturnStatus(soap, NULL, NULL, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return soap_in_SRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return soap_in_SRMv2__TReturnStatus(soap, NULL, NULL, "SRMv2:TReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfString:
		return soap_in_SRMv2__ArrayOfString(soap, NULL, NULL, "SRMv2:ArrayOfString");
	case SOAP_TYPE_SRMv2__ArrayOfUnsignedLong:
		return soap_in_SRMv2__ArrayOfUnsignedLong(soap, NULL, NULL, "SRMv2:ArrayOfUnsignedLong");
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return soap_in_SRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return soap_in_SRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return soap_in_SRMv2__ArrayOfTUserPermission(soap, NULL, NULL, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_SRMv2__TUserPermission:
		return soap_in_SRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_SRMv2__TRetentionPolicyInfo:
		return soap_in_SRMv2__TRetentionPolicyInfo(soap, NULL, NULL, "SRMv2:TRetentionPolicyInfo");
	case SOAP_TYPE_SRMv2__srmPing:
		return soap_in_SRMv2__srmPing(soap, NULL, NULL, "SRMv2:srmPing");
	case SOAP_TYPE_SRMv2__srmPingResponse_:
		return soap_in_SRMv2__srmPingResponse_(soap, NULL, NULL, "SRMv2:srmPingResponse");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocols:
		return soap_in_SRMv2__srmGetTransferProtocols(soap, NULL, NULL, "SRMv2:srmGetTransferProtocols");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_:
		return soap_in_SRMv2__srmGetTransferProtocolsResponse_(soap, NULL, NULL, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestTokens:
		return soap_in_SRMv2__srmGetRequestTokens(soap, NULL, NULL, "SRMv2:srmGetRequestTokens");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_:
		return soap_in_SRMv2__srmGetRequestTokensResponse_(soap, NULL, NULL, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return soap_in_SRMv2__srmExtendFileLifeTime(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTime");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return soap_in_SRMv2__srmExtendFileLifeTimeResponse_(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return soap_in_SRMv2__srmGetRequestSummary(soap, NULL, NULL, "SRMv2:srmGetRequestSummary");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return soap_in_SRMv2__srmGetRequestSummaryResponse_(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return soap_in_SRMv2__srmResumeRequest(soap, NULL, NULL, "SRMv2:srmResumeRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return soap_in_SRMv2__srmResumeRequestResponse_(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return soap_in_SRMv2__srmSuspendRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return soap_in_SRMv2__srmSuspendRequestResponse_(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return soap_in_SRMv2__srmAbortFiles(soap, NULL, NULL, "SRMv2:srmAbortFiles");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return soap_in_SRMv2__srmAbortFilesResponse_(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return soap_in_SRMv2__srmAbortRequest(soap, NULL, NULL, "SRMv2:srmAbortRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return soap_in_SRMv2__srmAbortRequestResponse_(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmPutDone:
		return soap_in_SRMv2__srmPutDone(soap, NULL, NULL, "SRMv2:srmPutDone");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return soap_in_SRMv2__srmPutDoneResponse_(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return soap_in_SRMv2__srmReleaseFiles(soap, NULL, NULL, "SRMv2:srmReleaseFiles");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return soap_in_SRMv2__srmReleaseFilesResponse_(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return soap_in_SRMv2__srmStatusOfCopyRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return soap_in_SRMv2__srmStatusOfCopyRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmCopy:
		return soap_in_SRMv2__srmCopy(soap, NULL, NULL, "SRMv2:srmCopy");
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return soap_in_SRMv2__srmCopyResponse_(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return soap_in_SRMv2__srmStatusOfPutRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return soap_in_SRMv2__srmStatusOfPutRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return soap_in_SRMv2__srmPrepareToPut(soap, NULL, NULL, "SRMv2:srmPrepareToPut");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return soap_in_SRMv2__srmPrepareToPutResponse_(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest:
		return soap_in_SRMv2__srmStatusOfBringOnlineRequest(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_:
		return soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_SRMv2__srmBringOnline:
		return soap_in_SRMv2__srmBringOnline(soap, NULL, NULL, "SRMv2:srmBringOnline");
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse_:
		return soap_in_SRMv2__srmBringOnlineResponse_(soap, NULL, NULL, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return soap_in_SRMv2__srmStatusOfGetRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return soap_in_SRMv2__srmStatusOfGetRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return soap_in_SRMv2__srmPrepareToGet(soap, NULL, NULL, "SRMv2:srmPrepareToGet");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return soap_in_SRMv2__srmPrepareToGetResponse_(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmMv:
		return soap_in_SRMv2__srmMv(soap, NULL, NULL, "SRMv2:srmMv");
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return soap_in_SRMv2__srmMvResponse_(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequest:
		return soap_in_SRMv2__srmStatusOfLsRequest(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_:
		return soap_in_SRMv2__srmStatusOfLsRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_SRMv2__srmLs:
		return soap_in_SRMv2__srmLs(soap, NULL, NULL, "SRMv2:srmLs");
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return soap_in_SRMv2__srmLsResponse_(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmRm:
		return soap_in_SRMv2__srmRm(soap, NULL, NULL, "SRMv2:srmRm");
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return soap_in_SRMv2__srmRmResponse_(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmdir:
		return soap_in_SRMv2__srmRmdir(soap, NULL, NULL, "SRMv2:srmRmdir");
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return soap_in_SRMv2__srmRmdirResponse_(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdir:
		return soap_in_SRMv2__srmMkdir(soap, NULL, NULL, "SRMv2:srmMkdir");
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return soap_in_SRMv2__srmMkdirResponse_(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmGetPermission:
		return soap_in_SRMv2__srmGetPermission(soap, NULL, NULL, "SRMv2:srmGetPermission");
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse_:
		return soap_in_SRMv2__srmGetPermissionResponse_(soap, NULL, NULL, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return soap_in_SRMv2__srmCheckPermission(soap, NULL, NULL, "SRMv2:srmCheckPermission");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return soap_in_SRMv2__srmCheckPermissionResponse_(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return soap_in_SRMv2__srmSetPermission(soap, NULL, NULL, "SRMv2:srmSetPermission");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return soap_in_SRMv2__srmSetPermissionResponse_(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokens:
		return soap_in_SRMv2__srmGetSpaceTokens(soap, NULL, NULL, "SRMv2:srmGetSpaceTokens");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_:
		return soap_in_SRMv2__srmGetSpaceTokensResponse_(soap, NULL, NULL, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpace:
		return soap_in_SRMv2__srmPurgeFromSpace(soap, NULL, NULL, "SRMv2:srmPurgeFromSpace");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_:
		return soap_in_SRMv2__srmPurgeFromSpaceResponse_(soap, NULL, NULL, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace:
		return soap_in_SRMv2__srmExtendFileLifeTimeInSpace(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpace");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_:
		return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse_(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest:
		return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequest(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_:
		return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFiles:
		return soap_in_SRMv2__srmChangeSpaceForFiles(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFiles");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_:
		return soap_in_SRMv2__srmChangeSpaceForFilesResponse_(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return soap_in_SRMv2__srmGetSpaceMetaData(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaData");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return soap_in_SRMv2__srmGetSpaceMetaDataResponse_(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest:
		return soap_in_SRMv2__srmStatusOfUpdateSpaceRequest(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_:
		return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return soap_in_SRMv2__srmUpdateSpace(soap, NULL, NULL, "SRMv2:srmUpdateSpace");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return soap_in_SRMv2__srmUpdateSpaceResponse_(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return soap_in_SRMv2__srmReleaseSpace(soap, NULL, NULL, "SRMv2:srmReleaseSpace");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return soap_in_SRMv2__srmReleaseSpaceResponse_(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest:
		return soap_in_SRMv2__srmStatusOfReserveSpaceRequest(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_:
		return soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse_(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return soap_in_SRMv2__srmReserveSpace(soap, NULL, NULL, "SRMv2:srmReserveSpace");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return soap_in_SRMv2__srmReserveSpaceResponse_(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPingRequest:
		return soap_in_PointerToSRMv2__srmPingRequest(soap, NULL, NULL, "SRMv2:srmPingRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPingResponse:
		return soap_in_PointerToSRMv2__srmPingResponse(soap, NULL, NULL, "SRMv2:srmPingResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsRequest:
		return soap_in_PointerToSRMv2__srmGetTransferProtocolsRequest(soap, NULL, NULL, "SRMv2:srmGetTransferProtocolsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsResponse:
		return soap_in_PointerToSRMv2__srmGetTransferProtocolsResponse(soap, NULL, NULL, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensRequest:
		return soap_in_PointerToSRMv2__srmGetRequestTokensRequest(soap, NULL, NULL, "SRMv2:srmGetRequestTokensRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensResponse:
		return soap_in_PointerToSRMv2__srmGetRequestTokensResponse(soap, NULL, NULL, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		return soap_in_PointerToSRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		return soap_in_PointerToSRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		return soap_in_PointerToSRMv2__srmResumeRequestRequest(soap, NULL, NULL, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		return soap_in_PointerToSRMv2__srmResumeRequestResponse(soap, NULL, NULL, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		return soap_in_PointerToSRMv2__srmSuspendRequestRequest(soap, NULL, NULL, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		return soap_in_PointerToSRMv2__srmSuspendRequestResponse(soap, NULL, NULL, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		return soap_in_PointerToSRMv2__srmAbortFilesRequest(soap, NULL, NULL, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		return soap_in_PointerToSRMv2__srmAbortFilesResponse(soap, NULL, NULL, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		return soap_in_PointerToSRMv2__srmAbortRequestRequest(soap, NULL, NULL, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		return soap_in_PointerToSRMv2__srmAbortRequestResponse(soap, NULL, NULL, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		return soap_in_PointerToSRMv2__srmPutDoneRequest(soap, NULL, NULL, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		return soap_in_PointerToSRMv2__srmPutDoneResponse(soap, NULL, NULL, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		return soap_in_PointerToSRMv2__srmReleaseFilesRequest(soap, NULL, NULL, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		return soap_in_PointerToSRMv2__srmReleaseFilesResponse(soap, NULL, NULL, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		return soap_in_PointerToSRMv2__srmCopyRequest(soap, NULL, NULL, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		return soap_in_PointerToSRMv2__srmCopyResponse(soap, NULL, NULL, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		return soap_in_PointerToSRMv2__srmPrepareToPutRequest(soap, NULL, NULL, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		return soap_in_PointerToSRMv2__srmPrepareToPutResponse(soap, NULL, NULL, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineRequest:
		return soap_in_PointerToSRMv2__srmBringOnlineRequest(soap, NULL, NULL, "SRMv2:srmBringOnlineRequest");
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineResponse:
		return soap_in_PointerToSRMv2__srmBringOnlineResponse(soap, NULL, NULL, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		return soap_in_PointerToSRMv2__srmPrepareToGetRequest(soap, NULL, NULL, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		return soap_in_PointerToSRMv2__srmPrepareToGetResponse(soap, NULL, NULL, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		return soap_in_PointerToSRMv2__srmMvRequest(soap, NULL, NULL, "SRMv2:srmMvRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		return soap_in_PointerToSRMv2__srmMvResponse(soap, NULL, NULL, "SRMv2:srmMvResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfLsRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfLsRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		return soap_in_PointerToSRMv2__srmLsRequest(soap, NULL, NULL, "SRMv2:srmLsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		return soap_in_PointerToSRMv2__srmLsResponse(soap, NULL, NULL, "SRMv2:srmLsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		return soap_in_PointerToSRMv2__srmRmRequest(soap, NULL, NULL, "SRMv2:srmRmRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		return soap_in_PointerToSRMv2__srmRmResponse(soap, NULL, NULL, "SRMv2:srmRmResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		return soap_in_PointerToSRMv2__srmRmdirRequest(soap, NULL, NULL, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		return soap_in_PointerToSRMv2__srmRmdirResponse(soap, NULL, NULL, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		return soap_in_PointerToSRMv2__srmMkdirRequest(soap, NULL, NULL, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		return soap_in_PointerToSRMv2__srmMkdirResponse(soap, NULL, NULL, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionRequest:
		return soap_in_PointerToSRMv2__srmGetPermissionRequest(soap, NULL, NULL, "SRMv2:srmGetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionResponse:
		return soap_in_PointerToSRMv2__srmGetPermissionResponse(soap, NULL, NULL, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		return soap_in_PointerToSRMv2__srmCheckPermissionRequest(soap, NULL, NULL, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		return soap_in_PointerToSRMv2__srmCheckPermissionResponse(soap, NULL, NULL, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		return soap_in_PointerToSRMv2__srmSetPermissionRequest(soap, NULL, NULL, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		return soap_in_PointerToSRMv2__srmSetPermissionResponse(soap, NULL, NULL, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensRequest:
		return soap_in_PointerToSRMv2__srmGetSpaceTokensRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceTokensRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensResponse:
		return soap_in_PointerToSRMv2__srmGetSpaceTokensResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceRequest:
		return soap_in_PointerToSRMv2__srmPurgeFromSpaceRequest(soap, NULL, NULL, "SRMv2:srmPurgeFromSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceResponse:
		return soap_in_PointerToSRMv2__srmPurgeFromSpaceResponse(soap, NULL, NULL, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse:
		return soap_in_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, NULL, NULL, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesRequest:
		return soap_in_PointerToSRMv2__srmChangeSpaceForFilesRequest(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesResponse:
		return soap_in_PointerToSRMv2__srmChangeSpaceForFilesResponse(soap, NULL, NULL, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		return soap_in_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		return soap_in_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		return soap_in_PointerToSRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		return soap_in_PointerToSRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		return soap_in_PointerToSRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		return soap_in_PointerToSRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest:
		return soap_in_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse:
		return soap_in_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse(soap, NULL, NULL, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		return soap_in_PointerToSRMv2__srmReserveSpaceRequest(soap, NULL, NULL, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		return soap_in_PointerToSRMv2__srmReserveSpaceResponse(soap, NULL, NULL, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSupportedTransferProtocol:
		return soap_in_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, NULL, NULL, "SRMv2:ArrayOfTSupportedTransferProtocol");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestTokenReturn:
		return soap_in_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, NULL, NULL, "SRMv2:ArrayOfTRequestTokenReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		return soap_in_PointerToSRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		return soap_in_PointerToSRMv2__TOverwriteMode(soap, NULL, NULL, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		return soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		return soap_in_PointerToSRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPermissionReturn:
		return soap_in_PointerToSRMv2__ArrayOfTPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		return soap_in_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus:
		return soap_in_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		return soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfAnyURI:
		return soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, NULL, NULL, "SRMv2:ArrayOfAnyURI");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		return soap_in_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TTransferParameters:
		return soap_in_PointerToSRMv2__TTransferParameters(soap, NULL, NULL, "SRMv2:TTransferParameters");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfUnsignedLong:
		return soap_in_PointerToSRMv2__ArrayOfUnsignedLong(soap, NULL, NULL, "SRMv2:ArrayOfUnsignedLong");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSupportedTransferProtocol:
		return soap_in_PointerToPointerToSRMv2__TSupportedTransferProtocol(soap, NULL, NULL, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_PointerToSRMv2__TSupportedTransferProtocol:
		return soap_in_PointerToSRMv2__TSupportedTransferProtocol(soap, NULL, NULL, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestTokenReturn:
		return soap_in_PointerToPointerToSRMv2__TRequestTokenReturn(soap, NULL, NULL, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_PointerToSRMv2__TRequestTokenReturn:
		return soap_in_PointerToSRMv2__TRequestTokenReturn(soap, NULL, NULL, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPermissionReturn:
		return soap_in_PointerToPointerToSRMv2__TPermissionReturn(soap, NULL, NULL, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TPermissionReturn:
		return soap_in_PointerToSRMv2__TPermissionReturn(soap, NULL, NULL, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		return soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		return soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, NULL, NULL, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		return soap_in_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		return soap_in_PointerToSRMv2__TSURLPermissionReturn(soap, NULL, NULL, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		return soap_in_PointerToPointerToSRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		return soap_in_PointerToSRMv2__TRequestSummary(soap, NULL, NULL, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		return soap_in_PointerToSRMv2__TRequestType(soap, NULL, NULL, "SRMv2:TRequestType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		return soap_in_PointerToSRMv2__TCopyRequestFileStatus(soap, NULL, NULL, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		return soap_in_PointerToSRMv2__TPutRequestFileStatus(soap, NULL, NULL, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus(soap, NULL, NULL, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TBringOnlineRequestFileStatus:
		return soap_in_PointerToSRMv2__TBringOnlineRequestFileStatus(soap, NULL, NULL, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		return soap_in_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		return soap_in_PointerToSRMv2__TGetRequestFileStatus(soap, NULL, NULL, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTExtraInfo:
		return soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, NULL, NULL, "SRMv2:ArrayOfTExtraInfo");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		return soap_in_PointerToPointerToSRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		return soap_in_PointerToSRMv2__TCopyFileRequest(soap, NULL, NULL, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		return soap_in_PointerToPointerToSRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		return soap_in_PointerToSRMv2__TPutFileRequest(soap, NULL, NULL, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		return soap_in_PointerToPointerToSRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		return soap_in_PointerToSRMv2__TGetFileRequest(soap, NULL, NULL, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		return soap_in_PointerToSRMv2__TDirOption(soap, NULL, NULL, "SRMv2:TDirOption");
	case SOAP_TYPE_PointerToSRMv2__TConnectionType:
		return soap_in_PointerToSRMv2__TConnectionType(soap, NULL, NULL, "SRMv2:TConnectionType");
	case SOAP_TYPE_PointerToSRMv2__TAccessPattern:
		return soap_in_PointerToSRMv2__TAccessPattern(soap, NULL, NULL, "SRMv2:TAccessPattern");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_in_PointerToxsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
	case SOAP_TYPE_PointerToPointerToSRMv2__TExtraInfo:
		return soap_in_PointerToPointerToSRMv2__TExtraInfo(soap, NULL, NULL, "SRMv2:TExtraInfo");
	case SOAP_TYPE_PointerToSRMv2__TExtraInfo:
		return soap_in_PointerToSRMv2__TExtraInfo(soap, NULL, NULL, "SRMv2:TExtraInfo");
	case SOAP_TYPE_PointerTobool:
		return soap_in_PointerTobool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		return soap_in_PointerToPointerToSRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		return soap_in_PointerToSRMv2__TMetaDataSpace(soap, NULL, NULL, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		return soap_in_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		return soap_in_PointerToSRMv2__TMetaDataPathDetail(soap, NULL, NULL, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		return soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TPermissionMode:
		return soap_in_PointerToSRMv2__TPermissionMode(soap, NULL, NULL, "SRMv2:TPermissionMode");
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		return soap_in_PointerToSRMv2__TFileType(soap, NULL, NULL, "SRMv2:TFileType");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfString:
		return soap_in_PointerToSRMv2__ArrayOfString(soap, NULL, NULL, "SRMv2:ArrayOfString");
	case SOAP_TYPE_PointerToSRMv2__TFileLocality:
		return soap_in_PointerToSRMv2__TFileLocality(soap, NULL, NULL, "SRMv2:TFileLocality");
	case SOAP_TYPE_PointerToSRMv2__TRetentionPolicyInfo:
		return soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, NULL, NULL, "SRMv2:TRetentionPolicyInfo");
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		return soap_in_PointerToSRMv2__TFileStorageType(soap, NULL, NULL, "SRMv2:TFileStorageType");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus:
		return soap_in_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus(soap, NULL, NULL, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLLifetimeReturnStatus:
		return soap_in_PointerToSRMv2__TSURLLifetimeReturnStatus(soap, NULL, NULL, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToint:
		return soap_in_PointerToint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		return soap_in_PointerToPointerToSRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		return soap_in_PointerToSRMv2__TSURLReturnStatus(soap, NULL, NULL, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		return soap_in_PointerToSRMv2__TReturnStatus(soap, NULL, NULL, "SRMv2:TReturnStatus");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_in_PointerTounsignedLONG64(soap, NULL, NULL, "xsd:unsignedLong");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		return soap_in_PointerToPointerToSRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		return soap_in_PointerToSRMv2__TGroupPermission(soap, NULL, NULL, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		return soap_in_PointerToPointerToSRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		return soap_in_PointerToSRMv2__TUserPermission(soap, NULL, NULL, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TAccessLatency:
		return soap_in_PointerToSRMv2__TAccessLatency(soap, NULL, NULL, "SRMv2:TAccessLatency");
	case SOAP_TYPE_xsd__anyURI:
	{	char **s;
		s = soap_in_xsd__anyURI(soap, NULL, NULL, "xsd:anyURI");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedLong"))
		{	*type = SOAP_TYPE_unsignedLONG64;
			return soap_in_unsignedLONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TStatusCode"))
		{	*type = SOAP_TYPE_SRMv2__TStatusCode;
			return soap_in_SRMv2__TStatusCode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TConnectionType"))
		{	*type = SOAP_TYPE_SRMv2__TConnectionType;
			return soap_in_SRMv2__TConnectionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TAccessPattern"))
		{	*type = SOAP_TYPE_SRMv2__TAccessPattern;
			return soap_in_SRMv2__TAccessPattern(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TFileLocality"))
		{	*type = SOAP_TYPE_SRMv2__TFileLocality;
			return soap_in_SRMv2__TFileLocality(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TOverwriteMode"))
		{	*type = SOAP_TYPE_SRMv2__TOverwriteMode;
			return soap_in_SRMv2__TOverwriteMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestType"))
		{	*type = SOAP_TYPE_SRMv2__TRequestType;
			return soap_in_SRMv2__TRequestType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPermissionType"))
		{	*type = SOAP_TYPE_SRMv2__TPermissionType;
			return soap_in_SRMv2__TPermissionType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPermissionMode"))
		{	*type = SOAP_TYPE_SRMv2__TPermissionMode;
			return soap_in_SRMv2__TPermissionMode(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TAccessLatency"))
		{	*type = SOAP_TYPE_SRMv2__TAccessLatency;
			return soap_in_SRMv2__TAccessLatency(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRetentionPolicy"))
		{	*type = SOAP_TYPE_SRMv2__TRetentionPolicy;
			return soap_in_SRMv2__TRetentionPolicy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TFileType"))
		{	*type = SOAP_TYPE_SRMv2__TFileType;
			return soap_in_SRMv2__TFileType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TFileStorageType"))
		{	*type = SOAP_TYPE_SRMv2__TFileStorageType;
			return soap_in_SRMv2__TFileStorageType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPingResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPingResponse;
			return soap_in_SRMv2__srmPingResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPingRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPingRequest;
			return soap_in_SRMv2__srmPingRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetTransferProtocolsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse;
			return soap_in_SRMv2__srmGetTransferProtocolsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetTransferProtocolsRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest;
			return soap_in_SRMv2__srmGetTransferProtocolsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestTokensResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestTokensResponse;
			return soap_in_SRMv2__srmGetRequestTokensResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestTokensRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestTokensRequest;
			return soap_in_SRMv2__srmGetRequestTokensRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse;
			return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest;
			return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse;
			return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest;
			return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestResponse;
			return soap_in_SRMv2__srmResumeRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestRequest;
			return soap_in_SRMv2__srmResumeRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestResponse;
			return soap_in_SRMv2__srmSuspendRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestRequest;
			return soap_in_SRMv2__srmSuspendRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesResponse;
			return soap_in_SRMv2__srmAbortFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesRequest;
			return soap_in_SRMv2__srmAbortFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestResponse;
			return soap_in_SRMv2__srmAbortRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestRequest;
			return soap_in_SRMv2__srmAbortRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneResponse;
			return soap_in_SRMv2__srmPutDoneResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneRequest;
			return soap_in_SRMv2__srmPutDoneRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesResponse;
			return soap_in_SRMv2__srmReleaseFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesRequest;
			return soap_in_SRMv2__srmReleaseFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse;
			return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest;
			return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyResponse;
			return soap_in_SRMv2__srmCopyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyRequest;
			return soap_in_SRMv2__srmCopyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse;
			return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest;
			return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutResponse;
			return soap_in_SRMv2__srmPrepareToPutResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutRequest;
			return soap_in_SRMv2__srmPrepareToPutRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfBringOnlineRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse;
			return soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfBringOnlineRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest;
			return soap_in_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmBringOnlineResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmBringOnlineResponse;
			return soap_in_SRMv2__srmBringOnlineResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmBringOnlineRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmBringOnlineRequest;
			return soap_in_SRMv2__srmBringOnlineRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse;
			return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest;
			return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetResponse;
			return soap_in_SRMv2__srmPrepareToGetResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetRequest;
			return soap_in_SRMv2__srmPrepareToGetRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMvResponse;
			return soap_in_SRMv2__srmMvResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmMvRequest;
			return soap_in_SRMv2__srmMvRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfLsRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse;
			return soap_in_SRMv2__srmStatusOfLsRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfLsRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest;
			return soap_in_SRMv2__srmStatusOfLsRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmLsResponse;
			return soap_in_SRMv2__srmLsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmLsRequest;
			return soap_in_SRMv2__srmLsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmResponse;
			return soap_in_SRMv2__srmRmResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmRmRequest;
			return soap_in_SRMv2__srmRmRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirResponse;
			return soap_in_SRMv2__srmRmdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirRequest;
			return soap_in_SRMv2__srmRmdirRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirResponse;
			return soap_in_SRMv2__srmMkdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirRequest;
			return soap_in_SRMv2__srmMkdirRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetPermissionResponse;
			return soap_in_SRMv2__srmGetPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetPermissionRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetPermissionRequest;
			return soap_in_SRMv2__srmGetPermissionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionResponse;
			return soap_in_SRMv2__srmCheckPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionRequest;
			return soap_in_SRMv2__srmCheckPermissionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionResponse;
			return soap_in_SRMv2__srmSetPermissionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionRequest;
			return soap_in_SRMv2__srmSetPermissionRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokensResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse;
			return soap_in_SRMv2__srmGetSpaceTokensResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokensRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest;
			return soap_in_SRMv2__srmGetSpaceTokensRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPurgeFromSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse;
			return soap_in_SRMv2__srmPurgeFromSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPurgeFromSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest;
			return soap_in_SRMv2__srmPurgeFromSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeInSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse;
			return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeInSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest;
			return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse;
			return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfChangeSpaceForFilesRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest;
			return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeSpaceForFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse;
			return soap_in_SRMv2__srmChangeSpaceForFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeSpaceForFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest;
			return soap_in_SRMv2__srmChangeSpaceForFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse;
			return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest;
			return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfUpdateSpaceRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse;
			return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfUpdateSpaceRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest;
			return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceResponse;
			return soap_in_SRMv2__srmUpdateSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceRequest;
			return soap_in_SRMv2__srmUpdateSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceResponse;
			return soap_in_SRMv2__srmReleaseSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceRequest;
			return soap_in_SRMv2__srmReleaseSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfReserveSpaceRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse;
			return soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfReserveSpaceRequestRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest;
			return soap_in_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceResponse;
			return soap_in_SRMv2__srmReserveSpaceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceRequest;
			return soap_in_SRMv2__srmReserveSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSupportedTransferProtocol"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol;
			return soap_in_SRMv2__ArrayOfTSupportedTransferProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSupportedTransferProtocol"))
		{	*type = SOAP_TYPE_SRMv2__TSupportedTransferProtocol;
			return soap_in_SRMv2__TSupportedTransferProtocol(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTRequestTokenReturn"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn;
			return soap_in_SRMv2__ArrayOfTRequestTokenReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestTokenReturn"))
		{	*type = SOAP_TYPE_SRMv2__TRequestTokenReturn;
			return soap_in_SRMv2__TRequestTokenReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn;
			return soap_in_SRMv2__ArrayOfTPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__TPermissionReturn;
			return soap_in_SRMv2__TPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn;
			return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLPermissionReturn"))
		{	*type = SOAP_TYPE_SRMv2__TSURLPermissionReturn;
			return soap_in_SRMv2__TSURLPermissionReturn(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTRequestSummary;
			return soap_in_SRMv2__ArrayOfTRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__TRequestSummary;
			return soap_in_SRMv2__TRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTCopyRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCopyRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TCopyRequestFileStatus;
			return soap_in_SRMv2__TCopyRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTPutRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPutRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TPutRequestFileStatus;
			return soap_in_SRMv2__TPutRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTBringOnlineRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TBringOnlineRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus;
			return soap_in_SRMv2__TBringOnlineRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGetRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus;
			return soap_in_SRMv2__ArrayOfTGetRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGetRequestFileStatus"))
		{	*type = SOAP_TYPE_SRMv2__TGetRequestFileStatus;
			return soap_in_SRMv2__TGetRequestFileStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTCopyFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest;
			return soap_in_SRMv2__ArrayOfTCopyFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TCopyFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TCopyFileRequest;
			return soap_in_SRMv2__TCopyFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTPutFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest;
			return soap_in_SRMv2__ArrayOfTPutFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TPutFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TPutFileRequest;
			return soap_in_SRMv2__TPutFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGetFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest;
			return soap_in_SRMv2__ArrayOfTGetFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGetFileRequest"))
		{	*type = SOAP_TYPE_SRMv2__TGetFileRequest;
			return soap_in_SRMv2__TGetFileRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TTransferParameters"))
		{	*type = SOAP_TYPE_SRMv2__TTransferParameters;
			return soap_in_SRMv2__TTransferParameters(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfAnyURI"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfAnyURI;
			return soap_in_SRMv2__ArrayOfAnyURI(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTExtraInfo"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTExtraInfo;
			return soap_in_SRMv2__ArrayOfTExtraInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TExtraInfo"))
		{	*type = SOAP_TYPE_SRMv2__TExtraInfo;
			return soap_in_SRMv2__TExtraInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TDirOption"))
		{	*type = SOAP_TYPE_SRMv2__TDirOption;
			return soap_in_SRMv2__TDirOption(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTMetaDataSpace"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace;
			return soap_in_SRMv2__ArrayOfTMetaDataSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TMetaDataSpace"))
		{	*type = SOAP_TYPE_SRMv2__TMetaDataSpace;
			return soap_in_SRMv2__TMetaDataSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTMetaDataPathDetail"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail;
			return soap_in_SRMv2__ArrayOfTMetaDataPathDetail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TMetaDataPathDetail"))
		{	*type = SOAP_TYPE_SRMv2__TMetaDataPathDetail;
			return soap_in_SRMv2__TMetaDataPathDetail(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLLifetimeReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus;
			return soap_in_SRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLLifetimeReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus;
			return soap_in_SRMv2__TSURLLifetimeReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTSURLReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus;
			return soap_in_SRMv2__ArrayOfTSURLReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TSURLReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__TSURLReturnStatus;
			return soap_in_SRMv2__TSURLReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TReturnStatus"))
		{	*type = SOAP_TYPE_SRMv2__TReturnStatus;
			return soap_in_SRMv2__TReturnStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfString"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfString;
			return soap_in_SRMv2__ArrayOfString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfUnsignedLong"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfUnsignedLong;
			return soap_in_SRMv2__ArrayOfUnsignedLong(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTGroupPermission"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTGroupPermission;
			return soap_in_SRMv2__ArrayOfTGroupPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TGroupPermission"))
		{	*type = SOAP_TYPE_SRMv2__TGroupPermission;
			return soap_in_SRMv2__TGroupPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:ArrayOfTUserPermission"))
		{	*type = SOAP_TYPE_SRMv2__ArrayOfTUserPermission;
			return soap_in_SRMv2__ArrayOfTUserPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TUserPermission"))
		{	*type = SOAP_TYPE_SRMv2__TUserPermission;
			return soap_in_SRMv2__TUserPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:TRetentionPolicyInfo"))
		{	*type = SOAP_TYPE_SRMv2__TRetentionPolicyInfo;
			return soap_in_SRMv2__TRetentionPolicyInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPing"))
		{	*type = SOAP_TYPE_SRMv2__srmPing;
			return soap_in_SRMv2__srmPing(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPingResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPingResponse_;
			return soap_in_SRMv2__srmPingResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetTransferProtocols"))
		{	*type = SOAP_TYPE_SRMv2__srmGetTransferProtocols;
			return soap_in_SRMv2__srmGetTransferProtocols(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetTransferProtocolsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_;
			return soap_in_SRMv2__srmGetTransferProtocolsResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestTokens"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestTokens;
			return soap_in_SRMv2__srmGetRequestTokens(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestTokensResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_;
			return soap_in_SRMv2__srmGetRequestTokensResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTime"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTime;
			return soap_in_SRMv2__srmExtendFileLifeTime(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_;
			return soap_in_SRMv2__srmExtendFileLifeTimeResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummary"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummary;
			return soap_in_SRMv2__srmGetRequestSummary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetRequestSummaryResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_;
			return soap_in_SRMv2__srmGetRequestSummaryResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequest;
			return soap_in_SRMv2__srmResumeRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmResumeRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmResumeRequestResponse_;
			return soap_in_SRMv2__srmResumeRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequest;
			return soap_in_SRMv2__srmSuspendRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSuspendRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSuspendRequestResponse_;
			return soap_in_SRMv2__srmSuspendRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFiles;
			return soap_in_SRMv2__srmAbortFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortFilesResponse_;
			return soap_in_SRMv2__srmAbortFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequest;
			return soap_in_SRMv2__srmAbortRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmAbortRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmAbortRequestResponse_;
			return soap_in_SRMv2__srmAbortRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDone"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDone;
			return soap_in_SRMv2__srmPutDone(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPutDoneResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPutDoneResponse_;
			return soap_in_SRMv2__srmPutDoneResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFiles;
			return soap_in_SRMv2__srmReleaseFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseFilesResponse_;
			return soap_in_SRMv2__srmReleaseFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequest;
			return soap_in_SRMv2__srmStatusOfCopyRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfCopyRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_;
			return soap_in_SRMv2__srmStatusOfCopyRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopy"))
		{	*type = SOAP_TYPE_SRMv2__srmCopy;
			return soap_in_SRMv2__srmCopy(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCopyResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCopyResponse_;
			return soap_in_SRMv2__srmCopyResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequest;
			return soap_in_SRMv2__srmStatusOfPutRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfPutRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_;
			return soap_in_SRMv2__srmStatusOfPutRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPut"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPut;
			return soap_in_SRMv2__srmPrepareToPut(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToPutResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToPutResponse_;
			return soap_in_SRMv2__srmPrepareToPutResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfBringOnlineRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest;
			return soap_in_SRMv2__srmStatusOfBringOnlineRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfBringOnlineRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_;
			return soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmBringOnline"))
		{	*type = SOAP_TYPE_SRMv2__srmBringOnline;
			return soap_in_SRMv2__srmBringOnline(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmBringOnlineResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmBringOnlineResponse_;
			return soap_in_SRMv2__srmBringOnlineResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequest;
			return soap_in_SRMv2__srmStatusOfGetRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfGetRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_;
			return soap_in_SRMv2__srmStatusOfGetRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGet"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGet;
			return soap_in_SRMv2__srmPrepareToGet(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPrepareToGetResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPrepareToGetResponse_;
			return soap_in_SRMv2__srmPrepareToGetResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMv"))
		{	*type = SOAP_TYPE_SRMv2__srmMv;
			return soap_in_SRMv2__srmMv(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMvResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMvResponse_;
			return soap_in_SRMv2__srmMvResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfLsRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfLsRequest;
			return soap_in_SRMv2__srmStatusOfLsRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfLsRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_;
			return soap_in_SRMv2__srmStatusOfLsRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLs"))
		{	*type = SOAP_TYPE_SRMv2__srmLs;
			return soap_in_SRMv2__srmLs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmLsResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmLsResponse_;
			return soap_in_SRMv2__srmLsResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRm"))
		{	*type = SOAP_TYPE_SRMv2__srmRm;
			return soap_in_SRMv2__srmRm(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmResponse_;
			return soap_in_SRMv2__srmRmResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdir"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdir;
			return soap_in_SRMv2__srmRmdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmRmdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmRmdirResponse_;
			return soap_in_SRMv2__srmRmdirResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdir"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdir;
			return soap_in_SRMv2__srmMkdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmMkdirResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmMkdirResponse_;
			return soap_in_SRMv2__srmMkdirResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetPermission"))
		{	*type = SOAP_TYPE_SRMv2__srmGetPermission;
			return soap_in_SRMv2__srmGetPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetPermissionResponse_;
			return soap_in_SRMv2__srmGetPermissionResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermission"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermission;
			return soap_in_SRMv2__srmCheckPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmCheckPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmCheckPermissionResponse_;
			return soap_in_SRMv2__srmCheckPermissionResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermission"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermission;
			return soap_in_SRMv2__srmSetPermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmSetPermissionResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmSetPermissionResponse_;
			return soap_in_SRMv2__srmSetPermissionResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokens"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokens;
			return soap_in_SRMv2__srmGetSpaceTokens(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceTokensResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_;
			return soap_in_SRMv2__srmGetSpaceTokensResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPurgeFromSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmPurgeFromSpace;
			return soap_in_SRMv2__srmPurgeFromSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmPurgeFromSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_;
			return soap_in_SRMv2__srmPurgeFromSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeInSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace;
			return soap_in_SRMv2__srmExtendFileLifeTimeInSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmExtendFileLifeTimeInSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_;
			return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfChangeSpaceForFilesRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest;
			return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_;
			return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeSpaceForFiles"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeSpaceForFiles;
			return soap_in_SRMv2__srmChangeSpaceForFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmChangeSpaceForFilesResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_;
			return soap_in_SRMv2__srmChangeSpaceForFilesResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaData"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaData;
			return soap_in_SRMv2__srmGetSpaceMetaData(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmGetSpaceMetaDataResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_;
			return soap_in_SRMv2__srmGetSpaceMetaDataResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfUpdateSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest;
			return soap_in_SRMv2__srmStatusOfUpdateSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfUpdateSpaceRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_;
			return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpace;
			return soap_in_SRMv2__srmUpdateSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmUpdateSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_;
			return soap_in_SRMv2__srmUpdateSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpace;
			return soap_in_SRMv2__srmReleaseSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReleaseSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_;
			return soap_in_SRMv2__srmReleaseSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfReserveSpaceRequest"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest;
			return soap_in_SRMv2__srmStatusOfReserveSpaceRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmStatusOfReserveSpaceRequestResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_;
			return soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpace"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpace;
			return soap_in_SRMv2__srmReserveSpace(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "SRMv2:srmReserveSpaceResponse"))
		{	*type = SOAP_TYPE_SRMv2__srmReserveSpaceResponse_;
			return soap_in_SRMv2__srmReserveSpaceResponse_(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:anyURI"))
		{	char **s;
			*type = SOAP_TYPE_xsd__anyURI;
			s = soap_in_xsd__anyURI(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
			return soap->error = SOAP_TAG_MISMATCH;
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_unsignedLONG64:
		return soap_out_unsignedLONG64(soap, tag, id, (const ULONG64 *)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_SRMv2__TStatusCode:
		return soap_out_SRMv2__TStatusCode(soap, tag, id, (const enum SRMv2__TStatusCode *)ptr, "SRMv2:TStatusCode");
	case SOAP_TYPE_SRMv2__TConnectionType:
		return soap_out_SRMv2__TConnectionType(soap, tag, id, (const enum SRMv2__TConnectionType *)ptr, "SRMv2:TConnectionType");
	case SOAP_TYPE_SRMv2__TAccessPattern:
		return soap_out_SRMv2__TAccessPattern(soap, tag, id, (const enum SRMv2__TAccessPattern *)ptr, "SRMv2:TAccessPattern");
	case SOAP_TYPE_SRMv2__TFileLocality:
		return soap_out_SRMv2__TFileLocality(soap, tag, id, (const enum SRMv2__TFileLocality *)ptr, "SRMv2:TFileLocality");
	case SOAP_TYPE_SRMv2__TOverwriteMode:
		return soap_out_SRMv2__TOverwriteMode(soap, tag, id, (const enum SRMv2__TOverwriteMode *)ptr, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_SRMv2__TRequestType:
		return soap_out_SRMv2__TRequestType(soap, tag, id, (const enum SRMv2__TRequestType *)ptr, "SRMv2:TRequestType");
	case SOAP_TYPE_SRMv2__TPermissionType:
		return soap_out_SRMv2__TPermissionType(soap, tag, id, (const enum SRMv2__TPermissionType *)ptr, "SRMv2:TPermissionType");
	case SOAP_TYPE_SRMv2__TPermissionMode:
		return soap_out_SRMv2__TPermissionMode(soap, tag, id, (const enum SRMv2__TPermissionMode *)ptr, "SRMv2:TPermissionMode");
	case SOAP_TYPE_SRMv2__TAccessLatency:
		return soap_out_SRMv2__TAccessLatency(soap, tag, id, (const enum SRMv2__TAccessLatency *)ptr, "SRMv2:TAccessLatency");
	case SOAP_TYPE_SRMv2__TRetentionPolicy:
		return soap_out_SRMv2__TRetentionPolicy(soap, tag, id, (const enum SRMv2__TRetentionPolicy *)ptr, "SRMv2:TRetentionPolicy");
	case SOAP_TYPE_SRMv2__TFileType:
		return soap_out_SRMv2__TFileType(soap, tag, id, (const enum SRMv2__TFileType *)ptr, "SRMv2:TFileType");
	case SOAP_TYPE_SRMv2__TFileStorageType:
		return soap_out_SRMv2__TFileStorageType(soap, tag, id, (const enum SRMv2__TFileStorageType *)ptr, "SRMv2:TFileStorageType");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_SRMv2__srmPingResponse:
		return ((SRMv2__srmPingResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPingResponse");
	case SOAP_TYPE_SRMv2__srmPingRequest:
		return ((SRMv2__srmPingRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPingRequest");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse:
		return ((SRMv2__srmGetTransferProtocolsResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest:
		return ((SRMv2__srmGetTransferProtocolsRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetTransferProtocolsRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse:
		return ((SRMv2__srmGetRequestTokensResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensRequest:
		return ((SRMv2__srmGetRequestTokensRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestTokensRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return ((SRMv2__srmExtendFileLifeTimeResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return ((SRMv2__srmExtendFileLifeTimeRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return ((SRMv2__srmGetRequestSummaryResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return ((SRMv2__srmGetRequestSummaryRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return ((SRMv2__srmResumeRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return ((SRMv2__srmResumeRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return ((SRMv2__srmSuspendRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return ((SRMv2__srmSuspendRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return ((SRMv2__srmAbortFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return ((SRMv2__srmAbortFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return ((SRMv2__srmAbortRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return ((SRMv2__srmAbortRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return ((SRMv2__srmPutDoneResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return ((SRMv2__srmPutDoneRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return ((SRMv2__srmReleaseFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return ((SRMv2__srmReleaseFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return ((SRMv2__srmStatusOfCopyRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return ((SRMv2__srmStatusOfCopyRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return ((SRMv2__srmCopyResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return ((SRMv2__srmCopyRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return ((SRMv2__srmStatusOfPutRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return ((SRMv2__srmStatusOfPutRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return ((SRMv2__srmPrepareToPutResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return ((SRMv2__srmPrepareToPutRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse:
		return ((SRMv2__srmStatusOfBringOnlineRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest:
		return ((SRMv2__srmStatusOfBringOnlineRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfBringOnlineRequestRequest");
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse:
		return ((SRMv2__srmBringOnlineResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_SRMv2__srmBringOnlineRequest:
		return ((SRMv2__srmBringOnlineRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmBringOnlineRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return ((SRMv2__srmStatusOfGetRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return ((SRMv2__srmStatusOfGetRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return ((SRMv2__srmPrepareToGetResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return ((SRMv2__srmPrepareToGetRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return ((SRMv2__srmMvResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return ((SRMv2__srmMvRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMvRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse:
		return ((SRMv2__srmStatusOfLsRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest:
		return ((SRMv2__srmStatusOfLsRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfLsRequestRequest");
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return ((SRMv2__srmLsResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return ((SRMv2__srmLsRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmLsRequest");
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return ((SRMv2__srmRmResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return ((SRMv2__srmRmRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmRequest");
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return ((SRMv2__srmRmdirResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return ((SRMv2__srmRmdirRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return ((SRMv2__srmMkdirResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return ((SRMv2__srmMkdirRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse:
		return ((SRMv2__srmGetPermissionResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetPermissionRequest:
		return ((SRMv2__srmGetPermissionRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return ((SRMv2__srmCheckPermissionResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return ((SRMv2__srmCheckPermissionRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return ((SRMv2__srmSetPermissionResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return ((SRMv2__srmSetPermissionRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse:
		return ((SRMv2__srmGetSpaceTokensResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest:
		return ((SRMv2__srmGetSpaceTokensRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceTokensRequest");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse:
		return ((SRMv2__srmPurgeFromSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest:
		return ((SRMv2__srmPurgeFromSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmPurgeFromSpaceRequest");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse:
		return ((SRMv2__srmExtendFileLifeTimeInSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest:
		return ((SRMv2__srmExtendFileLifeTimeInSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmExtendFileLifeTimeInSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		return ((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		return ((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfChangeSpaceForFilesRequestRequest");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse:
		return ((SRMv2__srmChangeSpaceForFilesResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest:
		return ((SRMv2__srmChangeSpaceForFilesRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmChangeSpaceForFilesRequest");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return ((SRMv2__srmGetSpaceMetaDataResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return ((SRMv2__srmGetSpaceMetaDataRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse:
		return ((SRMv2__srmStatusOfUpdateSpaceRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest:
		return ((SRMv2__srmStatusOfUpdateSpaceRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfUpdateSpaceRequestRequest");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return ((SRMv2__srmUpdateSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return ((SRMv2__srmUpdateSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return ((SRMv2__srmReleaseSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return ((SRMv2__srmReleaseSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse:
		return ((SRMv2__srmStatusOfReserveSpaceRequestResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest:
		return ((SRMv2__srmStatusOfReserveSpaceRequestRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmStatusOfReserveSpaceRequestRequest");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return ((SRMv2__srmReserveSpaceResponse *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return ((SRMv2__srmReserveSpaceRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol:
		return ((SRMv2__ArrayOfTSupportedTransferProtocol *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSupportedTransferProtocol");
	case SOAP_TYPE_SRMv2__TSupportedTransferProtocol:
		return ((SRMv2__TSupportedTransferProtocol *)ptr)->soap_out(soap, tag, id, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn:
		return ((SRMv2__ArrayOfTRequestTokenReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTRequestTokenReturn");
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return ((SRMv2__TRequestTokenReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn:
		return ((SRMv2__ArrayOfTPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTPermissionReturn");
	case SOAP_TYPE_SRMv2__TPermissionReturn:
		return ((SRMv2__TPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return ((SRMv2__ArrayOfTSURLPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return ((SRMv2__TSURLPermissionReturn *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return ((SRMv2__ArrayOfTRequestSummary *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return ((SRMv2__TRequestSummary *)ptr)->soap_out(soap, tag, id, "SRMv2:TRequestSummary");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return ((SRMv2__ArrayOfTCopyRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return ((SRMv2__TCopyRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return ((SRMv2__ArrayOfTPutRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return ((SRMv2__TPutRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus:
		return ((SRMv2__ArrayOfTBringOnlineRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTBringOnlineRequestFileStatus");
	case SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus:
		return ((SRMv2__TBringOnlineRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return ((SRMv2__ArrayOfTGetRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return ((SRMv2__TGetRequestFileStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return ((SRMv2__ArrayOfTCopyFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return ((SRMv2__TCopyFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return ((SRMv2__ArrayOfTPutFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return ((SRMv2__TPutFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return ((SRMv2__ArrayOfTGetFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return ((SRMv2__TGetFileRequest *)ptr)->soap_out(soap, tag, id, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_SRMv2__TTransferParameters:
		return ((SRMv2__TTransferParameters *)ptr)->soap_out(soap, tag, id, "SRMv2:TTransferParameters");
	case SOAP_TYPE_SRMv2__ArrayOfAnyURI:
		return ((SRMv2__ArrayOfAnyURI *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfAnyURI");
	case SOAP_TYPE_SRMv2__ArrayOfTExtraInfo:
		return ((SRMv2__ArrayOfTExtraInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTExtraInfo");
	case SOAP_TYPE_SRMv2__TExtraInfo:
		return ((SRMv2__TExtraInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:TExtraInfo");
	case SOAP_TYPE_SRMv2__TDirOption:
		return ((SRMv2__TDirOption *)ptr)->soap_out(soap, tag, id, "SRMv2:TDirOption");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return ((SRMv2__ArrayOfTMetaDataSpace *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return ((SRMv2__TMetaDataSpace *)ptr)->soap_out(soap, tag, id, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return ((SRMv2__ArrayOfTMetaDataPathDetail *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return ((SRMv2__TMetaDataPathDetail *)ptr)->soap_out(soap, tag, id, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus:
		return ((SRMv2__ArrayOfTSURLLifetimeReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLLifetimeReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus:
		return ((SRMv2__TSURLLifetimeReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return ((SRMv2__ArrayOfTSURLReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return ((SRMv2__TSURLReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return ((SRMv2__TReturnStatus *)ptr)->soap_out(soap, tag, id, "SRMv2:TReturnStatus");
	case SOAP_TYPE_SRMv2__ArrayOfString:
		return ((SRMv2__ArrayOfString *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfString");
	case SOAP_TYPE_SRMv2__ArrayOfUnsignedLong:
		return ((SRMv2__ArrayOfUnsignedLong *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfUnsignedLong");
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return ((SRMv2__ArrayOfTGroupPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return ((SRMv2__TGroupPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TGroupPermission");
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return ((SRMv2__ArrayOfTUserPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_SRMv2__TUserPermission:
		return ((SRMv2__TUserPermission *)ptr)->soap_out(soap, tag, id, "SRMv2:TUserPermission");
	case SOAP_TYPE_SRMv2__TRetentionPolicyInfo:
		return ((SRMv2__TRetentionPolicyInfo *)ptr)->soap_out(soap, tag, id, "SRMv2:TRetentionPolicyInfo");
	case SOAP_TYPE_SRMv2__srmPing:
		return soap_out_SRMv2__srmPing(soap, tag, id, (const struct SRMv2__srmPing *)ptr, "SRMv2:srmPing");
	case SOAP_TYPE_SRMv2__srmPingResponse_:
		return soap_out_SRMv2__srmPingResponse_(soap, tag, id, (const struct SRMv2__srmPingResponse_ *)ptr, "SRMv2:srmPingResponse");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocols:
		return soap_out_SRMv2__srmGetTransferProtocols(soap, tag, id, (const struct SRMv2__srmGetTransferProtocols *)ptr, "SRMv2:srmGetTransferProtocols");
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_:
		return soap_out_SRMv2__srmGetTransferProtocolsResponse_(soap, tag, id, (const struct SRMv2__srmGetTransferProtocolsResponse_ *)ptr, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestTokens:
		return soap_out_SRMv2__srmGetRequestTokens(soap, tag, id, (const struct SRMv2__srmGetRequestTokens *)ptr, "SRMv2:srmGetRequestTokens");
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_:
		return soap_out_SRMv2__srmGetRequestTokensResponse_(soap, tag, id, (const struct SRMv2__srmGetRequestTokensResponse_ *)ptr, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return soap_out_SRMv2__srmExtendFileLifeTime(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTime *)ptr, "SRMv2:srmExtendFileLifeTime");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return soap_out_SRMv2__srmExtendFileLifeTimeResponse_(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTimeResponse_ *)ptr, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return soap_out_SRMv2__srmGetRequestSummary(soap, tag, id, (const struct SRMv2__srmGetRequestSummary *)ptr, "SRMv2:srmGetRequestSummary");
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return soap_out_SRMv2__srmGetRequestSummaryResponse_(soap, tag, id, (const struct SRMv2__srmGetRequestSummaryResponse_ *)ptr, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return soap_out_SRMv2__srmResumeRequest(soap, tag, id, (const struct SRMv2__srmResumeRequest *)ptr, "SRMv2:srmResumeRequest");
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return soap_out_SRMv2__srmResumeRequestResponse_(soap, tag, id, (const struct SRMv2__srmResumeRequestResponse_ *)ptr, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return soap_out_SRMv2__srmSuspendRequest(soap, tag, id, (const struct SRMv2__srmSuspendRequest *)ptr, "SRMv2:srmSuspendRequest");
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return soap_out_SRMv2__srmSuspendRequestResponse_(soap, tag, id, (const struct SRMv2__srmSuspendRequestResponse_ *)ptr, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return soap_out_SRMv2__srmAbortFiles(soap, tag, id, (const struct SRMv2__srmAbortFiles *)ptr, "SRMv2:srmAbortFiles");
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return soap_out_SRMv2__srmAbortFilesResponse_(soap, tag, id, (const struct SRMv2__srmAbortFilesResponse_ *)ptr, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return soap_out_SRMv2__srmAbortRequest(soap, tag, id, (const struct SRMv2__srmAbortRequest *)ptr, "SRMv2:srmAbortRequest");
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return soap_out_SRMv2__srmAbortRequestResponse_(soap, tag, id, (const struct SRMv2__srmAbortRequestResponse_ *)ptr, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_SRMv2__srmPutDone:
		return soap_out_SRMv2__srmPutDone(soap, tag, id, (const struct SRMv2__srmPutDone *)ptr, "SRMv2:srmPutDone");
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return soap_out_SRMv2__srmPutDoneResponse_(soap, tag, id, (const struct SRMv2__srmPutDoneResponse_ *)ptr, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return soap_out_SRMv2__srmReleaseFiles(soap, tag, id, (const struct SRMv2__srmReleaseFiles *)ptr, "SRMv2:srmReleaseFiles");
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return soap_out_SRMv2__srmReleaseFilesResponse_(soap, tag, id, (const struct SRMv2__srmReleaseFilesResponse_ *)ptr, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return soap_out_SRMv2__srmStatusOfCopyRequest(soap, tag, id, (const struct SRMv2__srmStatusOfCopyRequest *)ptr, "SRMv2:srmStatusOfCopyRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return soap_out_SRMv2__srmStatusOfCopyRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfCopyRequestResponse_ *)ptr, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_SRMv2__srmCopy:
		return soap_out_SRMv2__srmCopy(soap, tag, id, (const struct SRMv2__srmCopy *)ptr, "SRMv2:srmCopy");
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return soap_out_SRMv2__srmCopyResponse_(soap, tag, id, (const struct SRMv2__srmCopyResponse_ *)ptr, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return soap_out_SRMv2__srmStatusOfPutRequest(soap, tag, id, (const struct SRMv2__srmStatusOfPutRequest *)ptr, "SRMv2:srmStatusOfPutRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return soap_out_SRMv2__srmStatusOfPutRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfPutRequestResponse_ *)ptr, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return soap_out_SRMv2__srmPrepareToPut(soap, tag, id, (const struct SRMv2__srmPrepareToPut *)ptr, "SRMv2:srmPrepareToPut");
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return soap_out_SRMv2__srmPrepareToPutResponse_(soap, tag, id, (const struct SRMv2__srmPrepareToPutResponse_ *)ptr, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest:
		return soap_out_SRMv2__srmStatusOfBringOnlineRequest(soap, tag, id, (const struct SRMv2__srmStatusOfBringOnlineRequest *)ptr, "SRMv2:srmStatusOfBringOnlineRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_:
		return soap_out_SRMv2__srmStatusOfBringOnlineRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfBringOnlineRequestResponse_ *)ptr, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_SRMv2__srmBringOnline:
		return soap_out_SRMv2__srmBringOnline(soap, tag, id, (const struct SRMv2__srmBringOnline *)ptr, "SRMv2:srmBringOnline");
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse_:
		return soap_out_SRMv2__srmBringOnlineResponse_(soap, tag, id, (const struct SRMv2__srmBringOnlineResponse_ *)ptr, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return soap_out_SRMv2__srmStatusOfGetRequest(soap, tag, id, (const struct SRMv2__srmStatusOfGetRequest *)ptr, "SRMv2:srmStatusOfGetRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return soap_out_SRMv2__srmStatusOfGetRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfGetRequestResponse_ *)ptr, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return soap_out_SRMv2__srmPrepareToGet(soap, tag, id, (const struct SRMv2__srmPrepareToGet *)ptr, "SRMv2:srmPrepareToGet");
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return soap_out_SRMv2__srmPrepareToGetResponse_(soap, tag, id, (const struct SRMv2__srmPrepareToGetResponse_ *)ptr, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_SRMv2__srmMv:
		return soap_out_SRMv2__srmMv(soap, tag, id, (const struct SRMv2__srmMv *)ptr, "SRMv2:srmMv");
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return soap_out_SRMv2__srmMvResponse_(soap, tag, id, (const struct SRMv2__srmMvResponse_ *)ptr, "SRMv2:srmMvResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequest:
		return soap_out_SRMv2__srmStatusOfLsRequest(soap, tag, id, (const struct SRMv2__srmStatusOfLsRequest *)ptr, "SRMv2:srmStatusOfLsRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_:
		return soap_out_SRMv2__srmStatusOfLsRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfLsRequestResponse_ *)ptr, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_SRMv2__srmLs:
		return soap_out_SRMv2__srmLs(soap, tag, id, (const struct SRMv2__srmLs *)ptr, "SRMv2:srmLs");
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return soap_out_SRMv2__srmLsResponse_(soap, tag, id, (const struct SRMv2__srmLsResponse_ *)ptr, "SRMv2:srmLsResponse");
	case SOAP_TYPE_SRMv2__srmRm:
		return soap_out_SRMv2__srmRm(soap, tag, id, (const struct SRMv2__srmRm *)ptr, "SRMv2:srmRm");
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return soap_out_SRMv2__srmRmResponse_(soap, tag, id, (const struct SRMv2__srmRmResponse_ *)ptr, "SRMv2:srmRmResponse");
	case SOAP_TYPE_SRMv2__srmRmdir:
		return soap_out_SRMv2__srmRmdir(soap, tag, id, (const struct SRMv2__srmRmdir *)ptr, "SRMv2:srmRmdir");
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return soap_out_SRMv2__srmRmdirResponse_(soap, tag, id, (const struct SRMv2__srmRmdirResponse_ *)ptr, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_SRMv2__srmMkdir:
		return soap_out_SRMv2__srmMkdir(soap, tag, id, (const struct SRMv2__srmMkdir *)ptr, "SRMv2:srmMkdir");
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return soap_out_SRMv2__srmMkdirResponse_(soap, tag, id, (const struct SRMv2__srmMkdirResponse_ *)ptr, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_SRMv2__srmGetPermission:
		return soap_out_SRMv2__srmGetPermission(soap, tag, id, (const struct SRMv2__srmGetPermission *)ptr, "SRMv2:srmGetPermission");
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse_:
		return soap_out_SRMv2__srmGetPermissionResponse_(soap, tag, id, (const struct SRMv2__srmGetPermissionResponse_ *)ptr, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return soap_out_SRMv2__srmCheckPermission(soap, tag, id, (const struct SRMv2__srmCheckPermission *)ptr, "SRMv2:srmCheckPermission");
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return soap_out_SRMv2__srmCheckPermissionResponse_(soap, tag, id, (const struct SRMv2__srmCheckPermissionResponse_ *)ptr, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return soap_out_SRMv2__srmSetPermission(soap, tag, id, (const struct SRMv2__srmSetPermission *)ptr, "SRMv2:srmSetPermission");
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return soap_out_SRMv2__srmSetPermissionResponse_(soap, tag, id, (const struct SRMv2__srmSetPermissionResponse_ *)ptr, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokens:
		return soap_out_SRMv2__srmGetSpaceTokens(soap, tag, id, (const struct SRMv2__srmGetSpaceTokens *)ptr, "SRMv2:srmGetSpaceTokens");
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_:
		return soap_out_SRMv2__srmGetSpaceTokensResponse_(soap, tag, id, (const struct SRMv2__srmGetSpaceTokensResponse_ *)ptr, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpace:
		return soap_out_SRMv2__srmPurgeFromSpace(soap, tag, id, (const struct SRMv2__srmPurgeFromSpace *)ptr, "SRMv2:srmPurgeFromSpace");
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_:
		return soap_out_SRMv2__srmPurgeFromSpaceResponse_(soap, tag, id, (const struct SRMv2__srmPurgeFromSpaceResponse_ *)ptr, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace:
		return soap_out_SRMv2__srmExtendFileLifeTimeInSpace(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTimeInSpace *)ptr, "SRMv2:srmExtendFileLifeTimeInSpace");
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_:
		return soap_out_SRMv2__srmExtendFileLifeTimeInSpaceResponse_(soap, tag, id, (const struct SRMv2__srmExtendFileLifeTimeInSpaceResponse_ *)ptr, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest:
		return soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequest(soap, tag, id, (const struct SRMv2__srmStatusOfChangeSpaceForFilesRequest *)ptr, "SRMv2:srmStatusOfChangeSpaceForFilesRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_:
		return soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_ *)ptr, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFiles:
		return soap_out_SRMv2__srmChangeSpaceForFiles(soap, tag, id, (const struct SRMv2__srmChangeSpaceForFiles *)ptr, "SRMv2:srmChangeSpaceForFiles");
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_:
		return soap_out_SRMv2__srmChangeSpaceForFilesResponse_(soap, tag, id, (const struct SRMv2__srmChangeSpaceForFilesResponse_ *)ptr, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return soap_out_SRMv2__srmGetSpaceMetaData(soap, tag, id, (const struct SRMv2__srmGetSpaceMetaData *)ptr, "SRMv2:srmGetSpaceMetaData");
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return soap_out_SRMv2__srmGetSpaceMetaDataResponse_(soap, tag, id, (const struct SRMv2__srmGetSpaceMetaDataResponse_ *)ptr, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest:
		return soap_out_SRMv2__srmStatusOfUpdateSpaceRequest(soap, tag, id, (const struct SRMv2__srmStatusOfUpdateSpaceRequest *)ptr, "SRMv2:srmStatusOfUpdateSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_:
		return soap_out_SRMv2__srmStatusOfUpdateSpaceRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfUpdateSpaceRequestResponse_ *)ptr, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return soap_out_SRMv2__srmUpdateSpace(soap, tag, id, (const struct SRMv2__srmUpdateSpace *)ptr, "SRMv2:srmUpdateSpace");
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return soap_out_SRMv2__srmUpdateSpaceResponse_(soap, tag, id, (const struct SRMv2__srmUpdateSpaceResponse_ *)ptr, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return soap_out_SRMv2__srmReleaseSpace(soap, tag, id, (const struct SRMv2__srmReleaseSpace *)ptr, "SRMv2:srmReleaseSpace");
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return soap_out_SRMv2__srmReleaseSpaceResponse_(soap, tag, id, (const struct SRMv2__srmReleaseSpaceResponse_ *)ptr, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest:
		return soap_out_SRMv2__srmStatusOfReserveSpaceRequest(soap, tag, id, (const struct SRMv2__srmStatusOfReserveSpaceRequest *)ptr, "SRMv2:srmStatusOfReserveSpaceRequest");
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_:
		return soap_out_SRMv2__srmStatusOfReserveSpaceRequestResponse_(soap, tag, id, (const struct SRMv2__srmStatusOfReserveSpaceRequestResponse_ *)ptr, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return soap_out_SRMv2__srmReserveSpace(soap, tag, id, (const struct SRMv2__srmReserveSpace *)ptr, "SRMv2:srmReserveSpace");
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return soap_out_SRMv2__srmReserveSpaceResponse_(soap, tag, id, (const struct SRMv2__srmReserveSpaceResponse_ *)ptr, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPingRequest:
		return soap_out_PointerToSRMv2__srmPingRequest(soap, tag, id, (SRMv2__srmPingRequest *const*)ptr, "SRMv2:srmPingRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPingResponse:
		return soap_out_PointerToSRMv2__srmPingResponse(soap, tag, id, (SRMv2__srmPingResponse *const*)ptr, "SRMv2:srmPingResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsRequest:
		return soap_out_PointerToSRMv2__srmGetTransferProtocolsRequest(soap, tag, id, (SRMv2__srmGetTransferProtocolsRequest *const*)ptr, "SRMv2:srmGetTransferProtocolsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsResponse:
		return soap_out_PointerToSRMv2__srmGetTransferProtocolsResponse(soap, tag, id, (SRMv2__srmGetTransferProtocolsResponse *const*)ptr, "SRMv2:srmGetTransferProtocolsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensRequest:
		return soap_out_PointerToSRMv2__srmGetRequestTokensRequest(soap, tag, id, (SRMv2__srmGetRequestTokensRequest *const*)ptr, "SRMv2:srmGetRequestTokensRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensResponse:
		return soap_out_PointerToSRMv2__srmGetRequestTokensResponse(soap, tag, id, (SRMv2__srmGetRequestTokensResponse *const*)ptr, "SRMv2:srmGetRequestTokensResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, tag, id, (SRMv2__srmExtendFileLifeTimeRequest *const*)ptr, "SRMv2:srmExtendFileLifeTimeRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, tag, id, (SRMv2__srmExtendFileLifeTimeResponse *const*)ptr, "SRMv2:srmExtendFileLifeTimeResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		return soap_out_PointerToSRMv2__srmGetRequestSummaryRequest(soap, tag, id, (SRMv2__srmGetRequestSummaryRequest *const*)ptr, "SRMv2:srmGetRequestSummaryRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		return soap_out_PointerToSRMv2__srmGetRequestSummaryResponse(soap, tag, id, (SRMv2__srmGetRequestSummaryResponse *const*)ptr, "SRMv2:srmGetRequestSummaryResponse");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		return soap_out_PointerToSRMv2__srmResumeRequestRequest(soap, tag, id, (SRMv2__srmResumeRequestRequest *const*)ptr, "SRMv2:srmResumeRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		return soap_out_PointerToSRMv2__srmResumeRequestResponse(soap, tag, id, (SRMv2__srmResumeRequestResponse *const*)ptr, "SRMv2:srmResumeRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		return soap_out_PointerToSRMv2__srmSuspendRequestRequest(soap, tag, id, (SRMv2__srmSuspendRequestRequest *const*)ptr, "SRMv2:srmSuspendRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		return soap_out_PointerToSRMv2__srmSuspendRequestResponse(soap, tag, id, (SRMv2__srmSuspendRequestResponse *const*)ptr, "SRMv2:srmSuspendRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		return soap_out_PointerToSRMv2__srmAbortFilesRequest(soap, tag, id, (SRMv2__srmAbortFilesRequest *const*)ptr, "SRMv2:srmAbortFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		return soap_out_PointerToSRMv2__srmAbortFilesResponse(soap, tag, id, (SRMv2__srmAbortFilesResponse *const*)ptr, "SRMv2:srmAbortFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		return soap_out_PointerToSRMv2__srmAbortRequestRequest(soap, tag, id, (SRMv2__srmAbortRequestRequest *const*)ptr, "SRMv2:srmAbortRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		return soap_out_PointerToSRMv2__srmAbortRequestResponse(soap, tag, id, (SRMv2__srmAbortRequestResponse *const*)ptr, "SRMv2:srmAbortRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		return soap_out_PointerToSRMv2__srmPutDoneRequest(soap, tag, id, (SRMv2__srmPutDoneRequest *const*)ptr, "SRMv2:srmPutDoneRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		return soap_out_PointerToSRMv2__srmPutDoneResponse(soap, tag, id, (SRMv2__srmPutDoneResponse *const*)ptr, "SRMv2:srmPutDoneResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		return soap_out_PointerToSRMv2__srmReleaseFilesRequest(soap, tag, id, (SRMv2__srmReleaseFilesRequest *const*)ptr, "SRMv2:srmReleaseFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		return soap_out_PointerToSRMv2__srmReleaseFilesResponse(soap, tag, id, (SRMv2__srmReleaseFilesResponse *const*)ptr, "SRMv2:srmReleaseFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, tag, id, (SRMv2__srmStatusOfCopyRequestRequest *const*)ptr, "SRMv2:srmStatusOfCopyRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, tag, id, (SRMv2__srmStatusOfCopyRequestResponse *const*)ptr, "SRMv2:srmStatusOfCopyRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		return soap_out_PointerToSRMv2__srmCopyRequest(soap, tag, id, (SRMv2__srmCopyRequest *const*)ptr, "SRMv2:srmCopyRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		return soap_out_PointerToSRMv2__srmCopyResponse(soap, tag, id, (SRMv2__srmCopyResponse *const*)ptr, "SRMv2:srmCopyResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, tag, id, (SRMv2__srmStatusOfPutRequestRequest *const*)ptr, "SRMv2:srmStatusOfPutRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, tag, id, (SRMv2__srmStatusOfPutRequestResponse *const*)ptr, "SRMv2:srmStatusOfPutRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		return soap_out_PointerToSRMv2__srmPrepareToPutRequest(soap, tag, id, (SRMv2__srmPrepareToPutRequest *const*)ptr, "SRMv2:srmPrepareToPutRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		return soap_out_PointerToSRMv2__srmPrepareToPutResponse(soap, tag, id, (SRMv2__srmPrepareToPutResponse *const*)ptr, "SRMv2:srmPrepareToPutResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest(soap, tag, id, (SRMv2__srmStatusOfBringOnlineRequestRequest *const*)ptr, "SRMv2:srmStatusOfBringOnlineRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse(soap, tag, id, (SRMv2__srmStatusOfBringOnlineRequestResponse *const*)ptr, "SRMv2:srmStatusOfBringOnlineRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineRequest:
		return soap_out_PointerToSRMv2__srmBringOnlineRequest(soap, tag, id, (SRMv2__srmBringOnlineRequest *const*)ptr, "SRMv2:srmBringOnlineRequest");
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineResponse:
		return soap_out_PointerToSRMv2__srmBringOnlineResponse(soap, tag, id, (SRMv2__srmBringOnlineResponse *const*)ptr, "SRMv2:srmBringOnlineResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, tag, id, (SRMv2__srmStatusOfGetRequestRequest *const*)ptr, "SRMv2:srmStatusOfGetRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, tag, id, (SRMv2__srmStatusOfGetRequestResponse *const*)ptr, "SRMv2:srmStatusOfGetRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		return soap_out_PointerToSRMv2__srmPrepareToGetRequest(soap, tag, id, (SRMv2__srmPrepareToGetRequest *const*)ptr, "SRMv2:srmPrepareToGetRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		return soap_out_PointerToSRMv2__srmPrepareToGetResponse(soap, tag, id, (SRMv2__srmPrepareToGetResponse *const*)ptr, "SRMv2:srmPrepareToGetResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		return soap_out_PointerToSRMv2__srmMvRequest(soap, tag, id, (SRMv2__srmMvRequest *const*)ptr, "SRMv2:srmMvRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		return soap_out_PointerToSRMv2__srmMvResponse(soap, tag, id, (SRMv2__srmMvResponse *const*)ptr, "SRMv2:srmMvResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfLsRequestRequest(soap, tag, id, (SRMv2__srmStatusOfLsRequestRequest *const*)ptr, "SRMv2:srmStatusOfLsRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfLsRequestResponse(soap, tag, id, (SRMv2__srmStatusOfLsRequestResponse *const*)ptr, "SRMv2:srmStatusOfLsRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		return soap_out_PointerToSRMv2__srmLsRequest(soap, tag, id, (SRMv2__srmLsRequest *const*)ptr, "SRMv2:srmLsRequest");
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		return soap_out_PointerToSRMv2__srmLsResponse(soap, tag, id, (SRMv2__srmLsResponse *const*)ptr, "SRMv2:srmLsResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		return soap_out_PointerToSRMv2__srmRmRequest(soap, tag, id, (SRMv2__srmRmRequest *const*)ptr, "SRMv2:srmRmRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		return soap_out_PointerToSRMv2__srmRmResponse(soap, tag, id, (SRMv2__srmRmResponse *const*)ptr, "SRMv2:srmRmResponse");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		return soap_out_PointerToSRMv2__srmRmdirRequest(soap, tag, id, (SRMv2__srmRmdirRequest *const*)ptr, "SRMv2:srmRmdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		return soap_out_PointerToSRMv2__srmRmdirResponse(soap, tag, id, (SRMv2__srmRmdirResponse *const*)ptr, "SRMv2:srmRmdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		return soap_out_PointerToSRMv2__srmMkdirRequest(soap, tag, id, (SRMv2__srmMkdirRequest *const*)ptr, "SRMv2:srmMkdirRequest");
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		return soap_out_PointerToSRMv2__srmMkdirResponse(soap, tag, id, (SRMv2__srmMkdirResponse *const*)ptr, "SRMv2:srmMkdirResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionRequest:
		return soap_out_PointerToSRMv2__srmGetPermissionRequest(soap, tag, id, (SRMv2__srmGetPermissionRequest *const*)ptr, "SRMv2:srmGetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionResponse:
		return soap_out_PointerToSRMv2__srmGetPermissionResponse(soap, tag, id, (SRMv2__srmGetPermissionResponse *const*)ptr, "SRMv2:srmGetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		return soap_out_PointerToSRMv2__srmCheckPermissionRequest(soap, tag, id, (SRMv2__srmCheckPermissionRequest *const*)ptr, "SRMv2:srmCheckPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		return soap_out_PointerToSRMv2__srmCheckPermissionResponse(soap, tag, id, (SRMv2__srmCheckPermissionResponse *const*)ptr, "SRMv2:srmCheckPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		return soap_out_PointerToSRMv2__srmSetPermissionRequest(soap, tag, id, (SRMv2__srmSetPermissionRequest *const*)ptr, "SRMv2:srmSetPermissionRequest");
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		return soap_out_PointerToSRMv2__srmSetPermissionResponse(soap, tag, id, (SRMv2__srmSetPermissionResponse *const*)ptr, "SRMv2:srmSetPermissionResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensRequest:
		return soap_out_PointerToSRMv2__srmGetSpaceTokensRequest(soap, tag, id, (SRMv2__srmGetSpaceTokensRequest *const*)ptr, "SRMv2:srmGetSpaceTokensRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensResponse:
		return soap_out_PointerToSRMv2__srmGetSpaceTokensResponse(soap, tag, id, (SRMv2__srmGetSpaceTokensResponse *const*)ptr, "SRMv2:srmGetSpaceTokensResponse");
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceRequest:
		return soap_out_PointerToSRMv2__srmPurgeFromSpaceRequest(soap, tag, id, (SRMv2__srmPurgeFromSpaceRequest *const*)ptr, "SRMv2:srmPurgeFromSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceResponse:
		return soap_out_PointerToSRMv2__srmPurgeFromSpaceResponse(soap, tag, id, (SRMv2__srmPurgeFromSpaceResponse *const*)ptr, "SRMv2:srmPurgeFromSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, tag, id, (SRMv2__srmExtendFileLifeTimeInSpaceRequest *const*)ptr, "SRMv2:srmExtendFileLifeTimeInSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse:
		return soap_out_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, tag, id, (SRMv2__srmExtendFileLifeTimeInSpaceResponse *const*)ptr, "SRMv2:srmExtendFileLifeTimeInSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, tag, id, (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *const*)ptr, "SRMv2:srmStatusOfChangeSpaceForFilesRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, tag, id, (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *const*)ptr, "SRMv2:srmStatusOfChangeSpaceForFilesRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesRequest:
		return soap_out_PointerToSRMv2__srmChangeSpaceForFilesRequest(soap, tag, id, (SRMv2__srmChangeSpaceForFilesRequest *const*)ptr, "SRMv2:srmChangeSpaceForFilesRequest");
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesResponse:
		return soap_out_PointerToSRMv2__srmChangeSpaceForFilesResponse(soap, tag, id, (SRMv2__srmChangeSpaceForFilesResponse *const*)ptr, "SRMv2:srmChangeSpaceForFilesResponse");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		return soap_out_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, tag, id, (SRMv2__srmGetSpaceMetaDataRequest *const*)ptr, "SRMv2:srmGetSpaceMetaDataRequest");
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		return soap_out_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, tag, id, (SRMv2__srmGetSpaceMetaDataResponse *const*)ptr, "SRMv2:srmGetSpaceMetaDataResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, tag, id, (SRMv2__srmStatusOfUpdateSpaceRequestRequest *const*)ptr, "SRMv2:srmStatusOfUpdateSpaceRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, tag, id, (SRMv2__srmStatusOfUpdateSpaceRequestResponse *const*)ptr, "SRMv2:srmStatusOfUpdateSpaceRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		return soap_out_PointerToSRMv2__srmUpdateSpaceRequest(soap, tag, id, (SRMv2__srmUpdateSpaceRequest *const*)ptr, "SRMv2:srmUpdateSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		return soap_out_PointerToSRMv2__srmUpdateSpaceResponse(soap, tag, id, (SRMv2__srmUpdateSpaceResponse *const*)ptr, "SRMv2:srmUpdateSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		return soap_out_PointerToSRMv2__srmReleaseSpaceRequest(soap, tag, id, (SRMv2__srmReleaseSpaceRequest *const*)ptr, "SRMv2:srmReleaseSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		return soap_out_PointerToSRMv2__srmReleaseSpaceResponse(soap, tag, id, (SRMv2__srmReleaseSpaceResponse *const*)ptr, "SRMv2:srmReleaseSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest:
		return soap_out_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest(soap, tag, id, (SRMv2__srmStatusOfReserveSpaceRequestRequest *const*)ptr, "SRMv2:srmStatusOfReserveSpaceRequestRequest");
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse:
		return soap_out_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse(soap, tag, id, (SRMv2__srmStatusOfReserveSpaceRequestResponse *const*)ptr, "SRMv2:srmStatusOfReserveSpaceRequestResponse");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		return soap_out_PointerToSRMv2__srmReserveSpaceRequest(soap, tag, id, (SRMv2__srmReserveSpaceRequest *const*)ptr, "SRMv2:srmReserveSpaceRequest");
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		return soap_out_PointerToSRMv2__srmReserveSpaceResponse(soap, tag, id, (SRMv2__srmReserveSpaceResponse *const*)ptr, "SRMv2:srmReserveSpaceResponse");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSupportedTransferProtocol:
		return soap_out_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, tag, id, (SRMv2__ArrayOfTSupportedTransferProtocol *const*)ptr, "SRMv2:ArrayOfTSupportedTransferProtocol");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestTokenReturn:
		return soap_out_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, tag, id, (SRMv2__ArrayOfTRequestTokenReturn *const*)ptr, "SRMv2:ArrayOfTRequestTokenReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		return soap_out_PointerToSRMv2__ArrayOfTRequestSummary(soap, tag, id, (SRMv2__ArrayOfTRequestSummary *const*)ptr, "SRMv2:ArrayOfTRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTCopyRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, tag, id, (SRMv2__ArrayOfTCopyFileRequest *const*)ptr, "SRMv2:ArrayOfTCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTPutRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		return soap_out_PointerToSRMv2__TOverwriteMode(soap, tag, id, (enum SRMv2__TOverwriteMode *const*)ptr, "SRMv2:TOverwriteMode");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTPutFileRequest(soap, tag, id, (SRMv2__ArrayOfTPutFileRequest *const*)ptr, "SRMv2:ArrayOfTPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTBringOnlineRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		return soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, tag, id, (SRMv2__ArrayOfTGetRequestFileStatus *const*)ptr, "SRMv2:ArrayOfTGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		return soap_out_PointerToSRMv2__ArrayOfTGetFileRequest(soap, tag, id, (SRMv2__ArrayOfTGetFileRequest *const*)ptr, "SRMv2:ArrayOfTGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPermissionReturn:
		return soap_out_PointerToSRMv2__ArrayOfTPermissionReturn(soap, tag, id, (SRMv2__ArrayOfTPermissionReturn *const*)ptr, "SRMv2:ArrayOfTPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		return soap_out_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, tag, id, (SRMv2__ArrayOfTSURLPermissionReturn *const*)ptr, "SRMv2:ArrayOfTSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus:
		return soap_out_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, tag, id, (SRMv2__ArrayOfTSURLLifetimeReturnStatus *const*)ptr, "SRMv2:ArrayOfTSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		return soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, tag, id, (SRMv2__ArrayOfTSURLReturnStatus *const*)ptr, "SRMv2:ArrayOfTSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfAnyURI:
		return soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, tag, id, (SRMv2__ArrayOfAnyURI *const*)ptr, "SRMv2:ArrayOfAnyURI");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		return soap_out_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, tag, id, (SRMv2__ArrayOfTMetaDataSpace *const*)ptr, "SRMv2:ArrayOfTMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TTransferParameters:
		return soap_out_PointerToSRMv2__TTransferParameters(soap, tag, id, (SRMv2__TTransferParameters *const*)ptr, "SRMv2:TTransferParameters");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfUnsignedLong:
		return soap_out_PointerToSRMv2__ArrayOfUnsignedLong(soap, tag, id, (SRMv2__ArrayOfUnsignedLong *const*)ptr, "SRMv2:ArrayOfUnsignedLong");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSupportedTransferProtocol:
		return soap_out_PointerToPointerToSRMv2__TSupportedTransferProtocol(soap, tag, id, (SRMv2__TSupportedTransferProtocol **const*)ptr, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_PointerToSRMv2__TSupportedTransferProtocol:
		return soap_out_PointerToSRMv2__TSupportedTransferProtocol(soap, tag, id, (SRMv2__TSupportedTransferProtocol *const*)ptr, "SRMv2:TSupportedTransferProtocol");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestTokenReturn:
		return soap_out_PointerToPointerToSRMv2__TRequestTokenReturn(soap, tag, id, (SRMv2__TRequestTokenReturn **const*)ptr, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_PointerToSRMv2__TRequestTokenReturn:
		return soap_out_PointerToSRMv2__TRequestTokenReturn(soap, tag, id, (SRMv2__TRequestTokenReturn *const*)ptr, "SRMv2:TRequestTokenReturn");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPermissionReturn:
		return soap_out_PointerToPointerToSRMv2__TPermissionReturn(soap, tag, id, (SRMv2__TPermissionReturn **const*)ptr, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TPermissionReturn:
		return soap_out_PointerToSRMv2__TPermissionReturn(soap, tag, id, (SRMv2__TPermissionReturn *const*)ptr, "SRMv2:TPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		return soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, tag, id, (SRMv2__ArrayOfTGroupPermission *const*)ptr, "SRMv2:ArrayOfTGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		return soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, tag, id, (SRMv2__ArrayOfTUserPermission *const*)ptr, "SRMv2:ArrayOfTUserPermission");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		return soap_out_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, tag, id, (SRMv2__TSURLPermissionReturn **const*)ptr, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		return soap_out_PointerToSRMv2__TSURLPermissionReturn(soap, tag, id, (SRMv2__TSURLPermissionReturn *const*)ptr, "SRMv2:TSURLPermissionReturn");
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		return soap_out_PointerToPointerToSRMv2__TRequestSummary(soap, tag, id, (SRMv2__TRequestSummary **const*)ptr, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		return soap_out_PointerToSRMv2__TRequestSummary(soap, tag, id, (SRMv2__TRequestSummary *const*)ptr, "SRMv2:TRequestSummary");
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		return soap_out_PointerToSRMv2__TRequestType(soap, tag, id, (enum SRMv2__TRequestType *const*)ptr, "SRMv2:TRequestType");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, tag, id, (SRMv2__TCopyRequestFileStatus **const*)ptr, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		return soap_out_PointerToSRMv2__TCopyRequestFileStatus(soap, tag, id, (SRMv2__TCopyRequestFileStatus *const*)ptr, "SRMv2:TCopyRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, tag, id, (SRMv2__TPutRequestFileStatus **const*)ptr, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		return soap_out_PointerToSRMv2__TPutRequestFileStatus(soap, tag, id, (SRMv2__TPutRequestFileStatus *const*)ptr, "SRMv2:TPutRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus(soap, tag, id, (SRMv2__TBringOnlineRequestFileStatus **const*)ptr, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TBringOnlineRequestFileStatus:
		return soap_out_PointerToSRMv2__TBringOnlineRequestFileStatus(soap, tag, id, (SRMv2__TBringOnlineRequestFileStatus *const*)ptr, "SRMv2:TBringOnlineRequestFileStatus");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		return soap_out_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, tag, id, (SRMv2__TGetRequestFileStatus **const*)ptr, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		return soap_out_PointerToSRMv2__TGetRequestFileStatus(soap, tag, id, (SRMv2__TGetRequestFileStatus *const*)ptr, "SRMv2:TGetRequestFileStatus");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTExtraInfo:
		return soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, tag, id, (SRMv2__ArrayOfTExtraInfo *const*)ptr, "SRMv2:ArrayOfTExtraInfo");
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		return soap_out_PointerToPointerToSRMv2__TCopyFileRequest(soap, tag, id, (SRMv2__TCopyFileRequest **const*)ptr, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		return soap_out_PointerToSRMv2__TCopyFileRequest(soap, tag, id, (SRMv2__TCopyFileRequest *const*)ptr, "SRMv2:TCopyFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		return soap_out_PointerToPointerToSRMv2__TPutFileRequest(soap, tag, id, (SRMv2__TPutFileRequest **const*)ptr, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		return soap_out_PointerToSRMv2__TPutFileRequest(soap, tag, id, (SRMv2__TPutFileRequest *const*)ptr, "SRMv2:TPutFileRequest");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		return soap_out_PointerToPointerToSRMv2__TGetFileRequest(soap, tag, id, (SRMv2__TGetFileRequest **const*)ptr, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		return soap_out_PointerToSRMv2__TGetFileRequest(soap, tag, id, (SRMv2__TGetFileRequest *const*)ptr, "SRMv2:TGetFileRequest");
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		return soap_out_PointerToSRMv2__TDirOption(soap, tag, id, (SRMv2__TDirOption *const*)ptr, "SRMv2:TDirOption");
	case SOAP_TYPE_PointerToSRMv2__TConnectionType:
		return soap_out_PointerToSRMv2__TConnectionType(soap, tag, id, (enum SRMv2__TConnectionType *const*)ptr, "SRMv2:TConnectionType");
	case SOAP_TYPE_PointerToSRMv2__TAccessPattern:
		return soap_out_PointerToSRMv2__TAccessPattern(soap, tag, id, (enum SRMv2__TAccessPattern *const*)ptr, "SRMv2:TAccessPattern");
	case SOAP_TYPE_PointerToxsd__anyURI:
		return soap_out_PointerToxsd__anyURI(soap, tag, id, (char **const*)ptr, "xsd:anyURI");
	case SOAP_TYPE_PointerToPointerToSRMv2__TExtraInfo:
		return soap_out_PointerToPointerToSRMv2__TExtraInfo(soap, tag, id, (SRMv2__TExtraInfo **const*)ptr, "SRMv2:TExtraInfo");
	case SOAP_TYPE_PointerToSRMv2__TExtraInfo:
		return soap_out_PointerToSRMv2__TExtraInfo(soap, tag, id, (SRMv2__TExtraInfo *const*)ptr, "SRMv2:TExtraInfo");
	case SOAP_TYPE_PointerTobool:
		return soap_out_PointerTobool(soap, tag, id, (bool *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		return soap_out_PointerToPointerToSRMv2__TMetaDataSpace(soap, tag, id, (SRMv2__TMetaDataSpace **const*)ptr, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		return soap_out_PointerToSRMv2__TMetaDataSpace(soap, tag, id, (SRMv2__TMetaDataSpace *const*)ptr, "SRMv2:TMetaDataSpace");
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		return soap_out_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, tag, id, (SRMv2__TMetaDataPathDetail **const*)ptr, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		return soap_out_PointerToSRMv2__TMetaDataPathDetail(soap, tag, id, (SRMv2__TMetaDataPathDetail *const*)ptr, "SRMv2:TMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		return soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, tag, id, (SRMv2__ArrayOfTMetaDataPathDetail *const*)ptr, "SRMv2:ArrayOfTMetaDataPathDetail");
	case SOAP_TYPE_PointerToSRMv2__TPermissionMode:
		return soap_out_PointerToSRMv2__TPermissionMode(soap, tag, id, (enum SRMv2__TPermissionMode *const*)ptr, "SRMv2:TPermissionMode");
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		return soap_out_PointerToSRMv2__TFileType(soap, tag, id, (enum SRMv2__TFileType *const*)ptr, "SRMv2:TFileType");
	case SOAP_TYPE_PointerToSRMv2__ArrayOfString:
		return soap_out_PointerToSRMv2__ArrayOfString(soap, tag, id, (SRMv2__ArrayOfString *const*)ptr, "SRMv2:ArrayOfString");
	case SOAP_TYPE_PointerToSRMv2__TFileLocality:
		return soap_out_PointerToSRMv2__TFileLocality(soap, tag, id, (enum SRMv2__TFileLocality *const*)ptr, "SRMv2:TFileLocality");
	case SOAP_TYPE_PointerToSRMv2__TRetentionPolicyInfo:
		return soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, tag, id, (SRMv2__TRetentionPolicyInfo *const*)ptr, "SRMv2:TRetentionPolicyInfo");
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		return soap_out_PointerToSRMv2__TFileStorageType(soap, tag, id, (enum SRMv2__TFileStorageType *const*)ptr, "SRMv2:TFileStorageType");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus:
		return soap_out_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus(soap, tag, id, (SRMv2__TSURLLifetimeReturnStatus **const*)ptr, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLLifetimeReturnStatus:
		return soap_out_PointerToSRMv2__TSURLLifetimeReturnStatus(soap, tag, id, (SRMv2__TSURLLifetimeReturnStatus *const*)ptr, "SRMv2:TSURLLifetimeReturnStatus");
	case SOAP_TYPE_PointerToint:
		return soap_out_PointerToint(soap, tag, id, (int *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		return soap_out_PointerToPointerToSRMv2__TSURLReturnStatus(soap, tag, id, (SRMv2__TSURLReturnStatus **const*)ptr, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		return soap_out_PointerToSRMv2__TSURLReturnStatus(soap, tag, id, (SRMv2__TSURLReturnStatus *const*)ptr, "SRMv2:TSURLReturnStatus");
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		return soap_out_PointerToSRMv2__TReturnStatus(soap, tag, id, (SRMv2__TReturnStatus *const*)ptr, "SRMv2:TReturnStatus");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTounsignedLONG64:
		return soap_out_PointerTounsignedLONG64(soap, tag, id, (ULONG64 *const*)ptr, "xsd:unsignedLong");
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		return soap_out_PointerToPointerToSRMv2__TGroupPermission(soap, tag, id, (SRMv2__TGroupPermission **const*)ptr, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		return soap_out_PointerToSRMv2__TGroupPermission(soap, tag, id, (SRMv2__TGroupPermission *const*)ptr, "SRMv2:TGroupPermission");
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		return soap_out_PointerToPointerToSRMv2__TUserPermission(soap, tag, id, (SRMv2__TUserPermission **const*)ptr, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		return soap_out_PointerToSRMv2__TUserPermission(soap, tag, id, (SRMv2__TUserPermission *const*)ptr, "SRMv2:TUserPermission");
	case SOAP_TYPE_PointerToSRMv2__TAccessLatency:
		return soap_out_PointerToSRMv2__TAccessLatency(soap, tag, id, (enum SRMv2__TAccessLatency *const*)ptr, "SRMv2:TAccessLatency");
	case SOAP_TYPE_xsd__anyURI:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:anyURI");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "QName", id, (char**)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char**)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_SRMv2__srmPingResponse:
		((SRMv2__srmPingResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPingRequest:
		((SRMv2__srmPingRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse:
		((SRMv2__srmGetTransferProtocolsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest:
		((SRMv2__srmGetTransferProtocolsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse:
		((SRMv2__srmGetRequestTokensResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensRequest:
		((SRMv2__srmGetRequestTokensRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		((SRMv2__srmExtendFileLifeTimeResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		((SRMv2__srmExtendFileLifeTimeRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		((SRMv2__srmGetRequestSummaryResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		((SRMv2__srmGetRequestSummaryRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		((SRMv2__srmResumeRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		((SRMv2__srmResumeRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		((SRMv2__srmSuspendRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		((SRMv2__srmSuspendRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		((SRMv2__srmAbortFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		((SRMv2__srmAbortFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		((SRMv2__srmAbortRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		((SRMv2__srmAbortRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		((SRMv2__srmPutDoneResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		((SRMv2__srmPutDoneRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		((SRMv2__srmReleaseFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		((SRMv2__srmReleaseFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		((SRMv2__srmStatusOfCopyRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		((SRMv2__srmStatusOfCopyRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		((SRMv2__srmCopyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		((SRMv2__srmCopyRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		((SRMv2__srmStatusOfPutRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		((SRMv2__srmStatusOfPutRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		((SRMv2__srmPrepareToPutResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		((SRMv2__srmPrepareToPutRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse:
		((SRMv2__srmStatusOfBringOnlineRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest:
		((SRMv2__srmStatusOfBringOnlineRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse:
		((SRMv2__srmBringOnlineResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineRequest:
		((SRMv2__srmBringOnlineRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		((SRMv2__srmStatusOfGetRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		((SRMv2__srmStatusOfGetRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		((SRMv2__srmPrepareToGetResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		((SRMv2__srmPrepareToGetRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse:
		((SRMv2__srmMvResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMvRequest:
		((SRMv2__srmMvRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse:
		((SRMv2__srmStatusOfLsRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest:
		((SRMv2__srmStatusOfLsRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse:
		((SRMv2__srmLsResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmLsRequest:
		((SRMv2__srmLsRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse:
		((SRMv2__srmRmResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmRequest:
		((SRMv2__srmRmRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		((SRMv2__srmRmdirResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		((SRMv2__srmRmdirRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		((SRMv2__srmMkdirResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		((SRMv2__srmMkdirRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse:
		((SRMv2__srmGetPermissionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionRequest:
		((SRMv2__srmGetPermissionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		((SRMv2__srmCheckPermissionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		((SRMv2__srmCheckPermissionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		((SRMv2__srmSetPermissionResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		((SRMv2__srmSetPermissionRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse:
		((SRMv2__srmGetSpaceTokensResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest:
		((SRMv2__srmGetSpaceTokensRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse:
		((SRMv2__srmPurgeFromSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest:
		((SRMv2__srmPurgeFromSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse:
		((SRMv2__srmExtendFileLifeTimeInSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest:
		((SRMv2__srmExtendFileLifeTimeInSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse:
		((SRMv2__srmChangeSpaceForFilesResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest:
		((SRMv2__srmChangeSpaceForFilesRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		((SRMv2__srmGetSpaceMetaDataResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		((SRMv2__srmGetSpaceMetaDataRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse:
		((SRMv2__srmStatusOfUpdateSpaceRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest:
		((SRMv2__srmStatusOfUpdateSpaceRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		((SRMv2__srmUpdateSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		((SRMv2__srmUpdateSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		((SRMv2__srmReleaseSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		((SRMv2__srmReleaseSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse:
		((SRMv2__srmStatusOfReserveSpaceRequestResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest:
		((SRMv2__srmStatusOfReserveSpaceRequestRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		((SRMv2__srmReserveSpaceResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		((SRMv2__srmReserveSpaceRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol:
		((SRMv2__ArrayOfTSupportedTransferProtocol *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSupportedTransferProtocol:
		((SRMv2__TSupportedTransferProtocol *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn:
		((SRMv2__ArrayOfTRequestTokenReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		((SRMv2__TRequestTokenReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn:
		((SRMv2__ArrayOfTPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TPermissionReturn:
		((SRMv2__TPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		((SRMv2__ArrayOfTSURLPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		((SRMv2__TSURLPermissionReturn *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		((SRMv2__ArrayOfTRequestSummary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRequestSummary:
		((SRMv2__TRequestSummary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		((SRMv2__ArrayOfTCopyRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		((SRMv2__TCopyRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		((SRMv2__ArrayOfTPutRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		((SRMv2__TPutRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus:
		((SRMv2__ArrayOfTBringOnlineRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus:
		((SRMv2__TBringOnlineRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		((SRMv2__ArrayOfTGetRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		((SRMv2__TGetRequestFileStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		((SRMv2__ArrayOfTCopyFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		((SRMv2__TCopyFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		((SRMv2__ArrayOfTPutFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		((SRMv2__TPutFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		((SRMv2__ArrayOfTGetFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		((SRMv2__TGetFileRequest *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TTransferParameters:
		((SRMv2__TTransferParameters *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfAnyURI:
		((SRMv2__ArrayOfAnyURI *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTExtraInfo:
		((SRMv2__ArrayOfTExtraInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TExtraInfo:
		((SRMv2__TExtraInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TDirOption:
		((SRMv2__TDirOption *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		((SRMv2__ArrayOfTMetaDataSpace *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		((SRMv2__TMetaDataSpace *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		((SRMv2__ArrayOfTMetaDataPathDetail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		((SRMv2__TMetaDataPathDetail *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus:
		((SRMv2__ArrayOfTSURLLifetimeReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus:
		((SRMv2__TSURLLifetimeReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		((SRMv2__ArrayOfTSURLReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		((SRMv2__TSURLReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TReturnStatus:
		((SRMv2__TReturnStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfString:
		((SRMv2__ArrayOfString *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfUnsignedLong:
		((SRMv2__ArrayOfUnsignedLong *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		((SRMv2__ArrayOfTGroupPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TGroupPermission:
		((SRMv2__TGroupPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		((SRMv2__ArrayOfTUserPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TUserPermission:
		((SRMv2__TUserPermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__TRetentionPolicyInfo:
		((SRMv2__TRetentionPolicyInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_SRMv2__srmPing:
		soap_serialize_SRMv2__srmPing(soap, (const struct SRMv2__srmPing *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPingResponse_:
		soap_serialize_SRMv2__srmPingResponse_(soap, (const struct SRMv2__srmPingResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocols:
		soap_serialize_SRMv2__srmGetTransferProtocols(soap, (const struct SRMv2__srmGetTransferProtocols *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_:
		soap_serialize_SRMv2__srmGetTransferProtocolsResponse_(soap, (const struct SRMv2__srmGetTransferProtocolsResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokens:
		soap_serialize_SRMv2__srmGetRequestTokens(soap, (const struct SRMv2__srmGetRequestTokens *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_:
		soap_serialize_SRMv2__srmGetRequestTokensResponse_(soap, (const struct SRMv2__srmGetRequestTokensResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		soap_serialize_SRMv2__srmExtendFileLifeTime(soap, (const struct SRMv2__srmExtendFileLifeTime *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		soap_serialize_SRMv2__srmExtendFileLifeTimeResponse_(soap, (const struct SRMv2__srmExtendFileLifeTimeResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		soap_serialize_SRMv2__srmGetRequestSummary(soap, (const struct SRMv2__srmGetRequestSummary *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		soap_serialize_SRMv2__srmGetRequestSummaryResponse_(soap, (const struct SRMv2__srmGetRequestSummaryResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		soap_serialize_SRMv2__srmResumeRequest(soap, (const struct SRMv2__srmResumeRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		soap_serialize_SRMv2__srmResumeRequestResponse_(soap, (const struct SRMv2__srmResumeRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		soap_serialize_SRMv2__srmSuspendRequest(soap, (const struct SRMv2__srmSuspendRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		soap_serialize_SRMv2__srmSuspendRequestResponse_(soap, (const struct SRMv2__srmSuspendRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		soap_serialize_SRMv2__srmAbortFiles(soap, (const struct SRMv2__srmAbortFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		soap_serialize_SRMv2__srmAbortFilesResponse_(soap, (const struct SRMv2__srmAbortFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		soap_serialize_SRMv2__srmAbortRequest(soap, (const struct SRMv2__srmAbortRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		soap_serialize_SRMv2__srmAbortRequestResponse_(soap, (const struct SRMv2__srmAbortRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPutDone:
		soap_serialize_SRMv2__srmPutDone(soap, (const struct SRMv2__srmPutDone *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		soap_serialize_SRMv2__srmPutDoneResponse_(soap, (const struct SRMv2__srmPutDoneResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		soap_serialize_SRMv2__srmReleaseFiles(soap, (const struct SRMv2__srmReleaseFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		soap_serialize_SRMv2__srmReleaseFilesResponse_(soap, (const struct SRMv2__srmReleaseFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		soap_serialize_SRMv2__srmStatusOfCopyRequest(soap, (const struct SRMv2__srmStatusOfCopyRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfCopyRequestResponse_(soap, (const struct SRMv2__srmStatusOfCopyRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCopy:
		soap_serialize_SRMv2__srmCopy(soap, (const struct SRMv2__srmCopy *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		soap_serialize_SRMv2__srmCopyResponse_(soap, (const struct SRMv2__srmCopyResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		soap_serialize_SRMv2__srmStatusOfPutRequest(soap, (const struct SRMv2__srmStatusOfPutRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfPutRequestResponse_(soap, (const struct SRMv2__srmStatusOfPutRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		soap_serialize_SRMv2__srmPrepareToPut(soap, (const struct SRMv2__srmPrepareToPut *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		soap_serialize_SRMv2__srmPrepareToPutResponse_(soap, (const struct SRMv2__srmPrepareToPutResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest:
		soap_serialize_SRMv2__srmStatusOfBringOnlineRequest(soap, (const struct SRMv2__srmStatusOfBringOnlineRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfBringOnlineRequestResponse_(soap, (const struct SRMv2__srmStatusOfBringOnlineRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmBringOnline:
		soap_serialize_SRMv2__srmBringOnline(soap, (const struct SRMv2__srmBringOnline *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse_:
		soap_serialize_SRMv2__srmBringOnlineResponse_(soap, (const struct SRMv2__srmBringOnlineResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		soap_serialize_SRMv2__srmStatusOfGetRequest(soap, (const struct SRMv2__srmStatusOfGetRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfGetRequestResponse_(soap, (const struct SRMv2__srmStatusOfGetRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		soap_serialize_SRMv2__srmPrepareToGet(soap, (const struct SRMv2__srmPrepareToGet *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		soap_serialize_SRMv2__srmPrepareToGetResponse_(soap, (const struct SRMv2__srmPrepareToGetResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMv:
		soap_serialize_SRMv2__srmMv(soap, (const struct SRMv2__srmMv *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		soap_serialize_SRMv2__srmMvResponse_(soap, (const struct SRMv2__srmMvResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequest:
		soap_serialize_SRMv2__srmStatusOfLsRequest(soap, (const struct SRMv2__srmStatusOfLsRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfLsRequestResponse_(soap, (const struct SRMv2__srmStatusOfLsRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmLs:
		soap_serialize_SRMv2__srmLs(soap, (const struct SRMv2__srmLs *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		soap_serialize_SRMv2__srmLsResponse_(soap, (const struct SRMv2__srmLsResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRm:
		soap_serialize_SRMv2__srmRm(soap, (const struct SRMv2__srmRm *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		soap_serialize_SRMv2__srmRmResponse_(soap, (const struct SRMv2__srmRmResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmdir:
		soap_serialize_SRMv2__srmRmdir(soap, (const struct SRMv2__srmRmdir *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		soap_serialize_SRMv2__srmRmdirResponse_(soap, (const struct SRMv2__srmRmdirResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMkdir:
		soap_serialize_SRMv2__srmMkdir(soap, (const struct SRMv2__srmMkdir *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		soap_serialize_SRMv2__srmMkdirResponse_(soap, (const struct SRMv2__srmMkdirResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetPermission:
		soap_serialize_SRMv2__srmGetPermission(soap, (const struct SRMv2__srmGetPermission *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse_:
		soap_serialize_SRMv2__srmGetPermissionResponse_(soap, (const struct SRMv2__srmGetPermissionResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		soap_serialize_SRMv2__srmCheckPermission(soap, (const struct SRMv2__srmCheckPermission *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		soap_serialize_SRMv2__srmCheckPermissionResponse_(soap, (const struct SRMv2__srmCheckPermissionResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermission:
		soap_serialize_SRMv2__srmSetPermission(soap, (const struct SRMv2__srmSetPermission *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		soap_serialize_SRMv2__srmSetPermissionResponse_(soap, (const struct SRMv2__srmSetPermissionResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokens:
		soap_serialize_SRMv2__srmGetSpaceTokens(soap, (const struct SRMv2__srmGetSpaceTokens *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_:
		soap_serialize_SRMv2__srmGetSpaceTokensResponse_(soap, (const struct SRMv2__srmGetSpaceTokensResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpace:
		soap_serialize_SRMv2__srmPurgeFromSpace(soap, (const struct SRMv2__srmPurgeFromSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_:
		soap_serialize_SRMv2__srmPurgeFromSpaceResponse_(soap, (const struct SRMv2__srmPurgeFromSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace:
		soap_serialize_SRMv2__srmExtendFileLifeTimeInSpace(soap, (const struct SRMv2__srmExtendFileLifeTimeInSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_:
		soap_serialize_SRMv2__srmExtendFileLifeTimeInSpaceResponse_(soap, (const struct SRMv2__srmExtendFileLifeTimeInSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest:
		soap_serialize_SRMv2__srmStatusOfChangeSpaceForFilesRequest(soap, (const struct SRMv2__srmStatusOfChangeSpaceForFilesRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_(soap, (const struct SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFiles:
		soap_serialize_SRMv2__srmChangeSpaceForFiles(soap, (const struct SRMv2__srmChangeSpaceForFiles *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_:
		soap_serialize_SRMv2__srmChangeSpaceForFilesResponse_(soap, (const struct SRMv2__srmChangeSpaceForFilesResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		soap_serialize_SRMv2__srmGetSpaceMetaData(soap, (const struct SRMv2__srmGetSpaceMetaData *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		soap_serialize_SRMv2__srmGetSpaceMetaDataResponse_(soap, (const struct SRMv2__srmGetSpaceMetaDataResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest:
		soap_serialize_SRMv2__srmStatusOfUpdateSpaceRequest(soap, (const struct SRMv2__srmStatusOfUpdateSpaceRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfUpdateSpaceRequestResponse_(soap, (const struct SRMv2__srmStatusOfUpdateSpaceRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		soap_serialize_SRMv2__srmUpdateSpace(soap, (const struct SRMv2__srmUpdateSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		soap_serialize_SRMv2__srmUpdateSpaceResponse_(soap, (const struct SRMv2__srmUpdateSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		soap_serialize_SRMv2__srmReleaseSpace(soap, (const struct SRMv2__srmReleaseSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		soap_serialize_SRMv2__srmReleaseSpaceResponse_(soap, (const struct SRMv2__srmReleaseSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest:
		soap_serialize_SRMv2__srmStatusOfReserveSpaceRequest(soap, (const struct SRMv2__srmStatusOfReserveSpaceRequest *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_:
		soap_serialize_SRMv2__srmStatusOfReserveSpaceRequestResponse_(soap, (const struct SRMv2__srmStatusOfReserveSpaceRequestResponse_ *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		soap_serialize_SRMv2__srmReserveSpace(soap, (const struct SRMv2__srmReserveSpace *)ptr);
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		soap_serialize_SRMv2__srmReserveSpaceResponse_(soap, (const struct SRMv2__srmReserveSpaceResponse_ *)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPingRequest:
		soap_serialize_PointerToSRMv2__srmPingRequest(soap, (SRMv2__srmPingRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPingResponse:
		soap_serialize_PointerToSRMv2__srmPingResponse(soap, (SRMv2__srmPingResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsRequest:
		soap_serialize_PointerToSRMv2__srmGetTransferProtocolsRequest(soap, (SRMv2__srmGetTransferProtocolsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetTransferProtocolsResponse:
		soap_serialize_PointerToSRMv2__srmGetTransferProtocolsResponse(soap, (SRMv2__srmGetTransferProtocolsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensRequest:
		soap_serialize_PointerToSRMv2__srmGetRequestTokensRequest(soap, (SRMv2__srmGetRequestTokensRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestTokensResponse:
		soap_serialize_PointerToSRMv2__srmGetRequestTokensResponse(soap, (SRMv2__srmGetRequestTokensResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeRequest:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeRequest(soap, (SRMv2__srmExtendFileLifeTimeRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeResponse:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeResponse(soap, (SRMv2__srmExtendFileLifeTimeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryRequest:
		soap_serialize_PointerToSRMv2__srmGetRequestSummaryRequest(soap, (SRMv2__srmGetRequestSummaryRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetRequestSummaryResponse:
		soap_serialize_PointerToSRMv2__srmGetRequestSummaryResponse(soap, (SRMv2__srmGetRequestSummaryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestRequest:
		soap_serialize_PointerToSRMv2__srmResumeRequestRequest(soap, (SRMv2__srmResumeRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmResumeRequestResponse:
		soap_serialize_PointerToSRMv2__srmResumeRequestResponse(soap, (SRMv2__srmResumeRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestRequest:
		soap_serialize_PointerToSRMv2__srmSuspendRequestRequest(soap, (SRMv2__srmSuspendRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSuspendRequestResponse:
		soap_serialize_PointerToSRMv2__srmSuspendRequestResponse(soap, (SRMv2__srmSuspendRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesRequest:
		soap_serialize_PointerToSRMv2__srmAbortFilesRequest(soap, (SRMv2__srmAbortFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortFilesResponse:
		soap_serialize_PointerToSRMv2__srmAbortFilesResponse(soap, (SRMv2__srmAbortFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestRequest:
		soap_serialize_PointerToSRMv2__srmAbortRequestRequest(soap, (SRMv2__srmAbortRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmAbortRequestResponse:
		soap_serialize_PointerToSRMv2__srmAbortRequestResponse(soap, (SRMv2__srmAbortRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneRequest:
		soap_serialize_PointerToSRMv2__srmPutDoneRequest(soap, (SRMv2__srmPutDoneRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPutDoneResponse:
		soap_serialize_PointerToSRMv2__srmPutDoneResponse(soap, (SRMv2__srmPutDoneResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesRequest:
		soap_serialize_PointerToSRMv2__srmReleaseFilesRequest(soap, (SRMv2__srmReleaseFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseFilesResponse:
		soap_serialize_PointerToSRMv2__srmReleaseFilesResponse(soap, (SRMv2__srmReleaseFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfCopyRequestRequest(soap, (SRMv2__srmStatusOfCopyRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfCopyRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfCopyRequestResponse(soap, (SRMv2__srmStatusOfCopyRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCopyRequest:
		soap_serialize_PointerToSRMv2__srmCopyRequest(soap, (SRMv2__srmCopyRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCopyResponse:
		soap_serialize_PointerToSRMv2__srmCopyResponse(soap, (SRMv2__srmCopyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfPutRequestRequest(soap, (SRMv2__srmStatusOfPutRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfPutRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfPutRequestResponse(soap, (SRMv2__srmStatusOfPutRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutRequest:
		soap_serialize_PointerToSRMv2__srmPrepareToPutRequest(soap, (SRMv2__srmPrepareToPutRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToPutResponse:
		soap_serialize_PointerToSRMv2__srmPrepareToPutResponse(soap, (SRMv2__srmPrepareToPutResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfBringOnlineRequestRequest(soap, (SRMv2__srmStatusOfBringOnlineRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfBringOnlineRequestResponse(soap, (SRMv2__srmStatusOfBringOnlineRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineRequest:
		soap_serialize_PointerToSRMv2__srmBringOnlineRequest(soap, (SRMv2__srmBringOnlineRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmBringOnlineResponse:
		soap_serialize_PointerToSRMv2__srmBringOnlineResponse(soap, (SRMv2__srmBringOnlineResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfGetRequestRequest(soap, (SRMv2__srmStatusOfGetRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfGetRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfGetRequestResponse(soap, (SRMv2__srmStatusOfGetRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetRequest:
		soap_serialize_PointerToSRMv2__srmPrepareToGetRequest(soap, (SRMv2__srmPrepareToGetRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPrepareToGetResponse:
		soap_serialize_PointerToSRMv2__srmPrepareToGetResponse(soap, (SRMv2__srmPrepareToGetResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMvRequest:
		soap_serialize_PointerToSRMv2__srmMvRequest(soap, (SRMv2__srmMvRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMvResponse:
		soap_serialize_PointerToSRMv2__srmMvResponse(soap, (SRMv2__srmMvResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfLsRequestRequest(soap, (SRMv2__srmStatusOfLsRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfLsRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfLsRequestResponse(soap, (SRMv2__srmStatusOfLsRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmLsRequest:
		soap_serialize_PointerToSRMv2__srmLsRequest(soap, (SRMv2__srmLsRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmLsResponse:
		soap_serialize_PointerToSRMv2__srmLsResponse(soap, (SRMv2__srmLsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmRequest:
		soap_serialize_PointerToSRMv2__srmRmRequest(soap, (SRMv2__srmRmRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmResponse:
		soap_serialize_PointerToSRMv2__srmRmResponse(soap, (SRMv2__srmRmResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmdirRequest:
		soap_serialize_PointerToSRMv2__srmRmdirRequest(soap, (SRMv2__srmRmdirRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmRmdirResponse:
		soap_serialize_PointerToSRMv2__srmRmdirResponse(soap, (SRMv2__srmRmdirResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMkdirRequest:
		soap_serialize_PointerToSRMv2__srmMkdirRequest(soap, (SRMv2__srmMkdirRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmMkdirResponse:
		soap_serialize_PointerToSRMv2__srmMkdirResponse(soap, (SRMv2__srmMkdirResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionRequest:
		soap_serialize_PointerToSRMv2__srmGetPermissionRequest(soap, (SRMv2__srmGetPermissionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetPermissionResponse:
		soap_serialize_PointerToSRMv2__srmGetPermissionResponse(soap, (SRMv2__srmGetPermissionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionRequest:
		soap_serialize_PointerToSRMv2__srmCheckPermissionRequest(soap, (SRMv2__srmCheckPermissionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmCheckPermissionResponse:
		soap_serialize_PointerToSRMv2__srmCheckPermissionResponse(soap, (SRMv2__srmCheckPermissionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionRequest:
		soap_serialize_PointerToSRMv2__srmSetPermissionRequest(soap, (SRMv2__srmSetPermissionRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmSetPermissionResponse:
		soap_serialize_PointerToSRMv2__srmSetPermissionResponse(soap, (SRMv2__srmSetPermissionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensRequest:
		soap_serialize_PointerToSRMv2__srmGetSpaceTokensRequest(soap, (SRMv2__srmGetSpaceTokensRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceTokensResponse:
		soap_serialize_PointerToSRMv2__srmGetSpaceTokensResponse(soap, (SRMv2__srmGetSpaceTokensResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceRequest:
		soap_serialize_PointerToSRMv2__srmPurgeFromSpaceRequest(soap, (SRMv2__srmPurgeFromSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmPurgeFromSpaceResponse:
		soap_serialize_PointerToSRMv2__srmPurgeFromSpaceResponse(soap, (SRMv2__srmPurgeFromSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, (SRMv2__srmExtendFileLifeTimeInSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse:
		soap_serialize_PointerToSRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, (SRMv2__srmExtendFileLifeTimeInSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesRequest:
		soap_serialize_PointerToSRMv2__srmChangeSpaceForFilesRequest(soap, (SRMv2__srmChangeSpaceForFilesRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmChangeSpaceForFilesResponse:
		soap_serialize_PointerToSRMv2__srmChangeSpaceForFilesResponse(soap, (SRMv2__srmChangeSpaceForFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataRequest:
		soap_serialize_PointerToSRMv2__srmGetSpaceMetaDataRequest(soap, (SRMv2__srmGetSpaceMetaDataRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmGetSpaceMetaDataResponse:
		soap_serialize_PointerToSRMv2__srmGetSpaceMetaDataResponse(soap, (SRMv2__srmGetSpaceMetaDataResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, (SRMv2__srmStatusOfUpdateSpaceRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, (SRMv2__srmStatusOfUpdateSpaceRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceRequest:
		soap_serialize_PointerToSRMv2__srmUpdateSpaceRequest(soap, (SRMv2__srmUpdateSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmUpdateSpaceResponse:
		soap_serialize_PointerToSRMv2__srmUpdateSpaceResponse(soap, (SRMv2__srmUpdateSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceRequest:
		soap_serialize_PointerToSRMv2__srmReleaseSpaceRequest(soap, (SRMv2__srmReleaseSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReleaseSpaceResponse:
		soap_serialize_PointerToSRMv2__srmReleaseSpaceResponse(soap, (SRMv2__srmReleaseSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest:
		soap_serialize_PointerToSRMv2__srmStatusOfReserveSpaceRequestRequest(soap, (SRMv2__srmStatusOfReserveSpaceRequestRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse:
		soap_serialize_PointerToSRMv2__srmStatusOfReserveSpaceRequestResponse(soap, (SRMv2__srmStatusOfReserveSpaceRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceRequest:
		soap_serialize_PointerToSRMv2__srmReserveSpaceRequest(soap, (SRMv2__srmReserveSpaceRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__srmReserveSpaceResponse:
		soap_serialize_PointerToSRMv2__srmReserveSpaceResponse(soap, (SRMv2__srmReserveSpaceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSupportedTransferProtocol:
		soap_serialize_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, (SRMv2__ArrayOfTSupportedTransferProtocol *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestTokenReturn:
		soap_serialize_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, (SRMv2__ArrayOfTRequestTokenReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTRequestSummary:
		soap_serialize_PointerToSRMv2__ArrayOfTRequestSummary(soap, (SRMv2__ArrayOfTRequestSummary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, (SRMv2__ArrayOfTCopyRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTCopyFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, (SRMv2__ArrayOfTCopyFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, (SRMv2__ArrayOfTPutRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TOverwriteMode:
		soap_serialize_PointerToSRMv2__TOverwriteMode(soap, (enum SRMv2__TOverwriteMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPutFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTPutFileRequest(soap, (SRMv2__ArrayOfTPutFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, (SRMv2__ArrayOfTBringOnlineRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetRequestFileStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, (SRMv2__ArrayOfTGetRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGetFileRequest:
		soap_serialize_PointerToSRMv2__ArrayOfTGetFileRequest(soap, (SRMv2__ArrayOfTGetFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTPermissionReturn:
		soap_serialize_PointerToSRMv2__ArrayOfTPermissionReturn(soap, (SRMv2__ArrayOfTPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLPermissionReturn:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, (SRMv2__ArrayOfTSURLPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, (SRMv2__ArrayOfTSURLLifetimeReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTSURLReturnStatus:
		soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, (SRMv2__ArrayOfTSURLReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfAnyURI:
		soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, (SRMv2__ArrayOfAnyURI *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataSpace:
		soap_serialize_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, (SRMv2__ArrayOfTMetaDataSpace *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TTransferParameters:
		soap_serialize_PointerToSRMv2__TTransferParameters(soap, (SRMv2__TTransferParameters *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfUnsignedLong:
		soap_serialize_PointerToSRMv2__ArrayOfUnsignedLong(soap, (SRMv2__ArrayOfUnsignedLong *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSupportedTransferProtocol:
		soap_serialize_PointerToPointerToSRMv2__TSupportedTransferProtocol(soap, (SRMv2__TSupportedTransferProtocol **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSupportedTransferProtocol:
		soap_serialize_PointerToSRMv2__TSupportedTransferProtocol(soap, (SRMv2__TSupportedTransferProtocol *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestTokenReturn:
		soap_serialize_PointerToPointerToSRMv2__TRequestTokenReturn(soap, (SRMv2__TRequestTokenReturn **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestTokenReturn:
		soap_serialize_PointerToSRMv2__TRequestTokenReturn(soap, (SRMv2__TRequestTokenReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TPermissionReturn:
		soap_serialize_PointerToPointerToSRMv2__TPermissionReturn(soap, (SRMv2__TPermissionReturn **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPermissionReturn:
		soap_serialize_PointerToSRMv2__TPermissionReturn(soap, (SRMv2__TPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTGroupPermission:
		soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, (SRMv2__ArrayOfTGroupPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTUserPermission:
		soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, (SRMv2__ArrayOfTUserPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLPermissionReturn:
		soap_serialize_PointerToPointerToSRMv2__TSURLPermissionReturn(soap, (SRMv2__TSURLPermissionReturn **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLPermissionReturn:
		soap_serialize_PointerToSRMv2__TSURLPermissionReturn(soap, (SRMv2__TSURLPermissionReturn *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TRequestSummary:
		soap_serialize_PointerToPointerToSRMv2__TRequestSummary(soap, (SRMv2__TRequestSummary **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestSummary:
		soap_serialize_PointerToSRMv2__TRequestSummary(soap, (SRMv2__TRequestSummary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRequestType:
		soap_serialize_PointerToSRMv2__TRequestType(soap, (enum SRMv2__TRequestType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TCopyRequestFileStatus(soap, (SRMv2__TCopyRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCopyRequestFileStatus:
		soap_serialize_PointerToSRMv2__TCopyRequestFileStatus(soap, (SRMv2__TCopyRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TPutRequestFileStatus(soap, (SRMv2__TPutRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPutRequestFileStatus:
		soap_serialize_PointerToSRMv2__TPutRequestFileStatus(soap, (SRMv2__TPutRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TBringOnlineRequestFileStatus(soap, (SRMv2__TBringOnlineRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TBringOnlineRequestFileStatus:
		soap_serialize_PointerToSRMv2__TBringOnlineRequestFileStatus(soap, (SRMv2__TBringOnlineRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetRequestFileStatus:
		soap_serialize_PointerToPointerToSRMv2__TGetRequestFileStatus(soap, (SRMv2__TGetRequestFileStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGetRequestFileStatus:
		soap_serialize_PointerToSRMv2__TGetRequestFileStatus(soap, (SRMv2__TGetRequestFileStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTExtraInfo:
		soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, (SRMv2__ArrayOfTExtraInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TCopyFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TCopyFileRequest(soap, (SRMv2__TCopyFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TCopyFileRequest:
		soap_serialize_PointerToSRMv2__TCopyFileRequest(soap, (SRMv2__TCopyFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TPutFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TPutFileRequest(soap, (SRMv2__TPutFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPutFileRequest:
		soap_serialize_PointerToSRMv2__TPutFileRequest(soap, (SRMv2__TPutFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGetFileRequest:
		soap_serialize_PointerToPointerToSRMv2__TGetFileRequest(soap, (SRMv2__TGetFileRequest **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGetFileRequest:
		soap_serialize_PointerToSRMv2__TGetFileRequest(soap, (SRMv2__TGetFileRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TDirOption:
		soap_serialize_PointerToSRMv2__TDirOption(soap, (SRMv2__TDirOption *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TConnectionType:
		soap_serialize_PointerToSRMv2__TConnectionType(soap, (enum SRMv2__TConnectionType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TAccessPattern:
		soap_serialize_PointerToSRMv2__TAccessPattern(soap, (enum SRMv2__TAccessPattern *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__anyURI:
		soap_serialize_PointerToxsd__anyURI(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TExtraInfo:
		soap_serialize_PointerToPointerToSRMv2__TExtraInfo(soap, (SRMv2__TExtraInfo **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TExtraInfo:
		soap_serialize_PointerToSRMv2__TExtraInfo(soap, (SRMv2__TExtraInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTobool:
		soap_serialize_PointerTobool(soap, (bool *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataSpace:
		soap_serialize_PointerToPointerToSRMv2__TMetaDataSpace(soap, (SRMv2__TMetaDataSpace **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TMetaDataSpace:
		soap_serialize_PointerToSRMv2__TMetaDataSpace(soap, (SRMv2__TMetaDataSpace *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TMetaDataPathDetail:
		soap_serialize_PointerToPointerToSRMv2__TMetaDataPathDetail(soap, (SRMv2__TMetaDataPathDetail **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TMetaDataPathDetail:
		soap_serialize_PointerToSRMv2__TMetaDataPathDetail(soap, (SRMv2__TMetaDataPathDetail *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfTMetaDataPathDetail:
		soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, (SRMv2__ArrayOfTMetaDataPathDetail *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TPermissionMode:
		soap_serialize_PointerToSRMv2__TPermissionMode(soap, (enum SRMv2__TPermissionMode *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TFileType:
		soap_serialize_PointerToSRMv2__TFileType(soap, (enum SRMv2__TFileType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__ArrayOfString:
		soap_serialize_PointerToSRMv2__ArrayOfString(soap, (SRMv2__ArrayOfString *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TFileLocality:
		soap_serialize_PointerToSRMv2__TFileLocality(soap, (enum SRMv2__TFileLocality *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TRetentionPolicyInfo:
		soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, (SRMv2__TRetentionPolicyInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TFileStorageType:
		soap_serialize_PointerToSRMv2__TFileStorageType(soap, (enum SRMv2__TFileStorageType *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus:
		soap_serialize_PointerToPointerToSRMv2__TSURLLifetimeReturnStatus(soap, (SRMv2__TSURLLifetimeReturnStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLLifetimeReturnStatus:
		soap_serialize_PointerToSRMv2__TSURLLifetimeReturnStatus(soap, (SRMv2__TSURLLifetimeReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToint:
		soap_serialize_PointerToint(soap, (int *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TSURLReturnStatus:
		soap_serialize_PointerToPointerToSRMv2__TSURLReturnStatus(soap, (SRMv2__TSURLReturnStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TSURLReturnStatus:
		soap_serialize_PointerToSRMv2__TSURLReturnStatus(soap, (SRMv2__TSURLReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TReturnStatus:
		soap_serialize_PointerToSRMv2__TReturnStatus(soap, (SRMv2__TReturnStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedLONG64:
		soap_serialize_PointerTounsignedLONG64(soap, (ULONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TGroupPermission:
		soap_serialize_PointerToPointerToSRMv2__TGroupPermission(soap, (SRMv2__TGroupPermission **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TGroupPermission:
		soap_serialize_PointerToSRMv2__TGroupPermission(soap, (SRMv2__TGroupPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToSRMv2__TUserPermission:
		soap_serialize_PointerToPointerToSRMv2__TUserPermission(soap, (SRMv2__TUserPermission **const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TUserPermission:
		soap_serialize_PointerToSRMv2__TUserPermission(soap, (SRMv2__TUserPermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToSRMv2__TAccessLatency:
		soap_serialize_PointerToSRMv2__TAccessLatency(soap, (enum SRMv2__TAccessLatency *const*)ptr);
		break;
	case SOAP_TYPE_xsd__anyURI:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char**)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_SRMv2__TRetentionPolicyInfo:
		return (void*)soap_instantiate_SRMv2__TRetentionPolicyInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TUserPermission:
		return (void*)soap_instantiate_SRMv2__TUserPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		return (void*)soap_instantiate_SRMv2__ArrayOfTUserPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGroupPermission:
		return (void*)soap_instantiate_SRMv2__TGroupPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGroupPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfUnsignedLong:
		return (void*)soap_instantiate_SRMv2__ArrayOfUnsignedLong(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfString:
		return (void*)soap_instantiate_SRMv2__ArrayOfString(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TReturnStatus:
		return (void*)soap_instantiate_SRMv2__TReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		return (void*)soap_instantiate_SRMv2__TSURLReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus:
		return (void*)soap_instantiate_SRMv2__TSURLLifetimeReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		return (void*)soap_instantiate_SRMv2__TMetaDataPathDetail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		return (void*)soap_instantiate_SRMv2__ArrayOfTMetaDataPathDetail(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		return (void*)soap_instantiate_SRMv2__TMetaDataSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		return (void*)soap_instantiate_SRMv2__ArrayOfTMetaDataSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TDirOption:
		return (void*)soap_instantiate_SRMv2__TDirOption(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TExtraInfo:
		return (void*)soap_instantiate_SRMv2__TExtraInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTExtraInfo:
		return (void*)soap_instantiate_SRMv2__ArrayOfTExtraInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfAnyURI:
		return (void*)soap_instantiate_SRMv2__ArrayOfAnyURI(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TTransferParameters:
		return (void*)soap_instantiate_SRMv2__TTransferParameters(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		return (void*)soap_instantiate_SRMv2__TGetFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGetFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		return (void*)soap_instantiate_SRMv2__TPutFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTPutFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		return (void*)soap_instantiate_SRMv2__TCopyFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		return (void*)soap_instantiate_SRMv2__ArrayOfTCopyFileRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TGetRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTGetRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TBringOnlineRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TPutRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTPutRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__TCopyRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		return (void*)soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TRequestSummary:
		return (void*)soap_instantiate_SRMv2__TRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		return (void*)soap_instantiate_SRMv2__ArrayOfTRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		return (void*)soap_instantiate_SRMv2__TSURLPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TPermissionReturn:
		return (void*)soap_instantiate_SRMv2__TPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn:
		return (void*)soap_instantiate_SRMv2__ArrayOfTPermissionReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		return (void*)soap_instantiate_SRMv2__TRequestTokenReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn:
		return (void*)soap_instantiate_SRMv2__ArrayOfTRequestTokenReturn(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__TSupportedTransferProtocol:
		return (void*)soap_instantiate_SRMv2__TSupportedTransferProtocol(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol:
		return (void*)soap_instantiate_SRMv2__ArrayOfTSupportedTransferProtocol(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmChangeSpaceForFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmChangeSpaceForFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmPurgeFromSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse:
		return (void*)soap_instantiate_SRMv2__srmPurgeFromSpaceResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokensRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokensResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetPermissionRequest:
		return (void*)soap_instantiate_SRMv2__srmGetPermissionRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse:
		return (void*)soap_instantiate_SRMv2__srmGetPermissionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		return (void*)soap_instantiate_SRMv2__srmMkdirRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		return (void*)soap_instantiate_SRMv2__srmMkdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		return (void*)soap_instantiate_SRMv2__srmRmdirRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		return (void*)soap_instantiate_SRMv2__srmRmdirResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmRequest:
		return (void*)soap_instantiate_SRMv2__srmRmRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmResponse:
		return (void*)soap_instantiate_SRMv2__srmRmResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsRequest:
		return (void*)soap_instantiate_SRMv2__srmLsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsResponse:
		return (void*)soap_instantiate_SRMv2__srmLsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfLsRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfLsRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvRequest:
		return (void*)soap_instantiate_SRMv2__srmMvRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvResponse:
		return (void*)soap_instantiate_SRMv2__srmMvResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmBringOnlineRequest:
		return (void*)soap_instantiate_SRMv2__srmBringOnlineRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse:
		return (void*)soap_instantiate_SRMv2__srmBringOnlineResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		return (void*)soap_instantiate_SRMv2__srmCopyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		return (void*)soap_instantiate_SRMv2__srmCopyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		return (void*)soap_instantiate_SRMv2__srmPutDoneRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		return (void*)soap_instantiate_SRMv2__srmPutDoneResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestTokensRequest:
		return (void*)soap_instantiate_SRMv2__srmGetRequestTokensRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse:
		return (void*)soap_instantiate_SRMv2__srmGetRequestTokensResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest:
		return (void*)soap_instantiate_SRMv2__srmGetTransferProtocolsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse:
		return (void*)soap_instantiate_SRMv2__srmGetTransferProtocolsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPingRequest:
		return (void*)soap_instantiate_SRMv2__srmPingRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPingResponse:
		return (void*)soap_instantiate_SRMv2__srmPingResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmReserveSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		return (void*)soap_instantiate_SRMv2__srmReserveSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		return (void*)soap_instantiate_SRMv2__srmReleaseSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		return (void*)soap_instantiate_SRMv2__srmUpdateSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceMetaData(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmChangeSpaceForFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFiles:
		return (void*)soap_instantiate_SRMv2__srmChangeSpaceForFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_:
		return (void*)soap_instantiate_SRMv2__srmPurgeFromSpaceResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPurgeFromSpace:
		return (void*)soap_instantiate_SRMv2__srmPurgeFromSpace(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokensResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetSpaceTokens:
		return (void*)soap_instantiate_SRMv2__srmGetSpaceTokens(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		return (void*)soap_instantiate_SRMv2__srmSetPermissionResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSetPermission:
		return (void*)soap_instantiate_SRMv2__srmSetPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		return (void*)soap_instantiate_SRMv2__srmCheckPermissionResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		return (void*)soap_instantiate_SRMv2__srmCheckPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetPermissionResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetPermission:
		return (void*)soap_instantiate_SRMv2__srmGetPermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		return (void*)soap_instantiate_SRMv2__srmMkdirResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMkdir:
		return (void*)soap_instantiate_SRMv2__srmMkdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		return (void*)soap_instantiate_SRMv2__srmRmdirResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmdir:
		return (void*)soap_instantiate_SRMv2__srmRmdir(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		return (void*)soap_instantiate_SRMv2__srmRmResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmRm:
		return (void*)soap_instantiate_SRMv2__srmRm(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		return (void*)soap_instantiate_SRMv2__srmLsResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmLs:
		return (void*)soap_instantiate_SRMv2__srmLs(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfLsRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfLsRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		return (void*)soap_instantiate_SRMv2__srmMvResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmMv:
		return (void*)soap_instantiate_SRMv2__srmMv(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGetResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		return (void*)soap_instantiate_SRMv2__srmPrepareToGet(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfGetRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse_:
		return (void*)soap_instantiate_SRMv2__srmBringOnlineResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmBringOnline:
		return (void*)soap_instantiate_SRMv2__srmBringOnline(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfBringOnlineRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPutResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		return (void*)soap_instantiate_SRMv2__srmPrepareToPut(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfPutRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		return (void*)soap_instantiate_SRMv2__srmCopyResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmCopy:
		return (void*)soap_instantiate_SRMv2__srmCopy(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		return (void*)soap_instantiate_SRMv2__srmStatusOfCopyRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmReleaseFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		return (void*)soap_instantiate_SRMv2__srmReleaseFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		return (void*)soap_instantiate_SRMv2__srmPutDoneResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPutDone:
		return (void*)soap_instantiate_SRMv2__srmPutDone(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmAbortRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		return (void*)soap_instantiate_SRMv2__srmAbortRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		return (void*)soap_instantiate_SRMv2__srmAbortFilesResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		return (void*)soap_instantiate_SRMv2__srmAbortFiles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		return (void*)soap_instantiate_SRMv2__srmSuspendRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		return (void*)soap_instantiate_SRMv2__srmResumeRequestResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		return (void*)soap_instantiate_SRMv2__srmResumeRequest(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummaryResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		return (void*)soap_instantiate_SRMv2__srmGetRequestSummary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		return (void*)soap_instantiate_SRMv2__srmExtendFileLifeTime(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetRequestTokensResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetRequestTokens:
		return (void*)soap_instantiate_SRMv2__srmGetRequestTokens(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_:
		return (void*)soap_instantiate_SRMv2__srmGetTransferProtocolsResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmGetTransferProtocols:
		return (void*)soap_instantiate_SRMv2__srmGetTransferProtocols(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPingResponse_:
		return (void*)soap_instantiate_SRMv2__srmPingResponse_(soap, -1, type, arrayType, n);
	case SOAP_TYPE_SRMv2__srmPing:
		return (void*)soap_instantiate_SRMv2__srmPing(soap, -1, type, arrayType, n);
	}
	return NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_SRMv2__TRetentionPolicyInfo:
		if (p->size < 0)
			delete (SRMv2__TRetentionPolicyInfo*)p->ptr;
		else
			delete[] (SRMv2__TRetentionPolicyInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TUserPermission:
		if (p->size < 0)
			delete (SRMv2__TUserPermission*)p->ptr;
		else
			delete[] (SRMv2__TUserPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTUserPermission:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTUserPermission*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTUserPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGroupPermission:
		if (p->size < 0)
			delete (SRMv2__TGroupPermission*)p->ptr;
		else
			delete[] (SRMv2__TGroupPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGroupPermission:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGroupPermission*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGroupPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfUnsignedLong:
		if (p->size < 0)
			delete (SRMv2__ArrayOfUnsignedLong*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfUnsignedLong*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfString:
		if (p->size < 0)
			delete (SRMv2__ArrayOfString*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfString*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TReturnStatus:
		if (p->size < 0)
			delete (SRMv2__TReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__TReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLReturnStatus:
		if (p->size < 0)
			delete (SRMv2__TSURLReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__TSURLReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLReturnStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLLifetimeReturnStatus:
		if (p->size < 0)
			delete (SRMv2__TSURLLifetimeReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__TSURLLifetimeReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLLifetimeReturnStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLLifetimeReturnStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLLifetimeReturnStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TMetaDataPathDetail:
		if (p->size < 0)
			delete (SRMv2__TMetaDataPathDetail*)p->ptr;
		else
			delete[] (SRMv2__TMetaDataPathDetail*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataPathDetail:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTMetaDataPathDetail*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTMetaDataPathDetail*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TMetaDataSpace:
		if (p->size < 0)
			delete (SRMv2__TMetaDataSpace*)p->ptr;
		else
			delete[] (SRMv2__TMetaDataSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTMetaDataSpace:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTMetaDataSpace*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTMetaDataSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TDirOption:
		if (p->size < 0)
			delete (SRMv2__TDirOption*)p->ptr;
		else
			delete[] (SRMv2__TDirOption*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TExtraInfo:
		if (p->size < 0)
			delete (SRMv2__TExtraInfo*)p->ptr;
		else
			delete[] (SRMv2__TExtraInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTExtraInfo:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTExtraInfo*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTExtraInfo*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfAnyURI:
		if (p->size < 0)
			delete (SRMv2__ArrayOfAnyURI*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfAnyURI*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TTransferParameters:
		if (p->size < 0)
			delete (SRMv2__TTransferParameters*)p->ptr;
		else
			delete[] (SRMv2__TTransferParameters*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGetFileRequest:
		if (p->size < 0)
			delete (SRMv2__TGetFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TGetFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGetFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGetFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TPutFileRequest:
		if (p->size < 0)
			delete (SRMv2__TPutFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TPutFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTPutFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTPutFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCopyFileRequest:
		if (p->size < 0)
			delete (SRMv2__TCopyFileRequest*)p->ptr;
		else
			delete[] (SRMv2__TCopyFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyFileRequest:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTCopyFileRequest*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTCopyFileRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TGetRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TGetRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TGetRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTGetRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTGetRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTGetRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TBringOnlineRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TBringOnlineRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TBringOnlineRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTBringOnlineRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTBringOnlineRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTBringOnlineRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TPutRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TPutRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TPutRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTPutRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTPutRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TCopyRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__TCopyRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__TCopyRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTCopyRequestFileStatus*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTCopyRequestFileStatus*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TRequestSummary:
		if (p->size < 0)
			delete (SRMv2__TRequestSummary*)p->ptr;
		else
			delete[] (SRMv2__TRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestSummary:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTRequestSummary*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSURLPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__TSURLPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__TSURLPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSURLPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSURLPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__TPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__TPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTPermissionReturn*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTPermissionReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TRequestTokenReturn:
		if (p->size < 0)
			delete (SRMv2__TRequestTokenReturn*)p->ptr;
		else
			delete[] (SRMv2__TRequestTokenReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTRequestTokenReturn*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTRequestTokenReturn*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__TSupportedTransferProtocol:
		if (p->size < 0)
			delete (SRMv2__TSupportedTransferProtocol*)p->ptr;
		else
			delete[] (SRMv2__TSupportedTransferProtocol*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol:
		if (p->size < 0)
			delete (SRMv2__ArrayOfTSupportedTransferProtocol*)p->ptr;
		else
			delete[] (SRMv2__ArrayOfTSupportedTransferProtocol*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmReserveSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReserveSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmReserveSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReserveSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfReserveSpaceRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfReserveSpaceRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfReserveSpaceRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfReserveSpaceRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmReleaseSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmReleaseSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmUpdateSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmUpdateSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmUpdateSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmUpdateSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfUpdateSpaceRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfUpdateSpaceRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfUpdateSpaceRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfUpdateSpaceRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceMetaDataRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceMetaDataRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceMetaDataResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceMetaDataResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmChangeSpaceForFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmChangeSpaceForFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmChangeSpaceForFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmChangeSpaceForFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeInSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeInSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeInSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeInSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest:
		if (p->size < 0)
			delete (SRMv2__srmPurgeFromSpaceRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPurgeFromSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse:
		if (p->size < 0)
			delete (SRMv2__srmPurgeFromSpaceResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPurgeFromSpaceResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceTokensRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceTokensRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetSpaceTokensResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetSpaceTokensResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionRequest:
		if (p->size < 0)
			delete (SRMv2__srmSetPermissionRequest*)p->ptr;
		else
			delete[] (SRMv2__srmSetPermissionRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse:
		if (p->size < 0)
			delete (SRMv2__srmSetPermissionResponse*)p->ptr;
		else
			delete[] (SRMv2__srmSetPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionRequest:
		if (p->size < 0)
			delete (SRMv2__srmCheckPermissionRequest*)p->ptr;
		else
			delete[] (SRMv2__srmCheckPermissionRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse:
		if (p->size < 0)
			delete (SRMv2__srmCheckPermissionResponse*)p->ptr;
		else
			delete[] (SRMv2__srmCheckPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetPermissionRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetPermissionRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetPermissionResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetPermissionResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirRequest:
		if (p->size < 0)
			delete (SRMv2__srmMkdirRequest*)p->ptr;
		else
			delete[] (SRMv2__srmMkdirRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse:
		if (p->size < 0)
			delete (SRMv2__srmMkdirResponse*)p->ptr;
		else
			delete[] (SRMv2__srmMkdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirRequest:
		if (p->size < 0)
			delete (SRMv2__srmRmdirRequest*)p->ptr;
		else
			delete[] (SRMv2__srmRmdirRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse:
		if (p->size < 0)
			delete (SRMv2__srmRmdirResponse*)p->ptr;
		else
			delete[] (SRMv2__srmRmdirResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmRequest:
		if (p->size < 0)
			delete (SRMv2__srmRmRequest*)p->ptr;
		else
			delete[] (SRMv2__srmRmRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse:
		if (p->size < 0)
			delete (SRMv2__srmRmResponse*)p->ptr;
		else
			delete[] (SRMv2__srmRmResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsRequest:
		if (p->size < 0)
			delete (SRMv2__srmLsRequest*)p->ptr;
		else
			delete[] (SRMv2__srmLsRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse:
		if (p->size < 0)
			delete (SRMv2__srmLsResponse*)p->ptr;
		else
			delete[] (SRMv2__srmLsResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfLsRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfLsRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfLsRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfLsRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvRequest:
		if (p->size < 0)
			delete (SRMv2__srmMvRequest*)p->ptr;
		else
			delete[] (SRMv2__srmMvRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse:
		if (p->size < 0)
			delete (SRMv2__srmMvResponse*)p->ptr;
		else
			delete[] (SRMv2__srmMvResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetRequest:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToGetRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToGetRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToGetResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToGetResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfGetRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfGetRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfGetRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfGetRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineRequest:
		if (p->size < 0)
			delete (SRMv2__srmBringOnlineRequest*)p->ptr;
		else
			delete[] (SRMv2__srmBringOnlineRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse:
		if (p->size < 0)
			delete (SRMv2__srmBringOnlineResponse*)p->ptr;
		else
			delete[] (SRMv2__srmBringOnlineResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfBringOnlineRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfBringOnlineRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfBringOnlineRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfBringOnlineRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutRequest:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToPutRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToPutRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse:
		if (p->size < 0)
			delete (SRMv2__srmPrepareToPutResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPrepareToPutResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfPutRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfPutRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfPutRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfPutRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyRequest:
		if (p->size < 0)
			delete (SRMv2__srmCopyRequest*)p->ptr;
		else
			delete[] (SRMv2__srmCopyRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse:
		if (p->size < 0)
			delete (SRMv2__srmCopyResponse*)p->ptr;
		else
			delete[] (SRMv2__srmCopyResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfCopyRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfCopyRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmStatusOfCopyRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmStatusOfCopyRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmReleaseFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmReleaseFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmReleaseFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneRequest:
		if (p->size < 0)
			delete (SRMv2__srmPutDoneRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPutDoneRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse:
		if (p->size < 0)
			delete (SRMv2__srmPutDoneResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPutDoneResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmAbortRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmAbortRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmAbortRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmAbortRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesRequest:
		if (p->size < 0)
			delete (SRMv2__srmAbortFilesRequest*)p->ptr;
		else
			delete[] (SRMv2__srmAbortFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse:
		if (p->size < 0)
			delete (SRMv2__srmAbortFilesResponse*)p->ptr;
		else
			delete[] (SRMv2__srmAbortFilesResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmSuspendRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmSuspendRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmSuspendRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmSuspendRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestRequest:
		if (p->size < 0)
			delete (SRMv2__srmResumeRequestRequest*)p->ptr;
		else
			delete[] (SRMv2__srmResumeRequestRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse:
		if (p->size < 0)
			delete (SRMv2__srmResumeRequestResponse*)p->ptr;
		else
			delete[] (SRMv2__srmResumeRequestResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestSummaryRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestSummaryRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestSummaryResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestSummaryResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeRequest*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse:
		if (p->size < 0)
			delete (SRMv2__srmExtendFileLifeTimeResponse*)p->ptr;
		else
			delete[] (SRMv2__srmExtendFileLifeTimeResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestTokensRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestTokensRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetRequestTokensResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetRequestTokensResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest:
		if (p->size < 0)
			delete (SRMv2__srmGetTransferProtocolsRequest*)p->ptr;
		else
			delete[] (SRMv2__srmGetTransferProtocolsRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse:
		if (p->size < 0)
			delete (SRMv2__srmGetTransferProtocolsResponse*)p->ptr;
		else
			delete[] (SRMv2__srmGetTransferProtocolsResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPingRequest:
		if (p->size < 0)
			delete (SRMv2__srmPingRequest*)p->ptr;
		else
			delete[] (SRMv2__srmPingRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPingResponse:
		if (p->size < 0)
			delete (SRMv2__srmPingResponse*)p->ptr;
		else
			delete[] (SRMv2__srmPingResponse*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReserveSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReserveSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReserveSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmReserveSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmReserveSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfReserveSpaceRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfReserveSpaceRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfReserveSpaceRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfReserveSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmUpdateSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmUpdateSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmUpdateSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmUpdateSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmUpdateSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfUpdateSpaceRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfUpdateSpaceRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfUpdateSpaceRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfUpdateSpaceRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceMetaDataResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceMetaDataResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceMetaData:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceMetaData*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceMetaData*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmChangeSpaceForFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmChangeSpaceForFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmChangeSpaceForFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmChangeSpaceForFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmChangeSpaceForFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfChangeSpaceForFilesRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfChangeSpaceForFilesRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTimeInSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTimeInSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTimeInSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTimeInSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPurgeFromSpaceResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPurgeFromSpaceResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPurgeFromSpace:
		if (p->size < 0)
			delete (struct SRMv2__srmPurgeFromSpace*)p->ptr;
		else
			delete[] (struct SRMv2__srmPurgeFromSpace*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceTokensResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceTokensResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetSpaceTokens:
		if (p->size < 0)
			delete (struct SRMv2__srmGetSpaceTokens*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetSpaceTokens*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermissionResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmSetPermissionResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmSetPermissionResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSetPermission:
		if (p->size < 0)
			delete (struct SRMv2__srmSetPermission*)p->ptr;
		else
			delete[] (struct SRMv2__srmSetPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermissionResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmCheckPermissionResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmCheckPermissionResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCheckPermission:
		if (p->size < 0)
			delete (struct SRMv2__srmCheckPermission*)p->ptr;
		else
			delete[] (struct SRMv2__srmCheckPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetPermissionResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetPermissionResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetPermissionResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetPermission:
		if (p->size < 0)
			delete (struct SRMv2__srmGetPermission*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetPermission*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdirResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmMkdirResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmMkdirResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMkdir:
		if (p->size < 0)
			delete (struct SRMv2__srmMkdir*)p->ptr;
		else
			delete[] (struct SRMv2__srmMkdir*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdirResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmRmdirResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmdirResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmdir:
		if (p->size < 0)
			delete (struct SRMv2__srmRmdir*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmdir*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRmResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmRmResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmRmResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmRm:
		if (p->size < 0)
			delete (struct SRMv2__srmRm*)p->ptr;
		else
			delete[] (struct SRMv2__srmRm*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLsResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmLsResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmLsResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmLs:
		if (p->size < 0)
			delete (struct SRMv2__srmLs*)p->ptr;
		else
			delete[] (struct SRMv2__srmLs*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfLsRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfLsRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfLsRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfLsRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfLsRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMvResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmMvResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmMvResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmMv:
		if (p->size < 0)
			delete (struct SRMv2__srmMv*)p->ptr;
		else
			delete[] (struct SRMv2__srmMv*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGetResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToGetResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToGetResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToGet:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToGet*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToGet*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfGetRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfGetRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfGetRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfGetRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfGetRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmBringOnlineResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmBringOnlineResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmBringOnlineResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmBringOnline:
		if (p->size < 0)
			delete (struct SRMv2__srmBringOnline*)p->ptr;
		else
			delete[] (struct SRMv2__srmBringOnline*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfBringOnlineRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfBringOnlineRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfBringOnlineRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfBringOnlineRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPutResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToPutResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToPutResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPrepareToPut:
		if (p->size < 0)
			delete (struct SRMv2__srmPrepareToPut*)p->ptr;
		else
			delete[] (struct SRMv2__srmPrepareToPut*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfPutRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfPutRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfPutRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfPutRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfPutRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopyResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmCopyResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmCopyResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmCopy:
		if (p->size < 0)
			delete (struct SRMv2__srmCopy*)p->ptr;
		else
			delete[] (struct SRMv2__srmCopy*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfCopyRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfCopyRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmStatusOfCopyRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmStatusOfCopyRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmStatusOfCopyRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmReleaseFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmReleaseFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmReleaseFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDoneResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPutDoneResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPutDoneResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPutDone:
		if (p->size < 0)
			delete (struct SRMv2__srmPutDone*)p->ptr;
		else
			delete[] (struct SRMv2__srmPutDone*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFilesResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortFilesResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortFilesResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmAbortFiles:
		if (p->size < 0)
			delete (struct SRMv2__srmAbortFiles*)p->ptr;
		else
			delete[] (struct SRMv2__srmAbortFiles*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmSuspendRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmSuspendRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmSuspendRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmSuspendRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmSuspendRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequestResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmResumeRequestResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmResumeRequestResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmResumeRequest:
		if (p->size < 0)
			delete (struct SRMv2__srmResumeRequest*)p->ptr;
		else
			delete[] (struct SRMv2__srmResumeRequest*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestSummaryResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestSummaryResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestSummary:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestSummary*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestSummary*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTimeResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTimeResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmExtendFileLifeTime:
		if (p->size < 0)
			delete (struct SRMv2__srmExtendFileLifeTime*)p->ptr;
		else
			delete[] (struct SRMv2__srmExtendFileLifeTime*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokensResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestTokensResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestTokensResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetRequestTokens:
		if (p->size < 0)
			delete (struct SRMv2__srmGetRequestTokens*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetRequestTokens*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmGetTransferProtocolsResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetTransferProtocolsResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmGetTransferProtocols:
		if (p->size < 0)
			delete (struct SRMv2__srmGetTransferProtocols*)p->ptr;
		else
			delete[] (struct SRMv2__srmGetTransferProtocols*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPingResponse_:
		if (p->size < 0)
			delete (struct SRMv2__srmPingResponse_*)p->ptr;
		else
			delete[] (struct SRMv2__srmPingResponse_*)p->ptr;
		break;
	case SOAP_TYPE_SRMv2__srmPing:
		if (p->size < 0)
			delete (struct SRMv2__srmPing*)p->ptr;
		else
			delete[] (struct SRMv2__srmPing*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	}
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedLONG64(struct soap *soap, ULONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedLONG64
	*a = SOAP_DEFAULT_unsignedLONG64;
#else
	*a = (ULONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedLONG64(struct soap *soap, const ULONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedLONG64);
	if (soap_out_unsignedLONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedLONG64(struct soap *soap, const char *tag, int id, const ULONG64 *a, const char *type)
{
	return soap_outULONG64(soap, tag, id, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_get_unsignedLONG64(struct soap *soap, ULONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedLONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 ULONG64 * SOAP_FMAC4 soap_in_unsignedLONG64(struct soap *soap, const char *tag, ULONG64 *a, const char *type)
{
	return soap_inULONG64(soap, tag, a, type, SOAP_TYPE_unsignedLONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	const char *s = soap_code_str(soap_codes_bool, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type);
	soap_send(soap, soap_bool2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TStatusCode(struct soap *soap, enum SRMv2__TStatusCode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TStatusCode
	*a = SOAP_DEFAULT_SRMv2__TStatusCode;
#else
	*a = (enum SRMv2__TStatusCode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TStatusCode(struct soap *soap, const enum SRMv2__TStatusCode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TStatusCode);
	if (soap_out_SRMv2__TStatusCode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TStatusCode[] =
{	{ (long)SRMv2__TStatusCode__SRM_USCORESUCCESS, "SRM_SUCCESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFAILURE, "SRM_FAILURE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREAUTHENTICATION_USCOREFAILURE, "SRM_AUTHENTICATION_FAILURE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREAUTHORIZATION_USCOREFAILURE, "SRM_AUTHORIZATION_FAILURE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINVALID_USCOREREQUEST, "SRM_INVALID_REQUEST" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINVALID_USCOREPATH, "SRM_INVALID_PATH" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCORELIFETIME_USCOREEXPIRED, "SRM_FILE_LIFETIME_EXPIRED" },
	{ (long)SRMv2__TStatusCode__SRM_USCORESPACE_USCORELIFETIME_USCOREEXPIRED, "SRM_SPACE_LIFETIME_EXPIRED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREEXCEED_USCOREALLOCATION, "SRM_EXCEED_ALLOCATION" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENO_USCOREUSER_USCORESPACE, "SRM_NO_USER_SPACE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENO_USCOREFREE_USCORESPACE, "SRM_NO_FREE_SPACE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREDUPLICATION_USCOREERROR, "SRM_DUPLICATION_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENON_USCOREEMPTY_USCOREDIRECTORY, "SRM_NON_EMPTY_DIRECTORY" },
	{ (long)SRMv2__TStatusCode__SRM_USCORETOO_USCOREMANY_USCORERESULTS, "SRM_TOO_MANY_RESULTS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREINTERNAL_USCOREERROR, "SRM_INTERNAL_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFATAL_USCOREINTERNAL_USCOREERROR, "SRM_FATAL_INTERNAL_ERROR" },
	{ (long)SRMv2__TStatusCode__SRM_USCORENOT_USCORESUPPORTED, "SRM_NOT_SUPPORTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCOREQUEUED, "SRM_REQUEST_QUEUED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCOREINPROGRESS, "SRM_REQUEST_INPROGRESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCORESUSPENDED, "SRM_REQUEST_SUSPENDED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREABORTED, "SRM_ABORTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCORERELEASED, "SRM_RELEASED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREPINNED, "SRM_FILE_PINNED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREIN_USCORECACHE, "SRM_FILE_IN_CACHE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORESPACE_USCOREAVAILABLE, "SRM_SPACE_AVAILABLE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORELOWER_USCORESPACE_USCOREGRANTED, "SRM_LOWER_SPACE_GRANTED" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREDONE, "SRM_DONE" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREPARTIAL_USCORESUCCESS, "SRM_PARTIAL_SUCCESS" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREREQUEST_USCORETIMED_USCOREOUT, "SRM_REQUEST_TIMED_OUT" },
	{ (long)SRMv2__TStatusCode__SRM_USCORELAST_USCORECOPY, "SRM_LAST_COPY" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREBUSY, "SRM_FILE_BUSY" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCORELOST, "SRM_FILE_LOST" },
	{ (long)SRMv2__TStatusCode__SRM_USCOREFILE_USCOREUNAVAILABLE, "SRM_FILE_UNAVAILABLE" },
	{ (long)SRMv2__TStatusCode__SRM_USCORECUSTOM_USCORESTATUS, "SRM_CUSTOM_STATUS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TStatusCode2s(struct soap *soap, enum SRMv2__TStatusCode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TStatusCode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TStatusCode(struct soap *soap, const char *tag, int id, const enum SRMv2__TStatusCode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TStatusCode), type);
	soap_send(soap, soap_SRMv2__TStatusCode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TStatusCode * SOAP_FMAC4 soap_get_SRMv2__TStatusCode(struct soap *soap, enum SRMv2__TStatusCode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TStatusCode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TStatusCode(struct soap *soap, const char *s, enum SRMv2__TStatusCode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TStatusCode, s);
	if (map)
		*a = (enum SRMv2__TStatusCode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 33)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TStatusCode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TStatusCode * SOAP_FMAC4 soap_in_SRMv2__TStatusCode(struct soap *soap, const char *tag, enum SRMv2__TStatusCode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TStatusCode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TStatusCode, sizeof(enum SRMv2__TStatusCode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TStatusCode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TStatusCode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TStatusCode, 0, sizeof(enum SRMv2__TStatusCode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TConnectionType(struct soap *soap, enum SRMv2__TConnectionType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TConnectionType
	*a = SOAP_DEFAULT_SRMv2__TConnectionType;
#else
	*a = (enum SRMv2__TConnectionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TConnectionType(struct soap *soap, const enum SRMv2__TConnectionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TConnectionType);
	if (soap_out_SRMv2__TConnectionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TConnectionType[] =
{	{ (long)SRMv2__TConnectionType__WAN, "WAN" },
	{ (long)SRMv2__TConnectionType__LAN, "LAN" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TConnectionType2s(struct soap *soap, enum SRMv2__TConnectionType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TConnectionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TConnectionType(struct soap *soap, const char *tag, int id, const enum SRMv2__TConnectionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TConnectionType), type);
	soap_send(soap, soap_SRMv2__TConnectionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TConnectionType * SOAP_FMAC4 soap_get_SRMv2__TConnectionType(struct soap *soap, enum SRMv2__TConnectionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TConnectionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TConnectionType(struct soap *soap, const char *s, enum SRMv2__TConnectionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TConnectionType, s);
	if (map)
		*a = (enum SRMv2__TConnectionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TConnectionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TConnectionType * SOAP_FMAC4 soap_in_SRMv2__TConnectionType(struct soap *soap, const char *tag, enum SRMv2__TConnectionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TConnectionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TConnectionType, sizeof(enum SRMv2__TConnectionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TConnectionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TConnectionType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TConnectionType, 0, sizeof(enum SRMv2__TConnectionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TAccessPattern(struct soap *soap, enum SRMv2__TAccessPattern *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TAccessPattern
	*a = SOAP_DEFAULT_SRMv2__TAccessPattern;
#else
	*a = (enum SRMv2__TAccessPattern)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TAccessPattern(struct soap *soap, const enum SRMv2__TAccessPattern *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TAccessPattern);
	if (soap_out_SRMv2__TAccessPattern(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TAccessPattern[] =
{	{ (long)SRMv2__TAccessPattern__TRANSFER_USCOREMODE, "TRANSFER_MODE" },
	{ (long)SRMv2__TAccessPattern__PROCESSING_USCOREMODE, "PROCESSING_MODE" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TAccessPattern2s(struct soap *soap, enum SRMv2__TAccessPattern n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TAccessPattern, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TAccessPattern(struct soap *soap, const char *tag, int id, const enum SRMv2__TAccessPattern *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TAccessPattern), type);
	soap_send(soap, soap_SRMv2__TAccessPattern2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TAccessPattern * SOAP_FMAC4 soap_get_SRMv2__TAccessPattern(struct soap *soap, enum SRMv2__TAccessPattern *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TAccessPattern(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TAccessPattern(struct soap *soap, const char *s, enum SRMv2__TAccessPattern *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TAccessPattern, s);
	if (map)
		*a = (enum SRMv2__TAccessPattern)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TAccessPattern)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TAccessPattern * SOAP_FMAC4 soap_in_SRMv2__TAccessPattern(struct soap *soap, const char *tag, enum SRMv2__TAccessPattern *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TAccessPattern *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TAccessPattern, sizeof(enum SRMv2__TAccessPattern), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TAccessPattern(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TAccessPattern *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TAccessPattern, 0, sizeof(enum SRMv2__TAccessPattern), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TFileLocality(struct soap *soap, enum SRMv2__TFileLocality *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TFileLocality
	*a = SOAP_DEFAULT_SRMv2__TFileLocality;
#else
	*a = (enum SRMv2__TFileLocality)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TFileLocality(struct soap *soap, const enum SRMv2__TFileLocality *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TFileLocality);
	if (soap_out_SRMv2__TFileLocality(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TFileLocality[] =
{	{ (long)SRMv2__TFileLocality__ONLINE, "ONLINE" },
	{ (long)SRMv2__TFileLocality__NEARLINE, "NEARLINE" },
	{ (long)SRMv2__TFileLocality__ONLINE_USCOREAND_USCORENEARLINE, "ONLINE_AND_NEARLINE" },
	{ (long)SRMv2__TFileLocality__LOST, "LOST" },
	{ (long)SRMv2__TFileLocality__NONE, "NONE" },
	{ (long)SRMv2__TFileLocality__UNAVAILABLE, "UNAVAILABLE" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TFileLocality2s(struct soap *soap, enum SRMv2__TFileLocality n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TFileLocality, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TFileLocality(struct soap *soap, const char *tag, int id, const enum SRMv2__TFileLocality *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TFileLocality), type);
	soap_send(soap, soap_SRMv2__TFileLocality2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TFileLocality * SOAP_FMAC4 soap_get_SRMv2__TFileLocality(struct soap *soap, enum SRMv2__TFileLocality *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TFileLocality(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TFileLocality(struct soap *soap, const char *s, enum SRMv2__TFileLocality *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TFileLocality, s);
	if (map)
		*a = (enum SRMv2__TFileLocality)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 5)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TFileLocality)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TFileLocality * SOAP_FMAC4 soap_in_SRMv2__TFileLocality(struct soap *soap, const char *tag, enum SRMv2__TFileLocality *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TFileLocality *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TFileLocality, sizeof(enum SRMv2__TFileLocality), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TFileLocality(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TFileLocality *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TFileLocality, 0, sizeof(enum SRMv2__TFileLocality), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TOverwriteMode(struct soap *soap, enum SRMv2__TOverwriteMode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TOverwriteMode
	*a = SOAP_DEFAULT_SRMv2__TOverwriteMode;
#else
	*a = (enum SRMv2__TOverwriteMode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TOverwriteMode(struct soap *soap, const enum SRMv2__TOverwriteMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TOverwriteMode);
	if (soap_out_SRMv2__TOverwriteMode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TOverwriteMode[] =
{	{ (long)SRMv2__TOverwriteMode__NEVER, "NEVER" },
	{ (long)SRMv2__TOverwriteMode__ALWAYS, "ALWAYS" },
	{ (long)SRMv2__TOverwriteMode__WHEN_USCOREFILES_USCOREARE_USCOREDIFFERENT, "WHEN_FILES_ARE_DIFFERENT" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TOverwriteMode2s(struct soap *soap, enum SRMv2__TOverwriteMode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TOverwriteMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TOverwriteMode(struct soap *soap, const char *tag, int id, const enum SRMv2__TOverwriteMode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TOverwriteMode), type);
	soap_send(soap, soap_SRMv2__TOverwriteMode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TOverwriteMode * SOAP_FMAC4 soap_get_SRMv2__TOverwriteMode(struct soap *soap, enum SRMv2__TOverwriteMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TOverwriteMode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TOverwriteMode(struct soap *soap, const char *s, enum SRMv2__TOverwriteMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TOverwriteMode, s);
	if (map)
		*a = (enum SRMv2__TOverwriteMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TOverwriteMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TOverwriteMode * SOAP_FMAC4 soap_in_SRMv2__TOverwriteMode(struct soap *soap, const char *tag, enum SRMv2__TOverwriteMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TOverwriteMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TOverwriteMode, sizeof(enum SRMv2__TOverwriteMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TOverwriteMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TOverwriteMode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TOverwriteMode, 0, sizeof(enum SRMv2__TOverwriteMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TRequestType(struct soap *soap, enum SRMv2__TRequestType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TRequestType
	*a = SOAP_DEFAULT_SRMv2__TRequestType;
#else
	*a = (enum SRMv2__TRequestType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TRequestType(struct soap *soap, const enum SRMv2__TRequestType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestType);
	if (soap_out_SRMv2__TRequestType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TRequestType[] =
{	{ (long)SRMv2__TRequestType__PREPARE_USCORETO_USCOREGET, "PREPARE_TO_GET" },
	{ (long)SRMv2__TRequestType__PREPARE_USCORETO_USCOREPUT, "PREPARE_TO_PUT" },
	{ (long)SRMv2__TRequestType__COPY, "COPY" },
	{ (long)SRMv2__TRequestType__BRING_USCOREONLINE, "BRING_ONLINE" },
	{ (long)SRMv2__TRequestType__RESERVE_USCORESPACE, "RESERVE_SPACE" },
	{ (long)SRMv2__TRequestType__UPDATE_USCORESPACE, "UPDATE_SPACE" },
	{ (long)SRMv2__TRequestType__CHANGE_USCORESPACE_USCOREFOR_USCOREFILES, "CHANGE_SPACE_FOR_FILES" },
	{ (long)SRMv2__TRequestType__LS, "LS" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TRequestType2s(struct soap *soap, enum SRMv2__TRequestType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TRequestType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestType(struct soap *soap, const char *tag, int id, const enum SRMv2__TRequestType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestType), type);
	soap_send(soap, soap_SRMv2__TRequestType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TRequestType * SOAP_FMAC4 soap_get_SRMv2__TRequestType(struct soap *soap, enum SRMv2__TRequestType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TRequestType(struct soap *soap, const char *s, enum SRMv2__TRequestType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TRequestType, s);
	if (map)
		*a = (enum SRMv2__TRequestType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 7)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TRequestType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TRequestType * SOAP_FMAC4 soap_in_SRMv2__TRequestType(struct soap *soap, const char *tag, enum SRMv2__TRequestType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TRequestType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestType, sizeof(enum SRMv2__TRequestType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TRequestType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TRequestType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestType, 0, sizeof(enum SRMv2__TRequestType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TPermissionType(struct soap *soap, enum SRMv2__TPermissionType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TPermissionType
	*a = SOAP_DEFAULT_SRMv2__TPermissionType;
#else
	*a = (enum SRMv2__TPermissionType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TPermissionType(struct soap *soap, const enum SRMv2__TPermissionType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TPermissionType);
	if (soap_out_SRMv2__TPermissionType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TPermissionType[] =
{	{ (long)SRMv2__TPermissionType__ADD, "ADD" },
	{ (long)SRMv2__TPermissionType__REMOVE, "REMOVE" },
	{ (long)SRMv2__TPermissionType__CHANGE, "CHANGE" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TPermissionType2s(struct soap *soap, enum SRMv2__TPermissionType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TPermissionType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPermissionType(struct soap *soap, const char *tag, int id, const enum SRMv2__TPermissionType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPermissionType), type);
	soap_send(soap, soap_SRMv2__TPermissionType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TPermissionType * SOAP_FMAC4 soap_get_SRMv2__TPermissionType(struct soap *soap, enum SRMv2__TPermissionType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPermissionType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TPermissionType(struct soap *soap, const char *s, enum SRMv2__TPermissionType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TPermissionType, s);
	if (map)
		*a = (enum SRMv2__TPermissionType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TPermissionType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TPermissionType * SOAP_FMAC4 soap_in_SRMv2__TPermissionType(struct soap *soap, const char *tag, enum SRMv2__TPermissionType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TPermissionType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPermissionType, sizeof(enum SRMv2__TPermissionType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TPermissionType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TPermissionType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPermissionType, 0, sizeof(enum SRMv2__TPermissionType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TPermissionMode(struct soap *soap, enum SRMv2__TPermissionMode *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TPermissionMode
	*a = SOAP_DEFAULT_SRMv2__TPermissionMode;
#else
	*a = (enum SRMv2__TPermissionMode)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TPermissionMode(struct soap *soap, const enum SRMv2__TPermissionMode *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TPermissionMode);
	if (soap_out_SRMv2__TPermissionMode(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TPermissionMode[] =
{	{ (long)SRMv2__TPermissionMode__NONE, "NONE" },
	{ (long)SRMv2__TPermissionMode__X, "X" },
	{ (long)SRMv2__TPermissionMode__W, "W" },
	{ (long)SRMv2__TPermissionMode__WX, "WX" },
	{ (long)SRMv2__TPermissionMode__R, "R" },
	{ (long)SRMv2__TPermissionMode__RX, "RX" },
	{ (long)SRMv2__TPermissionMode__RW, "RW" },
	{ (long)SRMv2__TPermissionMode__RWX, "RWX" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TPermissionMode2s(struct soap *soap, enum SRMv2__TPermissionMode n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TPermissionMode, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPermissionMode(struct soap *soap, const char *tag, int id, const enum SRMv2__TPermissionMode *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPermissionMode), type);
	soap_send(soap, soap_SRMv2__TPermissionMode2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TPermissionMode * SOAP_FMAC4 soap_get_SRMv2__TPermissionMode(struct soap *soap, enum SRMv2__TPermissionMode *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPermissionMode(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TPermissionMode(struct soap *soap, const char *s, enum SRMv2__TPermissionMode *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TPermissionMode, s);
	if (map)
		*a = (enum SRMv2__TPermissionMode)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 7)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TPermissionMode)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TPermissionMode * SOAP_FMAC4 soap_in_SRMv2__TPermissionMode(struct soap *soap, const char *tag, enum SRMv2__TPermissionMode *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TPermissionMode *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPermissionMode, sizeof(enum SRMv2__TPermissionMode), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TPermissionMode(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TPermissionMode *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPermissionMode, 0, sizeof(enum SRMv2__TPermissionMode), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TAccessLatency(struct soap *soap, enum SRMv2__TAccessLatency *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TAccessLatency
	*a = SOAP_DEFAULT_SRMv2__TAccessLatency;
#else
	*a = (enum SRMv2__TAccessLatency)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TAccessLatency(struct soap *soap, const enum SRMv2__TAccessLatency *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TAccessLatency);
	if (soap_out_SRMv2__TAccessLatency(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TAccessLatency[] =
{	{ (long)SRMv2__TAccessLatency__ONLINE, "ONLINE" },
	{ (long)SRMv2__TAccessLatency__NEARLINE, "NEARLINE" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TAccessLatency2s(struct soap *soap, enum SRMv2__TAccessLatency n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TAccessLatency, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TAccessLatency(struct soap *soap, const char *tag, int id, const enum SRMv2__TAccessLatency *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TAccessLatency), type);
	soap_send(soap, soap_SRMv2__TAccessLatency2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TAccessLatency * SOAP_FMAC4 soap_get_SRMv2__TAccessLatency(struct soap *soap, enum SRMv2__TAccessLatency *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TAccessLatency(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TAccessLatency(struct soap *soap, const char *s, enum SRMv2__TAccessLatency *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TAccessLatency, s);
	if (map)
		*a = (enum SRMv2__TAccessLatency)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 1)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TAccessLatency)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TAccessLatency * SOAP_FMAC4 soap_in_SRMv2__TAccessLatency(struct soap *soap, const char *tag, enum SRMv2__TAccessLatency *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TAccessLatency *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TAccessLatency, sizeof(enum SRMv2__TAccessLatency), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TAccessLatency(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TAccessLatency *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TAccessLatency, 0, sizeof(enum SRMv2__TAccessLatency), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TRetentionPolicy(struct soap *soap, enum SRMv2__TRetentionPolicy *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TRetentionPolicy
	*a = SOAP_DEFAULT_SRMv2__TRetentionPolicy;
#else
	*a = (enum SRMv2__TRetentionPolicy)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TRetentionPolicy(struct soap *soap, const enum SRMv2__TRetentionPolicy *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TRetentionPolicy);
	if (soap_out_SRMv2__TRetentionPolicy(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TRetentionPolicy[] =
{	{ (long)SRMv2__TRetentionPolicy__REPLICA, "REPLICA" },
	{ (long)SRMv2__TRetentionPolicy__OUTPUT, "OUTPUT" },
	{ (long)SRMv2__TRetentionPolicy__CUSTODIAL, "CUSTODIAL" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TRetentionPolicy2s(struct soap *soap, enum SRMv2__TRetentionPolicy n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TRetentionPolicy, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRetentionPolicy(struct soap *soap, const char *tag, int id, const enum SRMv2__TRetentionPolicy *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRetentionPolicy), type);
	soap_send(soap, soap_SRMv2__TRetentionPolicy2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TRetentionPolicy * SOAP_FMAC4 soap_get_SRMv2__TRetentionPolicy(struct soap *soap, enum SRMv2__TRetentionPolicy *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRetentionPolicy(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TRetentionPolicy(struct soap *soap, const char *s, enum SRMv2__TRetentionPolicy *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TRetentionPolicy, s);
	if (map)
		*a = (enum SRMv2__TRetentionPolicy)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TRetentionPolicy)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TRetentionPolicy * SOAP_FMAC4 soap_in_SRMv2__TRetentionPolicy(struct soap *soap, const char *tag, enum SRMv2__TRetentionPolicy *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TRetentionPolicy *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRetentionPolicy, sizeof(enum SRMv2__TRetentionPolicy), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TRetentionPolicy(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TRetentionPolicy *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRetentionPolicy, 0, sizeof(enum SRMv2__TRetentionPolicy), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TFileType(struct soap *soap, enum SRMv2__TFileType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TFileType
	*a = SOAP_DEFAULT_SRMv2__TFileType;
#else
	*a = (enum SRMv2__TFileType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TFileType(struct soap *soap, const enum SRMv2__TFileType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TFileType);
	if (soap_out_SRMv2__TFileType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TFileType[] =
{	{ (long)SRMv2__TFileType__FILE_, "FILE" },
	{ (long)SRMv2__TFileType__DIRECTORY, "DIRECTORY" },
	{ (long)SRMv2__TFileType__LINK, "LINK" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TFileType2s(struct soap *soap, enum SRMv2__TFileType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TFileType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TFileType(struct soap *soap, const char *tag, int id, const enum SRMv2__TFileType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TFileType), type);
	soap_send(soap, soap_SRMv2__TFileType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TFileType * SOAP_FMAC4 soap_get_SRMv2__TFileType(struct soap *soap, enum SRMv2__TFileType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TFileType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TFileType(struct soap *soap, const char *s, enum SRMv2__TFileType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TFileType, s);
	if (map)
		*a = (enum SRMv2__TFileType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TFileType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TFileType * SOAP_FMAC4 soap_in_SRMv2__TFileType(struct soap *soap, const char *tag, enum SRMv2__TFileType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TFileType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TFileType, sizeof(enum SRMv2__TFileType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TFileType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TFileType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TFileType, 0, sizeof(enum SRMv2__TFileType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SRMv2__TFileStorageType(struct soap *soap, enum SRMv2__TFileStorageType *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_SRMv2__TFileStorageType
	*a = SOAP_DEFAULT_SRMv2__TFileStorageType;
#else
	*a = (enum SRMv2__TFileStorageType)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SRMv2__TFileStorageType(struct soap *soap, const enum SRMv2__TFileStorageType *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SRMv2__TFileStorageType);
	if (soap_out_SRMv2__TFileStorageType(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_SRMv2__TFileStorageType[] =
{	{ (long)SRMv2__TFileStorageType__VOLATILE, "VOLATILE" },
	{ (long)SRMv2__TFileStorageType__DURABLE, "DURABLE" },
	{ (long)SRMv2__TFileStorageType__PERMANENT, "PERMANENT" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_SRMv2__TFileStorageType2s(struct soap *soap, enum SRMv2__TFileStorageType n)
{	const char *s = soap_code_str(soap_codes_SRMv2__TFileStorageType, (long)n);
	if (s)
		return s;
	return soap_long2s(soap, (long)n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TFileStorageType(struct soap *soap, const char *tag, int id, const enum SRMv2__TFileStorageType *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TFileStorageType), type);
	soap_send(soap, soap_SRMv2__TFileStorageType2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum SRMv2__TFileStorageType * SOAP_FMAC4 soap_get_SRMv2__TFileStorageType(struct soap *soap, enum SRMv2__TFileStorageType *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TFileStorageType(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2SRMv2__TFileStorageType(struct soap *soap, const char *s, enum SRMv2__TFileStorageType *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_SRMv2__TFileStorageType, s);
	if (map)
		*a = (enum SRMv2__TFileStorageType)map->code;
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || ((soap->mode & SOAP_XML_STRICT) && (n < 0 || n > 2)))
			return soap->error = SOAP_TYPE;
		*a = (enum SRMv2__TFileStorageType)n;
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum SRMv2__TFileStorageType * SOAP_FMAC4 soap_in_SRMv2__TFileStorageType(struct soap *soap, const char *tag, enum SRMv2__TFileStorageType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum SRMv2__TFileStorageType *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TFileStorageType, sizeof(enum SRMv2__TFileStorageType), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2SRMv2__TFileStorageType(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum SRMv2__TFileStorageType *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TFileStorageType, 0, sizeof(enum SRMv2__TFileStorageType), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

void SRMv2__srmPingResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPingResponse*)this)->versionInfo);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmPingResponse*)this)->otherInfo);
	/* transient soap skipped */
}

void SRMv2__srmPingResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPingResponse*)this)->versionInfo);
	((SRMv2__srmPingResponse*)this)->otherInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPingResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPingResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPingResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPingResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPingResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPingResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPingResponse), type);
	soap_out_string(soap, "versionInfo", -1, &(((SRMv2__srmPingResponse*)a)->versionInfo), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "otherInfo", -1, &(((SRMv2__srmPingResponse*)a)->otherInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPingResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPingResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPingResponse * SOAP_FMAC4 soap_get_SRMv2__srmPingResponse(struct soap *soap, SRMv2__srmPingResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPingResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPingResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPingResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPingResponse * SOAP_FMAC4 soap_in_SRMv2__srmPingResponse(struct soap *soap, const char *tag, SRMv2__srmPingResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPingResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPingResponse, sizeof(SRMv2__srmPingResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPingResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPingResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_versionInfo1 = 1, soap_flag_otherInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_versionInfo1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "versionInfo", &(((SRMv2__srmPingResponse*)a)->versionInfo), "xsd:string"))
				{	soap_flag_versionInfo1--;
					continue;
				}
			if (soap_flag_otherInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "otherInfo", &(((SRMv2__srmPingResponse*)a)->otherInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_otherInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_versionInfo1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPingResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPingResponse, 0, sizeof(SRMv2__srmPingResponse), 0, soap_copy_SRMv2__srmPingResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPingResponse * SOAP_FMAC6 soap_new_SRMv2__srmPingResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPingResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPingResponse(struct soap *soap, SRMv2__srmPingResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPingResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPingResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPingResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPingResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPingResponse;
		if (size)
			*size = sizeof(SRMv2__srmPingResponse);
		((SRMv2__srmPingResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPingResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPingResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPingResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPingResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPingResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPingResponse %p -> %p\n", q, p));
	*(SRMv2__srmPingResponse*)p = *(SRMv2__srmPingResponse*)q;
}

void SRMv2__srmPingRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPingRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmPingRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPingRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmPingRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPingRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPingRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPingRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPingRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPingRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPingRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmPingRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPingRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPingRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPingRequest * SOAP_FMAC4 soap_get_SRMv2__srmPingRequest(struct soap *soap, SRMv2__srmPingRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPingRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPingRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPingRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPingRequest * SOAP_FMAC4 soap_in_SRMv2__srmPingRequest(struct soap *soap, const char *tag, SRMv2__srmPingRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPingRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPingRequest, sizeof(SRMv2__srmPingRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPingRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPingRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmPingRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPingRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPingRequest, 0, sizeof(SRMv2__srmPingRequest), 0, soap_copy_SRMv2__srmPingRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPingRequest * SOAP_FMAC6 soap_new_SRMv2__srmPingRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPingRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPingRequest(struct soap *soap, SRMv2__srmPingRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPingRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPingRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPingRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPingRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPingRequest;
		if (size)
			*size = sizeof(SRMv2__srmPingRequest);
		((SRMv2__srmPingRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPingRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPingRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPingRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPingRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPingRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPingRequest %p -> %p\n", q, p));
	*(SRMv2__srmPingRequest*)p = *(SRMv2__srmPingRequest*)q;
}

void SRMv2__srmGetTransferProtocolsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetTransferProtocolsResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, &((SRMv2__srmGetTransferProtocolsResponse*)this)->protocolInfo);
	/* transient soap skipped */
}

void SRMv2__srmGetTransferProtocolsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetTransferProtocolsResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetTransferProtocolsResponse*)this)->protocolInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetTransferProtocolsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetTransferProtocolsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetTransferProtocolsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetTransferProtocolsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetTransferProtocolsResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, "protocolInfo", -1, &(((SRMv2__srmGetTransferProtocolsResponse*)a)->protocolInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetTransferProtocolsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetTransferProtocolsResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, SRMv2__srmGetTransferProtocolsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetTransferProtocolsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetTransferProtocolsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetTransferProtocolsResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, const char *tag, SRMv2__srmGetTransferProtocolsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetTransferProtocolsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse, sizeof(SRMv2__srmGetTransferProtocolsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetTransferProtocolsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_protocolInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetTransferProtocolsResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_protocolInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSupportedTransferProtocol(soap, "protocolInfo", &(((SRMv2__srmGetTransferProtocolsResponse*)a)->protocolInfo), "SRMv2:ArrayOfTSupportedTransferProtocol"))
				{	soap_flag_protocolInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetTransferProtocolsResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse, 0, sizeof(SRMv2__srmGetTransferProtocolsResponse), 0, soap_copy_SRMv2__srmGetTransferProtocolsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetTransferProtocolsResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetTransferProtocolsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, SRMv2__srmGetTransferProtocolsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetTransferProtocolsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetTransferProtocolsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetTransferProtocolsResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetTransferProtocolsResponse);
		((SRMv2__srmGetTransferProtocolsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetTransferProtocolsResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetTransferProtocolsResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetTransferProtocolsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetTransferProtocolsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetTransferProtocolsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetTransferProtocolsResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetTransferProtocolsResponse*)p = *(SRMv2__srmGetTransferProtocolsResponse*)q;
}

void SRMv2__srmGetTransferProtocolsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetTransferProtocolsRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmGetTransferProtocolsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetTransferProtocolsRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmGetTransferProtocolsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetTransferProtocolsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetTransferProtocolsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetTransferProtocolsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetTransferProtocolsRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetTransferProtocolsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetTransferProtocolsRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, SRMv2__srmGetTransferProtocolsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetTransferProtocolsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetTransferProtocolsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetTransferProtocolsRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, const char *tag, SRMv2__srmGetTransferProtocolsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetTransferProtocolsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest, sizeof(SRMv2__srmGetTransferProtocolsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetTransferProtocolsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetTransferProtocolsRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetTransferProtocolsRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest, 0, sizeof(SRMv2__srmGetTransferProtocolsRequest), 0, soap_copy_SRMv2__srmGetTransferProtocolsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetTransferProtocolsRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetTransferProtocolsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, SRMv2__srmGetTransferProtocolsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetTransferProtocolsRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetTransferProtocolsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetTransferProtocolsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetTransferProtocolsRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetTransferProtocolsRequest);
		((SRMv2__srmGetTransferProtocolsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetTransferProtocolsRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetTransferProtocolsRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetTransferProtocolsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetTransferProtocolsRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetTransferProtocolsRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetTransferProtocolsRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetTransferProtocolsRequest*)p = *(SRMv2__srmGetTransferProtocolsRequest*)q;
}

void SRMv2__srmGetRequestTokensResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetRequestTokensResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, &((SRMv2__srmGetRequestTokensResponse*)this)->arrayOfRequestTokens);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestTokensResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestTokensResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetRequestTokensResponse*)this)->arrayOfRequestTokens = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestTokensResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestTokensResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestTokensResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestTokensResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestTokensResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestTokensResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestTokensResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetRequestTokensResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, "arrayOfRequestTokens", -1, &(((SRMv2__srmGetRequestTokensResponse*)a)->arrayOfRequestTokens), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestTokensResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestTokensResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestTokensResponse(struct soap *soap, SRMv2__srmGetRequestTokensResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestTokensResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestTokensResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestTokensResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestTokensResponse(struct soap *soap, const char *tag, SRMv2__srmGetRequestTokensResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestTokensResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestTokensResponse, sizeof(SRMv2__srmGetRequestTokensResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestTokensResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestTokensResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfRequestTokens1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetRequestTokensResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfRequestTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTRequestTokenReturn(soap, "arrayOfRequestTokens", &(((SRMv2__srmGetRequestTokensResponse*)a)->arrayOfRequestTokens), "SRMv2:ArrayOfTRequestTokenReturn"))
				{	soap_flag_arrayOfRequestTokens1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestTokensResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestTokensResponse, 0, sizeof(SRMv2__srmGetRequestTokensResponse), 0, soap_copy_SRMv2__srmGetRequestTokensResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestTokensResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestTokensResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestTokensResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestTokensResponse(struct soap *soap, SRMv2__srmGetRequestTokensResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestTokensResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestTokensResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestTokensResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestTokensResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestTokensResponse);
		((SRMv2__srmGetRequestTokensResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestTokensResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestTokensResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestTokensResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestTokensResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestTokensResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestTokensResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestTokensResponse*)p = *(SRMv2__srmGetRequestTokensResponse*)q;
}

void SRMv2__srmGetRequestTokensRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetRequestTokensRequest*)this)->userRequestDescription);
	soap_serialize_string(soap, &((SRMv2__srmGetRequestTokensRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestTokensRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetRequestTokensRequest*)this)->userRequestDescription);
	soap_default_string(soap, &((SRMv2__srmGetRequestTokensRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmGetRequestTokensRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestTokensRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestTokensRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestTokensRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestTokensRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestTokensRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestTokensRequest), type);
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmGetRequestTokensRequest*)a)->userRequestDescription), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetRequestTokensRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestTokensRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestTokensRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestTokensRequest(struct soap *soap, SRMv2__srmGetRequestTokensRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestTokensRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestTokensRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestTokensRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestTokensRequest(struct soap *soap, const char *tag, SRMv2__srmGetRequestTokensRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestTokensRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestTokensRequest, sizeof(SRMv2__srmGetRequestTokensRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestTokensRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestTokensRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userRequestDescription1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmGetRequestTokensRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetRequestTokensRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestTokensRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestTokensRequest, 0, sizeof(SRMv2__srmGetRequestTokensRequest), 0, soap_copy_SRMv2__srmGetRequestTokensRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestTokensRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestTokensRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestTokensRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestTokensRequest(struct soap *soap, SRMv2__srmGetRequestTokensRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestTokensRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestTokensRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestTokensRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestTokensRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestTokensRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestTokensRequest);
		((SRMv2__srmGetRequestTokensRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestTokensRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestTokensRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestTokensRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestTokensRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestTokensRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestTokensRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestTokensRequest*)p = *(SRMv2__srmGetRequestTokensRequest*)q;
}

void SRMv2__srmExtendFileLifeTimeResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmExtendFileLifeTimeResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, &((SRMv2__srmExtendFileLifeTimeResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmExtendFileLifeTimeResponse*)this)->returnStatus = NULL;
	((SRMv2__srmExtendFileLifeTimeResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, sizeof(SRMv2__srmExtendFileLifeTimeResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmExtendFileLifeTimeResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLLifetimeReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, 0, sizeof(SRMv2__srmExtendFileLifeTimeResponse), 0, soap_copy_SRMv2__srmExtendFileLifeTimeResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeResponse;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeResponse);
		((SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeResponse %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeResponse*)p = *(SRMv2__srmExtendFileLifeTimeResponse*)q;
}

void SRMv2__srmExtendFileLifeTimeRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerToint(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->newFileLifeTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->newPinLifeTime);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmExtendFileLifeTimeRequest*)this)->requestToken);
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->newFileLifeTime = NULL;
	((SRMv2__srmExtendFileLifeTimeRequest*)this)->newPinLifeTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->authorizationID), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerToint(soap, "newFileLifeTime", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newFileLifeTime), "");
	soap_out_PointerToint(soap, "newPinLifeTime", -1, &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newPinLifeTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, sizeof(SRMv2__srmExtendFileLifeTimeRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_requestToken1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_newFileLifeTime1 = 1, soap_flag_newPinLifeTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_newFileLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "newFileLifeTime", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newFileLifeTime), "xsd:int"))
				{	soap_flag_newFileLifeTime1--;
					continue;
				}
			if (soap_flag_newPinLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "newPinLifeTime", &(((SRMv2__srmExtendFileLifeTimeRequest*)a)->newPinLifeTime), "xsd:int"))
				{	soap_flag_newPinLifeTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, 0, sizeof(SRMv2__srmExtendFileLifeTimeRequest), 0, soap_copy_SRMv2__srmExtendFileLifeTimeRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeRequest;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeRequest);
		((SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeRequest %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeRequest*)p = *(SRMv2__srmExtendFileLifeTimeRequest*)q;
}

void SRMv2__srmGetRequestSummaryResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetRequestSummaryResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTRequestSummary(soap, &((SRMv2__srmGetRequestSummaryResponse*)this)->arrayOfRequestSummaries);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestSummaryResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestSummaryResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetRequestSummaryResponse*)this)->arrayOfRequestSummaries = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetRequestSummaryResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestSummaryResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestSummaryResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestSummaryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetRequestSummaryResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTRequestSummary(soap, "arrayOfRequestSummaries", -1, &(((SRMv2__srmGetRequestSummaryResponse*)a)->arrayOfRequestSummaries), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestSummaryResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestSummaryResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, SRMv2__srmGetRequestSummaryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestSummaryResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestSummaryResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestSummaryResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, const char *tag, SRMv2__srmGetRequestSummaryResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestSummaryResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, sizeof(SRMv2__srmGetRequestSummaryResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestSummaryResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfRequestSummaries1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetRequestSummaryResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfRequestSummaries1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTRequestSummary(soap, "arrayOfRequestSummaries", &(((SRMv2__srmGetRequestSummaryResponse*)a)->arrayOfRequestSummaries), "SRMv2:ArrayOfTRequestSummary"))
				{	soap_flag_arrayOfRequestSummaries1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestSummaryResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, 0, sizeof(SRMv2__srmGetRequestSummaryResponse), 0, soap_copy_SRMv2__srmGetRequestSummaryResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestSummaryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, SRMv2__srmGetRequestSummaryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestSummaryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestSummaryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestSummaryResponse);
		((SRMv2__srmGetRequestSummaryResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestSummaryResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestSummaryResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestSummaryResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestSummaryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestSummaryResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestSummaryResponse*)p = *(SRMv2__srmGetRequestSummaryResponse*)q;
}

void SRMv2__srmGetRequestSummaryRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfString(soap, &((SRMv2__srmGetRequestSummaryRequest*)this)->arrayOfRequestTokens);
	soap_serialize_string(soap, &((SRMv2__srmGetRequestSummaryRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmGetRequestSummaryRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetRequestSummaryRequest*)this)->arrayOfRequestTokens = NULL;
	soap_default_string(soap, &((SRMv2__srmGetRequestSummaryRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmGetRequestSummaryRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetRequestSummaryRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetRequestSummaryRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetRequestSummaryRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest), type);
	soap_out_PointerToSRMv2__ArrayOfString(soap, "arrayOfRequestTokens", -1, &(((SRMv2__srmGetRequestSummaryRequest*)a)->arrayOfRequestTokens), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetRequestSummaryRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetRequestSummaryRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetRequestSummaryRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, SRMv2__srmGetRequestSummaryRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetRequestSummaryRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetRequestSummaryRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetRequestSummaryRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, const char *tag, SRMv2__srmGetRequestSummaryRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetRequestSummaryRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, sizeof(SRMv2__srmGetRequestSummaryRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetRequestSummaryRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfRequestTokens1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfRequestTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfString(soap, "arrayOfRequestTokens", &(((SRMv2__srmGetRequestSummaryRequest*)a)->arrayOfRequestTokens), "SRMv2:ArrayOfString"))
				{	soap_flag_arrayOfRequestTokens1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetRequestSummaryRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfRequestTokens1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetRequestSummaryRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, 0, sizeof(SRMv2__srmGetRequestSummaryRequest), 0, soap_copy_SRMv2__srmGetRequestSummaryRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetRequestSummaryRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, SRMv2__srmGetRequestSummaryRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetRequestSummaryRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetRequestSummaryRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetRequestSummaryRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetRequestSummaryRequest);
		((SRMv2__srmGetRequestSummaryRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetRequestSummaryRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetRequestSummaryRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetRequestSummaryRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetRequestSummaryRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetRequestSummaryRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetRequestSummaryRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetRequestSummaryRequest*)p = *(SRMv2__srmGetRequestSummaryRequest*)q;
}

void SRMv2__srmResumeRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmResumeRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmResumeRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmResumeRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmResumeRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmResumeRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmResumeRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmResumeRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmResumeRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmResumeRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmResumeRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmResumeRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmResumeRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmResumeRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmResumeRequestResponse(struct soap *soap, SRMv2__srmResumeRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmResumeRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmResumeRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmResumeRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmResumeRequestResponse(struct soap *soap, const char *tag, SRMv2__srmResumeRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmResumeRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmResumeRequestResponse, sizeof(SRMv2__srmResumeRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmResumeRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmResumeRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmResumeRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmResumeRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmResumeRequestResponse, 0, sizeof(SRMv2__srmResumeRequestResponse), 0, soap_copy_SRMv2__srmResumeRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmResumeRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmResumeRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmResumeRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmResumeRequestResponse(struct soap *soap, SRMv2__srmResumeRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmResumeRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmResumeRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmResumeRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmResumeRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmResumeRequestResponse);
		((SRMv2__srmResumeRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmResumeRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmResumeRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmResumeRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmResumeRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmResumeRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmResumeRequestResponse*)p = *(SRMv2__srmResumeRequestResponse*)q;
}

void SRMv2__srmResumeRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmResumeRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmResumeRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmResumeRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmResumeRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmResumeRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmResumeRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmResumeRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmResumeRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmResumeRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmResumeRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmResumeRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmResumeRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmResumeRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmResumeRequestRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmResumeRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmResumeRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmResumeRequestRequest(struct soap *soap, SRMv2__srmResumeRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmResumeRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmResumeRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmResumeRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmResumeRequestRequest(struct soap *soap, const char *tag, SRMv2__srmResumeRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmResumeRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmResumeRequestRequest, sizeof(SRMv2__srmResumeRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmResumeRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmResumeRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmResumeRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmResumeRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmResumeRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmResumeRequestRequest, 0, sizeof(SRMv2__srmResumeRequestRequest), 0, soap_copy_SRMv2__srmResumeRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmResumeRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmResumeRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmResumeRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmResumeRequestRequest(struct soap *soap, SRMv2__srmResumeRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmResumeRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmResumeRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmResumeRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmResumeRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmResumeRequestRequest);
		((SRMv2__srmResumeRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmResumeRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmResumeRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmResumeRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmResumeRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmResumeRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmResumeRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmResumeRequestRequest*)p = *(SRMv2__srmResumeRequestRequest*)q;
}

void SRMv2__srmSuspendRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmSuspendRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmSuspendRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSuspendRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSuspendRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSuspendRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSuspendRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSuspendRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSuspendRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmSuspendRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSuspendRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmSuspendRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSuspendRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSuspendRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmSuspendRequestResponse(struct soap *soap, SRMv2__srmSuspendRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSuspendRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSuspendRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSuspendRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmSuspendRequestResponse(struct soap *soap, const char *tag, SRMv2__srmSuspendRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSuspendRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, sizeof(SRMv2__srmSuspendRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSuspendRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSuspendRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmSuspendRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSuspendRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, 0, sizeof(SRMv2__srmSuspendRequestResponse), 0, soap_copy_SRMv2__srmSuspendRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSuspendRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmSuspendRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSuspendRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSuspendRequestResponse(struct soap *soap, SRMv2__srmSuspendRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmSuspendRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSuspendRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSuspendRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmSuspendRequestResponse);
		((SRMv2__srmSuspendRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSuspendRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSuspendRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSuspendRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSuspendRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSuspendRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmSuspendRequestResponse*)p = *(SRMv2__srmSuspendRequestResponse*)q;
}

void SRMv2__srmSuspendRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmSuspendRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmSuspendRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmSuspendRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmSuspendRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmSuspendRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmSuspendRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSuspendRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSuspendRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSuspendRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSuspendRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmSuspendRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSuspendRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmSuspendRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmSuspendRequestRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSuspendRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSuspendRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmSuspendRequestRequest(struct soap *soap, SRMv2__srmSuspendRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSuspendRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSuspendRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSuspendRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmSuspendRequestRequest(struct soap *soap, const char *tag, SRMv2__srmSuspendRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSuspendRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, sizeof(SRMv2__srmSuspendRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSuspendRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSuspendRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmSuspendRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmSuspendRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSuspendRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, 0, sizeof(SRMv2__srmSuspendRequestRequest), 0, soap_copy_SRMv2__srmSuspendRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSuspendRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmSuspendRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSuspendRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSuspendRequestRequest(struct soap *soap, SRMv2__srmSuspendRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSuspendRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmSuspendRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSuspendRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSuspendRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmSuspendRequestRequest);
		((SRMv2__srmSuspendRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSuspendRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSuspendRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSuspendRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSuspendRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSuspendRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSuspendRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmSuspendRequestRequest*)p = *(SRMv2__srmSuspendRequestRequest*)q;
}

void SRMv2__srmAbortFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmAbortFilesResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmAbortFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmAbortFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortFilesResponse*)this)->returnStatus = NULL;
	((SRMv2__srmAbortFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmAbortFilesResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmAbortFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmAbortFilesResponse(struct soap *soap, SRMv2__srmAbortFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmAbortFilesResponse(struct soap *soap, const char *tag, SRMv2__srmAbortFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortFilesResponse, sizeof(SRMv2__srmAbortFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmAbortFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmAbortFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortFilesResponse, 0, sizeof(SRMv2__srmAbortFilesResponse), 0, soap_copy_SRMv2__srmAbortFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmAbortFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortFilesResponse(struct soap *soap, SRMv2__srmAbortFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmAbortFilesResponse);
		((SRMv2__srmAbortFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmAbortFilesResponse*)p = *(SRMv2__srmAbortFilesResponse*)q;
}

void SRMv2__srmAbortFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmAbortFilesRequest*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmAbortFilesRequest*)this)->arrayOfSURLs);
	soap_serialize_string(soap, &((SRMv2__srmAbortFilesRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmAbortFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmAbortFilesRequest*)this)->requestToken);
	((SRMv2__srmAbortFilesRequest*)this)->arrayOfSURLs = NULL;
	soap_default_string(soap, &((SRMv2__srmAbortFilesRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmAbortFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortFilesRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmAbortFilesRequest*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmAbortFilesRequest*)a)->arrayOfSURLs), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmAbortFilesRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmAbortFilesRequest(struct soap *soap, SRMv2__srmAbortFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmAbortFilesRequest(struct soap *soap, const char *tag, SRMv2__srmAbortFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortFilesRequest, sizeof(SRMv2__srmAbortFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmAbortFilesRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmAbortFilesRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmAbortFilesRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortFilesRequest, 0, sizeof(SRMv2__srmAbortFilesRequest), 0, soap_copy_SRMv2__srmAbortFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmAbortFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortFilesRequest(struct soap *soap, SRMv2__srmAbortFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmAbortFilesRequest);
		((SRMv2__srmAbortFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmAbortFilesRequest*)p = *(SRMv2__srmAbortFilesRequest*)q;
}

void SRMv2__srmAbortRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmAbortRequestResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmAbortRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmAbortRequestResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmAbortRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmAbortRequestResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmAbortRequestResponse(struct soap *soap, SRMv2__srmAbortRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmAbortRequestResponse(struct soap *soap, const char *tag, SRMv2__srmAbortRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortRequestResponse, sizeof(SRMv2__srmAbortRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmAbortRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortRequestResponse, 0, sizeof(SRMv2__srmAbortRequestResponse), 0, soap_copy_SRMv2__srmAbortRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmAbortRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortRequestResponse(struct soap *soap, SRMv2__srmAbortRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmAbortRequestResponse);
		((SRMv2__srmAbortRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmAbortRequestResponse*)p = *(SRMv2__srmAbortRequestResponse*)q;
}

void SRMv2__srmAbortRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmAbortRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmAbortRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmAbortRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmAbortRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmAbortRequestRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmAbortRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmAbortRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmAbortRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmAbortRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmAbortRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmAbortRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmAbortRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmAbortRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmAbortRequestRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmAbortRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmAbortRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmAbortRequestRequest(struct soap *soap, SRMv2__srmAbortRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmAbortRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmAbortRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmAbortRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmAbortRequestRequest(struct soap *soap, const char *tag, SRMv2__srmAbortRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmAbortRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmAbortRequestRequest, sizeof(SRMv2__srmAbortRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmAbortRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmAbortRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmAbortRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmAbortRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmAbortRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmAbortRequestRequest, 0, sizeof(SRMv2__srmAbortRequestRequest), 0, soap_copy_SRMv2__srmAbortRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmAbortRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmAbortRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmAbortRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmAbortRequestRequest(struct soap *soap, SRMv2__srmAbortRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmAbortRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmAbortRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmAbortRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmAbortRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmAbortRequestRequest);
		((SRMv2__srmAbortRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmAbortRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmAbortRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmAbortRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmAbortRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmAbortRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmAbortRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmAbortRequestRequest*)p = *(SRMv2__srmAbortRequestRequest*)q;
}

void SRMv2__srmPutDoneResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPutDoneResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmPutDoneResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmPutDoneResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPutDoneResponse*)this)->returnStatus = NULL;
	((SRMv2__srmPutDoneResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPutDoneResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPutDoneResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPutDoneResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPutDoneResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPutDoneResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPutDoneResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPutDoneResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPutDoneResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPutDoneResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPutDoneResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPutDoneResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_get_SRMv2__srmPutDoneResponse(struct soap *soap, SRMv2__srmPutDoneResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPutDoneResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPutDoneResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPutDoneResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_in_SRMv2__srmPutDoneResponse(struct soap *soap, const char *tag, SRMv2__srmPutDoneResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPutDoneResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPutDoneResponse, sizeof(SRMv2__srmPutDoneResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPutDoneResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPutDoneResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPutDoneResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPutDoneResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPutDoneResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPutDoneResponse, 0, sizeof(SRMv2__srmPutDoneResponse), 0, soap_copy_SRMv2__srmPutDoneResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPutDoneResponse * SOAP_FMAC6 soap_new_SRMv2__srmPutDoneResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPutDoneResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPutDoneResponse(struct soap *soap, SRMv2__srmPutDoneResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPutDoneResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPutDoneResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPutDoneResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPutDoneResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPutDoneResponse;
		if (size)
			*size = sizeof(SRMv2__srmPutDoneResponse);
		((SRMv2__srmPutDoneResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPutDoneResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPutDoneResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPutDoneResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPutDoneResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPutDoneResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPutDoneResponse %p -> %p\n", q, p));
	*(SRMv2__srmPutDoneResponse*)p = *(SRMv2__srmPutDoneResponse*)q;
}

void SRMv2__srmPutDoneRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPutDoneRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmPutDoneRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmPutDoneRequest*)this)->arrayOfSURLs);
	/* transient soap skipped */
}

void SRMv2__srmPutDoneRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPutDoneRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmPutDoneRequest*)this)->authorizationID);
	((SRMv2__srmPutDoneRequest*)this)->arrayOfSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPutDoneRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPutDoneRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPutDoneRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPutDoneRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPutDoneRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPutDoneRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPutDoneRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmPutDoneRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmPutDoneRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmPutDoneRequest*)a)->arrayOfSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPutDoneRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPutDoneRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_get_SRMv2__srmPutDoneRequest(struct soap *soap, SRMv2__srmPutDoneRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPutDoneRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPutDoneRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPutDoneRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_in_SRMv2__srmPutDoneRequest(struct soap *soap, const char *tag, SRMv2__srmPutDoneRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPutDoneRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPutDoneRequest, sizeof(SRMv2__srmPutDoneRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPutDoneRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPutDoneRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmPutDoneRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmPutDoneRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmPutDoneRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPutDoneRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPutDoneRequest, 0, sizeof(SRMv2__srmPutDoneRequest), 0, soap_copy_SRMv2__srmPutDoneRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPutDoneRequest * SOAP_FMAC6 soap_new_SRMv2__srmPutDoneRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPutDoneRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPutDoneRequest(struct soap *soap, SRMv2__srmPutDoneRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPutDoneRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPutDoneRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPutDoneRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPutDoneRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPutDoneRequest;
		if (size)
			*size = sizeof(SRMv2__srmPutDoneRequest);
		((SRMv2__srmPutDoneRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPutDoneRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPutDoneRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPutDoneRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPutDoneRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPutDoneRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPutDoneRequest %p -> %p\n", q, p));
	*(SRMv2__srmPutDoneRequest*)p = *(SRMv2__srmPutDoneRequest*)q;
}

void SRMv2__srmReleaseFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReleaseFilesResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmReleaseFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmReleaseFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseFilesResponse*)this)->returnStatus = NULL;
	((SRMv2__srmReleaseFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReleaseFilesResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmReleaseFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmReleaseFilesResponse(struct soap *soap, SRMv2__srmReleaseFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmReleaseFilesResponse(struct soap *soap, const char *tag, SRMv2__srmReleaseFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, sizeof(SRMv2__srmReleaseFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReleaseFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmReleaseFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, 0, sizeof(SRMv2__srmReleaseFilesResponse), 0, soap_copy_SRMv2__srmReleaseFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmReleaseFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseFilesResponse(struct soap *soap, SRMv2__srmReleaseFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmReleaseFilesResponse);
		((SRMv2__srmReleaseFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmReleaseFilesResponse*)p = *(SRMv2__srmReleaseFilesResponse*)q;
}

void SRMv2__srmReleaseFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmReleaseFilesRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmReleaseFilesRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmReleaseFilesRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmReleaseFilesRequest*)this)->doRemove);
	/* transient soap skipped */
}

void SRMv2__srmReleaseFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmReleaseFilesRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmReleaseFilesRequest*)this)->authorizationID);
	((SRMv2__srmReleaseFilesRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmReleaseFilesRequest*)this)->doRemove = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseFilesRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerTobool(soap, "doRemove", -1, &(((SRMv2__srmReleaseFilesRequest*)a)->doRemove), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmReleaseFilesRequest(struct soap *soap, SRMv2__srmReleaseFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmReleaseFilesRequest(struct soap *soap, const char *tag, SRMv2__srmReleaseFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, sizeof(SRMv2__srmReleaseFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_doRemove1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmReleaseFilesRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmReleaseFilesRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmReleaseFilesRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_doRemove1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "doRemove", &(((SRMv2__srmReleaseFilesRequest*)a)->doRemove), "xsd:boolean"))
				{	soap_flag_doRemove1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, 0, sizeof(SRMv2__srmReleaseFilesRequest), 0, soap_copy_SRMv2__srmReleaseFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmReleaseFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseFilesRequest(struct soap *soap, SRMv2__srmReleaseFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmReleaseFilesRequest);
		((SRMv2__srmReleaseFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmReleaseFilesRequest*)p = *(SRMv2__srmReleaseFilesRequest*)q;
}

void SRMv2__srmStatusOfCopyRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfCopyRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, &((SRMv2__srmStatusOfCopyRequestResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfCopyRequestResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfCopyRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfCopyRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfCopyRequestResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmStatusOfCopyRequestResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfCopyRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfCopyRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfCopyRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfCopyRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfCopyRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, SRMv2__srmStatusOfCopyRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfCopyRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfCopyRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfCopyRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfCopyRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, sizeof(SRMv2__srmStatusOfCopyRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfCopyRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTCopyRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmStatusOfCopyRequestResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfCopyRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, 0, sizeof(SRMv2__srmStatusOfCopyRequestResponse), 0, soap_copy_SRMv2__srmStatusOfCopyRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, SRMv2__srmStatusOfCopyRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfCopyRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfCopyRequestResponse);
		((SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfCopyRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfCopyRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfCopyRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfCopyRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfCopyRequestResponse*)p = *(SRMv2__srmStatusOfCopyRequestResponse*)q;
}

void SRMv2__srmStatusOfCopyRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfSourceSURLs);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfTargetSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfCopyRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmStatusOfCopyRequestRequest*)this)->authorizationID);
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfSourceSURLs = NULL;
	((SRMv2__srmStatusOfCopyRequestRequest*)this)->arrayOfTargetSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfCopyRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfCopyRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfCopyRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfSourceSURLs), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfTargetSURLs", -1, &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfTargetSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfCopyRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfCopyRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, SRMv2__srmStatusOfCopyRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfCopyRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfCopyRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfCopyRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfCopyRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, sizeof(SRMv2__srmStatusOfCopyRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfCopyRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfSourceSURLs1 = 1, soap_flag_arrayOfTargetSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSourceSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfSourceSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSourceSURLs1--;
					continue;
				}
			if (soap_flag_arrayOfTargetSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfTargetSURLs", &(((SRMv2__srmStatusOfCopyRequestRequest*)a)->arrayOfTargetSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfTargetSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfCopyRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, 0, sizeof(SRMv2__srmStatusOfCopyRequestRequest), 0, soap_copy_SRMv2__srmStatusOfCopyRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, SRMv2__srmStatusOfCopyRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfCopyRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfCopyRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfCopyRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfCopyRequestRequest);
		((SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfCopyRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfCopyRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfCopyRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfCopyRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfCopyRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfCopyRequestRequest*)p = *(SRMv2__srmStatusOfCopyRequestRequest*)q;
}

void SRMv2__srmCopyResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmCopyResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmCopyResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, &((SRMv2__srmCopyResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmCopyResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmCopyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCopyResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmCopyResponse*)this)->requestToken);
	((SRMv2__srmCopyResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmCopyResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCopyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCopyResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCopyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCopyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCopyResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmCopyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCopyResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmCopyResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmCopyResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmCopyResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmCopyResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCopyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCopyResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_get_SRMv2__srmCopyResponse(struct soap *soap, SRMv2__srmCopyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCopyResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCopyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCopyResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_in_SRMv2__srmCopyResponse(struct soap *soap, const char *tag, SRMv2__srmCopyResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCopyResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCopyResponse, sizeof(SRMv2__srmCopyResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCopyResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCopyResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmCopyResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmCopyResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmCopyResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTCopyRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmCopyResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCopyResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCopyResponse, 0, sizeof(SRMv2__srmCopyResponse), 0, soap_copy_SRMv2__srmCopyResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCopyResponse * SOAP_FMAC6 soap_new_SRMv2__srmCopyResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCopyResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCopyResponse(struct soap *soap, SRMv2__srmCopyResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCopyResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmCopyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCopyResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCopyResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCopyResponse;
		if (size)
			*size = sizeof(SRMv2__srmCopyResponse);
		((SRMv2__srmCopyResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCopyResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCopyResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCopyResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCopyResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCopyResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCopyResponse %p -> %p\n", q, p));
	*(SRMv2__srmCopyResponse*)p = *(SRMv2__srmCopyResponse*)q;
}

void SRMv2__srmCopyRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmCopyRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, &((SRMv2__srmCopyRequest*)this)->arrayOfFileRequests);
	soap_serialize_string(soap, &((SRMv2__srmCopyRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TOverwriteMode(soap, &((SRMv2__srmCopyRequest*)this)->overwriteOption);
	soap_serialize_PointerToint(soap, &((SRMv2__srmCopyRequest*)this)->desiredTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmCopyRequest*)this)->desiredTargetSURLLifeTime);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmCopyRequest*)this)->targetFileStorageType);
	soap_serialize_string(soap, &((SRMv2__srmCopyRequest*)this)->targetSpaceToken);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmCopyRequest*)this)->targetFileRetentionPolicyInfo);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmCopyRequest*)this)->sourceStorageSystemInfo);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmCopyRequest*)this)->targetStorageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmCopyRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmCopyRequest*)this)->authorizationID);
	((SRMv2__srmCopyRequest*)this)->arrayOfFileRequests = NULL;
	soap_default_string(soap, &((SRMv2__srmCopyRequest*)this)->userRequestDescription);
	((SRMv2__srmCopyRequest*)this)->overwriteOption = NULL;
	((SRMv2__srmCopyRequest*)this)->desiredTotalRequestTime = NULL;
	((SRMv2__srmCopyRequest*)this)->desiredTargetSURLLifeTime = NULL;
	((SRMv2__srmCopyRequest*)this)->targetFileStorageType = NULL;
	soap_default_string(soap, &((SRMv2__srmCopyRequest*)this)->targetSpaceToken);
	((SRMv2__srmCopyRequest*)this)->targetFileRetentionPolicyInfo = NULL;
	((SRMv2__srmCopyRequest*)this)->sourceStorageSystemInfo = NULL;
	((SRMv2__srmCopyRequest*)this)->targetStorageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCopyRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCopyRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCopyRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCopyRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCopyRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmCopyRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCopyRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmCopyRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmCopyRequest*)a)->arrayOfFileRequests), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmCopyRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", -1, &(((SRMv2__srmCopyRequest*)a)->overwriteOption), "");
	soap_out_PointerToint(soap, "desiredTotalRequestTime", -1, &(((SRMv2__srmCopyRequest*)a)->desiredTotalRequestTime), "");
	soap_out_PointerToint(soap, "desiredTargetSURLLifeTime", -1, &(((SRMv2__srmCopyRequest*)a)->desiredTargetSURLLifeTime), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "targetFileStorageType", -1, &(((SRMv2__srmCopyRequest*)a)->targetFileStorageType), "");
	soap_out_string(soap, "targetSpaceToken", -1, &(((SRMv2__srmCopyRequest*)a)->targetSpaceToken), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", -1, &(((SRMv2__srmCopyRequest*)a)->targetFileRetentionPolicyInfo), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "sourceStorageSystemInfo", -1, &(((SRMv2__srmCopyRequest*)a)->sourceStorageSystemInfo), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "targetStorageSystemInfo", -1, &(((SRMv2__srmCopyRequest*)a)->targetStorageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCopyRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCopyRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_get_SRMv2__srmCopyRequest(struct soap *soap, SRMv2__srmCopyRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCopyRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCopyRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCopyRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_in_SRMv2__srmCopyRequest(struct soap *soap, const char *tag, SRMv2__srmCopyRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCopyRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCopyRequest, sizeof(SRMv2__srmCopyRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCopyRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCopyRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_overwriteOption1 = 1, soap_flag_desiredTotalRequestTime1 = 1, soap_flag_desiredTargetSURLLifeTime1 = 1, soap_flag_targetFileStorageType1 = 1, soap_flag_targetSpaceToken1 = 1, soap_flag_targetFileRetentionPolicyInfo1 = 1, soap_flag_sourceStorageSystemInfo1 = 1, soap_flag_targetStorageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmCopyRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTCopyFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmCopyRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTCopyFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmCopyRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_overwriteOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", &(((SRMv2__srmCopyRequest*)a)->overwriteOption), "SRMv2:TOverwriteMode"))
				{	soap_flag_overwriteOption1--;
					continue;
				}
			if (soap_flag_desiredTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredTotalRequestTime", &(((SRMv2__srmCopyRequest*)a)->desiredTotalRequestTime), "xsd:int"))
				{	soap_flag_desiredTotalRequestTime1--;
					continue;
				}
			if (soap_flag_desiredTargetSURLLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredTargetSURLLifeTime", &(((SRMv2__srmCopyRequest*)a)->desiredTargetSURLLifeTime), "xsd:int"))
				{	soap_flag_desiredTargetSURLLifeTime1--;
					continue;
				}
			if (soap_flag_targetFileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "targetFileStorageType", &(((SRMv2__srmCopyRequest*)a)->targetFileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_targetFileStorageType1--;
					continue;
				}
			if (soap_flag_targetSpaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "targetSpaceToken", &(((SRMv2__srmCopyRequest*)a)->targetSpaceToken), "xsd:string"))
				{	soap_flag_targetSpaceToken1--;
					continue;
				}
			if (soap_flag_targetFileRetentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", &(((SRMv2__srmCopyRequest*)a)->targetFileRetentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_targetFileRetentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_sourceStorageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "sourceStorageSystemInfo", &(((SRMv2__srmCopyRequest*)a)->sourceStorageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_sourceStorageSystemInfo1--;
					continue;
				}
			if (soap_flag_targetStorageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "targetStorageSystemInfo", &(((SRMv2__srmCopyRequest*)a)->targetStorageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_targetStorageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCopyRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCopyRequest, 0, sizeof(SRMv2__srmCopyRequest), 0, soap_copy_SRMv2__srmCopyRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCopyRequest * SOAP_FMAC6 soap_new_SRMv2__srmCopyRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCopyRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCopyRequest(struct soap *soap, SRMv2__srmCopyRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCopyRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmCopyRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCopyRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCopyRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCopyRequest;
		if (size)
			*size = sizeof(SRMv2__srmCopyRequest);
		((SRMv2__srmCopyRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCopyRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCopyRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCopyRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCopyRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCopyRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCopyRequest %p -> %p\n", q, p));
	*(SRMv2__srmCopyRequest*)p = *(SRMv2__srmCopyRequest*)q;
}

void SRMv2__srmStatusOfPutRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfPutRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, &((SRMv2__srmStatusOfPutRequestResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfPutRequestResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfPutRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfPutRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfPutRequestResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmStatusOfPutRequestResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfPutRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfPutRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfPutRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfPutRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfPutRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfPutRequestResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmStatusOfPutRequestResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfPutRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfPutRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, SRMv2__srmStatusOfPutRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfPutRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfPutRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfPutRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfPutRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, sizeof(SRMv2__srmStatusOfPutRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfPutRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfPutRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfPutRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTPutRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmStatusOfPutRequestResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfPutRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, 0, sizeof(SRMv2__srmStatusOfPutRequestResponse), 0, soap_copy_SRMv2__srmStatusOfPutRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, SRMv2__srmStatusOfPutRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfPutRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfPutRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfPutRequestResponse);
		((SRMv2__srmStatusOfPutRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfPutRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfPutRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfPutRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfPutRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfPutRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfPutRequestResponse*)p = *(SRMv2__srmStatusOfPutRequestResponse*)q;
}

void SRMv2__srmStatusOfPutRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->arrayOfTargetSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfPutRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmStatusOfPutRequestRequest*)this)->authorizationID);
	((SRMv2__srmStatusOfPutRequestRequest*)this)->arrayOfTargetSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfPutRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfPutRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfPutRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfPutRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfTargetSURLs", -1, &(((SRMv2__srmStatusOfPutRequestRequest*)a)->arrayOfTargetSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfPutRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfPutRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, SRMv2__srmStatusOfPutRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfPutRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfPutRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfPutRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfPutRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, sizeof(SRMv2__srmStatusOfPutRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfPutRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfTargetSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfTargetSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfTargetSURLs", &(((SRMv2__srmStatusOfPutRequestRequest*)a)->arrayOfTargetSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfTargetSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfPutRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, 0, sizeof(SRMv2__srmStatusOfPutRequestRequest), 0, soap_copy_SRMv2__srmStatusOfPutRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, SRMv2__srmStatusOfPutRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfPutRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfPutRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfPutRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfPutRequestRequest);
		((SRMv2__srmStatusOfPutRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfPutRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfPutRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfPutRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfPutRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfPutRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfPutRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfPutRequestRequest*)p = *(SRMv2__srmStatusOfPutRequestRequest*)q;
}

void SRMv2__srmPrepareToPutResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPrepareToPutResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToPutResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, &((SRMv2__srmPrepareToPutResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToPutResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToPutResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToPutResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToPutResponse*)this)->requestToken);
	((SRMv2__srmPrepareToPutResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmPrepareToPutResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToPutResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToPutResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToPutResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToPutResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToPutResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToPutResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToPutResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmPrepareToPutResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToPutResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToPutResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToPutResponse(struct soap *soap, SRMv2__srmPrepareToPutResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToPutResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToPutResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToPutResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToPutResponse(struct soap *soap, const char *tag, SRMv2__srmPrepareToPutResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToPutResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, sizeof(SRMv2__srmPrepareToPutResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToPutResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToPutResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPrepareToPutResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmPrepareToPutResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPrepareToPutResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTPutRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmPrepareToPutResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToPutResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, 0, sizeof(SRMv2__srmPrepareToPutResponse), 0, soap_copy_SRMv2__srmPrepareToPutResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToPutResponse * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToPutResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToPutResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToPutResponse(struct soap *soap, SRMv2__srmPrepareToPutResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToPutResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToPutResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToPutResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutResponse;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToPutResponse);
		((SRMv2__srmPrepareToPutResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToPutResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToPutResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToPutResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToPutResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToPutResponse %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToPutResponse*)p = *(SRMv2__srmPrepareToPutResponse*)q;
}

void SRMv2__srmPrepareToPutRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfTPutFileRequest(soap, &((SRMv2__srmPrepareToPutRequest*)this)->arrayOfFileRequests);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__TOverwriteMode(soap, &((SRMv2__srmPrepareToPutRequest*)this)->overwriteOption);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmPrepareToPutRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToPutRequest*)this)->desiredTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToPutRequest*)this)->desiredPinLifeTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToPutRequest*)this)->desiredFileLifeTime);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmPrepareToPutRequest*)this)->desiredFileStorageType);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->targetSpaceToken);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmPrepareToPutRequest*)this)->targetFileRetentionPolicyInfo);
	soap_serialize_PointerToSRMv2__TTransferParameters(soap, &((SRMv2__srmPrepareToPutRequest*)this)->transferParameters);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToPutRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->authorizationID);
	((SRMv2__srmPrepareToPutRequest*)this)->arrayOfFileRequests = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->userRequestDescription);
	((SRMv2__srmPrepareToPutRequest*)this)->overwriteOption = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->desiredTotalRequestTime = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->desiredPinLifeTime = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->desiredFileLifeTime = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->desiredFileStorageType = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToPutRequest*)this)->targetSpaceToken);
	((SRMv2__srmPrepareToPutRequest*)this)->targetFileRetentionPolicyInfo = NULL;
	((SRMv2__srmPrepareToPutRequest*)this)->transferParameters = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToPutRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToPutRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToPutRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToPutRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToPutRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToPutRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToPutRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfTPutFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfFileRequests), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->overwriteOption), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToint(soap, "desiredTotalRequestTime", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->desiredTotalRequestTime), "");
	soap_out_PointerToint(soap, "desiredPinLifeTime", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->desiredPinLifeTime), "");
	soap_out_PointerToint(soap, "desiredFileLifeTime", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->desiredFileLifeTime), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->desiredFileStorageType), "");
	soap_out_string(soap, "targetSpaceToken", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->targetSpaceToken), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->targetFileRetentionPolicyInfo), "");
	soap_out_PointerToSRMv2__TTransferParameters(soap, "transferParameters", -1, &(((SRMv2__srmPrepareToPutRequest*)a)->transferParameters), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToPutRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToPutRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToPutRequest(struct soap *soap, SRMv2__srmPrepareToPutRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToPutRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToPutRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToPutRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToPutRequest(struct soap *soap, const char *tag, SRMv2__srmPrepareToPutRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToPutRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, sizeof(SRMv2__srmPrepareToPutRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToPutRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToPutRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_overwriteOption1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_desiredTotalRequestTime1 = 1, soap_flag_desiredPinLifeTime1 = 1, soap_flag_desiredFileLifeTime1 = 1, soap_flag_desiredFileStorageType1 = 1, soap_flag_targetSpaceToken1 = 1, soap_flag_targetFileRetentionPolicyInfo1 = 1, soap_flag_transferParameters1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmPrepareToPutRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPutFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmPrepareToPutRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTPutFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmPrepareToPutRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_overwriteOption1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TOverwriteMode(soap, "overwriteOption", &(((SRMv2__srmPrepareToPutRequest*)a)->overwriteOption), "SRMv2:TOverwriteMode"))
				{	soap_flag_overwriteOption1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmPrepareToPutRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_desiredTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredTotalRequestTime", &(((SRMv2__srmPrepareToPutRequest*)a)->desiredTotalRequestTime), "xsd:int"))
				{	soap_flag_desiredTotalRequestTime1--;
					continue;
				}
			if (soap_flag_desiredPinLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredPinLifeTime", &(((SRMv2__srmPrepareToPutRequest*)a)->desiredPinLifeTime), "xsd:int"))
				{	soap_flag_desiredPinLifeTime1--;
					continue;
				}
			if (soap_flag_desiredFileLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredFileLifeTime", &(((SRMv2__srmPrepareToPutRequest*)a)->desiredFileLifeTime), "xsd:int"))
				{	soap_flag_desiredFileLifeTime1--;
					continue;
				}
			if (soap_flag_desiredFileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", &(((SRMv2__srmPrepareToPutRequest*)a)->desiredFileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_desiredFileStorageType1--;
					continue;
				}
			if (soap_flag_targetSpaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "targetSpaceToken", &(((SRMv2__srmPrepareToPutRequest*)a)->targetSpaceToken), "xsd:string"))
				{	soap_flag_targetSpaceToken1--;
					continue;
				}
			if (soap_flag_targetFileRetentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", &(((SRMv2__srmPrepareToPutRequest*)a)->targetFileRetentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_targetFileRetentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_transferParameters1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTransferParameters(soap, "transferParameters", &(((SRMv2__srmPrepareToPutRequest*)a)->transferParameters), "SRMv2:TTransferParameters"))
				{	soap_flag_transferParameters1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToPutRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, 0, sizeof(SRMv2__srmPrepareToPutRequest), 0, soap_copy_SRMv2__srmPrepareToPutRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToPutRequest * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToPutRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToPutRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToPutRequest(struct soap *soap, SRMv2__srmPrepareToPutRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToPutRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToPutRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToPutRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToPutRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutRequest;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToPutRequest);
		((SRMv2__srmPrepareToPutRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToPutRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToPutRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToPutRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToPutRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToPutRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToPutRequest %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToPutRequest*)p = *(SRMv2__srmPrepareToPutRequest*)q;
}

void SRMv2__srmStatusOfBringOnlineRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, &((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->remainingTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->remainingDeferredStartTime);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfBringOnlineRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->remainingTotalRequestTime = NULL;
	((SRMv2__srmStatusOfBringOnlineRequestResponse*)this)->remainingDeferredStartTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfBringOnlineRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfBringOnlineRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfBringOnlineRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->remainingTotalRequestTime), "");
	soap_out_PointerToint(soap, "remainingDeferredStartTime", -1, &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->remainingDeferredStartTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfBringOnlineRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, SRMv2__srmStatusOfBringOnlineRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfBringOnlineRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfBringOnlineRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfBringOnlineRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse, sizeof(SRMv2__srmStatusOfBringOnlineRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfBringOnlineRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1, soap_flag_remainingDeferredStartTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTBringOnlineRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			if (soap_flag_remainingDeferredStartTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingDeferredStartTime", &(((SRMv2__srmStatusOfBringOnlineRequestResponse*)a)->remainingDeferredStartTime), "xsd:int"))
				{	soap_flag_remainingDeferredStartTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfBringOnlineRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse, 0, sizeof(SRMv2__srmStatusOfBringOnlineRequestResponse), 0, soap_copy_SRMv2__srmStatusOfBringOnlineRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfBringOnlineRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, SRMv2__srmStatusOfBringOnlineRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfBringOnlineRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfBringOnlineRequestResponse);
		((SRMv2__srmStatusOfBringOnlineRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfBringOnlineRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfBringOnlineRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfBringOnlineRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfBringOnlineRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfBringOnlineRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfBringOnlineRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfBringOnlineRequestResponse*)p = *(SRMv2__srmStatusOfBringOnlineRequestResponse*)q;
}

void SRMv2__srmStatusOfBringOnlineRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->arrayOfSourceSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfBringOnlineRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->authorizationID);
	((SRMv2__srmStatusOfBringOnlineRequestRequest*)this)->arrayOfSourceSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfBringOnlineRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfBringOnlineRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfBringOnlineRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", -1, &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->arrayOfSourceSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfBringOnlineRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, SRMv2__srmStatusOfBringOnlineRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfBringOnlineRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfBringOnlineRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfBringOnlineRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest, sizeof(SRMv2__srmStatusOfBringOnlineRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfBringOnlineRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfSourceSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSourceSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", &(((SRMv2__srmStatusOfBringOnlineRequestRequest*)a)->arrayOfSourceSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSourceSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfBringOnlineRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest, 0, sizeof(SRMv2__srmStatusOfBringOnlineRequestRequest), 0, soap_copy_SRMv2__srmStatusOfBringOnlineRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfBringOnlineRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, SRMv2__srmStatusOfBringOnlineRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfBringOnlineRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfBringOnlineRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfBringOnlineRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfBringOnlineRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfBringOnlineRequestRequest);
		((SRMv2__srmStatusOfBringOnlineRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfBringOnlineRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfBringOnlineRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfBringOnlineRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfBringOnlineRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfBringOnlineRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfBringOnlineRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfBringOnlineRequestRequest*)p = *(SRMv2__srmStatusOfBringOnlineRequestRequest*)q;
}

void SRMv2__srmBringOnlineResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmBringOnlineResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmBringOnlineResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, &((SRMv2__srmBringOnlineResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmBringOnlineResponse*)this)->remainingTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmBringOnlineResponse*)this)->remainingDeferredStartTime);
	/* transient soap skipped */
}

void SRMv2__srmBringOnlineResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmBringOnlineResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmBringOnlineResponse*)this)->requestToken);
	((SRMv2__srmBringOnlineResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmBringOnlineResponse*)this)->remainingTotalRequestTime = NULL;
	((SRMv2__srmBringOnlineResponse*)this)->remainingDeferredStartTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmBringOnlineResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmBringOnlineResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmBringOnlineResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmBringOnlineResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmBringOnlineResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmBringOnlineResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmBringOnlineResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmBringOnlineResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmBringOnlineResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmBringOnlineResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmBringOnlineResponse*)a)->remainingTotalRequestTime), "");
	soap_out_PointerToint(soap, "remainingDeferredStartTime", -1, &(((SRMv2__srmBringOnlineResponse*)a)->remainingDeferredStartTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmBringOnlineResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmBringOnlineResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmBringOnlineResponse * SOAP_FMAC4 soap_get_SRMv2__srmBringOnlineResponse(struct soap *soap, SRMv2__srmBringOnlineResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmBringOnlineResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmBringOnlineResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmBringOnlineResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmBringOnlineResponse * SOAP_FMAC4 soap_in_SRMv2__srmBringOnlineResponse(struct soap *soap, const char *tag, SRMv2__srmBringOnlineResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmBringOnlineResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmBringOnlineResponse, sizeof(SRMv2__srmBringOnlineResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmBringOnlineResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmBringOnlineResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1, soap_flag_remainingDeferredStartTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmBringOnlineResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmBringOnlineResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTBringOnlineRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmBringOnlineResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTBringOnlineRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmBringOnlineResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			if (soap_flag_remainingDeferredStartTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingDeferredStartTime", &(((SRMv2__srmBringOnlineResponse*)a)->remainingDeferredStartTime), "xsd:int"))
				{	soap_flag_remainingDeferredStartTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmBringOnlineResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmBringOnlineResponse, 0, sizeof(SRMv2__srmBringOnlineResponse), 0, soap_copy_SRMv2__srmBringOnlineResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmBringOnlineResponse * SOAP_FMAC6 soap_new_SRMv2__srmBringOnlineResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmBringOnlineResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmBringOnlineResponse(struct soap *soap, SRMv2__srmBringOnlineResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmBringOnlineResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmBringOnlineResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmBringOnlineResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmBringOnlineResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmBringOnlineResponse;
		if (size)
			*size = sizeof(SRMv2__srmBringOnlineResponse);
		((SRMv2__srmBringOnlineResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmBringOnlineResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmBringOnlineResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmBringOnlineResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmBringOnlineResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmBringOnlineResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmBringOnlineResponse %p -> %p\n", q, p));
	*(SRMv2__srmBringOnlineResponse*)p = *(SRMv2__srmBringOnlineResponse*)q;
}

void SRMv2__srmBringOnlineRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfTGetFileRequest(soap, &((SRMv2__srmBringOnlineRequest*)this)->arrayOfFileRequests);
	soap_serialize_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmBringOnlineRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmBringOnlineRequest*)this)->desiredFileStorageType);
	soap_serialize_PointerToint(soap, &((SRMv2__srmBringOnlineRequest*)this)->desiredTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmBringOnlineRequest*)this)->desiredLifeTime);
	soap_serialize_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->targetSpaceToken);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmBringOnlineRequest*)this)->targetFileRetentionPolicyInfo);
	soap_serialize_PointerToSRMv2__TTransferParameters(soap, &((SRMv2__srmBringOnlineRequest*)this)->transferParameters);
	soap_serialize_PointerToint(soap, &((SRMv2__srmBringOnlineRequest*)this)->deferredStartTime);
	/* transient soap skipped */
}

void SRMv2__srmBringOnlineRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->authorizationID);
	((SRMv2__srmBringOnlineRequest*)this)->arrayOfFileRequests = NULL;
	soap_default_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->userRequestDescription);
	((SRMv2__srmBringOnlineRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmBringOnlineRequest*)this)->desiredFileStorageType = NULL;
	((SRMv2__srmBringOnlineRequest*)this)->desiredTotalRequestTime = NULL;
	((SRMv2__srmBringOnlineRequest*)this)->desiredLifeTime = NULL;
	soap_default_string(soap, &((SRMv2__srmBringOnlineRequest*)this)->targetSpaceToken);
	((SRMv2__srmBringOnlineRequest*)this)->targetFileRetentionPolicyInfo = NULL;
	((SRMv2__srmBringOnlineRequest*)this)->transferParameters = NULL;
	((SRMv2__srmBringOnlineRequest*)this)->deferredStartTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmBringOnlineRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmBringOnlineRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmBringOnlineRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmBringOnlineRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmBringOnlineRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmBringOnlineRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmBringOnlineRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmBringOnlineRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmBringOnlineRequest*)a)->arrayOfFileRequests), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmBringOnlineRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmBringOnlineRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", -1, &(((SRMv2__srmBringOnlineRequest*)a)->desiredFileStorageType), "");
	soap_out_PointerToint(soap, "desiredTotalRequestTime", -1, &(((SRMv2__srmBringOnlineRequest*)a)->desiredTotalRequestTime), "");
	soap_out_PointerToint(soap, "desiredLifeTime", -1, &(((SRMv2__srmBringOnlineRequest*)a)->desiredLifeTime), "");
	soap_out_string(soap, "targetSpaceToken", -1, &(((SRMv2__srmBringOnlineRequest*)a)->targetSpaceToken), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", -1, &(((SRMv2__srmBringOnlineRequest*)a)->targetFileRetentionPolicyInfo), "");
	soap_out_PointerToSRMv2__TTransferParameters(soap, "transferParameters", -1, &(((SRMv2__srmBringOnlineRequest*)a)->transferParameters), "");
	soap_out_PointerToint(soap, "deferredStartTime", -1, &(((SRMv2__srmBringOnlineRequest*)a)->deferredStartTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmBringOnlineRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmBringOnlineRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmBringOnlineRequest * SOAP_FMAC4 soap_get_SRMv2__srmBringOnlineRequest(struct soap *soap, SRMv2__srmBringOnlineRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmBringOnlineRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmBringOnlineRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmBringOnlineRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmBringOnlineRequest * SOAP_FMAC4 soap_in_SRMv2__srmBringOnlineRequest(struct soap *soap, const char *tag, SRMv2__srmBringOnlineRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmBringOnlineRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmBringOnlineRequest, sizeof(SRMv2__srmBringOnlineRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmBringOnlineRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmBringOnlineRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_desiredFileStorageType1 = 1, soap_flag_desiredTotalRequestTime1 = 1, soap_flag_desiredLifeTime1 = 1, soap_flag_targetSpaceToken1 = 1, soap_flag_targetFileRetentionPolicyInfo1 = 1, soap_flag_transferParameters1 = 1, soap_flag_deferredStartTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmBringOnlineRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmBringOnlineRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTGetFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmBringOnlineRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmBringOnlineRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_desiredFileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", &(((SRMv2__srmBringOnlineRequest*)a)->desiredFileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_desiredFileStorageType1--;
					continue;
				}
			if (soap_flag_desiredTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredTotalRequestTime", &(((SRMv2__srmBringOnlineRequest*)a)->desiredTotalRequestTime), "xsd:int"))
				{	soap_flag_desiredTotalRequestTime1--;
					continue;
				}
			if (soap_flag_desiredLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredLifeTime", &(((SRMv2__srmBringOnlineRequest*)a)->desiredLifeTime), "xsd:int"))
				{	soap_flag_desiredLifeTime1--;
					continue;
				}
			if (soap_flag_targetSpaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "targetSpaceToken", &(((SRMv2__srmBringOnlineRequest*)a)->targetSpaceToken), "xsd:string"))
				{	soap_flag_targetSpaceToken1--;
					continue;
				}
			if (soap_flag_targetFileRetentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", &(((SRMv2__srmBringOnlineRequest*)a)->targetFileRetentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_targetFileRetentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_transferParameters1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTransferParameters(soap, "transferParameters", &(((SRMv2__srmBringOnlineRequest*)a)->transferParameters), "SRMv2:TTransferParameters"))
				{	soap_flag_transferParameters1--;
					continue;
				}
			if (soap_flag_deferredStartTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "deferredStartTime", &(((SRMv2__srmBringOnlineRequest*)a)->deferredStartTime), "xsd:int"))
				{	soap_flag_deferredStartTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmBringOnlineRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmBringOnlineRequest, 0, sizeof(SRMv2__srmBringOnlineRequest), 0, soap_copy_SRMv2__srmBringOnlineRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmBringOnlineRequest * SOAP_FMAC6 soap_new_SRMv2__srmBringOnlineRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmBringOnlineRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmBringOnlineRequest(struct soap *soap, SRMv2__srmBringOnlineRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmBringOnlineRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmBringOnlineRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmBringOnlineRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmBringOnlineRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmBringOnlineRequest;
		if (size)
			*size = sizeof(SRMv2__srmBringOnlineRequest);
		((SRMv2__srmBringOnlineRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmBringOnlineRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmBringOnlineRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmBringOnlineRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmBringOnlineRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmBringOnlineRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmBringOnlineRequest %p -> %p\n", q, p));
	*(SRMv2__srmBringOnlineRequest*)p = *(SRMv2__srmBringOnlineRequest*)q;
}

void SRMv2__srmStatusOfGetRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfGetRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, &((SRMv2__srmStatusOfGetRequestResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfGetRequestResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfGetRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfGetRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfGetRequestResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmStatusOfGetRequestResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfGetRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfGetRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfGetRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfGetRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfGetRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfGetRequestResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmStatusOfGetRequestResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfGetRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfGetRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, SRMv2__srmStatusOfGetRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfGetRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfGetRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfGetRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfGetRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, sizeof(SRMv2__srmStatusOfGetRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfGetRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfGetRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfGetRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTGetRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmStatusOfGetRequestResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfGetRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, 0, sizeof(SRMv2__srmStatusOfGetRequestResponse), 0, soap_copy_SRMv2__srmStatusOfGetRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, SRMv2__srmStatusOfGetRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfGetRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfGetRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfGetRequestResponse);
		((SRMv2__srmStatusOfGetRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfGetRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfGetRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfGetRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfGetRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfGetRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfGetRequestResponse*)p = *(SRMv2__srmStatusOfGetRequestResponse*)q;
}

void SRMv2__srmStatusOfGetRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->requestToken);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->arrayOfSourceSURLs);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfGetRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->requestToken);
	soap_default_string(soap, &((SRMv2__srmStatusOfGetRequestRequest*)this)->authorizationID);
	((SRMv2__srmStatusOfGetRequestRequest*)this)->arrayOfSourceSURLs = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfGetRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfGetRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfGetRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfGetRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->requestToken), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", -1, &(((SRMv2__srmStatusOfGetRequestRequest*)a)->arrayOfSourceSURLs), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfGetRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfGetRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, SRMv2__srmStatusOfGetRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfGetRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfGetRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfGetRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfGetRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, sizeof(SRMv2__srmStatusOfGetRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfGetRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_authorizationID1 = 1, soap_flag_arrayOfSourceSURLs1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSourceSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSourceSURLs", &(((SRMv2__srmStatusOfGetRequestRequest*)a)->arrayOfSourceSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSourceSURLs1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfGetRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, 0, sizeof(SRMv2__srmStatusOfGetRequestRequest), 0, soap_copy_SRMv2__srmStatusOfGetRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, SRMv2__srmStatusOfGetRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfGetRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfGetRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfGetRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfGetRequestRequest);
		((SRMv2__srmStatusOfGetRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfGetRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfGetRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfGetRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfGetRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfGetRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfGetRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfGetRequestRequest*)p = *(SRMv2__srmStatusOfGetRequestRequest*)q;
}

void SRMv2__srmPrepareToGetResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPrepareToGetResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToGetResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, &((SRMv2__srmPrepareToGetResponse*)this)->arrayOfFileStatuses);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToGetResponse*)this)->remainingTotalRequestTime);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToGetResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPrepareToGetResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToGetResponse*)this)->requestToken);
	((SRMv2__srmPrepareToGetResponse*)this)->arrayOfFileStatuses = NULL;
	((SRMv2__srmPrepareToGetResponse*)this)->remainingTotalRequestTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToGetResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToGetResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToGetResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToGetResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToGetResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToGetResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToGetResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->arrayOfFileStatuses), "");
	soap_out_PointerToint(soap, "remainingTotalRequestTime", -1, &(((SRMv2__srmPrepareToGetResponse*)a)->remainingTotalRequestTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToGetResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToGetResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToGetResponse(struct soap *soap, SRMv2__srmPrepareToGetResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToGetResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToGetResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToGetResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToGetResponse(struct soap *soap, const char *tag, SRMv2__srmPrepareToGetResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToGetResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, sizeof(SRMv2__srmPrepareToGetResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToGetResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToGetResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_arrayOfFileStatuses1 = 1, soap_flag_remainingTotalRequestTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPrepareToGetResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmPrepareToGetResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetRequestFileStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPrepareToGetResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTGetRequestFileStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			if (soap_flag_remainingTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingTotalRequestTime", &(((SRMv2__srmPrepareToGetResponse*)a)->remainingTotalRequestTime), "xsd:int"))
				{	soap_flag_remainingTotalRequestTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToGetResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, 0, sizeof(SRMv2__srmPrepareToGetResponse), 0, soap_copy_SRMv2__srmPrepareToGetResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToGetResponse * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToGetResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToGetResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToGetResponse(struct soap *soap, SRMv2__srmPrepareToGetResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToGetResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToGetResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToGetResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetResponse;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToGetResponse);
		((SRMv2__srmPrepareToGetResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToGetResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToGetResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToGetResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToGetResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToGetResponse %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToGetResponse*)p = *(SRMv2__srmPrepareToGetResponse*)q;
}

void SRMv2__srmPrepareToGetRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfTGetFileRequest(soap, &((SRMv2__srmPrepareToGetRequest*)this)->arrayOfFileRequests);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->userRequestDescription);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmPrepareToGetRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmPrepareToGetRequest*)this)->desiredFileStorageType);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToGetRequest*)this)->desiredTotalRequestTime);
	soap_serialize_PointerToint(soap, &((SRMv2__srmPrepareToGetRequest*)this)->desiredPinLifeTime);
	soap_serialize_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->targetSpaceToken);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmPrepareToGetRequest*)this)->targetFileRetentionPolicyInfo);
	soap_serialize_PointerToSRMv2__TTransferParameters(soap, &((SRMv2__srmPrepareToGetRequest*)this)->transferParameters);
	/* transient soap skipped */
}

void SRMv2__srmPrepareToGetRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->authorizationID);
	((SRMv2__srmPrepareToGetRequest*)this)->arrayOfFileRequests = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->userRequestDescription);
	((SRMv2__srmPrepareToGetRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->desiredFileStorageType = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->desiredTotalRequestTime = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->desiredPinLifeTime = NULL;
	soap_default_string(soap, &((SRMv2__srmPrepareToGetRequest*)this)->targetSpaceToken);
	((SRMv2__srmPrepareToGetRequest*)this)->targetFileRetentionPolicyInfo = NULL;
	((SRMv2__srmPrepareToGetRequest*)this)->transferParameters = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPrepareToGetRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPrepareToGetRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPrepareToGetRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPrepareToGetRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPrepareToGetRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPrepareToGetRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPrepareToGetRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfFileRequests), "");
	soap_out_string(soap, "userRequestDescription", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->userRequestDescription), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->desiredFileStorageType), "");
	soap_out_PointerToint(soap, "desiredTotalRequestTime", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->desiredTotalRequestTime), "");
	soap_out_PointerToint(soap, "desiredPinLifeTime", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->desiredPinLifeTime), "");
	soap_out_string(soap, "targetSpaceToken", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->targetSpaceToken), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->targetFileRetentionPolicyInfo), "");
	soap_out_PointerToSRMv2__TTransferParameters(soap, "transferParameters", -1, &(((SRMv2__srmPrepareToGetRequest*)a)->transferParameters), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPrepareToGetRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPrepareToGetRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_get_SRMv2__srmPrepareToGetRequest(struct soap *soap, SRMv2__srmPrepareToGetRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPrepareToGetRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPrepareToGetRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPrepareToGetRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_in_SRMv2__srmPrepareToGetRequest(struct soap *soap, const char *tag, SRMv2__srmPrepareToGetRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPrepareToGetRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, sizeof(SRMv2__srmPrepareToGetRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPrepareToGetRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPrepareToGetRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfFileRequests1 = 1, soap_flag_userRequestDescription1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_desiredFileStorageType1 = 1, soap_flag_desiredTotalRequestTime1 = 1, soap_flag_desiredPinLifeTime1 = 1, soap_flag_targetSpaceToken1 = 1, soap_flag_targetFileRetentionPolicyInfo1 = 1, soap_flag_transferParameters1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmPrepareToGetRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfFileRequests1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGetFileRequest(soap, "arrayOfFileRequests", &(((SRMv2__srmPrepareToGetRequest*)a)->arrayOfFileRequests), "SRMv2:ArrayOfTGetFileRequest"))
				{	soap_flag_arrayOfFileRequests1--;
					continue;
				}
			if (soap_flag_userRequestDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userRequestDescription", &(((SRMv2__srmPrepareToGetRequest*)a)->userRequestDescription), "xsd:string"))
				{	soap_flag_userRequestDescription1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmPrepareToGetRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_desiredFileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "desiredFileStorageType", &(((SRMv2__srmPrepareToGetRequest*)a)->desiredFileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_desiredFileStorageType1--;
					continue;
				}
			if (soap_flag_desiredTotalRequestTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredTotalRequestTime", &(((SRMv2__srmPrepareToGetRequest*)a)->desiredTotalRequestTime), "xsd:int"))
				{	soap_flag_desiredTotalRequestTime1--;
					continue;
				}
			if (soap_flag_desiredPinLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredPinLifeTime", &(((SRMv2__srmPrepareToGetRequest*)a)->desiredPinLifeTime), "xsd:int"))
				{	soap_flag_desiredPinLifeTime1--;
					continue;
				}
			if (soap_flag_targetSpaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "targetSpaceToken", &(((SRMv2__srmPrepareToGetRequest*)a)->targetSpaceToken), "xsd:string"))
				{	soap_flag_targetSpaceToken1--;
					continue;
				}
			if (soap_flag_targetFileRetentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "targetFileRetentionPolicyInfo", &(((SRMv2__srmPrepareToGetRequest*)a)->targetFileRetentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_targetFileRetentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_transferParameters1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTransferParameters(soap, "transferParameters", &(((SRMv2__srmPrepareToGetRequest*)a)->transferParameters), "SRMv2:TTransferParameters"))
				{	soap_flag_transferParameters1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfFileRequests1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPrepareToGetRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, 0, sizeof(SRMv2__srmPrepareToGetRequest), 0, soap_copy_SRMv2__srmPrepareToGetRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPrepareToGetRequest * SOAP_FMAC6 soap_new_SRMv2__srmPrepareToGetRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPrepareToGetRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPrepareToGetRequest(struct soap *soap, SRMv2__srmPrepareToGetRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPrepareToGetRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPrepareToGetRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPrepareToGetRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPrepareToGetRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetRequest;
		if (size)
			*size = sizeof(SRMv2__srmPrepareToGetRequest);
		((SRMv2__srmPrepareToGetRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPrepareToGetRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPrepareToGetRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPrepareToGetRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPrepareToGetRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPrepareToGetRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPrepareToGetRequest %p -> %p\n", q, p));
	*(SRMv2__srmPrepareToGetRequest*)p = *(SRMv2__srmPrepareToGetRequest*)q;
}

void SRMv2__srmMvResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmMvResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmMvResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMvResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMvResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMvResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMvResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMvResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMvResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmMvResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMvResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmMvResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMvResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMvResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_get_SRMv2__srmMvResponse(struct soap *soap, SRMv2__srmMvResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMvResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMvResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMvResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_in_SRMv2__srmMvResponse(struct soap *soap, const char *tag, SRMv2__srmMvResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMvResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMvResponse, sizeof(SRMv2__srmMvResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMvResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMvResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmMvResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMvResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMvResponse, 0, sizeof(SRMv2__srmMvResponse), 0, soap_copy_SRMv2__srmMvResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMvResponse * SOAP_FMAC6 soap_new_SRMv2__srmMvResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMvResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMvResponse(struct soap *soap, SRMv2__srmMvResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMvResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmMvResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMvResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMvResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMvResponse;
		if (size)
			*size = sizeof(SRMv2__srmMvResponse);
		((SRMv2__srmMvResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMvResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMvResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMvResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMvResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMvResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMvResponse %p -> %p\n", q, p));
	*(SRMv2__srmMvResponse*)p = *(SRMv2__srmMvResponse*)q;
}

void SRMv2__srmMvRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmMvRequest*)this)->authorizationID);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__srmMvRequest*)this)->fromSURL);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__srmMvRequest*)this)->toSURL);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmMvRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmMvRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmMvRequest*)this)->authorizationID);
	soap_default_xsd__anyURI(soap, &((SRMv2__srmMvRequest*)this)->fromSURL);
	soap_default_xsd__anyURI(soap, &((SRMv2__srmMvRequest*)this)->toSURL);
	((SRMv2__srmMvRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMvRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMvRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMvRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMvRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMvRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmMvRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMvRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmMvRequest*)a)->authorizationID), "");
	soap_out_xsd__anyURI(soap, "fromSURL", -1, &(((SRMv2__srmMvRequest*)a)->fromSURL), "");
	soap_out_xsd__anyURI(soap, "toSURL", -1, &(((SRMv2__srmMvRequest*)a)->toSURL), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmMvRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMvRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMvRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_get_SRMv2__srmMvRequest(struct soap *soap, SRMv2__srmMvRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMvRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMvRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMvRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_in_SRMv2__srmMvRequest(struct soap *soap, const char *tag, SRMv2__srmMvRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMvRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMvRequest, sizeof(SRMv2__srmMvRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMvRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMvRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_fromSURL1 = 1, soap_flag_toSURL1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmMvRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_fromSURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "fromSURL", &(((SRMv2__srmMvRequest*)a)->fromSURL), "xsd:anyURI"))
				{	soap_flag_fromSURL1--;
					continue;
				}
			if (soap_flag_toSURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "toSURL", &(((SRMv2__srmMvRequest*)a)->toSURL), "xsd:anyURI"))
				{	soap_flag_toSURL1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmMvRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fromSURL1 > 0 || soap_flag_toSURL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMvRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMvRequest, 0, sizeof(SRMv2__srmMvRequest), 0, soap_copy_SRMv2__srmMvRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMvRequest * SOAP_FMAC6 soap_new_SRMv2__srmMvRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMvRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMvRequest(struct soap *soap, SRMv2__srmMvRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMvRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmMvRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMvRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMvRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMvRequest;
		if (size)
			*size = sizeof(SRMv2__srmMvRequest);
		((SRMv2__srmMvRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMvRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMvRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMvRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMvRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMvRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMvRequest %p -> %p\n", q, p));
	*(SRMv2__srmMvRequest*)p = *(SRMv2__srmMvRequest*)q;
}

void SRMv2__srmStatusOfLsRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfLsRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, &((SRMv2__srmStatusOfLsRequestResponse*)this)->details);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfLsRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfLsRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfLsRequestResponse*)this)->details = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfLsRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfLsRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfLsRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfLsRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfLsRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", -1, &(((SRMv2__srmStatusOfLsRequestResponse*)a)->details), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfLsRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfLsRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, SRMv2__srmStatusOfLsRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfLsRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfLsRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfLsRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfLsRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfLsRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse, sizeof(SRMv2__srmStatusOfLsRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfLsRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_details1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfLsRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_details1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", &(((SRMv2__srmStatusOfLsRequestResponse*)a)->details), "SRMv2:ArrayOfTMetaDataPathDetail"))
				{	soap_flag_details1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfLsRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse, 0, sizeof(SRMv2__srmStatusOfLsRequestResponse), 0, soap_copy_SRMv2__srmStatusOfLsRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfLsRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfLsRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, SRMv2__srmStatusOfLsRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfLsRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfLsRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfLsRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfLsRequestResponse);
		((SRMv2__srmStatusOfLsRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfLsRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfLsRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfLsRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfLsRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfLsRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfLsRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfLsRequestResponse*)p = *(SRMv2__srmStatusOfLsRequestResponse*)q;
}

void SRMv2__srmStatusOfLsRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->requestToken);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->offset);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->count);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfLsRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmStatusOfLsRequestRequest*)this)->requestToken);
	((SRMv2__srmStatusOfLsRequestRequest*)this)->offset = NULL;
	((SRMv2__srmStatusOfLsRequestRequest*)this)->count = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfLsRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfLsRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfLsRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfLsRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfLsRequestRequest*)a)->authorizationID), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfLsRequestRequest*)a)->requestToken), "");
	soap_out_PointerToint(soap, "offset", -1, &(((SRMv2__srmStatusOfLsRequestRequest*)a)->offset), "");
	soap_out_PointerToint(soap, "count", -1, &(((SRMv2__srmStatusOfLsRequestRequest*)a)->count), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfLsRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfLsRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, SRMv2__srmStatusOfLsRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfLsRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfLsRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfLsRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfLsRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfLsRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest, sizeof(SRMv2__srmStatusOfLsRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfLsRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_requestToken1 = 1, soap_flag_offset1 = 1, soap_flag_count1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfLsRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfLsRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_offset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "offset", &(((SRMv2__srmStatusOfLsRequestRequest*)a)->offset), "xsd:int"))
				{	soap_flag_offset1--;
					continue;
				}
			if (soap_flag_count1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "count", &(((SRMv2__srmStatusOfLsRequestRequest*)a)->count), "xsd:int"))
				{	soap_flag_count1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfLsRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest, 0, sizeof(SRMv2__srmStatusOfLsRequestRequest), 0, soap_copy_SRMv2__srmStatusOfLsRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfLsRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfLsRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, SRMv2__srmStatusOfLsRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfLsRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfLsRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfLsRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfLsRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfLsRequestRequest);
		((SRMv2__srmStatusOfLsRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfLsRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfLsRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfLsRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfLsRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfLsRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfLsRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfLsRequestRequest*)p = *(SRMv2__srmStatusOfLsRequestRequest*)q;
}

void SRMv2__srmLsResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmLsResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmLsResponse*)this)->requestToken);
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, &((SRMv2__srmLsResponse*)this)->details);
	/* transient soap skipped */
}

void SRMv2__srmLsResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmLsResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmLsResponse*)this)->requestToken);
	((SRMv2__srmLsResponse*)this)->details = NULL;
	/* transient soap skipped */
}

int SRMv2__srmLsResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmLsResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmLsResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmLsResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmLsResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmLsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmLsResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmLsResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmLsResponse*)a)->requestToken), "");
	soap_out_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", -1, &(((SRMv2__srmLsResponse*)a)->details), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmLsResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmLsResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_get_SRMv2__srmLsResponse(struct soap *soap, SRMv2__srmLsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmLsResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmLsResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmLsResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_in_SRMv2__srmLsResponse(struct soap *soap, const char *tag, SRMv2__srmLsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmLsResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmLsResponse, sizeof(SRMv2__srmLsResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmLsResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmLsResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_details1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmLsResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmLsResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_details1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataPathDetail(soap, "details", &(((SRMv2__srmLsResponse*)a)->details), "SRMv2:ArrayOfTMetaDataPathDetail"))
				{	soap_flag_details1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmLsResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmLsResponse, 0, sizeof(SRMv2__srmLsResponse), 0, soap_copy_SRMv2__srmLsResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmLsResponse * SOAP_FMAC6 soap_new_SRMv2__srmLsResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmLsResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmLsResponse(struct soap *soap, SRMv2__srmLsResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmLsResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmLsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmLsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmLsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmLsResponse;
		if (size)
			*size = sizeof(SRMv2__srmLsResponse);
		((SRMv2__srmLsResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmLsResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmLsResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmLsResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmLsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmLsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmLsResponse %p -> %p\n", q, p));
	*(SRMv2__srmLsResponse*)p = *(SRMv2__srmLsResponse*)q;
}

void SRMv2__srmLsRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmLsRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmLsRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmLsRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TFileStorageType(soap, &((SRMv2__srmLsRequest*)this)->fileStorageType);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmLsRequest*)this)->fullDetailedList);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmLsRequest*)this)->allLevelRecursive);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->numOfLevels);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->offset);
	soap_serialize_PointerToint(soap, &((SRMv2__srmLsRequest*)this)->count);
	/* transient soap skipped */
}

void SRMv2__srmLsRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmLsRequest*)this)->authorizationID);
	((SRMv2__srmLsRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmLsRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmLsRequest*)this)->fileStorageType = NULL;
	((SRMv2__srmLsRequest*)this)->fullDetailedList = NULL;
	((SRMv2__srmLsRequest*)this)->allLevelRecursive = NULL;
	((SRMv2__srmLsRequest*)this)->numOfLevels = NULL;
	((SRMv2__srmLsRequest*)this)->offset = NULL;
	((SRMv2__srmLsRequest*)this)->count = NULL;
	/* transient soap skipped */
}

int SRMv2__srmLsRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmLsRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmLsRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmLsRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmLsRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmLsRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmLsRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmLsRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmLsRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmLsRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", -1, &(((SRMv2__srmLsRequest*)a)->fileStorageType), "");
	soap_out_PointerTobool(soap, "fullDetailedList", -1, &(((SRMv2__srmLsRequest*)a)->fullDetailedList), "");
	soap_out_PointerTobool(soap, "allLevelRecursive", -1, &(((SRMv2__srmLsRequest*)a)->allLevelRecursive), "");
	soap_out_PointerToint(soap, "numOfLevels", -1, &(((SRMv2__srmLsRequest*)a)->numOfLevels), "");
	soap_out_PointerToint(soap, "offset", -1, &(((SRMv2__srmLsRequest*)a)->offset), "");
	soap_out_PointerToint(soap, "count", -1, &(((SRMv2__srmLsRequest*)a)->count), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmLsRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmLsRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_get_SRMv2__srmLsRequest(struct soap *soap, SRMv2__srmLsRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmLsRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmLsRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmLsRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_in_SRMv2__srmLsRequest(struct soap *soap, const char *tag, SRMv2__srmLsRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmLsRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmLsRequest, sizeof(SRMv2__srmLsRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmLsRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmLsRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_fileStorageType1 = 1, soap_flag_fullDetailedList1 = 1, soap_flag_allLevelRecursive1 = 1, soap_flag_numOfLevels1 = 1, soap_flag_offset1 = 1, soap_flag_count1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmLsRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmLsRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmLsRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_fileStorageType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TFileStorageType(soap, "fileStorageType", &(((SRMv2__srmLsRequest*)a)->fileStorageType), "SRMv2:TFileStorageType"))
				{	soap_flag_fileStorageType1--;
					continue;
				}
			if (soap_flag_fullDetailedList1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "fullDetailedList", &(((SRMv2__srmLsRequest*)a)->fullDetailedList), "xsd:boolean"))
				{	soap_flag_fullDetailedList1--;
					continue;
				}
			if (soap_flag_allLevelRecursive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "allLevelRecursive", &(((SRMv2__srmLsRequest*)a)->allLevelRecursive), "xsd:boolean"))
				{	soap_flag_allLevelRecursive1--;
					continue;
				}
			if (soap_flag_numOfLevels1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "numOfLevels", &(((SRMv2__srmLsRequest*)a)->numOfLevels), "xsd:int"))
				{	soap_flag_numOfLevels1--;
					continue;
				}
			if (soap_flag_offset1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "offset", &(((SRMv2__srmLsRequest*)a)->offset), "xsd:int"))
				{	soap_flag_offset1--;
					continue;
				}
			if (soap_flag_count1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "count", &(((SRMv2__srmLsRequest*)a)->count), "xsd:int"))
				{	soap_flag_count1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmLsRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmLsRequest, 0, sizeof(SRMv2__srmLsRequest), 0, soap_copy_SRMv2__srmLsRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmLsRequest * SOAP_FMAC6 soap_new_SRMv2__srmLsRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmLsRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmLsRequest(struct soap *soap, SRMv2__srmLsRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmLsRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmLsRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmLsRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmLsRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmLsRequest;
		if (size)
			*size = sizeof(SRMv2__srmLsRequest);
		((SRMv2__srmLsRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmLsRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmLsRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmLsRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmLsRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmLsRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmLsRequest %p -> %p\n", q, p));
	*(SRMv2__srmLsRequest*)p = *(SRMv2__srmLsRequest*)q;
}

void SRMv2__srmRmResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmRmResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmRmResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmRmResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmResponse*)this)->returnStatus = NULL;
	((SRMv2__srmRmResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmRmResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmRmResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmRmResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_get_SRMv2__srmRmResponse(struct soap *soap, SRMv2__srmRmResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_in_SRMv2__srmRmResponse(struct soap *soap, const char *tag, SRMv2__srmRmResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmResponse, sizeof(SRMv2__srmRmResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmRmResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmRmResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmResponse, 0, sizeof(SRMv2__srmRmResponse), 0, soap_copy_SRMv2__srmRmResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmResponse * SOAP_FMAC6 soap_new_SRMv2__srmRmResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmResponse(struct soap *soap, SRMv2__srmRmResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmResponse;
		if (size)
			*size = sizeof(SRMv2__srmRmResponse);
		((SRMv2__srmRmResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmResponse %p -> %p\n", q, p));
	*(SRMv2__srmRmResponse*)p = *(SRMv2__srmRmResponse*)q;
}

void SRMv2__srmRmRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmRmRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmRmRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmRmRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmRmRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmRmRequest*)this)->authorizationID);
	((SRMv2__srmRmRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmRmRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmRmRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmRmRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmRmRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmRmRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_get_SRMv2__srmRmRequest(struct soap *soap, SRMv2__srmRmRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_in_SRMv2__srmRmRequest(struct soap *soap, const char *tag, SRMv2__srmRmRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmRequest, sizeof(SRMv2__srmRmRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmRmRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmRmRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmRmRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmRequest, 0, sizeof(SRMv2__srmRmRequest), 0, soap_copy_SRMv2__srmRmRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmRequest * SOAP_FMAC6 soap_new_SRMv2__srmRmRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmRequest(struct soap *soap, SRMv2__srmRmRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmRequest;
		if (size)
			*size = sizeof(SRMv2__srmRmRequest);
		((SRMv2__srmRmRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmRequest %p -> %p\n", q, p));
	*(SRMv2__srmRmRequest*)p = *(SRMv2__srmRmRequest*)q;
}

void SRMv2__srmRmdirResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmRmdirResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmRmdirResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmRmdirResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmdirResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmdirResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmdirResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmdirResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmdirResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmRmdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmdirResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmRmdirResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmdirResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmdirResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_get_SRMv2__srmRmdirResponse(struct soap *soap, SRMv2__srmRmdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmdirResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmdirResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_in_SRMv2__srmRmdirResponse(struct soap *soap, const char *tag, SRMv2__srmRmdirResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmdirResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmdirResponse, sizeof(SRMv2__srmRmdirResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmdirResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmdirResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmRmdirResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmdirResponse, 0, sizeof(SRMv2__srmRmdirResponse), 0, soap_copy_SRMv2__srmRmdirResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmdirResponse * SOAP_FMAC6 soap_new_SRMv2__srmRmdirResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmdirResponse(struct soap *soap, SRMv2__srmRmdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmdirResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmdirResponse;
		if (size)
			*size = sizeof(SRMv2__srmRmdirResponse);
		((SRMv2__srmRmdirResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmdirResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmdirResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmdirResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmdirResponse %p -> %p\n", q, p));
	*(SRMv2__srmRmdirResponse*)p = *(SRMv2__srmRmdirResponse*)q;
}

void SRMv2__srmRmdirRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmRmdirRequest*)this)->authorizationID);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__srmRmdirRequest*)this)->SURL);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmRmdirRequest*)this)->storageSystemInfo);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmRmdirRequest*)this)->recursive);
	/* transient soap skipped */
}

void SRMv2__srmRmdirRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmRmdirRequest*)this)->authorizationID);
	soap_default_xsd__anyURI(soap, &((SRMv2__srmRmdirRequest*)this)->SURL);
	((SRMv2__srmRmdirRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmRmdirRequest*)this)->recursive = NULL;
	/* transient soap skipped */
}

int SRMv2__srmRmdirRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmRmdirRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmRmdirRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmRmdirRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmRmdirRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmRmdirRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmRmdirRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmRmdirRequest*)a)->authorizationID), "");
	soap_out_xsd__anyURI(soap, "SURL", -1, &(((SRMv2__srmRmdirRequest*)a)->SURL), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmRmdirRequest*)a)->storageSystemInfo), "");
	soap_out_PointerTobool(soap, "recursive", -1, &(((SRMv2__srmRmdirRequest*)a)->recursive), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmRmdirRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmRmdirRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_get_SRMv2__srmRmdirRequest(struct soap *soap, SRMv2__srmRmdirRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmRmdirRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmRmdirRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmRmdirRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_in_SRMv2__srmRmdirRequest(struct soap *soap, const char *tag, SRMv2__srmRmdirRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmRmdirRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmRmdirRequest, sizeof(SRMv2__srmRmdirRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmRmdirRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmRmdirRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_SURL1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_recursive1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmRmdirRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_SURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "SURL", &(((SRMv2__srmRmdirRequest*)a)->SURL), "xsd:anyURI"))
				{	soap_flag_SURL1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmRmdirRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_recursive1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "recursive", &(((SRMv2__srmRmdirRequest*)a)->recursive), "xsd:boolean"))
				{	soap_flag_recursive1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SURL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmRmdirRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmRmdirRequest, 0, sizeof(SRMv2__srmRmdirRequest), 0, soap_copy_SRMv2__srmRmdirRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmRmdirRequest * SOAP_FMAC6 soap_new_SRMv2__srmRmdirRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmRmdirRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmRmdirRequest(struct soap *soap, SRMv2__srmRmdirRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmRmdirRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmRmdirRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmRmdirRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmRmdirRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmRmdirRequest;
		if (size)
			*size = sizeof(SRMv2__srmRmdirRequest);
		((SRMv2__srmRmdirRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmRmdirRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmRmdirRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmRmdirRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmRmdirRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmRmdirRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmRmdirRequest %p -> %p\n", q, p));
	*(SRMv2__srmRmdirRequest*)p = *(SRMv2__srmRmdirRequest*)q;
}

void SRMv2__srmMkdirResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmMkdirResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmMkdirResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmMkdirResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMkdirResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMkdirResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMkdirResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMkdirResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMkdirResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmMkdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMkdirResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmMkdirResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMkdirResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMkdirResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_get_SRMv2__srmMkdirResponse(struct soap *soap, SRMv2__srmMkdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMkdirResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMkdirResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMkdirResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_in_SRMv2__srmMkdirResponse(struct soap *soap, const char *tag, SRMv2__srmMkdirResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMkdirResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMkdirResponse, sizeof(SRMv2__srmMkdirResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMkdirResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMkdirResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmMkdirResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMkdirResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMkdirResponse, 0, sizeof(SRMv2__srmMkdirResponse), 0, soap_copy_SRMv2__srmMkdirResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMkdirResponse * SOAP_FMAC6 soap_new_SRMv2__srmMkdirResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMkdirResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMkdirResponse(struct soap *soap, SRMv2__srmMkdirResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMkdirResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmMkdirResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMkdirResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMkdirResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMkdirResponse;
		if (size)
			*size = sizeof(SRMv2__srmMkdirResponse);
		((SRMv2__srmMkdirResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMkdirResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMkdirResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMkdirResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMkdirResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMkdirResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMkdirResponse %p -> %p\n", q, p));
	*(SRMv2__srmMkdirResponse*)p = *(SRMv2__srmMkdirResponse*)q;
}

void SRMv2__srmMkdirRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmMkdirRequest*)this)->authorizationID);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__srmMkdirRequest*)this)->SURL);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmMkdirRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmMkdirRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmMkdirRequest*)this)->authorizationID);
	soap_default_xsd__anyURI(soap, &((SRMv2__srmMkdirRequest*)this)->SURL);
	((SRMv2__srmMkdirRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmMkdirRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmMkdirRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmMkdirRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmMkdirRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmMkdirRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmMkdirRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmMkdirRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmMkdirRequest*)a)->authorizationID), "");
	soap_out_xsd__anyURI(soap, "SURL", -1, &(((SRMv2__srmMkdirRequest*)a)->SURL), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmMkdirRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmMkdirRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmMkdirRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_get_SRMv2__srmMkdirRequest(struct soap *soap, SRMv2__srmMkdirRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmMkdirRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmMkdirRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmMkdirRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_in_SRMv2__srmMkdirRequest(struct soap *soap, const char *tag, SRMv2__srmMkdirRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmMkdirRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmMkdirRequest, sizeof(SRMv2__srmMkdirRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmMkdirRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmMkdirRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_SURL1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmMkdirRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_SURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "SURL", &(((SRMv2__srmMkdirRequest*)a)->SURL), "xsd:anyURI"))
				{	soap_flag_SURL1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmMkdirRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SURL1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmMkdirRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmMkdirRequest, 0, sizeof(SRMv2__srmMkdirRequest), 0, soap_copy_SRMv2__srmMkdirRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmMkdirRequest * SOAP_FMAC6 soap_new_SRMv2__srmMkdirRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmMkdirRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmMkdirRequest(struct soap *soap, SRMv2__srmMkdirRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmMkdirRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmMkdirRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmMkdirRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmMkdirRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmMkdirRequest;
		if (size)
			*size = sizeof(SRMv2__srmMkdirRequest);
		((SRMv2__srmMkdirRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmMkdirRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmMkdirRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmMkdirRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmMkdirRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmMkdirRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmMkdirRequest %p -> %p\n", q, p));
	*(SRMv2__srmMkdirRequest*)p = *(SRMv2__srmMkdirRequest*)q;
}

void SRMv2__srmGetPermissionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetPermissionResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTPermissionReturn(soap, &((SRMv2__srmGetPermissionResponse*)this)->arrayOfPermissionReturns);
	/* transient soap skipped */
}

void SRMv2__srmGetPermissionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetPermissionResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetPermissionResponse*)this)->arrayOfPermissionReturns = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetPermissionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetPermissionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetPermissionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetPermissionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetPermissionResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetPermissionResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetPermissionResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTPermissionReturn(soap, "arrayOfPermissionReturns", -1, &(((SRMv2__srmGetPermissionResponse*)a)->arrayOfPermissionReturns), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetPermissionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetPermissionResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetPermissionResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetPermissionResponse(struct soap *soap, SRMv2__srmGetPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetPermissionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetPermissionResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetPermissionResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetPermissionResponse(struct soap *soap, const char *tag, SRMv2__srmGetPermissionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetPermissionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetPermissionResponse, sizeof(SRMv2__srmGetPermissionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetPermissionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetPermissionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfPermissionReturns1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetPermissionResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfPermissionReturns1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTPermissionReturn(soap, "arrayOfPermissionReturns", &(((SRMv2__srmGetPermissionResponse*)a)->arrayOfPermissionReturns), "SRMv2:ArrayOfTPermissionReturn"))
				{	soap_flag_arrayOfPermissionReturns1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetPermissionResponse, 0, sizeof(SRMv2__srmGetPermissionResponse), 0, soap_copy_SRMv2__srmGetPermissionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetPermissionResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetPermissionResponse(struct soap *soap, SRMv2__srmGetPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetPermissionResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetPermissionResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetPermissionResponse);
		((SRMv2__srmGetPermissionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetPermissionResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetPermissionResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetPermissionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetPermissionResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetPermissionResponse*)p = *(SRMv2__srmGetPermissionResponse*)q;
}

void SRMv2__srmGetPermissionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetPermissionRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmGetPermissionRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmGetPermissionRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmGetPermissionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetPermissionRequest*)this)->authorizationID);
	((SRMv2__srmGetPermissionRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmGetPermissionRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetPermissionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetPermissionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetPermissionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetPermissionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetPermissionRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetPermissionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetPermissionRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetPermissionRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmGetPermissionRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmGetPermissionRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetPermissionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetPermissionRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetPermissionRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetPermissionRequest(struct soap *soap, SRMv2__srmGetPermissionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetPermissionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetPermissionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetPermissionRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetPermissionRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetPermissionRequest(struct soap *soap, const char *tag, SRMv2__srmGetPermissionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetPermissionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetPermissionRequest, sizeof(SRMv2__srmGetPermissionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetPermissionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetPermissionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetPermissionRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmGetPermissionRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmGetPermissionRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetPermissionRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetPermissionRequest, 0, sizeof(SRMv2__srmGetPermissionRequest), 0, soap_copy_SRMv2__srmGetPermissionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetPermissionRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetPermissionRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetPermissionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetPermissionRequest(struct soap *soap, SRMv2__srmGetPermissionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetPermissionRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetPermissionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetPermissionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetPermissionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetPermissionRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetPermissionRequest);
		((SRMv2__srmGetPermissionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetPermissionRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetPermissionRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetPermissionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetPermissionRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetPermissionRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetPermissionRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetPermissionRequest*)p = *(SRMv2__srmGetPermissionRequest*)q;
}

void SRMv2__srmCheckPermissionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmCheckPermissionResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, &((SRMv2__srmCheckPermissionResponse*)this)->arrayOfPermissions);
	/* transient soap skipped */
}

void SRMv2__srmCheckPermissionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCheckPermissionResponse*)this)->returnStatus = NULL;
	((SRMv2__srmCheckPermissionResponse*)this)->arrayOfPermissions = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCheckPermissionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCheckPermissionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCheckPermissionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCheckPermissionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCheckPermissionResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmCheckPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCheckPermissionResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmCheckPermissionResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, "arrayOfPermissions", -1, &(((SRMv2__srmCheckPermissionResponse*)a)->arrayOfPermissions), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCheckPermissionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCheckPermissionResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_get_SRMv2__srmCheckPermissionResponse(struct soap *soap, SRMv2__srmCheckPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCheckPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCheckPermissionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCheckPermissionResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_in_SRMv2__srmCheckPermissionResponse(struct soap *soap, const char *tag, SRMv2__srmCheckPermissionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCheckPermissionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, sizeof(SRMv2__srmCheckPermissionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCheckPermissionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCheckPermissionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfPermissions1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmCheckPermissionResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLPermissionReturn(soap, "arrayOfPermissions", &(((SRMv2__srmCheckPermissionResponse*)a)->arrayOfPermissions), "SRMv2:ArrayOfTSURLPermissionReturn"))
				{	soap_flag_arrayOfPermissions1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCheckPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, 0, sizeof(SRMv2__srmCheckPermissionResponse), 0, soap_copy_SRMv2__srmCheckPermissionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCheckPermissionResponse * SOAP_FMAC6 soap_new_SRMv2__srmCheckPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCheckPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCheckPermissionResponse(struct soap *soap, SRMv2__srmCheckPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmCheckPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCheckPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCheckPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionResponse;
		if (size)
			*size = sizeof(SRMv2__srmCheckPermissionResponse);
		((SRMv2__srmCheckPermissionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCheckPermissionResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCheckPermissionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCheckPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCheckPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCheckPermissionResponse %p -> %p\n", q, p));
	*(SRMv2__srmCheckPermissionResponse*)p = *(SRMv2__srmCheckPermissionResponse*)q;
}

void SRMv2__srmCheckPermissionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmCheckPermissionRequest*)this)->arrayOfSURLs);
	soap_serialize_string(soap, &((SRMv2__srmCheckPermissionRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmCheckPermissionRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmCheckPermissionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmCheckPermissionRequest*)this)->arrayOfSURLs = NULL;
	soap_default_string(soap, &((SRMv2__srmCheckPermissionRequest*)this)->authorizationID);
	((SRMv2__srmCheckPermissionRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmCheckPermissionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmCheckPermissionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmCheckPermissionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmCheckPermissionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmCheckPermissionRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmCheckPermissionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmCheckPermissionRequest), type);
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->arrayOfSURLs), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmCheckPermissionRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmCheckPermissionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmCheckPermissionRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_get_SRMv2__srmCheckPermissionRequest(struct soap *soap, SRMv2__srmCheckPermissionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmCheckPermissionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmCheckPermissionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmCheckPermissionRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_in_SRMv2__srmCheckPermissionRequest(struct soap *soap, const char *tag, SRMv2__srmCheckPermissionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmCheckPermissionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, sizeof(SRMv2__srmCheckPermissionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmCheckPermissionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmCheckPermissionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_arrayOfSURLs1 = 1, soap_flag_authorizationID1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmCheckPermissionRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmCheckPermissionRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmCheckPermissionRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmCheckPermissionRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, 0, sizeof(SRMv2__srmCheckPermissionRequest), 0, soap_copy_SRMv2__srmCheckPermissionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmCheckPermissionRequest * SOAP_FMAC6 soap_new_SRMv2__srmCheckPermissionRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmCheckPermissionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmCheckPermissionRequest(struct soap *soap, SRMv2__srmCheckPermissionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmCheckPermissionRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmCheckPermissionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmCheckPermissionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmCheckPermissionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionRequest;
		if (size)
			*size = sizeof(SRMv2__srmCheckPermissionRequest);
		((SRMv2__srmCheckPermissionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmCheckPermissionRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmCheckPermissionRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmCheckPermissionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmCheckPermissionRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmCheckPermissionRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmCheckPermissionRequest %p -> %p\n", q, p));
	*(SRMv2__srmCheckPermissionRequest*)p = *(SRMv2__srmCheckPermissionRequest*)q;
}

void SRMv2__srmSetPermissionResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmSetPermissionResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmSetPermissionResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmSetPermissionResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSetPermissionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSetPermissionResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSetPermissionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSetPermissionResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSetPermissionResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmSetPermissionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSetPermissionResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmSetPermissionResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSetPermissionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSetPermissionResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_get_SRMv2__srmSetPermissionResponse(struct soap *soap, SRMv2__srmSetPermissionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSetPermissionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSetPermissionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSetPermissionResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_in_SRMv2__srmSetPermissionResponse(struct soap *soap, const char *tag, SRMv2__srmSetPermissionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSetPermissionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSetPermissionResponse, sizeof(SRMv2__srmSetPermissionResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSetPermissionResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSetPermissionResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmSetPermissionResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSetPermissionResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSetPermissionResponse, 0, sizeof(SRMv2__srmSetPermissionResponse), 0, soap_copy_SRMv2__srmSetPermissionResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSetPermissionResponse * SOAP_FMAC6 soap_new_SRMv2__srmSetPermissionResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSetPermissionResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSetPermissionResponse(struct soap *soap, SRMv2__srmSetPermissionResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSetPermissionResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmSetPermissionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSetPermissionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSetPermissionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionResponse;
		if (size)
			*size = sizeof(SRMv2__srmSetPermissionResponse);
		((SRMv2__srmSetPermissionResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSetPermissionResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSetPermissionResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSetPermissionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSetPermissionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSetPermissionResponse %p -> %p\n", q, p));
	*(SRMv2__srmSetPermissionResponse*)p = *(SRMv2__srmSetPermissionResponse*)q;
}

void SRMv2__srmSetPermissionRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmSetPermissionRequest*)this)->authorizationID);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__srmSetPermissionRequest*)this)->SURL);
	soap_serialize_PointerToSRMv2__TPermissionMode(soap, &((SRMv2__srmSetPermissionRequest*)this)->ownerPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->arrayOfUserPermissions);
	soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, &((SRMv2__srmSetPermissionRequest*)this)->arrayOfGroupPermissions);
	soap_serialize_PointerToSRMv2__TPermissionMode(soap, &((SRMv2__srmSetPermissionRequest*)this)->otherPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmSetPermissionRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmSetPermissionRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmSetPermissionRequest*)this)->authorizationID);
	soap_default_xsd__anyURI(soap, &((SRMv2__srmSetPermissionRequest*)this)->SURL);
	soap_default_SRMv2__TPermissionType(soap, &((SRMv2__srmSetPermissionRequest*)this)->permissionType);
	((SRMv2__srmSetPermissionRequest*)this)->ownerPermission = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->arrayOfUserPermissions = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->arrayOfGroupPermissions = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->otherPermission = NULL;
	((SRMv2__srmSetPermissionRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmSetPermissionRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmSetPermissionRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmSetPermissionRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmSetPermissionRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmSetPermissionRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmSetPermissionRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmSetPermissionRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmSetPermissionRequest*)a)->authorizationID), "");
	soap_out_xsd__anyURI(soap, "SURL", -1, &(((SRMv2__srmSetPermissionRequest*)a)->SURL), "");
	soap_out_SRMv2__TPermissionType(soap, "permissionType", -1, &(((SRMv2__srmSetPermissionRequest*)a)->permissionType), "");
	soap_out_PointerToSRMv2__TPermissionMode(soap, "ownerPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->ownerPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, "arrayOfUserPermissions", -1, &(((SRMv2__srmSetPermissionRequest*)a)->arrayOfUserPermissions), "");
	soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, "arrayOfGroupPermissions", -1, &(((SRMv2__srmSetPermissionRequest*)a)->arrayOfGroupPermissions), "");
	soap_out_PointerToSRMv2__TPermissionMode(soap, "otherPermission", -1, &(((SRMv2__srmSetPermissionRequest*)a)->otherPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmSetPermissionRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmSetPermissionRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmSetPermissionRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_get_SRMv2__srmSetPermissionRequest(struct soap *soap, SRMv2__srmSetPermissionRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmSetPermissionRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmSetPermissionRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmSetPermissionRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_in_SRMv2__srmSetPermissionRequest(struct soap *soap, const char *tag, SRMv2__srmSetPermissionRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmSetPermissionRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmSetPermissionRequest, sizeof(SRMv2__srmSetPermissionRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmSetPermissionRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmSetPermissionRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_SURL1 = 1, soap_flag_permissionType1 = 1, soap_flag_ownerPermission1 = 1, soap_flag_arrayOfUserPermissions1 = 1, soap_flag_arrayOfGroupPermissions1 = 1, soap_flag_otherPermission1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmSetPermissionRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_SURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "SURL", &(((SRMv2__srmSetPermissionRequest*)a)->SURL), "xsd:anyURI"))
				{	soap_flag_SURL1--;
					continue;
				}
			if (soap_flag_permissionType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_SRMv2__TPermissionType(soap, "permissionType", &(((SRMv2__srmSetPermissionRequest*)a)->permissionType), "SRMv2:TPermissionType"))
				{	soap_flag_permissionType1--;
					continue;
				}
			if (soap_flag_ownerPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionMode(soap, "ownerPermission", &(((SRMv2__srmSetPermissionRequest*)a)->ownerPermission), "SRMv2:TPermissionMode"))
				{	soap_flag_ownerPermission1--;
					continue;
				}
			if (soap_flag_arrayOfUserPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, "arrayOfUserPermissions", &(((SRMv2__srmSetPermissionRequest*)a)->arrayOfUserPermissions), "SRMv2:ArrayOfTUserPermission"))
				{	soap_flag_arrayOfUserPermissions1--;
					continue;
				}
			if (soap_flag_arrayOfGroupPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, "arrayOfGroupPermissions", &(((SRMv2__srmSetPermissionRequest*)a)->arrayOfGroupPermissions), "SRMv2:ArrayOfTGroupPermission"))
				{	soap_flag_arrayOfGroupPermissions1--;
					continue;
				}
			if (soap_flag_otherPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionMode(soap, "otherPermission", &(((SRMv2__srmSetPermissionRequest*)a)->otherPermission), "SRMv2:TPermissionMode"))
				{	soap_flag_otherPermission1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmSetPermissionRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_SURL1 > 0 || soap_flag_permissionType1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmSetPermissionRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmSetPermissionRequest, 0, sizeof(SRMv2__srmSetPermissionRequest), 0, soap_copy_SRMv2__srmSetPermissionRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmSetPermissionRequest * SOAP_FMAC6 soap_new_SRMv2__srmSetPermissionRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmSetPermissionRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmSetPermissionRequest(struct soap *soap, SRMv2__srmSetPermissionRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmSetPermissionRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmSetPermissionRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmSetPermissionRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmSetPermissionRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionRequest;
		if (size)
			*size = sizeof(SRMv2__srmSetPermissionRequest);
		((SRMv2__srmSetPermissionRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmSetPermissionRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmSetPermissionRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmSetPermissionRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmSetPermissionRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmSetPermissionRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmSetPermissionRequest %p -> %p\n", q, p));
	*(SRMv2__srmSetPermissionRequest*)p = *(SRMv2__srmSetPermissionRequest*)q;
}

void SRMv2__srmGetSpaceTokensResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetSpaceTokensResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfString(soap, &((SRMv2__srmGetSpaceTokensResponse*)this)->arrayOfSpaceTokens);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceTokensResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceTokensResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetSpaceTokensResponse*)this)->arrayOfSpaceTokens = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceTokensResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceTokensResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceTokensResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceTokensResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetSpaceTokensResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfString(soap, "arrayOfSpaceTokens", -1, &(((SRMv2__srmGetSpaceTokensResponse*)a)->arrayOfSpaceTokens), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceTokensResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceTokensResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, SRMv2__srmGetSpaceTokensResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceTokensResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceTokensResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceTokensResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, const char *tag, SRMv2__srmGetSpaceTokensResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceTokensResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse, sizeof(SRMv2__srmGetSpaceTokensResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceTokensResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfSpaceTokens1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetSpaceTokensResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfSpaceTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfString(soap, "arrayOfSpaceTokens", &(((SRMv2__srmGetSpaceTokensResponse*)a)->arrayOfSpaceTokens), "SRMv2:ArrayOfString"))
				{	soap_flag_arrayOfSpaceTokens1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceTokensResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse, 0, sizeof(SRMv2__srmGetSpaceTokensResponse), 0, soap_copy_SRMv2__srmGetSpaceTokensResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceTokensResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceTokensResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, SRMv2__srmGetSpaceTokensResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceTokensResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceTokensResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokensResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceTokensResponse);
		((SRMv2__srmGetSpaceTokensResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokensResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceTokensResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceTokensResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceTokensResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceTokensResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceTokensResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceTokensResponse*)p = *(SRMv2__srmGetSpaceTokensResponse*)q;
}

void SRMv2__srmGetSpaceTokensRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetSpaceTokensRequest*)this)->userSpaceTokenDescription);
	soap_serialize_string(soap, &((SRMv2__srmGetSpaceTokensRequest*)this)->authorizationID);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceTokensRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetSpaceTokensRequest*)this)->userSpaceTokenDescription);
	soap_default_string(soap, &((SRMv2__srmGetSpaceTokensRequest*)this)->authorizationID);
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceTokensRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceTokensRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceTokensRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceTokensRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest), type);
	soap_out_string(soap, "userSpaceTokenDescription", -1, &(((SRMv2__srmGetSpaceTokensRequest*)a)->userSpaceTokenDescription), "");
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetSpaceTokensRequest*)a)->authorizationID), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceTokensRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceTokensRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, SRMv2__srmGetSpaceTokensRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceTokensRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceTokensRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceTokensRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, const char *tag, SRMv2__srmGetSpaceTokensRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceTokensRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest, sizeof(SRMv2__srmGetSpaceTokensRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceTokensRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_userSpaceTokenDescription1 = 1, soap_flag_authorizationID1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_userSpaceTokenDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userSpaceTokenDescription", &(((SRMv2__srmGetSpaceTokensRequest*)a)->userSpaceTokenDescription), "xsd:string"))
				{	soap_flag_userSpaceTokenDescription1--;
					continue;
				}
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetSpaceTokensRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceTokensRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest, 0, sizeof(SRMv2__srmGetSpaceTokensRequest), 0, soap_copy_SRMv2__srmGetSpaceTokensRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceTokensRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceTokensRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, SRMv2__srmGetSpaceTokensRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceTokensRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceTokensRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceTokensRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokensRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceTokensRequest);
		((SRMv2__srmGetSpaceTokensRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceTokensRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceTokensRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceTokensRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceTokensRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceTokensRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceTokensRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceTokensRequest*)p = *(SRMv2__srmGetSpaceTokensRequest*)q;
}

void SRMv2__srmPurgeFromSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmPurgeFromSpaceResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmPurgeFromSpaceResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmPurgeFromSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmPurgeFromSpaceResponse*)this)->returnStatus = NULL;
	((SRMv2__srmPurgeFromSpaceResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPurgeFromSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPurgeFromSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPurgeFromSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmPurgeFromSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmPurgeFromSpaceResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmPurgeFromSpaceResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPurgeFromSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPurgeFromSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, SRMv2__srmPurgeFromSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPurgeFromSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPurgeFromSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPurgeFromSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmPurgeFromSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPurgeFromSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse, sizeof(SRMv2__srmPurgeFromSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPurgeFromSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmPurgeFromSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmPurgeFromSpaceResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPurgeFromSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse, 0, sizeof(SRMv2__srmPurgeFromSpaceResponse), 0, soap_copy_SRMv2__srmPurgeFromSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPurgeFromSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPurgeFromSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, SRMv2__srmPurgeFromSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPurgeFromSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPurgeFromSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPurgeFromSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmPurgeFromSpaceResponse);
		((SRMv2__srmPurgeFromSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPurgeFromSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPurgeFromSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPurgeFromSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPurgeFromSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPurgeFromSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPurgeFromSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmPurgeFromSpaceResponse*)p = *(SRMv2__srmPurgeFromSpaceResponse*)q;
}

void SRMv2__srmPurgeFromSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->arrayOfSURLs);
	soap_serialize_string(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmPurgeFromSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->authorizationID);
	((SRMv2__srmPurgeFromSpaceRequest*)this)->arrayOfSURLs = NULL;
	soap_default_string(soap, &((SRMv2__srmPurgeFromSpaceRequest*)this)->spaceToken);
	((SRMv2__srmPurgeFromSpaceRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmPurgeFromSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmPurgeFromSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmPurgeFromSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmPurgeFromSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmPurgeFromSpaceRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmPurgeFromSpaceRequest*)a)->arrayOfSURLs), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmPurgeFromSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmPurgeFromSpaceRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmPurgeFromSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmPurgeFromSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, SRMv2__srmPurgeFromSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmPurgeFromSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmPurgeFromSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmPurgeFromSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmPurgeFromSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmPurgeFromSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest, sizeof(SRMv2__srmPurgeFromSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmPurgeFromSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_spaceToken1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmPurgeFromSpaceRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmPurgeFromSpaceRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmPurgeFromSpaceRequest*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmPurgeFromSpaceRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0 || soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmPurgeFromSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest, 0, sizeof(SRMv2__srmPurgeFromSpaceRequest), 0, soap_copy_SRMv2__srmPurgeFromSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmPurgeFromSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmPurgeFromSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, SRMv2__srmPurgeFromSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmPurgeFromSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmPurgeFromSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmPurgeFromSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmPurgeFromSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmPurgeFromSpaceRequest);
		((SRMv2__srmPurgeFromSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmPurgeFromSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmPurgeFromSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmPurgeFromSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmPurgeFromSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmPurgeFromSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmPurgeFromSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmPurgeFromSpaceRequest*)p = *(SRMv2__srmPurgeFromSpaceRequest*)q;
}

void SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)this)->returnStatus = NULL;
	((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeInSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeInSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeInSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeInSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeInSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse, sizeof(SRMv2__srmExtendFileLifeTimeInSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeInSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLLifetimeReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLLifetimeReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeInSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse, 0, sizeof(SRMv2__srmExtendFileLifeTimeInSpaceResponse), 0, soap_copy_SRMv2__srmExtendFileLifeTimeInSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeInSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, SRMv2__srmExtendFileLifeTimeInSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeInSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeInSpaceResponse);
		((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeInSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeInSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeInSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeInSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeInSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeInSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeInSpaceResponse*)p = *(SRMv2__srmExtendFileLifeTimeInSpaceResponse*)q;
}

void SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->arrayOfSURLs);
	soap_serialize_PointerToint(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->newLifeTime);
	/* transient soap skipped */
}

void SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->spaceToken);
	((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->arrayOfSURLs = NULL;
	((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)this)->newLifeTime = NULL;
	/* transient soap skipped */
}

int SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmExtendFileLifeTimeInSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->authorizationID), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->arrayOfSURLs), "");
	soap_out_PointerToint(soap, "newLifeTime", -1, &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->newLifeTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeInSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmExtendFileLifeTimeInSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmExtendFileLifeTimeInSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmExtendFileLifeTimeInSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest, sizeof(SRMv2__srmExtendFileLifeTimeInSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmExtendFileLifeTimeInSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_newLifeTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_newLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "newLifeTime", &(((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)a)->newLifeTime), "xsd:int"))
				{	soap_flag_newLifeTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmExtendFileLifeTimeInSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest, 0, sizeof(SRMv2__srmExtendFileLifeTimeInSpaceRequest), 0, soap_copy_SRMv2__srmExtendFileLifeTimeInSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmExtendFileLifeTimeInSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, SRMv2__srmExtendFileLifeTimeInSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmExtendFileLifeTimeInSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmExtendFileLifeTimeInSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmExtendFileLifeTimeInSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeInSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmExtendFileLifeTimeInSpaceRequest);
		((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmExtendFileLifeTimeInSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmExtendFileLifeTimeInSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmExtendFileLifeTimeInSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmExtendFileLifeTimeInSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmExtendFileLifeTimeInSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmExtendFileLifeTimeInSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmExtendFileLifeTimeInSpaceRequest*)p = *(SRMv2__srmExtendFileLifeTimeInSpaceRequest*)q;
}

void SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->estimatedProcessingTime = NULL;
	((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToint(soap, "estimatedProcessingTime", -1, &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse, sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_estimatedProcessingTime1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "estimatedProcessingTime", &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->estimatedProcessingTime), "xsd:int"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse, 0, sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse), 0, soap_copy_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse);
		((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)p = *(SRMv2__srmStatusOfChangeSpaceForFilesRequestResponse*)q;
}

void SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

int SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)a)->authorizationID), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)a)->requestToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest, sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_requestToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest, 0, sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest), 0, soap_copy_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest);
		((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)p = *(SRMv2__srmStatusOfChangeSpaceForFilesRequestRequest*)q;
}

void SRMv2__srmChangeSpaceForFilesResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmChangeSpaceForFilesResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmChangeSpaceForFilesResponse*)this)->requestToken);
	soap_serialize_PointerToint(soap, &((SRMv2__srmChangeSpaceForFilesResponse*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, &((SRMv2__srmChangeSpaceForFilesResponse*)this)->arrayOfFileStatuses);
	/* transient soap skipped */
}

void SRMv2__srmChangeSpaceForFilesResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmChangeSpaceForFilesResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmChangeSpaceForFilesResponse*)this)->requestToken);
	((SRMv2__srmChangeSpaceForFilesResponse*)this)->estimatedProcessingTime = NULL;
	((SRMv2__srmChangeSpaceForFilesResponse*)this)->arrayOfFileStatuses = NULL;
	/* transient soap skipped */
}

int SRMv2__srmChangeSpaceForFilesResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmChangeSpaceForFilesResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmChangeSpaceForFilesResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmChangeSpaceForFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->requestToken), "");
	soap_out_PointerToint(soap, "estimatedProcessingTime", -1, &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", -1, &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->arrayOfFileStatuses), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmChangeSpaceForFilesResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmChangeSpaceForFilesResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesResponse * SOAP_FMAC4 soap_get_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, SRMv2__srmChangeSpaceForFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmChangeSpaceForFilesResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmChangeSpaceForFilesResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmChangeSpaceForFilesResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesResponse * SOAP_FMAC4 soap_in_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, const char *tag, SRMv2__srmChangeSpaceForFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmChangeSpaceForFilesResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse, sizeof(SRMv2__srmChangeSpaceForFilesResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmChangeSpaceForFilesResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_estimatedProcessingTime1 = 1, soap_flag_arrayOfFileStatuses1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "estimatedProcessingTime", &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->estimatedProcessingTime), "xsd:int"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_arrayOfFileStatuses1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTSURLReturnStatus(soap, "arrayOfFileStatuses", &(((SRMv2__srmChangeSpaceForFilesResponse*)a)->arrayOfFileStatuses), "SRMv2:ArrayOfTSURLReturnStatus"))
				{	soap_flag_arrayOfFileStatuses1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmChangeSpaceForFilesResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse, 0, sizeof(SRMv2__srmChangeSpaceForFilesResponse), 0, soap_copy_SRMv2__srmChangeSpaceForFilesResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmChangeSpaceForFilesResponse * SOAP_FMAC6 soap_new_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmChangeSpaceForFilesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, SRMv2__srmChangeSpaceForFilesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmChangeSpaceForFilesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmChangeSpaceForFilesResponse;
		if (size)
			*size = sizeof(SRMv2__srmChangeSpaceForFilesResponse);
		((SRMv2__srmChangeSpaceForFilesResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmChangeSpaceForFilesResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmChangeSpaceForFilesResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmChangeSpaceForFilesResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmChangeSpaceForFilesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmChangeSpaceForFilesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmChangeSpaceForFilesResponse %p -> %p\n", q, p));
	*(SRMv2__srmChangeSpaceForFilesResponse*)p = *(SRMv2__srmChangeSpaceForFilesResponse*)q;
}

void SRMv2__srmChangeSpaceForFilesRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfAnyURI(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->arrayOfSURLs);
	soap_serialize_string(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->targetSpaceToken);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmChangeSpaceForFilesRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->authorizationID);
	((SRMv2__srmChangeSpaceForFilesRequest*)this)->arrayOfSURLs = NULL;
	soap_default_string(soap, &((SRMv2__srmChangeSpaceForFilesRequest*)this)->targetSpaceToken);
	((SRMv2__srmChangeSpaceForFilesRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmChangeSpaceForFilesRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmChangeSpaceForFilesRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmChangeSpaceForFilesRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmChangeSpaceForFilesRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", -1, &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->arrayOfSURLs), "");
	soap_out_string(soap, "targetSpaceToken", -1, &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->targetSpaceToken), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmChangeSpaceForFilesRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmChangeSpaceForFilesRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesRequest * SOAP_FMAC4 soap_get_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, SRMv2__srmChangeSpaceForFilesRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmChangeSpaceForFilesRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmChangeSpaceForFilesRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmChangeSpaceForFilesRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesRequest * SOAP_FMAC4 soap_in_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, const char *tag, SRMv2__srmChangeSpaceForFilesRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmChangeSpaceForFilesRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest, sizeof(SRMv2__srmChangeSpaceForFilesRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmChangeSpaceForFilesRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSURLs1 = 1, soap_flag_targetSpaceToken1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSURLs1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfAnyURI(soap, "arrayOfSURLs", &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->arrayOfSURLs), "SRMv2:ArrayOfAnyURI"))
				{	soap_flag_arrayOfSURLs1--;
					continue;
				}
			if (soap_flag_targetSpaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "targetSpaceToken", &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->targetSpaceToken), "xsd:string"))
				{	soap_flag_targetSpaceToken1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmChangeSpaceForFilesRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSURLs1 > 0 || soap_flag_targetSpaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmChangeSpaceForFilesRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest, 0, sizeof(SRMv2__srmChangeSpaceForFilesRequest), 0, soap_copy_SRMv2__srmChangeSpaceForFilesRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmChangeSpaceForFilesRequest * SOAP_FMAC6 soap_new_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmChangeSpaceForFilesRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, SRMv2__srmChangeSpaceForFilesRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmChangeSpaceForFilesRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmChangeSpaceForFilesRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmChangeSpaceForFilesRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmChangeSpaceForFilesRequest;
		if (size)
			*size = sizeof(SRMv2__srmChangeSpaceForFilesRequest);
		((SRMv2__srmChangeSpaceForFilesRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmChangeSpaceForFilesRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmChangeSpaceForFilesRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmChangeSpaceForFilesRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmChangeSpaceForFilesRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmChangeSpaceForFilesRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmChangeSpaceForFilesRequest %p -> %p\n", q, p));
	*(SRMv2__srmChangeSpaceForFilesRequest*)p = *(SRMv2__srmChangeSpaceForFilesRequest*)q;
}

void SRMv2__srmGetSpaceMetaDataResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmGetSpaceMetaDataResponse*)this)->returnStatus);
	soap_serialize_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, &((SRMv2__srmGetSpaceMetaDataResponse*)this)->arrayOfSpaceDetails);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceMetaDataResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmGetSpaceMetaDataResponse*)this)->returnStatus = NULL;
	((SRMv2__srmGetSpaceMetaDataResponse*)this)->arrayOfSpaceDetails = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceMetaDataResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceMetaDataResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceMetaDataResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->returnStatus), "");
	soap_out_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, "arrayOfSpaceDetails", -1, &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->arrayOfSpaceDetails), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceMetaDataResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceMetaDataResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, SRMv2__srmGetSpaceMetaDataResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceMetaDataResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceMetaDataResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, const char *tag, SRMv2__srmGetSpaceMetaDataResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceMetaDataResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, sizeof(SRMv2__srmGetSpaceMetaDataResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceMetaDataResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_arrayOfSpaceDetails1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_arrayOfSpaceDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTMetaDataSpace(soap, "arrayOfSpaceDetails", &(((SRMv2__srmGetSpaceMetaDataResponse*)a)->arrayOfSpaceDetails), "SRMv2:ArrayOfTMetaDataSpace"))
				{	soap_flag_arrayOfSpaceDetails1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceMetaDataResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, 0, sizeof(SRMv2__srmGetSpaceMetaDataResponse), 0, soap_copy_SRMv2__srmGetSpaceMetaDataResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, SRMv2__srmGetSpaceMetaDataResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceMetaDataResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataResponse;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceMetaDataResponse);
		((SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceMetaDataResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceMetaDataResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceMetaDataResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceMetaDataResponse %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceMetaDataResponse*)p = *(SRMv2__srmGetSpaceMetaDataResponse*)q;
}

void SRMv2__srmGetSpaceMetaDataRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmGetSpaceMetaDataRequest*)this)->authorizationID);
	soap_serialize_PointerToSRMv2__ArrayOfString(soap, &((SRMv2__srmGetSpaceMetaDataRequest*)this)->arrayOfSpaceTokens);
	/* transient soap skipped */
}

void SRMv2__srmGetSpaceMetaDataRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmGetSpaceMetaDataRequest*)this)->authorizationID);
	((SRMv2__srmGetSpaceMetaDataRequest*)this)->arrayOfSpaceTokens = NULL;
	/* transient soap skipped */
}

int SRMv2__srmGetSpaceMetaDataRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmGetSpaceMetaDataRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmGetSpaceMetaDataRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->authorizationID), "");
	soap_out_PointerToSRMv2__ArrayOfString(soap, "arrayOfSpaceTokens", -1, &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->arrayOfSpaceTokens), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmGetSpaceMetaDataRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmGetSpaceMetaDataRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_get_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, SRMv2__srmGetSpaceMetaDataRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmGetSpaceMetaDataRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmGetSpaceMetaDataRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_in_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, const char *tag, SRMv2__srmGetSpaceMetaDataRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmGetSpaceMetaDataRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, sizeof(SRMv2__srmGetSpaceMetaDataRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmGetSpaceMetaDataRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_arrayOfSpaceTokens1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_arrayOfSpaceTokens1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfString(soap, "arrayOfSpaceTokens", &(((SRMv2__srmGetSpaceMetaDataRequest*)a)->arrayOfSpaceTokens), "SRMv2:ArrayOfString"))
				{	soap_flag_arrayOfSpaceTokens1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_arrayOfSpaceTokens1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmGetSpaceMetaDataRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, 0, sizeof(SRMv2__srmGetSpaceMetaDataRequest), 0, soap_copy_SRMv2__srmGetSpaceMetaDataRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC6 soap_new_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, SRMv2__srmGetSpaceMetaDataRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmGetSpaceMetaDataRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmGetSpaceMetaDataRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmGetSpaceMetaDataRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataRequest;
		if (size)
			*size = sizeof(SRMv2__srmGetSpaceMetaDataRequest);
		((SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmGetSpaceMetaDataRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmGetSpaceMetaDataRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmGetSpaceMetaDataRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmGetSpaceMetaDataRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmGetSpaceMetaDataRequest %p -> %p\n", q, p));
	*(SRMv2__srmGetSpaceMetaDataRequest*)p = *(SRMv2__srmGetSpaceMetaDataRequest*)q;
}

void SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->returnStatus);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->sizeOfTotalSpace);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->sizeOfGuaranteedSpace);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->lifetimeGranted);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->sizeOfTotalSpace = NULL;
	((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->sizeOfGuaranteedSpace = NULL;
	((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)this)->lifetimeGranted = NULL;
	/* transient soap skipped */
}

int SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfUpdateSpaceRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->returnStatus), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfTotalSpace", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->sizeOfTotalSpace), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfGuaranteedSpace", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->sizeOfGuaranteedSpace), "");
	soap_out_PointerToint(soap, "lifetimeGranted", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->lifetimeGranted), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, SRMv2__srmStatusOfUpdateSpaceRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfUpdateSpaceRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfUpdateSpaceRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfUpdateSpaceRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse, sizeof(SRMv2__srmStatusOfUpdateSpaceRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfUpdateSpaceRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_sizeOfTotalSpace1 = 1, soap_flag_sizeOfGuaranteedSpace1 = 1, soap_flag_lifetimeGranted1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_sizeOfTotalSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfTotalSpace", &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->sizeOfTotalSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfTotalSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfGuaranteedSpace", &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->sizeOfGuaranteedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfGuaranteedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeGranted1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "lifetimeGranted", &(((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)a)->lifetimeGranted), "xsd:int"))
				{	soap_flag_lifetimeGranted1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfUpdateSpaceRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse, 0, sizeof(SRMv2__srmStatusOfUpdateSpaceRequestResponse), 0, soap_copy_SRMv2__srmStatusOfUpdateSpaceRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfUpdateSpaceRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, SRMv2__srmStatusOfUpdateSpaceRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfUpdateSpaceRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfUpdateSpaceRequestResponse);
		((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfUpdateSpaceRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfUpdateSpaceRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfUpdateSpaceRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfUpdateSpaceRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfUpdateSpaceRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfUpdateSpaceRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfUpdateSpaceRequestResponse*)p = *(SRMv2__srmStatusOfUpdateSpaceRequestResponse*)q;
}

void SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

int SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfUpdateSpaceRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)a)->authorizationID), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)a)->requestToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, SRMv2__srmStatusOfUpdateSpaceRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfUpdateSpaceRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfUpdateSpaceRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfUpdateSpaceRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest, sizeof(SRMv2__srmStatusOfUpdateSpaceRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfUpdateSpaceRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_requestToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfUpdateSpaceRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest, 0, sizeof(SRMv2__srmStatusOfUpdateSpaceRequestRequest), 0, soap_copy_SRMv2__srmStatusOfUpdateSpaceRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfUpdateSpaceRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, SRMv2__srmStatusOfUpdateSpaceRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfUpdateSpaceRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfUpdateSpaceRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfUpdateSpaceRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfUpdateSpaceRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfUpdateSpaceRequestRequest);
		((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfUpdateSpaceRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfUpdateSpaceRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfUpdateSpaceRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfUpdateSpaceRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfUpdateSpaceRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfUpdateSpaceRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfUpdateSpaceRequestRequest*)p = *(SRMv2__srmStatusOfUpdateSpaceRequestRequest*)q;
}

void SRMv2__srmUpdateSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->requestToken);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfTotalSpace);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfGuaranteedSpace);
	soap_serialize_PointerToint(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->lifetimeGranted);
	/* transient soap skipped */
}

void SRMv2__srmUpdateSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmUpdateSpaceResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmUpdateSpaceResponse*)this)->requestToken);
	((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfTotalSpace = NULL;
	((SRMv2__srmUpdateSpaceResponse*)this)->sizeOfGuaranteedSpace = NULL;
	((SRMv2__srmUpdateSpaceResponse*)this)->lifetimeGranted = NULL;
	/* transient soap skipped */
}

int SRMv2__srmUpdateSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmUpdateSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmUpdateSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmUpdateSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmUpdateSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->requestToken), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfTotalSpace", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfTotalSpace), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfGuaranteedSpace", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfGuaranteedSpace), "");
	soap_out_PointerToint(soap, "lifetimeGranted", -1, &(((SRMv2__srmUpdateSpaceResponse*)a)->lifetimeGranted), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmUpdateSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmUpdateSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmUpdateSpaceResponse(struct soap *soap, SRMv2__srmUpdateSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmUpdateSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmUpdateSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmUpdateSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmUpdateSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmUpdateSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmUpdateSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, sizeof(SRMv2__srmUpdateSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmUpdateSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmUpdateSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_sizeOfTotalSpace1 = 1, soap_flag_sizeOfGuaranteedSpace1 = 1, soap_flag_lifetimeGranted1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmUpdateSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmUpdateSpaceResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_sizeOfTotalSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfTotalSpace", &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfTotalSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfTotalSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfGuaranteedSpace", &(((SRMv2__srmUpdateSpaceResponse*)a)->sizeOfGuaranteedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfGuaranteedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeGranted1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "lifetimeGranted", &(((SRMv2__srmUpdateSpaceResponse*)a)->lifetimeGranted), "xsd:int"))
				{	soap_flag_lifetimeGranted1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmUpdateSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, 0, sizeof(SRMv2__srmUpdateSpaceResponse), 0, soap_copy_SRMv2__srmUpdateSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmUpdateSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmUpdateSpaceResponse(struct soap *soap, SRMv2__srmUpdateSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmUpdateSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmUpdateSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmUpdateSpaceResponse);
		((SRMv2__srmUpdateSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmUpdateSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmUpdateSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmUpdateSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmUpdateSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmUpdateSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmUpdateSpaceResponse*)p = *(SRMv2__srmUpdateSpaceResponse*)q;
}

void SRMv2__srmUpdateSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfTotalSpaceDesired);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfGuaranteedSpaceDesired);
	soap_serialize_PointerToint(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->newLifeTime);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->storageSystemInfo);
	/* transient soap skipped */
}

void SRMv2__srmUpdateSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmUpdateSpaceRequest*)this)->spaceToken);
	((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfTotalSpaceDesired = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->newSizeOfGuaranteedSpaceDesired = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->newLifeTime = NULL;
	((SRMv2__srmUpdateSpaceRequest*)this)->storageSystemInfo = NULL;
	/* transient soap skipped */
}

int SRMv2__srmUpdateSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmUpdateSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmUpdateSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmUpdateSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmUpdateSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->authorizationID), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerTounsignedLONG64(soap, "newSizeOfTotalSpaceDesired", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfTotalSpaceDesired), "");
	soap_out_PointerTounsignedLONG64(soap, "newSizeOfGuaranteedSpaceDesired", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfGuaranteedSpaceDesired), "");
	soap_out_PointerToint(soap, "newLifeTime", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->newLifeTime), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmUpdateSpaceRequest*)a)->storageSystemInfo), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmUpdateSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmUpdateSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmUpdateSpaceRequest(struct soap *soap, SRMv2__srmUpdateSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmUpdateSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmUpdateSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmUpdateSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmUpdateSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmUpdateSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmUpdateSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, sizeof(SRMv2__srmUpdateSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmUpdateSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmUpdateSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_newSizeOfTotalSpaceDesired1 = 1, soap_flag_newSizeOfGuaranteedSpaceDesired1 = 1, soap_flag_newLifeTime1 = 1, soap_flag_storageSystemInfo1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmUpdateSpaceRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmUpdateSpaceRequest*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_newSizeOfTotalSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "newSizeOfTotalSpaceDesired", &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfTotalSpaceDesired), "xsd:unsignedLong"))
				{	soap_flag_newSizeOfTotalSpaceDesired1--;
					continue;
				}
			if (soap_flag_newSizeOfGuaranteedSpaceDesired1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "newSizeOfGuaranteedSpaceDesired", &(((SRMv2__srmUpdateSpaceRequest*)a)->newSizeOfGuaranteedSpaceDesired), "xsd:unsignedLong"))
				{	soap_flag_newSizeOfGuaranteedSpaceDesired1--;
					continue;
				}
			if (soap_flag_newLifeTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "newLifeTime", &(((SRMv2__srmUpdateSpaceRequest*)a)->newLifeTime), "xsd:int"))
				{	soap_flag_newLifeTime1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmUpdateSpaceRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmUpdateSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, 0, sizeof(SRMv2__srmUpdateSpaceRequest), 0, soap_copy_SRMv2__srmUpdateSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmUpdateSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmUpdateSpaceRequest(struct soap *soap, SRMv2__srmUpdateSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmUpdateSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmUpdateSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmUpdateSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmUpdateSpaceRequest);
		((SRMv2__srmUpdateSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmUpdateSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmUpdateSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmUpdateSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmUpdateSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmUpdateSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmUpdateSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmUpdateSpaceRequest*)p = *(SRMv2__srmUpdateSpaceRequest*)q;
}

void SRMv2__srmReleaseSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReleaseSpaceResponse*)this)->returnStatus);
	/* transient soap skipped */
}

void SRMv2__srmReleaseSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReleaseSpaceResponse*)this)->returnStatus = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReleaseSpaceResponse*)a)->returnStatus), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmReleaseSpaceResponse(struct soap *soap, SRMv2__srmReleaseSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmReleaseSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmReleaseSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, sizeof(SRMv2__srmReleaseSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReleaseSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, 0, sizeof(SRMv2__srmReleaseSpaceResponse), 0, soap_copy_SRMv2__srmReleaseSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseSpaceResponse(struct soap *soap, SRMv2__srmReleaseSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmReleaseSpaceResponse);
		((SRMv2__srmReleaseSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmReleaseSpaceResponse*)p = *(SRMv2__srmReleaseSpaceResponse*)q;
}

void SRMv2__srmReleaseSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->spaceToken);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->storageSystemInfo);
	soap_serialize_PointerTobool(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->forceFileRelease);
	/* transient soap skipped */
}

void SRMv2__srmReleaseSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmReleaseSpaceRequest*)this)->spaceToken);
	((SRMv2__srmReleaseSpaceRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmReleaseSpaceRequest*)this)->forceFileRelease = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReleaseSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReleaseSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReleaseSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReleaseSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReleaseSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->authorizationID), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->spaceToken), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->storageSystemInfo), "");
	soap_out_PointerTobool(soap, "forceFileRelease", -1, &(((SRMv2__srmReleaseSpaceRequest*)a)->forceFileRelease), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReleaseSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReleaseSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmReleaseSpaceRequest(struct soap *soap, SRMv2__srmReleaseSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReleaseSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReleaseSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReleaseSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmReleaseSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmReleaseSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReleaseSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, sizeof(SRMv2__srmReleaseSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReleaseSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReleaseSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_spaceToken1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_forceFileRelease1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmReleaseSpaceRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmReleaseSpaceRequest*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmReleaseSpaceRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_forceFileRelease1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTobool(soap, "forceFileRelease", &(((SRMv2__srmReleaseSpaceRequest*)a)->forceFileRelease), "xsd:boolean"))
				{	soap_flag_forceFileRelease1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_spaceToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReleaseSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, 0, sizeof(SRMv2__srmReleaseSpaceRequest), 0, soap_copy_SRMv2__srmReleaseSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReleaseSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReleaseSpaceRequest(struct soap *soap, SRMv2__srmReleaseSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReleaseSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReleaseSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReleaseSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmReleaseSpaceRequest);
		((SRMv2__srmReleaseSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReleaseSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReleaseSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReleaseSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReleaseSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReleaseSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReleaseSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmReleaseSpaceRequest*)p = *(SRMv2__srmReleaseSpaceRequest*)q;
}

void SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->returnStatus);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->retentionPolicyInfo);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->sizeOfTotalReservedSpace);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->sizeOfGuaranteedReservedSpace);
	soap_serialize_PointerToint(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->lifetimeOfReservedSpace);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->spaceToken);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->returnStatus = NULL;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->estimatedProcessingTime = NULL;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->retentionPolicyInfo = NULL;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->sizeOfTotalReservedSpace = NULL;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->sizeOfGuaranteedReservedSpace = NULL;
	((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->lifetimeOfReservedSpace = NULL;
	soap_default_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestResponse*)this)->spaceToken);
	/* transient soap skipped */
}

int SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfReserveSpaceRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->returnStatus), "");
	soap_out_PointerToint(soap, "estimatedProcessingTime", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->retentionPolicyInfo), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfTotalReservedSpace", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->sizeOfTotalReservedSpace), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfGuaranteedReservedSpace", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->sizeOfGuaranteedReservedSpace), "");
	soap_out_PointerToint(soap, "lifetimeOfReservedSpace", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->lifetimeOfReservedSpace), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->spaceToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestResponse * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, SRMv2__srmStatusOfReserveSpaceRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfReserveSpaceRequestResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestResponse * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, const char *tag, SRMv2__srmStatusOfReserveSpaceRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfReserveSpaceRequestResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse, sizeof(SRMv2__srmStatusOfReserveSpaceRequestResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfReserveSpaceRequestResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_estimatedProcessingTime1 = 1, soap_flag_retentionPolicyInfo1 = 1, soap_flag_sizeOfTotalReservedSpace1 = 1, soap_flag_sizeOfGuaranteedReservedSpace1 = 1, soap_flag_lifetimeOfReservedSpace1 = 1, soap_flag_spaceToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "estimatedProcessingTime", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->estimatedProcessingTime), "xsd:int"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_retentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->retentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_retentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_sizeOfTotalReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfTotalReservedSpace", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->sizeOfTotalReservedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfTotalReservedSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfGuaranteedReservedSpace", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->sizeOfGuaranteedReservedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfGuaranteedReservedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "lifetimeOfReservedSpace", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->lifetimeOfReservedSpace), "xsd:int"))
				{	soap_flag_lifetimeOfReservedSpace1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmStatusOfReserveSpaceRequestResponse*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfReserveSpaceRequestResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse, 0, sizeof(SRMv2__srmStatusOfReserveSpaceRequestResponse), 0, soap_copy_SRMv2__srmStatusOfReserveSpaceRequestResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfReserveSpaceRequestResponse * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, SRMv2__srmStatusOfReserveSpaceRequestResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfReserveSpaceRequestResponse;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfReserveSpaceRequestResponse);
		((SRMv2__srmStatusOfReserveSpaceRequestResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfReserveSpaceRequestResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfReserveSpaceRequestResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfReserveSpaceRequestResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfReserveSpaceRequestResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfReserveSpaceRequestResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfReserveSpaceRequestResponse %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfReserveSpaceRequestResponse*)p = *(SRMv2__srmStatusOfReserveSpaceRequestResponse*)q;
}

void SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

void SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmStatusOfReserveSpaceRequestRequest*)this)->requestToken);
	/* transient soap skipped */
}

int SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmStatusOfReserveSpaceRequestRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestRequest*)a)->authorizationID), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmStatusOfReserveSpaceRequestRequest*)a)->requestToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestRequest * SOAP_FMAC4 soap_get_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, SRMv2__srmStatusOfReserveSpaceRequestRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmStatusOfReserveSpaceRequestRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestRequest * SOAP_FMAC4 soap_in_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, const char *tag, SRMv2__srmStatusOfReserveSpaceRequestRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmStatusOfReserveSpaceRequestRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest, sizeof(SRMv2__srmStatusOfReserveSpaceRequestRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmStatusOfReserveSpaceRequestRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_requestToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmStatusOfReserveSpaceRequestRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmStatusOfReserveSpaceRequestRequest*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmStatusOfReserveSpaceRequestRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest, 0, sizeof(SRMv2__srmStatusOfReserveSpaceRequestRequest), 0, soap_copy_SRMv2__srmStatusOfReserveSpaceRequestRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmStatusOfReserveSpaceRequestRequest * SOAP_FMAC6 soap_new_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, SRMv2__srmStatusOfReserveSpaceRequestRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmStatusOfReserveSpaceRequestRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmStatusOfReserveSpaceRequestRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmStatusOfReserveSpaceRequestRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmStatusOfReserveSpaceRequestRequest;
		if (size)
			*size = sizeof(SRMv2__srmStatusOfReserveSpaceRequestRequest);
		((SRMv2__srmStatusOfReserveSpaceRequestRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmStatusOfReserveSpaceRequestRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmStatusOfReserveSpaceRequestRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmStatusOfReserveSpaceRequestRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmStatusOfReserveSpaceRequestRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmStatusOfReserveSpaceRequestRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmStatusOfReserveSpaceRequestRequest %p -> %p\n", q, p));
	*(SRMv2__srmStatusOfReserveSpaceRequestRequest*)p = *(SRMv2__srmStatusOfReserveSpaceRequestRequest*)q;
}

void SRMv2__srmReserveSpaceResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__srmReserveSpaceResponse*)this)->returnStatus);
	soap_serialize_string(soap, &((SRMv2__srmReserveSpaceResponse*)this)->requestToken);
	soap_serialize_PointerToint(soap, &((SRMv2__srmReserveSpaceResponse*)this)->estimatedProcessingTime);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmReserveSpaceResponse*)this)->retentionPolicyInfo);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmReserveSpaceResponse*)this)->sizeOfTotalReservedSpace);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmReserveSpaceResponse*)this)->sizeOfGuaranteedReservedSpace);
	soap_serialize_PointerToint(soap, &((SRMv2__srmReserveSpaceResponse*)this)->lifetimeOfReservedSpace);
	soap_serialize_string(soap, &((SRMv2__srmReserveSpaceResponse*)this)->spaceToken);
	/* transient soap skipped */
}

void SRMv2__srmReserveSpaceResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__srmReserveSpaceResponse*)this)->returnStatus = NULL;
	soap_default_string(soap, &((SRMv2__srmReserveSpaceResponse*)this)->requestToken);
	((SRMv2__srmReserveSpaceResponse*)this)->estimatedProcessingTime = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->retentionPolicyInfo = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->sizeOfTotalReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->sizeOfGuaranteedReservedSpace = NULL;
	((SRMv2__srmReserveSpaceResponse*)this)->lifetimeOfReservedSpace = NULL;
	soap_default_string(soap, &((SRMv2__srmReserveSpaceResponse*)this)->spaceToken);
	/* transient soap skipped */
}

int SRMv2__srmReserveSpaceResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReserveSpaceResponse);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReserveSpaceResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReserveSpaceResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReserveSpaceResponse(struct soap *soap, const char *tag, int id, const SRMv2__srmReserveSpaceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReserveSpaceResponse), type);
	soap_out_PointerToSRMv2__TReturnStatus(soap, "returnStatus", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->returnStatus), "");
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->requestToken), "");
	soap_out_PointerToint(soap, "estimatedProcessingTime", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->estimatedProcessingTime), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->retentionPolicyInfo), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfTotalReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfTotalReservedSpace), "");
	soap_out_PointerTounsignedLONG64(soap, "sizeOfGuaranteedReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfGuaranteedReservedSpace), "");
	soap_out_PointerToint(soap, "lifetimeOfReservedSpace", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->lifetimeOfReservedSpace), "");
	soap_out_string(soap, "spaceToken", -1, &(((SRMv2__srmReserveSpaceResponse*)a)->spaceToken), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReserveSpaceResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReserveSpaceResponse(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_get_SRMv2__srmReserveSpaceResponse(struct soap *soap, SRMv2__srmReserveSpaceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReserveSpaceResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReserveSpaceResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReserveSpaceResponse(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_in_SRMv2__srmReserveSpaceResponse(struct soap *soap, const char *tag, SRMv2__srmReserveSpaceResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReserveSpaceResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, sizeof(SRMv2__srmReserveSpaceResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReserveSpaceResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReserveSpaceResponse *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_returnStatus1 = 1, soap_flag_requestToken1 = 1, soap_flag_estimatedProcessingTime1 = 1, soap_flag_retentionPolicyInfo1 = 1, soap_flag_sizeOfTotalReservedSpace1 = 1, soap_flag_sizeOfGuaranteedReservedSpace1 = 1, soap_flag_lifetimeOfReservedSpace1 = 1, soap_flag_spaceToken1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_returnStatus1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "returnStatus", &(((SRMv2__srmReserveSpaceResponse*)a)->returnStatus), "SRMv2:TReturnStatus"))
				{	soap_flag_returnStatus1--;
					continue;
				}
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__srmReserveSpaceResponse*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_estimatedProcessingTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "estimatedProcessingTime", &(((SRMv2__srmReserveSpaceResponse*)a)->estimatedProcessingTime), "xsd:int"))
				{	soap_flag_estimatedProcessingTime1--;
					continue;
				}
			if (soap_flag_retentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", &(((SRMv2__srmReserveSpaceResponse*)a)->retentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_retentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_sizeOfTotalReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfTotalReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfTotalReservedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfTotalReservedSpace1--;
					continue;
				}
			if (soap_flag_sizeOfGuaranteedReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "sizeOfGuaranteedReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->sizeOfGuaranteedReservedSpace), "xsd:unsignedLong"))
				{	soap_flag_sizeOfGuaranteedReservedSpace1--;
					continue;
				}
			if (soap_flag_lifetimeOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "lifetimeOfReservedSpace", &(((SRMv2__srmReserveSpaceResponse*)a)->lifetimeOfReservedSpace), "xsd:int"))
				{	soap_flag_lifetimeOfReservedSpace1--;
					continue;
				}
			if (soap_flag_spaceToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "spaceToken", &(((SRMv2__srmReserveSpaceResponse*)a)->spaceToken), "xsd:string"))
				{	soap_flag_spaceToken1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_returnStatus1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReserveSpaceResponse *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, 0, sizeof(SRMv2__srmReserveSpaceResponse), 0, soap_copy_SRMv2__srmReserveSpaceResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReserveSpaceResponse * SOAP_FMAC6 soap_new_SRMv2__srmReserveSpaceResponse(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReserveSpaceResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReserveSpaceResponse(struct soap *soap, SRMv2__srmReserveSpaceResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceResponse * SOAP_FMAC4 soap_instantiate_SRMv2__srmReserveSpaceResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReserveSpaceResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReserveSpaceResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceResponse;
		if (size)
			*size = sizeof(SRMv2__srmReserveSpaceResponse);
		((SRMv2__srmReserveSpaceResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceResponse[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReserveSpaceResponse);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReserveSpaceResponse*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReserveSpaceResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReserveSpaceResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReserveSpaceResponse %p -> %p\n", q, p));
	*(SRMv2__srmReserveSpaceResponse*)p = *(SRMv2__srmReserveSpaceResponse*)q;
}

void SRMv2__srmReserveSpaceRequest::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->authorizationID);
	soap_serialize_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->userSpaceTokenDescription);
	soap_serialize_PointerToSRMv2__TRetentionPolicyInfo(soap, &((SRMv2__srmReserveSpaceRequest*)this)->retentionPolicyInfo);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__srmReserveSpaceRequest*)this)->desiredSizeOfTotalSpace);
	soap_embedded(soap, &((SRMv2__srmReserveSpaceRequest*)this)->desiredSizeOfGuaranteedSpace, SOAP_TYPE_unsignedLONG64);
	soap_serialize_PointerToint(soap, &((SRMv2__srmReserveSpaceRequest*)this)->desiredLifetimeOfReservedSpace);
	soap_serialize_PointerToSRMv2__ArrayOfUnsignedLong(soap, &((SRMv2__srmReserveSpaceRequest*)this)->arrayOfExpectedFileSizes);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__srmReserveSpaceRequest*)this)->storageSystemInfo);
	soap_serialize_PointerToSRMv2__TTransferParameters(soap, &((SRMv2__srmReserveSpaceRequest*)this)->transferParameters);
	/* transient soap skipped */
}

void SRMv2__srmReserveSpaceRequest::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->authorizationID);
	soap_default_string(soap, &((SRMv2__srmReserveSpaceRequest*)this)->userSpaceTokenDescription);
	((SRMv2__srmReserveSpaceRequest*)this)->retentionPolicyInfo = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->desiredSizeOfTotalSpace = NULL;
	soap_default_unsignedLONG64(soap, &((SRMv2__srmReserveSpaceRequest*)this)->desiredSizeOfGuaranteedSpace);
	((SRMv2__srmReserveSpaceRequest*)this)->desiredLifetimeOfReservedSpace = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->arrayOfExpectedFileSizes = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->storageSystemInfo = NULL;
	((SRMv2__srmReserveSpaceRequest*)this)->transferParameters = NULL;
	/* transient soap skipped */
}

int SRMv2__srmReserveSpaceRequest::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__srmReserveSpaceRequest);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__srmReserveSpaceRequest::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__srmReserveSpaceRequest(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__srmReserveSpaceRequest(struct soap *soap, const char *tag, int id, const SRMv2__srmReserveSpaceRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__srmReserveSpaceRequest), type);
	soap_out_string(soap, "authorizationID", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->authorizationID), "");
	soap_out_string(soap, "userSpaceTokenDescription", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->userSpaceTokenDescription), "");
	soap_out_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->retentionPolicyInfo), "");
	soap_out_PointerTounsignedLONG64(soap, "desiredSizeOfTotalSpace", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->desiredSizeOfTotalSpace), "");
	soap_out_unsignedLONG64(soap, "desiredSizeOfGuaranteedSpace", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->desiredSizeOfGuaranteedSpace), "");
	soap_out_PointerToint(soap, "desiredLifetimeOfReservedSpace", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->desiredLifetimeOfReservedSpace), "");
	soap_out_PointerToSRMv2__ArrayOfUnsignedLong(soap, "arrayOfExpectedFileSizes", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->arrayOfExpectedFileSizes), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->storageSystemInfo), "");
	soap_out_PointerToSRMv2__TTransferParameters(soap, "transferParameters", -1, &(((SRMv2__srmReserveSpaceRequest*)a)->transferParameters), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__srmReserveSpaceRequest::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__srmReserveSpaceRequest(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_get_SRMv2__srmReserveSpaceRequest(struct soap *soap, SRMv2__srmReserveSpaceRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__srmReserveSpaceRequest(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__srmReserveSpaceRequest::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__srmReserveSpaceRequest(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_in_SRMv2__srmReserveSpaceRequest(struct soap *soap, const char *tag, SRMv2__srmReserveSpaceRequest *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__srmReserveSpaceRequest *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, sizeof(SRMv2__srmReserveSpaceRequest), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__srmReserveSpaceRequest)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__srmReserveSpaceRequest *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_authorizationID1 = 1, soap_flag_userSpaceTokenDescription1 = 1, soap_flag_retentionPolicyInfo1 = 1, soap_flag_desiredSizeOfTotalSpace1 = 1, soap_flag_desiredSizeOfGuaranteedSpace1 = 1, soap_flag_desiredLifetimeOfReservedSpace1 = 1, soap_flag_arrayOfExpectedFileSizes1 = 1, soap_flag_storageSystemInfo1 = 1, soap_flag_transferParameters1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_authorizationID1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "authorizationID", &(((SRMv2__srmReserveSpaceRequest*)a)->authorizationID), "xsd:string"))
				{	soap_flag_authorizationID1--;
					continue;
				}
			if (soap_flag_userSpaceTokenDescription1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "userSpaceTokenDescription", &(((SRMv2__srmReserveSpaceRequest*)a)->userSpaceTokenDescription), "xsd:string"))
				{	soap_flag_userSpaceTokenDescription1--;
					continue;
				}
			if (soap_flag_retentionPolicyInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRetentionPolicyInfo(soap, "retentionPolicyInfo", &(((SRMv2__srmReserveSpaceRequest*)a)->retentionPolicyInfo), "SRMv2:TRetentionPolicyInfo"))
				{	soap_flag_retentionPolicyInfo1--;
					continue;
				}
			if (soap_flag_desiredSizeOfTotalSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "desiredSizeOfTotalSpace", &(((SRMv2__srmReserveSpaceRequest*)a)->desiredSizeOfTotalSpace), "xsd:unsignedLong"))
				{	soap_flag_desiredSizeOfTotalSpace1--;
					continue;
				}
			if (soap_flag_desiredSizeOfGuaranteedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_unsignedLONG64(soap, "desiredSizeOfGuaranteedSpace", &(((SRMv2__srmReserveSpaceRequest*)a)->desiredSizeOfGuaranteedSpace), "xsd:unsignedLong"))
				{	soap_flag_desiredSizeOfGuaranteedSpace1--;
					continue;
				}
			if (soap_flag_desiredLifetimeOfReservedSpace1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "desiredLifetimeOfReservedSpace", &(((SRMv2__srmReserveSpaceRequest*)a)->desiredLifetimeOfReservedSpace), "xsd:int"))
				{	soap_flag_desiredLifetimeOfReservedSpace1--;
					continue;
				}
			if (soap_flag_arrayOfExpectedFileSizes1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfUnsignedLong(soap, "arrayOfExpectedFileSizes", &(((SRMv2__srmReserveSpaceRequest*)a)->arrayOfExpectedFileSizes), "SRMv2:ArrayOfUnsignedLong"))
				{	soap_flag_arrayOfExpectedFileSizes1--;
					continue;
				}
			if (soap_flag_storageSystemInfo1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "storageSystemInfo", &(((SRMv2__srmReserveSpaceRequest*)a)->storageSystemInfo), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_storageSystemInfo1--;
					continue;
				}
			if (soap_flag_transferParameters1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TTransferParameters(soap, "transferParameters", &(((SRMv2__srmReserveSpaceRequest*)a)->transferParameters), "SRMv2:TTransferParameters"))
				{	soap_flag_transferParameters1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_retentionPolicyInfo1 > 0 || soap_flag_desiredSizeOfGuaranteedSpace1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__srmReserveSpaceRequest *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, 0, sizeof(SRMv2__srmReserveSpaceRequest), 0, soap_copy_SRMv2__srmReserveSpaceRequest);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__srmReserveSpaceRequest * SOAP_FMAC6 soap_new_SRMv2__srmReserveSpaceRequest(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__srmReserveSpaceRequest(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__srmReserveSpaceRequest(struct soap *soap, SRMv2__srmReserveSpaceRequest *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__srmReserveSpaceRequest * SOAP_FMAC4 soap_instantiate_SRMv2__srmReserveSpaceRequest(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__srmReserveSpaceRequest(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__srmReserveSpaceRequest, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceRequest;
		if (size)
			*size = sizeof(SRMv2__srmReserveSpaceRequest);
		((SRMv2__srmReserveSpaceRequest*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__srmReserveSpaceRequest[n];
		if (size)
			*size = n * sizeof(SRMv2__srmReserveSpaceRequest);
		for (int i = 0; i < n; i++)
			((SRMv2__srmReserveSpaceRequest*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__srmReserveSpaceRequest*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__srmReserveSpaceRequest(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__srmReserveSpaceRequest %p -> %p\n", q, p));
	*(SRMv2__srmReserveSpaceRequest*)p = *(SRMv2__srmReserveSpaceRequest*)q;
}

void SRMv2__ArrayOfTSupportedTransferProtocol::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSupportedTransferProtocol*)this)->protocolArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSupportedTransferProtocol*)this)->__sizeprotocolArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSupportedTransferProtocol(soap, ((SRMv2__ArrayOfTSupportedTransferProtocol*)this)->protocolArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSupportedTransferProtocol::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSupportedTransferProtocol*)this)->__sizeprotocolArray = 0;
	((SRMv2__ArrayOfTSupportedTransferProtocol*)this)->protocolArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSupportedTransferProtocol::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSupportedTransferProtocol::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSupportedTransferProtocol(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSupportedTransferProtocol *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol), type);
	if (((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->protocolArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->__sizeprotocolArray; i++)
			soap_out_PointerToSRMv2__TSupportedTransferProtocol(soap, "protocolArray", -1, ((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->protocolArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSupportedTransferProtocol::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSupportedTransferProtocol(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSupportedTransferProtocol * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, SRMv2__ArrayOfTSupportedTransferProtocol *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSupportedTransferProtocol(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSupportedTransferProtocol::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSupportedTransferProtocol(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSupportedTransferProtocol * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, const char *tag, SRMv2__ArrayOfTSupportedTransferProtocol *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSupportedTransferProtocol *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol, sizeof(SRMv2__ArrayOfTSupportedTransferProtocol), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSupportedTransferProtocol *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_protocolArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_protocolArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSupportedTransferProtocol **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->__sizeprotocolArray = 0; !soap_element_begin_in(soap, "protocolArray", 1); ((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->__sizeprotocolArray++)
				{	p = (SRMv2__TSupportedTransferProtocol **)soap_push_block(soap, sizeof(SRMv2__TSupportedTransferProtocol *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSupportedTransferProtocol(soap, "protocolArray", p, "SRMv2:TSupportedTransferProtocol"))
						break;
					soap_flag_protocolArray1 = 0;
				}
				((SRMv2__ArrayOfTSupportedTransferProtocol*)a)->protocolArray = (SRMv2__TSupportedTransferProtocol **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_protocolArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSupportedTransferProtocol *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol, 0, sizeof(SRMv2__ArrayOfTSupportedTransferProtocol), 0, soap_copy_SRMv2__ArrayOfTSupportedTransferProtocol);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSupportedTransferProtocol * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSupportedTransferProtocol(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, SRMv2__ArrayOfTSupportedTransferProtocol *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSupportedTransferProtocol * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSupportedTransferProtocol(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSupportedTransferProtocol, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSupportedTransferProtocol;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSupportedTransferProtocol);
		((SRMv2__ArrayOfTSupportedTransferProtocol*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSupportedTransferProtocol[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSupportedTransferProtocol);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSupportedTransferProtocol*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSupportedTransferProtocol*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSupportedTransferProtocol(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSupportedTransferProtocol %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSupportedTransferProtocol*)p = *(SRMv2__ArrayOfTSupportedTransferProtocol*)q;
}

void SRMv2__TSupportedTransferProtocol::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TSupportedTransferProtocol*)this)->transferProtocol);
	soap_serialize_PointerToSRMv2__ArrayOfTExtraInfo(soap, &((SRMv2__TSupportedTransferProtocol*)this)->attributes);
	/* transient soap skipped */
}

void SRMv2__TSupportedTransferProtocol::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TSupportedTransferProtocol*)this)->transferProtocol);
	((SRMv2__TSupportedTransferProtocol*)this)->attributes = NULL;
	/* transient soap skipped */
}

int SRMv2__TSupportedTransferProtocol::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSupportedTransferProtocol);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSupportedTransferProtocol::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSupportedTransferProtocol(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSupportedTransferProtocol(struct soap *soap, const char *tag, int id, const SRMv2__TSupportedTransferProtocol *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSupportedTransferProtocol), type);
	soap_out_string(soap, "transferProtocol", -1, &(((SRMv2__TSupportedTransferProtocol*)a)->transferProtocol), "");
	soap_out_PointerToSRMv2__ArrayOfTExtraInfo(soap, "attributes", -1, &(((SRMv2__TSupportedTransferProtocol*)a)->attributes), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSupportedTransferProtocol::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSupportedTransferProtocol(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSupportedTransferProtocol * SOAP_FMAC4 soap_get_SRMv2__TSupportedTransferProtocol(struct soap *soap, SRMv2__TSupportedTransferProtocol *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSupportedTransferProtocol(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSupportedTransferProtocol::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSupportedTransferProtocol(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSupportedTransferProtocol * SOAP_FMAC4 soap_in_SRMv2__TSupportedTransferProtocol(struct soap *soap, const char *tag, SRMv2__TSupportedTransferProtocol *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSupportedTransferProtocol *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSupportedTransferProtocol, sizeof(SRMv2__TSupportedTransferProtocol), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSupportedTransferProtocol)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSupportedTransferProtocol *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_transferProtocol1 = 1, soap_flag_attributes1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_transferProtocol1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "transferProtocol", &(((SRMv2__TSupportedTransferProtocol*)a)->transferProtocol), "xsd:string"))
				{	soap_flag_transferProtocol1--;
					continue;
				}
			if (soap_flag_attributes1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTExtraInfo(soap, "attributes", &(((SRMv2__TSupportedTransferProtocol*)a)->attributes), "SRMv2:ArrayOfTExtraInfo"))
				{	soap_flag_attributes1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_transferProtocol1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSupportedTransferProtocol *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSupportedTransferProtocol, 0, sizeof(SRMv2__TSupportedTransferProtocol), 0, soap_copy_SRMv2__TSupportedTransferProtocol);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSupportedTransferProtocol * SOAP_FMAC6 soap_new_SRMv2__TSupportedTransferProtocol(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSupportedTransferProtocol(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSupportedTransferProtocol(struct soap *soap, SRMv2__TSupportedTransferProtocol *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSupportedTransferProtocol * SOAP_FMAC4 soap_instantiate_SRMv2__TSupportedTransferProtocol(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSupportedTransferProtocol(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSupportedTransferProtocol, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSupportedTransferProtocol;
		if (size)
			*size = sizeof(SRMv2__TSupportedTransferProtocol);
		((SRMv2__TSupportedTransferProtocol*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSupportedTransferProtocol[n];
		if (size)
			*size = n * sizeof(SRMv2__TSupportedTransferProtocol);
		for (int i = 0; i < n; i++)
			((SRMv2__TSupportedTransferProtocol*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSupportedTransferProtocol*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSupportedTransferProtocol(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSupportedTransferProtocol %p -> %p\n", q, p));
	*(SRMv2__TSupportedTransferProtocol*)p = *(SRMv2__TSupportedTransferProtocol*)q;
}

void SRMv2__ArrayOfTRequestTokenReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTRequestTokenReturn*)this)->tokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestTokenReturn*)this)->__sizetokenArray; i++)
		{
			soap_serialize_PointerToSRMv2__TRequestTokenReturn(soap, ((SRMv2__ArrayOfTRequestTokenReturn*)this)->tokenArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTRequestTokenReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTRequestTokenReturn*)this)->__sizetokenArray = 0;
	((SRMv2__ArrayOfTRequestTokenReturn*)this)->tokenArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTRequestTokenReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTRequestTokenReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTRequestTokenReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTRequestTokenReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn), type);
	if (((SRMv2__ArrayOfTRequestTokenReturn*)a)->tokenArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestTokenReturn*)a)->__sizetokenArray; i++)
			soap_out_PointerToSRMv2__TRequestTokenReturn(soap, "tokenArray", -1, ((SRMv2__ArrayOfTRequestTokenReturn*)a)->tokenArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTRequestTokenReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTRequestTokenReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestTokenReturn * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, SRMv2__ArrayOfTRequestTokenReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTRequestTokenReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTRequestTokenReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTRequestTokenReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestTokenReturn * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, const char *tag, SRMv2__ArrayOfTRequestTokenReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTRequestTokenReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn, sizeof(SRMv2__ArrayOfTRequestTokenReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTRequestTokenReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_tokenArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_tokenArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TRequestTokenReturn **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTRequestTokenReturn*)a)->__sizetokenArray = 0; !soap_element_begin_in(soap, "tokenArray", 1); ((SRMv2__ArrayOfTRequestTokenReturn*)a)->__sizetokenArray++)
				{	p = (SRMv2__TRequestTokenReturn **)soap_push_block(soap, sizeof(SRMv2__TRequestTokenReturn *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TRequestTokenReturn(soap, "tokenArray", p, "SRMv2:TRequestTokenReturn"))
						break;
					soap_flag_tokenArray1 = 0;
				}
				((SRMv2__ArrayOfTRequestTokenReturn*)a)->tokenArray = (SRMv2__TRequestTokenReturn **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_tokenArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTRequestTokenReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn, 0, sizeof(SRMv2__ArrayOfTRequestTokenReturn), 0, soap_copy_SRMv2__ArrayOfTRequestTokenReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTRequestTokenReturn * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTRequestTokenReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, SRMv2__ArrayOfTRequestTokenReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestTokenReturn * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTRequestTokenReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTRequestTokenReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestTokenReturn;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTRequestTokenReturn);
		((SRMv2__ArrayOfTRequestTokenReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestTokenReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTRequestTokenReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTRequestTokenReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTRequestTokenReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTRequestTokenReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTRequestTokenReturn %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTRequestTokenReturn*)p = *(SRMv2__ArrayOfTRequestTokenReturn*)q;
}

void SRMv2__TRequestTokenReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TRequestTokenReturn*)this)->requestToken);
	soap_serialize_PointerTotime(soap, &((SRMv2__TRequestTokenReturn*)this)->createdAtTime);
	/* transient soap skipped */
}

void SRMv2__TRequestTokenReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TRequestTokenReturn*)this)->requestToken);
	((SRMv2__TRequestTokenReturn*)this)->createdAtTime = NULL;
	/* transient soap skipped */
}

int SRMv2__TRequestTokenReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestTokenReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TRequestTokenReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TRequestTokenReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestTokenReturn(struct soap *soap, const char *tag, int id, const SRMv2__TRequestTokenReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestTokenReturn), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__TRequestTokenReturn*)a)->requestToken), "");
	soap_out_PointerTotime(soap, "createdAtTime", -1, &(((SRMv2__TRequestTokenReturn*)a)->createdAtTime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TRequestTokenReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TRequestTokenReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_get_SRMv2__TRequestTokenReturn(struct soap *soap, SRMv2__TRequestTokenReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestTokenReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TRequestTokenReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TRequestTokenReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_in_SRMv2__TRequestTokenReturn(struct soap *soap, const char *tag, SRMv2__TRequestTokenReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TRequestTokenReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestTokenReturn, sizeof(SRMv2__TRequestTokenReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TRequestTokenReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TRequestTokenReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_createdAtTime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__TRequestTokenReturn*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_createdAtTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "createdAtTime", &(((SRMv2__TRequestTokenReturn*)a)->createdAtTime), "xsd:dateTime"))
				{	soap_flag_createdAtTime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TRequestTokenReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestTokenReturn, 0, sizeof(SRMv2__TRequestTokenReturn), 0, soap_copy_SRMv2__TRequestTokenReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TRequestTokenReturn * SOAP_FMAC6 soap_new_SRMv2__TRequestTokenReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TRequestTokenReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TRequestTokenReturn(struct soap *soap, SRMv2__TRequestTokenReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TRequestTokenReturn * SOAP_FMAC4 soap_instantiate_SRMv2__TRequestTokenReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TRequestTokenReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TRequestTokenReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TRequestTokenReturn;
		if (size)
			*size = sizeof(SRMv2__TRequestTokenReturn);
		((SRMv2__TRequestTokenReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TRequestTokenReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__TRequestTokenReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__TRequestTokenReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TRequestTokenReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TRequestTokenReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TRequestTokenReturn %p -> %p\n", q, p));
	*(SRMv2__TRequestTokenReturn*)p = *(SRMv2__TRequestTokenReturn*)q;
}

void SRMv2__ArrayOfTPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTPermissionReturn*)this)->permissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPermissionReturn*)this)->__sizepermissionArray; i++)
		{
			soap_serialize_PointerToSRMv2__TPermissionReturn(soap, ((SRMv2__ArrayOfTPermissionReturn*)this)->permissionArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTPermissionReturn*)this)->__sizepermissionArray = 0;
	((SRMv2__ArrayOfTPermissionReturn*)this)->permissionArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn), type);
	if (((SRMv2__ArrayOfTPermissionReturn*)a)->permissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPermissionReturn*)a)->__sizepermissionArray; i++)
			soap_out_PointerToSRMv2__TPermissionReturn(soap, "permissionArray", -1, ((SRMv2__ArrayOfTPermissionReturn*)a)->permissionArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, SRMv2__ArrayOfTPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, const char *tag, SRMv2__ArrayOfTPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn, sizeof(SRMv2__ArrayOfTPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_permissionArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_permissionArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TPermissionReturn **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTPermissionReturn*)a)->__sizepermissionArray = 0; !soap_element_begin_in(soap, "permissionArray", 1); ((SRMv2__ArrayOfTPermissionReturn*)a)->__sizepermissionArray++)
				{	p = (SRMv2__TPermissionReturn **)soap_push_block(soap, sizeof(SRMv2__TPermissionReturn *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TPermissionReturn(soap, "permissionArray", p, "SRMv2:TPermissionReturn"))
						break;
					soap_flag_permissionArray1 = 0;
				}
				((SRMv2__ArrayOfTPermissionReturn*)a)->permissionArray = (SRMv2__TPermissionReturn **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_permissionArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn, 0, sizeof(SRMv2__ArrayOfTPermissionReturn), 0, soap_copy_SRMv2__ArrayOfTPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, SRMv2__ArrayOfTPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTPermissionReturn);
		((SRMv2__ArrayOfTPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTPermissionReturn*)p = *(SRMv2__ArrayOfTPermissionReturn*)q;
}

void SRMv2__TPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TPermissionReturn*)this)->surl);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TPermissionReturn*)this)->status);
	soap_serialize_string(soap, &((SRMv2__TPermissionReturn*)this)->owner);
	soap_serialize_PointerToSRMv2__TPermissionMode(soap, &((SRMv2__TPermissionReturn*)this)->ownerPermission);
	soap_serialize_PointerToSRMv2__ArrayOfTUserPermission(soap, &((SRMv2__TPermissionReturn*)this)->arrayOfUserPermissions);
	soap_serialize_PointerToSRMv2__ArrayOfTGroupPermission(soap, &((SRMv2__TPermissionReturn*)this)->arrayOfGroupPermissions);
	soap_serialize_PointerToSRMv2__TPermissionMode(soap, &((SRMv2__TPermissionReturn*)this)->otherPermission);
	/* transient soap skipped */
}

void SRMv2__TPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((SRMv2__TPermissionReturn*)this)->surl);
	((SRMv2__TPermissionReturn*)this)->status = NULL;
	soap_default_string(soap, &((SRMv2__TPermissionReturn*)this)->owner);
	((SRMv2__TPermissionReturn*)this)->ownerPermission = NULL;
	((SRMv2__TPermissionReturn*)this)->arrayOfUserPermissions = NULL;
	((SRMv2__TPermissionReturn*)this)->arrayOfGroupPermissions = NULL;
	((SRMv2__TPermissionReturn*)this)->otherPermission = NULL;
	/* transient soap skipped */
}

int SRMv2__TPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__TPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TPermissionReturn), type);
	soap_out_xsd__anyURI(soap, "surl", -1, &(((SRMv2__TPermissionReturn*)a)->surl), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TPermissionReturn*)a)->status), "");
	soap_out_string(soap, "owner", -1, &(((SRMv2__TPermissionReturn*)a)->owner), "");
	soap_out_PointerToSRMv2__TPermissionMode(soap, "ownerPermission", -1, &(((SRMv2__TPermissionReturn*)a)->ownerPermission), "");
	soap_out_PointerToSRMv2__ArrayOfTUserPermission(soap, "arrayOfUserPermissions", -1, &(((SRMv2__TPermissionReturn*)a)->arrayOfUserPermissions), "");
	soap_out_PointerToSRMv2__ArrayOfTGroupPermission(soap, "arrayOfGroupPermissions", -1, &(((SRMv2__TPermissionReturn*)a)->arrayOfGroupPermissions), "");
	soap_out_PointerToSRMv2__TPermissionMode(soap, "otherPermission", -1, &(((SRMv2__TPermissionReturn*)a)->otherPermission), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__TPermissionReturn(struct soap *soap, SRMv2__TPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__TPermissionReturn(struct soap *soap, const char *tag, SRMv2__TPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TPermissionReturn, sizeof(SRMv2__TPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surl1 = 1, soap_flag_status1 = 1, soap_flag_owner1 = 1, soap_flag_ownerPermission1 = 1, soap_flag_arrayOfUserPermissions1 = 1, soap_flag_arrayOfGroupPermissions1 = 1, soap_flag_otherPermission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "surl", &(((SRMv2__TPermissionReturn*)a)->surl), "xsd:anyURI"))
				{	soap_flag_surl1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TPermissionReturn*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_owner1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "owner", &(((SRMv2__TPermissionReturn*)a)->owner), "xsd:string"))
				{	soap_flag_owner1--;
					continue;
				}
			if (soap_flag_ownerPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionMode(soap, "ownerPermission", &(((SRMv2__TPermissionReturn*)a)->ownerPermission), "SRMv2:TPermissionMode"))
				{	soap_flag_ownerPermission1--;
					continue;
				}
			if (soap_flag_arrayOfUserPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTUserPermission(soap, "arrayOfUserPermissions", &(((SRMv2__TPermissionReturn*)a)->arrayOfUserPermissions), "SRMv2:ArrayOfTUserPermission"))
				{	soap_flag_arrayOfUserPermissions1--;
					continue;
				}
			if (soap_flag_arrayOfGroupPermissions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__ArrayOfTGroupPermission(soap, "arrayOfGroupPermissions", &(((SRMv2__TPermissionReturn*)a)->arrayOfGroupPermissions), "SRMv2:ArrayOfTGroupPermission"))
				{	soap_flag_arrayOfGroupPermissions1--;
					continue;
				}
			if (soap_flag_otherPermission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionMode(soap, "otherPermission", &(((SRMv2__TPermissionReturn*)a)->otherPermission), "SRMv2:TPermissionMode"))
				{	soap_flag_otherPermission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_surl1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TPermissionReturn, 0, sizeof(SRMv2__TPermissionReturn), 0, soap_copy_SRMv2__TPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__TPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TPermissionReturn(struct soap *soap, SRMv2__TPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__TPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__TPermissionReturn);
		((SRMv2__TPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__TPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__TPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__TPermissionReturn*)p = *(SRMv2__TPermissionReturn*)q;
}

void SRMv2__ArrayOfTSURLPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLPermissionReturn*)this)->__sizesurlPermissionArray; i++)
		{
			soap_serialize_PointerToSRMv2__TSURLPermissionReturn(soap, ((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTSURLPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTSURLPermissionReturn*)this)->__sizesurlPermissionArray = 0;
	((SRMv2__ArrayOfTSURLPermissionReturn*)this)->surlPermissionArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTSURLPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTSURLPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTSURLPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn), type);
	if (((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray; i++)
			soap_out_PointerToSRMv2__TSURLPermissionReturn(soap, "surlPermissionArray", -1, ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTSURLPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTSURLPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, SRMv2__ArrayOfTSURLPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTSURLPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTSURLPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, const char *tag, SRMv2__ArrayOfTSURLPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTSURLPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, sizeof(SRMv2__ArrayOfTSURLPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTSURLPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surlPermissionArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surlPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TSURLPermissionReturn **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray = 0; !soap_element_begin_in(soap, "surlPermissionArray", 1); ((SRMv2__ArrayOfTSURLPermissionReturn*)a)->__sizesurlPermissionArray++)
				{	p = (SRMv2__TSURLPermissionReturn **)soap_push_block(soap, sizeof(SRMv2__TSURLPermissionReturn *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TSURLPermissionReturn(soap, "surlPermissionArray", p, "SRMv2:TSURLPermissionReturn"))
						break;
					soap_flag_surlPermissionArray1 = 0;
				}
				((SRMv2__ArrayOfTSURLPermissionReturn*)a)->surlPermissionArray = (SRMv2__TSURLPermissionReturn **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_surlPermissionArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTSURLPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, 0, sizeof(SRMv2__ArrayOfTSURLPermissionReturn), 0, soap_copy_SRMv2__ArrayOfTSURLPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, SRMv2__ArrayOfTSURLPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTSURLPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTSURLPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTSURLPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTSURLPermissionReturn);
		((SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTSURLPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTSURLPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTSURLPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTSURLPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTSURLPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTSURLPermissionReturn*)p = *(SRMv2__ArrayOfTSURLPermissionReturn*)q;
}

void SRMv2__TSURLPermissionReturn::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TSURLPermissionReturn*)this)->surl);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TSURLPermissionReturn*)this)->status);
	soap_serialize_PointerToSRMv2__TPermissionMode(soap, &((SRMv2__TSURLPermissionReturn*)this)->permission);
	/* transient soap skipped */
}

void SRMv2__TSURLPermissionReturn::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((SRMv2__TSURLPermissionReturn*)this)->surl);
	((SRMv2__TSURLPermissionReturn*)this)->status = NULL;
	((SRMv2__TSURLPermissionReturn*)this)->permission = NULL;
	/* transient soap skipped */
}

int SRMv2__TSURLPermissionReturn::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TSURLPermissionReturn);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TSURLPermissionReturn::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TSURLPermissionReturn(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TSURLPermissionReturn(struct soap *soap, const char *tag, int id, const SRMv2__TSURLPermissionReturn *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TSURLPermissionReturn), type);
	soap_out_xsd__anyURI(soap, "surl", -1, &(((SRMv2__TSURLPermissionReturn*)a)->surl), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TSURLPermissionReturn*)a)->status), "");
	soap_out_PointerToSRMv2__TPermissionMode(soap, "permission", -1, &(((SRMv2__TSURLPermissionReturn*)a)->permission), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TSURLPermissionReturn::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TSURLPermissionReturn(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_get_SRMv2__TSURLPermissionReturn(struct soap *soap, SRMv2__TSURLPermissionReturn *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TSURLPermissionReturn(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TSURLPermissionReturn::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TSURLPermissionReturn(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_in_SRMv2__TSURLPermissionReturn(struct soap *soap, const char *tag, SRMv2__TSURLPermissionReturn *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TSURLPermissionReturn *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TSURLPermissionReturn, sizeof(SRMv2__TSURLPermissionReturn), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TSURLPermissionReturn)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TSURLPermissionReturn *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_surl1 = 1, soap_flag_status1 = 1, soap_flag_permission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_surl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "surl", &(((SRMv2__TSURLPermissionReturn*)a)->surl), "xsd:anyURI"))
				{	soap_flag_surl1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TSURLPermissionReturn*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TPermissionMode(soap, "permission", &(((SRMv2__TSURLPermissionReturn*)a)->permission), "SRMv2:TPermissionMode"))
				{	soap_flag_permission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_surl1 > 0 || soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TSURLPermissionReturn *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TSURLPermissionReturn, 0, sizeof(SRMv2__TSURLPermissionReturn), 0, soap_copy_SRMv2__TSURLPermissionReturn);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TSURLPermissionReturn * SOAP_FMAC6 soap_new_SRMv2__TSURLPermissionReturn(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TSURLPermissionReturn(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TSURLPermissionReturn(struct soap *soap, SRMv2__TSURLPermissionReturn *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TSURLPermissionReturn * SOAP_FMAC4 soap_instantiate_SRMv2__TSURLPermissionReturn(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TSURLPermissionReturn(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TSURLPermissionReturn, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TSURLPermissionReturn;
		if (size)
			*size = sizeof(SRMv2__TSURLPermissionReturn);
		((SRMv2__TSURLPermissionReturn*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TSURLPermissionReturn[n];
		if (size)
			*size = n * sizeof(SRMv2__TSURLPermissionReturn);
		for (int i = 0; i < n; i++)
			((SRMv2__TSURLPermissionReturn*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TSURLPermissionReturn*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TSURLPermissionReturn(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TSURLPermissionReturn %p -> %p\n", q, p));
	*(SRMv2__TSURLPermissionReturn*)p = *(SRMv2__TSURLPermissionReturn*)q;
}

void SRMv2__ArrayOfTRequestSummary::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestSummary*)this)->__sizesummaryArray; i++)
		{
			soap_serialize_PointerToSRMv2__TRequestSummary(soap, ((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTRequestSummary::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTRequestSummary*)this)->__sizesummaryArray = 0;
	((SRMv2__ArrayOfTRequestSummary*)this)->summaryArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTRequestSummary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTRequestSummary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTRequestSummary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTRequestSummary(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTRequestSummary *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary), type);
	if (((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray; i++)
			soap_out_PointerToSRMv2__TRequestSummary(soap, "summaryArray", -1, ((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTRequestSummary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTRequestSummary(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTRequestSummary(struct soap *soap, SRMv2__ArrayOfTRequestSummary *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTRequestSummary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTRequestSummary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTRequestSummary(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTRequestSummary(struct soap *soap, const char *tag, SRMv2__ArrayOfTRequestSummary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTRequestSummary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, sizeof(SRMv2__ArrayOfTRequestSummary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTRequestSummary)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTRequestSummary *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_summaryArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_summaryArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TRequestSummary **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray = 0; !soap_element_begin_in(soap, "summaryArray", 1); ((SRMv2__ArrayOfTRequestSummary*)a)->__sizesummaryArray++)
				{	p = (SRMv2__TRequestSummary **)soap_push_block(soap, sizeof(SRMv2__TRequestSummary *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TRequestSummary(soap, "summaryArray", p, "SRMv2:TRequestSummary"))
						break;
					soap_flag_summaryArray1 = 0;
				}
				((SRMv2__ArrayOfTRequestSummary*)a)->summaryArray = (SRMv2__TRequestSummary **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_summaryArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTRequestSummary *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, 0, sizeof(SRMv2__ArrayOfTRequestSummary), 0, soap_copy_SRMv2__ArrayOfTRequestSummary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTRequestSummary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTRequestSummary(struct soap *soap, SRMv2__ArrayOfTRequestSummary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTRequestSummary * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTRequestSummary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTRequestSummary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestSummary;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTRequestSummary);
		((SRMv2__ArrayOfTRequestSummary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTRequestSummary[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTRequestSummary);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTRequestSummary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTRequestSummary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTRequestSummary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTRequestSummary %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTRequestSummary*)p = *(SRMv2__ArrayOfTRequestSummary*)q;
}

void SRMv2__TRequestSummary::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &((SRMv2__TRequestSummary*)this)->requestToken);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TRequestSummary*)this)->status);
	soap_serialize_PointerToSRMv2__TRequestType(soap, &((SRMv2__TRequestSummary*)this)->requestType);
	soap_serialize_PointerToint(soap, &((SRMv2__TRequestSummary*)this)->totalNumFilesInRequest);
	soap_serialize_PointerToint(soap, &((SRMv2__TRequestSummary*)this)->numOfCompletedFiles);
	soap_serialize_PointerToint(soap, &((SRMv2__TRequestSummary*)this)->numOfWaitingFiles);
	soap_serialize_PointerToint(soap, &((SRMv2__TRequestSummary*)this)->numOfFailedFiles);
	/* transient soap skipped */
}

void SRMv2__TRequestSummary::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &((SRMv2__TRequestSummary*)this)->requestToken);
	((SRMv2__TRequestSummary*)this)->status = NULL;
	((SRMv2__TRequestSummary*)this)->requestType = NULL;
	((SRMv2__TRequestSummary*)this)->totalNumFilesInRequest = NULL;
	((SRMv2__TRequestSummary*)this)->numOfCompletedFiles = NULL;
	((SRMv2__TRequestSummary*)this)->numOfWaitingFiles = NULL;
	((SRMv2__TRequestSummary*)this)->numOfFailedFiles = NULL;
	/* transient soap skipped */
}

int SRMv2__TRequestSummary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TRequestSummary);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TRequestSummary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TRequestSummary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TRequestSummary(struct soap *soap, const char *tag, int id, const SRMv2__TRequestSummary *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TRequestSummary), type);
	soap_out_string(soap, "requestToken", -1, &(((SRMv2__TRequestSummary*)a)->requestToken), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TRequestSummary*)a)->status), "");
	soap_out_PointerToSRMv2__TRequestType(soap, "requestType", -1, &(((SRMv2__TRequestSummary*)a)->requestType), "");
	soap_out_PointerToint(soap, "totalNumFilesInRequest", -1, &(((SRMv2__TRequestSummary*)a)->totalNumFilesInRequest), "");
	soap_out_PointerToint(soap, "numOfCompletedFiles", -1, &(((SRMv2__TRequestSummary*)a)->numOfCompletedFiles), "");
	soap_out_PointerToint(soap, "numOfWaitingFiles", -1, &(((SRMv2__TRequestSummary*)a)->numOfWaitingFiles), "");
	soap_out_PointerToint(soap, "numOfFailedFiles", -1, &(((SRMv2__TRequestSummary*)a)->numOfFailedFiles), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TRequestSummary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TRequestSummary(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_get_SRMv2__TRequestSummary(struct soap *soap, SRMv2__TRequestSummary *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TRequestSummary(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TRequestSummary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TRequestSummary(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_in_SRMv2__TRequestSummary(struct soap *soap, const char *tag, SRMv2__TRequestSummary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TRequestSummary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TRequestSummary, sizeof(SRMv2__TRequestSummary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TRequestSummary)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TRequestSummary *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_requestToken1 = 1, soap_flag_status1 = 1, soap_flag_requestType1 = 1, soap_flag_totalNumFilesInRequest1 = 1, soap_flag_numOfCompletedFiles1 = 1, soap_flag_numOfWaitingFiles1 = 1, soap_flag_numOfFailedFiles1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_requestToken1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "requestToken", &(((SRMv2__TRequestSummary*)a)->requestToken), "xsd:string"))
				{	soap_flag_requestToken1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TRequestSummary*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_requestType1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TRequestType(soap, "requestType", &(((SRMv2__TRequestSummary*)a)->requestType), "SRMv2:TRequestType"))
				{	soap_flag_requestType1--;
					continue;
				}
			if (soap_flag_totalNumFilesInRequest1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "totalNumFilesInRequest", &(((SRMv2__TRequestSummary*)a)->totalNumFilesInRequest), "xsd:int"))
				{	soap_flag_totalNumFilesInRequest1--;
					continue;
				}
			if (soap_flag_numOfCompletedFiles1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "numOfCompletedFiles", &(((SRMv2__TRequestSummary*)a)->numOfCompletedFiles), "xsd:int"))
				{	soap_flag_numOfCompletedFiles1--;
					continue;
				}
			if (soap_flag_numOfWaitingFiles1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "numOfWaitingFiles", &(((SRMv2__TRequestSummary*)a)->numOfWaitingFiles), "xsd:int"))
				{	soap_flag_numOfWaitingFiles1--;
					continue;
				}
			if (soap_flag_numOfFailedFiles1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "numOfFailedFiles", &(((SRMv2__TRequestSummary*)a)->numOfFailedFiles), "xsd:int"))
				{	soap_flag_numOfFailedFiles1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_requestToken1 > 0 || soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TRequestSummary *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TRequestSummary, 0, sizeof(SRMv2__TRequestSummary), 0, soap_copy_SRMv2__TRequestSummary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TRequestSummary * SOAP_FMAC6 soap_new_SRMv2__TRequestSummary(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TRequestSummary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TRequestSummary(struct soap *soap, SRMv2__TRequestSummary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TRequestSummary * SOAP_FMAC4 soap_instantiate_SRMv2__TRequestSummary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TRequestSummary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TRequestSummary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TRequestSummary;
		if (size)
			*size = sizeof(SRMv2__TRequestSummary);
		((SRMv2__TRequestSummary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TRequestSummary[n];
		if (size)
			*size = n * sizeof(SRMv2__TRequestSummary);
		for (int i = 0; i < n; i++)
			((SRMv2__TRequestSummary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TRequestSummary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TRequestSummary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TRequestSummary %p -> %p\n", q, p));
	*(SRMv2__TRequestSummary*)p = *(SRMv2__TRequestSummary*)q;
}

void SRMv2__ArrayOfTCopyRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->statusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->__sizestatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TCopyRequestFileStatus(soap, ((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->statusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTCopyRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->__sizestatusArray = 0;
	((SRMv2__ArrayOfTCopyRequestFileStatus*)this)->statusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTCopyRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTCopyRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTCopyRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus), type);
	if (((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->statusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizestatusArray; i++)
			soap_out_PointerToSRMv2__TCopyRequestFileStatus(soap, "statusArray", -1, ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->statusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTCopyRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTCopyRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTCopyRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTCopyRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTCopyRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTCopyRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, sizeof(SRMv2__ArrayOfTCopyRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTCopyRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_statusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_statusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TCopyRequestFileStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizestatusArray = 0; !soap_element_begin_in(soap, "statusArray", 1); ((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->__sizestatusArray++)
				{	p = (SRMv2__TCopyRequestFileStatus **)soap_push_block(soap, sizeof(SRMv2__TCopyRequestFileStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TCopyRequestFileStatus(soap, "statusArray", p, "SRMv2:TCopyRequestFileStatus"))
						break;
					soap_flag_statusArray1 = 0;
				}
				((SRMv2__ArrayOfTCopyRequestFileStatus*)a)->statusArray = (SRMv2__TCopyRequestFileStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_statusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__ArrayOfTCopyRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, 0, sizeof(SRMv2__ArrayOfTCopyRequestFileStatus), 0, soap_copy_SRMv2__ArrayOfTCopyRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTCopyRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__ArrayOfTCopyRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__ArrayOfTCopyRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__ArrayOfTCopyRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__ArrayOfTCopyRequestFileStatus);
		((SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__ArrayOfTCopyRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__ArrayOfTCopyRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__ArrayOfTCopyRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__ArrayOfTCopyRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__ArrayOfTCopyRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__ArrayOfTCopyRequestFileStatus*)p = *(SRMv2__ArrayOfTCopyRequestFileStatus*)q;
}

void SRMv2__TCopyRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TCopyRequestFileStatus*)this)->sourceSURL);
	soap_serialize_xsd__anyURI(soap, &((SRMv2__TCopyRequestFileStatus*)this)->targetSURL);
	soap_serialize_PointerToSRMv2__TReturnStatus(soap, &((SRMv2__TCopyRequestFileStatus*)this)->status);
	soap_serialize_PointerTounsignedLONG64(soap, &((SRMv2__TCopyRequestFileStatus*)this)->fileSize);
	soap_serialize_PointerToint(soap, &((SRMv2__TCopyRequestFileStatus*)this)->estimatedWaitTime);
	soap_serialize_PointerToint(soap, &((SRMv2__TCopyRequestFileStatus*)this)->remainingFileLifetime);
	/* transient soap skipped */
}

void SRMv2__TCopyRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_xsd__anyURI(soap, &((SRMv2__TCopyRequestFileStatus*)this)->sourceSURL);
	soap_default_xsd__anyURI(soap, &((SRMv2__TCopyRequestFileStatus*)this)->targetSURL);
	((SRMv2__TCopyRequestFileStatus*)this)->status = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->fileSize = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->estimatedWaitTime = NULL;
	((SRMv2__TCopyRequestFileStatus*)this)->remainingFileLifetime = NULL;
	/* transient soap skipped */
}

int SRMv2__TCopyRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__TCopyRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__TCopyRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__TCopyRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__TCopyRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__TCopyRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__TCopyRequestFileStatus), type);
	soap_out_xsd__anyURI(soap, "sourceSURL", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->sourceSURL), "");
	soap_out_xsd__anyURI(soap, "targetSURL", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->targetSURL), "");
	soap_out_PointerToSRMv2__TReturnStatus(soap, "status", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->status), "");
	soap_out_PointerTounsignedLONG64(soap, "fileSize", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->fileSize), "");
	soap_out_PointerToint(soap, "estimatedWaitTime", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedWaitTime), "");
	soap_out_PointerToint(soap, "remainingFileLifetime", -1, &(((SRMv2__TCopyRequestFileStatus*)a)->remainingFileLifetime), "");
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__TCopyRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__TCopyRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__TCopyRequestFileStatus(struct soap *soap, SRMv2__TCopyRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__TCopyRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__TCopyRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__TCopyRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__TCopyRequestFileStatus(struct soap *soap, const char *tag, SRMv2__TCopyRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__TCopyRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, sizeof(SRMv2__TCopyRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__TCopyRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__TCopyRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_sourceSURL1 = 1, soap_flag_targetSURL1 = 1, soap_flag_status1 = 1, soap_flag_fileSize1 = 1, soap_flag_estimatedWaitTime1 = 1, soap_flag_remainingFileLifetime1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_sourceSURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "sourceSURL", &(((SRMv2__TCopyRequestFileStatus*)a)->sourceSURL), "xsd:anyURI"))
				{	soap_flag_sourceSURL1--;
					continue;
				}
			if (soap_flag_targetSURL1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__anyURI(soap, "targetSURL", &(((SRMv2__TCopyRequestFileStatus*)a)->targetSURL), "xsd:anyURI"))
				{	soap_flag_targetSURL1--;
					continue;
				}
			if (soap_flag_status1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSRMv2__TReturnStatus(soap, "status", &(((SRMv2__TCopyRequestFileStatus*)a)->status), "SRMv2:TReturnStatus"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_fileSize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTounsignedLONG64(soap, "fileSize", &(((SRMv2__TCopyRequestFileStatus*)a)->fileSize), "xsd:unsignedLong"))
				{	soap_flag_fileSize1--;
					continue;
				}
			if (soap_flag_estimatedWaitTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "estimatedWaitTime", &(((SRMv2__TCopyRequestFileStatus*)a)->estimatedWaitTime), "xsd:int"))
				{	soap_flag_estimatedWaitTime1--;
					continue;
				}
			if (soap_flag_remainingFileLifetime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToint(soap, "remainingFileLifetime", &(((SRMv2__TCopyRequestFileStatus*)a)->remainingFileLifetime), "xsd:int"))
				{	soap_flag_remainingFileLifetime1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_sourceSURL1 > 0 || soap_flag_targetSURL1 > 0 || soap_flag_status1 > 0))
		{	soap->error = SOAP_OCCURS;
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (SRMv2__TCopyRequestFileStatus *)soap_id_forward(soap, soap->href, (void**)a, 0, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, 0, sizeof(SRMv2__TCopyRequestFileStatus), 0, soap_copy_SRMv2__TCopyRequestFileStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 SRMv2__TCopyRequestFileStatus * SOAP_FMAC6 soap_new_SRMv2__TCopyRequestFileStatus(struct soap *soap, int n)
{	return soap_instantiate_SRMv2__TCopyRequestFileStatus(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SRMv2__TCopyRequestFileStatus(struct soap *soap, SRMv2__TCopyRequestFileStatus *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 SRMv2__TCopyRequestFileStatus * SOAP_FMAC4 soap_instantiate_SRMv2__TCopyRequestFileStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SRMv2__TCopyRequestFileStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SRMv2__TCopyRequestFileStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new SRMv2__TCopyRequestFileStatus;
		if (size)
			*size = sizeof(SRMv2__TCopyRequestFileStatus);
		((SRMv2__TCopyRequestFileStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new SRMv2__TCopyRequestFileStatus[n];
		if (size)
			*size = n * sizeof(SRMv2__TCopyRequestFileStatus);
		for (int i = 0; i < n; i++)
			((SRMv2__TCopyRequestFileStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (SRMv2__TCopyRequestFileStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SRMv2__TCopyRequestFileStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying SRMv2__TCopyRequestFileStatus %p -> %p\n", q, p));
	*(SRMv2__TCopyRequestFileStatus*)p = *(SRMv2__TCopyRequestFileStatus*)q;
}

void SRMv2__ArrayOfTPutRequestFileStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	if (((SRMv2__ArrayOfTPutRequestFileStatus*)this)->statusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutRequestFileStatus*)this)->__sizestatusArray; i++)
		{
			soap_serialize_PointerToSRMv2__TPutRequestFileStatus(soap, ((SRMv2__ArrayOfTPutRequestFileStatus*)this)->statusArray + i);
		}
	}
	/* transient soap skipped */
}

void SRMv2__ArrayOfTPutRequestFileStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	((SRMv2__ArrayOfTPutRequestFileStatus*)this)->__sizestatusArray = 0;
	((SRMv2__ArrayOfTPutRequestFileStatus*)this)->statusArray = NULL;
	/* transient soap skipped */
}

int SRMv2__ArrayOfTPutRequestFileStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus);
	if (this->soap_out(soap, tag, id, type))
		return soap->error;
	return soap_putindependent(soap);
}

int SRMv2__ArrayOfTPutRequestFileStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, const char *tag, int id, const SRMv2__ArrayOfTPutRequestFileStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus), type);
	if (((SRMv2__ArrayOfTPutRequestFileStatus*)a)->statusArray)
	{	int i;
		for (i = 0; i < ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizestatusArray; i++)
			soap_out_PointerToSRMv2__TPutRequestFileStatus(soap, "statusArray", -1, ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->statusArray + i, "");
	}
	/* transient soap skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *SRMv2__ArrayOfTPutRequestFileStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_SRMv2__ArrayOfTPutRequestFileStatus(soap, this, tag, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC4 soap_get_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, SRMv2__ArrayOfTPutRequestFileStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *SRMv2__ArrayOfTPutRequestFileStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_SRMv2__ArrayOfTPutRequestFileStatus(soap, tag, this, type);
}

SOAP_FMAC3 SRMv2__ArrayOfTPutRequestFileStatus * SOAP_FMAC4 soap_in_SRMv2__ArrayOfTPutRequestFileStatus(struct soap *soap, const char *tag, SRMv2__ArrayOfTPutRequestFileStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0))
		return NULL;
	a = (SRMv2__ArrayOfTPutRequestFileStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus, sizeof(SRMv2__ArrayOfTPutRequestFileStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_SRMv2__ArrayOfTPutRequestFileStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (SRMv2__ArrayOfTPutRequestFileStatus *)a->soap_in(soap, tag, type);
		}
	}
	short soap_flag_statusArray1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_statusArray1 && soap->error == SOAP_TAG_MISMATCH)
			{	SRMv2__TPutRequestFileStatus **p;
				soap_new_block(soap);
				for (((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizestatusArray = 0; !soap_element_begin_in(soap, "statusArray", 1); ((SRMv2__ArrayOfTPutRequestFileStatus*)a)->__sizestatusArray++)
				{	p = (SRMv2__TPutRequestFileStatus **)soap_push_block(soap, sizeof(SRMv2__TPutRequestFileStatus *));
					if (!p)
						return NULL;
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_PointerToSRMv2__TPutRequestFileStatus(soap, "statusArray", p, "SRMv2:TPutRequestFileStatus"))
						break;
					soap_flag_statusArray1 = 0;
				}
				((SRMv2__ArrayOfTPutRequestFileStatus*)a)->statusArray = (SRMv2__TPutRequestFileStatus **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_statusArray1 && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	