#include "../../std.h"

#include <string>

#include <arc/stringconv.h>
#include "../server/httpsd.h"
#include "../../misc/log_time.h"
//#include "../../misc/escaped.h"
//#include "../../misc/time_utils.h"

// one more hack
#undef SOAP_FMAC3
#define WITH_NOGLOBAL
#define SOAP_FMAC3 static
#include "srm1_soap.nsmap"
#include "srm1_soapC.cpp"
#include "srm1_soapClient.cpp"
#include "srm1_soapServer.cpp"

#include "srm_url.h"
#include "srm_request.h"
#include "srm_file.h"
#include "srm_file_metadata.h"
#include "srm_file_status.h"

#include "srm_proxy.h"


// ------------------------------------------------------
// Helper methods and functions
// ------------------------------------------------------

static ArrayOfFileMetaData* make_ArrayOfFileMetaData(struct soap* soap,const std::list<SRMFile> &files) {
  ArrayOfFileMetaData* r = soap_new_ArrayOfFileMetaData(soap,-1);
  if(r==NULL) return NULL;
  r->soap_default(soap);
  r->__size=0;
  r->__ptr=(SRMv1Type__FileMetaData**)soap_malloc(soap,sizeof(SRMv1Type__FileMetaData*)*files.size());
  if(r->__ptr == NULL) return NULL;
  for(std::list<SRMFile>::const_iterator f = files.begin();f!=files.end();++f) {
    const SRMFileMetaData* m = f->MetaData();
    r->__ptr[r->__size]=NULL;
    if(m) {
std::cerr<<"make_ArrayOfFileMetaData: have metadata"<<std::endl;
      r->__ptr[r->__size]=m->V1(soap);
    };
    if(r->__ptr[r->__size] == NULL) {
std::cerr<<"make_ArrayOfFileMetaData: no metadata"<<std::endl;
      r->__ptr[r->__size]=soap_new_SRMv1Type__FileMetaData(soap,-1);
      if(r->__ptr[r->__size] == NULL) continue;
      r->__ptr[r->__size]->soap_default(soap);
    };
    r->__size++;
  };
std::cerr<<"make_ArrayOfFileMetaData: files: "<<r->__size<<std::endl;
  return r;
}

static ArrayOfRequestFileStatus* make_ArrayOfRequestFileStatus(struct soap* soap,const std::list<SRMFile> &files) {
  ArrayOfRequestFileStatus* r = soap_new_ArrayOfRequestFileStatus(soap,-1);
  if(r == NULL) return NULL;
  r->soap_default(soap);
  r->__size=0;
  r->__ptr=(SRMv1Type__RequestFileStatus**)soap_malloc(soap,sizeof(SRMv1Type__RequestFileStatus*)*files.size());
  if(r->__ptr == NULL) return NULL;
  for(std::list<SRMFile>::const_iterator f = files.begin();f!=files.end();++f) {
    const SRMFileMetaData* m = f->MetaData();
    const SRMFileStatus* s = f->Status();
    r->__ptr[r->__size]=NULL;
    if(s) {
      r->__ptr[r->__size]=s->V1(soap,r->__size,m);
    };
    if(r->__ptr[r->__size] == NULL) {
      r->__ptr[r->__size]=soap_new_SRMv1Type__RequestFileStatus(soap,-1);
      if(r->__ptr[r->__size] == NULL) continue;
      r->__ptr[r->__size]->soap_default(soap);
    };
    r->__size++;
  };
  return r;
}

static int enumerate_state(const char* state) {
  if(strcasecmp(state,"done") == 0) return 3;
  if(strcasecmp(state,"active") == 0) return 2;
  if(strcasecmp(state,"pending") == 0) return 1;
  if(strcasecmp(state,"failed") == 0) return 0;
  return -1;
}

static int compare_states(const char* state1,const char* state2) {
  int st1 = enumerate_state(state1);
  int st2 = enumerate_state(state2);
  return (st1-st2);
}

static SRMv1Type__RequestStatus* make_SRMv1Type__RequestStatus(struct soap* soap,const SRMRequest req) {
  SRMv1Type__RequestStatus* req_stat = soap_new_SRMv1Type__RequestStatus(soap,-1);
  if(req_stat==NULL) return NULL;
  req_stat->soap_default(soap);
  req_stat->requestId=req->GetID().empty()?0:stringto<int>(req->GetID());
  req_stat->type=soap_strdup(soap,req->GetCommand().c_str());
  const std::list<SRMRemoteRequest>& reqs = req->GetRequests();
  const std::list<SRMFile>& files = req->GetFiles();
  std::string state;    // take worst
  bool have_failed_state = false;
  time_t submitTime = (time_t)(-1); // take earliest
  time_t startTime = (time_t)(-1);  // take earliest
  time_t finishTime = (time_t)(-1); // take latest
  int estTimeToStart = -1; // take longest
  std::string errorMessage; // catenate all
  int retryDeltaTime = -1; // take shortest
  for(std::list<SRMRemoteRequest>::const_iterator r = reqs.begin();
                                                     r!=reqs.end();++r) {
    const SRMRequestStatus* status = r->GetStatus();
    if(status == NULL) continue; // Should it be treated as failed?
    if(!(status->state.empty())) {
      if(compare_states(status->state.c_str(),"Failed") == 0) {
        have_failed_state=true;
      } else {
        if((state.empty()) || 
           (compare_states(state.c_str(),status->state.c_str()) > 0))
                                     state=status->state;
      };
    };
    if(status->submitTime!=(time_t)(-1))
      if((submitTime==(time_t)(-1)) || 
         (((int)(submitTime - status->submitTime)) < 0))
                                     submitTime=status->submitTime;
    if(status->startTime!=(time_t)(-1))
      if((startTime==(time_t)(-1)) || 
         (((int)(startTime - status->startTime)) < 0))
                                     startTime=status->startTime;
    if(status->finishTime!=(time_t)(-1))
      if((finishTime==(time_t)(-1)) || 
         (((int)(finishTime - status->finishTime)) < 0))
                                     finishTime=status->finishTime;
    if(status->estTimeToStart!=-1) 
      if((estTimeToStart==-1) || (estTimeToStart < status->estTimeToStart))
                                     estTimeToStart=status->estTimeToStart;
    if(!(status->errorMessage.empty())) {
      if(!(errorMessage.empty())) errorMessage+="\n";
      errorMessage+=status->errorMessage;
    };
    if(status->retryDeltaTime!=-1)
      if((retryDeltaTime==-1) || (retryDeltaTime > status->retryDeltaTime)) 
                                     retryDeltaTime=status->retryDeltaTime;
  };
  if(state.empty()) {
    // try to generate state based on file states





    state="Failed"; // some error
  };
  if(estTimeToStart < 0) estTimeToStart=0;
  if(retryDeltaTime < 0) retryDeltaTime=0;
  req_stat->state=soap_strdup(soap,state.c_str());
  req_stat->retryDeltaTime=retryDeltaTime;
  if(submitTime != (time_t)(-1)) {
    if(req_stat->submitTime=(time_t*)soap_malloc(soap,sizeof(time_t))) {
      (*(req_stat->submitTime))=submitTime;
    };
  };
  if(startTime != (time_t)(-1)) {
    if(req_stat->startTime=(time_t*)soap_malloc(soap,sizeof(time_t))) {
      (*(req_stat->startTime))=startTime;
    };
  };
  if(finishTime != (time_t)(-1)) {
    if(req_stat->finishTime=(time_t*)soap_malloc(soap,sizeof(time_t))) {
      (*(req_stat->finishTime))=finishTime;
    };
  };
  if(!(errorMessage.empty())) {
    req_stat->errorMessage=soap_strdup(soap,errorMessage.c_str());
  };
  req_stat->fileStatuses=make_ArrayOfRequestFileStatus(soap,files);
  return req_stat;
}

static std::string strip_SURL_to_ID(const char* surl) {
  if(strncmp("srm://",surl,6) != 0) return std::string(surl);
  SRM_URL u(surl);
  std::string id = u.FileName();
  return id;
}

static bool check_ArrayOfstring(ArrayOfstring* array) {
  if(array == NULL) return false;
  if(array->__ptr == NULL) return false;
  if(array->__size <= 0) return false;
  return true;
}

// ------------------------------------------------------
// Methods involving creation of request
// ------------------------------------------------------

int SRMv1Meth__get(struct soap *sp,
    ArrayOfstring*                      SURLs,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(!check_ArrayOfstring(SURLs)) return SOAP_FAULT;
  if(!check_ArrayOfstring(Protocols)) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<SURLs->__size;n++) {
    std::string id = strip_SURL_to_ID(SURLs->__ptr[n]);
    fileids.push_back(id);
  };
  std::list<std::string> protocols;
  for(int n = 0;n<Protocols->__size;n++) {
    protocols.push_back(std::string(Protocols->__ptr[n]));
  };
  SRMRequest rr = it->requests->MakeRequest("get",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  if(rr.V1_get(protocols)) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

int SRMv1Meth__copy(struct soap *sp,
    ArrayOfstring*                      sourceSURLs,
    ArrayOfstring*                      destSURLs,
    ArrayOfboolean*                     undefined_arg,
  struct SRMv1Meth__copyResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;

  if(!check_ArrayOfstring(sourceSURLs)) return SOAP_FAULT;
  int files_n = sourceSURLs->__size;
  if(!check_ArrayOfstring(destSURLs)) return SOAP_FAULT;
  std::list<std::string> fileids;
  std::list<bool> fileTos;
  std::list<std::string> fileURLs;
  std::string thishost;
  int thisport = 0;
  {
    const char* u = base_url_by_type("gsi");
    if(!u) u=base_url_by_type("gssapi");
    URL u_(u);
    thishost=u_.Host();
    thisport=u_.Port();
  };
  for(int n = 0;n<files_n;n++) {
    if(sourceSURLs->__ptr[n] == NULL) continue;
    if(destSURLs->__ptr[n] == NULL) continue;
    if(strncmp("srm://",sourceSURLs->__ptr[n],6) == 0) {
      SRM_URL u(sourceSURLs->__ptr[n]);
      if((u.Host() == thishost) && (u.Port() == thisport)) {
        std::string id = u.FileName();
        fileids.push_back(id);
        fileTos.push_back(true);
        fileURLs.push_back(destSURLs->__ptr[n]);
        continue;
      };
    };
    if(strncmp("srm://",destSURLs->__ptr[n],6) == 0) {
      SRM_URL u(destSURLs->__ptr[n]);
      if((u.Host() == thishost) && (u.Port() == thisport)) {
        std::string id = u.FileName();
        fileids.push_back(id);
        fileTos.push_back(false);
        fileURLs.push_back(sourceSURLs->__ptr[n]);
        continue;
      };
    };
  };
  files_n=fileids.size();
  SRMRequest rr = it->requests->MakeRequest("copy",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  std::list<SRMFile>& files = (std::list<SRMFile>&)(rr->GetFiles());
  {
    int n = 0;
    std::list<SRMFile>::iterator f = files.begin();
    std::list<bool>::iterator fTo = fileTos.begin();
    std::list<std::string>::iterator fU = fileURLs.begin();
    for(;(f!=files.end()) && (fTo!=fileTos.end()) && (fU!=fileURLs.end());
                                   ++f,++fTo,++fU) {
      if(n >= files_n) break;
      SRMFileStatus* fstatus = new SRMFileStatus;
      if(fstatus != NULL) {
        if(*fTo) {
          fstatus->destFilename=(*fU);
        } else {
          fstatus->sourceFilename=(*fU);
        };
        f->Status(fstatus);
      };
      ++n;
    };
  };
  if(rr.V1_copy()) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_FAULT;
}

int SRMv1Meth__put(struct soap *sp,
    ArrayOfstring*                      Src_file_names,
    ArrayOfstring*                      Dest_file_names,
    ArrayOflong*                        sizes,
    ArrayOfboolean*                     wantPermanent,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__putResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(!check_ArrayOfstring(Src_file_names)) return SOAP_FAULT;
  int files_n = Src_file_names->__size;
  if(!check_ArrayOfstring(Dest_file_names)) return SOAP_FAULT;
  if((sizes == NULL) || 
     (sizes->__ptr == NULL) || 
     (sizes->__size != files_n)) return SOAP_FAULT;
  if((wantPermanent == NULL) || 
     (wantPermanent->__ptr == NULL) || 
     (wantPermanent->__size != files_n)) return SOAP_FAULT;
  if(!check_ArrayOfstring(Protocols)) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<Dest_file_names->__size;n++) {
    std::string id = strip_SURL_to_ID(Dest_file_names->__ptr[n]);
    fileids.push_back(id);
  };
  std::list<std::string> protocols;
  for(int n = 0;n<Protocols->__size;n++) {
    protocols.push_back(std::string(Protocols->__ptr[n]));
  };
  SRMRequest rr = it->requests->MakeRequest("put",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  std::list<SRMFile>& files = (std::list<SRMFile>&)(rr->GetFiles());
  int n = 0;
  for(std::list<SRMFile>::iterator f = files.begin();f!=files.end();++f) {
    if(n >= files_n) break;
    SRMFileMetaData* mdata = new SRMFileMetaData;
    if(mdata != NULL) {
      mdata->size=sizes->__ptr[n];
      mdata->isPermanent=wantPermanent->__ptr[n];
    };
    f->MetaData(mdata);
    SRMFileStatus* fstatus = new SRMFileStatus;
    if(fstatus != NULL) {
      fstatus->sourceFilename=Src_file_names->__ptr[n];
      fstatus->destFilename=Dest_file_names->__ptr[n];
    };
    f->Status(fstatus);
    ++n;
  };
  if(rr.V1_put(protocols)) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}


int SRMv1Meth__pin(struct soap *sp,
    ArrayOfstring*                      TURLs,
  struct SRMv1Meth__pinResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<TURLs->__size;n++) {
    std::string id = TURLs->__ptr[n];
    fileids.push_back(id); 
  };
  SRMRequest rr = it->requests->MakeRequest("pin",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  if(rr.V1_pin()) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

int SRMv1Meth__unPin(struct soap *sp,
    ArrayOfstring*                      TURLs,
    int                                 RequestId,
  struct SRMv1Meth__unPinResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  std::string requestid = tostring<int>(RequestId);
  SRMRequest rr = it->requests->GetRequest(requestid,it->c->identity_proxy());
  if(!rr) return SOAP_OK;
  rr.V1_unPin();
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

// ------------------------------------------------------
// Methods not propagated to backend SRM servers
// ------------------------------------------------------

int SRMv1Meth__ping(struct soap *sp,
  bool &_Result) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  _Result=true;
  return SOAP_OK;
}

int SRMv1Meth__ping(struct soap *sp,
  struct SRMv1Meth__pingResponse& r) {
  SRMv1Meth__ping(sp,r._Result);
}

// ------------------------------------------------------
// Methods which act on existing request
// ------------------------------------------------------

int SRMv1Meth__setFileStatus(struct soap *sp,
    int                                 RequestId,
    int                                 fileId,
    char*                               state,
  struct SRMv1Meth__setFileStatusResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  std::string requestid = tostring<int>(RequestId);
  std::string fileid = tostring<int>(fileId);
  SRMRequest rr = it->requests->GetRequest(requestid,it->c->identity_proxy());
  if(!rr) return SOAP_OK;
  //SRMFile* ff = (SRMFile*)(rr->GetFile(fileid));
  //if(!ff) return SOAP_OK;
  rr.V1_setFileStatus(fileid,std::string(state));
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  // Leave only requested file ?!?!?!
  if(req) {
    if((req->fileStatuses) &&
       (req->fileStatuses->__ptr) && (req->fileStatuses->__size > 0)) {
      for(int n=0;n<req->fileStatuses->__size;++n) {
        if(req->fileStatuses->__ptr[n]) {
          if(req->fileStatuses->__ptr[n]->fileId == fileId) {
            req->fileStatuses->__ptr[0]=req->fileStatuses->__ptr[n];
            req->fileStatuses->__size=1;
            break;
          };
        };
      };
      if(req->fileStatuses->__size != 1) req->fileStatuses->__size=0;
    };
  };
  r._Result=req;
  return SOAP_OK;
}

int SRMv1Meth__getRequestStatus(struct soap *sp,
    int                                 RequestId,
  struct SRMv1Meth__getRequestStatusResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  std::string requestid = tostring<int>(RequestId);
  SRMRequest rr = it->requests->GetRequest(requestid,it->c->identity_proxy());
  if(!rr) return SOAP_OK;
  rr.V1_getRequestStatus();
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

// ------------------------------------------------------
// Simple methods
// ------------------------------------------------------

int SRMv1Meth__mkPermanent(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__mkPermanentResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(!check_ArrayOfstring(SURLs)) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<SURLs->__size;n++) {
    std::string id = strip_SURL_to_ID(SURLs->__ptr[n]);
    fileids.push_back(id);
  };
  SRMRequest rr = it->requests->MakeRequest("mkPermanent",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  if(rr.V1_mkPermanent()) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

int SRMv1Meth__getProtocols(struct soap *sp,
  struct SRMv1Meth__getProtocolsResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  r._Result=NULL;
  std::list<std::string> fileids;
  SRMRequest rr = it->requests->MakeRequest("getProtocols",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  std::list<std::string> protocols;
  if(rr.V1_getProtocols(protocols)) {
    r._Result=soap_new_ArrayOfstring(sp,-1);
    if(r._Result) {
      r._Result->__size=0;
      if(protocols.size() > 0) {
        r._Result->__ptr=(char**)soap_malloc(sp,sizeof(char*)*protocols.size());
        if(r._Result->__ptr) {
          int n = 0;
          for(std::list<std::string>::iterator p = protocols.begin();
                                                 p!=protocols.end();++p) {
	        r._Result->__ptr[n++]=strdup(p->c_str());
          };
        };
      };
    };
  };
  return SOAP_OK;
}

int SRMv1Meth__advisoryDelete(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__advisoryDeleteResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<SURLs->__size;n++) {
    std::string id = strip_SURL_to_ID(SURLs->__ptr[n]);
    fileids.push_back(id); 
  };
  SRMRequest rr = it->requests->MakeRequest("advisoryDelete",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  rr.V1_advisoryDelete();
  return SOAP_OK;
}


int SRMv1Meth__getFileMetaData(struct soap *sp,
    ArrayOfstring*                      SURLs,
  struct SRMv1Meth__getFileMetaDataResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(it->requests == NULL) return SOAP_FAULT;
  r._Result=NULL;
  if(SURLs == NULL) return SOAP_OK;
  if(SURLs->__ptr == NULL) return SOAP_OK;
  if(SURLs->__size == 0) return SOAP_OK;
  std::list<std::string> fileids;
  for(int n = 0;n<SURLs->__size;n++) {
    std::string id = strip_SURL_to_ID(SURLs->__ptr[n]);
    fileids.push_back(id); 
  };
  SRMRequest rr = it->requests->MakeRequest("getFileMetaData",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  if(rr.V1_getFileMetaData()) {
std::cerr<<"V1_getFileMetaData - success"<<std::endl;
    r._Result=make_ArrayOfFileMetaData(sp,rr->GetFiles());
std::cerr<<"V1_getFileMetaData - Result: "<<r._Result->__size<<std::endl;
  } else {
std::cerr<<"V1_getFileMetaData - failure"<<std::endl;
    r._Result=soap_new_ArrayOfFileMetaData(sp,-1);
    r._Result->__size=0;
    r._Result->__ptr=NULL;
  };
  return SOAP_OK;
}

int SRMv1Meth__getEstGetTime(struct soap *sp,
    ArrayOfstring*                      SURLs,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getEstGetTimeResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(!check_ArrayOfstring(SURLs)) return SOAP_FAULT;
  if(!check_ArrayOfstring(Protocols)) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<SURLs->__size;n++) {
    std::string id = strip_SURL_to_ID(SURLs->__ptr[n]);
    fileids.push_back(id);
  };
  std::list<std::string> protocols;
  for(int n = 0;n<Protocols->__size;n++) {
    protocols.push_back(std::string(Protocols->__ptr[n]));
  };
  SRMRequest rr = it->requests->MakeRequest("getEstGetTime",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  if(rr.V1_getEstGetTime(protocols)) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

int SRMv1Meth__getEstPutTime(struct soap *sp,
    ArrayOfstring*                      Src_file_names,
    ArrayOfstring*                      Dest_file_names,
    ArrayOflong*                        sizes,
    ArrayOfboolean*                     wantPermanent,
    ArrayOfstring*                      Protocols,
  struct SRMv1Meth__getEstPutTimeResponse& r) {
  HTTP_SRM_Proxy* it = (HTTP_SRM_Proxy*)(sp->user);
  if(it == NULL) return SOAP_FAULT;
  if(!check_ArrayOfstring(Src_file_names)) return SOAP_FAULT;
  int files_n = Src_file_names->__size;
  if(!check_ArrayOfstring(Dest_file_names)) return SOAP_FAULT;
  if((sizes == NULL) || 
     (sizes->__ptr == NULL) || 
     (sizes->__size != files_n)) return SOAP_FAULT;
  if((wantPermanent == NULL) || 
     (wantPermanent->__ptr == NULL) || 
     (wantPermanent->__size != files_n)) return SOAP_FAULT;
  if(!check_ArrayOfstring(Protocols)) return SOAP_FAULT;
  std::list<std::string> fileids;
  for(int n = 0;n<Dest_file_names->__size;n++) {
    std::string id = strip_SURL_to_ID(Dest_file_names->__ptr[n]);
    fileids.push_back(id);
  };
  std::list<std::string> protocols;
  for(int n = 0;n<Protocols->__size;n++) {
    protocols.push_back(std::string(Protocols->__ptr[n]));
  };
  SRMRequest rr = it->requests->MakeRequest("getEstPutTime",fileids,true,it->c->identity_proxy());
  if(!rr) return SOAP_FAULT;
  std::list<SRMFile>& files = (std::list<SRMFile>&)(rr->GetFiles());
  int n = 0;
  for(std::list<SRMFile>::iterator f = files.begin();f!=files.end();++f) {
    if(n >= files_n) break;
    SRMFileMetaData* mdata = new SRMFileMetaData;
    if(mdata != NULL) {
      mdata->size=sizes->__ptr[n];
      mdata->isPermanent=wantPermanent->__ptr[n];
    };
    f->MetaData(mdata);
    SRMFileStatus* fstatus = new SRMFileStatus;
    if(fstatus != NULL) {
      fstatus->sourceFilename=Src_file_names->__ptr[n];
      fstatus->destFilename=Dest_file_names->__ptr[n];
    };
    f->Status(fstatus);
    ++n;
  };
  if(rr.V1_getEstPutTime(protocols)) {
    it->requests->RememberRequest(rr);
  };
  // make response
  SRMv1Type__RequestStatus* req = make_SRMv1Type__RequestStatus(sp,rr);
  r._Result=req;
  return SOAP_OK;
}

