#include "srm_file_metadata.h"

#include "srm1_soapH.h"
#include "srm2_soapH.h"

#include "srm_file_metadata.h"

#include "srm_file_status.h"


SRMFileStatus::SRMFileStatus(void):estSecondsToStart(0),queueOrder(0) {
}

SRMFileStatus::SRMFileStatus(const SRMv1Type__RequestFileStatus* status):estSecondsToStart(0),queueOrder(0) {
  if(status == NULL) return;
  if(status->state) state=status->state;
  if(status->TURL) TURL=status->TURL;
  estSecondsToStart=status->estSecondsToStart;
  if(status->sourceFilename) sourceFilename=status->sourceFilename;
  if(status->destFilename) destFilename=status->destFilename;
  queueOrder=status->queueOrder;
  // int fileId
}

SRMv1Type__RequestFileStatus* SRMFileStatus::V1(struct soap* soap,int fileid,const SRMFileMetaData* metadata) const {
  if(soap == NULL) return NULL;
  SRMv1Type__RequestFileStatus* status = NULL;
  status=soap_new_SRMv1Type__RequestFileStatus(soap,-1);
  if(status == NULL) return NULL;
  status->soap_default(soap);
  SRMv1Type__FileMetaData* metadata_ = NULL;
  if(metadata) metadata_=metadata->V1(soap);
  if(metadata_) {
    status->SURL=metadata_->SURL;
    status->size=metadata_->size;
    status->owner=metadata_->owner;
    status->group=metadata_->owner;
    status->permMode=metadata_->permMode;
    status->checksumType=metadata_->checksumType;
    status->checksumValue=metadata_->checksumValue;
    status->isPinned=metadata_->isPinned;
    status->isPermanent=metadata_->isPermanent;
    status->isCached=metadata_->isCached;
    struct soap *soap;  /* transient */
    // (*((SRMv1Type__FileMetaData*)status))=(*metadata_);
  };
  if(!state.empty()) {
    status->state=soap_strdup(soap,state.c_str());
  } else {
    status->state="Failed"; // ???
  };
  if(!TURL.empty()) status->TURL=soap_strdup(soap,TURL.c_str());
  status->estSecondsToStart=estSecondsToStart;
  if(!sourceFilename.empty()) status->sourceFilename=soap_strdup(soap,sourceFilename.c_str());
  if(!destFilename.empty()) status->destFilename=soap_strdup(soap,destFilename.c_str());
  status->queueOrder=queueOrder;
  status->fileId=fileid;
  return status;
}

