#ifndef __ARC_SRM_REMOTE_REQUEST_H__
#define __ARC_SRM_REMOTE_REQUEST_H__

#include <string>
#include <list>
#include <stdsoap2.h>

#include "srm_endpoint.h"

class HTTP_ClientSOAP;
class SRMRequestStatus;
class SRMFile;
class SRMRequestStatus;
class ArrayOfstring;

class SRMv1Type__RequestStatus;

class SRMRemoteRequest {
 friend class SRMRequests;
 friend class SRMLocalRequest;
 private:
  std::string id; // ID of request on remote server
  // char *type
  SRMEndpoint* endpoint;
  SRMRequestStatus* status;
  HTTP_ClientSOAP* c;
  std::string cred;
  struct soap soap;
  bool connect(void);
  ArrayOfstring* MakeSURLs(struct soap* soap,const std::list<SRMFile*>& files);
  ArrayOfstring* MakeTURLs(struct soap* soap,const std::list<SRMFile*>& files);
  ArrayOfstring* MakeProtocols(struct soap* soap,const std::list<std::string>& protocols);
  bool FindFiles(std::list<SRMFile*>& files);
  enum StatusOptions {
    Replace = 0,
    NotReplace = 1,
    ReplaceQuicker = 2
  };
  bool SetStatus(SRMv1Type__RequestStatus* s,std::list<SRMFile*>& files,StatusOptions options = Replace);
  bool SetStatus(SRMv1Type__RequestStatus* s,SRMFile& file);
 public:
  SRMRemoteRequest(SRMEndpoint* endpoint,const char* credentials = NULL);
  SRMRemoteRequest(const SRMRemoteRequest& r);
  ~SRMRemoteRequest(void);
  SRMRemoteRequest& operator=(const SRMRemoteRequest& r);
  const SRMRequestStatus* GetStatus(void) const { return status; };
  // SRM Methods
  bool V1_get(std::list<SRMFile*>& files,const std::list<std::string>& protocols);
  bool V1_copy(std::list<SRMFile*>& files);
  void V1_ping(void);
  bool V1_pin(std::list<SRMFile*>& files);
  bool V1_unPin(std::list<SRMFile*>& files);
  bool V1_mkPermanent(std::list<SRMFile*>& files);
  bool V1_getEstGetTime(std::list<SRMFile*>& files,const std::list<std::string>& protocols);
  bool V1_getEstPutTime(std::list<SRMFile*>& files,const std::list<std::string>& protocols);
  bool V1_put(std::list<SRMFile*>& files,const std::list<std::string>& protocols);
  bool V1_setFileStatus(SRMFile& file,const std::string& state);
  bool V1_getRequestStatus(std::list<SRMFile*>& files);
  bool V1_getProtocols(std::list<std::string>& protocols);
  bool V1_advisoryDelete(std::list<SRMFile*>& files);
  bool V1_getFileMetaData(std::list<SRMFile*>& files);
};

class SRMRequestStatus {
 friend class SRMRemoteRequest;
 public:
  std::string state;
  time_t submitTime;
  time_t startTime;
  time_t finishTime;
  int estTimeToStart; /* required element of type xsd:int */
  // class ArrayOfRequestFileStatus *fileStatuses;
  std::string errorMessage;
  int retryDeltaTime;
  SRMRequestStatus(void):submitTime(-1),startTime(-1),finishTime(-1),estTimeToStart(-1),retryDeltaTime(-1) { };
  ~SRMRequestStatus(void) { };
};

#endif
