#include "../../std.h"

#include "../../auth/identity_dn.h"
#include "../../auth/identity_voms.h"

#include "identity_fireman.h"


Identity::Item* IdentityFireman::add(const Item* t) {
  if(items_.size() > 0) return NULL;
  return Identity::add(t);
}

Identity::Item* IdentityFireman::use(Item* t) {
  if(items_.size() > 0) return NULL;
  return Identity::use(t);
}


IdentityFireman::IdentityFireman(const Identity& t):Identity(t) { }

IdentityFireman::~IdentityFireman(void) { }

IdentityFireman::IdentityFireman(void) { }

Identity* IdentityFireman::duplicate(void) const {
  return new IdentityFireman(*this);
}

std::string IdentityFireman::get(void) {
  if(items_.size() <= 0) return std::string("");
  Identity::Item* i = *(items_.begin());
  if(!i) return std::string("");
  return i->str();
}

