#include "../../std.h"

#include "permission_fireman.h"

PermissionFireman::PermissionFireman(void) {
  set(object,create,deny);
  set(object,read,deny);
  set(object,write,deny);
  set(object,extend,deny);
  set(object,reduce,deny);
  set(object,remove,deny);
  set(object,info,deny);
  set(metadata,create,deny);
  set(metadata,read,deny);
  set(metadata,write,deny);
  set(metadata,extend,deny);
  set(metadata,reduce,deny);
  set(metadata,remove,deny);
  set(metadata,info,deny);
  set(permissions,create,deny);
  set(permissions,read,deny);
  set(permissions,write,deny);
  set(permissions,extend,deny);
  set(permissions,reduce,deny);
  set(permissions,remove,deny);
  set(permissions,info,deny);
}

PermissionFireman::PermissionFireman(const Permission& p):Permission(p) {
}

PermissionFireman::~PermissionFireman(void) {
}

Permission* PermissionFireman::duplicate(void) const {
  return new PermissionFireman(*this);
}

bool PermissionFireman::allowPermission(void) {
  return get(permissions,read,allow);
}

bool PermissionFireman::allowRemove(void) {
  return get(object,remove,allow); 
}

bool PermissionFireman::allowRead(void) {
  return get(object,read,allow); 
}

bool PermissionFireman::allowWrite(void) {
  return get(object,write,allow) || 
         get(object,extend,allow) ||
         get(object,reduce,allow);
}

bool PermissionFireman::allowList(void) {
  return get(object,info,allow);
}

bool PermissionFireman::allowExecute(void) {
  return false;
}

bool PermissionFireman::allowGetMetadata(void) {
  return get(metadata,read,allow);
}

bool PermissionFireman::allowSetMetadata(void) {
  return get(metadata,write,allow);
}

void PermissionFireman::allowPermission(bool v) {
  if(v) {
    set(permissions,create,allow);
    set(permissions,read,allow);
    set(permissions,write,allow);
    set(permissions,extend,allow);
    set(permissions,reduce,allow);
    set(permissions,remove,allow);
    set(permissions,info,allow);
  } else {
    set(permissions,create,deny);
    set(permissions,read,deny);
    set(permissions,write,deny);
    set(permissions,extend,deny);
    set(permissions,reduce,deny);
    set(permissions,remove,deny);
    set(permissions,info,deny);
  };
}

void PermissionFireman::allowRemove(bool v) {
  if(v) {
    set(object,remove,allow);
    set(object,create,allow);
  } else {
    set(object,remove,deny);
    set(object,create,deny);
  };
}

void PermissionFireman::allowRead(bool v) {
  if(v) {
    set(object,read,allow);
  } else {
    set(object,read,deny);
  };
}

void PermissionFireman::allowWrite(bool v) {
  if(v) {
    set(object,write,allow);
    set(object,extend,allow);
    set(object,reduce,allow);
  } else {
    set(object,write,deny);
    set(object,extend,deny);
    set(object,reduce,deny);
  };
}

void PermissionFireman::allowList(bool v) {
  if(v) {
    set(object,info,allow);
  } else {
    set(object,info,deny);
  };
}

void PermissionFireman::allowExecute(bool v) {
  if(v) {
  } else {
  };
}

void PermissionFireman::allowGetMetadata(bool v) {
  if(v) {
    set(metadata,read,allow);
    set(metadata,info,allow);
  } else {
    set(metadata,read,deny);
    set(metadata,info,deny);
  };
}

void PermissionFireman::allowSetMetadata(bool v) {
  if(v) {
    set(metadata,create,allow);
    set(metadata,write,allow);
    set(metadata,extend,allow);
    set(metadata,reduce,allow);
    set(metadata,remove,allow);
  } else {
    set(metadata,create,deny);
    set(metadata,write,deny);
    set(metadata,extend,deny);
    set(metadata,reduce,deny);
    set(metadata,remove,deny);
  };
}


