#include "../httpsd.h"
#include "../server/service_soap.h"

#include <mysql.h>

class nl__jobinfo;
class array_jobinfo;
class nl2__addRequest;
class nl2__addResponse;
class nl2__getRequest;
class nl2__getResponse;

class HTTP_Logger: public HTTP_ServiceAdv {
 friend int nl__add(struct soap*,nl__jobinfo*,int &);
 friend int nl__get(struct soap*,char*,ULONG64,array_jobinfo&);
 friend int __nl2__add(struct soap*,nl2__addRequest*,nl2__addResponse*);
 friend int __nl2__get(struct soap*,nl2__getRequest*,nl2__getResponse*);

 private:
  bool acl_read;
  bool acl_write;
  bool acl_query;

  MYSQL sql;

 public:
  HTTP_Logger(HTTP_Connector *c,bool acl_read,bool acl_write,bool acl_query,const char* host,const char* database,const char* user = NULL,const char* password = NULL);
  virtual ~HTTP_Logger(void);
  virtual HTTP_Error get(const char* uri,int &keep_alive);
  virtual HTTP_Error put(const char* uri,int &keep_alive);
  virtual HTTP_Error post(const char* uri,int &keep_alive);
  virtual void soap_methods(void);
};

HTTP_Service* logger_service_creator(HTTP_Connector& c,const char* uri,void* arg);
bool logger_service_configurator(std::istream& f,const char* uri,HTTP_Service_Properties &prop);

