/* logger_soapServer.cpp
   Generated by gSOAP 2.7.8a from logger_soap.h
   Copyright (C) 2000-2006, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/
#include "logger_soapH.h"

SOAP_SOURCE_STAMP("@(#) logger_soapServer.cpp ver 2.7.8a 2009-04-06 10:51:34 GMT")


SOAP_FMAC5 int SOAP_FMAC6 logger_soap_serve(struct soap *soap)
{
#ifndef WITH_FASTCGI
	unsigned int k = soap->max_keep_alive;
#endif

	do
	{
#ifdef WITH_FASTCGI
		if (FCGI_Accept() < 0)
		{
			soap->error = SOAP_EOF;
			return soap_send_fault(soap);
		}
#endif

		soap_begin(soap);

#ifndef WITH_FASTCGI
		if (soap->max_keep_alive > 0 && !--k)
			soap->keep_alive = 0;
#endif

		if (soap_begin_recv(soap))
		{	if (soap->error < SOAP_STOP)
			{
#ifdef WITH_FASTCGI
				soap_send_fault(soap);
#else 
				return soap_send_fault(soap);
#endif
			}
			soap_closesock(soap);

			continue;
		}

		if (soap_envelope_begin_in(soap)
		 || soap_recv_header(soap)
		 || soap_body_begin_in(soap)
		 || logger_soap_serve_request(soap)
		 || (soap->fserveloop && soap->fserveloop(soap)))
		{
#ifdef WITH_FASTCGI
			soap_send_fault(soap);
#else
			return soap_send_fault(soap);
#endif
		}

#ifdef WITH_FASTCGI
	} while (1);
#else
	} while (soap->keep_alive);
#endif
	return SOAP_OK;
}

#ifndef WITH_NOSERVEREQUEST
SOAP_FMAC5 int SOAP_FMAC6 logger_soap_serve_request(struct soap *soap)
{
	soap_peek_element(soap);
	if (!soap_match_tag(soap, soap->tag, "nl:add"))
		return soap_serve_nl__add(soap);
	if (!soap_match_tag(soap, soap->tag, "nl:get"))
		return soap_serve_nl__get(soap);
	return soap->error = SOAP_NO_METHOD;
}
#endif

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_nl__add(struct soap *soap)
{	struct nl__add soap_tmp_nl__add;
	struct nl__addResponse soap_tmp_nl__addResponse;
	soap_default_nl__addResponse(soap, &soap_tmp_nl__addResponse);
	soap_default_nl__add(soap, &soap_tmp_nl__add);
	soap->encodingStyle = NULL;
	if (!soap_get_nl__add(soap, &soap_tmp_nl__add, "nl:add", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = nl__add(soap, soap_tmp_nl__add.i, soap_tmp_nl__addResponse.r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	soap_serialize_nl__addResponse(soap, &soap_tmp_nl__addResponse);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || soap_put_nl__addResponse(soap, &soap_tmp_nl__addResponse, "nl:addResponse", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || soap_put_nl__addResponse(soap, &soap_tmp_nl__addResponse, "nl:addResponse", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

SOAP_FMAC5 int SOAP_FMAC6 soap_serve_nl__get(struct soap *soap)
{	struct nl__get soap_tmp_nl__get;
	array_jobinfo r;
	r.soap_default(soap);
	soap_default_nl__get(soap, &soap_tmp_nl__get);
	soap->encodingStyle = NULL;
	if (!soap_get_nl__get(soap, &soap_tmp_nl__get, "nl:get", NULL))
		return soap->error;
	if (soap_body_end_in(soap)
	 || soap_envelope_end_in(soap)
	 || soap_end_recv(soap))
		return soap->error;
	soap->error = nl__get(soap, soap_tmp_nl__get.query, soap_tmp_nl__get.offset, r);
	if (soap->error)
		return soap->error;
	soap_serializeheader(soap);
	r.soap_serialize(soap);
	if (soap_begin_count(soap))
		return soap->error;
	if (soap->mode & SOAP_IO_LENGTH)
	{	if (soap_envelope_begin_out(soap)
		 || soap_putheader(soap)
		 || soap_body_begin_out(soap)
		 || r.soap_put(soap, "array-jobinfo", "")
		 || soap_body_end_out(soap)
		 || soap_envelope_end_out(soap))
			 return soap->error;
	};
	if (soap_end_count(soap)
	 || soap_response(soap, SOAP_OK)
	 || soap_envelope_begin_out(soap)
	 || soap_putheader(soap)
	 || soap_body_begin_out(soap)
	 || r.soap_put(soap, "array-jobinfo", "")
	 || soap_body_end_out(soap)
	 || soap_envelope_end_out(soap)
	 || soap_end_send(soap))
		return soap->error;
	return soap_closesock(soap);
}

/* End of logger_soapServer.cpp */
